/*  BEGIN software license
 *
 *  msXpertSuite - mass spectrometry software suite
 *  -----------------------------------------------
 *  Copyright(C) 2009, 2017 Filippo Rusconi
 *
 *  http://www.msxpertsuite.org
 *
 *  This file is part of the msXpertSuite project.
 *
 *  The msXpertSuite project is the successor of the massXpert project. This
 *  project now includes various independent modules:
 *  
 *  - massXpert, model polymer chemistries and simulate mass spectrometric data;
 *  - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * END software license
 */



/////////////////////// Qt includes
#include <QDebug>
#include <QScriptEngine>


/////////////////////// Local includes
#include <libmass/DataPointJsPrototype.hpp>
#include <libmass/DataPoint.hpp>

Q_DECLARE_METATYPE(msXpSlibmass::DataPoint*);


namespace msXpSlibmass
{


	DataPointJsPrototype::DataPointJsPrototype(QObject *parent)
		: QObject(parent)
	{
	}


	DataPointJsPrototype::~DataPointJsPrototype()
	{
	}


	DataPoint *
		DataPointJsPrototype::thisDataPoint() const
		{
			DataPoint *dataPoint = qscriptvalue_cast<DataPoint*>(thisObject().data());

			if(dataPoint == Q_NULLPTR)
				qFatal("Fatal error at %s@%d -- %s. "
						"thisDataPoint() would return Q_NULLPTR."
						"Program aborted.",
						__FILE__, __LINE__, __FUNCTION__);

			return dataPoint;
		}


	bool 
		DataPointJsPrototype::initialize(const QString &xyLine)
		{
			return thisDataPoint()->initialize(xyLine);
		}


	void 
		DataPointJsPrototype::initialize(double key, double value)
		{
			return thisDataPoint()->initialize(key, value);
		}


	bool 
		DataPointJsPrototype::isValid() const
		{
			return thisDataPoint()->isValid();
		}


	QScriptValue 
		DataPointJsPrototype::valueOf() const
		{
			return thisObject().data();
		}


} // namespace msXpSlibmass
