<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [BrowserContext](./puppeteer.browsercontext.md) &gt; [waitForTarget](./puppeteer.browsercontext.waitfortarget.md)

## BrowserContext.waitForTarget() method

This searches for a target in this specific browser context.

<b>Signature:</b>

```typescript
waitForTarget(predicate: (x: Target) => boolean, options?: {
        timeout?: number;
    }): Promise<Target>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  predicate | (x: [Target](./puppeteer.target.md)) =&gt; boolean | A function to be run for every target |
|  options | { timeout?: number; } | An object of options. Accepts a timout, which is the maximum wait time in milliseconds. Pass <code>0</code> to disable the timeout. Defaults to 30 seconds. |

<b>Returns:</b>

Promise&lt;[Target](./puppeteer.target.md)&gt;

Promise which resolves to the first target found that matches the `predicate` function.

## Example

An example of finding a target for a page opened via `window.open`:

```js
await page.evaluate(() => window.open('https://www.example.com/'));
const newWindowTarget = await browserContext.waitForTarget(target => target.url() === 'https://www.example.com/');

```

