/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.translators;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.BSEProperties;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.translators.AbstractBasisSetXmlToText;

public class BasisXmlToMolcasInput
extends AbstractBasisSetXmlToText {
    @Override
    public String convert(String data, Vector elementList, boolean optimize) throws IOException, FormatException {
        optimize = false;
        this.enableSplitSP();
        return this.readBasisSet(data, elementList, optimize);
    }

    @Override
    protected void addHeader(StringBuffer output, Element root) throws FormatException {
        String title = root.getChildText("title", BSEProperties.mDcNs);
        output.append("!\n! BASIS SET = " + title + "\n!\n");
    }

    @Override
    protected void addFooter(StringBuffer output) throws FormatException {
    }

    @Override
    protected void addElementDescription(StringBuffer output, String element, Element contractions) {
        String elementName = this.mPertable.name(this.mPertable.atomicNumber(element));
        List descriptionList = contractions.getChildren("description", BSEProperties.mDcNs);
        for (Element description : descriptionList) {
            output.append("* " + elementName.toUpperCase() + "       " + description.getValue() + "\n");
        }
        output.append(" Basis set\n");
        output.append(" " + elementName.toUpperCase() + "    / inline\n");
        int atomicNumber = this.mPertable.atomicNumber(element);
        output.append("          " + atomicNumber + ".   ");
        Element description_1 = contractions.getChild("description", BSEProperties.mDcNs);
        String descr = description_1.getValue();
        int startindex = descr.lastIndexOf(40) + 1;
        int endindex = descr.toLowerCase().lastIndexOf(41);
        if (startindex != -1 && endindex != -1) {
            String shells = descr.substring(startindex, endindex);
            int nShells = shells.split(",").length - 1;
            output.append(nShells);
        }
        output.append("\n");
    }

    @Override
    protected void readCmlMatrix(StringBuffer output, Vector matrices, String element, String shell) throws FormatException {
        output.append("* " + shell.toUpperCase() + "-type functions\n");
        Matrix associationMatrix = this.buildAssociationMatrix(matrices);
        int rows = associationMatrix.getNumRows();
        int columns = associationMatrix.getNumColumns();
        output.append("    " + rows + "    " + (columns - 1) + "\n");
        try {
            int i;
            for (i = 0; i < rows; ++i) {
                String value = this.formattedValue(associationMatrix.getValue(i, 0));
                output.append("        " + value + "\n");
            }
            for (i = 0; i < rows; ++i) {
                for (int j = 1; j < columns; ++j) {
                    String value = this.formattedValue(associationMatrix.getValue(i, j));
                    output.append(value);
                }
                output.append("\n");
            }
        }
        catch (IndexOutOfBoundsException ie) {
            throw new FormatException(ie.getMessage());
        }
    }
}

