/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.util.test;

import com.sourceforge.knecs.dsm.util.PedigreeUtils;
import com.sourceforge.knecs.dsm.util.Species;
import com.sourceforge.knecs.dsm.util.Xlink;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.NSProperty;
import java.util.Vector;

public class TestPedigreeUtils {
    public static void main(String[] args) {
        String XMLresult;
        String XMLresult2;
        Species.Tuple tup;
        System.out.println("PEDIGREE UTILS TESTS");
        System.out.println("Test of the makeRDFBag with 1 item");
        Vector<String> oneItem = new Vector<String>();
        oneItem.add("hydrogen");
        String RDFBagStr = PedigreeUtils.makeRDFBag(oneItem);
        for (int i = 0; i < oneItem.size(); ++i) {
            System.out.print("Vector element " + i + ": " + (String)oneItem.get(i) + "\n");
        }
        if (RDFBagStr != null) {
            System.out.println("Resulting RDF Bag String:\n" + RDFBagStr);
        } else {
            System.out.println("Test failed: No RDF String returned");
        }
        System.out.println("");
        System.out.println("Test of the makeRDFBag with 3 items");
        Vector<String> threeItems = new Vector<String>();
        threeItems.add("hydrogen");
        threeItems.add("nitrogen");
        threeItems.add("oxygen");
        RDFBagStr = PedigreeUtils.makeRDFBag(threeItems);
        for (int i = 0; i < threeItems.size(); ++i) {
            System.out.print("Vector element " + i + ": " + (String)threeItems.get(i) + "\n");
        }
        if (RDFBagStr != null) {
            System.out.println("Resulting RDF Bag String:\n" + RDFBagStr);
        } else {
            System.out.println("Test failed: No RDF String returned");
        }
        System.out.println("");
        System.out.println("Test of the makeXMLforHref with 4 String args");
        String role = "project";
        String type = "simple";
        String title = "CMCS Project";
        String href = "http://cmcs.ca.sandia.gov";
        String XMLString2 = PedigreeUtils.makeXMLforHref(role, type, title, href);
        if (XMLString2 != null) {
            System.out.println("role: " + role);
            System.out.println("title: " + title);
            System.out.println("type: " + type);
            System.out.println("href: " + href);
            System.out.println("Resulting XML Xlink String:\n" + XMLString2);
        } else {
            System.out.println("Test failed: No XML String returned");
        }
        System.out.println("");
        System.out.println("Test of the relative makeXMLforHref");
        href = "http://cmcs.ca.sandia.gov:8101/sam/first/second/third/";
        XMLString2 = PedigreeUtils.makeRelativeXMLforHref(role, type, title, href);
        if (XMLString2 != null) {
            System.out.println("role: " + role);
            System.out.println("title: " + title);
            System.out.println("type: " + type);
            System.out.println("href: " + href);
            System.out.println("Resulting Relative XML Xlink String:\n" + XMLString2);
        } else {
            System.out.println("Test failed: No XML String returned");
        }
        System.out.println("");
        System.out.println("Test of the makeXMLforHref with Xlink arg");
        Xlink xl = new Xlink(href, title, type, role);
        XMLString2 = PedigreeUtils.makeXMLforHref(xl);
        if (XMLString2 != null) {
            System.out.println("Resulting XML Xlink String:\n" + XMLString2);
        } else {
            System.out.println("Test failed: No XML String returned");
        }
        System.out.println("");
        System.out.println("Test of the makeXMLforSpeciesList with 3 species");
        System.out.println("First has 2 formulas, 2 names");
        System.out.println("Second has no formulas, 1 name");
        System.out.println("Third has 1 formula, no names");
        Species sp1 = new Species("2229-07-4");
        Species sp2 = new Species("2231-07-4");
        Species sp3 = new Species("2231-07-4");
        sp1.addFormulaToList("CH3", "");
        sp1.addFormulaToList("H3C", "GrossZSorted");
        sp1.addNameToList("methyl", "IUPAC");
        sp1.addNameToList("methyl radical", "");
        sp2.addNameToList("water", "");
        sp3.addFormulaToList("H2O", "");
        Vector<Species> speciesList = new Vector<Species>();
        speciesList.add(sp1);
        speciesList.add(sp2);
        speciesList.add(sp3);
        XMLString2 = PedigreeUtils.makeXMLforSpeciesList(speciesList);
        if (XMLString2 != null) {
            System.out.println("Resulting XML Species String:\n" + XMLString2);
        } else {
            System.out.println("Test failed: No XML Species String returned");
        }
        System.out.println("");
        System.out.println("Two tests of rdf:Bag parse");
        String bag1 = "<Bag xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><href xmlns=\"http://purl.oclc.org/NET/cmcs/schema/\" xlink:href=\"/slide/files/projects/grimech/description/hcn.xml\" xlink:role=\"Reference\" xlink:title=\"Literature Reference\" xlink:type=\"simple\"></href></li> </Bag>";
        String bag2 = "<Bag xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">oxygen</li><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">hydrogen</li></Bag>";
        Vector result1 = new Vector();
        try {
            PedigreeUtils.parseBag(bag1, result1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("Test #1: parse rdf:Bag with one Xlink item");
        System.out.println("Bag XML is \n" + bag1);
        if (result1 != null) {
            for (int i = 0; i < result1.size(); ++i) {
                System.out.print("item " + i + ": " + result1.get(i) + "\n");
            }
        } else {
            System.out.println("Bag parse failed");
        }
        System.out.println("");
        Vector result2 = new Vector();
        try {
            PedigreeUtils.parseBag(bag2, result2);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("Test #2: parse rdf:Bag with two simple items");
        System.out.println("Bag XML is \n" + bag2);
        if (result2 != null) {
            for (int i = 0; i < result2.size(); ++i) {
                System.out.print("item " + i + ": " + result2.get(i) + "\n");
            }
        } else {
            System.out.println("Bag parse failed");
        }
        System.out.println("");
        System.out.println("Test of Xlink parse");
        XMLString2 = "<href xmlns=\"http://purl.oclc.org/NET/cmcs/schema/\" xlink:href=\"/slide/files/projects/grimech/description/hcn.xml\" xlink:role=\"Reference\" xlink:title=\"Literature Reference\" xlink:type=\"simple\" xmlns:cmcs=\"http://purl.oclc.org/NET/cmcs/schema/\" xmlns:xlink=\"http://www.w3.org /1999/xlink\"></href>";
        Xlink newXl = new Xlink();
        try {
            PedigreeUtils.parseXlink(XMLString2, newXl);
        }
        catch (Exception e) {
            System.out.println("Exception on parseXlink: " + e.getMessage());
        }
        System.out.println("Xlink XML is \n" + XMLString2);
        if (newXl != null) {
            System.out.println("role: " + newXl.getRole());
            System.out.println("title: " + newXl.getTitle());
            System.out.println("type: " + newXl.getType());
            System.out.println("href: " + newXl.getHref());
        } else {
            System.out.println("Xlink parse failed");
        }
        System.out.println("");
        System.out.println("Tests of cmcs:speciesList parse");
        CMCSProperties properties = CMCSProperties.getCMCSProperties();
        String cmcsNamespace = properties.getProperty("cmcsns");
        String SpeciesListXML = "<speciesList xmlns=\"" + cmcsNamespace + "\">" + "<species xmlns=\"" + cmcsNamespace + "\">" + "<cas xmlns=\"" + cmcsNamespace + "\">0000-00-01</cas></species></speciesList>";
        System.out.println("Test 1: 1 species with only one cas number: XML is ");
        System.out.println(SpeciesListXML);
        Vector spResult = new Vector();
        try {
            PedigreeUtils.parseSpeciesList(SpeciesListXML, spResult);
        }
        catch (Exception e) {
            System.out.println("Exception on parseSpeciesList: " + e.getMessage());
        }
        if (spResult != null) {
            System.out.println("Number of species: " + spResult.size());
            for (int s = 0; s < spResult.size(); ++s) {
                Species sp = (Species)spResult.get(s);
                System.out.print("Species " + s + " with Cas: " + sp.getCas() + "\n");
                Vector formulas = sp.getFormulaList();
                System.out.print("Number of Formulas: " + formulas.size() + "\n");
                for (int f = 0; f < formulas.size(); ++f) {
                    String formula = new String();
                    String formType = new String();
                    Species.Tuple tup2 = sp.removeFirstFormulaInList();
                    formula = tup2.getValue();
                    formType = tup2.getType();
                    System.out.println("Formula " + f + ": " + formula + " Type: " + formType);
                }
                Vector names = sp.getNameList();
                System.out.print("Number of Names: " + names.size() + "\n");
                for (int n = 0; n < names.size(); ++n) {
                    String name = new String();
                    String nameType = new String();
                    tup = sp.removeFirstNameInList();
                    name = tup.getValue();
                    nameType = tup.getType();
                    System.out.println("Name " + n + ": " + name + " Type: " + nameType);
                }
                System.out.println("");
            }
        } else {
            System.out.println("SpeciesList parse failed");
        }
        System.out.println("");
        SpeciesListXML = "<speciesList xmlns=\"" + cmcsNamespace + "\">" + "<species xmlns=\"" + cmcsNamespace + "\">" + "<cas xmlns=\"" + cmcsNamespace + "\">0000-00-01</cas><formulaList xmlns=\"" + cmcsNamespace + "\">" + "<formula xmlns=\"" + cmcsNamespace + "\">H2O</formula></formulaList>" + "<nameList xmlns=\"" + cmcsNamespace + "\">" + "<name xmlns=\"" + cmcsNamespace + "\">water</name></nameList></species>" + "<species xmlns=\"" + cmcsNamespace + "\">" + "<cas xmlns=\"" + cmcsNamespace + "\">0000-00-02</cas><formulaList xmlns=\"" + cmcsNamespace + "\">" + "<formula xmlns=\"" + cmcsNamespace + "\" type=\"IUPAC\">CO2</formula>" + "<formula xmlns=\"" + cmcsNamespace + "\">NaCl</formula>" + "</formulaList>" + "<nameList xmlns=\"" + cmcsNamespace + "\">" + "<name xmlns=\"" + cmcsNamespace + "\" type=\"IUPAC\">carbon dioxide</name>" + "<name xmlns=\"" + cmcsNamespace + "\">salt</name>" + "</nameList></species></speciesList>";
        System.out.println("Test 2: 2 species: \n");
        System.out.println("1st: 1 formula and 1 name; 2nd: 2 formulas and 2 names\n");
        System.out.println("XML is ");
        System.out.println(SpeciesListXML);
        Vector spResult2 = new Vector();
        try {
            PedigreeUtils.parseSpeciesList(SpeciesListXML, spResult2);
        }
        catch (Exception e) {
            System.out.println("Exception on parseSpeciesList: " + e.getMessage());
        }
        if (spResult2 != null) {
            System.out.println("Number of species: " + spResult2.size());
            for (int s = 0; s < spResult2.size(); ++s) {
                Species sp = (Species)spResult2.get(s);
                System.out.print("Species " + s + " with Cas: " + sp.getCas() + "\n");
                Vector formulas = sp.getFormulaList();
                System.out.println("Formula vector size : " + formulas.size());
                for (int f = 0; f < formulas.size(); ++f) {
                    String formula = new String();
                    String formType = new String();
                    tup = sp.removeFirstFormulaInList();
                    formula = tup.getValue();
                    formType = tup.getType();
                    System.out.println("Formula " + f + ": " + formula + " Type: " + formType);
                }
                Vector names = sp.getNameList();
                System.out.println("Name vector size : " + names.size());
                for (int n = 0; n < names.size(); ++n) {
                    String name = new String();
                    String nameType = new String();
                    Species.Tuple tup3 = sp.removeFirstNameInList();
                    name = tup3.getValue();
                    nameType = tup3.getType();
                    System.out.println("Name " + n + ": " + name + " Type: " + nameType);
                }
                System.out.println("");
            }
        } else {
            System.out.println("SpeciesList parse failed");
        }
        System.out.println("");
        System.out.println("Test of supportsMany");
        System.out.println("All should be true except last one");
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        Vector bagProps = CMCSProperties.getPropertyAsNSPropertyVector("bagproperties");
        try {
            for (int i = 0; i < bagProps.size(); ++i) {
                NSProperty nsProp = (NSProperty)bagProps.get(i);
                System.out.println(PedigreeUtils.supportsMany(nsProp));
            }
            NSProperty nsProp = new NSProperty("http://testnamespace", "test");
            System.out.println(PedigreeUtils.supportsMany(nsProp));
        }
        catch (Exception e) {
            System.out.println("Exception on parseXlink: " + e.getMessage());
        }
        System.out.println("");
        System.out.println("6 Tests of ParseValue");
        System.out.println("Test #1: parse rdf:Bag with one Xlink item");
        Vector vec1 = new Vector();
        try {
            PedigreeUtils.parseValue(bag1, vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("Test #2: parse rdf:Bag with two simple items");
        vec1.clear();
        try {
            PedigreeUtils.parseValue(bag2, vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("Test #3: parse Xlink");
        vec1.clear();
        try {
            PedigreeUtils.parseValue(XMLString2, vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("Test #4: parse simple text");
        vec1.clear();
        try {
            PedigreeUtils.parseValue("Simple text should print out", vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("Test #5: parse rdf:Bag with 2 Xlinks");
        String XlinkString = "<Bag xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><href xmlns=\"http://purl.oclc.org/NET/cmcs/schema/\" xlink:href=\"/slide/files/projects/grimech/description/hcn.xml\" xlink:role=\"Reference\" xlink:title=\"Literature Reference\" xlink:type=\"simple\"></href></li><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><href xmlns=\"http://purl.oclc.org/NET/cmcs/schema/\" xlink:href=\"/slide/files/projects/grimech/description/hcn2.xml\" xlink:role=\"Reference 2\" xlink:title=\"Literature Reference 2\" xlink:type=\"simple\"></href></li></Bag>";
        vec1.clear();
        try {
            PedigreeUtils.parseValue(XlinkString, vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("Test #6: parse rdf:Bag with 1 Xlinks and 1 text");
        String XlinkString2 = "<Bag xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"><href xmlns=\"http://purl.oclc.org/NET/cmcs/schema/\" xlink:href=\"/slide/files/projects/grimech/description/hcn.xml\" xlink:role=\"Reference\" xlink:title=\"Literature Reference\" xlink:type=\"simple\"></href></li><li xmlns=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">Just text</li></Bag>";
        vec1.clear();
        try {
            PedigreeUtils.parseValue(XlinkString2, vec1);
        }
        catch (Exception e) {
            System.out.println("Exception on parseValue: " + e.getMessage());
        }
        if (vec1 == null) {
            System.out.println("Test parseValue failed: No vector");
        }
        for (int idx = 0; idx < vec1.size(); ++idx) {
            if (vec1.get(idx) instanceof Xlink) {
                xl = (Xlink)vec1.get(idx);
                System.out.println("item " + idx + " role: " + xl.getRole());
                System.out.println("item " + idx + " title: " + xl.getTitle());
                System.out.println("item " + idx + " type: " + xl.getType());
                System.out.println("item " + idx + " href: " + xl.getHref());
                continue;
            }
            String contents = (String)vec1.get(idx);
            System.out.println("item " + idx + " contents: " + contents);
        }
        System.out.println("");
        System.out.println("5 Tests of Make XML");
        NSProperty nsPropBag = (NSProperty)bagProps.get(0);
        NSProperty nsPropNoBag = new NSProperty("http://testnamespace", "test");
        System.out.println("Test #1: Should be a rdf:Bag of Strings");
        try {
            XMLresult2 = PedigreeUtils.makeXML(threeItems, nsPropBag);
            System.out.println(XMLresult2);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("");
        System.out.println("Test #2: Should NOT be a rdf:Bag -- should concatenate into a String");
        try {
            XMLresult2 = PedigreeUtils.makeXML(threeItems, nsPropNoBag);
            System.out.println(XMLresult2);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("");
        System.out.println("Test #3: Should be a single href; should NOT be a rdf:Bag");
        Vector<Xlink> xlinkVec = new Vector<Xlink>();
        xl = new Xlink("http://cmcs.ca.sandia.gov", "CMCS", "simple", "project");
        xlinkVec.add(xl);
        try {
            XMLresult = PedigreeUtils.makeXML(xlinkVec, nsPropNoBag);
            System.out.println(XMLresult);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("");
        System.out.println("Test #4: Should be a rdf:Bag of href");
        try {
            XMLresult = PedigreeUtils.makeXML(xlinkVec, nsPropBag);
            System.out.println(XMLresult);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("");
        System.out.println("Test #5: Should be a single string ");
        try {
            XMLresult = PedigreeUtils.makeXML(oneItem, nsPropNoBag);
            System.out.println(XMLresult);
        }
        catch (Exception e) {
            System.out.println("Exception on parseBag: " + e.getMessage());
        }
        System.out.println("");
    }
}

