/* ----------------------------------------------------------------- */
/*           The Japanese TTS System "Open JTalk"                    */
/*           developed by HTS Working Group                          */
/*           http://open-jtalk.sourceforge.net/                      */
/* ----------------------------------------------------------------- */
/*                                                                   */
/*  Copyright (c) 2008-2016  Nagoya Institute of Technology          */
/*                           Department of Computer Science          */
/*                                                                   */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/* - Redistributions of source code must retain the above copyright  */
/*   notice, this list of conditions and the following disclaimer.   */
/* - Redistributions in binary form must reproduce the above         */
/*   copyright notice, this list of conditions and the following     */
/*   disclaimer in the documentation and/or other materials provided */
/*   with the distribution.                                          */
/* - Neither the name of the HTS working group nor the names of its  */
/*   contributors may be used to endorse or promote products derived */
/*   from this software without specific prior written permission.   */
/*                                                                   */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND            */
/* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,       */
/* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF          */
/* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE          */
/* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS */
/* BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,          */
/* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,     */
/* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON */
/* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,   */
/* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY    */
/* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/* POSSIBILITY OF SUCH DAMAGE.                                       */
/* ----------------------------------------------------------------- */

#ifndef NJD2JPCOMMON_RULE_H
#define NJD2JPCOMMON_RULE_H

#ifdef __cplusplus
#define NJD2JPCOMMON_RULE_H_START extern "C" {
#define NJD2JPCOMMON_RULE_H_END   }
#else
#define NJD2JPCOMMON_RULE_H_START
#define NJD2JPCOMMON_RULE_H_END
#endif                          /* __CPLUSPLUS */

NJD2JPCOMMON_RULE_H_START;

static const char *njd2jpcommon_pos_list[] = {
   "\xa4\xbd\xa4\xce\xc2\xbe", "\xb4\xd6\xc5\xea", "*", "*", "\xa4\xbd\xa4\xce\xc2\xbe",
   "\xa5\xd5\xa5\xa3\xa5\xe9\xa1\xbc", "*", "*", "*", "\xb4\xb6\xc6\xb0\xbb\xec",
   "\xb4\xb6\xc6\xb0\xbb\xec", "*", "*", "*", "\xb4\xb6\xc6\xb0\xbb\xec",
   "\xb5\xad\xb9\xe6", "*", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xa5\xa2\xa5\xeb\xa5\xd5\xa5\xa1\xa5\xd9\xa5\xc3\xa5\xc8", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xb0\xec\xc8\xcc", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xb3\xe7\xb8\xcc\xb3\xab", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xb3\xe7\xb8\xcc\xca\xc4", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xb6\xe7\xc5\xc0", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xb6\xf5\xc7\xf2", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xbf\xf4", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb5\xad\xb9\xe6", "\xc6\xc9\xc5\xc0", "*", "*", "\xb5\xad\xb9\xe6",
   "\xb7\xc1\xcd\xc6\xbb\xec", "\xbc\xab\xce\xa9", "*", "*", "\xb7\xc1\xcd\xc6\xbb\xec",
   "\xb7\xc1\xcd\xc6\xbb\xec", "\xc0\xdc\xc8\xf8", "*", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xb7\xc1\xcd\xc6\xbb\xec\xc5\xaa",
   "\xb7\xc1\xcd\xc6\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "*", "*", "\xb7\xc1\xcd\xc6\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xb3\xca\xbd\xf5\xbb\xec", "\xb0\xec\xc8\xcc", "*", "\xbd\xf5\xbb\xec-\xb3\xca\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xb3\xca\xbd\xf5\xbb\xec", "\xb0\xfa\xcd\xd1", "*", "\xbd\xf5\xbb\xec-\xb3\xca\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xb3\xca\xbd\xf5\xbb\xec", "\xcf\xa2\xb8\xec", "*", "\xbd\xf5\xbb\xec-\xb3\xca\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xb7\xb8\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xb7\xb8\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xbd\xaa\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xbd\xaa\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xc0\xdc\xc2\xb3\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xc0\xdc\xc2\xb3\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xc6\xc3\xbc\xec", "*", "*", "\xbd\xf5\xbb\xec-\xa4\xbd\xa4\xce\xc2\xbe",
   "\xbd\xf5\xbb\xec", "\xc9\xfb\xbb\xec\xb2\xbd", "*", "*", "\xbd\xf5\xbb\xec-\xa4\xbd\xa4\xce\xc2\xbe",
   "\xbd\xf5\xbb\xec", "\xc9\xfb\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xc9\xfb\xbd\xf5\xbb\xec",
   "\xbd\xf5\xbb\xec", "\xc9\xfb\xbd\xf5\xbb\xec\xa1\xbf\xca\xc2\xce\xa9\xbd\xf5\xbb\xec\xa1\xbf\xbd\xaa\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xa4\xbd\xa4\xce\xc2\xbe",
   "\xbd\xf5\xbb\xec", "\xca\xc2\xce\xa9\xbd\xf5\xbb\xec", "*", "*", "\xbd\xf5\xbb\xec-\xa4\xbd\xa4\xce\xc2\xbe",
   "\xbd\xf5\xbb\xec", "\xcf\xa2\xc2\xce\xb2\xbd", "*", "*", "\xbd\xf5\xbb\xec-\xa4\xbd\xa4\xce\xc2\xbe",
   "\xbd\xf5\xc6\xb0\xbb\xec", "*", "*", "*", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc0\xdc\xc2\xb3\xbb\xec", "*", "*", "*", "\xc0\xdc\xc2\xb3\xbb\xec",
   "\xc0\xdc\xc6\xac\xbb\xec", "\xb7\xc1\xcd\xc6\xbb\xec\xc0\xdc\xc2\xb3", "*", "*", "\xc0\xdc\xc6\xac\xbc\xad",
   "\xc0\xdc\xc6\xac\xbb\xec", "\xbf\xf4\xc0\xdc\xc2\xb3", "*", "*", "\xc0\xdc\xc6\xac\xbc\xad",
   "\xc0\xdc\xc6\xac\xbb\xec", "\xc6\xb0\xbb\xec\xc0\xdc\xc2\xb3", "*", "*", "\xc0\xdc\xc6\xac\xbc\xad",
   "\xc0\xdc\xc6\xac\xbb\xec", "\xcc\xbe\xbb\xec\xc0\xdc\xc2\xb3", "*", "*", "\xc0\xdc\xc6\xac\xbc\xad",
   "\xc6\xb0\xbb\xec", "\xbc\xab\xce\xa9", "*", "*", "\xc6\xb0\xbb\xec",
   "\xc6\xb0\xbb\xec", "\xc0\xdc\xc8\xf8", "*", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xc6\xb0\xbb\xec\xc5\xaa",
   "\xc6\xb0\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "*", "*", "\xc6\xb0\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xc9\xfb\xbb\xec", "*", "*", "*", "\xc9\xfb\xbb\xec",
   "\xc9\xfb\xbb\xec", "\xb0\xec\xc8\xcc", "*", "*", "\xc9\xfb\xbb\xec",
   "\xc9\xfb\xbb\xec", "\xbd\xf5\xbb\xec\xce\xe0\xc0\xdc\xc2\xb3", "*", "*", "\xc9\xfb\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xa5\xb5\xca\xd1\xc0\xdc\xc2\xb3", "*", "*", "\xcc\xbe\xbb\xec-\xa5\xb5\xca\xd1\xc0\xdc\xc2\xb3",
   "\xcc\xbe\xbb\xec", "\xa5\xca\xa5\xa4\xb7\xc1\xcd\xc6\xbb\xec\xb8\xec\xb4\xb4", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb0\xec\xc8\xcc", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb0\xfa\xcd\xd1\xca\xb8\xbb\xfa\xce\xf3", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "*", "\xb7\xc1\xbe\xf5\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xb0\xec\xc8\xcc", "*", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xbf\xcd\xcc\xbe", "\xb0\xec\xc8\xcc", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xbf\xcd\xcc\xbe", "\xc0\xab", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xbf\xcd\xcc\xbe", "\xcc\xbe", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xc1\xc8\xbf\xa5", "*", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xc3\xcf\xb0\xe8", "\xb0\xec\xc8\xcc", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec", "\xc3\xcf\xb0\xe8", "\xb9\xf1", "\xcc\xbe\xbb\xec-\xb8\xc7\xcd\xad\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xbf\xf4", "*", "*", "\xcc\xbe\xbb\xec-\xbf\xf4\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc2\xb3\xbb\xec\xc5\xaa", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xa5\xb5\xca\xd1\xc0\xdc\xc2\xb3", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xb0\xec\xc8\xcc", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xb7\xc1\xbe\xf5\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xbd\xf5\xbf\xf4\xbb\xec", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xbd\xf5\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xbf\xcd\xcc\xbe", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xc3\xcf\xb0\xe8", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xc6\xc3\xbc\xec", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc0\xdc\xc8\xf8", "\xc9\xfb\xbb\xec\xb2\xc4\xc7\xbd", "*", "\xc0\xdc\xc8\xf8\xbc\xad-\xcc\xbe\xbb\xec\xc5\xaa",
   "\xcc\xbe\xbb\xec", "\xc2\xe5\xcc\xbe\xbb\xec", "\xb0\xec\xc8\xcc", "*", "\xc2\xe5\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc2\xe5\xcc\xbe\xbb\xec", "\xbd\xcc\xcc\xf3", "*", "\xc2\xe5\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc6\xb0\xbb\xec\xc8\xf3\xbc\xab\xce\xa9\xc5\xaa", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc6\xc3\xbc\xec", "\xbd\xf5\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcc\xbe\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "\xb0\xec\xc8\xcc", "*", "\xcc\xbe\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xcc\xbe\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "\xb7\xc1\xcd\xc6\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "\xcc\xbe\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xcc\xbe\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "\xbd\xf5\xc6\xb0\xbb\xec\xb8\xec\xb4\xb4", "*", "\xcc\xbe\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xcc\xbe\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "\xc9\xfb\xbb\xec\xb2\xc4\xc7\xbd", "*", "\xcc\xbe\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xcc\xbe\xbb\xec", "\xc8\xf3\xbc\xab\xce\xa9", "*", "*", "\xcc\xbe\xbb\xec-\xc8\xf3\xbc\xab\xce\xa9",
   "\xcc\xbe\xbb\xec", "\xc9\xfb\xbb\xec\xb2\xc4\xc7\xbd", "*", "*", "\xcc\xbe\xbb\xec-\xc9\xe1\xc4\xcc\xcc\xbe\xbb\xec",
   "\xcf\xa2\xc2\xce\xbb\xec", "*", "*", "*", "\xcf\xa2\xc2\xce\xbb\xec",
   NULL, NULL, NULL, NULL, NULL
};

static const char *njd2jpcommon_cform_list[] = {
   "*", "*",
   "\xa5\xac\xa5\xeb\xc0\xdc\xc2\xb3", "\xa4\xbd\xa4\xce\xc2\xbe",
   "\xb2\xbb\xca\xd8\xb4\xf0\xcb\xdc\xb7\xc1", "\xb4\xf0\xcb\xdc\xb7\xc1",
   "\xb2\xbe\xc4\xea\xb7\xc1", "\xb2\xbe\xc4\xea\xb7\xc1",
   "\xb2\xbe\xc4\xea\xbd\xcc\xcc\xf3\xa3\xb1", "\xb2\xbe\xc4\xea\xb7\xc1",
   "\xb2\xbe\xc4\xea\xbd\xcc\xcc\xf3\xa3\xb2", "\xb2\xbe\xc4\xea\xb7\xc1",
   "\xb4\xf0\xcb\xdc\xb7\xc1", "\xb4\xf0\xcb\xdc\xb7\xc1",
   "\xb4\xf0\xcb\xdc\xb7\xc1-\xc2\xa5\xb2\xbb\xca\xd8", "\xb4\xf0\xcb\xdc\xb7\xc1",
   "\xb8\xbd\xc2\xe5\xb4\xf0\xcb\xdc\xb7\xc1", "\xb4\xf0\xcb\xdc\xb7\xc1",
   "\xc2\xce\xb8\xc0\xc0\xdc\xc2\xb3", "\xcf\xa2\xc2\xce\xb7\xc1",
   "\xc2\xce\xb8\xc0\xc0\xdc\xc2\xb3\xc6\xc3\xbc\xec", "\xcf\xa2\xc2\xce\xb7\xc1",
   "\xc2\xce\xb8\xc0\xc0\xdc\xc2\xb3\xc6\xc3\xbc\xec\xa3\xb2", "\xcf\xa2\xc2\xce\xb7\xc1",
   "\xca\xb8\xb8\xec\xb4\xf0\xcb\xdc\xb7\xc1", "\xb4\xf0\xcb\xdc\xb7\xc1",
   "\xcc\xa4\xc1\xb3\xa5\xa6\xc0\xdc\xc2\xb3", "\xcc\xa4\xc1\xb3\xb7\xc1",
   "\xcc\xa4\xc1\xb3\xa5\xcc\xc0\xdc\xc2\xb3", "\xcc\xa4\xc1\xb3\xb7\xc1",
   "\xcc\xa4\xc1\xb3\xa5\xec\xa5\xeb\xc0\xdc\xc2\xb3", "\xcc\xa4\xc1\xb3\xb7\xc1",
   "\xcc\xa4\xc1\xb3\xb7\xc1", "\xcc\xa4\xc1\xb3\xb7\xc1",
   "\xcc\xa4\xc1\xb3\xc6\xc3\xbc\xec", "\xcc\xa4\xc1\xb3\xb7\xc1",
   "\xcc\xbf\xce\xe1\xa3\xe5", "\xcc\xbf\xce\xe1\xb7\xc1",
   "\xcc\xbf\xce\xe1\xa3\xe9", "\xcc\xbf\xce\xe1\xb7\xc1",
   "\xcc\xbf\xce\xe1\xa3\xf2\xa3\xef", "\xcc\xbf\xce\xe1\xb7\xc1",
   "\xcc\xbf\xce\xe1\xa3\xf9\xa3\xef", "\xcc\xbf\xce\xe1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xa5\xb4\xa5\xb6\xa5\xa4\xc0\xdc\xc2\xb3", "\xcf\xa2\xcd\xd1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xa5\xbf\xc0\xdc\xc2\xb3", "\xcf\xa2\xcd\xd1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xa5\xc6\xc0\xdc\xc2\xb3", "\xcf\xa2\xcd\xd1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xa5\xc7\xc0\xdc\xc2\xb3", "\xcf\xa2\xcd\xd1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xa5\xcb\xc0\xdc\xc2\xb3", "\xcf\xa2\xcd\xd1\xb7\xc1",
   "\xcf\xa2\xcd\xd1\xb7\xc1", "\xcf\xa2\xcd\xd1\xb7\xc1",
   NULL, NULL
};

static const char *njd2jpcommon_ctype_list[] = {
   "*", "*",
   "\xa5\xab\xca\xd1\xa1\xa6\xa5\xaf\xa5\xeb", "\xa5\xab\xb9\xd4\xca\xd1\xb3\xca",
   "\xa5\xab\xca\xd1\xa1\xa6\xcd\xe8\xa5\xeb", "\xa5\xab\xb9\xd4\xca\xd1\xb3\xca",
   "\xa5\xb5\xca\xd1\xa1\xa6\xa1\xdd\xa5\xb9\xa5\xeb", "\xa5\xb5\xb9\xd4\xca\xd1\xb3\xca",
   "\xa5\xb5\xca\xd1\xa1\xa6\xa1\xdd\xa5\xba\xa5\xeb", "\xa5\xb5\xb9\xd4\xca\xd1\xb3\xca",
   "\xa5\xb5\xca\xd1\xa1\xa6\xa5\xb9\xa5\xeb", "\xa5\xb5\xb9\xd4\xca\xd1\xb3\xca",
   "\xa5\xe9\xca\xd1", "\xa5\xe9\xb9\xd4\xca\xd1\xb3\xca",
   "\xb0\xec\xc3\xca", "\xb0\xec\xc3\xca",
   "\xb0\xec\xc3\xca\xa1\xa6\xa5\xaf\xa5\xec\xa5\xeb", "\xb0\xec\xc3\xca",
   "\xb0\xec\xc3\xca\xa1\xa6\xc6\xc0\xa5\xeb", "\xb0\xec\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xab\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xac\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xbf\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xc0\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xcf\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xa5\xde\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xb2\xbc\xc6\xf3\xa1\xa6\xc6\xc0", "\xc6\xf3\xc3\xca",
   "\xb7\xc1\xcd\xc6\xbb\xec\xa1\xa6\xa5\xa2\xa5\xa6\xa5\xaa\xc3\xca", "\xb7\xc1\xcd\xc6\xbb\xec",
   "\xb7\xc1\xcd\xc6\xbb\xec\xa1\xa6\xa5\xa4\xa5\xa4", "\xb7\xc1\xcd\xc6\xbb\xec",
   "\xb7\xc1\xcd\xc6\xbb\xec\xa1\xa6\xa5\xa4\xc3\xca", "\xb7\xc1\xcd\xc6\xbb\xec",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xab\xb9\xd4\xa5\xa4\xb2\xbb\xca\xd8", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xab\xb9\xd4\xc2\xa5\xb2\xbb\xca\xd8", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xab\xb9\xd4\xc2\xa5\xb2\xbb\xca\xd8\xa5\xe6\xa5\xaf", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xac\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xb5\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xbf\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xca\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xd0\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xde\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xe9\xb9\xd4", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xe9\xb9\xd4\xa5\xa2\xa5\xeb", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xe9\xb9\xd4\xc6\xc3\xbc\xec", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xef\xb9\xd4\xa5\xa6\xb2\xbb\xca\xd8", "\xb8\xde\xc3\xca",
   "\xb8\xde\xc3\xca\xa1\xa6\xa5\xef\xb9\xd4\xc2\xa5\xb2\xbb\xca\xd8", "\xb8\xde\xc3\xca",
   "\xbb\xcd\xc3\xca\xa1\xa6\xa5\xb5\xb9\xd4", "\xbb\xcd\xc3\xca",
   "\xbb\xcd\xc3\xca\xa1\xa6\xa5\xbf\xb9\xd4", "\xbb\xcd\xc3\xca",
   "\xbb\xcd\xc3\xca\xa1\xa6\xa5\xcf\xb9\xd4", "\xbb\xcd\xc3\xca",
   "\xbb\xcd\xc3\xca\xa1\xa6\xa5\xd0\xb9\xd4", "\xbb\xcd\xc3\xca",
   "\xbe\xe5\xc6\xf3\xa1\xa6\xa5\xc0\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xbe\xe5\xc6\xf3\xa1\xa6\xa5\xcf\xb9\xd4", "\xc6\xf3\xc3\xca",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xb8\xa5\xe3", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xbf", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xbf\xa5\xa4", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xc0", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xc7\xa5\xb9", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xca\xa5\xa4", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xcc", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xde\xa5\xb9", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc6\xc3\xbc\xec\xa1\xa6\xa5\xe4", "\xbd\xf5\xc6\xb0\xbb\xec",
   "\xc9\xd4\xca\xd1\xb2\xbd\xb7\xbf", "\xc9\xd4\xca\xd1\xb2\xbd",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xad", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xb1\xa5\xea", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xb4\xa5\xc8\xa5\xb7", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xca\xa5\xea", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xd9\xa5\xb7", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xde\xa5\xb8", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xea", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   "\xca\xb8\xb8\xec\xa1\xa6\xa5\xeb", "\xca\xb8\xb8\xec\xbd\xf5\xc6\xb0\xbb\xec",
   NULL, NULL
};

NJD2JPCOMMON_RULE_H_END;

#endif                          /* !NJD2JPCOMMON_RULE_H */
