/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_ACCOUNTMANAGEMENTSERVICEAFFECTSIDENTITYACCESS_H_
#define OPENDRIM_ACCOUNTMANAGEMENTSERVICEAFFECTSIDENTITYACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_AccountManagementServiceAffectsIdentity.h"
#include "assocOpenDRIM_AccountManagementServiceAffectsIdentity.h"

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AccountManagementServiceAffectsIdentity>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AccountManagementServiceAffectsIdentity& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementServiceAffectsIdentity& newInstance, const OpenDRIM_AccountManagementServiceAffectsIdentity& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementServiceAffectsIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AccountManagementServiceAffectsIdentity& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_associatorAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const char** properties, vector<Instance>& AffectingElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_associatorAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const char** properties, vector<Instance>& AffectedElement_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_referenceAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const vector<Instance>& AffectingElement_instances, vector<OpenDRIM_AccountManagementServiceAffectsIdentity>& OpenDRIM_AccountManagementServiceAffectsIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_referenceAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const vector<Instance>& AffectedElement_instances, vector<OpenDRIM_AccountManagementServiceAffectsIdentity>& OpenDRIM_AccountManagementServiceAffectsIdentity_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_AccountManagementServiceAffectsIdentity_populate(OpenDRIM_AccountManagementServiceAffectsIdentity& instance, string& errorMessage);

#endif /*OPENDRIM_ACCOUNTMANAGEMENTSERVICEAFFECTSIDENTITYACCESS_H_*/
