/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSTestCEReactions.h"

#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSDOMBindingCaller.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvert.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSTestCEReactionsStringifier.h"
#include <runtime/Error.h>
#include <runtime/FunctionPrototype.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsTestCEReactionsPrototypeFunctionMethodWithCEReactions(JSC::ExecState*);

// Attributes

JSC::EncodedJSValue jsTestCEReactionsAttributeWithCEReactions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestCEReactionsAttributeWithCEReactions(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestCEReactionsReflectAttributeWithCEReactions(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestCEReactionsReflectAttributeWithCEReactions(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestCEReactionsStringifierAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestCEReactionsStringifierAttribute(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsTestCEReactionsConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSTestCEReactionsConstructor(JSC::ExecState*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSTestCEReactionsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSTestCEReactionsPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSTestCEReactionsPrototype* ptr = new (NotNull, JSC::allocateCell<JSTestCEReactionsPrototype>(vm.heap)) JSTestCEReactionsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSTestCEReactionsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};

using JSTestCEReactionsConstructor = JSDOMConstructorNotConstructable<JSTestCEReactions>;

template<> JSValue JSTestCEReactionsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSTestCEReactionsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSTestCEReactions::prototype(vm, &globalObject), DontDelete | ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(&vm, String(ASCIILiteral("TestCEReactions"))), ReadOnly | DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), ReadOnly | DontEnum);
}

template<> const ClassInfo JSTestCEReactionsConstructor::s_info = { "TestCEReactions", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestCEReactionsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSTestCEReactionsPrototypeTableValues[] =
{
    { "constructor", DontEnum, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestCEReactionsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestCEReactionsConstructor) } },
    { "attributeWithCEReactions", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestCEReactionsAttributeWithCEReactions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestCEReactionsAttributeWithCEReactions) } },
    { "reflectAttributeWithCEReactions", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestCEReactionsReflectAttributeWithCEReactions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestCEReactionsReflectAttributeWithCEReactions) } },
    { "stringifierAttribute", CustomAccessor, NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsTestCEReactionsStringifierAttribute), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSTestCEReactionsStringifierAttribute) } },
    { "methodWithCEReactions", JSC::Function, NoIntrinsic, { (intptr_t)static_cast<NativeFunction>(jsTestCEReactionsPrototypeFunctionMethodWithCEReactions), (intptr_t) (0) } },
};

const ClassInfo JSTestCEReactionsPrototype::s_info = { "TestCEReactionsPrototype", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestCEReactionsPrototype) };

void JSTestCEReactionsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSTestCEReactionsPrototypeTableValues, *this);
}

const ClassInfo JSTestCEReactions::s_info = { "TestCEReactions", &Base::s_info, 0, CREATE_METHOD_TABLE(JSTestCEReactions) };

JSTestCEReactions::JSTestCEReactions(Structure* structure, JSDOMGlobalObject& globalObject, Ref<TestCEReactions>&& impl)
    : JSDOMWrapper<TestCEReactions>(structure, globalObject, WTFMove(impl))
{
}

void JSTestCEReactions::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

}

JSObject* JSTestCEReactions::createPrototype(VM& vm, JSGlobalObject* globalObject)
{
    return JSTestCEReactionsPrototype::create(vm, globalObject, JSTestCEReactionsPrototype::createStructure(vm, globalObject, globalObject->objectPrototype()));
}

JSObject* JSTestCEReactions::prototype(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSTestCEReactions>(vm, globalObject);
}

void JSTestCEReactions::destroy(JSC::JSCell* cell)
{
    JSTestCEReactions* thisObject = static_cast<JSTestCEReactions*>(cell);
    thisObject->JSTestCEReactions::~JSTestCEReactions();
}

template<> inline JSTestCEReactions* BindingCaller<JSTestCEReactions>::castForAttribute(ExecState& state, EncodedJSValue thisValue)
{
    return jsDynamicDowncast<JSTestCEReactions*>(state.vm(), JSValue::decode(thisValue));
}

template<> inline JSTestCEReactions* BindingCaller<JSTestCEReactions>::castForOperation(ExecState& state)
{
    return jsDynamicDowncast<JSTestCEReactions*>(state.vm(), state.thisValue());
}

static inline JSValue jsTestCEReactionsAttributeWithCEReactionsGetter(ExecState&, JSTestCEReactions&, ThrowScope& throwScope);

EncodedJSValue jsTestCEReactionsAttributeWithCEReactions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestCEReactions>::attribute<jsTestCEReactionsAttributeWithCEReactionsGetter>(state, thisValue, "attributeWithCEReactions");
}

static inline JSValue jsTestCEReactionsAttributeWithCEReactionsGetter(ExecState& state, JSTestCEReactions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(state, impl.attributeWithCEReactions());
    return result;
}

static inline JSValue jsTestCEReactionsReflectAttributeWithCEReactionsGetter(ExecState&, JSTestCEReactions&, ThrowScope& throwScope);

EncodedJSValue jsTestCEReactionsReflectAttributeWithCEReactions(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestCEReactions>::attribute<jsTestCEReactionsReflectAttributeWithCEReactionsGetter>(state, thisValue, "reflectAttributeWithCEReactions");
}

static inline JSValue jsTestCEReactionsReflectAttributeWithCEReactionsGetter(ExecState& state, JSTestCEReactions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(state, impl.attributeWithoutSynchronization(WebCore::HTMLNames::reflectattributewithcereactionsAttr));
    return result;
}

static inline JSValue jsTestCEReactionsStringifierAttributeGetter(ExecState&, JSTestCEReactions&, ThrowScope& throwScope);

EncodedJSValue jsTestCEReactionsStringifierAttribute(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    return BindingCaller<JSTestCEReactions>::attribute<jsTestCEReactionsStringifierAttributeGetter>(state, thisValue, "stringifierAttribute");
}

static inline JSValue jsTestCEReactionsStringifierAttributeGetter(ExecState& state, JSTestCEReactions& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(state);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TestCEReactionsStringifier>>(state, *thisObject.globalObject(), impl.stringifierAttribute());
    return result;
}

EncodedJSValue jsTestCEReactionsConstructor(ExecState* state, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = state->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    JSTestCEReactionsPrototype* domObject = jsDynamicDowncast<JSTestCEReactionsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!domObject))
        return throwVMTypeError(state, throwScope);
    return JSValue::encode(JSTestCEReactions::getConstructor(state->vm(), domObject->globalObject()));
}

bool setJSTestCEReactionsConstructor(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = state->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    JSValue value = JSValue::decode(encodedValue);
    JSTestCEReactionsPrototype* domObject = jsDynamicDowncast<JSTestCEReactionsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!domObject)) {
        throwVMTypeError(state, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return domObject->putDirect(state->vm(), state->propertyNames().constructor, value);
}

static inline bool setJSTestCEReactionsAttributeWithCEReactionsFunction(ExecState&, JSTestCEReactions&, JSValue, ThrowScope&);

bool setJSTestCEReactionsAttributeWithCEReactions(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestCEReactions>::setAttribute<setJSTestCEReactionsAttributeWithCEReactionsFunction>(state, thisValue, encodedValue, "attributeWithCEReactions");
}

static inline bool setJSTestCEReactionsAttributeWithCEReactionsFunction(ExecState& state, JSTestCEReactions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(state, value, StringConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setAttributeWithCEReactions(WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestCEReactionsReflectAttributeWithCEReactionsFunction(ExecState&, JSTestCEReactions&, JSValue, ThrowScope&);

bool setJSTestCEReactionsReflectAttributeWithCEReactions(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestCEReactions>::setAttribute<setJSTestCEReactionsReflectAttributeWithCEReactionsFunction>(state, thisValue, encodedValue, "reflectAttributeWithCEReactions");
}

static inline bool setJSTestCEReactionsReflectAttributeWithCEReactionsFunction(ExecState& state, JSTestCEReactions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(state, value, StringConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::reflectattributewithcereactionsAttr, WTFMove(nativeValue));
    return true;
}


static inline bool setJSTestCEReactionsStringifierAttributeFunction(ExecState&, JSTestCEReactions&, JSValue, ThrowScope&);

bool setJSTestCEReactionsStringifierAttribute(ExecState* state, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return BindingCaller<JSTestCEReactions>::setAttribute<setJSTestCEReactionsStringifierAttributeFunction>(state, thisValue, encodedValue, "stringifierAttribute");
}

static inline bool setJSTestCEReactionsStringifierAttributeFunction(ExecState& state, JSTestCEReactions& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack;
    Ref<TestCEReactionsStringifier> forwardedImpl = thisObject.wrapped().stringifierAttribute();
    auto& impl = forwardedImpl.get();
    auto nativeValue = convert<IDLDOMString>(state, value, StringConversionConfiguration::Normal);
    RETURN_IF_EXCEPTION(throwScope, false);
    impl.setValue(WTFMove(nativeValue));
    return true;
}


JSValue JSTestCEReactions::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSTestCEReactionsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

static inline JSC::EncodedJSValue jsTestCEReactionsPrototypeFunctionMethodWithCEReactionsCaller(JSC::ExecState*, JSTestCEReactions*, JSC::ThrowScope&);

EncodedJSValue JSC_HOST_CALL jsTestCEReactionsPrototypeFunctionMethodWithCEReactions(ExecState* state)
{
    CustomElementReactionStack customElementReactionStack;
    return BindingCaller<JSTestCEReactions>::callOperation<jsTestCEReactionsPrototypeFunctionMethodWithCEReactionsCaller>(state, "methodWithCEReactions");
}

static inline JSC::EncodedJSValue jsTestCEReactionsPrototypeFunctionMethodWithCEReactionsCaller(JSC::ExecState* state, JSTestCEReactions* castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(state);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.methodWithCEReactions();
    return JSValue::encode(jsUndefined());
}

bool JSTestCEReactionsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    return false;
}

void JSTestCEReactionsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsTestCEReactions = static_cast<JSTestCEReactions*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsTestCEReactions->wrapped(), jsTestCEReactions);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7TestCEReactions@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15TestCEReactionsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::ExecState*, JSDOMGlobalObject* globalObject, Ref<TestCEReactions>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = *(reinterpret_cast<void**>(impl.ptr()));
#if PLATFORM(WIN)
    void* expectedVTablePointer = reinterpret_cast<void*>(__identifier("??_7TestCEReactions@WebCore@@6B@"));
#else
    void* expectedVTablePointer = &_ZTVN7WebCore15TestCEReactionsE[2];
#if COMPILER(CLANG)
    // If this fails TestCEReactions does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(__is_polymorphic(TestCEReactions), "TestCEReactions is not polymorphic");
#endif
#endif
    // If you hit this assertion you either have a use after free bug, or
    // TestCEReactions has subclasses. If TestCEReactions has subclasses that get passed
    // to toJS() we currently require TestCEReactions you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<TestCEReactions>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::ExecState* state, JSDOMGlobalObject* globalObject, TestCEReactions& impl)
{
    return wrap(state, globalObject, impl);
}

TestCEReactions* JSTestCEReactions::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicDowncast<JSTestCEReactions*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
