# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0371 (uw-imap)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63264);
 script_cve_id("CVE-2008-5514");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Fedora Core 9 FEDORA-2009-0371 (uw-imap)";
 script_name(name);

 desc = "The remote host is missing an update to uw-imap
announced via advisory FEDORA-2009-0371.

Update Information:

Update to new upstream version - 2007e.    Contains fix for a security issue -
buffer overflow in rfc822_output_char / rfc822_output_data (CVE-2008-5514).

ChangeLog:

* Fri Dec 19 2008 Rex Dieter  2007e-1
- imap-2007e

References:

[ 1 ] Bug #477227 - CVE-2008-5514 libc-client: buffer overflow in rfc822_output_char / rfc822_output_data
https://bugzilla.redhat.com/show_bug.cgi?id=477227

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update uw-imap' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0371

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 9 FEDORA-2009-0371 (uw-imap)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libc-client", rpm:"libc-client~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uw-imap", rpm:"uw-imap~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uw-imap-devel", rpm:"uw-imap-devel~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uw-imap-static", rpm:"uw-imap-static~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uw-imap-utils", rpm:"uw-imap-utils~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"uw-imap-debuginfo", rpm:"uw-imap-debuginfo~2007e~1.fc9", rls:"FC9")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
