###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_opera_select_dos_vuln_lin.nasl 3574 2009-07-21 13:31:35Z jul $
#
# Opera Web Browser Select Object Denial Of Service Vulnerability (Linux)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800922);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2540", "CVE-2009-1692");
  script_bugtraq_id(35446);
  script_name("Opera Web Browser Select Object Denial Of Service Vulnerability (Linux)");
  desc = "

  Overview:
  The host is installed with Opera Web Browser and is prone to Select Object
  Denial of Service vulnerability.

  Vulnerability Insight:
  This flaw is caused due to improper boundary check while passing data into
  the select() method and can be exploited by paasing a large integer value
  resulting in memory exhaustion.

  Impact:
  Successful exploitation will let the attacker crash the browser leading to
  Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  Opera version 9.64 and prior on Linux.

  Fix: Upgrade to opera 10 beta 1 or later.
  http://www.opera.com/download

  References:
  http://www.milw0rm.com/exploits/9160
  http://www.g-sec.lu/one-bug-to-rule-them-all.html
  http://www.securityfocus.com/archive/1/archive/1/504969/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Opera");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_opera_detection_linux_900037.nasl");
  script_require_keys("Opera/Linux/Version");
  exit(0);
}


include("version_func.inc");

if(!operaVer){
  exit(0);
}

# Check for Opera version <= 9.64
if(version_is_less_equal(version:operaVer, test_version:"9.64")){
  security_warning(0);
}
