# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-813-3 (apr-util)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64650);
 script_cve_id("CVE-2009-2412");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-813-3 (apr-util)");

 desc = "The remote host is missing an update to apr-util
announced via advisory USN-813-3.

Details follow:

USN-813-1 fixed vulnerabilities in apr. This update provides the corresponding updates for apr-util.

Original advisory details:

 Matt Lewis discovered that apr did not properly sanitize its input when
 allocating memory. If an application using apr processed crafted input, a
 remote attacker could cause a denial of service or potentially execute
 arbitrary code as the user invoking the application.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  libaprutil1                     1.2.12+dfsg-3ubuntu0.2

Ubuntu 8.10:
  libaprutil1                     1.2.12+dfsg-7ubuntu0.3

Ubuntu 9.04:
  libaprutil1                     1.2.12+dfsg-8ubuntu0.3

After a standard system upgrade you need to restart any applications using
apr-util, such as Subversion and Apache, to effect the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-813-3

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-813-3 (apr-util)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-3ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-3ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-3ubuntu0.2", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-7ubuntu0.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-7ubuntu0.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-7ubuntu0.3", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dbg", ver:"1.2.12+dfsg-8ubuntu0.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1-dev", ver:"1.2.12+dfsg-8ubuntu0.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libaprutil1", ver:"1.2.12+dfsg-8ubuntu0.3", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
