<?php
declare(strict_types = 1);

return [
    'headers' => [
        'date' => [
            'Sun, 04 Apr 2021 01:57:44 GMT'
        ],
        'server' => [
            'mw1393.eqiad.wmnet'
        ],
        'x-content-type-options' => [
            'nosniff'
        ],
        'p3p' => [
            'CP="See https://en.wikipedia.org/wiki/Special:CentralAutoLogin/P3P for more info."'
        ],
        'content-language' => [
            'en'
        ],
        'vary' => [
            'Accept-Encoding,Cookie,Authorization'
        ],
        'x-request-id' => [
            'ef7ed8ff-918f-4ac3-b96b-46979745839c'
        ],
        'last-modified' => [
            'Sun, 04 Apr 2021 01:53:01 GMT'
        ],
        'content-type' => [
            'text/html; charset=UTF-8'
        ],
        'content-encoding' => [
            'gzip'
        ],
        'age' => [
            '48167'
        ],
        'x-cache' => [
            'cp3056 hit, cp3062 hit/125'
        ],
        'x-cache-status' => [
            'hit-front'
        ],
        'server-timing' => [
            'cache;desc="hit-front", host;desc="cp3062"'
        ],
        'strict-transport-security' => [
            'max-age=106384710; includeSubDomains; preload'
        ],
        'report-to' => [
            '{ "group": "wm_nel", "max_age": 86400, "endpoints": [{ "url": "https://intake-logging.wikimedia.org/v1/events?stream=w3c.reportingapi.network_error&schema_uri=/w3c/reportingapi/network_error/1.0.0" }] }'
        ],
        'nel' => [
            '{ "report_to": "wm_nel", "max_age": 86400, "failure_fraction": 0.05, "success_fraction": 0.0}'
        ],
        'x-client-ip' => [
            '89.6.157.99'
        ],
        'cache-control' => [
            'private, s-maxage=0, max-age=0, must-revalidate'
        ],
        'accept-ranges' => [
            'bytes'
        ],
        'content-length' => [
            '158363'
        ],
        'Content-Location' => [
            'https://en.wikipedia.org/wiki/Albert_Einstein'
        ],
        'X-Request-Time' => [
            '0.369 ms'
        ]
    ],
    'statusCode' => 200,
    'reasonPhrase' => 'OK',
    'body' => '<!DOCTYPE html>
<html class="client-nojs" lang="en" dir="ltr">
<head>
<meta charset="UTF-8"/>
<title>Albert Einstein - Wikipedia</title>
<script>document.documentElement.className="client-js";RLCONF={"wgBreakFrames":!1,"wgSeparatorTransformTable":["",""],"wgDigitTransformTable":["",""],"wgDefaultDateFormat":"dmy","wgMonthNames":["","January","February","March","April","May","June","July","August","September","October","November","December"],"wgRequestId":"ef7ed8ff-918f-4ac3-b96b-46979745839c","wgCSPNonce":!1,"wgCanonicalNamespace":"","wgCanonicalSpecialPageName":!1,"wgNamespaceNumber":0,"wgPageName":"Albert_Einstein","wgTitle":"Albert Einstein","wgCurRevisionId":1015872965,"wgRevisionId":1015872965,"wgArticleId":736,"wgIsArticle":!0,"wgIsRedirect":!1,"wgAction":"view","wgUserName":null,"wgUserGroups":["*"],"wgCategories":["Webarchive template wayback links","CS1 German-language sources (de)","Wikipedia articles needing page number citations from November 2020","CS1: Julian–Gregorian uncertainty","CS1 French-language sources (fr)","CS1 location test","Wikipedia indefinitely semi-protected pages",
"Use American English from April 2020","All Wikipedia articles written in American English","Articles with short description","Short description is different from Wikidata","Use dmy dates from March 2021","Articles containing German-language text","Biography with signature","Articles with hCards","Articles with hAudio microformats","Wikipedia articles needing clarification from September 2020","All articles with unsourced statements","Articles with unsourced statements from April 2020","Wikipedia articles incorporating a citation from the 1922 Encyclopaedia Britannica with Wikisource reference","Pages using Sister project links with hidden wikidata","Articles with Curlie links","Articles with Project Gutenberg links","Articles with Internet Archive links","Articles with LibriVox links","Nobelprize template using Wikidata property P8024","Good articles","Wikipedia articles with BIBSYS identifiers","Wikipedia articles with BNC identifiers","Wikipedia articles with BNE identifiers",
"Wikipedia articles with BNF identifiers","Wikipedia articles with CANTIC identifiers","Wikipedia articles with CINII identifiers","Wikipedia articles with GND identifiers","Wikipedia articles with HDS identifiers","Wikipedia articles with ICCU identifiers","Wikipedia articles with ISNI identifiers","Wikipedia articles with LCCN identifiers","Wikipedia articles with LNB identifiers","Wikipedia articles with MusicBrainz identifiers","Wikipedia articles with MGP identifiers","Wikipedia articles with NARA identifiers","Wikipedia articles with NCL identifiers","Wikipedia articles with NDL identifiers","Wikipedia articles with NKC identifiers","Wikipedia articles with NLA identifiers","Wikipedia articles with NLG identifiers","Wikipedia articles with NLI identifiers","Wikipedia articles with NLK identifiers","Wikipedia articles with NLP identifiers","Wikipedia articles with NLR identifiers","Wikipedia articles with NSK identifiers","Wikipedia articles with NTA identifiers",
"Wikipedia articles with PLWABN identifiers","Wikipedia articles with RERO identifiers","Wikipedia articles with SELIBR identifiers","Wikipedia articles with SNAC-ID identifiers","Wikipedia articles with SUDOC identifiers","Wikipedia articles with Trove identifiers","Wikipedia articles with ULAN identifiers","Wikipedia articles with VcBA identifiers","Wikipedia articles with VIAF identifiers","Wikipedia articles with WORLDCATID identifiers","AC with 35 elements","Articles containing timelines","Albert Einstein","1879 births","1955 deaths","20th-century American engineers","20th-century American physicists","20th-century American writers","20th-century German physicists","Activists from New Jersey","American agnostics","American anti-capitalists","American humanists","American inventors","American letter writers","American Nobel laureates","American pacifists","American relativity theorists","American science writers","American socialists","American Zionists","Ashkenazi Jews",
"Charles University faculty","Corresponding Members of the Russian Academy of Sciences (1917–1925)","Cosmologists","Deaths from abdominal aortic aneurysm","Determinists","Disease-related deaths in New Jersey","Einstein family","ETH Zurich alumni","ETH Zurich faculty","European democratic socialists","Foreign associates of the National Academy of Sciences","Foreign Fellows of the Indian National Science Academy","Foreign Members of the Royal Society","German agnostics","German anti-capitalists","German emigrants to Switzerland","German humanists","German inventors","German Jews","German Nobel laureates","German relativity theorists","German socialists","Honorary Members of the USSR Academy of Sciences","Institute for Advanced Study faculty","Jewish agnostics","Jewish American physicists","Jewish emigrants from Nazi Germany to the United States","Jewish inventors","Jewish Nobel laureates","Jewish physicists","Jewish socialists","Leiden University faculty",
"Mathematicians involved with Mathematische Annalen","Members of the American Philosophical Society","Members of the Bavarian Academy of Sciences","Members of the Lincean Academy","Members of the Royal Netherlands Academy of Arts and Sciences","Members of the United States National Academy of Sciences","Naturalised citizens of Austria","Naturalised citizens of Switzerland","Naturalized citizens of the United States","New Jersey socialists","Nobel laureates in Physics","Pantheists","Patent examiners","People from Princeton, New Jersey","People who lost German citizenship","Philosophers of mathematics","Philosophers of science","Philosophy of science","Quantum physicists","Recipients of the Gold Medal of the Royal Astronomical Society","Recipients of the Pour le Mérite (civil class)","Scientists from Munich","Spinozists","Stateless people","Swiss agnostics","Swiss emigrants to the United States","Swiss Jews","Swiss physicists","Winners of the Max Planck Medal","World federalists"],
"wgPageContentLanguage":"en","wgPageContentModel":"wikitext","wgRelevantPageName":"Albert_Einstein","wgRelevantArticleId":736,"wgIsProbablyEditable":!1,"wgRelevantPageIsProbablyEditable":!1,"wgRestrictionEdit":["autoconfirmed"],"wgRestrictionMove":["sysop"],"wgMediaViewerOnClick":!0,"wgMediaViewerEnabledByDefault":!0,"wgPopupsFlags":10,"wgVisualEditor":{"pageLanguageCode":"en","pageLanguageDir":"ltr","pageVariantFallbacks":"en"},"wgMFDisplayWikibaseDescriptions":{"search":!0,"nearby":!0,"watchlist":!0,"tagline":!1},"wgWMESchemaEditAttemptStepOversample":!1,"wgULSCurrentAutonym":"English","wgNoticeProject":"wikipedia","wgCentralAuthMobileDomain":!1,"wgEditSubmitButtonLabelPublish":!0,"wgULSPosition":"interlanguage","wgWikibaseItemId":"Q937"};RLSTATE={"ext.globalCssJs.user.styles":"ready","site.styles":"ready","noscript":"ready","user.styles":"ready","ext.globalCssJs.user":"ready","user":"ready","user.options":"loading","ext.cite.styles":"ready",
"ext.tmh.thumbnail.styles":"ready","ext.categoryTree.styles":"ready","skins.vector.styles.legacy":"ready","jquery.makeCollapsible.styles":"ready","ext.visualEditor.desktopArticleTarget.noscript":"ready","ext.uls.interlanguage":"ready","ext.wikimediaBadges":"ready","wikibase.client.init":"ready"};RLPAGEMODULES=["ext.cite.ux-enhancements","mw.MediaWikiPlayer.loader","mw.PopUpMediaTransform","mw.TMHGalleryHook.js","ext.scribunto.logs","ext.categoryTree","site","mediawiki.page.ready","jquery.makeCollapsible","mediawiki.toc","skins.vector.legacy.js","ext.gadget.ReferenceTooltips","ext.gadget.charinsert","ext.gadget.extra-toolbar-buttons","ext.gadget.refToolbar","ext.gadget.switcher","ext.centralauth.centralautologin","mmv.head","mmv.bootstrap.autostart","ext.popups","ext.visualEditor.desktopArticleTarget.init","ext.visualEditor.targetLoader","ext.eventLogging","ext.wikimediaEvents","ext.navigationTiming","ext.uls.compactlinks","ext.uls.interface","ext.cx.eventlogging.campaigns",
"ext.centralNotice.geoIP","ext.centralNotice.startUp"];</script>
<script>(RLQ=window.RLQ||[]).push(function(){mw.loader.implement("user.options@1hzgi",function($,jQuery,require,module){/*@nomin*/mw.user.tokens.set({"patrolToken":"+\\\\","watchToken":"+\\\\","csrfToken":"+\\\\"});
});});</script>
<link rel="stylesheet" href="/w/load.php?lang=en&amp;modules=ext.categoryTree.styles%7Cext.cite.styles%7Cext.tmh.thumbnail.styles%7Cext.uls.interlanguage%7Cext.visualEditor.desktopArticleTarget.noscript%7Cext.wikimediaBadges%7Cjquery.makeCollapsible.styles%7Cskins.vector.styles.legacy%7Cwikibase.client.init&amp;only=styles&amp;skin=vector"/>
<script async="" src="/w/load.php?lang=en&amp;modules=startup&amp;only=scripts&amp;raw=1&amp;skin=vector"></script>
<meta name="ResourceLoaderDynamicStyles" content=""/>
<link rel="stylesheet" href="/w/load.php?lang=en&amp;modules=site.styles&amp;only=styles&amp;skin=vector"/>
<meta name="generator" content="MediaWiki 1.36.0-wmf.37"/>
<meta name="referrer" content="origin"/>
<meta name="referrer" content="origin-when-crossorigin"/>
<meta name="referrer" content="origin-when-cross-origin"/>
<meta property="og:image" content="https://upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Einstein_1921_by_F_Schmutzer_-_restoration.jpg/1200px-Einstein_1921_by_F_Schmutzer_-_restoration.jpg"/>
<meta property="og:title" content="Albert Einstein - Wikipedia"/>
<meta property="og:type" content="website"/>
<link rel="preconnect" href="//upload.wikimedia.org"/>
<link rel="alternate" media="only screen and (max-width: 720px)" href="//en.m.wikipedia.org/wiki/Albert_Einstein"/>
<link rel="apple-touch-icon" href="/static/apple-touch/wikipedia.png"/>
<link rel="shortcut icon" href="/static/favicon/wikipedia.ico"/>
<link rel="search" type="application/opensearchdescription+xml" href="/w/opensearch_desc.php" title="Wikipedia (en)"/>
<link rel="EditURI" type="application/rsd+xml" href="//en.wikipedia.org/w/api.php?action=rsd"/>
<link rel="license" href="//creativecommons.org/licenses/by-sa/3.0/"/>
<link rel="canonical" href="https://en.wikipedia.org/wiki/Albert_Einstein"/>
<link rel="dns-prefetch" href="//login.wikimedia.org"/>
<link rel="dns-prefetch" href="//meta.wikimedia.org" />
</head>
<body class="mediawiki ltr sitedir-ltr mw-hide-empty-elt ns-0 ns-subject page-Albert_Einstein rootpage-Albert_Einstein skin-vector action-view skin-vector-legacy"><div id="mw-page-base" class="noprint"></div>
<div id="mw-head-base" class="noprint"></div>
<div id="content" class="mw-body" role="main">
	<a id="top"></a>
	<div id="siteNotice" class="mw-body-content"><!-- CentralNotice --></div>
	<div class="mw-indicators mw-body-content">
	<div id="mw-indicator-good-star" class="mw-indicator"><a href="/wiki/Wikipedia:Good_articles" title="This is a good article. Click here for more information."><img alt="This is a good article. Click here for more information." src="//upload.wikimedia.org/wikipedia/en/thumb/9/94/Symbol_support_vote.svg/19px-Symbol_support_vote.svg.png" decoding="async" width="19" height="20" srcset="//upload.wikimedia.org/wikipedia/en/thumb/9/94/Symbol_support_vote.svg/29px-Symbol_support_vote.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/9/94/Symbol_support_vote.svg/39px-Symbol_support_vote.svg.png 2x" data-file-width="180" data-file-height="185" /></a></div>
	<div id="mw-indicator-pp-default" class="mw-indicator"><a href="/wiki/Wikipedia:Protection_policy#semi" title="This article is semi-protected."><img alt="Page semi-protected" src="//upload.wikimedia.org/wikipedia/en/thumb/1/1b/Semi-protection-shackle.svg/20px-Semi-protection-shackle.svg.png" decoding="async" width="20" height="20" srcset="//upload.wikimedia.org/wikipedia/en/thumb/1/1b/Semi-protection-shackle.svg/30px-Semi-protection-shackle.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/1/1b/Semi-protection-shackle.svg/40px-Semi-protection-shackle.svg.png 2x" data-file-width="512" data-file-height="512" /></a></div>
	</div>
	<h1 id="firstHeading" class="firstHeading" >Albert Einstein</h1>
	<div id="bodyContent" class="mw-body-content">
		<div id="siteSub" class="noprint">From Wikipedia, the free encyclopedia</div>
		<div id="contentSub"></div>
		<div id="contentSub2"></div>
		
		<div id="jump-to-nav"></div>
		<a class="mw-jump-link" href="#mw-head">Jump to navigation</a>
		<a class="mw-jump-link" href="#searchInput">Jump to search</a>
		<div id="mw-content-text" lang="en" dir="ltr" class="mw-content-ltr"><div class="mw-parser-output"><div role="note" class="hatnote navigation-not-searchable">"Einstein" redirects here. For other uses, see <a href="/wiki/Einstein_(disambiguation)" class="mw-disambig" title="Einstein (disambiguation)">Einstein (disambiguation)</a> and <a href="/wiki/Albert_Einstein_(disambiguation)" class="mw-disambig" title="Albert Einstein (disambiguation)">Albert Einstein (disambiguation)</a>.</div>
<p class="mw-empty-elt">

</p>
<div class="shortdescription nomobile noexcerpt noprint searchaux" style="display:none">German-born scientist who developed the theory of relativity</div>
<p class="mw-empty-elt">
</p>
<table class="infobox biography vcard"><tbody><tr><th colspan="2" class="infobox-above"><div class="fn" style="display:inline">Albert Einstein</div></th></tr><tr><td colspan="2" class="infobox-image"><a href="/wiki/File:Einstein_1921_by_F_Schmutzer_-_restoration.jpg" class="image"><img alt="Einstein 1921 by F Schmutzer - restoration.jpg" src="//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Einstein_1921_by_F_Schmutzer_-_restoration.jpg/220px-Einstein_1921_by_F_Schmutzer_-_restoration.jpg" decoding="async" width="220" height="289" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Einstein_1921_by_F_Schmutzer_-_restoration.jpg/330px-Einstein_1921_by_F_Schmutzer_-_restoration.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Einstein_1921_by_F_Schmutzer_-_restoration.jpg/440px-Einstein_1921_by_F_Schmutzer_-_restoration.jpg 2x" data-file-width="2523" data-file-height="3313" /></a><div class="infobox-caption">Einstein in 1921</div></td></tr><tr><th scope="row" class="infobox-label">Born</th><td class="infobox-data"><span style="display:none">(<span class="bday">1879-03-14</span>)</span>14 March 1879<br /><div style="display:inline" class="birthplace"><a href="/wiki/Ulm" title="Ulm">Ulm</a>, <a href="/wiki/Kingdom_of_W%C3%BCrttemberg" title="Kingdom of Württemberg">Kingdom of Württemberg</a>, <a href="/wiki/German_Empire" title="German Empire">German Empire</a></div></td></tr><tr><th scope="row" class="infobox-label">Died</th><td class="infobox-data">18 April 1955<span style="display:none">(1955-04-18)</span> (aged&#160;76)<br /><div style="display:inline" class="deathplace"><span class="nowrap"><a href="/wiki/Princeton,_New_Jersey" title="Princeton, New Jersey">Princeton, New Jersey</a>, U.S.</span></div></td></tr><tr><th scope="row" class="infobox-label">Citizenship</th><td class="infobox-data category"><div class="plainlist">
<ul><li><a href="/wiki/Kingdom_of_W%C3%BCrttemberg" title="Kingdom of Württemberg">Kingdom of Württemberg</a>, part of the German Empire (1879–1896)<sup id="cite_ref-GEcitizen_1-0" class="reference"><a href="#cite_note-GEcitizen-1">&#91;note 1&#93;</a></sup></li>
<li><a href="/wiki/Statelessness" title="Statelessness">Stateless</a> (1896–1901)</li>
<li><a href="/wiki/Switzerland" title="Switzerland">Switzerland</a> (1901–1955)</li>
<li><a href="/wiki/Cisleithania" title="Cisleithania">Austria</a>, part of the <a href="/wiki/Austro-Hungarian_Empire" class="mw-redirect" title="Austro-Hungarian Empire">Austro-Hungarian Empire</a> (1911–1912)</li>
<li><a href="/wiki/Kingdom_of_Prussia" title="Kingdom of Prussia">Kingdom of Prussia</a>, part of the German Empire (1914–1918)<sup id="cite_ref-GEcitizen_1-1" class="reference"><a href="#cite_note-GEcitizen-1">&#91;note 1&#93;</a></sup></li>
<li><a href="/wiki/Free_State_of_Prussia" title="Free State of Prussia">Free State of Prussia</a> (<a href="/wiki/Weimar_Republic" title="Weimar Republic">Weimar Republic</a> and <a href="/wiki/Nazi_Germany" title="Nazi Germany">Nazi Germany</a>, 1918–1933)</li>
<li><a href="/wiki/United_States" title="United States">United States</a> (1940–1955)</li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label">Education</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/ETH_Zurich" title="ETH Zurich">Federal Polytechnic School</a> in <a href="/wiki/Zurich" class="mw-redirect" title="Zurich">Zurich</a> (Federal teaching diploma, 1900)</li>
<li><a href="/wiki/University_of_Zurich" title="University of Zurich">University of Zurich</a> (PhD, 1905)</li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label">Known&#160;for</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/General_relativity" title="General relativity">General relativity</a></li>
<li><a href="/wiki/Special_relativity" title="Special relativity">Special relativity</a></li>
<li><a href="/wiki/Photoelectric_effect" title="Photoelectric effect">Photoelectric effect</a></li>
<li><a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence"><i>E=mc<sup>2</sup></i> (Mass–energy equivalence)</a></li>
<li><a href="/wiki/Planck%E2%80%93Einstein_relation" title="Planck–Einstein relation"><i>E=hf</i> (Planck–Einstein relation)</a></li>
<li>Theory of <a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a></li>
<li><a href="/wiki/Einstein_field_equations" title="Einstein field equations">Einstein field equations</a></li>
<li><a href="/wiki/Bose%E2%80%93Einstein_statistics" title="Bose–Einstein statistics">Bose–Einstein statistics</a></li>
<li><a href="/wiki/Bose%E2%80%93Einstein_condensate" title="Bose–Einstein condensate">Bose–Einstein condensate</a></li>
<li><a href="/wiki/Gravitational_wave" title="Gravitational wave">Gravitational wave</a></li>
<li><a href="/wiki/Cosmological_constant" title="Cosmological constant">Cosmological constant</a></li>
<li><a href="/wiki/Unified_field_theory" title="Unified field theory">Unified field theory</a></li>
<li><a href="/wiki/EPR_paradox" title="EPR paradox">EPR paradox</a></li>
<li><a href="/wiki/Ensemble_interpretation" title="Ensemble interpretation">Ensemble interpretation</a></li>
<li><a href="/wiki/List_of_things_named_after_Albert_Einstein" title="List of things named after Albert Einstein">List of other concepts</a></li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label"><span class="nowrap">Spouse(s)</span></th><td class="infobox-data"><div class="plainlist">
<ul><li class="mw-empty-elt"></li></ul>
<div style="display:inline;white-space:nowrap;"><div style="display:inline-block;line-height:normal;margin-top:1px;white-space:normal;"><a href="/wiki/Mileva_Mari%C4%87" title="Mileva Marić">Mileva Marić</a></div>
   <div style="line-height:0;margin-bottom:-2px;">&#8203;</div>&#32;<div style="display:inline-block;margin-bottom:1px;">&#8203;</div>&#40;<abbr title="married">m.</abbr>&#160;1903&#59;&#32;<abbr title="divorced">div.</abbr>&#160;1919&#41;<wbr />&#8203;</div>
<ul><li class="mw-empty-elt"></li></ul>
<div style="display:inline;white-space:nowrap;"><div style="display:inline-block;line-height:normal;margin-top:1px;white-space:normal;"><a href="/wiki/Elsa_L%C3%B6wenthal" class="mw-redirect" title="Elsa Löwenthal">Elsa Löwenthal</a></div>
   <div style="line-height:0;margin-bottom:-2px;">&#8203;</div>&#32;<div style="display:inline-block;margin-bottom:1px;">&#8203;</div>&#40;<abbr title="married">m.</abbr>&#160;1919&#59;&#32;died<sup id="cite_ref-66xNO_2-0" class="reference"><a href="#cite_note-66xNO-2">&#91;1&#93;</a></sup><sup id="cite_ref-FOOTNOTEPais1982301_3-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982301-3">&#91;2&#93;</a></sup>&#160;1936&#41;<wbr />&#8203;</div>
</div></td></tr><tr><th scope="row" class="infobox-label">Children</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/Lieserl_Einstein" class="mw-redirect" title="Lieserl Einstein">"Lieserl" Einstein</a></li>
<li><a href="/wiki/Hans_Albert_Einstein" title="Hans Albert Einstein">Hans Albert Einstein</a></li>
<li><a href="/wiki/Einstein_family#Eduard_&quot;Tete&quot;_Einstein_(Albert&#39;s_second_son)" title="Einstein family">Eduard "Tete" Einstein</a></li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label">Awards</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/Barnard_Medal_for_Meritorious_Service_to_Science" title="Barnard Medal for Meritorious Service to Science">Barnard Medal</a> (1920)</li>
<li><a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Nobel Prize in Physics</a> (1921)</li>
<li><a href="/wiki/Matteucci_Medal" title="Matteucci Medal">Matteucci Medal</a> (1921)</li>
<li><a href="/wiki/ForMemRS" class="mw-redirect" title="ForMemRS">ForMemRS</a> (1921)<sup id="cite_ref-frs_4-0" class="reference"><a href="#cite_note-frs-4">&#91;3&#93;</a></sup></li>
<li><a href="/wiki/Copley_Medal" title="Copley Medal">Copley Medal</a> (1925)<sup id="cite_ref-frs_4-1" class="reference"><a href="#cite_note-frs-4">&#91;3&#93;</a></sup></li>
<li><a href="/wiki/Gold_Medal_of_the_Royal_Astronomical_Society" title="Gold Medal of the Royal Astronomical Society">Gold Medal of the Royal Astronomical Society</a> (1926)</li>
<li><a href="/wiki/Max_Planck_Medal" title="Max Planck Medal">Max Planck Medal</a> (1929)</li>
<li><a href="/wiki/Member_of_the_National_Academy_of_Sciences" title="Member of the National Academy of Sciences">Member of the National Academy of Sciences</a> (1942)</li>
<li><a href="/wiki/Time_100:_The_Most_Important_People_of_the_Century" title="Time 100: The Most Important People of the Century"><i>Time</i> Person of the Century</a> (1999)</li></ul>
</div></td></tr><tr><td colspan="2" class="infobox-full-data"><b>Scientific career</b></td></tr><tr><th scope="row" class="infobox-label">Fields</th><td class="infobox-data category"><a href="/wiki/Physics" title="Physics">Physics</a>, <a href="/wiki/Philosophy" title="Philosophy">philosophy</a></td></tr><tr><th scope="row" class="infobox-label">Institutions</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/Swiss_Patent_Office" class="mw-redirect" title="Swiss Patent Office">Swiss Patent Office</a> (<a href="/wiki/Bern" title="Bern">Bern</a>) (1902–1909)</li>
<li><a href="/wiki/University_of_Bern" title="University of Bern">University of Bern</a> (1908–1909)</li>
<li><a href="/wiki/University_of_Zurich" title="University of Zurich">University of Zurich</a> (1909–1911)</li>
<li><a href="/wiki/Karl-Ferdinands-Universit%C3%A4t" class="mw-redirect" title="Karl-Ferdinands-Universität">Charles University in Prague</a> (1911–1912)</li>
<li><a href="/wiki/ETH_Zurich" title="ETH Zurich">ETH Zurich</a> (1912–1914)</li>
<li><a href="/wiki/Prussian_Academy_of_Sciences" title="Prussian Academy of Sciences">Prussian Academy of Sciences</a> (1914–1933)</li>
<li><a href="/wiki/Humboldt_University_of_Berlin" title="Humboldt University of Berlin">Humboldt University of Berlin</a> (1914–1933)</li>
<li><a href="/wiki/Kaiser_Wilhelm_Institute" class="mw-redirect" title="Kaiser Wilhelm Institute">Kaiser Wilhelm Institute</a> (director, 1917–1933)</li>
<li><a href="/wiki/German_Physical_Society" title="German Physical Society">German Physical Society</a> (president, 1916–1918)</li>
<li><a href="/wiki/Leiden_University" title="Leiden University">Leiden University</a> (visits, 1920)</li>
<li><a href="/wiki/Institute_for_Advanced_Study" title="Institute for Advanced Study">Institute for Advanced Study</a> (1933–1955)</li>
<li><a href="/wiki/Caltech" class="mw-redirect" title="Caltech">Caltech</a> (visits, 1931–1933)</li>
<li><a href="/wiki/University_of_Oxford" title="University of Oxford">University of Oxford</a> (visits, 1931–1933)</li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label"><a href="/wiki/Thesis" title="Thesis">Thesis</a></th><td class="infobox-data"><a rel="nofollow" class="external text" href="http://e-collection.library.ethz.ch/eserv/eth:30378/eth-30378-01.pdf"><i><i lang="de" title="German-language text">Eine neue Bestimmung der Moleküldimensionen</i> (A New Determination of Molecular Dimensions)</i></a>&#160;<span style="font-size:97%;">(1905)</span></td></tr><tr><th scope="row" class="infobox-label"><a href="/wiki/Doctoral_advisor" title="Doctoral advisor">Doctoral advisor</a></th><td class="infobox-data"><a href="/wiki/Alfred_Kleiner" title="Alfred Kleiner">Alfred Kleiner</a></td></tr><tr><th scope="row" class="infobox-label">Other&#160;academic advisors</th><td class="infobox-data"><a href="/wiki/Heinrich_Friedrich_Weber" title="Heinrich Friedrich Weber">Heinrich Friedrich Weber</a></td></tr><tr><th scope="row" class="infobox-label">Influences</th><td class="infobox-data"><div class="plainlist">
<ul><li><a href="/wiki/Arthur_Schopenhauer" title="Arthur Schopenhauer">Arthur Schopenhauer</a></li>
<li><a href="/wiki/Baruch_Spinoza" title="Baruch Spinoza">Baruch Spinoza</a></li>
<li><a href="/wiki/Bernhard_Riemann" title="Bernhard Riemann">Bernhard Riemann</a></li>
<li><a href="/wiki/David_Hume" title="David Hume">David Hume</a></li>
<li><a href="/wiki/Ernst_Mach" title="Ernst Mach">Ernst Mach</a></li>
<li><a href="/wiki/Hendrik_Lorentz" title="Hendrik Lorentz">Hendrik Lorentz</a></li>
<li><a href="/wiki/Hermann_Minkowski" title="Hermann Minkowski">Hermann Minkowski</a></li>
<li><a href="/wiki/Isaac_Newton" title="Isaac Newton">Isaac Newton</a></li>
<li><a href="/wiki/James_Clerk_Maxwell" title="James Clerk Maxwell">James Clerk Maxwell</a></li>
<li><a href="/wiki/Michele_Besso" title="Michele Besso">Michele Besso</a></li>
<li><a href="/wiki/Moritz_Schlick" title="Moritz Schlick">Moritz Schlick</a></li>
<li><a href="/wiki/Thomas_Young_(scientist)" title="Thomas Young (scientist)">Thomas Young</a></li></ul>
</div></td></tr><tr><th scope="row" class="infobox-label">Influenced</th><td class="infobox-data"><div class="plainlist">
<ul><li>Virtually all <a href="/wiki/Modern_physics" title="Modern physics">modern physics</a></li></ul>
</div></td></tr><tr style="display:none"><td colspan="2">
</td></tr><tr><th colspan="2" class="infobox-header">Signature</th></tr><tr><td colspan="2" class="infobox-full-data"><a href="/wiki/File:Albert_Einstein_signature_1934.svg" class="image"><img alt="Albert Einstein signature 1934.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Albert_Einstein_signature_1934.svg/150px-Albert_Einstein_signature_1934.svg.png" decoding="async" width="150" height="23" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Albert_Einstein_signature_1934.svg/225px-Albert_Einstein_signature_1934.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Albert_Einstein_signature_1934.svg/300px-Albert_Einstein_signature_1934.svg.png 2x" data-file-width="585" data-file-height="88" /></a></td></tr></tbody></table>
<p><b>Albert Einstein</b> (<span class="rt-commentedText nowrap"><span class="IPA nopopups noexcerpt"><a href="/wiki/Help:IPA/English" title="Help:IPA/English">/<span style="border-bottom:1px dotted"><span title="/ˈ/: primary stress follows">ˈ</span><span title="/aɪ/: &#39;i&#39; in &#39;tide&#39;">aɪ</span><span title="&#39;n&#39; in &#39;nigh&#39;">n</span><span title="&#39;s&#39; in &#39;sigh&#39;">s</span><span title="&#39;t&#39; in &#39;tie&#39;">t</span><span title="/aɪ/: &#39;i&#39; in &#39;tide&#39;">aɪ</span><span title="&#39;n&#39; in &#39;nigh&#39;">n</span></span>/</a></span></span> <a href="/wiki/Help:Pronunciation_respelling_key" title="Help:Pronunciation respelling key"><i title="English pronunciation respelling"><span style="font-size:90%">EYEN</span>-styne</i></a>;<sup id="cite_ref-NDxay_5-0" class="reference"><a href="#cite_note-NDxay-5">&#91;4&#93;</a></sup> <small>German:&#32;</small><span title="Representation in the International Phonetic Alphabet (IPA)" class="IPA"><a href="/wiki/Help:IPA/Standard_German" title="Help:IPA/Standard German">[ˈalbɛʁt ˈʔaɪnʃtaɪn]</a></span>&#32;<span class="nowrap" style="font-size:85%">(<span class="unicode haudio"><span class="fn"><span style="white-space:nowrap;margin-right:.25em;"><a href="/wiki/File:Albert_Einstein_german.ogg" title="About this sound"><img alt="About this sound" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Loudspeaker.svg/11px-Loudspeaker.svg.png" decoding="async" width="11" height="11" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Loudspeaker.svg/17px-Loudspeaker.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Loudspeaker.svg/22px-Loudspeaker.svg.png 2x" data-file-width="20" data-file-height="20" /></a></span><a href="//upload.wikimedia.org/wikipedia/commons/7/77/De-Albert_Einstein.oga" class="internal" title="De-Albert Einstein.oga">listen</a></span></span>)</span>; 14 March 1879&#160;– 18 April 1955) was a German-born <a href="/wiki/Theoretical_physics" title="Theoretical physics">theoretical physicist</a>,<sup id="cite_ref-Bio_6-0" class="reference"><a href="#cite_note-Bio-6">&#91;5&#93;</a></sup> widely acknowledged to be one of the greatest physicists of all time. Einstein is known widely for developing the <a href="/wiki/Theory_of_relativity" title="Theory of relativity">theory of relativity</a>, but he also made important contributions to the development of the theory of <a href="/wiki/Quantum_mechanics" title="Quantum mechanics">quantum mechanics</a>. Relativity and quantum mechanics are together the two pillars of <a href="/wiki/Modern_physics" title="Modern physics">modern physics</a>. <sup id="cite_ref-frs_4-2" class="reference"><a href="#cite_note-frs-4">&#91;3&#93;</a></sup><sup id="cite_ref-YangHamilton2010_7-0" class="reference"><a href="#cite_note-YangHamilton2010-7">&#91;6&#93;</a></sup> His <a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence">mass–energy equivalence</a> formula <span class="texhtml"><a href="/wiki/Mass%E2%80%93energy_equivalence#Mass–velocity_relationship" title="Mass–energy equivalence"><i>E</i> = <i>mc</i><sup>2</sup></a></span>, which arises from relativity theory, has been dubbed "the world\'s most famous equation".<sup id="cite_ref-LnLVo_8-0" class="reference"><a href="#cite_note-LnLVo-8">&#91;7&#93;</a></sup> His work is also known for its influence on the <a href="/wiki/Philosophy_of_science" title="Philosophy of science">philosophy of science</a>.<sup id="cite_ref-xZQWt_9-0" class="reference"><a href="#cite_note-xZQWt-9">&#91;8&#93;</a></sup><sup id="cite_ref-3UiiT_10-0" class="reference"><a href="#cite_note-3UiiT-10">&#91;9&#93;</a></sup> He received the 1921 <a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Nobel Prize in Physics</a> "for his services to theoretical physics, and especially for his discovery of the law of the <a href="/wiki/Photoelectric_effect" title="Photoelectric effect">photoelectric effect</a>",<sup id="cite_ref-Nobel_Prize_11-0" class="reference"><a href="#cite_note-Nobel_Prize-11">&#91;10&#93;</a></sup> a pivotal step in the development of quantum theory. His intellectual achievements and originality resulted in "Einstein" becoming <a href="/wiki/Archetypal_name" title="Archetypal name">synonymous</a> with "genius".<sup id="cite_ref-wordnetweb.princeton.edu_12-0" class="reference"><a href="#cite_note-wordnetweb.princeton.edu-12">&#91;11&#93;</a></sup>
</p><p>In 1905, a year sometimes described as his <i><a href="/wiki/Annus_mirabilis" title="Annus mirabilis">annus mirabilis</a></i> (\'miracle year\'), Einstein published <a href="/wiki/Annus_Mirabilis_papers" title="Annus Mirabilis papers">four groundbreaking papers</a>. These outlined the theory of the photoelectric effect, explained <a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a>, introduced <a href="/wiki/Special_relativity" title="Special relativity">special relativity</a>, and demonstrated mass-energy equivalence. Einstein thought that the laws of <a href="/wiki/Classical_mechanics" title="Classical mechanics">classical mechanics</a> could no longer be reconciled with those of the <a href="/wiki/Electromagnetic_field" title="Electromagnetic field">electromagnetic field</a>, which led him to develop his special theory of relativity. He then extended the theory to gravitational fields; he published a paper on <a href="/wiki/General_relativity" title="General relativity">general relativity</a> in 1916, introducing his theory of gravitation. In 1917, he applied the general theory of relativity to model the structure of the universe.<sup id="cite_ref-Nobel_13-0" class="reference"><a href="#cite_note-Nobel-13">&#91;12&#93;</a></sup><sup id="cite_ref-NYT-20151124_14-0" class="reference"><a href="#cite_note-NYT-20151124-14">&#91;13&#93;</a></sup> He continued to deal with problems of <a href="/wiki/Statistical_mechanics" title="Statistical mechanics">statistical mechanics</a> and quantum theory, which led to his explanations of particle theory and the <a href="/wiki/Brownian_motion" title="Brownian motion">motion of molecules</a>. He also investigated the thermal properties of light and the quantum theory of radiation, which laid the foundation of the <a href="/wiki/Photon" title="Photon">photon</a> theory of light. However, for much of the later part of his career, he worked on two ultimately unsuccessful endeavors. First, despite his great contributions to quantum mechanics, he opposed what it evolved into, objecting that nature "does not play dice".<sup id="cite_ref-15" class="reference"><a href="#cite_note-15">&#91;14&#93;</a></sup> Second, he attempted to devise a <a href="/wiki/Unified_field_theory" title="Unified field theory">unified field theory</a> by generalizing his geometric theory of gravitation to include electromagnetism. As a result, he became increasingly isolated from the mainstream of modern physics.
</p><p>Einstein was born in the <a href="/wiki/German_Empire" title="German Empire">German Empire</a>, but moved to Switzerland in 1895, forsaking his German citizenship the following year. In 1901, he acquired Swiss citizenship, which he kept for the rest of his life. In 1905, he was awarded a PhD by the <a href="/wiki/University_of_Zurich" title="University of Zurich">University of Zurich</a>. In 1933, while Einstein was visiting the United States, <a href="/wiki/Adolf_Hitler" title="Adolf Hitler">Adolf Hitler</a> came to power. Einstein did not return to Germany because he objected to the policies of the newly elected <a href="/wiki/Nazi_Germany" title="Nazi Germany">Nazi-led government</a>.<sup id="cite_ref-zE9Bz_16-0" class="reference"><a href="#cite_note-zE9Bz-16">&#91;15&#93;</a></sup> He settled in the United States and became an American citizen in 1940.<sup id="cite_ref-BoyerDubofsky2001_17-0" class="reference"><a href="#cite_note-BoyerDubofsky2001-17">&#91;16&#93;</a></sup> On the eve of <a href="/wiki/World_War_II" title="World War II">World War II</a>, he endorsed <a href="/wiki/Einstein%E2%80%93Szil%C3%A1rd_letter" title="Einstein–Szilárd letter">a letter</a> to President <a href="/wiki/Franklin_D._Roosevelt" title="Franklin D. Roosevelt">Franklin D. Roosevelt</a> alerting him to the potential <a href="/wiki/German_nuclear_weapons_program" title="German nuclear weapons program">German nuclear weapons program</a> and recommending that the US begin <a href="/wiki/Manhattan_Project" title="Manhattan Project">similar research</a>. Einstein supported the <a href="/wiki/Allies_of_World_War_II" title="Allies of World War II">Allies</a>, but he generally denounced the idea of <a href="/wiki/Nuclear_weapons" class="mw-redirect" title="Nuclear weapons">nuclear weapons</a>.
</p>
<style data-mw-deduplicate="TemplateStyles:r886046785">.mw-parser-output .toclimit-2 .toclevel-1 ul,.mw-parser-output .toclimit-3 .toclevel-2 ul,.mw-parser-output .toclimit-4 .toclevel-3 ul,.mw-parser-output .toclimit-5 .toclevel-4 ul,.mw-parser-output .toclimit-6 .toclevel-5 ul,.mw-parser-output .toclimit-7 .toclevel-6 ul{display:none}</style><div class="toclimit-4"><div id="toc" class="toc" role="navigation" aria-labelledby="mw-toc-heading"><input type="checkbox" role="button" id="toctogglecheckbox" class="toctogglecheckbox" style="display:none" /><div class="toctitle" lang="en" dir="ltr"><h2 id="mw-toc-heading">Contents</h2><span class="toctogglespan"><label class="toctogglelabel" for="toctogglecheckbox"></label></span></div>
<ul>
<li class="toclevel-1 tocsection-1"><a href="#Life_and_career"><span class="tocnumber">1</span> <span class="toctext">Life and career</span></a>
<ul>
<li class="toclevel-2 tocsection-2"><a href="#Early_life_and_education"><span class="tocnumber">1.1</span> <span class="toctext">Early life and education</span></a></li>
<li class="toclevel-2 tocsection-3"><a href="#Marriages_and_children"><span class="tocnumber">1.2</span> <span class="toctext">Marriages and children</span></a></li>
<li class="toclevel-2 tocsection-4"><a href="#Patent_office"><span class="tocnumber">1.3</span> <span class="toctext">Patent office</span></a></li>
<li class="toclevel-2 tocsection-5"><a href="#First_scientific_papers"><span class="tocnumber">1.4</span> <span class="toctext">First scientific papers</span></a></li>
<li class="toclevel-2 tocsection-6"><a href="#Academic_career"><span class="tocnumber">1.5</span> <span class="toctext">Academic career</span></a></li>
<li class="toclevel-2 tocsection-7"><a href="#1921–1922:_Travels_abroad"><span class="tocnumber">1.6</span> <span class="toctext">1921–1922: Travels abroad</span></a></li>
<li class="toclevel-2 tocsection-8"><a href="#1930–1931:_Travel_to_the_US"><span class="tocnumber">1.7</span> <span class="toctext">1930–1931: Travel to the US</span></a></li>
<li class="toclevel-2 tocsection-9"><a href="#1933:_Emigration_to_the_US"><span class="tocnumber">1.8</span> <span class="toctext">1933: Emigration to the US</span></a>
<ul>
<li class="toclevel-3 tocsection-10"><a href="#Refugee_status"><span class="tocnumber">1.8.1</span> <span class="toctext">Refugee status</span></a></li>
<li class="toclevel-3 tocsection-11"><a href="#Resident_scholar_at_the_Institute_for_Advanced_Study"><span class="tocnumber">1.8.2</span> <span class="toctext">Resident scholar at the Institute for Advanced Study</span></a></li>
<li class="toclevel-3 tocsection-12"><a href="#World_War_II_and_the_Manhattan_Project"><span class="tocnumber">1.8.3</span> <span class="toctext">World War II and the Manhattan Project</span></a></li>
<li class="toclevel-3 tocsection-13"><a href="#US_citizenship"><span class="tocnumber">1.8.4</span> <span class="toctext">US citizenship</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-14"><a href="#Personal_life"><span class="tocnumber">1.9</span> <span class="toctext">Personal life</span></a>
<ul>
<li class="toclevel-3 tocsection-15"><a href="#Assisting_Zionist_causes"><span class="tocnumber">1.9.1</span> <span class="toctext">Assisting Zionist causes</span></a></li>
<li class="toclevel-3 tocsection-16"><a href="#Love_of_music"><span class="tocnumber">1.9.2</span> <span class="toctext">Love of music</span></a></li>
<li class="toclevel-3 tocsection-17"><a href="#Political_and_religious_views"><span class="tocnumber">1.9.3</span> <span class="toctext">Political and religious views</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-18"><a href="#Death"><span class="tocnumber">1.10</span> <span class="toctext">Death</span></a></li>
</ul>
</li>
<li class="toclevel-1 tocsection-19"><a href="#Scientific_career"><span class="tocnumber">2</span> <span class="toctext">Scientific career</span></a>
<ul>
<li class="toclevel-2 tocsection-20"><a href="#1905_–_Annus_Mirabilis_papers"><span class="tocnumber">2.1</span> <span class="toctext">1905 – <i>Annus Mirabilis</i> papers</span></a></li>
<li class="toclevel-2 tocsection-21"><a href="#Statistical_mechanics"><span class="tocnumber">2.2</span> <span class="toctext">Statistical mechanics</span></a>
<ul>
<li class="toclevel-3 tocsection-22"><a href="#Thermodynamic_fluctuations_and_statistical_physics"><span class="tocnumber">2.2.1</span> <span class="toctext">Thermodynamic fluctuations and statistical physics</span></a></li>
<li class="toclevel-3 tocsection-23"><a href="#Theory_of_critical_opalescence"><span class="tocnumber">2.2.2</span> <span class="toctext">Theory of critical opalescence</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-24"><a href="#Special_relativity"><span class="tocnumber">2.3</span> <span class="toctext">Special relativity</span></a></li>
<li class="toclevel-2 tocsection-25"><a href="#General_relativity"><span class="tocnumber">2.4</span> <span class="toctext">General relativity</span></a>
<ul>
<li class="toclevel-3 tocsection-26"><a href="#General_relativity_and_the_equivalence_principle"><span class="tocnumber">2.4.1</span> <span class="toctext">General relativity and the equivalence principle</span></a></li>
<li class="toclevel-3 tocsection-27"><a href="#Gravitational_waves"><span class="tocnumber">2.4.2</span> <span class="toctext">Gravitational waves</span></a></li>
<li class="toclevel-3 tocsection-28"><a href="#Hole_argument_and_Entwurf_theory"><span class="tocnumber">2.4.3</span> <span class="toctext">Hole argument and Entwurf theory</span></a></li>
<li class="toclevel-3 tocsection-29"><a href="#Physical_cosmology"><span class="tocnumber">2.4.4</span> <span class="toctext">Physical cosmology</span></a></li>
<li class="toclevel-3 tocsection-30"><a href="#Energy_momentum_pseudotensor"><span class="tocnumber">2.4.5</span> <span class="toctext">Energy momentum pseudotensor</span></a></li>
<li class="toclevel-3 tocsection-31"><a href="#Wormholes"><span class="tocnumber">2.4.6</span> <span class="toctext">Wormholes</span></a></li>
<li class="toclevel-3 tocsection-32"><a href="#Einstein–Cartan_theory"><span class="tocnumber">2.4.7</span> <span class="toctext">Einstein–Cartan theory</span></a></li>
<li class="toclevel-3 tocsection-33"><a href="#Equations_of_motion"><span class="tocnumber">2.4.8</span> <span class="toctext">Equations of motion</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-34"><a href="#Old_quantum_theory"><span class="tocnumber">2.5</span> <span class="toctext">Old quantum theory</span></a>
<ul>
<li class="toclevel-3 tocsection-35"><a href="#Photons_and_energy_quanta"><span class="tocnumber">2.5.1</span> <span class="toctext">Photons and energy quanta</span></a></li>
<li class="toclevel-3 tocsection-36"><a href="#Quantized_atomic_vibrations"><span class="tocnumber">2.5.2</span> <span class="toctext">Quantized atomic vibrations</span></a></li>
<li class="toclevel-3 tocsection-37"><a href="#Adiabatic_principle_and_action-angle_variables"><span class="tocnumber">2.5.3</span> <span class="toctext">Adiabatic principle and action-angle variables</span></a></li>
<li class="toclevel-3 tocsection-38"><a href="#Bose–Einstein_statistics"><span class="tocnumber">2.5.4</span> <span class="toctext">Bose–Einstein statistics</span></a></li>
<li class="toclevel-3 tocsection-39"><a href="#Wave–particle_duality"><span class="tocnumber">2.5.5</span> <span class="toctext">Wave–particle duality</span></a></li>
<li class="toclevel-3 tocsection-40"><a href="#Zero-point_energy"><span class="tocnumber">2.5.6</span> <span class="toctext">Zero-point energy</span></a></li>
<li class="toclevel-3 tocsection-41"><a href="#Stimulated_emission"><span class="tocnumber">2.5.7</span> <span class="toctext">Stimulated emission</span></a></li>
<li class="toclevel-3 tocsection-42"><a href="#Matter_waves"><span class="tocnumber">2.5.8</span> <span class="toctext">Matter waves</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-43"><a href="#Quantum_mechanics"><span class="tocnumber">2.6</span> <span class="toctext">Quantum mechanics</span></a>
<ul>
<li class="toclevel-3 tocsection-44"><a href="#Einstein&#39;s_objections_to_quantum_mechanics"><span class="tocnumber">2.6.1</span> <span class="toctext">Einstein\'s objections to quantum mechanics</span></a></li>
<li class="toclevel-3 tocsection-45"><a href="#Bohr_versus_Einstein"><span class="tocnumber">2.6.2</span> <span class="toctext">Bohr versus Einstein</span></a></li>
<li class="toclevel-3 tocsection-46"><a href="#Einstein–Podolsky–Rosen_paradox"><span class="tocnumber">2.6.3</span> <span class="toctext">Einstein–Podolsky–Rosen paradox</span></a></li>
</ul>
</li>
<li class="toclevel-2 tocsection-47"><a href="#Unified_field_theory"><span class="tocnumber">2.7</span> <span class="toctext">Unified field theory</span></a></li>
<li class="toclevel-2 tocsection-48"><a href="#Other_investigations"><span class="tocnumber">2.8</span> <span class="toctext">Other investigations</span></a></li>
<li class="toclevel-2 tocsection-49"><a href="#Collaboration_with_other_scientists"><span class="tocnumber">2.9</span> <span class="toctext">Collaboration with other scientists</span></a>
<ul>
<li class="toclevel-3 tocsection-50"><a href="#Einstein–de_Haas_experiment"><span class="tocnumber">2.9.1</span> <span class="toctext">Einstein–de Haas experiment</span></a></li>
<li class="toclevel-3 tocsection-51"><a href="#Schrödinger_gas_model"><span class="tocnumber">2.9.2</span> <span class="toctext">Schrödinger gas model</span></a></li>
<li class="toclevel-3 tocsection-52"><a href="#Einstein_refrigerator"><span class="tocnumber">2.9.3</span> <span class="toctext">Einstein refrigerator</span></a></li>
</ul>
</li>
</ul>
</li>
<li class="toclevel-1 tocsection-53"><a href="#Non-scientific_legacy"><span class="tocnumber">3</span> <span class="toctext">Non-scientific legacy</span></a></li>
<li class="toclevel-1 tocsection-54"><a href="#In_popular_culture"><span class="tocnumber">4</span> <span class="toctext">In popular culture</span></a></li>
<li class="toclevel-1 tocsection-55"><a href="#Awards_and_honors"><span class="tocnumber">5</span> <span class="toctext">Awards and honors</span></a></li>
<li class="toclevel-1 tocsection-56"><a href="#Publications"><span class="tocnumber">6</span> <span class="toctext">Publications</span></a>
<ul>
<li class="toclevel-2 tocsection-57"><a href="#Scientific"><span class="tocnumber">6.1</span> <span class="toctext">Scientific</span></a></li>
<li class="toclevel-2 tocsection-58"><a href="#Others"><span class="tocnumber">6.2</span> <span class="toctext">Others</span></a></li>
</ul>
</li>
<li class="toclevel-1 tocsection-59"><a href="#See_also"><span class="tocnumber">7</span> <span class="toctext">See also</span></a></li>
<li class="toclevel-1 tocsection-60"><a href="#References"><span class="tocnumber">8</span> <span class="toctext">References</span></a>
<ul>
<li class="toclevel-2 tocsection-61"><a href="#Works_cited"><span class="tocnumber">8.1</span> <span class="toctext">Works cited</span></a></li>
</ul>
</li>
<li class="toclevel-1 tocsection-62"><a href="#Further_reading"><span class="tocnumber">9</span> <span class="toctext">Further reading</span></a></li>
<li class="toclevel-1 tocsection-63"><a href="#External_links"><span class="tocnumber">10</span> <span class="toctext">External links</span></a></li>
</ul>
</div>
</div>
<h2><span class="mw-headline" id="Life_and_career">Life and career</span></h2>
<h3><span class="mw-headline" id="Early_life_and_education">Early life and education</span></h3>
<div role="note" class="hatnote navigation-not-searchable">See also: <a href="/wiki/Einstein_family" title="Einstein family">Einstein family</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_at_the_age_of_three_(1882).jpg" class="image"><img alt="A young boy with short hair and a round face, wearing a white collar and large bow, with vest, coat, skirt, and high boots. He is leaning against an ornate chair." src="//upload.wikimedia.org/wikipedia/commons/thumb/f/fb/Albert_Einstein_at_the_age_of_three_%281882%29.jpg/170px-Albert_Einstein_at_the_age_of_three_%281882%29.jpg" decoding="async" width="170" height="246" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/f/fb/Albert_Einstein_at_the_age_of_three_%281882%29.jpg/255px-Albert_Einstein_at_the_age_of_three_%281882%29.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fb/Albert_Einstein_at_the_age_of_three_%281882%29.jpg/340px-Albert_Einstein_at_the_age_of_three_%281882%29.jpg 2x" data-file-width="414" data-file-height="600" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_at_the_age_of_three_(1882).jpg" class="internal" title="Enlarge"></a></div>Einstein at the age of three in 1882</div></div></div>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><div class="mediaContainer" style="width:220px"><audio id="mwe_player_0" controls="" preload="none" style="width:220px" class="kskin thumbimage" data-durationhint="90.24" data-startoffset="0" data-mwtitle="03_ALBERT_EINSTEIN.ogg" data-mwprovider="wikimediacommons"><source src="//upload.wikimedia.org/wikipedia/commons/4/46/03_ALBERT_EINSTEIN.ogg" type="audio/ogg; codecs=&quot;vorbis&quot;" data-title="Original Ogg file (70 kbps)" data-shorttitle="Ogg source" data-width="0" data-height="0" data-bandwidth="69534" /><source src="//upload.wikimedia.org/wikipedia/commons/transcoded/4/46/03_ALBERT_EINSTEIN.ogg/03_ALBERT_EINSTEIN.ogg.mp3" type="audio/mpeg" data-title="MP3" data-shorttitle="MP3" data-transcodekey="mp3" data-width="0" data-height="0" data-bandwidth="115000" /></audio></div>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:03_ALBERT_EINSTEIN.ogg" class="internal" title="Enlarge"></a></div>Start of a speech by Albert Einstein made on 11 April 1943 for the United Jewish Appeal (recording by Radio Universidad Nacional de La Plata, Argentina) <hr /> "Ladies (coughs) and gentlemen, our age is proud of the progress it has made in man\'s intellectual development. The search and striving for truth and knowledge is one of the highest of man\'s qualities ..."</div></div></div>
<p>Albert Einstein was born in <a href="/wiki/Ulm" title="Ulm">Ulm</a>,<sup id="cite_ref-Bio_6-1" class="reference"><a href="#cite_note-Bio-6">&#91;5&#93;</a></sup> in the <a href="/wiki/Kingdom_of_W%C3%BCrttemberg" title="Kingdom of Württemberg">Kingdom of Württemberg</a> in the <a href="/wiki/German_Empire" title="German Empire">German Empire</a>, on 14 March 1879 into a family of secular <a href="/wiki/Ashkenazi_Jews" title="Ashkenazi Jews">Ashkenazi Jews</a>.<sup id="cite_ref-18" class="reference"><a href="#cite_note-18">&#91;17&#93;</a></sup><sup id="cite_ref-19" class="reference"><a href="#cite_note-19">&#91;18&#93;</a></sup> His parents were <a href="/wiki/Hermann_Einstein" class="mw-redirect" title="Hermann Einstein">Hermann Einstein</a>, a salesman and engineer, and <a href="/wiki/Pauline_Koch" class="mw-redirect" title="Pauline Koch">Pauline Koch</a>. In 1880, the family moved to <a href="/wiki/Munich" title="Munich">Munich</a>, where Einstein\'s father and his uncle Jakob founded <i>Elektrotechnische Fabrik J. Einstein &amp; Cie</i>, a company that manufactured electrical equipment based on <a href="/wiki/Direct_current" title="Direct current">direct current</a>.<sup id="cite_ref-Bio_6-2" class="reference"><a href="#cite_note-Bio-6">&#91;5&#93;</a></sup>
</p><p>Albert attended a <a href="/wiki/Catholic_school" title="Catholic school">Catholic elementary school</a> in Munich, from the age of five, for three years. At the age of eight, he was transferred to the Luitpold Gymnasium (now known as the Albert Einstein Gymnasium), where he received advanced primary and secondary school education until he left the <a href="/wiki/German_Empire" title="German Empire">German Empire</a> seven years later.<sup id="cite_ref-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA59_59–61&#93;_20-0" class="reference"><a href="#cite_note-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA59_59–61]-20">&#91;19&#93;</a></sup>
</p><p>In 1894, Hermann and Jakob\'s company lost a bid to supply the city of Munich with electrical lighting because they lacked the capital to convert their equipment from the direct current (DC) standard to the more efficient <a href="/wiki/Alternating_current" title="Alternating current">alternating current</a> (AC) standard.<sup id="cite_ref-EQyag_21-0" class="reference"><a href="#cite_note-EQyag-21">&#91;20&#93;</a></sup> The loss forced the sale of the Munich factory. In search of business, the Einstein family moved to Italy, first to <a href="/wiki/Milan" title="Milan">Milan</a> and a few months later to <a href="/wiki/Pavia" title="Pavia">Pavia</a>. When the family moved to Pavia, Einstein, then 15, stayed in Munich to finish his studies at the Luitpold Gymnasium. His father intended for him to pursue <a href="/wiki/Electrical_engineering" title="Electrical engineering">electrical engineering</a>, but Einstein clashed with the authorities and resented the school\'s regimen and teaching method. He later wrote that the spirit of learning and creative thought was lost in strict <a href="/wiki/Rote_learning" title="Rote learning">rote learning</a>. At the end of December 1894, he traveled to Italy to join his family in Pavia, convincing the school to let him go by using a doctor\'s note.<sup id="cite_ref-FOOTNOTEFölsing199730–31_22-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing199730–31-22">&#91;21&#93;</a></sup> During his time in Italy he wrote a short essay with the title "On the Investigation of the State of the <a href="/wiki/Aether_(classical_element)" title="Aether (classical element)">Ether</a> in a Magnetic Field".<sup id="cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._5_23-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._5-23">&#91;22&#93;</a></sup><sup id="cite_ref-1RgTv_24-0" class="reference"><a href="#cite_note-1RgTv-24">&#91;23&#93;</a></sup>
</p><p>Einstein excelled at math and physics from a young age, reaching a mathematical level years ahead of his peers. The 12-year-old Einstein taught himself algebra and Euclidean geometry over a single summer.<sup id="cite_ref-25" class="reference"><a href="#cite_note-25">&#91;24&#93;</a></sup> Einstein also independently discovered his own original proof of the <a href="/wiki/Pythagorean_theorem" title="Pythagorean theorem">Pythagorean theorem</a> at age 12.<sup id="cite_ref-FVfDU_26-0" class="reference"><a href="#cite_note-FVfDU-26">&#91;25&#93;</a></sup> A family tutor Max Talmud says that after he had given the 12-year-old Einstein a geometry textbook, after a short time "[Einstein] had worked through the whole book. He thereupon devoted himself to higher mathematics... Soon the flight of his mathematical genius was so high I could not follow."<sup id="cite_ref-FOOTNOTEIsaacson200717_27-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200717-27">&#91;26&#93;</a></sup> His passion for geometry and algebra led the 12-year-old to become convinced that nature could be understood as a "mathematical structure".<sup id="cite_ref-FOOTNOTEIsaacson200717_27-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200717-27">&#91;26&#93;</a></sup> Einstein started teaching himself calculus at 12, and as a 14-year-old he says he had "mastered <a href="/wiki/Integral_calculus" class="mw-redirect" title="Integral calculus">integral</a> and <a href="/wiki/Differential_calculus" title="Differential calculus">differential calculus</a>".<sup id="cite_ref-FOOTNOTEIsaacson200716_28-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200716-28">&#91;27&#93;</a></sup>
</p>
<div class="thumb tleft"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_as_a_child.jpg" class="image"><img alt="Studio photo of a boy seated in a relaxed posture and wearing a suit, posed in front of a backdrop of scenery." src="//upload.wikimedia.org/wikipedia/commons/thumb/a/ad/Albert_Einstein_as_a_child.jpg/170px-Albert_Einstein_as_a_child.jpg" decoding="async" width="170" height="239" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/a/ad/Albert_Einstein_as_a_child.jpg/255px-Albert_Einstein_as_a_child.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/a/ad/Albert_Einstein_as_a_child.jpg/340px-Albert_Einstein_as_a_child.jpg 2x" data-file-width="379" data-file-height="533" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_as_a_child.jpg" class="internal" title="Enlarge"></a></div>Albert Einstein in 1893 (age&#160;14)</div></div></div>
<p>At age 13, when he had become more seriously interested in philosophy (and music),<sup id="cite_ref-FOOTNOTECalapriceLipscombe20058_29-0" class="reference"><a href="#cite_note-FOOTNOTECalapriceLipscombe20058-29">&#91;28&#93;</a></sup> Einstein was introduced to <a href="/wiki/Immanuel_Kant" title="Immanuel Kant">Kant</a>\'s <i><a href="/wiki/Critique_of_Pure_Reason" title="Critique of Pure Reason">Critique of Pure Reason</a></i>. Kant became his favorite philosopher, his tutor stating: "At the time he was still a child, only thirteen years old, yet Kant\'s works, incomprehensible to ordinary mortals, seemed to be clear to him."<sup id="cite_ref-FOOTNOTEIsaacson200717_27-2" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200717-27">&#91;26&#93;</a></sup>
</p><p>In 1895, at the age of 16, Einstein took the entrance examinations for the <a href="/wiki/ETH_Zurich" title="ETH Zurich">Swiss Federal Polytechnic School</a> in <a href="/wiki/Z%C3%BCrich" title="Zürich">Zürich</a> (later the Eidgenössische Technische Hochschule, ETH). He failed to reach the required standard in the general part of the examination,<sup id="cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_p._11_30-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_p._11-30">&#91;29&#93;</a></sup> but obtained exceptional grades in physics and mathematics.<sup id="cite_ref-FOOTNOTEFölsing199736–37_31-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing199736–37-31">&#91;30&#93;</a></sup> On the advice of the principal of the polytechnic school, he attended the <a href="/wiki/Old_Cantonal_School_Aarau" title="Old Cantonal School Aarau">Argovian cantonal school</a> (<a href="/wiki/Gymnasium_(school)" title="Gymnasium (school)">gymnasium</a>) in <a href="/wiki/Aarau" title="Aarau">Aarau</a>, Switzerland, in 1895 and 1896 to complete his secondary schooling. While lodging with the family of professor <a href="/wiki/Jost_Winteler" title="Jost Winteler">Jost Winteler</a>, he fell in love with Winteler\'s daughter, Marie. Albert\'s sister <a href="/wiki/Maja_Einstein" class="mw-redirect" title="Maja Einstein">Maja</a> later married Winteler\'s son Paul.<sup id="cite_ref-FOOTNOTEHighfieldCarter199321,_31,_56–57_32-0" class="reference"><a href="#cite_note-FOOTNOTEHighfieldCarter199321,_31,_56–57-32">&#91;31&#93;</a></sup> In January 1896, with his father\'s approval, Einstein renounced his <a href="/wiki/German_citizenship" class="mw-redirect" title="German citizenship">citizenship in the German Kingdom of Württemberg</a> to avoid <a href="/wiki/Conscription_in_Germany" title="Conscription in Germany">military service</a>.<sup id="cite_ref-FOOTNOTEFölsing199740_33-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing199740-33">&#91;32&#93;</a></sup> In September 1896, he passed the Swiss <a href="/wiki/Matura" title="Matura">Matura</a> with mostly good grades, including a top grade of 6 in physics and mathematical subjects, on <a href="/wiki/Grading_systems_by_country#Switzerland" title="Grading systems by country">a scale of 1–6</a>.<sup id="cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_docs._21–27_34-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_docs._21–27-34">&#91;33&#93;</a></sup> At 17, he enrolled in the four-year mathematics and physics teaching diploma program at the Zürich polytechnic school. Marie Winteler, who was a year older, moved to <a href="/wiki/Olsberg,_Aargau" title="Olsberg, Aargau">Olsberg</a>, Switzerland, for a teaching post.<sup id="cite_ref-FOOTNOTEHighfieldCarter199321,_31,_56–57_32-1" class="reference"><a href="#cite_note-FOOTNOTEHighfieldCarter199321,_31,_56–57-32">&#91;31&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein%27s_exam_of_maturity_grades_(color2).jpg" class="image"><img alt="Einstein&#39;s matriculation certificate at the age of 17. The heading translates as &quot;The Education Committee of the Canton of Aargau&quot;. His scores were German 5, French 3, Italian 5, History 6, Geography 4, Algebra 6, Geometry 6, Descriptive Geometry 6, Physics 6, Chemistry 5, Natural History 5, Art Drawing 4, Technical Drawing 4. 6 = very good, 5 = good, 4 = sufficient, 3 = insufficient, 2 = poor, 1 = very poor." src="//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg/170px-Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg" decoding="async" width="170" height="278" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg/255px-Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg/340px-Albert_Einstein%27s_exam_of_maturity_grades_%28color2%29.jpg 2x" data-file-width="1479" data-file-height="2419" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein%27s_exam_of_maturity_grades_(color2).jpg" class="internal" title="Enlarge"></a></div>Einstein\'s <a href="/wiki/Matura" title="Matura">matriculation</a> certificate<sup id="cite_ref-6Ar1y_35-0" class="reference"><a href="#cite_note-6Ar1y-35">&#91;note 2&#93;</a></sup></div></div></div>
<p>Einstein\'s future wife, a 20-year-old <a href="/wiki/Serbs" title="Serbs">Serbian</a> named <a href="/wiki/Mileva_Mari%C4%87" title="Mileva Marić">Mileva Marić</a>, also enrolled at the polytechnic school that year. She was the only woman among the six students in the mathematics and physics section of the teaching diploma course. Over the next few years, Einstein\'s and Marić\'s friendship developed into a romance, and they spent countless hours debating and reading books together on extra-curricular physics in which they were both interested. Einstein wrote in his letters to Marić that he preferred studying alongside her.<sup id="cite_ref-mileva_36-0" class="reference"><a href="#cite_note-mileva-36">&#91;34&#93;</a></sup> In 1900, Einstein passed the exams in Maths and Physics and was awarded the Federal teaching diploma.<sup id="cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._67_37-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._67-37">&#91;35&#93;</a></sup> There is eyewitness evidence and several letters over many years that indicate Marić might have collaborated with Einstein prior to his 1905 papers,<sup id="cite_ref-mileva_36-1" class="reference"><a href="#cite_note-mileva-36">&#91;34&#93;</a></sup><sup id="cite_ref-7HA7H_38-0" class="reference"><a href="#cite_note-7HA7H-38">&#91;36&#93;</a></sup><sup id="cite_ref-1zJdH_39-0" class="reference"><a href="#cite_note-1zJdH-39">&#91;37&#93;</a></sup> known as the <a href="/wiki/Annus_Mirabilis_papers" title="Annus Mirabilis papers"><i>Annus Mirabilis</i> papers</a>, and that they developed some of the concepts together during their studies, although some historians of physics who have studied the issue disagree that she made any substantive contributions.<sup id="cite_ref-FOOTNOTEPais19941–29_40-0" class="reference"><a href="#cite_note-FOOTNOTEPais19941–29-40">&#91;38&#93;</a></sup><sup id="cite_ref-xKrMG_41-0" class="reference"><a href="#cite_note-xKrMG-41">&#91;39&#93;</a></sup><sup id="cite_ref-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA49_49–56&#93;_42-0" class="reference"><a href="#cite_note-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA49_49–56]-42">&#91;40&#93;</a></sup><sup id="cite_ref-dUxMl_43-0" class="reference"><a href="#cite_note-dUxMl-43">&#91;41&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="Marriages_and_children">Marriages and children</span></h3>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Albert_Einstein_and_his_wife_Mileva_Maric.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/87/Albert_Einstein_and_his_wife_Mileva_Maric.jpg/220px-Albert_Einstein_and_his_wife_Mileva_Maric.jpg" decoding="async" width="220" height="152" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/87/Albert_Einstein_and_his_wife_Mileva_Maric.jpg/330px-Albert_Einstein_and_his_wife_Mileva_Maric.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/87/Albert_Einstein_and_his_wife_Mileva_Maric.jpg/440px-Albert_Einstein_and_his_wife_Mileva_Maric.jpg 2x" data-file-width="3324" data-file-height="2300" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_and_his_wife_Mileva_Maric.jpg" class="internal" title="Enlarge"></a></div>Albert and <a href="/wiki/Mileva_Mari%C4%87" title="Mileva Marić">Mileva Marić</a> Einstein, 1912</div></div></div>
<p>Early correspondence between Einstein and Marić was discovered and published in 1987 which revealed that the couple had a daughter named <a href="/wiki/Lieserl_Einstein" class="mw-redirect" title="Lieserl Einstein">"Lieserl"</a>, born in early 1902 in <a href="/wiki/Novi_Sad" title="Novi Sad">Novi Sad</a> where Marić was staying with her parents. Marić returned to Switzerland without the child, whose real name and fate are unknown. The contents of Einstein\'s letter in September 1903 suggest that the girl was either given up for adoption or died of <a href="/wiki/Scarlet_fever" title="Scarlet fever">scarlet fever</a> in infancy.<sup id="cite_ref-HBMes_44-0" class="reference"><a href="#cite_note-HBMes-44">&#91;42&#93;</a></sup><sup id="cite_ref-FOOTNOTECalapriceLipscombe200522–23_45-0" class="reference"><a href="#cite_note-FOOTNOTECalapriceLipscombe200522–23-45">&#91;43&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Einstein_Albert_Elsa_LOC_32096u.jpg" class="image"><img alt="Einstein, looking relaxed and holding a pipe, stands next to a smiling, well-dressed Elsa who is wearing a fancy hat and fur wrap. She is looking at him." src="//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Einstein_Albert_Elsa_LOC_32096u.jpg/220px-Einstein_Albert_Elsa_LOC_32096u.jpg" decoding="async" width="220" height="190" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/3/38/Einstein_Albert_Elsa_LOC_32096u.jpg/330px-Einstein_Albert_Elsa_LOC_32096u.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/38/Einstein_Albert_Elsa_LOC_32096u.jpg/440px-Einstein_Albert_Elsa_LOC_32096u.jpg 2x" data-file-width="1200" data-file-height="1038" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein_Albert_Elsa_LOC_32096u.jpg" class="internal" title="Enlarge"></a></div>Einstein with his second wife, Elsa, in 1921</div></div></div>
<p>Einstein and Marić married in January 1903. In May 1904, their son <a href="/wiki/Hans_Albert_Einstein" title="Hans Albert Einstein">Hans Albert Einstein</a> was born in <a href="/wiki/Bern" title="Bern">Bern</a>, Switzerland. Their son <a href="/wiki/Einstein_family#Eduard_&quot;Tete&quot;_Einstein_(Albert&#39;s_son)" title="Einstein family">Eduard</a> was born in Zürich in July 1910. The couple moved to Berlin in April 1914, but Marić returned to Zürich with their sons after learning that despite their close relationship before,<sup id="cite_ref-mileva_36-2" class="reference"><a href="#cite_note-mileva-36">&#91;34&#93;</a></sup> Einstein\'s chief romantic attraction was now his cousin <a href="/wiki/Elsa_Einstein" title="Elsa Einstein">Elsa Löwenthal</a>;<sup id="cite_ref-FOOTNOTEStachel1966_46-0" class="reference"><a href="#cite_note-FOOTNOTEStachel1966-46">&#91;44&#93;</a></sup> she was his first cousin maternally and the second cousin paternally.<sup id="cite_ref-FOOTNOTECalapriceLipscombe2005&#91;httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50&#93;_47-0" class="reference"><a href="#cite_note-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50]-47">&#91;45&#93;</a></sup> They divorced on 14 February 1919, having lived apart for five years.<sup id="cite_ref-48" class="reference"><a href="#cite_note-48">&#91;46&#93;</a></sup><sup id="cite_ref-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA50_50&#93;_49-0" class="reference"><a href="#cite_note-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA50_50]-49">&#91;47&#93;</a></sup> As part of the divorce settlement, Einstein transferred his Nobel Prize fund to Marić when he won it.<sup id="cite_ref-50" class="reference"><a href="#cite_note-50">&#91;48&#93;</a></sup> Eduard had a breakdown at about age 20 and was diagnosed with <a href="/wiki/Schizophrenia" title="Schizophrenia">schizophrenia</a>.<sup id="cite_ref-Robinson2015a_51-0" class="reference"><a href="#cite_note-Robinson2015a-51">&#91;49&#93;</a></sup> His mother cared for him and he was also committed to asylums for several periods, finally being committed permanently after her death.<sup id="cite_ref-FOOTNOTENeffe2007&#91;httpsarchiveorgdetailseinsteinbiograph00neffpage203_203&#93;_52-0" class="reference"><a href="#cite_note-FOOTNOTENeffe2007[httpsarchiveorgdetailseinsteinbiograph00neffpage203_203]-52">&#91;50&#93;</a></sup>
</p><p>In letters revealed in 2015, Einstein wrote to his early love Marie Winteler about his marriage and his strong feelings for her. He wrote in 1910, while his wife was pregnant with their second child: "I think of you in heartfelt love every spare minute and am so unhappy as only a man can be." He spoke about a "misguided love" and a "missed life" regarding his love for Marie.<sup id="cite_ref-MlQLY_53-0" class="reference"><a href="#cite_note-MlQLY-53">&#91;51&#93;</a></sup>
</p><p>Einstein married Elsa Löwenthal in 1919,<sup id="cite_ref-FOOTNOTEIsaacson2007&#91;&#91;Category:Wikipedia_articles_needing_page_number_citations_from_November_2020&#93;&#93;&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;&#91;&#91;Wikipedia:Citing_sources&#124;&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;&#93;&#93;&lt;/i&gt;&amp;#93;&lt;/sup&gt;_54-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007[[Category:Wikipedia_articles_needing_page_number_citations_from_November_2020]]&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;[[Wikipedia:Citing_sources|&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;]]&lt;/i&gt;&amp;#93;&lt;/sup&gt;-54">&#91;52&#93;</a></sup><sup id="cite_ref-FOOTNOTECalapriceKennefickSchulmann201562_55-0" class="reference"><a href="#cite_note-FOOTNOTECalapriceKennefickSchulmann201562-55">&#91;53&#93;</a></sup> after having a relationship with her since 1912.<sup id="cite_ref-FOOTNOTECalapriceLipscombe2005&#91;httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50&#93;_47-1" class="reference"><a href="#cite_note-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50]-47">&#91;45&#93;</a></sup> They emigrated to the United States in 1933. Elsa was diagnosed with heart and kidney problems in 1935 and died in December 1936.<sup id="cite_ref-FOOTNOTEHighfieldCarter1993216_56-0" class="reference"><a href="#cite_note-FOOTNOTEHighfieldCarter1993216-56">&#91;54&#93;</a></sup>
</p><p>In 1923, Einstein fell in love with a secretary named Betty Neumann, the niece of a close friend, Hans Mühsam.<sup id="cite_ref-57" class="reference"><a href="#cite_note-57">&#91;55&#93;</a></sup><sup id="cite_ref-58" class="reference"><a href="#cite_note-58">&#91;56&#93;</a></sup><sup id="cite_ref-59" class="reference"><a href="#cite_note-59">&#91;57&#93;</a></sup><sup id="cite_ref-60" class="reference"><a href="#cite_note-60">&#91;58&#93;</a></sup> In a volume of letters released by <a href="/wiki/Hebrew_University_of_Jerusalem" title="Hebrew University of Jerusalem">Hebrew University of Jerusalem</a> in 2006,<sup id="cite_ref-61" class="reference"><a href="#cite_note-61">&#91;59&#93;</a></sup> Einstein described about six women, including Margarete Lebach (a blonde Austrian), Estella Katzenellenbogen (the rich owner of a florist business), Toni Mendel (a wealthy Jewish widow) and Ethel Michanowski (a Berlin socialite), with whom he spent time and from whom he received gifts while being married to Elsa.<sup id="cite_ref-62" class="reference"><a href="#cite_note-62">&#91;60&#93;</a></sup><sup id="cite_ref-63" class="reference"><a href="#cite_note-63">&#91;61&#93;</a></sup> Later, after the death of his second wife Elsa, Einstein was briefly in a relationship with Margarita Konenkova.<sup id="cite_ref-64" class="reference"><a href="#cite_note-64">&#91;62&#93;</a></sup> Konenkova was a Russian spy who was married to the noted Russian sculptor <a href="/wiki/Sergei_Konenkov" class="mw-redirect" title="Sergei Konenkov">Sergei Konenkov</a> (who created the bronze bust of Einstein at the <a href="/wiki/Institute_for_Advanced_Study" title="Institute for Advanced Study">Institute for Advanced Study</a> at Princeton).<sup id="cite_ref-65" class="reference"><a href="#cite_note-65">&#91;63&#93;</a></sup><sup id="cite_ref-66" class="reference"><a href="#cite_note-66">&#91;64&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="Patent_office">Patent office</span></h3>
<div class="thumb tleft"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Einstein_patentoffice.jpg" class="image"><img alt="Head and shoulders shot of a young, moustached man with dark, curly hair wearing a plaid suit and vest, striped shirt, and a dark tie." src="//upload.wikimedia.org/wikipedia/commons/thumb/a/a0/Einstein_patentoffice.jpg/170px-Einstein_patentoffice.jpg" decoding="async" width="170" height="222" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/a/a0/Einstein_patentoffice.jpg/255px-Einstein_patentoffice.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/a/a0/Einstein_patentoffice.jpg/340px-Einstein_patentoffice.jpg 2x" data-file-width="666" data-file-height="870" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein_patentoffice.jpg" class="internal" title="Enlarge"></a></div>Albert Einstein in 1904 (age&#160;25)</div></div></div>
<p>After graduating in 1900, Einstein spent almost two frustrating years searching for a teaching post. He acquired <a href="/wiki/Switzerland" title="Switzerland">Swiss</a> citizenship in February 1901,<sup id="cite_ref-FOOTNOTEFölsing199782_67-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing199782-67">&#91;65&#93;</a></sup> but for medical reasons was not <a href="/wiki/Conscription_in_Switzerland" title="Conscription in Switzerland">conscripted</a>. With the help of <a href="/wiki/Marcel_Grossmann" title="Marcel Grossmann">Marcel Grossmann</a>\'s father, he secured a job in <a href="/wiki/Bern" title="Bern">Bern</a> at the <a href="/wiki/Swiss_Federal_Institute_of_Intellectual_Property" title="Swiss Federal Institute of Intellectual Property">Federal Office for Intellectual Property</a>, the patent office,<sup id="cite_ref-ODY5p_68-0" class="reference"><a href="#cite_note-ODY5p-68">&#91;66&#93;</a></sup><sup id="cite_ref-FOOTNOTEIsaacson200763_69-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200763-69">&#91;67&#93;</a></sup> as an <a href="/wiki/Patent_examiner" title="Patent examiner">assistant examiner – level III</a>.<sup id="cite_ref-MeZPN_70-0" class="reference"><a href="#cite_note-MeZPN-70">&#91;68&#93;</a></sup><sup id="cite_ref-IGEFAQ_71-0" class="reference"><a href="#cite_note-IGEFAQ-71">&#91;69&#93;</a></sup>
</p><p>Einstein evaluated <a href="/wiki/Patent_application" title="Patent application">patent applications</a> for a variety of devices including a gravel sorter and an electromechanical typewriter.<sup id="cite_ref-IGEFAQ_71-1" class="reference"><a href="#cite_note-IGEFAQ-71">&#91;69&#93;</a></sup> In 1903, his position at the Swiss Patent Office became permanent, although he was passed over for promotion until he "fully mastered machine technology".<sup id="cite_ref-FOOTNOTEGalison2000370_72-0" class="reference"><a href="#cite_note-FOOTNOTEGalison2000370-72">&#91;70&#93;</a></sup>
</p><p>Much of his work at the patent office related to questions about transmission of electric signals and electrical-mechanical synchronization of time, two technical problems that show up conspicuously in the <a href="/wiki/Einstein%27s_thought_experiments" title="Einstein&#39;s thought experiments">thought experiments</a> that eventually led Einstein to his radical conclusions about the nature of light and the fundamental connection between space and time.<sup id="cite_ref-FOOTNOTEGalison2000377_73-0" class="reference"><a href="#cite_note-FOOTNOTEGalison2000377-73">&#91;71&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:232px;"><a href="/wiki/File:Einstein-with-habicht-and-solovine.jpg" class="image"><img alt="Three young men in suits with high white collars and bow ties, sitting." src="//upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Einstein-with-habicht-and-solovine.jpg/230px-Einstein-with-habicht-and-solovine.jpg" decoding="async" width="230" height="151" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Einstein-with-habicht-and-solovine.jpg/345px-Einstein-with-habicht-and-solovine.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/d7/Einstein-with-habicht-and-solovine.jpg/460px-Einstein-with-habicht-and-solovine.jpg 2x" data-file-width="4672" data-file-height="3066" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein-with-habicht-and-solovine.jpg" class="internal" title="Enlarge"></a></div><a href="/wiki/Olympia_Academy" title="Olympia Academy">Olympia Academy</a> founders: <a href="/wiki/Conrad_Habicht" title="Conrad Habicht">Conrad Habicht</a>, <a href="/wiki/Maurice_Solovine" title="Maurice Solovine">Maurice Solovine</a> and Einstein</div></div></div>
<p>With a few friends he had met in Bern, Einstein started a small discussion group in 1902, self-mockingly named "<a href="/wiki/Olympia_Academy" title="Olympia Academy">The Olympia Academy</a>", which met regularly to discuss science and philosophy. Sometimes they were joined by Mileva who attentively listened but did not participate.<sup id="cite_ref-FOOTNOTEHighfieldCarter199396–98_74-0" class="reference"><a href="#cite_note-FOOTNOTEHighfieldCarter199396–98-74">&#91;72&#93;</a></sup> Their readings included the works of <a href="/wiki/Henri_Poincar%C3%A9" title="Henri Poincaré">Henri Poincaré</a>, <a href="/wiki/Ernst_Mach" title="Ernst Mach">Ernst Mach</a>, and <a href="/wiki/David_Hume" title="David Hume">David Hume</a>, which influenced his scientific and philosophical outlook.<sup id="cite_ref-FOOTNOTEIsaacson200779–84_75-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson200779–84-75">&#91;73&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="First_scientific_papers">First scientific papers</span></h3>
<p>In 1900, Einstein\'s paper <a href="/wiki/List_of_scientific_publications_by_Albert_Einstein#Journal_articles" title="List of scientific publications by Albert Einstein">"Folgerungen aus den Capillaritätserscheinungen"</a> ("Conclusions from the Capillarity Phenomena") was published in the journal <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i>.<sup id="cite_ref-FOOTNOTEEinstein1901_76-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1901-76">&#91;74&#93;</a></sup><sup id="cite_ref-SdDhS_77-0" class="reference"><a href="#cite_note-SdDhS-77">&#91;75&#93;</a></sup> On 30 April 1905, Einstein completed his thesis,<sup id="cite_ref-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;_78-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;-78">&#91;76&#93;</a></sup> with <a href="/wiki/Alfred_Kleiner" title="Alfred Kleiner">Alfred Kleiner</a>, Professor of Experimental Physics, serving as <i><a href="/wiki/Pro_forma" title="Pro forma">pro-forma</a></i> advisor. As a result, Einstein was awarded a PhD by the <a href="/wiki/University_of_Z%C3%BCrich" class="mw-redirect" title="University of Zürich">University of Zürich</a>, with his dissertation <i>A New Determination of Molecular Dimensions</i>.<sup id="cite_ref-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;_78-1" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;-78">&#91;76&#93;</a></sup><sup id="cite_ref-FOOTNOTEEinstein1926bchap._&quot;A_New_Determination_of_Molecular_Dimensions&quot;_79-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1926bchap._&quot;A_New_Determination_of_Molecular_Dimensions&quot;-79">&#91;77&#93;</a></sup>
</p><p>Also in 1905, which has been called Einstein\'s <i><a href="/wiki/Annus_mirabilis" title="Annus mirabilis">annus mirabilis</a></i> (amazing year), he published <a href="/wiki/Annus_Mirabilis_papers" title="Annus Mirabilis papers">four groundbreaking papers</a>, on the <a href="/wiki/Photoelectric_effect" title="Photoelectric effect">photoelectric effect</a>, <a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a>, <a href="/wiki/Special_relativity" title="Special relativity">special relativity</a>, and the <a href="/wiki/Equivalence_of_mass_and_energy" class="mw-redirect" title="Equivalence of mass and energy">equivalence of mass and energy</a>, which were to bring him to the notice of the academic world, at the age of 26.
</p>
<h3><span class="mw-headline" id="Academic_career">Academic career</span></h3>
<p>By 1908, he was recognized as a leading scientist and was appointed lecturer at the <a href="/wiki/University_of_Bern" title="University of Bern">University of Bern</a>. The following year, after he gave a lecture on <a href="/wiki/Electrodynamics" class="mw-redirect" title="Electrodynamics">electrodynamics</a> and the relativity principle at the University of Zurich, <a href="/wiki/Alfred_Kleiner" title="Alfred Kleiner">Alfred Kleiner</a> recommended him to the faculty for a newly created professorship in theoretical physics. Einstein was appointed associate professor in 1909.<sup id="cite_ref-bG2yp_80-0" class="reference"><a href="#cite_note-bG2yp-80">&#91;78&#93;</a></sup>
</p><p>Einstein became a full professor at the German <a href="/wiki/Charles-Ferdinand_University" class="mw-redirect" title="Charles-Ferdinand University">Charles-Ferdinand University</a> in <a href="/wiki/Prague" title="Prague">Prague</a> in April 1911, accepting <a href="/wiki/Cisleithania" title="Cisleithania">Austrian</a> citizenship in the <a href="/wiki/Austria-Hungary" title="Austria-Hungary">Austro-Hungarian Empire</a> to do so.<sup id="cite_ref-FOOTNOTEIsaacson2007164_81-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007164-81">&#91;79&#93;</a></sup><sup id="cite_ref-Itl8r_82-0" class="reference"><a href="#cite_note-Itl8r-82">&#91;80&#93;</a></sup> During his Prague stay, he wrote 11 scientific works, five of them on radiation mathematics and on the quantum theory of solids. In July 1912, he returned to his alma mater in Zürich. From 1912 until 1914, he was a professor of theoretical physics at the <a href="/wiki/ETH_Zurich" title="ETH Zurich">ETH Zurich</a>, where he taught analytical mechanics and <a href="/wiki/Thermodynamics" title="Thermodynamics">thermodynamics</a>. He also studied <a href="/wiki/Continuum_mechanics" title="Continuum mechanics">continuum mechanics</a>, the molecular theory of heat, and the problem of gravitation, on which he worked with mathematician and friend <a href="/wiki/Marcel_Grossmann" title="Marcel Grossmann">Marcel Grossmann</a>.<sup id="cite_ref-hXQin_83-0" class="reference"><a href="#cite_note-hXQin-83">&#91;81&#93;</a></sup>
</p><p>When the "<a href="/wiki/Manifesto_of_the_Ninety-Three" title="Manifesto of the Ninety-Three">Manifesto of the Ninety-Three</a>" was published in October 1914—a document signed by a host of prominent German intellectuals that justified Germany\'s militarism and position during the First World War—Einstein was one of the few German intellectuals to rebut its contents and sign the pacifistic "<a href="/wiki/Manifesto_to_the_Europeans" title="Manifesto to the Europeans">Manifesto to the Europeans</a>".<sup id="cite_ref-FOOTNOTEScheideler2002333_84-0" class="reference"><a href="#cite_note-FOOTNOTEScheideler2002333-84">&#91;82&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/1/1a/19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png/220px-19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png" decoding="async" width="220" height="300" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/1/1a/19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png/330px-19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/1a/19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png/440px-19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png 2x" data-file-width="841" data-file-height="1147" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:19191125_A_New_Physics_Based_on_Einstein_-_The_New_York_Times.png" class="internal" title="Enlarge"></a></div><i>The New York Times</i> reported confirmation of "the Einstein theory" (specifically, the bending of light by gravitation) based on 29 May 1919 eclipse observations in Principe (Africa) and Sobral (Brazil), after the findings were presented on 6 November 1919 to a joint meeting in London of the <a href="/wiki/Royal_Society" title="Royal Society">Royal Society</a> and the <a href="/wiki/Royal_Astronomical_Society" title="Royal Astronomical Society">Royal Astronomical Society</a>.<sup id="cite_ref-NYTimes_19191125_85-0" class="reference"><a href="#cite_note-NYTimes_19191125-85">&#91;83&#93;</a></sup> (<a rel="nofollow" class="external text" href="https://timesmachine.nytimes.com/timesmachine/1919/11/25/96868705.html?pageNumber=17">Full text</a>)</div></div></div>
<p>On 3 July 1913, he became a member of the <a href="/wiki/Prussian_Academy_of_Sciences" title="Prussian Academy of Sciences">Prussian Academy of Sciences</a> in Berlin. <a href="/wiki/Max_Planck" title="Max Planck">Max Planck</a> and <a href="/wiki/Walther_Nernst" title="Walther Nernst">Walther Nernst</a> visited him the next week in Zurich to persuade him to join the academy, additionally offering him the post of director at the <a href="/wiki/Kaiser_Wilhelm_Institute_for_Physics" class="mw-redirect" title="Kaiser Wilhelm Institute for Physics">Kaiser Wilhelm Institute for Physics</a>, which was soon to be established.<sup id="cite_ref-FOOTNOTEStachel2002534_86-0" class="reference"><a href="#cite_note-FOOTNOTEStachel2002534-86">&#91;84&#93;</a></sup> Membership in the academy included paid salary and professorship without teaching duties at <a href="/wiki/Humboldt_University_of_Berlin" title="Humboldt University of Berlin">Humboldt University of Berlin</a>. He was officially elected to the academy on 24 July, and he moved to Berlin the following year. His decision to move to Berlin was also influenced by the prospect of living near his cousin Elsa, with whom he had started a romantic affair. He joined the academy and thus Berlin University<sup class="noprint Inline-Template" style="margin-left:0.1em; white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Please_clarify" title="Wikipedia:Please clarify"><span title="Does Berlin University mean Humboldt University? (September 2020)">clarification needed</span></a></i>&#93;</sup> on 1 April 1914.<sup class="noprint Inline-Template" style="margin-left:0.1em; white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Please_clarify" title="Wikipedia:Please clarify"><span title="In a previous sentence, it states he was elected to the academy on 24 July, so which is it? (September 2020)">clarification needed</span></a></i>&#93;</sup><sup id="cite_ref-FOOTNOTEWeinstein201518–19_87-0" class="reference"><a href="#cite_note-FOOTNOTEWeinstein201518–19-87">&#91;85&#93;</a></sup> As World War I broke out that year, the plan for Kaiser Wilhelm Institute for Physics was aborted. The institute was established on 1 October 1917, with Einstein as its director.<sup id="cite_ref-EXcH6_88-0" class="reference"><a href="#cite_note-EXcH6-88">&#91;86&#93;</a></sup> In 1916, Einstein was elected president of the <a href="/wiki/German_Physical_Society" title="German Physical Society">German Physical Society</a> (1916–1918).<sup id="cite_ref-FOOTNOTECalapriceLipscombe2005&#91;httpsbooksgooglecombooksid5eWh2O_3OAQCpgPR19_&quot;Timeline&quot;,_p._xix&#93;_89-0" class="reference"><a href="#cite_note-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPR19_&quot;Timeline&quot;,_p._xix]-89">&#91;87&#93;</a></sup>
</p><p>Based on calculations Einstein had made in 1911 using his new theory of general relativity, <a href="/wiki/Gravitational_lens" title="Gravitational lens">light from another star should be bent</a> by the Sun\'s gravity. In 1919, that prediction was confirmed by Sir <a href="/wiki/Arthur_Eddington" title="Arthur Eddington">Arthur Eddington</a> during the <a href="/wiki/Solar_eclipse_of_29_May_1919" class="mw-redirect" title="Solar eclipse of 29 May 1919">solar eclipse of 29 May 1919</a>. Those observations were published in the international media, making Einstein world-famous. On 7 November 1919, the leading British newspaper <i><a href="/wiki/The_Times" title="The Times">The Times</a></i> printed a banner headline that read: "Revolution in Science&#160;– New Theory of the Universe&#160;– Newtonian Ideas Overthrown".<sup id="cite_ref-Eddington_90-0" class="reference"><a href="#cite_note-Eddington-90">&#91;88&#93;</a></sup>
</p><p>In 1920, he became a Foreign Member of the <a href="/wiki/Royal_Netherlands_Academy_of_Arts_and_Sciences" title="Royal Netherlands Academy of Arts and Sciences">Royal Netherlands Academy of Arts and Sciences</a>.<sup id="cite_ref-3gcYy_91-0" class="reference"><a href="#cite_note-3gcYy-91">&#91;89&#93;</a></sup> In 1922, he was awarded the 1921 <a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Nobel Prize in Physics</a> "for his services to Theoretical Physics, and especially for his discovery of the law of the photoelectric effect".<sup id="cite_ref-Nobel_Prize_11-1" class="reference"><a href="#cite_note-Nobel_Prize-11">&#91;10&#93;</a></sup> While the <a href="/wiki/General_relativity" title="General relativity">general theory of relativity</a> was still considered somewhat controversial, the citation also does not treat even the cited photoelectric work as an <i>explanation</i> but merely as a <i>discovery of the law</i>, as the idea of photons was considered outlandish and did not receive universal acceptance until the 1924 derivation of the <a href="/wiki/Planck_spectrum" class="mw-redirect" title="Planck spectrum">Planck spectrum</a> by <a href="/wiki/S._N._Bose" class="mw-redirect" title="S. N. Bose">S. N. Bose</a>. Einstein was elected a <a href="/wiki/List_of_Fellows_of_the_Royal_Society_elected_in_1921" class="mw-redirect" title="List of Fellows of the Royal Society elected in 1921">Foreign Member of the Royal Society (ForMemRS) in 1921</a>.<sup id="cite_ref-frs_4-3" class="reference"><a href="#cite_note-frs-4">&#91;3&#93;</a></sup> He also received the <a href="/wiki/Copley_Medal" title="Copley Medal">Copley Medal</a> from the <a href="/wiki/Royal_Society" title="Royal Society">Royal Society</a> in 1925.<sup id="cite_ref-frs_4-4" class="reference"><a href="#cite_note-frs-4">&#91;3&#93;</a></sup>
</p>
<h3><span id="1921.E2.80.931922:_Travels_abroad"></span><span class="mw-headline" id="1921–1922:_Travels_abroad">1921–1922: Travels abroad</span></h3>
<div class="thumb tleft"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_(Nobel).png" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/5/50/Albert_Einstein_%28Nobel%29.png/170px-Albert_Einstein_%28Nobel%29.png" decoding="async" width="170" height="240" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/5/50/Albert_Einstein_%28Nobel%29.png/255px-Albert_Einstein_%28Nobel%29.png 1.5x, //upload.wikimedia.org/wikipedia/commons/5/50/Albert_Einstein_%28Nobel%29.png 2x" data-file-width="280" data-file-height="396" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_(Nobel).png" class="internal" title="Enlarge"></a></div>Einstein\'s official portrait after receiving the 1921 Nobel Prize in Physics</div></div></div>
<p>Einstein visited New York City for the first time on 2 April 1921, where he received an official welcome by Mayor <a href="/wiki/John_Francis_Hylan" title="John Francis Hylan">John Francis Hylan</a>, followed by three weeks of lectures and receptions.<sup id="cite_ref-92" class="reference"><a href="#cite_note-92">&#91;90&#93;</a></sup> He went on to deliver several lectures at <a href="/wiki/Columbia_University" title="Columbia University">Columbia University</a> and <a href="/wiki/Princeton_University" title="Princeton University">Princeton University</a>, and in Washington, he accompanied representatives of the <a href="/wiki/National_Academy_of_Science" class="mw-redirect" title="National Academy of Science">National Academy of Science</a> on a visit to the <a href="/wiki/White_House" title="White House">White House</a>. On his return to Europe he was the guest of the British statesman and philosopher <a href="/wiki/Viscount_Haldane" class="mw-redirect" title="Viscount Haldane">Viscount Haldane</a> in London, where he met several renowned scientific, intellectual, and political figures, and delivered a lecture at <a href="/wiki/King%27s_College_London" title="King&#39;s College London">King\'s College London</a>.<sup id="cite_ref-FOOTNOTEHoffmann1972145–148_93-0" class="reference"><a href="#cite_note-FOOTNOTEHoffmann1972145–148-93">&#91;91&#93;</a></sup><sup id="cite_ref-FOOTNOTEFölsing1997499–508_94-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing1997499–508-94">&#91;92&#93;</a></sup>
</p><p>He also published an essay, "My First Impression of the U.S.A.", in July 1921, in which he tried briefly to describe some characteristics of Americans, much as had <a href="/wiki/Alexis_de_Tocqueville" title="Alexis de Tocqueville">Alexis de Tocqueville</a>, who published his own impressions in <i><a href="/wiki/Democracy_in_America" title="Democracy in America">Democracy in America</a></i> (1835).<sup id="cite_ref-7gwHd_95-0" class="reference"><a href="#cite_note-7gwHd-95">&#91;93&#93;</a></sup> For some of his observations, Einstein was clearly surprised: "What strikes a visitor is the joyous, positive attitude to life ... The American is friendly, self-confident, optimistic, and without envy."<sup id="cite_ref-FOOTNOTEHolton198420_96-0" class="reference"><a href="#cite_note-FOOTNOTEHolton198420-96">&#91;94&#93;</a></sup>
</p><p>In 1922, his travels took him to Asia and later to Palestine, as part of a six-month excursion and speaking tour, as he visited <a href="/wiki/Singapore" title="Singapore">Singapore</a>, <a href="/wiki/Ceylon" class="mw-redirect" title="Ceylon">Ceylon</a> and <a href="/wiki/Japan" title="Japan">Japan</a>, where he gave a series of lectures to thousands of Japanese. After his first public lecture, he met the emperor and empress at the <a href="/wiki/Tokyo_Imperial_Palace" title="Tokyo Imperial Palace">Imperial Palace</a>, where thousands came to watch. In a letter to his sons, he described his impression of the Japanese as being modest, intelligent, considerate, and having a true feel for art.<sup id="cite_ref-FOOTNOTEIsaacson2007307–308_97-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007307–308-97">&#91;95&#93;</a></sup> In his own travel diaries from his 1922–23 visit to Asia, he expresses some views on the Chinese, Japanese and Indian people, which have been described as xenophobic and racist judgments when they were rediscovered in 2018.<sup id="cite_ref-38YkY_98-0" class="reference"><a href="#cite_note-38YkY-98">&#91;96&#93;</a></sup><sup id="cite_ref-99" class="reference"><a href="#cite_note-99">&#91;97&#93;</a></sup>
</p><p>Because of Einstein\'s travels to the Far East, he was unable to personally accept the Nobel Prize for Physics at the Stockholm award ceremony in December 1922. In his place, the banquet speech was made by a German diplomat, who praised Einstein not only as a scientist but also as an international peacemaker and activist.<sup id="cite_ref-oxak7_100-0" class="reference"><a href="#cite_note-oxak7-100">&#91;98&#93;</a></sup>
</p><p>On his return voyage, he visited <a href="/wiki/Mandatory_Palestine" title="Mandatory Palestine">Palestine</a> for 12 days, his only visit to that region. He was greeted as if he were a head of state, rather than a physicist, which included a cannon salute upon arriving at the home of the British high commissioner, <a href="/wiki/Sir_Herbert_Samuel" class="mw-redirect" title="Sir Herbert Samuel">Sir Herbert Samuel</a>. During one reception, the building was stormed by people who wanted to see and hear him. In Einstein\'s talk to the audience, he expressed happiness that the Jewish people were beginning to be recognized as a force in the world.<sup id="cite_ref-FOOTNOTEIsaacson2007308_101-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007308-101">&#91;99&#93;</a></sup>
</p><p>Einstein visited Spain for two weeks in 1923, where he briefly met <a href="/wiki/Santiago_Ram%C3%B3n_y_Cajal" title="Santiago Ramón y Cajal">Santiago Ramón y Cajal</a> and also received a diploma from <a href="/wiki/Alfonso_XIII_of_Spain" class="mw-redirect" title="Alfonso XIII of Spain">King Alfonso XIII</a> naming him a member of the Spanish Academy of Sciences.<sup id="cite_ref-w74nv_102-0" class="reference"><a href="#cite_note-w74nv-102">&#91;100&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:League_of_Nations_Commission_067.tif" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/63/League_of_Nations_Commission_067.tif/lossy-page1-220px-League_of_Nations_Commission_067.tif.jpg" decoding="async" width="220" height="169" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/63/League_of_Nations_Commission_067.tif/lossy-page1-330px-League_of_Nations_Commission_067.tif.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/63/League_of_Nations_Commission_067.tif/lossy-page1-440px-League_of_Nations_Commission_067.tif.jpg 2x" data-file-width="5008" data-file-height="3840" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:League_of_Nations_Commission_067.tif" class="internal" title="Enlarge"></a></div>Albert Einstein at a session of the <a href="/wiki/International_Committee_on_Intellectual_Cooperation" title="International Committee on Intellectual Cooperation">International Committee on Intellectual Cooperation</a> (<a href="/wiki/League_of_Nations" title="League of Nations">League of Nations</a>) of which he was a member from 1922 to 1932.</div></div></div>
<p>From 1922 to 1932, Einstein was a member of the <a href="/wiki/International_Committee_on_Intellectual_Cooperation" title="International Committee on Intellectual Cooperation">International Committee on Intellectual Cooperation</a> of the <a href="/wiki/League_of_Nations" title="League of Nations">League of Nations</a> in <a href="/wiki/Geneva" title="Geneva">Geneva</a> (with a few months of interruption in 1923–1924),<sup id="cite_ref-Q5hgx_103-0" class="reference"><a href="#cite_note-Q5hgx-103">&#91;101&#93;</a></sup> a body created to promote international exchange between scientists, researchers, teachers, artists, and intellectuals.<sup id="cite_ref-vNNnX_104-0" class="reference"><a href="#cite_note-vNNnX-104">&#91;102&#93;</a></sup> Originally slated to serve as the Swiss delegate, Secretary-General <a href="/wiki/Eric_Drummond" class="mw-redirect" title="Eric Drummond">Eric Drummond</a> was persuaded by Catholic activists <a href="/wiki/Oskar_Halecki" title="Oskar Halecki">Oskar Halecki</a> and <a href="/wiki/Giuseppe_Motta" title="Giuseppe Motta">Giuseppe Motta</a> to instead have him become the German delegate, thus allowing <a href="/wiki/Gonzague_de_Reynold" title="Gonzague de Reynold">Gonzague de Reynold</a> to take the Swiss spot, from which he promoted traditionalist Catholic values.<sup id="cite_ref-e9Xyh_105-0" class="reference"><a href="#cite_note-e9Xyh-105">&#91;103&#93;</a></sup> Einstein\'s former physics professor <a href="/wiki/Hendrik_Lorentz" title="Hendrik Lorentz">Hendrik Lorentz</a> and the Polish chemist <a href="/wiki/Marie_Curie" title="Marie Curie">Marie Curie</a> were also members of the committee.
</p>
<h3><span id="1930.E2.80.931931:_Travel_to_the_US"></span><span class="mw-headline" id="1930–1931:_Travel_to_the_US">1930–1931: Travel to the US</span></h3>
<p>In December 1930, Einstein visited America for the second time, originally intended as a two-month working visit as a research fellow at the <a href="/wiki/California_Institute_of_Technology" title="California Institute of Technology">California Institute of Technology</a>. After the national attention, he received during his first trip to the US, he and his arrangers aimed to protect his privacy. Although swamped with telegrams and invitations to receive awards or speak publicly, he declined them all.<sup id="cite_ref-FOOTNOTEIsaacson2007368_106-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007368-106">&#91;104&#93;</a></sup>
</p><p>After arriving in New York City, Einstein was taken to various places and events, including <a href="/wiki/Chinatown,_Manhattan" title="Chinatown, Manhattan">Chinatown</a>, a lunch with the editors of <i>The New York Times</i>, and a performance of <i>Carmen</i> at the <a href="/wiki/Metropolitan_Opera" title="Metropolitan Opera">Metropolitan Opera</a>, where he was cheered by the audience on his arrival. During the days following, he was given the keys to the city by Mayor <a href="/wiki/Jimmy_Walker" title="Jimmy Walker">Jimmy Walker</a> and met the president of Columbia University, who described Einstein as "the ruling monarch of the mind".<sup id="cite_ref-FOOTNOTEIsaacson2007370_107-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007370-107">&#91;105&#93;</a></sup> <a href="/wiki/Harry_Emerson_Fosdick" title="Harry Emerson Fosdick">Harry Emerson Fosdick</a>, pastor at New York\'s <a href="/wiki/Riverside_Church" title="Riverside Church">Riverside Church</a>, gave Einstein a tour of the church and showed him a full-size statue that the church made of Einstein, standing at the entrance.<sup id="cite_ref-FOOTNOTEIsaacson2007370_107-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007370-107">&#91;105&#93;</a></sup> Also during his stay in New York, he joined a crowd of 15,000 people at <a href="/wiki/Madison_Square_Garden" title="Madison Square Garden">Madison Square Garden</a> during a <a href="/wiki/Hanukkah" title="Hanukkah">Hanukkah</a> celebration.<sup id="cite_ref-FOOTNOTEIsaacson2007370_107-2" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007370-107">&#91;105&#93;</a></sup>
</p>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg/170px-Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg" decoding="async" width="170" height="192" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg/255px-Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/e/e2/Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg/340px-Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg 2x" data-file-width="1138" data-file-height="1288" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_and_Charlie_Chaplin_-_1931.jpg" class="internal" title="Enlarge"></a></div>Einstein (left) and <a href="/wiki/Charlie_Chaplin" title="Charlie Chaplin">Charlie Chaplin</a> at the <a href="/wiki/Hollywood" title="Hollywood">Hollywood</a> premiere of <i><a href="/wiki/City_Lights" title="City Lights">City Lights</a></i>, January 1931</div></div></div>
<p>Einstein next traveled to California, where he met <a href="/wiki/Caltech" class="mw-redirect" title="Caltech">Caltech</a> president and Nobel laureate <a href="/wiki/Robert_A._Millikan" class="mw-redirect" title="Robert A. Millikan">Robert A. Millikan</a>. His friendship with Millikan was "awkward", as Millikan "had a penchant for patriotic militarism", where Einstein was a pronounced <a href="/wiki/Pacifism" title="Pacifism">pacifist</a>.<sup id="cite_ref-FOOTNOTEIsaacson2007373_108-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007373-108">&#91;106&#93;</a></sup> During an address to Caltech\'s students, Einstein noted that science was often inclined to do more harm than good.<sup id="cite_ref-FOOTNOTEIsaacson2007374_109-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007374-109">&#91;107&#93;</a></sup>
</p><p>This aversion to war also led Einstein to befriend author <a href="/wiki/Upton_Sinclair" title="Upton Sinclair">Upton Sinclair</a> and film star <a href="/wiki/Charlie_Chaplin" title="Charlie Chaplin">Charlie Chaplin</a>, both noted for their pacifism. <a href="/wiki/Carl_Laemmle" title="Carl Laemmle">Carl Laemmle</a>, head of <a href="/wiki/Universal_Studios" class="mw-redirect" title="Universal Studios">Universal Studios</a>, gave Einstein a tour of his studio and introduced him to Chaplin. They had an instant rapport, with Chaplin inviting Einstein and his wife, Elsa, to his home for dinner. Chaplin said Einstein\'s outward persona, calm and gentle, seemed to conceal a "highly emotional temperament", from which came his "extraordinary intellectual energy".<sup id="cite_ref-FOOTNOTEChaplin1964320_110-0" class="reference"><a href="#cite_note-FOOTNOTEChaplin1964320-110">&#91;108&#93;</a></sup>
</p><p>Chaplin\'s film, <i><a href="/wiki/City_Lights" title="City Lights">City Lights</a></i>, was to premiere a few days later in Hollywood, and Chaplin invited Einstein and Elsa to join him as his special guests. <a href="/wiki/Walter_Isaacson" title="Walter Isaacson">Walter Isaacson</a>, Einstein\'s biographer, described this as "one of the most memorable scenes in the new era of celebrity".<sup id="cite_ref-FOOTNOTEIsaacson2007374_109-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007374-109">&#91;107&#93;</a></sup> Chaplin visited Einstein at his home on a later trip to Berlin and recalled his "modest little flat" and the piano at which he had begun writing his theory. Chaplin speculated that it was "possibly used as kindling wood by the Nazis".<sup id="cite_ref-FOOTNOTEChaplin1964322_111-0" class="reference"><a href="#cite_note-FOOTNOTEChaplin1964322-111">&#91;109&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="1933:_Emigration_to_the_US">1933: Emigration to the US</span></h3>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Einstein-cartoon1.jpg" class="image"><img alt="Cartoon of Einstein, who has shed his &quot;Pacifism&quot; wings, standing next to a pillar labeled &quot;World Peace&quot;. He is rolling up his sleeves and holding a sword labeled &quot;Preparedness&quot;." src="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Einstein-cartoon1.jpg/170px-Einstein-cartoon1.jpg" decoding="async" width="170" height="186" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Einstein-cartoon1.jpg/255px-Einstein-cartoon1.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Einstein-cartoon1.jpg/340px-Einstein-cartoon1.jpg 2x" data-file-width="624" data-file-height="682" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein-cartoon1.jpg" class="internal" title="Enlarge"></a></div>Cartoon of Einstein after shedding his "pacifism" wings (<a href="/wiki/Charles_R._Macauley" title="Charles R. Macauley">Charles R. Macauley</a>, <abbr title="circa">c.</abbr><span style="white-space:nowrap;">&#8201;1933</span>)</div></div></div>
<p>In February 1933, while on a visit to the United States, Einstein knew he could not return to Germany with the rise to power of the <a href="/wiki/Nazi_Germany" title="Nazi Germany">Nazis</a> under Germany\'s new chancellor, <a href="/wiki/Adolf_Hitler" title="Adolf Hitler">Adolf Hitler</a>.<sup id="cite_ref-FOOTNOTEFölsing1997659_112-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing1997659-112">&#91;110&#93;</a></sup><sup id="cite_ref-FOOTNOTEIsaacson2007404_113-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007404-113">&#91;111&#93;</a></sup>
</p><p>While at American universities in early 1933, he undertook his third two-month visiting professorship at the <a href="/wiki/California_Institute_of_Technology" title="California Institute of Technology">California Institute of Technology</a> in Pasadena. In February and March 1933, the <a href="/wiki/Gestapo" title="Gestapo">Gestapo</a> repeatedly raided his family\'s apartment in Berlin.<sup id="cite_ref-114" class="reference"><a href="#cite_note-114">&#91;112&#93;</a></sup> He and his wife Elsa returned to Europe in March, and during the trip, they learned that the German Reichstag passed the <a href="/wiki/Enabling_Act_of_1933" title="Enabling Act of 1933">Enabling Act</a>, which was passed on 23 March and transformed Hitler\'s government into a <i>de facto</i> legal dictatorship and that they would not be able to proceed to Berlin. Later on they heard that their cottage was raided by the Nazis and his personal sailboat confiscated. Upon landing in <a href="/wiki/Antwerp" title="Antwerp">Antwerp</a>, Belgium on 28 March, he immediately went to the German consulate and surrendered his passport, formally renouncing his German citizenship.<sup id="cite_ref-FOOTNOTEIsaacson2007407–410_115-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007407–410-115">&#91;113&#93;</a></sup> The Nazis later sold his boat and converted his cottage into a <a href="/wiki/Hitler_Youth" title="Hitler Youth">Hitler Youth</a> camp.<sup id="cite_ref-el4GB_116-0" class="reference"><a href="#cite_note-el4GB-116">&#91;114&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Refugee_status">Refugee status</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Einstein%27s_landing_card_(5706142737).jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/7/78/Einstein%27s_landing_card_%285706142737%29.jpg/220px-Einstein%27s_landing_card_%285706142737%29.jpg" decoding="async" width="220" height="144" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/7/78/Einstein%27s_landing_card_%285706142737%29.jpg/330px-Einstein%27s_landing_card_%285706142737%29.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/7/78/Einstein%27s_landing_card_%285706142737%29.jpg/440px-Einstein%27s_landing_card_%285706142737%29.jpg 2x" data-file-width="1391" data-file-height="909" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein%27s_landing_card_(5706142737).jpg" class="internal" title="Enlarge"></a></div>Albert Einstein\'s landing card (26 May 1933), when he landed in <a href="/wiki/Dover" title="Dover">Dover</a> (United Kingdom) from <a href="/wiki/Ostende" class="mw-redirect" title="Ostende">Ostende</a> (Belgium) to visit <a href="/wiki/Oxford" title="Oxford">Oxford</a>.</div></div></div>
<p>In April 1933, Einstein discovered that the new German government had passed laws barring Jews from holding any official positions, including teaching at universities.<sup id="cite_ref-FOOTNOTEIsaacson2007407–410_115-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007407–410-115">&#91;113&#93;</a></sup> Historian <a href="/wiki/Gerald_Holton" title="Gerald Holton">Gerald Holton</a> describes how, with "virtually no audible protest being raised by their colleagues", thousands of Jewish scientists were suddenly forced to give up their university positions and their names were removed from the rolls of institutions where they were employed.<sup id="cite_ref-FOOTNOTEHolton1984_117-0" class="reference"><a href="#cite_note-FOOTNOTEHolton1984-117">&#91;115&#93;</a></sup>
</p><p>A month later, Einstein\'s works were among those targeted by the <a href="/wiki/German_Student_Union" title="German Student Union">German Student Union</a> in the <a href="/wiki/Nazi_book_burnings" title="Nazi book burnings">Nazi book burnings</a>, with Nazi propaganda minister <a href="/wiki/Joseph_Goebbels" title="Joseph Goebbels">Joseph Goebbels</a> proclaiming, "Jewish intellectualism is dead."<sup id="cite_ref-FOOTNOTEIsaacson2007407–410_115-2" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007407–410-115">&#91;113&#93;</a></sup> One German magazine included him in a list of enemies of the German regime with the phrase, "not yet hanged", offering a $5,000 bounty on his head.<sup id="cite_ref-FOOTNOTEIsaacson2007407–410_115-3" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007407–410-115">&#91;113&#93;</a></sup><sup id="cite_ref-Jerome_118-0" class="reference"><a href="#cite_note-Jerome-118">&#91;116&#93;</a></sup> In a subsequent letter to physicist and friend <a href="/wiki/Max_Born" title="Max Born">Max Born</a>, who had already emigrated from Germany to England, Einstein wrote, "...&#160;I must confess that the degree of their brutality and cowardice came as something of a surprise."<sup id="cite_ref-FOOTNOTEIsaacson2007407–410_115-4" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007407–410-115">&#91;113&#93;</a></sup> After moving to the US, he described the book burnings as a "spontaneous emotional outburst" by those who "shun popular enlightenment", and "more than anything else in the world, fear the influence of men of intellectual independence".<sup id="cite_ref-FOOTNOTEEinstein1954197_119-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1954197-119">&#91;117&#93;</a></sup>
</p><p>Einstein was now without a permanent home, unsure where he would live and work, and equally worried about the fate of countless other scientists still in Germany. He rented a house in De Haan, Belgium, where he lived for a few months. In late July 1933, he went to England for about six weeks at the personal invitation of British naval officer Commander <a href="/wiki/Oliver_Locker-Lampson" title="Oliver Locker-Lampson">Oliver Locker-Lampson</a>, who had become friends with Einstein in the preceding years. Locker-Lampson invited him to stay near his <a href="/wiki/Cromer" title="Cromer">Cromer</a> home in a wooden cabin on Roughton Heath in the Parish of <a href="/wiki/Roughton,_Norfolk" title="Roughton, Norfolk">Roughton, Norfolk</a>. To protect Einstein, Locker-Lampson had two bodyguards watch over him at his secluded cabin, with a photo of them carrying shotguns and guarding Einstein, published in the <i>Daily Herald</i> on 24 July 1933.<sup id="cite_ref-FOOTNOTEIsaacson2007422_120-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007422-120">&#91;118&#93;</a></sup><sup id="cite_ref-3zIp7_121-0" class="reference"><a href="#cite_note-3zIp7-121">&#91;119&#93;</a></sup>
</p><p>Locker-Lampson took Einstein to meet <a href="/wiki/Winston_Churchill" title="Winston Churchill">Winston Churchill</a> at his home, and later, <a href="/wiki/Austen_Chamberlain" title="Austen Chamberlain">Austen Chamberlain</a> and former Prime Minister <a href="/wiki/David_Lloyd_George" title="David Lloyd George">Lloyd George</a>.<sup id="cite_ref-FOOTNOTEIsaacson2007419–420_122-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007419–420-122">&#91;120&#93;</a></sup> Einstein asked them to help bring Jewish scientists out of Germany. British historian <a href="/wiki/Martin_Gilbert" title="Martin Gilbert">Martin Gilbert</a> notes that Churchill responded immediately, and sent his friend, physicist <a href="/wiki/Frederick_Lindemann,_1st_Viscount_Cherwell" title="Frederick Lindemann, 1st Viscount Cherwell">Frederick Lindemann</a>, to Germany to seek out Jewish scientists and place them in British universities.<sup id="cite_ref-Gilbert_123-0" class="reference"><a href="#cite_note-Gilbert-123">&#91;121&#93;</a></sup> Churchill later observed that as a result of Germany having driven the Jews out, they had lowered their "technical standards" and put <a href="/wiki/Allies_of_World_War_II" title="Allies of World War II">the Allies</a>\' technology ahead of theirs.<sup id="cite_ref-Gilbert_123-1" class="reference"><a href="#cite_note-Gilbert-123">&#91;121&#93;</a></sup>
</p><p>Einstein later contacted leaders of other nations, including <a href="/wiki/Turkey" title="Turkey">Turkey</a>\'s Prime Minister, <a href="/wiki/%C4%B0smet_%C4%B0n%C3%B6n%C3%BC" title="İsmet İnönü">İsmet İnönü</a>, to whom he wrote in September 1933 requesting placement of unemployed German-Jewish scientists. As a result of Einstein\'s letter, Jewish invitees to Turkey eventually totaled over "1,000 saved individuals".<sup id="cite_ref-aDu8s_124-0" class="reference"><a href="#cite_note-aDu8s-124">&#91;122&#93;</a></sup>
</p><p>Locker-Lampson also submitted a bill to parliament to extend British citizenship to Einstein, during which period Einstein made a number of public appearances describing the crisis brewing in Europe.<sup id="cite_ref-FOOTNOTEClark1971_125-0" class="reference"><a href="#cite_note-FOOTNOTEClark1971-125">&#91;123&#93;</a></sup> In one of his speeches he denounced Germany\'s treatment of Jews, while at the same time he introduced a bill promoting Jewish citizenship in Palestine, as they were being denied citizenship elsewhere.<sup id="cite_ref-AP_126-0" class="reference"><a href="#cite_note-AP-126">&#91;124&#93;</a></sup> In his speech he described Einstein as a "citizen of the world" who should be offered a temporary shelter in the UK.<sup id="cite_ref-gnriE_127-0" class="reference"><a href="#cite_note-gnriE-127">&#91;note 3&#93;</a></sup><sup id="cite_ref-Guardian_128-0" class="reference"><a href="#cite_note-Guardian-128">&#91;125&#93;</a></sup> Both bills failed, however, and Einstein then accepted an earlier offer from the <a href="/wiki/Institute_for_Advanced_Study" title="Institute for Advanced Study">Institute for Advanced Study</a>, in <a href="/wiki/Princeton,_New_Jersey" title="Princeton, New Jersey">Princeton, New Jersey</a>, US, to become a resident scholar.<sup id="cite_ref-FOOTNOTEClark1971_125-1" class="reference"><a href="#cite_note-FOOTNOTEClark1971-125">&#91;123&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Resident_scholar_at_the_Institute_for_Advanced_Study">Resident scholar at the Institute for Advanced Study</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Einstein-formal_portrait-35.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Einstein-formal_portrait-35.jpg/170px-Einstein-formal_portrait-35.jpg" decoding="async" width="170" height="219" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Einstein-formal_portrait-35.jpg/255px-Einstein-formal_portrait-35.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Einstein-formal_portrait-35.jpg/340px-Einstein-formal_portrait-35.jpg 2x" data-file-width="520" data-file-height="671" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein-formal_portrait-35.jpg" class="internal" title="Enlarge"></a></div>Portrait of Einstein taken in 1935 at Princeton</div></div></div>
<p>In October 1933, Einstein returned to the US and took up a position at the Institute for Advanced Study,<sup id="cite_ref-FOOTNOTEClark1971_125-2" class="reference"><a href="#cite_note-FOOTNOTEClark1971-125">&#91;123&#93;</a></sup><sup id="cite_ref-FOOTNOTEFölsing1997649,_678_129-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing1997649,_678-129">&#91;126&#93;</a></sup> noted for having become a refuge for scientists fleeing Nazi Germany.<sup id="cite_ref-Arntzenius2011_130-0" class="reference"><a href="#cite_note-Arntzenius2011-130">&#91;127&#93;</a></sup> At the time, most American universities, including Harvard, Princeton and Yale, had minimal or no Jewish faculty or students, as a result of their <a href="/wiki/Jewish_quota" title="Jewish quota">Jewish quotas</a>, which lasted until the late 1940s.<sup id="cite_ref-Arntzenius2011_130-1" class="reference"><a href="#cite_note-Arntzenius2011-130">&#91;127&#93;</a></sup>
</p><p>Einstein was still undecided on his future. He had offers from several European universities, including <a href="/wiki/Christ_Church,_Oxford" title="Christ Church, Oxford">Christ Church, Oxford</a> where he stayed for three short periods between May 1931 and June 1933 and was offered a 5-year studentship,<sup id="cite_ref-FFt5E_131-0" class="reference"><a href="#cite_note-FFt5E-131">&#91;128&#93;</a></sup><sup id="cite_ref-v8v06_132-0" class="reference"><a href="#cite_note-v8v06-132">&#91;129&#93;</a></sup> but in 1935, he arrived at the decision to remain permanently in the United States and apply for citizenship.<sup id="cite_ref-FOOTNOTEClark1971_125-3" class="reference"><a href="#cite_note-FOOTNOTEClark1971-125">&#91;123&#93;</a></sup><sup id="cite_ref-FOOTNOTEFölsing1997686–687_133-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing1997686–687-133">&#91;130&#93;</a></sup>
</p><p>Einstein\'s affiliation with the Institute for Advanced Study would last until his death in 1955.<sup id="cite_ref-mzNc5_134-0" class="reference"><a href="#cite_note-mzNc5-134">&#91;131&#93;</a></sup> He was one of the four first selected (two of the others being <a href="/wiki/John_von_Neumann" title="John von Neumann">John von Neumann</a> and <a href="/wiki/Kurt_G%C3%B6del" title="Kurt Gödel">Kurt Gödel</a>) at the new Institute, where he soon developed a close friendship with Gödel. The two would take long walks together discussing their work. <a href="/wiki/Bruria_Kaufman" title="Bruria Kaufman">Bruria Kaufman</a>, his assistant, later became a physicist. During this period, Einstein tried to develop a <a href="/wiki/Unified_field_theory" title="Unified field theory">unified field theory</a> and to refute the <a href="/wiki/Copenhagen_interpretation" title="Copenhagen interpretation">accepted interpretation</a> of <a href="/wiki/Quantum_physics" class="mw-redirect" title="Quantum physics">quantum physics</a>, both unsuccessfully.
</p>
<h4><span class="mw-headline" id="World_War_II_and_the_Manhattan_Project">World War II and the Manhattan Project</span></h4>
<div role="note" class="hatnote navigation-not-searchable">See also: <a href="/wiki/Einstein%E2%80%93Szil%C3%A1rd_letter" title="Einstein–Szilárd letter">Einstein–Szilárd letter</a></div>
<p>In 1939, a group of Hungarian scientists that included émigré physicist <a href="/wiki/Le%C3%B3_Szil%C3%A1rd" class="mw-redirect" title="Leó Szilárd">Leó Szilárd</a> attempted to alert Washington to ongoing Nazi atomic bomb research. The group\'s warnings were discounted. Einstein and Szilárd, along with other refugees such as <a href="/wiki/Edward_Teller" title="Edward Teller">Edward Teller</a> and <a href="/wiki/Eugene_Wigner" title="Eugene Wigner">Eugene Wigner</a>, "regarded it as their responsibility to alert Americans to the possibility that German scientists might win the <a href="/wiki/German_nuclear_energy_project" class="mw-redirect" title="German nuclear energy project">race to build an atomic bomb</a>, and to warn that Hitler would be more than willing to resort to such a weapon."<sup id="cite_ref-FOOTNOTEIsaacson2007630_135-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007630-135">&#91;132&#93;</a></sup><sup id="cite_ref-o4fkQ_136-0" class="reference"><a href="#cite_note-o4fkQ-136">&#91;133&#93;</a></sup> To make certain the US was aware of the danger, in July 1939, a few months before the beginning of World War II in Europe, Szilárd and Wigner visited Einstein to explain the possibility of atomic bombs, which Einstein, a pacifist, said he had never considered.<sup id="cite_ref-pRqWK_137-0" class="reference"><a href="#cite_note-pRqWK-137">&#91;134&#93;</a></sup> He was asked to lend his support by writing <a href="/wiki/Einstein%E2%80%93Szil%C3%A1rd_letter" title="Einstein–Szilárd letter">a letter</a>, with Szilárd, to President <a href="/wiki/Franklin_D._Roosevelt" title="Franklin D. Roosevelt">Roosevelt</a>, recommending the US pay attention and engage in its own nuclear weapons research.
</p><p>The letter is believed to be "arguably the key stimulus for the U.S. adoption of serious investigations into nuclear weapons on the eve of the U.S. entry into World War II".<sup id="cite_ref-4Z68g_138-0" class="reference"><a href="#cite_note-4Z68g-138">&#91;135&#93;</a></sup> In addition to the letter, Einstein used his connections with the <a href="/wiki/Belgian_Royal_Family" class="mw-redirect" title="Belgian Royal Family">Belgian Royal Family</a><sup id="cite_ref-eZym8_139-0" class="reference"><a href="#cite_note-eZym8-139">&#91;136&#93;</a></sup> and the Belgian queen mother to get access with a personal envoy to the White House\'s Oval Office. Some say that as a result of Einstein\'s letter and his meetings with Roosevelt, the US entered the "race" to develop the bomb, drawing on its "immense material, financial, and scientific resources" to initiate the <a href="/wiki/Manhattan_Project" title="Manhattan Project">Manhattan Project</a>.
</p><p>For Einstein, "war was a disease&#160;... [and] he called for resistance to war." By signing the letter to Roosevelt, some argue he went against his pacifist principles.<sup id="cite_ref-z73PK_140-0" class="reference"><a href="#cite_note-z73PK-140">&#91;137&#93;</a></sup> In 1954, a year before his death, Einstein said to his old friend, <a href="/wiki/Linus_Pauling" title="Linus Pauling">Linus Pauling</a>, "I made one great mistake in my life—when I signed the letter to President Roosevelt recommending that atom bombs be made; but there was some justification—the danger that the Germans would make them&#160;..."<sup id="cite_ref-FOOTNOTEClark1971&#91;&#91;Category:Wikipedia_articles_needing_page_number_citations_from_November_2020&#93;&#93;&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;&#91;&#91;Wikipedia:Citing_sources&#124;&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;&#93;&#93;&lt;/i&gt;&amp;#93;&lt;/sup&gt;_141-0" class="reference"><a href="#cite_note-FOOTNOTEClark1971[[Category:Wikipedia_articles_needing_page_number_citations_from_November_2020]]&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;[[Wikipedia:Citing_sources|&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;]]&lt;/i&gt;&amp;#93;&lt;/sup&gt;-141">&#91;138&#93;</a></sup> In 1955, Einstein and ten other intellectuals and scientists, including British philosopher <a href="/wiki/Bertrand_Russell" title="Bertrand Russell">Bertrand Russell</a>, signed <a href="/wiki/Russell%E2%80%93Einstein_Manifesto" title="Russell–Einstein Manifesto">a manifesto</a> highlighting the danger of nuclear weapons.
</p>
<h4><span class="mw-headline" id="US_citizenship">US citizenship</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Citizen-Einstein.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Citizen-Einstein.jpg/220px-Citizen-Einstein.jpg" decoding="async" width="220" height="167" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Citizen-Einstein.jpg/330px-Citizen-Einstein.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8a/Citizen-Einstein.jpg/440px-Citizen-Einstein.jpg 2x" data-file-width="2220" data-file-height="1683" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Citizen-Einstein.jpg" class="internal" title="Enlarge"></a></div>Einstein accepting <a href="/wiki/Citizenship_of_the_United_States" title="Citizenship of the United States">US citizenship</a> certificate from judge <a href="/wiki/Phillip_Forman" title="Phillip Forman">Phillip Forman</a></div></div></div>
<p>Einstein became an American citizen in 1940. Not long after settling into his career at the Institute for Advanced Study in Princeton, New Jersey, he expressed his appreciation of the <a href="/wiki/Meritocracy" title="Meritocracy">meritocracy</a> in American culture when compared to Europe. He recognized the "right of individuals to say and think what they pleased", without social barriers, and as a result, individuals were encouraged, he said, to be more creative, a trait he valued from his own early education.<sup id="cite_ref-FOOTNOTEIsaacson2007432_142-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007432-142">&#91;139&#93;</a></sup>
</p><p>Einstein joined the <a href="/wiki/National_Association_for_the_Advancement_of_Colored_People" class="mw-redirect" title="National Association for the Advancement of Colored People">National Association for the Advancement of Colored People</a> (NAACP) in Princeton, where he campaigned for the <a href="/wiki/Civil_rights_movement_(1896%E2%80%931954)" title="Civil rights movement (1896–1954)">civil rights</a> of African Americans. He considered racism America\'s "worst disease",<sup id="cite_ref-Jerome_118-1" class="reference"><a href="#cite_note-Jerome-118">&#91;116&#93;</a></sup><sup id="cite_ref-143" class="reference"><a href="#cite_note-143">&#91;140&#93;</a></sup> seeing it as "handed down from one generation to the next".<sup id="cite_ref-FOOTNOTECalaprice2005148–149_144-0" class="reference"><a href="#cite_note-FOOTNOTECalaprice2005148–149-144">&#91;141&#93;</a></sup> As part of his involvement, he corresponded with civil rights activist <a href="/wiki/W._E._B._Du_Bois" title="W. E. B. Du Bois">W. E. B. Du Bois</a> and was prepared to testify on his behalf during his trial in 1951.<sup id="cite_ref-FOOTNOTERobeson2002565_145-0" class="reference"><a href="#cite_note-FOOTNOTERobeson2002565-145">&#91;142&#93;</a></sup> When Einstein offered to be a character witness for Du Bois, the judge decided to drop the case.<sup id="cite_ref-civil_146-0" class="reference"><a href="#cite_note-civil-146">&#91;143&#93;</a></sup>
</p><p>In 1946 Einstein visited <a href="/wiki/Lincoln_University_(Pennsylvania)" title="Lincoln University (Pennsylvania)">Lincoln University</a> in Pennsylvania, a <a href="/wiki/Historically_black_college" class="mw-redirect" title="Historically black college">historically black college</a>, where he was awarded an honorary degree. Lincoln was the first university in the United States to grant college degrees to <a href="/wiki/African_Americans" title="African Americans">African Americans</a>; alumni include <a href="/wiki/Langston_Hughes" title="Langston Hughes">Langston Hughes</a> and <a href="/wiki/Thurgood_Marshall" title="Thurgood Marshall">Thurgood Marshall</a>. Einstein gave a speech about racism in America, adding, "I do not intend to be quiet about it."<sup id="cite_ref-Jerome_Isis_147-0" class="reference"><a href="#cite_note-Jerome_Isis-147">&#91;144&#93;</a></sup> A resident of Princeton recalls that Einstein had once paid the college tuition for a black student.<sup id="cite_ref-civil_146-1" class="reference"><a href="#cite_note-civil-146">&#91;143&#93;</a></sup> Einstein has said "Being a Jew myself, perhaps I can understand and empathize with how black people feel as victims of discrimination".<sup id="cite_ref-148" class="reference"><a href="#cite_note-148">&#91;145&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="Personal_life">Personal life</span></h3>
<h4><span class="mw-headline" id="Assisting_Zionist_causes">Assisting Zionist causes</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_Head.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Albert_Einstein_Head.jpg/170px-Albert_Einstein_Head.jpg" decoding="async" width="170" height="227" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Albert_Einstein_Head.jpg/255px-Albert_Einstein_Head.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/d3/Albert_Einstein_Head.jpg/340px-Albert_Einstein_Head.jpg 2x" data-file-width="3250" data-file-height="4333" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_Head.jpg" class="internal" title="Enlarge"></a></div>Einstein in 1947</div></div></div>
<p>Einstein was a figurehead leader in helping establish the <a href="/wiki/Hebrew_University_of_Jerusalem" title="Hebrew University of Jerusalem">Hebrew University of Jerusalem</a>,<sup id="cite_ref-149" class="reference"><a href="#cite_note-149">&#91;146&#93;</a></sup> which opened in 1925 and was among its first Board of Governors. Earlier, in 1921, he was asked by the biochemist and president of the <a href="/wiki/World_Zionist_Organization" title="World Zionist Organization">World Zionist Organization</a>, <a href="/wiki/Chaim_Weizmann" title="Chaim Weizmann">Chaim Weizmann</a>, to help raise funds for the planned university.<sup id="cite_ref-FOOTNOTEIsaacson2007290_150-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007290-150">&#91;147&#93;</a></sup> He also submitted various suggestions as to its initial programs.
</p><p>Among those, he advised first creating an Institute of Agriculture in order to settle the undeveloped land. That should be followed, he suggested, by a Chemical Institute and an Institute of Microbiology, to fight the various ongoing epidemics such as <a href="/wiki/Malaria" title="Malaria">malaria</a>, which he called an "evil" that was undermining a third of the country\'s development.<sup id="cite_ref-FOOTNOTERoweSchulmann2007161_151-0" class="reference"><a href="#cite_note-FOOTNOTERoweSchulmann2007161-151">&#91;148&#93;</a></sup> Establishing an Oriental Studies Institute, to include language courses given in both Hebrew and Arabic, for scientific exploration of the country and its historical monuments, was also important.<sup id="cite_ref-FOOTNOTERoweSchulmann2007158_152-0" class="reference"><a href="#cite_note-FOOTNOTERoweSchulmann2007158-152">&#91;149&#93;</a></sup>
</p><p>Einstein was not a <a href="/wiki/Nationalism" title="Nationalism">nationalist</a>; he was against the creation of an independent Jewish state, which would be established as <a href="/wiki/Israel" title="Israel">Israel</a> in 1948. Einstein felt that Jews could live alongside native Arabs in <a href="/wiki/Palestine_(region)" title="Palestine (region)">Palestine</a>. As a result, Einstein was limited to a marginal role in the <a href="/wiki/Zionism" title="Zionism">Zionist movement</a>.<sup id="cite_ref-153" class="reference"><a href="#cite_note-153">&#91;150&#93;</a></sup>
</p><p>Chaim Weizmann later became Israel\'s first president. Upon his death while in office in November 1952 and at the urging of <a href="/wiki/Ezriel_Carlebach" title="Ezriel Carlebach">Ezriel Carlebach</a>, Prime Minister <a href="/wiki/David_Ben-Gurion" title="David Ben-Gurion">David Ben-Gurion</a> offered Einstein the position of <a href="/wiki/President_of_Israel" title="President of Israel">President of Israel</a>, a mostly ceremonial post.<sup id="cite_ref-Time_154-0" class="reference"><a href="#cite_note-Time-154">&#91;151&#93;</a></sup><sup id="cite_ref-Msb2q_155-0" class="reference"><a href="#cite_note-Msb2q-155">&#91;152&#93;</a></sup> The offer was presented by Israel\'s ambassador in Washington, <a href="/wiki/Abba_Eban" title="Abba Eban">Abba Eban</a>, who explained that the offer "embodies the deepest respect which the Jewish people can repose in any of its sons".<sup id="cite_ref-FOOTNOTEIsaacson2007522_156-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007522-156">&#91;153&#93;</a></sup> Einstein declined, and wrote in his response that he was "deeply moved", and "at once saddened and ashamed" that he could not accept it.<sup id="cite_ref-FOOTNOTEIsaacson2007522_156-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007522-156">&#91;153&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Love_of_music">Love of music</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Rabindranath_with_Einstein.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/0/09/Rabindranath_with_Einstein.jpg/220px-Rabindranath_with_Einstein.jpg" decoding="async" width="220" height="168" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/0/09/Rabindranath_with_Einstein.jpg/330px-Rabindranath_with_Einstein.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/0/09/Rabindranath_with_Einstein.jpg/440px-Rabindranath_with_Einstein.jpg 2x" data-file-width="654" data-file-height="500" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Rabindranath_with_Einstein.jpg" class="internal" title="Enlarge"></a></div>Einstein (right) with writer, musician and Nobel laureate <a href="/wiki/Rabindranath_Tagore" title="Rabindranath Tagore">Rabindranath Tagore</a>, 1930</div></div></div>
<p>Einstein developed an appreciation for music at an early age. In his late journals he wrote: "If I were not a physicist, I would probably be a musician. I often think in music. I live my daydreams in music. I see my life in terms of music... I get most joy in life out of music."<sup id="cite_ref-BQH5A_157-0" class="reference"><a href="#cite_note-BQH5A-157">&#91;154&#93;</a></sup><sup id="cite_ref-aBOjz_158-0" class="reference"><a href="#cite_note-aBOjz-158">&#91;155&#93;</a></sup>
</p><p>His mother played the piano reasonably well and wanted her son to learn the <a href="/wiki/Violin" title="Violin">violin</a>, not only to instill in him a love of music but also to help him assimilate into <a href="/wiki/German_culture" class="mw-redirect" title="German culture">German culture</a>. According to conductor <a href="/wiki/Leon_Botstein" title="Leon Botstein">Leon Botstein</a>, Einstein began playing when he was 5. However, he did not enjoy it at that age.<sup id="cite_ref-Botstein_159-0" class="reference"><a href="#cite_note-Botstein-159">&#91;156&#93;</a></sup>
</p><p>When he turned 13, he discovered the <a href="/wiki/Mozart_violin_sonatas" class="mw-redirect" title="Mozart violin sonatas">violin sonatas of Mozart</a>, whereupon he became enamored of <a href="/wiki/Wolfgang_Amadeus_Mozart" title="Wolfgang Amadeus Mozart">Mozart</a>\'s compositions and studied music more willingly. Einstein taught himself to play without "ever practicing systematically". He said that "love is a better teacher than a sense of duty."<sup id="cite_ref-Botstein_159-1" class="reference"><a href="#cite_note-Botstein-159">&#91;156&#93;</a></sup> At age 17, he was heard by a school examiner in Aarau while playing <a href="/wiki/Beethoven%27s_violin_sonatas_(disambiguation)" class="mw-redirect" title="Beethoven&#39;s violin sonatas (disambiguation)">Beethoven\'s violin sonatas</a>. The examiner stated afterward that his playing was "remarkable and revealing of \'great insight\'". What struck the examiner, writes Botstein, was that Einstein "displayed a deep love of the music, a quality that was and remains in short supply. Music possessed an unusual meaning for this student."<sup id="cite_ref-Botstein_159-2" class="reference"><a href="#cite_note-Botstein-159">&#91;156&#93;</a></sup>
</p><p>Music took on a pivotal and permanent role in Einstein\'s life from that period on. Although the idea of becoming a professional musician himself was not on his mind at any time, among those with whom Einstein played <a href="/wiki/Chamber_music" title="Chamber music">chamber music</a> were a few professionals, and he performed for private audiences and friends. Chamber music had also become a regular part of his social life while living in Bern, Zürich, and Berlin, where he played with Max Planck and his son, among others. He is sometimes erroneously credited as the editor of the 1937 edition of the <a href="/wiki/K%C3%B6chel_catalog" class="mw-redirect" title="Köchel catalog">Köchel catalog</a> of Mozart\'s work; that edition was prepared by <a href="/wiki/Alfred_Einstein" title="Alfred Einstein">Alfred Einstein</a>, who may have been a distant relation.<sup id="cite_ref-kGuWC_160-0" class="reference"><a href="#cite_note-kGuWC-160">&#91;157&#93;</a></sup><sup id="cite_ref-OIn6p_161-0" class="reference"><a href="#cite_note-OIn6p-161">&#91;158&#93;</a></sup>
</p><p>In 1931, while engaged in research at the California Institute of Technology, he visited the Zoellner family conservatory in Los Angeles, where he played some of <a href="/wiki/Ludwig_van_Beethoven" title="Ludwig van Beethoven">Beethoven</a> and Mozart\'s works with members of the <a href="/wiki/Zoellner_Quartet" title="Zoellner Quartet">Zoellner Quartet</a>.<sup id="cite_ref-Times_162-0" class="reference"><a href="#cite_note-Times-162">&#91;159&#93;</a></sup><sup id="cite_ref-RR_163-0" class="reference"><a href="#cite_note-RR-163">&#91;160&#93;</a></sup> Near the end of his life, when the young <a href="/wiki/Juilliard_Quartet" class="mw-redirect" title="Juilliard Quartet">Juilliard Quartet</a> visited him in Princeton, he played his violin with them, and the quartet was "impressed by Einstein\'s level of coordination and intonation".<sup id="cite_ref-Botstein_159-3" class="reference"><a href="#cite_note-Botstein-159">&#91;156&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Political_and_religious_views">Political and religious views</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main articles: <a href="/wiki/Political_views_of_Albert_Einstein" title="Political views of Albert Einstein">Political views of Albert Einstein</a> and <a href="/wiki/Religious_and_philosophical_views_of_Albert_Einstein" title="Religious and philosophical views of Albert Einstein">Religious and philosophical views of Albert Einstein</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Einsteinwiezmann.PNG" class="image"><img alt="Casual group shot of four men and two women standing on a brick pavement." src="//upload.wikimedia.org/wikipedia/commons/thumb/c/c4/Einsteinwiezmann.PNG/220px-Einsteinwiezmann.PNG" decoding="async" width="220" height="166" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/c/c4/Einsteinwiezmann.PNG/330px-Einsteinwiezmann.PNG 1.5x, //upload.wikimedia.org/wikipedia/commons/c/c4/Einsteinwiezmann.PNG 2x" data-file-width="396" data-file-height="299" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einsteinwiezmann.PNG" class="internal" title="Enlarge"></a></div>Albert Einstein with his wife <a href="/wiki/Elsa_Einstein" title="Elsa Einstein">Elsa Einstein</a> and Zionist leaders, including future <a href="/wiki/President_of_Israel" title="President of Israel">President of Israel</a> <a href="/wiki/Chaim_Weizmann" title="Chaim Weizmann">Chaim Weizmann</a>, his wife <a href="/wiki/Vera_Weizmann" title="Vera Weizmann">Vera Weizmann</a>, <a href="/wiki/Menahem_Ussishkin" class="mw-redirect" title="Menahem Ussishkin">Menahem Ussishkin</a>, and Ben-Zion Mossinson on arrival in New York City in 1921</div></div></div>
<p>In 1918, Einstein was one of the founding members of the <a href="/wiki/German_Democratic_Party" title="German Democratic Party">German Democratic Party</a>, a <a href="/wiki/Liberalism" title="Liberalism">liberal</a> party.<sup id="cite_ref-FOOTNOTERoweSchulmann200783_164-0" class="reference"><a href="#cite_note-FOOTNOTERoweSchulmann200783-164">&#91;161&#93;</a></sup> However, later in his life, Einstein\'s political view was in favor of <a href="/wiki/Socialism" title="Socialism">socialism</a> and critical of capitalism, which he detailed in his essays such as "<a href="/wiki/Why_Socialism%3F" title="Why Socialism?">Why Socialism?</a>"<sup id="cite_ref-FOOTNOTEEinstein1949_165-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1949-165">&#91;162&#93;</a></sup><sup id="cite_ref-LXsUJ_166-0" class="reference"><a href="#cite_note-LXsUJ-166">&#91;163&#93;</a></sup> His opinions on the <a href="/wiki/Bolsheviks" title="Bolsheviks">Bolsheviks</a> also changed with time. In 1925, he criticized them for not having a \'well-regulated system of government\' and called their rule a \'regime of terror and a tragedy in human history\'. He later adopted a more balanced view, criticizing their methods but praising them, which is shown by his 1929 remark on <a href="/wiki/Vladimir_Lenin" title="Vladimir Lenin">Vladimir Lenin</a>: "In Lenin I honor a man, who in total sacrifice of his own person has committed his entire energy to realizing social justice. I do not find his methods advisable. One thing is certain, however: men like him are the guardians and renewers of mankind\'s conscience."<sup id="cite_ref-FOOTNOTERoweSchulmann2013&#91;httpsbooksgooglecombooksid_X1dAAAAQBAJpgPA413_412,_413&#93;_167-0" class="reference"><a href="#cite_note-FOOTNOTERoweSchulmann2013[httpsbooksgooglecombooksid_X1dAAAAQBAJpgPA413_412,_413]-167">&#91;164&#93;</a></sup> Einstein offered and was called on to give judgments and opinions on matters often unrelated to theoretical physics or mathematics.<sup id="cite_ref-FOOTNOTEClark1971_125-4" class="reference"><a href="#cite_note-FOOTNOTEClark1971-125">&#91;123&#93;</a></sup> He strongly advocated the idea of a democratic <a href="/wiki/World_government" title="World government">global government</a> that would check the power of nation-states in the framework of a world federation.<sup id="cite_ref-FOOTNOTEIsaacson2007487,_494,_550_168-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007487,_494,_550-168">&#91;165&#93;</a></sup> The FBI created a secret dossier on Einstein in 1932, and by the time of his death his FBI file was 1,427 pages long.<sup id="cite_ref-ixWWZ_169-0" class="reference"><a href="#cite_note-ixWWZ-169">&#91;166&#93;</a></sup>
</p><p>Einstein was deeply impressed by <a href="/wiki/Mahatma_Gandhi" title="Mahatma Gandhi">Mahatma Gandhi</a>, with whom he exchanged written letters. He described Gandhi as "a role model for the generations to come".<sup id="cite_ref-Albano-Müller_170-0" class="reference"><a href="#cite_note-Albano-Müller-170">&#91;167&#93;</a></sup>
</p><p>Einstein spoke of his spiritual outlook in a wide array of original writings and interviews.<sup id="cite_ref-018QJ_171-0" class="reference"><a href="#cite_note-018QJ-171">&#91;168&#93;</a></sup> Einstein stated that he had sympathy for the impersonal <a href="/wiki/Pantheism" title="Pantheism">pantheistic</a> God of <a href="/wiki/Spinozism" title="Spinozism">Baruch Spinoza\'s philosophy</a>.<sup id="cite_ref-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidG_iziBAPXtECpgPA325_325&#93;_172-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidG_iziBAPXtECpgPA325_325]-172">&#91;169&#93;</a></sup> He did not believe in a <a href="/wiki/Personal_god" title="Personal god">personal god</a> who concerns himself with fates and actions of human beings, a view which he described as naïve.<sup id="cite_ref-FOOTNOTECalaprice2000218_173-0" class="reference"><a href="#cite_note-FOOTNOTECalaprice2000218-173">&#91;170&#93;</a></sup> He clarified, however, that "I am not an atheist",<sup id="cite_ref-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidcdxWNE7NY6QCpgPT390_390&#93;_174-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidcdxWNE7NY6QCpgPT390_390]-174">&#91;171&#93;</a></sup> preferring to call himself an <a href="/wiki/Agnosticism" title="Agnosticism">agnostic</a>,<sup id="cite_ref-FOOTNOTECalaprice2010&#91;httpsbooksgooglecombooksidG_iziBAPXtECpgPA340_340&#93;_175-0" class="reference"><a href="#cite_note-FOOTNOTECalaprice2010[httpsbooksgooglecombooksidG_iziBAPXtECpgPA340_340]-175">&#91;172&#93;</a></sup><sup id="cite_ref-flickr2687_176-0" class="reference"><a href="#cite_note-flickr2687-176">&#91;173&#93;</a></sup> or a "deeply religious nonbeliever".<sup id="cite_ref-FOOTNOTECalaprice2000218_173-1" class="reference"><a href="#cite_note-FOOTNOTECalaprice2000218-173">&#91;170&#93;</a></sup> When asked if he believed in an <a href="/wiki/Afterlife" title="Afterlife">afterlife</a>, Einstein replied, "No. And one life is enough for me."<sup id="cite_ref-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidOzSJgdwk5esCpgPT461_461&#93;_177-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidOzSJgdwk5esCpgPT461_461]-177">&#91;174&#93;</a></sup>
</p><p>Einstein was primarily affiliated with non-religious <a href="/wiki/Secular_humanist" class="mw-redirect" title="Secular humanist">humanist</a> and <a href="/wiki/Ethical_Culture" class="mw-redirect" title="Ethical Culture">Ethical Culture</a> groups in both the UK and US. He served on the advisory board of the <a href="/wiki/First_Humanist_Society_of_New_York" title="First Humanist Society of New York">First Humanist Society of New York</a>,<sup id="cite_ref-mKToJ_178-0" class="reference"><a href="#cite_note-mKToJ-178">&#91;175&#93;</a></sup> and was an honorary associate of the <a href="/wiki/Rationalist_Association" title="Rationalist Association">Rationalist Association</a>, which publishes <i><a href="/wiki/New_Humanist" title="New Humanist">New Humanist</a></i> in Britain. For the 75th anniversary of the <a href="/wiki/New_York_Society_for_Ethical_Culture" class="mw-redirect" title="New York Society for Ethical Culture">New York Society for Ethical Culture</a>, he stated that the idea of Ethical Culture embodied his personal conception of what is most valuable and enduring in religious idealism. He observed, "Without \'ethical culture\' there is no salvation for humanity."<sup id="cite_ref-FOOTNOTEEinstein1995&#91;httpsbooksgooglecombooksid9fJkBqwDD3sCpgPA62_62&#93;_179-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1995[httpsbooksgooglecombooksid9fJkBqwDD3sCpgPA62_62]-179">&#91;176&#93;</a></sup>
</p><p>
In a German-language letter to philosopher <a href="/wiki/Eric_Gutkind" title="Eric Gutkind">Eric Gutkind</a>, dated 3 January 1954, Einstein wrote:</p><blockquote><p>The word <a href="/wiki/God_(word)" title="God (word)">God</a> is for me nothing more than the expression and product of human weaknesses, the <a href="/wiki/Bible" title="Bible">Bible</a> a collection of honorable, but still primitive legends which are nevertheless pretty childish. No interpretation no matter how subtle can (for me) change this. ... For me the <a href="/wiki/Jewish_religion" class="mw-redirect" title="Jewish religion">Jewish religion</a> like all other religions is an incarnation of the most childish superstitions. And the <a href="/wiki/Jewish_people" class="mw-redirect" title="Jewish people">Jewish people</a> to whom I gladly belong and with whose mentality I have a deep affinity have no different quality for me than all other people. ... I cannot see anything \'<a href="/wiki/Jews_as_the_chosen_people" title="Jews as the chosen people">chosen</a>\' about them.<sup id="cite_ref-xI99y_180-0" class="reference"><a href="#cite_note-xI99y-180">&#91;177&#93;</a></sup></p></blockquote>
<h3><span class="mw-headline" id="Death">Death</span></h3>
<p>On 17 April 1955, Einstein experienced <a href="/wiki/Internal_bleeding" title="Internal bleeding">internal bleeding</a> caused by the rupture of an <a href="/wiki/Abdominal_aortic_aneurysm" title="Abdominal aortic aneurysm">abdominal aortic aneurysm</a>, which had previously been reinforced surgically by <a href="/wiki/Rudolph_Nissen" title="Rudolph Nissen">Rudolph Nissen</a> in 1948.<sup id="cite_ref-BXLfp_181-0" class="reference"><a href="#cite_note-BXLfp-181">&#91;178&#93;</a></sup> He took the draft of a speech he was preparing for a television appearance commemorating the state of Israel\'s seventh anniversary with him to the hospital, but he did not live to complete it.<sup id="cite_ref-QN45b_182-0" class="reference"><a href="#cite_note-QN45b-182">&#91;179&#93;</a></sup>
</p><p>Einstein refused surgery, saying, "I want to go when I want. It is tasteless to prolong life artificially. I have done my share; it is time to go. I will do it elegantly."<sup id="cite_ref-BhiNM_183-0" class="reference"><a href="#cite_note-BhiNM-183">&#91;180&#93;</a></sup> He died in <a href="/wiki/Princeton_Hospital" class="mw-redirect" title="Princeton Hospital">Princeton Hospital</a> early the next morning at the age of 76, having continued to work until near the end.<sup id="cite_ref-YUhsl_184-0" class="reference"><a href="#cite_note-YUhsl-184">&#91;181&#93;</a></sup>
</p><p>During the autopsy, the pathologist of Princeton Hospital, <a href="/wiki/Thomas_Stoltz_Harvey" title="Thomas Stoltz Harvey">Thomas Stoltz Harvey</a>, removed <a href="/wiki/Albert_Einstein%27s_brain" title="Albert Einstein&#39;s brain">Einstein\'s brain</a> for preservation without the permission of his family, in the hope that the <a href="/wiki/Neuroscience" title="Neuroscience">neuroscience</a> of the future would be able to discover what made Einstein so <a href="/wiki/Human_intelligence" title="Human intelligence">intelligent</a>.<sup id="cite_ref-MqyYW_185-0" class="reference"><a href="#cite_note-MqyYW-185">&#91;182&#93;</a></sup> Einstein\'s remains were <a href="/wiki/Cremation" title="Cremation">cremated</a> in <a href="/wiki/Trenton,_New_Jersey" title="Trenton, New Jersey">Trenton</a>, New Jersey, <sup id="cite_ref-186" class="reference"><a href="#cite_note-186">&#91;183&#93;</a></sup> and his ashes were scattered at an undisclosed location.<sup id="cite_ref-GQrBZ_187-0" class="reference"><a href="#cite_note-GQrBZ-187">&#91;184&#93;</a></sup><sup id="cite_ref-Obit_188-0" class="reference"><a href="#cite_note-Obit-188">&#91;185&#93;</a></sup>
</p><p>In a memorial lecture delivered on 13 December 1965 at <a href="/wiki/UNESCO" title="UNESCO">UNESCO</a> headquarters, nuclear physicist <a href="/wiki/J._Robert_Oppenheimer" title="J. Robert Oppenheimer">J. Robert Oppenheimer</a> summarized his impression of Einstein as a person: "He was almost wholly without sophistication and wholly without worldliness&#160;... There was always with him a wonderful purity at once childlike and profoundly stubborn."<sup id="cite_ref-aJHxn_189-0" class="reference"><a href="#cite_note-aJHxn-189">&#91;186&#93;</a></sup>
</p>
<h2><span class="mw-headline" id="Scientific_career">Scientific career</span></h2>
<p>Throughout his life, Einstein published hundreds of books and articles.<sup id="cite_ref-Bio_6-3" class="reference"><a href="#cite_note-Bio-6">&#91;5&#93;</a></sup><sup id="cite_ref-Paul_Arthur_Schilpp,_editor_1951_730–746_190-0" class="reference"><a href="#cite_note-Paul_Arthur_Schilpp,_editor_1951_730–746-190">&#91;187&#93;</a></sup> He published more than 300 scientific papers and 150 non-scientific ones.<sup id="cite_ref-Nobel_13-1" class="reference"><a href="#cite_note-Nobel-13">&#91;12&#93;</a></sup><sup id="cite_ref-Paul_Arthur_Schilpp,_editor_1951_730–746_190-1" class="reference"><a href="#cite_note-Paul_Arthur_Schilpp,_editor_1951_730–746-190">&#91;187&#93;</a></sup> On 5 December 2014, universities and archives announced the release of Einstein\'s papers, comprising more than 30,000 unique documents.<sup id="cite_ref-FOOTNOTEStachel_et_al.2008_191-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008-191">&#91;188&#93;</a></sup><sup id="cite_ref-NYT-20141204-DB_192-0" class="reference"><a href="#cite_note-NYT-20141204-DB-192">&#91;189&#93;</a></sup> Einstein\'s intellectual achievements and originality have made the word "Einstein" synonymous with "<a href="/wiki/Genius" title="Genius">genius</a>".<sup id="cite_ref-wordnetweb.princeton.edu_12-1" class="reference"><a href="#cite_note-wordnetweb.princeton.edu-12">&#91;11&#93;</a></sup> In addition to the work he did by himself he also collaborated with other scientists on additional projects including the <a href="/wiki/Bose%E2%80%93Einstein_statistics" title="Bose–Einstein statistics">Bose–Einstein statistics</a>, the <a href="/wiki/Einstein_refrigerator" title="Einstein refrigerator">Einstein refrigerator</a> and others.<sup id="cite_ref-Instituut-Lorentz_193-0" class="reference"><a href="#cite_note-Instituut-Lorentz-193">&#91;190&#93;</a></sup><sup id="cite_ref-e5xd8_194-0" class="reference"><a href="#cite_note-e5xd8-194">&#91;191&#93;</a></sup>
</p>
<h3><span id="1905_.E2.80.93_Annus_Mirabilis_papers"></span><span class="mw-headline" id="1905_–_Annus_Mirabilis_papers">1905 – <i>Annus Mirabilis</i> papers</span></h3>
<p>The <a href="/wiki/Annus_Mirabilis_papers" title="Annus Mirabilis papers"><i>Annus Mirabilis</i> papers</a> are four articles pertaining to the <a href="/wiki/Photoelectric_effect" title="Photoelectric effect">photoelectric effect</a> (which gave rise to <a href="/wiki/Quantum_mechanics" title="Quantum mechanics">quantum theory</a>), <a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a>, the <a href="/wiki/Special_theory_of_relativity" class="mw-redirect" title="Special theory of relativity">special theory of relativity</a>, and <a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence">E = mc<sup>2</sup></a> that Einstein published in the <i>Annalen der Physik</i> scientific journal in 1905. These four works contributed substantially to the foundation of <a href="/wiki/History_of_physics#Modern_physics" title="History of physics">modern physics</a> and changed views on <a href="/wiki/Space" title="Space">space</a>, time, and <a href="/wiki/Matter" title="Matter">matter</a>. The four papers are:
</p>
<table class="wikitable">

<tbody><tr>
<th>Title <small>(translated)</small></th>
<th><small>Area of focus</small></th>
<th>Received</th>
<th>Published</th>
<th>Significance
</th></tr>
<tr>
<td>"On a Heuristic Viewpoint Concerning the Production and Transformation of Light"<sup id="cite_ref-FOOTNOTEEinstein1905a_195-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905a-195">&#91;192&#93;</a></sup></td>
<td><a href="/wiki/Photoelectric_effect" title="Photoelectric effect">Photoelectric effect</a></td>
<td>18 March</td>
<td>9 June</td>
<td>Resolved an unsolved puzzle by suggesting that energy is exchanged only in discrete amounts (<a href="/wiki/Quantum" title="Quantum">quanta</a>).<sup id="cite_ref-1Jhcb_196-0" class="reference"><a href="#cite_note-1Jhcb-196">&#91;193&#93;</a></sup> This idea was pivotal to the early development of quantum theory.<sup id="cite_ref-oJBvd_197-0" class="reference"><a href="#cite_note-oJBvd-197">&#91;194&#93;</a></sup>
</td></tr>
<tr>
<td>"On the Motion of Small Particles Suspended in a Stationary Liquid, as Required by the Molecular Kinetic Theory of Heat"<sup id="cite_ref-FOOTNOTEEinstein1905c_198-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905c-198">&#91;195&#93;</a></sup></td>
<td><a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a></td>
<td>11 May</td>
<td>18 July</td>
<td>Explained empirical evidence for the <a href="/wiki/Atomic_theory" title="Atomic theory">atomic theory</a>, supporting the application of <a href="/wiki/Statistical_physics" title="Statistical physics">statistical physics</a>.
</td></tr>
<tr>
<td>"On the Electrodynamics of Moving Bodies"<sup id="cite_ref-FOOTNOTEEinstein1905d_199-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905d-199">&#91;196&#93;</a></sup></td>
<td><a href="/wiki/Special_relativity" title="Special relativity">Special relativity</a></td>
<td>30 June</td>
<td>26&#160;September</td>
<td>Reconciled Maxwell\'s equations for electricity and magnetism with the laws of mechanics by introducing changes to mechanics, resulting from analysis based on empirical evidence that the speed of light is independent of the motion of the observer.<sup id="cite_ref-RhZ8x_200-0" class="reference"><a href="#cite_note-RhZ8x-200">&#91;197&#93;</a></sup> Discredited the concept of a "<a href="/wiki/Luminiferous_ether" class="mw-redirect" title="Luminiferous ether">luminiferous ether</a>".<sup id="cite_ref-lhfJ9_201-0" class="reference"><a href="#cite_note-lhfJ9-201">&#91;198&#93;</a></sup>
</td></tr>
<tr>
<td>"Does the Inertia of a Body Depend Upon Its Energy Content?"<sup id="cite_ref-FOOTNOTEEinstein1905e_202-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905e-202">&#91;199&#93;</a></sup></td>
<td><a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence"><span class="nowrap">Matter–energy</span> equivalence</a></td>
<td>27&#160;September</td>
<td>21 November</td>
<td>Equivalence of matter and energy, <span class="nowrap"><i>E</i> = <i>mc</i><sup>2</sup></span> (and by implication, the ability of gravity to "bend" light), the existence of "<a href="/wiki/Rest_energy" class="mw-redirect" title="Rest energy">rest energy</a>", and the basis of nuclear energy.
</td></tr></tbody></table>
<h3><span class="mw-headline" id="Statistical_mechanics">Statistical mechanics</span></h3>
<h4><span class="mw-headline" id="Thermodynamic_fluctuations_and_statistical_physics">Thermodynamic fluctuations and statistical physics</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main articles: <a href="/wiki/Statistical_mechanics" title="Statistical mechanics">Statistical mechanics</a>, <a href="/wiki/Thermal_fluctuations" title="Thermal fluctuations">thermal fluctuations</a>, and <a href="/wiki/Statistical_physics" title="Statistical physics">statistical physics</a></div>
<p>Einstein\'s first paper<sup id="cite_ref-FOOTNOTEEinstein1901_76-1" class="reference"><a href="#cite_note-FOOTNOTEEinstein1901-76">&#91;74&#93;</a></sup><sup id="cite_ref-PubList_203-0" class="reference"><a href="#cite_note-PubList-203">&#91;200&#93;</a></sup> submitted in 1900 to <i>Annalen der Physik</i> was on <a href="/wiki/Capillary_attraction" class="mw-redirect" title="Capillary attraction">capillary attraction</a>. It was published in 1901 with the title "Folgerungen aus den Capillaritätserscheinungen", which translates as "Conclusions from the capillarity phenomena". Two papers he published in 1902–1903 (thermodynamics) attempted to interpret <a href="/wiki/Atom" title="Atom">atomic</a> phenomena from a statistical point of view. These papers were the foundation for the 1905 paper on Brownian motion, which showed that Brownian movement can be construed as firm evidence that molecules exist. His research in 1903 and 1904 was mainly concerned with the effect of finite atomic size on diffusion phenomena.<sup id="cite_ref-PubList_203-1" class="reference"><a href="#cite_note-PubList-203">&#91;200&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Theory_of_critical_opalescence">Theory of critical opalescence</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Critical_opalescence" title="Critical opalescence">Critical opalescence</a></div>
<p>Einstein returned to the problem of thermodynamic fluctuations, giving a treatment of the density variations in a fluid at its critical point. Ordinarily the density fluctuations are controlled by the second derivative of the free energy with respect to the density. At the critical point, this derivative is zero, leading to large fluctuations. The effect of density fluctuations is that light of all wavelengths is scattered, making the fluid look milky white. Einstein relates this to <a href="/wiki/Rayleigh_scattering" title="Rayleigh scattering">Rayleigh scattering</a>, which is what happens when the fluctuation size is much smaller than the wavelength, and which explains why the sky is blue.<sup id="cite_ref-L2N73_204-0" class="reference"><a href="#cite_note-L2N73-204">&#91;201&#93;</a></sup> Einstein quantitatively derived critical opalescence from a treatment of density fluctuations, and demonstrated how both the effect and Rayleigh scattering originate from the atomistic constitution of matter.
</p>
<h3><span class="mw-headline" id="Special_relativity">Special relativity</span></h3>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/History_of_special_relativity" title="History of special relativity">History of special relativity</a></div>
<p>Einstein\'s "<i>Zur Elektrodynamik bewegter Körper</i>"<sup id="cite_ref-FOOTNOTEEinstein1905d_199-1" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905d-199">&#91;196&#93;</a></sup> ("On the Electrodynamics of Moving Bodies") was received on 30 June 1905 and published 26 September of that same year. It reconciled conflicts between <a href="/wiki/Maxwell%27s_equations" title="Maxwell&#39;s equations">Maxwell\'s equations</a> (the laws of electricity and magnetism) and the laws of Newtonian mechanics by introducing changes to the laws of mechanics.<sup id="cite_ref-FOOTNOTEFölsing1997178–198_205-0" class="reference"><a href="#cite_note-FOOTNOTEFölsing1997178–198-205">&#91;202&#93;</a></sup> Observationally, the effects of these changes are most apparent at high speeds (where objects are moving at speeds close to the <a href="/wiki/Speed_of_light" title="Speed of light">speed of light</a>). The theory developed in this paper later became known as Einstein\'s special theory of relativity. There is evidence from Einstein\'s writings that he collaborated with his first wife, Mileva Marić, on this work. The decision to publish only under his name seems to have been mutual, but the exact reason is unknown.<sup id="cite_ref-mileva_36-3" class="reference"><a href="#cite_note-mileva-36">&#91;34&#93;</a></sup>
</p><p>This paper predicted that, when measured in the frame of a relatively moving observer, a clock carried by a moving body would appear to <a href="/wiki/Time_dilation" title="Time dilation">slow down</a>, and the body itself would <a href="/wiki/Length_contraction" title="Length contraction">contract</a> in its direction of motion. This paper also argued that the idea of a <a href="/wiki/Luminiferous_aether" title="Luminiferous aether">luminiferous aether</a>—one of the leading theoretical entities in physics at the time—was superfluous.<sup id="cite_ref-aBfxO_206-0" class="reference"><a href="#cite_note-aBfxO-206">&#91;note 4&#93;</a></sup>
</p><p>In his paper on <a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence">mass–energy equivalence</a>, Einstein produced <i>E</i>&#160;=&#160;<i>mc</i><sup>2</sup> as a consequence of his special relativity equations.<sup id="cite_ref-FOOTNOTEStachel2002vi,_15,_90,_131,_&#91;httpsbooksgooglecomidOAsQ_hFjhrACpgPA215_215&#93;_207-0" class="reference"><a href="#cite_note-FOOTNOTEStachel2002vi,_15,_90,_131,_[httpsbooksgooglecomidOAsQ_hFjhrACpgPA215_215]-207">&#91;203&#93;</a></sup> Einstein\'s 1905 work on relativity remained controversial for many years, but was accepted by leading physicists, starting with <a href="/wiki/Max_Planck" title="Max Planck">Max Planck</a>.<sup id="cite_ref-sBl2q_208-0" class="reference"><a href="#cite_note-sBl2q-208">&#91;note 5&#93;</a></sup><sup id="cite_ref-FOOTNOTEPais1982382–386_209-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982382–386-209">&#91;204&#93;</a></sup>
</p><p>Einstein originally framed special relativity in terms of <a href="/wiki/Kinematics" title="Kinematics">kinematics</a> (the study of moving bodies). In 1908, <a href="/wiki/Hermann_Minkowski" title="Hermann Minkowski">Hermann Minkowski</a> reinterpreted special relativity in geometric terms as a theory of <a href="/wiki/Spacetime" title="Spacetime">spacetime</a>. Einstein adopted Minkowski\'s formalism in his 1915 <a href="/wiki/General_relativity" title="General relativity">general theory of relativity</a>.<sup id="cite_ref-FOOTNOTEPais1982151–152_210-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982151–152-210">&#91;205&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="General_relativity">General relativity</span></h3>
<h4><span class="mw-headline" id="General_relativity_and_the_equivalence_principle">General relativity and the equivalence principle</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/History_of_general_relativity" title="History of general relativity">History of general relativity</a></div>
<div role="note" class="hatnote navigation-not-searchable">See also: <a href="/wiki/Theory_of_relativity" title="Theory of relativity">Theory of relativity</a> and <a href="/wiki/Einstein_field_equations" title="Einstein field equations">Einstein field equations</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:1919_eclipse_positive.jpg" class="image"><img alt="Black circle covering the sun, rays visible around it, in a dark sky." src="//upload.wikimedia.org/wikipedia/commons/thumb/3/37/1919_eclipse_positive.jpg/170px-1919_eclipse_positive.jpg" decoding="async" width="170" height="218" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/3/37/1919_eclipse_positive.jpg/255px-1919_eclipse_positive.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/37/1919_eclipse_positive.jpg/340px-1919_eclipse_positive.jpg 2x" data-file-width="700" data-file-height="899" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:1919_eclipse_positive.jpg" class="internal" title="Enlarge"></a></div><a href="/wiki/Arthur_Stanley_Eddington" class="mw-redirect" title="Arthur Stanley Eddington">Eddington</a>\'s photograph of a <a href="/wiki/Solar_eclipse" title="Solar eclipse">solar eclipse</a></div></div></div>
<p>General relativity (GR) is a <a href="/wiki/Theory_of_gravitation" class="mw-redirect" title="Theory of gravitation">theory of gravitation</a> that was developed by Einstein between 1907 and 1915. According to <a href="/wiki/General_relativity" title="General relativity">general relativity</a>, the observed gravitational attraction between masses results from the warping of <a href="/wiki/Spacetime" title="Spacetime">space and time</a> by those masses. General relativity has developed into an essential tool in modern <a href="/wiki/Astrophysics" title="Astrophysics">astrophysics</a>. It provides the foundation for the current understanding of <a href="/wiki/Black_holes" class="mw-redirect" title="Black holes">black holes</a>, regions of space where gravitational attraction is so strong that not even light can escape.
</p><p>As Einstein later said, the reason for the development of general relativity was that the preference of inertial motions within <a href="/wiki/Special_relativity" title="Special relativity">special relativity</a> was unsatisfactory, while a theory which from the outset prefers no state of motion (even accelerated ones) should appear more satisfactory.<sup id="cite_ref-FOOTNOTEEinstein1923_211-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1923-211">&#91;206&#93;</a></sup> Consequently, in 1907 he published an article on acceleration under special relativity. In that article titled "On the Relativity Principle and the Conclusions Drawn from It", he argued that <a href="/wiki/Free_fall" title="Free fall">free fall</a> is really inertial motion, and that for a free-falling observer the rules of special relativity must apply. This argument is called the <a href="/wiki/Equivalence_principle" title="Equivalence principle">equivalence principle</a>. In the same article, Einstein also predicted the phenomena of <a href="/wiki/Gravitational_time_dilation" title="Gravitational time dilation">gravitational time dilation</a>, <a href="/wiki/Gravitational_redshift" title="Gravitational redshift">gravitational redshift</a> and <a href="/wiki/Gravitational_lensing" class="mw-redirect" title="Gravitational lensing">deflection of light</a>.<sup id="cite_ref-FOOTNOTEPais1982179–183_212-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982179–183-212">&#91;207&#93;</a></sup><sup id="cite_ref-FOOTNOTEStachel_et_al.2008273–274vol._2:_The_Swiss_Years:_Writings,_1900–1909_213-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008273–274vol._2:_The_Swiss_Years:_Writings,_1900–1909-213">&#91;208&#93;</a></sup>
</p><p>In 1911, Einstein published another article "On the Influence of Gravitation on the Propagation of Light" expanding on the 1907 article, in which he estimated the amount of deflection of light by massive bodies. Thus, the theoretical prediction of general relativity could for the first time be tested experimentally.<sup id="cite_ref-FOOTNOTEPais1982194–195_214-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982194–195-214">&#91;209&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Gravitational_waves">Gravitational waves</span></h4>
<p>In 1916, Einstein predicted <a href="/wiki/Gravitational_wave" title="Gravitational wave">gravitational waves</a>,<sup id="cite_ref-FOOTNOTEEinstein1916_215-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1916-215">&#91;210&#93;</a></sup><sup id="cite_ref-FOOTNOTEEinstein1918_216-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1918-216">&#91;211&#93;</a></sup> ripples in the <a href="/wiki/Curvature" title="Curvature">curvature</a> of spacetime which propagate as <a href="/wiki/Wave" title="Wave">waves</a>, traveling outward from the source, transporting energy as gravitational radiation. The existence of gravitational waves is possible under general relativity due to its <a href="/wiki/Lorentz_invariance" class="mw-redirect" title="Lorentz invariance">Lorentz invariance</a> which brings the concept of a finite speed of propagation of the physical interactions of gravity with it. By contrast, gravitational waves cannot exist in the <a href="/wiki/Newton%27s_law_of_universal_gravitation" title="Newton&#39;s law of universal gravitation">Newtonian theory of gravitation</a>, which postulates that the physical interactions of gravity propagate at infinite speed.
</p><p>The first, indirect, detection of gravitational waves came in the 1970s through observation of a pair of closely orbiting <a href="/wiki/Neutron_stars" class="mw-redirect" title="Neutron stars">neutron stars</a>, <a href="/wiki/PSR_B1913%2B16" class="mw-redirect" title="PSR B1913+16">PSR B1913+16</a>.<sup id="cite_ref-natgeo_217-0" class="reference"><a href="#cite_note-natgeo-217">&#91;212&#93;</a></sup> The explanation of the decay in their orbital period was that they were emitting gravitational waves.<sup id="cite_ref-natgeo_217-1" class="reference"><a href="#cite_note-natgeo-217">&#91;212&#93;</a></sup><sup id="cite_ref-Tf1T0_218-0" class="reference"><a href="#cite_note-Tf1T0-218">&#91;213&#93;</a></sup> Einstein\'s prediction was confirmed on 11 February 2016, when researchers at <a href="/wiki/LIGO" title="LIGO">LIGO</a> published the <a href="/wiki/First_observation_of_gravitational_waves" title="First observation of gravitational waves">first observation of gravitational waves</a>,<sup id="cite_ref-PRL-20160211_219-0" class="reference"><a href="#cite_note-PRL-20160211-219">&#91;214&#93;</a></sup> detected on Earth on 14 September 2015, nearly one hundred years after the prediction.<sup id="cite_ref-natgeo_217-2" class="reference"><a href="#cite_note-natgeo-217">&#91;212&#93;</a></sup><sup id="cite_ref-CO6kH_220-0" class="reference"><a href="#cite_note-CO6kH-220">&#91;215&#93;</a></sup><sup id="cite_ref-oSmHb_221-0" class="reference"><a href="#cite_note-oSmHb-221">&#91;216&#93;</a></sup><sup id="cite_ref-hkKSp_222-0" class="reference"><a href="#cite_note-hkKSp-222">&#91;217&#93;</a></sup><sup id="cite_ref-38Msx_223-0" class="reference"><a href="#cite_note-38Msx-223">&#91;218&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Hole_argument_and_Entwurf_theory">Hole argument and Entwurf theory</span></h4>
<p>While developing general relativity, Einstein became confused about the <a href="/wiki/Gauge_invariance" class="mw-redirect" title="Gauge invariance">gauge invariance</a> in the theory. He formulated an argument that led him to conclude that a general relativistic field theory is impossible. He gave up looking for fully generally covariant tensor equations and searched for equations that would be invariant under general linear transformations only.
</p><p>In June 1913, the Entwurf (\'draft\') theory was the result of these investigations. As its name suggests, it was a sketch of a theory, less elegant and more difficult than general relativity, with the equations of motion supplemented by additional gauge fixing conditions. After more than two years of intensive work, Einstein realized that the <a href="/wiki/Hole_argument" title="Hole argument">hole argument</a> was mistaken<sup id="cite_ref-sOA9t_224-0" class="reference"><a href="#cite_note-sOA9t-224">&#91;219&#93;</a></sup> and abandoned the theory in November 1915.
</p>
<h4><span class="mw-headline" id="Physical_cosmology">Physical cosmology</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Physical_cosmology" title="Physical cosmology">Physical cosmology</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:MillikanLemaitreEinstein.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/c/c6/MillikanLemaitreEinstein.jpg/220px-MillikanLemaitreEinstein.jpg" decoding="async" width="220" height="179" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/c/c6/MillikanLemaitreEinstein.jpg/330px-MillikanLemaitreEinstein.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/c/c6/MillikanLemaitreEinstein.jpg/440px-MillikanLemaitreEinstein.jpg 2x" data-file-width="711" data-file-height="577" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:MillikanLemaitreEinstein.jpg" class="internal" title="Enlarge"></a></div>Einstein with <a href="/wiki/Robert_Andrews_Millikan" title="Robert Andrews Millikan">Millikan</a> and <a href="/wiki/Georges_Lema%C3%AEtre" title="Georges Lemaître">Georges Lemaître</a> at the <a href="/wiki/California_Institute_of_Technology" title="California Institute of Technology">California Institute of Technology</a> in January 1933.</div></div></div>
<p>In 1917, Einstein applied the general theory of relativity to the structure of the universe as a whole.<sup id="cite_ref-FOOTNOTEEinstein1917a_225-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1917a-225">&#91;220&#93;</a></sup> He discovered that the general field equations predicted a universe that was dynamic, either contracting or expanding. As observational evidence for a dynamic universe was not known at the time, Einstein introduced a new term, the <a href="/wiki/Cosmological_constant" title="Cosmological constant">cosmological constant</a>, to the field equations, in order to allow the theory to predict a static universe. The modified field equations predicted a static universe of closed curvature, in accordance with Einstein\'s understanding of <a href="/wiki/Mach%27s_principle" title="Mach&#39;s principle">Mach\'s principle</a> in these years. This model became known as the Einstein World or <a href="/wiki/Einstein%27s_static_universe" title="Einstein&#39;s static universe">Einstein\'s static universe</a>.<sup id="cite_ref-FOOTNOTEPais1994285–286_226-0" class="reference"><a href="#cite_note-FOOTNOTEPais1994285–286-226">&#91;221&#93;</a></sup><sup id="cite_ref-iJwuX_227-0" class="reference"><a href="#cite_note-iJwuX-227">&#91;222&#93;</a></sup>
</p><p>Following the discovery of the recession of the nebulae by <a href="/wiki/Edwin_Hubble" title="Edwin Hubble">Edwin Hubble</a> in 1929, Einstein abandoned his static model of the universe, and proposed two dynamic models of the cosmos, <a href="/wiki/The_Friedmann-Einstein_universe" class="mw-redirect" title="The Friedmann-Einstein universe">The Friedmann-Einstein universe</a> of 1931<sup id="cite_ref-FOOTNOTEEinstein1931_228-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1931-228">&#91;223&#93;</a></sup><sup id="cite_ref-cor-2013_229-0" class="reference"><a href="#cite_note-cor-2013-229">&#91;224&#93;</a></sup> and the <a href="/wiki/Einstein%E2%80%93de_Sitter_universe" title="Einstein–de Sitter universe">Einstein–de Sitter universe</a> of 1932.<sup id="cite_ref-FOOTNOTEEinsteinde_Sitter1932_230-0" class="reference"><a href="#cite_note-FOOTNOTEEinsteinde_Sitter1932-230">&#91;225&#93;</a></sup><sup id="cite_ref-J9Tqu_231-0" class="reference"><a href="#cite_note-J9Tqu-231">&#91;226&#93;</a></sup> In each of these models, Einstein discarded the cosmological constant, claiming that it was "in any case theoretically unsatisfactory".<sup id="cite_ref-FOOTNOTEEinstein1931_228-1" class="reference"><a href="#cite_note-FOOTNOTEEinstein1931-228">&#91;223&#93;</a></sup><sup id="cite_ref-cor-2013_229-1" class="reference"><a href="#cite_note-cor-2013-229">&#91;224&#93;</a></sup><sup id="cite_ref-sxfvo_232-0" class="reference"><a href="#cite_note-sxfvo-232">&#91;227&#93;</a></sup>
</p><p>In many Einstein biographies, it is claimed that Einstein referred to the cosmological constant in later years as his "biggest blunder". The astrophysicist <a href="/wiki/Mario_Livio" title="Mario Livio">Mario Livio</a> has recently cast doubt on this claim, suggesting that it may be exaggerated.<sup id="cite_ref-qmmVf_233-0" class="reference"><a href="#cite_note-qmmVf-233">&#91;228&#93;</a></sup>
</p><p>In late 2013, a team led by the Irish physicist <a href="/wiki/Cormac_O%27Raifeartaigh" title="Cormac O&#39;Raifeartaigh">Cormac O\'Raifeartaigh</a> discovered evidence that, shortly after learning of Hubble\'s observations of the recession of the nebulae, Einstein considered a <a href="/wiki/Steady_State_theory" class="mw-redirect" title="Steady State theory">steady-state model</a> of the universe.<sup id="cite_ref-Tq53z_234-0" class="reference"><a href="#cite_note-Tq53z-234">&#91;229&#93;</a></sup><sup id="cite_ref-8pfEk_235-0" class="reference"><a href="#cite_note-8pfEk-235">&#91;230&#93;</a></sup> In a hitherto overlooked manuscript, apparently written in early 1931, Einstein explored a model of the expanding universe in which the density of matter remains constant due to a continuous creation of matter, a process he associated with the cosmological constant.<sup id="cite_ref-cor-steady-state_236-0" class="reference"><a href="#cite_note-cor-steady-state-236">&#91;231&#93;</a></sup><sup id="cite_ref-Einstein&#39;s_aborted_model_237-0" class="reference"><a href="#cite_note-Einstein&#39;s_aborted_model-237">&#91;232&#93;</a></sup> As he stated in the paper, "In what follows, I would like to draw attention to a solution to equation (1) that can account for Hubbel\'s [<i>sic</i>] facts, and in which the density is constant over time" ... "If one considers a physically bounded volume, particles of matter will be continually leaving it. For the density to remain constant, new particles of matter must be continually formed in the volume from space."
</p><p>It thus appears that Einstein considered a <a href="/wiki/Steady_State_theory" class="mw-redirect" title="Steady State theory">steady-state model</a> of the expanding universe many years before Hoyle, Bondi and Gold.<sup id="cite_ref-ILjYQ_238-0" class="reference"><a href="#cite_note-ILjYQ-238">&#91;233&#93;</a></sup><sup id="cite_ref-ThZb0_239-0" class="reference"><a href="#cite_note-ThZb0-239">&#91;234&#93;</a></sup> However, Einstein\'s steady-state model contained a fundamental flaw and he quickly abandoned the idea.<sup id="cite_ref-cor-steady-state_236-1" class="reference"><a href="#cite_note-cor-steady-state-236">&#91;231&#93;</a></sup><sup id="cite_ref-Einstein&#39;s_aborted_model_237-1" class="reference"><a href="#cite_note-Einstein&#39;s_aborted_model-237">&#91;232&#93;</a></sup><sup id="cite_ref-7ShC9_240-0" class="reference"><a href="#cite_note-7ShC9-240">&#91;235&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Energy_momentum_pseudotensor">Energy momentum pseudotensor</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Stress%E2%80%93energy%E2%80%93momentum_pseudotensor" title="Stress–energy–momentum pseudotensor">Stress–energy–momentum pseudotensor</a></div>
<p>General relativity includes a dynamical spacetime, so it is difficult to see how to identify the conserved energy and momentum. <a href="/wiki/Noether%27s_theorem" title="Noether&#39;s theorem">Noether\'s theorem</a> allows these quantities to be determined from a <a href="/wiki/Lagrangian_(field_theory)" title="Lagrangian (field theory)">Lagrangian</a> with <a href="/wiki/Translational_symmetry" title="Translational symmetry">translation invariance</a>, but <a href="/wiki/General_covariance" title="General covariance">general covariance</a> makes translation invariance into something of a <a href="/wiki/Gauge_symmetry" class="mw-redirect" title="Gauge symmetry">gauge symmetry</a>. The energy and momentum derived within general relativity by Noether\'s prescriptions do not make a real tensor for this reason.
</p><p>Einstein argued that this is true for a fundamental reason: the gravitational field could be made to vanish by a choice of coordinates. He maintained that the non-covariant energy momentum pseudotensor was, in fact, the best description of the energy momentum distribution in a gravitational field. This approach has been echoed by <a href="/wiki/Lev_Landau" title="Lev Landau">Lev Landau</a> and <a href="/wiki/Evgeny_Lifshitz" title="Evgeny Lifshitz">Evgeny Lifshitz</a>, and others, and has become standard.
</p><p>The use of non-covariant objects like pseudotensors was heavily criticized in 1917 by <a href="/wiki/Erwin_Schr%C3%B6dinger" title="Erwin Schrödinger">Erwin Schrödinger</a> and others.
</p>
<h4><span class="mw-headline" id="Wormholes">Wormholes</span></h4>
<p>In 1935, Einstein collaborated with <a href="/wiki/Nathan_Rosen" title="Nathan Rosen">Nathan Rosen</a> to produce a model of a <a href="/wiki/Wormhole" title="Wormhole">wormhole</a>, often called <a href="/wiki/Einstein%E2%80%93Rosen_bridges" class="mw-redirect" title="Einstein–Rosen bridges">Einstein–Rosen bridges</a>.<sup id="cite_ref-FOOTNOTEEinsteinRosen1935_241-0" class="reference"><a href="#cite_note-FOOTNOTEEinsteinRosen1935-241">&#91;236&#93;</a></sup><sup id="cite_ref-QNjpt_242-0" class="reference"><a href="#cite_note-QNjpt-242">&#91;237&#93;</a></sup> His motivation was to model elementary particles with charge as a solution of gravitational field equations, in line with the program outlined in the paper "Do Gravitational Fields play an Important Role in the Constitution of the Elementary Particles?". These solutions cut and pasted <a href="/wiki/Schwarzschild_black_hole" class="mw-redirect" title="Schwarzschild black hole">Schwarzschild black holes</a> to make a bridge between two patches.<sup id="cite_ref-ja7FY_243-0" class="reference"><a href="#cite_note-ja7FY-243">&#91;238&#93;</a></sup>
</p><p>If one end of a wormhole was positively charged, the other end would be negatively charged. These properties led Einstein to believe that pairs of particles and antiparticles could be described in this way.
</p>
<h4><span id="Einstein.E2.80.93Cartan_theory"></span><span class="mw-headline" id="Einstein–Cartan_theory">Einstein–Cartan theory</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein%E2%80%93Cartan_theory" title="Einstein–Cartan theory">Einstein–Cartan theory</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_photo_1920.jpg" class="image"><img alt="Einstein, sitting at a table, looks up from the papers he is reading and into the camera." src="//upload.wikimedia.org/wikipedia/commons/thumb/1/10/Albert_Einstein_photo_1920.jpg/170px-Albert_Einstein_photo_1920.jpg" decoding="async" width="170" height="245" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/1/10/Albert_Einstein_photo_1920.jpg/255px-Albert_Einstein_photo_1920.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/10/Albert_Einstein_photo_1920.jpg/340px-Albert_Einstein_photo_1920.jpg 2x" data-file-width="3875" data-file-height="5593" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_photo_1920.jpg" class="internal" title="Enlarge"></a></div>Einstein at his office, <a href="/wiki/University_of_Berlin" class="mw-redirect" title="University of Berlin">University of Berlin</a>, 1920</div></div></div><p>In order to incorporate spinning point particles into general relativity, the affine connection needed to be generalized to include an antisymmetric part, called the <a href="/wiki/Torsion_tensor" title="Torsion tensor">torsion</a>. This modification was made by Einstein and Cartan in the 1920s.
</p><h4><span class="mw-headline" id="Equations_of_motion">Equations of motion</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein%E2%80%93Infeld%E2%80%93Hoffmann_equations" title="Einstein–Infeld–Hoffmann equations">Einstein–Infeld–Hoffmann equations</a></div>
<p>The theory of general relativity has a fundamental law—the <a href="/wiki/Einstein_field_equations" title="Einstein field equations">Einstein field equations</a>, which describe how space curves. The <a href="/wiki/Geodesic_equation" class="mw-redirect" title="Geodesic equation">geodesic equation</a>, which describes how particles move, may be derived from the Einstein field equations.
</p><p>Since the equations of general relativity are non-linear, a lump of energy made out of pure gravitational fields, like a black hole, would move on a trajectory which is determined by the Einstein field equations themselves, not by a new law. So Einstein proposed that the path of a singular solution, like a black hole, would be determined to be a geodesic from general relativity itself.
</p><p>This was established by Einstein, Infeld, and Hoffmann for pointlike objects without angular momentum, and by <a href="/wiki/Roy_Kerr" title="Roy Kerr">Roy Kerr</a> for spinning objects.
</p>
<h3><span class="mw-headline" id="Old_quantum_theory">Old quantum theory</span></h3>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Old_quantum_theory" title="Old quantum theory">Old quantum theory</a></div>
<h4><span class="mw-headline" id="Photons_and_energy_quanta">Photons and energy quanta</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Photoelectric_effect_in_a_solid_-_diagram.svg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/a/a6/Photoelectric_effect_in_a_solid_-_diagram.svg/220px-Photoelectric_effect_in_a_solid_-_diagram.svg.png" decoding="async" width="220" height="220" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/a/a6/Photoelectric_effect_in_a_solid_-_diagram.svg/330px-Photoelectric_effect_in_a_solid_-_diagram.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/a/a6/Photoelectric_effect_in_a_solid_-_diagram.svg/440px-Photoelectric_effect_in_a_solid_-_diagram.svg.png 2x" data-file-width="364" data-file-height="364" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Photoelectric_effect_in_a_solid_-_diagram.svg" class="internal" title="Enlarge"></a></div>The photoelectric effect. Incoming photons on the left strike a metal plate (bottom), and eject electrons, depicted as flying off to the right.</div></div></div>
<p>In a 1905 paper,<sup id="cite_ref-FOOTNOTEEinstein1905a_195-1" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905a-195">&#91;192&#93;</a></sup> Einstein postulated that light itself consists of localized particles (<i><a href="/wiki/Quantum" title="Quantum">quanta</a></i>). Einstein\'s light quanta were nearly universally rejected by all physicists, including Max Planck and Niels Bohr. This idea only became universally accepted in 1919, with <a href="/wiki/Robert_Millikan" class="mw-redirect" title="Robert Millikan">Robert Millikan</a>\'s detailed experiments on the photoelectric effect, and with the measurement of <a href="/wiki/Compton_scattering" title="Compton scattering">Compton scattering</a>.
</p><p>Einstein concluded that each wave of frequency <i>f</i> is associated with a collection of <a href="/wiki/Photon" title="Photon">photons</a> with energy <i>hf</i> each, where <i>h</i> is <a href="/wiki/Planck%27s_constant" class="mw-redirect" title="Planck&#39;s constant">Planck\'s constant</a>. He does not say much more, because he is not sure how the particles are related to the wave. But he does suggest that this idea would explain certain experimental results, notably the photoelectric effect.<sup id="cite_ref-FOOTNOTEEinstein1905a_195-2" class="reference"><a href="#cite_note-FOOTNOTEEinstein1905a-195">&#91;192&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Quantized_atomic_vibrations">Quantized atomic vibrations</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein_solid" title="Einstein solid">Einstein solid</a></div>
<p>In 1907, Einstein proposed a model of matter where each atom in a lattice structure is an independent harmonic oscillator. In the Einstein model, each atom oscillates independently—a series of equally spaced quantized states for each oscillator. Einstein was aware that getting the frequency of the actual oscillations would be difficult, but he nevertheless proposed this theory because it was a particularly clear demonstration that quantum mechanics could solve the specific heat problem in classical mechanics. <a href="/wiki/Peter_Debye" title="Peter Debye">Peter Debye</a> refined this model.<sup id="cite_ref-ixm32_244-0" class="reference"><a href="#cite_note-ixm32-244">&#91;239&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Adiabatic_principle_and_action-angle_variables">Adiabatic principle and action-angle variables</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Adiabatic_invariant" title="Adiabatic invariant">Adiabatic invariant</a></div>
<p>Throughout the 1910s, quantum mechanics expanded in scope to cover many different systems. After <a href="/wiki/Ernest_Rutherford" title="Ernest Rutherford">Ernest Rutherford</a> discovered the nucleus and proposed that electrons orbit like planets, Niels Bohr was able to show that the same quantum mechanical postulates introduced by Planck and developed by Einstein would explain the discrete motion of electrons in atoms, and the <a href="/wiki/Periodic_table_of_the_elements" class="mw-redirect" title="Periodic table of the elements">periodic table of the elements</a>.
</p><p>Einstein contributed to these developments by linking them with the 1898 arguments <a href="/wiki/Wilhelm_Wien" title="Wilhelm Wien">Wilhelm Wien</a> had made. Wien had shown that the hypothesis of <a href="/wiki/Adiabatic_invariant" title="Adiabatic invariant">adiabatic invariance</a> of a thermal equilibrium state allows all the <a href="/wiki/Blackbody_radiation" class="mw-redirect" title="Blackbody radiation">blackbody curves</a> at different temperature to be derived from one another by a <a href="/wiki/Wien%27s_displacement_law" title="Wien&#39;s displacement law">simple shifting process</a>. Einstein noted in 1911 that the same adiabatic principle shows that the quantity which is quantized in any mechanical motion must be an adiabatic invariant. <a href="/wiki/Arnold_Sommerfeld" title="Arnold Sommerfeld">Arnold Sommerfeld</a> identified this adiabatic invariant as the <a href="/wiki/Action-angle_variables" class="mw-redirect" title="Action-angle variables">action variable</a> of classical mechanics.
</p>
<h4><span id="Bose.E2.80.93Einstein_statistics"></span><span class="mw-headline" id="Bose–Einstein_statistics">Bose–Einstein statistics</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Bose%E2%80%93Einstein_statistics" title="Bose–Einstein statistics">Bose–Einstein statistics</a></div>
<p>In 1924, Einstein received a description of a <a href="/wiki/Statistical_mechanics" title="Statistical mechanics">statistical</a> model from Indian physicist <a href="/wiki/Satyendra_Nath_Bose" title="Satyendra Nath Bose">Satyendra Nath Bose</a>, based on a counting method that assumed that light could be understood as a gas of indistinguishable particles. Einstein noted that Bose\'s statistics applied to some atoms as well as to the proposed light particles, and submitted his translation of Bose\'s paper to the <i><a href="/wiki/Zeitschrift_f%C3%BCr_Physik" title="Zeitschrift für Physik">Zeitschrift für Physik</a></i>. Einstein also published his own articles describing the model and its implications, among them the <a href="/wiki/Bose%E2%80%93Einstein_condensate" title="Bose–Einstein condensate">Bose–Einstein condensate</a> phenomenon that some particulates should appear at very low temperatures.<sup id="cite_ref-FOOTNOTEEinstein1924_245-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1924-245">&#91;240&#93;</a></sup> It was not until 1995 that the first such condensate was produced experimentally by <a href="/wiki/Eric_Allin_Cornell" title="Eric Allin Cornell">Eric Allin Cornell</a> and <a href="/wiki/Carl_Wieman" title="Carl Wieman">Carl Wieman</a> using <a href="/wiki/Ultracold_atom" title="Ultracold atom">ultra-cooling</a> equipment built at the <a href="/wiki/National_Institute_of_Standards_and_Technology" title="National Institute of Standards and Technology">NIST</a>–<a href="/wiki/JILA" title="JILA">JILA</a> laboratory at the <a href="/wiki/University_of_Colorado_at_Boulder" class="mw-redirect" title="University of Colorado at Boulder">University of Colorado at Boulder</a>.<sup id="cite_ref-nlagl_246-0" class="reference"><a href="#cite_note-nlagl-246">&#91;241&#93;</a></sup> Bose–Einstein statistics are now used to describe the behaviors of any assembly of <a href="/wiki/Boson" title="Boson">bosons</a>. Einstein\'s sketches for this project may be seen in the Einstein Archive in the library of the Leiden University.<sup id="cite_ref-Instituut-Lorentz_193-1" class="reference"><a href="#cite_note-Instituut-Lorentz-193">&#91;190&#93;</a></sup>
</p>
<h4><span id="Wave.E2.80.93particle_duality"></span><span class="mw-headline" id="Wave–particle_duality">Wave–particle duality</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Albert_Einstein_photo_1921.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/1/11/Albert_Einstein_photo_1921.jpg/170px-Albert_Einstein_photo_1921.jpg" decoding="async" width="170" height="275" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/1/11/Albert_Einstein_photo_1921.jpg/255px-Albert_Einstein_photo_1921.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/1/11/Albert_Einstein_photo_1921.jpg/340px-Albert_Einstein_photo_1921.jpg 2x" data-file-width="600" data-file-height="969" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Albert_Einstein_photo_1921.jpg" class="internal" title="Enlarge"></a></div>Einstein during his visit to the United States</div></div></div>
<p>Although the patent office promoted Einstein to Technical Examiner Second Class in 1906, he had not given up on academia. In 1908, he became a <i><a href="/wiki/Privatdozent" title="Privatdozent">Privatdozent</a></i> at the University of Bern.<sup id="cite_ref-FOOTNOTEPais1982522_247-0" class="reference"><a href="#cite_note-FOOTNOTEPais1982522-247">&#91;242&#93;</a></sup> In "<i>Über die Entwicklung unserer Anschauungen über das Wesen und die Konstitution der Strahlung</i>" ("<a href="https://en.wikisource.org/wiki/Translation:The_Development_of_Our_Views_on_the_Composition_and_Essence_of_Radiation" class="extiw" title="s:Translation:The Development of Our Views on the Composition and Essence of Radiation">The Development of our Views on the Composition and Essence of Radiation</a>"), on the <a href="/wiki/Quantization_(physics)" title="Quantization (physics)">quantization</a> of light, and in an earlier 1909 paper, Einstein showed that Max Planck\'s energy quanta must have well-defined <a href="/wiki/Momentum" title="Momentum">momenta</a> and act in some respects as independent, <a href="/wiki/Point_particle" title="Point particle">point-like particles</a>. This paper introduced the <i>photon</i> concept (although the name <i>photon</i> was introduced later by <a href="/wiki/Gilbert_N._Lewis" title="Gilbert N. Lewis">Gilbert N. Lewis</a> in 1926) and inspired the notion of <a href="/wiki/Wave%E2%80%93particle_duality" title="Wave–particle duality">wave–particle duality</a> in <a href="/wiki/Quantum_mechanics" title="Quantum mechanics">quantum mechanics</a>. Einstein saw this wave–particle duality in radiation as concrete evidence for his conviction that physics needed a new, unified foundation.
</p>
<h4><span class="mw-headline" id="Zero-point_energy">Zero-point energy</span></h4>
<p>In a series of works completed from 1911 to 1913, Planck reformulated his 1900 quantum theory and introduced the idea of <a href="/wiki/Zero-point_energy" title="Zero-point energy">zero-point energy</a> in his "second quantum theory". Soon, this idea attracted the attention of Einstein and his assistant <a href="/wiki/Otto_Stern" title="Otto Stern">Otto Stern</a>. Assuming the energy of rotating diatomic molecules contains zero-point energy, they then compared the theoretical specific heat of hydrogen gas with the experimental data. The numbers matched nicely. However, after publishing the findings, they promptly withdrew their support, because they no longer had confidence in the correctness of the idea of zero-point energy.<sup id="cite_ref-FOOTNOTEStachel_et_al.2008270ffvol._4:_The_Swiss_Years:_Writings,_1912–1914_248-0" class="reference"><a href="#cite_note-FOOTNOTEStachel_et_al.2008270ffvol._4:_The_Swiss_Years:_Writings,_1912–1914-248">&#91;243&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Stimulated_emission">Stimulated emission</span></h4>
<p>In 1917, at the height of his work on relativity, Einstein published an article in <i>Physikalische Zeitschrift</i> that proposed the possibility of <a href="/wiki/Stimulated_emission" title="Stimulated emission">stimulated emission</a>, the physical process that makes possible the <a href="/wiki/Maser" title="Maser">maser</a> and the <a href="/wiki/Laser" title="Laser">laser</a>.<sup id="cite_ref-FOOTNOTEEinstein1917b_249-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1917b-249">&#91;244&#93;</a></sup>
This article showed that the statistics of absorption and emission of light would only be consistent with Planck\'s distribution law if the emission of light into a mode with n photons would be enhanced statistically compared to the emission of light into an empty mode. This paper was enormously influential in the later development of quantum mechanics, because it was the first paper to show that the statistics of atomic transitions had simple laws.
</p>
<h4><span class="mw-headline" id="Matter_waves">Matter waves</span></h4>
<p>Einstein discovered <a href="/wiki/Louis_de_Broglie" title="Louis de Broglie">Louis de Broglie</a>\'s work and supported his ideas, which were received skeptically at first. In another major paper from this era, Einstein gave a wave equation for <a href="/wiki/Matter_wave" title="Matter wave">de Broglie waves</a>, which Einstein suggested was the <a href="/wiki/Hamilton%E2%80%93Jacobi_equation" title="Hamilton–Jacobi equation">Hamilton–Jacobi equation</a> of mechanics. This paper would inspire Schrödinger\'s work of 1926.
</p>
<h3><span class="mw-headline" id="Quantum_mechanics">Quantum mechanics</span></h3>
<h4><span id="Einstein.27s_objections_to_quantum_mechanics"></span><span class="mw-headline" id="Einstein\'s_objections_to_quantum_mechanics">Einstein\'s objections to quantum mechanics</span></h4>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:NYT_May_4,_1935.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/a/a0/NYT_May_4%2C_1935.jpg/170px-NYT_May_4%2C_1935.jpg" decoding="async" width="170" height="203" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/a/a0/NYT_May_4%2C_1935.jpg/255px-NYT_May_4%2C_1935.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/a/a0/NYT_May_4%2C_1935.jpg/340px-NYT_May_4%2C_1935.jpg 2x" data-file-width="569" data-file-height="680" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:NYT_May_4,_1935.jpg" class="internal" title="Enlarge"></a></div>Newspaper headline on 4 May 1935</div></div></div>
<p>Einstein played a major role in developing quantum theory, beginning with his 1905 paper on the photoelectric effect. However, he became displeased with modern quantum mechanics as it had evolved after 1925, despite its acceptance by other physicists. He was skeptical that the randomness of quantum mechanics was fundamental rather than the result of determinism, stating that God "is not playing at dice".<sup id="cite_ref-zZ2hS_250-0" class="reference"><a href="#cite_note-zZ2hS-250">&#91;245&#93;</a></sup> Until the end of his life, he continued to maintain that quantum mechanics was incomplete.<sup id="cite_ref-yzZtL_251-0" class="reference"><a href="#cite_note-yzZtL-251">&#91;246&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Bohr_versus_Einstein">Bohr versus Einstein</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Bohr%E2%80%93Einstein_debates" title="Bohr–Einstein debates">Bohr–Einstein debates</a></div>
<div class="thumb tright"><div class="thumbinner" style="width:172px;"><a href="/wiki/File:Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg" class="image"><img alt="Two men sitting, looking relaxed. A dark-haired Bohr is talking while Einstein looks skeptical." src="//upload.wikimedia.org/wikipedia/commons/thumb/d/d5/Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg/170px-Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg" decoding="async" width="170" height="246" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/d/d5/Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg/255px-Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/d/d5/Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg/340px-Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg 2x" data-file-width="1467" data-file-height="2123" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Niels_Bohr_Albert_Einstein_by_Ehrenfest.jpg" class="internal" title="Enlarge"></a></div>Einstein and <a href="/wiki/Niels_Bohr" title="Niels Bohr">Niels Bohr</a>, 1925</div></div></div><p> The Bohr–Einstein debates were a series of public disputes about <a href="/wiki/Quantum_mechanics" title="Quantum mechanics">quantum mechanics</a> between Einstein and <a href="/wiki/Niels_Bohr" title="Niels Bohr">Niels Bohr</a>, who were two of its founders. Their debates are remembered because of their importance to the <a href="/wiki/Philosophy_of_science" title="Philosophy of science">philosophy of science</a>.<sup id="cite_ref-Bohr1949_252-0" class="reference"><a href="#cite_note-Bohr1949-252">&#91;247&#93;</a></sup><sup id="cite_ref-FOOTNOTEEinstein1969_253-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1969-253">&#91;248&#93;</a></sup><sup id="cite_ref-FOOTNOTEEinsteinPodolskyRosen1935_254-0" class="reference"><a href="#cite_note-FOOTNOTEEinsteinPodolskyRosen1935-254">&#91;249&#93;</a></sup> Their debates would influence later <a href="/wiki/Interpretations_of_quantum_mechanics" title="Interpretations of quantum mechanics">interpretations of quantum mechanics</a>.
</p><h4><span id="Einstein.E2.80.93Podolsky.E2.80.93Rosen_paradox"></span><span class="mw-headline" id="Einstein–Podolsky–Rosen_paradox">Einstein–Podolsky–Rosen paradox</span></h4>
<p>In 1935, Einstein returned to quantum mechanics, in particular to the question of its completeness, in the <a href="/wiki/EPR_paradox" title="EPR paradox">"EPR paper"</a>.<sup id="cite_ref-FOOTNOTEEinsteinPodolskyRosen1935_254-1" class="reference"><a href="#cite_note-FOOTNOTEEinsteinPodolskyRosen1935-254">&#91;249&#93;</a></sup> In a <a href="/wiki/Einstein%27s_thought_experiments" title="Einstein&#39;s thought experiments">thought experiment</a>, he considered two particles which had interacted such that their properties were strongly correlated. No matter how far the two particles were separated, a precise position measurement on one particle would result in equally precise knowledge of the position of the other particle; likewise a precise momentum measurement of one particle would result in equally precise knowledge of the momentum of the other particle, without needing to disturb the other particle in any way.<sup id="cite_ref-FOOTNOTEIsaacson2007pp._448–453_255-0" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007pp._448–453-255">&#91;250&#93;</a></sup>
</p><p>Given Einstein\'s concept of <a href="/wiki/Local_realism" class="mw-redirect" title="Local realism">local realism</a>, there were two possibilities: (1) either the other particle had these properties already determined, or (2) the process of measuring the first particle instantaneously affected the reality of the position and momentum of the second particle. Einstein rejected this second possibility (popularly called "spooky action at a distance").<sup id="cite_ref-FOOTNOTEIsaacson2007pp._448–453_255-1" class="reference"><a href="#cite_note-FOOTNOTEIsaacson2007pp._448–453-255">&#91;250&#93;</a></sup>
</p><p>Einstein\'s belief in local realism led him to assert that, while the correctness of quantum mechanics was not in question, it must be incomplete. But as a physical principle, local realism was shown to be incorrect when the <a href="/wiki/Aspect_experiment" class="mw-redirect" title="Aspect experiment">Aspect experiment</a> of 1982 confirmed <a href="/wiki/Bell%27s_theorem" title="Bell&#39;s theorem">Bell\'s theorem</a>, which <a href="/wiki/J._S._Bell" class="mw-redirect" title="J. S. Bell">J. S. Bell</a> had delineated in 1964. The results of these and subsequent experiments demonstrate that quantum physics cannot be represented by any version of the picture of physics in which "particles are regarded as unconnected independent classical-like entities, each one being unable to communicate with the other after they have separated."<sup id="cite_ref-FOOTNOTEPenrose2007583_256-0" class="reference"><a href="#cite_note-FOOTNOTEPenrose2007583-256">&#91;251&#93;</a></sup>
</p><p>Although Einstein was wrong about local realism, his clear prediction of the unusual properties of its opposite, <a href="/wiki/Quantum_entanglement" title="Quantum entanglement">entangled quantum states</a>, has resulted in the EPR paper becoming among the top ten papers published in <i><a href="/wiki/Physical_Review" title="Physical Review">Physical Review</a></i>. It is considered a centerpiece of the development of <a href="/wiki/Quantum_information_theory" class="mw-redirect" title="Quantum information theory">quantum information theory</a>.<sup id="cite_ref-FOOTNOTEFine2017_257-0" class="reference"><a href="#cite_note-FOOTNOTEFine2017-257">&#91;252&#93;</a></sup>
</p>
<h3><span class="mw-headline" id="Unified_field_theory">Unified field theory</span></h3>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Classical_unified_field_theories" title="Classical unified field theories">Classical unified field theories</a></div>
<p>Following his research on general relativity, Einstein attempted to generalize his theory of gravitation to include electromagnetism as aspects of a single entity. In 1950, he described his "<a href="/wiki/Unified_field_theory" title="Unified field theory">unified field theory</a>" in a <i><a href="/wiki/Scientific_American" title="Scientific American">Scientific American</a></i> article titled "On the Generalized Theory of Gravitation".<sup id="cite_ref-FOOTNOTEEinstein1950_258-0" class="reference"><a href="#cite_note-FOOTNOTEEinstein1950-258">&#91;253&#93;</a></sup> Although he was lauded for this work, his efforts were ultimately unsuccessful.
Notably, Einstein\'s unification project did not accommodate the <a href="/wiki/Strong_nuclear_force" class="mw-redirect" title="Strong nuclear force">strong</a> and <a href="/wiki/Weak_nuclear_force" class="mw-redirect" title="Weak nuclear force">weak nuclear forces</a>, neither of which were well understood until many years after his death. Although mainstream physics long ignored Einstein\'s approaches to unification, Einstein\'s work has motivated modern quests for a <a href="/wiki/Theory_of_everything" title="Theory of everything">theory of everything</a>, in particular <a href="/wiki/String_theory" title="String theory">string theory</a>, where geometrical fields emerge in a unified quantum-mechanical setting.
</p>
<h3><span class="mw-headline" id="Other_investigations">Other investigations</span></h3>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein%27s_unsuccessful_investigations" title="Einstein&#39;s unsuccessful investigations">Einstein\'s unsuccessful investigations</a></div>
<p>Einstein conducted other investigations that were unsuccessful and abandoned. These pertain to <a href="/wiki/Force" title="Force">force</a>, <a href="/wiki/Superconductivity" title="Superconductivity">superconductivity</a>, and other research.
</p>
<h3><span class="mw-headline" id="Collaboration_with_other_scientists">Collaboration with other scientists</span></h3>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Solvay_conference_1927.jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/6e/Solvay_conference_1927.jpg/220px-Solvay_conference_1927.jpg" decoding="async" width="220" height="159" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/6e/Solvay_conference_1927.jpg/330px-Solvay_conference_1927.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/6e/Solvay_conference_1927.jpg/440px-Solvay_conference_1927.jpg 2x" data-file-width="3000" data-file-height="2171" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Solvay_conference_1927.jpg" class="internal" title="Enlarge"></a></div>The 1927 <a href="/wiki/Solvay_Conference" title="Solvay Conference">Solvay Conference</a> in Brussels, a gathering of the world\'s top physicists. Einstein is in the center.</div></div></div>
<p>In addition to longtime collaborators <a href="/wiki/Leopold_Infeld" title="Leopold Infeld">Leopold Infeld</a>, <a href="/wiki/Nathan_Rosen" title="Nathan Rosen">Nathan Rosen</a>, <a href="/wiki/Peter_Bergmann" title="Peter Bergmann">Peter Bergmann</a> and others, Einstein also had some one-shot collaborations with various scientists.
</p>
<h4><span id="Einstein.E2.80.93de_Haas_experiment"></span><span class="mw-headline" id="Einstein–de_Haas_experiment">Einstein–de Haas experiment</span></h4>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein%E2%80%93de_Haas_effect" title="Einstein–de Haas effect">Einstein–de Haas effect</a></div>
<p>Einstein and De Haas demonstrated that magnetization is due to the motion of electrons, nowadays known to be the spin. In order to show this, they reversed the magnetization in an iron bar suspended on a <a href="/wiki/Torsion_pendulum" class="mw-redirect" title="Torsion pendulum">torsion pendulum</a>. They confirmed that this leads the bar to rotate, because the electron\'s angular momentum changes as the magnetization changes. This experiment needed to be sensitive because the angular momentum associated with electrons is small, but it definitively established that electron motion of some kind is responsible for magnetization.
</p>
<h4><span id="Schr.C3.B6dinger_gas_model"></span><span class="mw-headline" id="Schrödinger_gas_model">Schrödinger gas model</span></h4>
<p>Einstein suggested to Erwin Schrödinger that he might be able to reproduce the statistics of a <a href="/wiki/Bose%E2%80%93Einstein_condensate" title="Bose–Einstein condensate">Bose–Einstein gas</a> by considering a box. Then to each possible quantum motion of a particle in a box associate an independent harmonic oscillator. Quantizing these oscillators, each level will have an integer occupation number, which will be the number of particles in it.<sup class="noprint Inline-Template Template-Fact" style="white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Citation_needed" title="Wikipedia:Citation needed"><span title="This claim needs references to reliable sources. (April 2020)">citation needed</span></a></i>&#93;</sup>
</p><p>This formulation is a form of <a href="/wiki/Second_quantization" title="Second quantization">second quantization</a>, but it predates modern quantum mechanics. Erwin Schrödinger applied this to derive the <a href="/wiki/Thermodynamic" class="mw-redirect" title="Thermodynamic">thermodynamic</a> properties of a <a href="/wiki/Quantum_chaos" title="Quantum chaos">semiclassical</a> <a href="/wiki/Ideal_gas" title="Ideal gas">ideal gas</a>. Schrödinger urged Einstein to add his name as co-author, although Einstein declined the invitation.<sup id="cite_ref-4IMf2_259-0" class="reference"><a href="#cite_note-4IMf2-259">&#91;254&#93;</a></sup>
</p>
<h4><span class="mw-headline" id="Einstein_refrigerator">Einstein refrigerator</span></h4>
<p>In 1926, Einstein and his former student Leó Szilárd co-invented (and in 1930, patented) the <a href="/wiki/Einstein_refrigerator" title="Einstein refrigerator">Einstein refrigerator</a>. This <a href="/wiki/Absorption_refrigerator" title="Absorption refrigerator">absorption refrigerator</a> was then revolutionary for having no moving parts and using only heat as an input.<sup id="cite_ref-Goettling_260-0" class="reference"><a href="#cite_note-Goettling-260">&#91;255&#93;</a></sup> On 11 November 1930, <span><a rel="nofollow" class="external text" href="https://patents.google.com/patent/US1781541">U.S. Patent 1,781,541</a></span> was awarded to Einstein and Leó Szilárd for the refrigerator. Their invention was not immediately put into commercial production, and the most promising of their patents were acquired by the Swedish company <a href="/wiki/Electrolux" title="Electrolux">Electrolux</a>.<sup id="cite_ref-262" class="reference"><a href="#cite_note-262">&#91;note 6&#93;</a></sup>
</p>
<h2><span class="mw-headline" id="Non-scientific_legacy">Non-scientific legacy</span></h2>
<div class="thumb tright"><div class="thumbinner" style="width:222px;"><a href="/wiki/File:Einstein-Oslofjord_(cropped).jpg" class="image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/61/Einstein-Oslofjord_%28cropped%29.jpg/220px-Einstein-Oslofjord_%28cropped%29.jpg" decoding="async" width="220" height="169" class="thumbimage" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/61/Einstein-Oslofjord_%28cropped%29.jpg/330px-Einstein-Oslofjord_%28cropped%29.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/61/Einstein-Oslofjord_%28cropped%29.jpg/440px-Einstein-Oslofjord_%28cropped%29.jpg 2x" data-file-width="906" data-file-height="698" /></a>  <div class="thumbcaption"><div class="magnify"><a href="/wiki/File:Einstein-Oslofjord_(cropped).jpg" class="internal" title="Enlarge"></a></div>Einstein (second from left) at a picnic in Oslo during the visit to Denmark and Norway in 1920. <a href="/wiki/Heinrich_Jacob_Goldschmidt" title="Heinrich Jacob Goldschmidt">Heinrich Goldschmidt</a> (left), <a href="/wiki/Ole_Colbj%C3%B8rnsen" title="Ole Colbjørnsen">Ole Colbjørnsen</a> (seated in center) and <a href="/wiki/J%C3%B8rgen_Vogt" title="Jørgen Vogt">Jørgen Vogt</a> behind Ilse Einstein. <br /><small><i>Credit: University of Oslo</i></small></div></div></div>
<p>While traveling, Einstein wrote daily to his wife Elsa and adopted stepdaughters Margot and Ilse. The letters were included in the papers bequeathed to the <a href="/wiki/Hebrew_University_of_Jerusalem" title="Hebrew University of Jerusalem">Hebrew University of Jerusalem</a>. Margot Einstein permitted the personal letters to be made available to the public, but requested that it not be done until twenty years after her death (she died in 1986<sup id="cite_ref-margot-obituary_263-0" class="reference"><a href="#cite_note-margot-obituary-263">&#91;257&#93;</a></sup>). Barbara Wolff, of the Hebrew University\'s <a href="/wiki/Albert_Einstein_Archives" title="Albert Einstein Archives">Albert Einstein Archives</a>, told the <a href="/wiki/BBC" title="BBC">BBC</a> that there are about 3,500 pages of private correspondence written between 1912 and 1955.<sup id="cite_ref-letters-love_264-0" class="reference"><a href="#cite_note-letters-love-264">&#91;258&#93;</a></sup>
</p><p>Einstein\'s <a href="/wiki/Personality_rights" title="Personality rights">right of publicity</a> was litigated in 2015 in a federal district court in California. Although the court initially held that the right had expired,<sup id="cite_ref-casetext-hebrew-university_265-0" class="reference"><a href="#cite_note-casetext-hebrew-university-265">&#91;259&#93;</a></sup> that ruling was immediately appealed, and the decision was later vacated in its entirety. The underlying claims between the parties in that lawsuit were ultimately settled. The right is enforceable, and the Hebrew University of Jerusalem is the exclusive representative of that right.<sup id="cite_ref-pacermonitor-hebrew-university_266-0" class="reference"><a href="#cite_note-pacermonitor-hebrew-university-266">&#91;260&#93;</a></sup> <a href="/wiki/Branded_Entertainment_Network" title="Branded Entertainment Network">Corbis</a>, successor to The Roger Richman Agency, licenses the <a href="/wiki/Trademark" title="Trademark">use of his name and associated imagery</a>, as agent for the university.<sup id="cite_ref-einstein.biz_267-0" class="reference"><a href="#cite_note-einstein.biz-267">&#91;261&#93;</a></sup>
</p>
<h2><span class="mw-headline" id="In_popular_culture">In popular culture</span></h2>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Albert_Einstein_in_popular_culture" title="Albert Einstein in popular culture">Albert Einstein in popular culture</a></div>
<p>Einstein became one of the most famous <a href="/wiki/Scientific_celebrity" title="Scientific celebrity">scientific celebrities</a>,<sup id="cite_ref-268" class="reference"><a href="#cite_note-268">&#91;262&#93;</a></sup><sup id="cite_ref-269" class="reference"><a href="#cite_note-269">&#91;263&#93;</a></sup> beginning with the confirmation of his theory of general relativity in 1919.<sup id="cite_ref-270" class="reference"><a href="#cite_note-270">&#91;264&#93;</a></sup> Despite the general public having little understanding of his work, he was widely recognized and received adulation and publicity. In the period before World War II, <i><a href="/wiki/The_New_Yorker" title="The New Yorker">The New Yorker</a></i> published a vignette in their "The Talk of the Town" feature saying that Einstein was so well known in America that he would be stopped on the street by people wanting him to explain "that theory". He finally figured out a way to handle the incessant inquiries. He told his inquirers "Pardon me, sorry! Always I am mistaken for Professor Einstein."<sup id="cite_ref-disguise_271-0" class="reference"><a href="#cite_note-disguise-271">&#91;265&#93;</a></sup>
</p><p>Einstein has been the subject of or inspiration for many novels, films, plays, and works of music.<sup id="cite_ref-orchestra_272-0" class="reference"><a href="#cite_note-orchestra-272">&#91;266&#93;</a></sup> He is a favorite model for depictions of <a href="/wiki/Absent-minded_professor" title="Absent-minded professor">absent-minded professors</a>; his expressive face and distinctive hairstyle have been widely copied and exaggerated. <i><a href="/wiki/Time_(magazine)" title="Time (magazine)">Time</a></i> magazine\'s Frederic Golden wrote that Einstein was "a cartoonist\'s dream come true".<sup id="cite_ref-slqbwn_273-0" class="reference"><a href="#cite_note-slqbwn-273">&#91;267&#93;</a></sup>
</p><p>Many popular <a href="/wiki/Quotations" class="mw-redirect" title="Quotations">quotations</a> are often <a href="/wiki/False_attribution" title="False attribution">misattributed</a> to him.<sup id="cite_ref-fake-quotes_274-0" class="reference"><a href="#cite_note-fake-quotes-274">&#91;268&#93;</a></sup><sup id="cite_ref-humiliate-atheist_275-0" class="reference"><a href="#cite_note-humiliate-atheist-275">&#91;269&#93;</a></sup>
</p>
<h2><span class="mw-headline" id="Awards_and_honors">Awards and honors</span></h2>
<div role="note" class="hatnote navigation-not-searchable">Main article: <a href="/wiki/Einstein%27s_awards_and_honors" title="Einstein&#39;s awards and honors">Einstein\'s awards and honors</a></div>
<p>Einstein received numerous awards and honors, and in 1922, he was awarded the 1921 <a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Nobel Prize in Physics</a> "for his services to Theoretical Physics, and especially for his discovery of the law of the photoelectric effect". None of the nominations in 1921 met the criteria set by <a href="/wiki/Alfred_Nobel" title="Alfred Nobel">Alfred Nobel</a>, so the 1921 prize was carried forward and awarded to Einstein in 1922.<sup id="cite_ref-Nobel_Prize_11-2" class="reference"><a href="#cite_note-Nobel_Prize-11">&#91;10&#93;</a></sup>
</p>
<h2><span class="mw-headline" id="Publications">Publications</span></h2>
<h3><span class="mw-headline" id="Scientific">Scientific</span></h3>
<dl><dd><div role="note" class="hatnote navigation-not-searchable">Further information: <a href="/wiki/List_of_scientific_publications_by_Albert_Einstein" title="List of scientific publications by Albert Einstein">List of scientific publications by Albert Einstein</a></div></dd></dl>
<style data-mw-deduplicate="TemplateStyles:r998391716">.mw-parser-output .div-col{margin-top:0.3em;column-width:30em}.mw-parser-output .div-col-small{font-size:90%}.mw-parser-output .div-col-rules{column-rule:1px solid #aaa}.mw-parser-output .div-col dl,.mw-parser-output .div-col ol,.mw-parser-output .div-col ul{margin-top:0}.mw-parser-output .div-col li,.mw-parser-output .div-col dd{page-break-inside:avoid;break-inside:avoid-column}</style><div class="div-col" style="column-width: 35em;">
<ul><li><style data-mw-deduplicate="TemplateStyles:r999302996">.mw-parser-output cite.citation{font-style:inherit}.mw-parser-output .citation q{quotes:"\\"""\\"""\'""\'"}.mw-parser-output .id-lock-free a,.mw-parser-output .citation .cs1-lock-free a{background:linear-gradient(transparent,transparent),url("//upload.wikimedia.org/wikipedia/commons/6/65/Lock-green.svg")right 0.1em center/9px no-repeat}.mw-parser-output .id-lock-limited a,.mw-parser-output .id-lock-registration a,.mw-parser-output .citation .cs1-lock-limited a,.mw-parser-output .citation .cs1-lock-registration a{background:linear-gradient(transparent,transparent),url("//upload.wikimedia.org/wikipedia/commons/d/d6/Lock-gray-alt-2.svg")right 0.1em center/9px no-repeat}.mw-parser-output .id-lock-subscription a,.mw-parser-output .citation .cs1-lock-subscription a{background:linear-gradient(transparent,transparent),url("//upload.wikimedia.org/wikipedia/commons/a/aa/Lock-red-alt-2.svg")right 0.1em center/9px no-repeat}.mw-parser-output .cs1-subscription,.mw-parser-output .cs1-registration{color:#555}.mw-parser-output .cs1-subscription span,.mw-parser-output .cs1-registration span{border-bottom:1px dotted;cursor:help}.mw-parser-output .cs1-ws-icon a{background:linear-gradient(transparent,transparent),url("//upload.wikimedia.org/wikipedia/commons/4/4c/Wikisource-logo.svg")right 0.1em center/12px no-repeat}.mw-parser-output code.cs1-code{color:inherit;background:inherit;border:none;padding:inherit}.mw-parser-output .cs1-hidden-error{display:none;font-size:100%}.mw-parser-output .cs1-visible-error{font-size:100%}.mw-parser-output .cs1-maint{display:none;color:#33aa33;margin-left:0.3em}.mw-parser-output .cs1-format{font-size:95%}.mw-parser-output .cs1-kern-left,.mw-parser-output .cs1-kern-wl-left{padding-left:0.2em}.mw-parser-output .cs1-kern-right,.mw-parser-output .cs1-kern-wl-right{padding-right:0.2em}.mw-parser-output .citation .mw-selflink{font-weight:inherit}</style><cite id="CITEREFEinstein1901" class="citation journal cs1">Einstein, Albert (1901) [Manuscript received: 16 December 1900].  Written at Zurich, Switzerland. <a rel="nofollow" class="external text" href="https://zenodo.org/record/1423995">"Folgerungen aus den Capillaritätserscheinungen"</a> &#91;Conclusions Drawn from the Phenomena of Capillarity&#93;. <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i> (in German). Hoboken, New Jersey (published 14 March 2006). <b>309</b> (3): 513–523. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1901AnP...309..513E">1901AnP...309..513E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1002%2Fandp.19013090306">10.1002/andp.19013090306</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annalen+der+Physik&amp;rft.atitle=Folgerungen+aus+den+Capillarit%C3%A4tserscheinungen&amp;rft.volume=309&amp;rft.issue=3&amp;rft.pages=513-523&amp;rft.date=1901&amp;rft_id=info%3Adoi%2F10.1002%2Fandp.19013090306&amp;rft_id=info%3Abibcode%2F1901AnP...309..513E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fzenodo.org%2Frecord%2F1423995&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1905a" class="citation journal cs1">Einstein, Albert (1905a) [Manuscript received: 18 March 1905].  Written at Berne, Switzerland. <a rel="nofollow" class="external text" href="http://www.physik.uni-augsburg.de/annalen/history/einstein-papers/1905_17_132-148.pdf">"Über einen die Erzeugung und Verwandlung des Lichtes betreffenden heuristischen Gesichtspunkt"</a> &#91;On a Heuristic Viewpoint Concerning the Production and Transformation of Light&#93; <span class="cs1-format">(PDF)</span>. <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i> (in German). Hoboken, New Jersey (published 10 March 2006). <b>322</b> (6): 132–148. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1905AnP...322..132E">1905AnP...322..132E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1002%2Fandp.19053220607">10.1002/andp.19053220607</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annalen+der+Physik&amp;rft.atitle=%C3%9Cber+einen+die+Erzeugung+und+Verwandlung+des+Lichtes+betreffenden+heuristischen+Gesichtspunkt&amp;rft.volume=322&amp;rft.issue=6&amp;rft.pages=132-148&amp;rft.date=1905&amp;rft_id=info%3Adoi%2F10.1002%2Fandp.19053220607&amp;rft_id=info%3Abibcode%2F1905AnP...322..132E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fwww.physik.uni-augsburg.de%2Fannalen%2Fhistory%2Feinstein-papers%2F1905_17_132-148.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1905b" class="citation thesis cs1">Einstein, Albert (1905b) [Completed 30 April and submitted 20 July 1905].  Written at Berne, Switzerland, published by Wyss Buchdruckerei. <a rel="nofollow" class="external text" href="http://e-collection.library.ethz.ch/eserv/eth:30378/eth-30378-01.pdf"><i>Eine neue Bestimmung der Moleküldimensionen</i></a> &#91;<i>A new determination of molecular dimensions</i>&#93; <span class="cs1-format">(PDF)</span>. <i>Dissertationen <a href="/wiki/Universit%C3%A4t_Z%C3%BCrich" class="mw-redirect" title="Universität Zürich">Universität Zürich</a></i> (PhD Thesis) (in German). Zurich, Switzerland: <a href="/wiki/ETH" class="mw-redirect" title="ETH">ETH</a> Zürich (published 2008). <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.3929%2Fethz-a-000565688">10.3929/ethz-a-000565688</a> &#8211; via ETH Bibliothek.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Adissertation&amp;rft.title=Eine+neue+Bestimmung+der+Molek%C3%BCldimensionen&amp;rft.inst=ETH+Z%C3%BCrich&amp;rft.date=1905&amp;rft_id=info%3Adoi%2F10.3929%2Fethz-a-000565688&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fe-collection.library.ethz.ch%2Feserv%2Feth%3A30378%2Feth-30378-01.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1905c" class="citation journal cs1">Einstein, Albert (1905c) [Manuscript received: 11 May 1905].  Written at Berne, Switzerland. <a rel="nofollow" class="external text" href="http://sedici.unlp.edu.ar/handle/10915/2785">"Über die von der molekularkinetischen Theorie der Wärme geforderte Bewegung von in ruhenden Flüssigkeiten suspendierten Teilchen"</a> &#91;On the Motion&#160;– Required by the Molecular Kinetic Theory of Heat&#160;– of Small Particles Suspended in a Stationary Liquid&#93;. <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i> (in German). Hoboken, New Jersey (published 10 March 2006). <b>322</b> (8): 549–560. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1905AnP...322..549E">1905AnP...322..549E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1002%2Fandp.19053220806">10.1002/andp.19053220806</a></span>. <a href="/wiki/Hdl_(identifier)" class="mw-redirect" title="Hdl (identifier)">hdl</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//hdl.handle.net/10915%2F2785">10915/2785</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annalen+der+Physik&amp;rft.atitle=%C3%9Cber+die+von+der+molekularkinetischen+Theorie+der+W%C3%A4rme+geforderte+Bewegung+von+in+ruhenden+Fl%C3%BCssigkeiten+suspendierten+Teilchen&amp;rft.volume=322&amp;rft.issue=8&amp;rft.pages=549-560&amp;rft.date=1905&amp;rft_id=info%3Ahdl%2F10915%2F2785&amp;rft_id=info%3Adoi%2F10.1002%2Fandp.19053220806&amp;rft_id=info%3Abibcode%2F1905AnP...322..549E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fsedici.unlp.edu.ar%2Fhandle%2F10915%2F2785&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1905d" class="citation journal cs1">Einstein, Albert (1905d) [Manuscript received: 30 June 1905].  Written at Berne, Switzerland. <a rel="nofollow" class="external text" href="http://sedici.unlp.edu.ar/handle/10915/2786">"Zur Elektrodynamik bewegter Körper"</a> &#91;On the Electrodynamics of Moving Bodies&#93;. <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i> (Submitted manuscript) (in German). Hoboken, New Jersey (published 10 March 2006). <b>322</b> (10): 891–921. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1905AnP...322..891E">1905AnP...322..891E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1002%2Fandp.19053221004">10.1002/andp.19053221004</a>. <a href="/wiki/Hdl_(identifier)" class="mw-redirect" title="Hdl (identifier)">hdl</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//hdl.handle.net/10915%2F2786">10915/2786</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annalen+der+Physik&amp;rft.atitle=Zur+Elektrodynamik+bewegter+K%C3%B6rper&amp;rft.volume=322&amp;rft.issue=10&amp;rft.pages=891-921&amp;rft.date=1905&amp;rft_id=info%3Ahdl%2F10915%2F2786&amp;rft_id=info%3Adoi%2F10.1002%2Fandp.19053221004&amp;rft_id=info%3Abibcode%2F1905AnP...322..891E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fsedici.unlp.edu.ar%2Fhandle%2F10915%2F2786&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1905e" class="citation journal cs1">Einstein, Albert (1905e) [Manuscript received: 27 September 1905].  Written at Berne, Switzerland. <a rel="nofollow" class="external text" href="https://zenodo.org/record/1424057">"Ist die Trägheit eines Körpers von seinem Energieinhalt abhängig?"</a> &#91;Does the Inertia of a Body Depend Upon Its Energy Content?&#93;. <i><a href="/wiki/Annalen_der_Physik" title="Annalen der Physik">Annalen der Physik</a></i> (in German). Hoboken, New Jersey (published 10 March 2006). <b>323</b> (13): 639–641. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1905AnP...323..639E">1905AnP...323..639E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1002%2Fandp.19053231314">10.1002/andp.19053231314</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Annalen+der+Physik&amp;rft.atitle=Ist+die+Tr%C3%A4gheit+eines+K%C3%B6rpers+von+seinem+Energieinhalt+abh%C3%A4ngig%3F&amp;rft.volume=323&amp;rft.issue=13&amp;rft.pages=639-641&amp;rft.date=1905&amp;rft_id=info%3Adoi%2F10.1002%2Fandp.19053231314&amp;rft_id=info%3Abibcode%2F1905AnP...323..639E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fzenodo.org%2Frecord%2F1424057&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1915" class="citation journal cs1">Einstein, Albert (1915) [Published 25 November 1915]. <a rel="nofollow" class="external text" href="http://echo.mpiwg-berlin.mpg.de/MPIWG:ZZB2HK6W">"Die Feldgleichungen der Gravitation"</a> &#91;The Field Equations of Gravitation&#93; <span class="cs1-format">(Online page images)</span>. <i>Sitzungsberichte 1915</i> (in German). Berlin, Germany: <a href="/wiki/Prussian_Academy_of_Sciences" title="Prussian Academy of Sciences">Königlich Preussische Akademie der Wissenschaften</a>: 844–847 &#8211; via ECHO, Cultural Heritage Online, <a href="/wiki/Max_Planck_Institute" class="mw-redirect" title="Max Planck Institute">Max Planck Institute</a> for the History of Science.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sitzungsberichte+1915&amp;rft.atitle=Die+Feldgleichungen+der+Gravitation&amp;rft.pages=844-847&amp;rft.date=1915&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fecho.mpiwg-berlin.mpg.de%2FMPIWG%3AZZB2HK6W&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1916" class="citation journal cs1">Einstein, Albert (22 June 1916). <a rel="nofollow" class="external text" href="https://echo.mpiwg-berlin.mpg.de/ECHOdocuView?url=/permanent/echo/einstein/sitzungsberichte/BGG54UCY/index.meta">"Näherungsweise Integration der Feldgleichungen der Gravitation"</a> &#91;Approximate integration of the field equations of gravitation&#93;. <i><a href="/wiki/Prussian_Academy_of_Sciences" title="Prussian Academy of Sciences">Sitzungsberichte der Königlich Preussischen Akademie der Wissenschaften Berlin</a></i>: 688–696. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1916SPAW.......688E">1916SPAW.......688E</a><span class="reference-accessdate">. Retrieved <span class="nowrap">14 November</span> 2020</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sitzungsberichte+der+K%C3%B6niglich+Preussischen+Akademie+der+Wissenschaften+Berlin&amp;rft.atitle=N%C3%A4herungsweise+Integration+der+Feldgleichungen+der+Gravitation&amp;rft.pages=688-696&amp;rft.date=1916-06-22&amp;rft_id=info%3Abibcode%2F1916SPAW.......688E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fecho.mpiwg-berlin.mpg.de%2FECHOdocuView%3Furl%3D%2Fpermanent%2Fecho%2Feinstein%2Fsitzungsberichte%2FBGG54UCY%2Findex.meta&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1917a" class="citation journal cs1">Einstein, Albert (1917a). <a rel="nofollow" class="external text" href="http://echo.mpiwg-berlin.mpg.de/MPIWG:H428RSAN">"Kosmologische Betrachtungen zur allgemeinen Relativitätstheorie"</a> &#91;Cosmological Considerations in the General Theory of Relativity&#93;. <i>Sitzungsberichte 1917</i> (in German). <a href="/wiki/Prussian_Academy_of_Sciences" title="Prussian Academy of Sciences">Königlich Preussische Akademie der Wissenschaften</a>, Berlin.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sitzungsberichte+1917&amp;rft.atitle=Kosmologische+Betrachtungen+zur+allgemeinen+Relativit%C3%A4tstheorie&amp;rft.date=1917&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fecho.mpiwg-berlin.mpg.de%2FMPIWG%3AH428RSAN&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1917b" class="citation journal cs1">Einstein, Albert (1917b). "Zur Quantentheorie der Strahlung" &#91;On the Quantum Mechanics of Radiation&#93;. <i>Physikalische Zeitschrift</i> (in German). <b>18</b>: 121–128. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1917PhyZ...18..121E">1917PhyZ...18..121E</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physikalische+Zeitschrift&amp;rft.atitle=Zur+Quantentheorie+der+Strahlung&amp;rft.volume=18&amp;rft.pages=121-128&amp;rft.date=1917&amp;rft_id=info%3Abibcode%2F1917PhyZ...18..121E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1918" class="citation journal cs1">Einstein, Albert (31 January 1918). <a rel="nofollow" class="external text" href="https://echo.mpiwg-berlin.mpg.de/ECHOdocuView?url=/permanent/echo/einstein/sitzungsberichte/W7ZU8V1E/index.meta">"Über Gravitationswellen"</a> &#91;About gravitational waves&#93;. <i>Sitzungsberichte der Königlich Preussischen Akademie der Wissenschaften Berlin</i>: 154–167. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1918SPAW.......154E">1918SPAW.......154E</a><span class="reference-accessdate">. Retrieved <span class="nowrap">14 November</span> 2020</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sitzungsberichte+der+K%C3%B6niglich+Preussischen+Akademie+der+Wissenschaften+Berlin&amp;rft.atitle=%C3%9Cber+Gravitationswellen&amp;rft.pages=154-167&amp;rft.date=1918-01-31&amp;rft_id=info%3Abibcode%2F1918SPAW.......154E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fecho.mpiwg-berlin.mpg.de%2FECHOdocuView%3Furl%3D%2Fpermanent%2Fecho%2Feinstein%2Fsitzungsberichte%2FW7ZU8V1E%2Findex.meta&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1923" class="citation speech cs1">Einstein, Albert (1923) [First published 1923, in English 1967].  Written at Gothenburg. <a rel="nofollow" class="external text" href="https://www.nobelprize.org/nobel_prizes/physics/laureates/1921/einstein-lecture.html"><i>Grundgedanken und Probleme der Relativitätstheorie</i></a> &#91;<i>Fundamental Ideas and Problems of the Theory of Relativity</i>&#93; (Speech). Lecture delivered to the Nordic Assembly of Naturalists at Gothenburg, 11 July 1923. <i>Nobel Lectures, Physics 1901–1921</i> (in German and English). Stockholm: Nobelprice.org (published 3 February 2015) &#8211; via Nobel Media AB 2014.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Grundgedanken+und+Probleme+der+Relativit%C3%A4tstheorie&amp;rft.place=Stockholm&amp;rft.pub=Nobelprice.org&amp;rft.date=1923&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fwww.nobelprize.org%2Fnobel_prizes%2Fphysics%2Flaureates%2F1921%2Feinstein-lecture.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1924" class="citation journal cs1">Einstein, Albert (1924) [Published 10 July 1924]. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20161014072015/http://echo.mpiwg-berlin.mpg.de/ECHOdocuView?url=/permanent/echo/einstein/sitzungsberichte/PG8B073X/index.meta">"Quantentheorie des einatomigen idealen Gases"</a> &#91;Quantum theory of monatomic ideal gases&#93;. <i>Sitzungsberichte der Preussischen Akademie der Wissenschaften, Physikalisch-Mathematische Klasse</i> (in German): 261–267. Archived from <a rel="nofollow" class="external text" href="http://echo.mpiwg-berlin.mpg.de/MPIWG:DRQK5WYB">the original</a> <span class="cs1-format">(Online page images)</span> on 14 October 2016 &#8211; via ECHO, Cultural Heritage Online, <a href="/wiki/Max_Planck_Institute" class="mw-redirect" title="Max Planck Institute">Max Planck Institute</a> for the History of Science.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sitzungsberichte+der+Preussischen+Akademie+der+Wissenschaften%2C+Physikalisch-Mathematische+Klasse&amp;rft.atitle=Quantentheorie+des+einatomigen+idealen+Gases&amp;rft.pages=261-267&amp;rft.date=1924&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fecho.mpiwg-berlin.mpg.de%2FMPIWG%3ADRQK5WYB&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> First of a series of papers on this topic.</li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1926" class="citation journal cs1">Einstein, Albert (12 March 1926) [Cover Date 1 March 1926].  Written at Berlin. "Die Ursache der Mäanderbildung der Flußläufe und des sogenannten Baerschen Gesetzes" &#91;On <a href="/wiki/Baer%27s_law" class="mw-redirect" title="Baer&#39;s law">Baer\'s law</a> and <a href="/wiki/Meander" title="Meander">meanders</a> in the courses of rivers&#93;. <i>Die Naturwissenschaften</i> (in German). Heidelberg, Germany. <b>14</b> (11): 223–224. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1926NW.....14..223E">1926NW.....14..223E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1007%2FBF01510300">10.1007/BF01510300</a>. <a href="/wiki/ISSN_(identifier)" class="mw-redirect" title="ISSN (identifier)">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/1432-1904">1432-1904</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:39899416">39899416</a> &#8211; via SpringerLink.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Die+Naturwissenschaften&amp;rft.atitle=Die+Ursache+der+M%C3%A4anderbildung+der+Flu%C3%9Fl%C3%A4ufe+und+des+sogenannten+Baerschen+Gesetzes&amp;rft.volume=14&amp;rft.issue=11&amp;rft.pages=223-224&amp;rft.date=1926-03-12&amp;rft_id=info%3Adoi%2F10.1007%2FBF01510300&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A39899416%23id-name%3DS2CID&amp;rft.issn=1432-1904&amp;rft_id=info%3Abibcode%2F1926NW.....14..223E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1926b" class="citation book cs1">Einstein, Albert (1926b).  Written at Berne, Switzerland.  Fürth, R. (ed.). <a rel="nofollow" class="external text" href="http://www.pitt.edu/~jdnorton/lectures/Rotman_Summer_School_2013/Einstein_1905_docs/Einstein_Dissertation_English.pdf"><i>Investigations on the Theory of the Brownian Movement</i></a> <span class="cs1-format">(PDF)</span>. Translated by Cowper, A. D. US: Dover Publications (published 1956). <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-60796-285-4" title="Special:BookSources/978-1-60796-285-4"><bdi>978-1-60796-285-4</bdi></a><span class="reference-accessdate">. Retrieved <span class="nowrap">4 January</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Investigations+on+the+Theory+of+the+Brownian+Movement&amp;rft.place=US&amp;rft.pub=Dover+Publications&amp;rft.date=1926&amp;rft.isbn=978-1-60796-285-4&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fwww.pitt.edu%2F~jdnorton%2Flectures%2FRotman_Summer_School_2013%2FEinstein_1905_docs%2FEinstein_Dissertation_English.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1931" class="citation journal cs1">Einstein, Albert (1931). "Zum kosmologischen Problem der allgemeinen Relativitätstheorie" &#91;On the cosmological problem of the general theory of relativity&#93;. <i>Sonderasugabe aus den Sitzungsb. König. Preuss. Akad.</i>: 235–237.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Sonderasugabe+aus+den+Sitzungsb.+K%C3%B6nig.+Preuss.+Akad.&amp;rft.atitle=Zum+kosmologischen+Problem+der+allgemeinen+Relativit%C3%A4tstheorie&amp;rft.pages=235-237&amp;rft.date=1931&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinsteinde_Sitter1932" class="citation journal cs1">Einstein, A.; de Sitter, W. (1932). <a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1076193">"On the relation between the expansion and the mean density of the universe"</a>. <i>Proceedings of the National Academy of Sciences</i>. <b>18</b> (3): 213–214. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1932PNAS...18..213E">1932PNAS...18..213E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1073%2Fpnas.18.3.213">10.1073/pnas.18.3.213</a>. <a href="/wiki/PMC_(identifier)" class="mw-redirect" title="PMC (identifier)">PMC</a>&#160;<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1076193">1076193</a></span>. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/16587663">16587663</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Proceedings+of+the+National+Academy+of+Sciences&amp;rft.atitle=On+the+relation+between+the+expansion+and+the+mean+density+of+the+universe&amp;rft.volume=18&amp;rft.issue=3&amp;rft.pages=213-214&amp;rft.date=1932&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1076193%23id-name%3DPMC&amp;rft_id=info%3Apmid%2F16587663&amp;rft_id=info%3Adoi%2F10.1073%2Fpnas.18.3.213&amp;rft_id=info%3Abibcode%2F1932PNAS...18..213E&amp;rft.aulast=Einstein&amp;rft.aufirst=A.&amp;rft.au=de+Sitter%2C+W.&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1076193&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinsteinRosen1935" class="citation journal cs1">Einstein, Albert; Rosen, Nathan (1935). <a rel="nofollow" class="external text" href="https://doi.org/10.1103%2FPhysRev.48.73">"The Particle Problem in the General Theory of Relativity"</a>. <i><a href="/wiki/Physical_Review" title="Physical Review">Physical Review</a></i>. <b>48</b> (1): 73. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1935PhRv...48...73E">1935PhRv...48...73E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1103%2FPhysRev.48.73">10.1103/PhysRev.48.73</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physical+Review&amp;rft.atitle=The+Particle+Problem+in+the+General+Theory+of+Relativity&amp;rft.volume=48&amp;rft.issue=1&amp;rft.pages=73&amp;rft.date=1935&amp;rft_id=info%3Adoi%2F10.1103%2FPhysRev.48.73&amp;rft_id=info%3Abibcode%2F1935PhRv...48...73E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft.au=Rosen%2C+Nathan&amp;rft_id=%2F%2Fdoi.org%2F10.1103%252FPhysRev.48.73&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinsteinPodolskyRosen1935" class="citation journal cs1">Einstein, Albert; Podolsky, Boris; Rosen, Nathan (15 May 1935) [Received 25 March 1935]. <a rel="nofollow" class="external text" href="http://cds.cern.ch/record/405662">"Can Quantum-Mechanical Description of Physical Reality Be Considered Complete?"</a>. <i>Physical Review</i> (Submitted manuscript). <b>47</b> (10): 777–780. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1935PhRv...47..777E">1935PhRv...47..777E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1103%2FPhysRev.47.777">10.1103/PhysRev.47.777</a></span> &#8211; via APS Journals.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physical+Review&amp;rft.atitle=Can+Quantum-Mechanical+Description+of+Physical+Reality+Be+Considered+Complete%3F&amp;rft.volume=47&amp;rft.issue=10&amp;rft.pages=777-780&amp;rft.date=1935-05-15&amp;rft_id=info%3Adoi%2F10.1103%2FPhysRev.47.777&amp;rft_id=info%3Abibcode%2F1935PhRv...47..777E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft.au=Podolsky%2C+Boris&amp;rft.au=Rosen%2C+Nathan&amp;rft_id=http%3A%2F%2Fcds.cern.ch%2Frecord%2F405662&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1950" class="citation journal cs1">Einstein, Albert (1950). "On the Generalized Theory of Gravitation". <i>Scientific American</i>. <b>CLXXXII</b> (4): 13–17. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1950SciAm.182d..13E">1950SciAm.182d..13E</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1038%2Fscientificamerican0450-13">10.1038/scientificamerican0450-13</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Scientific+American&amp;rft.atitle=On+the+Generalized+Theory+of+Gravitation&amp;rft.volume=CLXXXII&amp;rft.issue=4&amp;rft.pages=13-17&amp;rft.date=1950&amp;rft_id=info%3Adoi%2F10.1038%2Fscientificamerican0450-13&amp;rft_id=info%3Abibcode%2F1950SciAm.182d..13E&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1954" class="citation book cs1">Einstein, Albert (1954). <a rel="nofollow" class="external text" href="https://archive.org/details/ideasopinions00eins"><i>Ideas and Opinions</i></a>. New York: Crown Publishers. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-517-00393-0" title="Special:BookSources/978-0-517-00393-0"><bdi>978-0-517-00393-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Ideas+and+Opinions&amp;rft.place=New+York&amp;rft.pub=Crown+Publishers&amp;rft.date=1954&amp;rft.isbn=978-0-517-00393-0&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fideasopinions00eins&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span><br /><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1995" class="citation book cs1">&#8212;&#8212;&#8212;&#8212;&#8212;&#8212; (1995) [1954]. <a rel="nofollow" class="external text" href="https://books.google.com/books?id=9fJkBqwDD3sC"><i>Ideas and Opinions</i></a>. New York: Three Rivers Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-517-88440-9" title="Special:BookSources/978-0-517-88440-9"><bdi>978-0-517-88440-9</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Ideas+and+Opinions&amp;rft.place=New+York&amp;rft.pub=Three+Rivers+Press&amp;rft.date=1995&amp;rft.isbn=978-0-517-88440-9&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D9fJkBqwDD3sC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1969" class="citation book cs1">Einstein, Albert (1969). <i>Albert Einstein, Hedwig und Max Born: Briefwechsel 1916–1955</i> (in German). Commented by Max Born; Preface by Bertrand Russell; Foreword by Werner Heisenberg. Munich: Nymphenburger Verlagshandlung. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-3-88682-005-4" title="Special:BookSources/978-3-88682-005-4"><bdi>978-3-88682-005-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein%2C+Hedwig+und+Max+Born%3A+Briefwechsel+1916%E2%80%931955&amp;rft.place=Munich&amp;rft.pub=Nymphenburger+Verlagshandlung&amp;rft.date=1969&amp;rft.isbn=978-3-88682-005-4&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> A reprint of this book was published by Edition Erbrich in 1982, <link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-3-88682-005-4" title="Special:BookSources/978-3-88682-005-4">978-3-88682-005-4</a>.</li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFStachel_et_al.2008" class="citation book cs1"><a href="/wiki/John_Stachel" title="John Stachel">Stachel, John</a>; Martin J. Klein; A. J. Kox; Michel Janssen; R. Schulmann; Diana Komos Buchwald;  et&#160;al., eds. (21 July 2008) [Published between 1987 and 2006]. <a rel="nofollow" class="external text" href="https://einsteinpapers.press.princeton.edu/"><i>The Collected Papers of Albert Einstein</i></a>. <b>1–10</b>. <a href="/wiki/Princeton_University_Press" title="Princeton University Press">Princeton University Press</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Collected+Papers+of+Albert+Einstein&amp;rft.pub=Princeton+University+Press&amp;rft.date=2008-07-21&amp;rft_id=https%3A%2F%2Feinsteinpapers.press.princeton.edu%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span>. Further information about the volumes published so far can be found on the webpages of the <a rel="nofollow" class="external text" href="http://www.einstein.caltech.edu/index.html">Einstein Papers Project</a> and on the <a href="/wiki/Princeton_University_Press" title="Princeton University Press">Princeton University Press</a> <a rel="nofollow" class="external text" href="http://press.princeton.edu/einstein/">Einstein Page</a></li></ul>
</div>
<h3><span class="mw-headline" id="Others">Others</span></h3>
<link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r998391716"/><div class="div-col" style="column-width: 35em;">
<ul><li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1948" class="citation news cs1">Einstein, Albert;  et&#160;al. (4 December 1948). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20071217113044/http://phys4.harvard.edu/~wilson/NYTimes1948.html">"To the editors of <i>The New York Times</i>"</a>. <i>The New York Times</i>. Melville, New York: AIP, American Inst. of Physics. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-7354-0359-8" title="Special:BookSources/978-0-7354-0359-8"><bdi>978-0-7354-0359-8</bdi></a>. Archived from <a rel="nofollow" class="external text" href="http://phys4.harvard.edu/~wilson/NYTimes1948.html">the original</a> on 17 December 2007<span class="reference-accessdate">. Retrieved <span class="nowrap">25 May</span> 2006</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=To+the+editors+of+The+New+York+Times&amp;rft.date=1948-12-04&amp;rft.isbn=978-0-7354-0359-8&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fphys4.harvard.edu%2F~wilson%2FNYTimes1948.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1949" class="citation journal cs1">Einstein, Albert (May 1949).  Sweezy, Paul; Huberman, Leo (eds.). <a rel="nofollow" class="external text" href="http://monthlyreview.org/2009/05/01/why-socialism/">"Why Socialism?"</a>. <i>Monthly Review</i>. <b>1</b> (1): 9–15. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.14452%2FMR-001-01-1949-05_3">10.14452/MR-001-01-1949-05_3</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Monthly+Review&amp;rft.atitle=Why+Socialism%3F&amp;rft.volume=1&amp;rft.issue=1&amp;rft.pages=9-15&amp;rft.date=1949-05&amp;rft_id=info%3Adoi%2F10.14452%2FMR-001-01-1949-05_3&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fmonthlyreview.org%2F2009%2F05%2F01%2Fwhy-socialism%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span><br /><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein2009" class="citation web cs1">&#8212;&#8212;&#8212;&#8212;&#8212;&#8212; (May 2009) [May 1949]. <a rel="nofollow" class="external text" href="http://www.monthlyreview.org/598einst.htm">"Why Socialism? (Reprise)"</a>. <i>Monthly Review</i>. New York: Monthly Review Foundation. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20060111081948/http://www.monthlyreview.org/598einst.htm">Archived</a> from the original on 11 January 2006<span class="reference-accessdate">. Retrieved <span class="nowrap">16 January</span> 2006</span> &#8211; via MonthlyReview.org.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Monthly+Review&amp;rft.atitle=Why+Socialism%3F+%28Reprise%29&amp;rft.date=2009-05&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fwww.monthlyreview.org%2F598einst.htm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1979" class="citation book cs1">Einstein, Albert (1979). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/autobiographical1979eins"><i>Autobiographical Notes</i></a></span>. Paul Arthur Schilpp (Centennial&#160;ed.). Chicago: Open Court. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-87548-352-8" title="Special:BookSources/978-0-87548-352-8"><bdi>978-0-87548-352-8</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Autobiographical+Notes&amp;rft.place=Chicago&amp;rft.edition=Centennial&amp;rft.pub=Open+Court&amp;rft.date=1979&amp;rft.isbn=978-0-87548-352-8&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fautobiographical1979eins&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span>. The <i>chasing a light beam</i> thought experiment is described on pages 48–51.</li></ul>
</div>
<h2><span class="mw-headline" id="See_also">See also</span></h2>
<link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r998391716"/><div class="div-col" style="column-width: 25em;">
<ul><li><a href="/wiki/Albert_Einstein_House" title="Albert Einstein House">Albert Einstein House</a> in Princeton</li>
<li><a href="/wiki/Einstein%27s_thought_experiments" title="Einstein&#39;s thought experiments">Einstein\'s thought experiments</a></li>
<li><a href="/wiki/Einstein_notation" title="Einstein notation">Einstein notation</a></li>
<li><i><a href="/wiki/The_Einstein_Theory_of_Relativity" title="The Einstein Theory of Relativity">The Einstein Theory of Relativity</a></i>, an educational film</li>
<li><a href="/wiki/Frist_Campus_Center" title="Frist Campus Center">Frist Campus Center</a> at <a href="/wiki/Princeton_University" title="Princeton University">Princeton University</a>&#160;&#8211;&#32; room 302 is associated with Einstein. (The center was once the Palmer Physical Laboratory.)</li>
<li><a href="/wiki/Heinrich_Burkhardt" title="Heinrich Burkhardt">Heinrich Burkhardt</a></li>
<li><a href="/wiki/Bern_Historical_Museum" title="Bern Historical Museum">Bern Historical Museum</a> (Einstein Museum)</li>
<li><a href="/wiki/History_of_gravitational_theory" title="History of gravitational theory">History of gravitational theory</a></li>
<li><a href="/wiki/List_of_coupled_cousins" title="List of coupled cousins">List of coupled cousins</a></li>
<li><a href="/wiki/List_of_German_inventors_and_discoverers" title="List of German inventors and discoverers">List of German inventors and discoverers</a></li>
<li><a href="/wiki/List_of_Jewish_Nobel_laureates" title="List of Jewish Nobel laureates">Jewish Nobel laureates</a></li>
<li><a href="/wiki/List_of_peace_activists" title="List of peace activists">List of peace activists</a></li>
<li><a href="/wiki/Relativity_priority_dispute" title="Relativity priority dispute">Relativity priority dispute</a></li>
<li><a href="/wiki/Sticky_bead_argument" title="Sticky bead argument">Sticky bead argument</a></li></ul>
</div>
<h2><span class="mw-headline" id="References">References</span></h2>
<p><b>Footnotes</b>
</p>
<style data-mw-deduplicate="TemplateStyles:r1011085734">.mw-parser-output .reflist{font-size:90%;margin-bottom:0.5em;list-style-type:decimal}.mw-parser-output .reflist .references{font-size:100%;margin-bottom:0;list-style-type:inherit}.mw-parser-output .reflist-columns-2{column-width:30em}.mw-parser-output .reflist-columns-3{column-width:25em}.mw-parser-output .reflist-columns{margin-top:0.3em}.mw-parser-output .reflist-columns ol{margin-top:0}.mw-parser-output .reflist-columns li{page-break-inside:avoid;break-inside:avoid-column}.mw-parser-output .reflist-upper-alpha{list-style-type:upper-alpha}.mw-parser-output .reflist-upper-roman{list-style-type:upper-roman}.mw-parser-output .reflist-lower-alpha{list-style-type:lower-alpha}.mw-parser-output .reflist-lower-greek{list-style-type:lower-greek}.mw-parser-output .reflist-lower-roman{list-style-type:lower-roman}</style><div class="reflist">
<div class="mw-references-wrap"><ol class="references">
<li id="cite_note-GEcitizen-1"><span class="mw-cite-backlink">^ <a href="#cite_ref-GEcitizen_1-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-GEcitizen_1-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text">In the German Empire, citizens were exclusively subjects of one of the 27 <i>Bundesstaaten</i>.</span>
</li>
<li id="cite_note-6Ar1y-35"><span class="mw-cite-backlink"><b><a href="#cite_ref-6Ar1y_35-0">^</a></b></span> <span class="reference-text">Einstein\'s scores on his <a href="/wiki/Matura" title="Matura">matriculation</a> certificate: German 5; French 3; Italian 5; History 6; Geography 4; Algebra 6; Geometry 6; Descriptive Geometry 6; Physics 6; Chemistry 5; Natural History 5; Art and Technical Drawing 4.<br /><a href="/wiki/Grading_systems_by_country#Switzerland" title="Grading systems by country">The scores</a> are 6 = very good, 5 = good, 4 = sufficient, 3 = insufficient, 2 = poor, 1 = very poor.</span>
</li>
<li id="cite_note-gnriE-127"><span class="mw-cite-backlink"><b><a href="#cite_ref-gnriE_127-0">^</a></b></span> <span class="reference-text">"Their leaders in Germany have not driven out her cut-throats and her blackguards. She has chosen the cream of her culture and has suppressed it. She has even turned upon her most glorious citizen, Albert Einstein, who is the supreme example of the selfless intellectual...The man, who, beyond all others, approximates a citizen of the world, is without a home. How proud we must be to offer him temporary shelter."</span>
</li>
<li id="cite_note-aBfxO-206"><span class="mw-cite-backlink"><b><a href="#cite_ref-aBfxO_206-0">^</a></b></span> <span class="reference-text">In <a href="https://en.wikisource.org/wiki/Translation:On_the_Electrodynamics_of_Moving_Bodies" class="extiw" title="s:Translation:On the Electrodynamics of Moving Bodies">his paper</a>, Einstein wrote: "The introduction of a \'luminiferous æther\' will be proved to be superfluous in so far, as according to the conceptions which will be developed, we shall introduce neither a \'space absolutely at rest\' endowed with special properties, nor shall we associate a velocity-vector with a point in which electro-magnetic processes take place."</span>
</li>
<li id="cite_note-sBl2q-208"><span class="mw-cite-backlink"><b><a href="#cite_ref-sBl2q_208-0">^</a></b></span> <span class="reference-text">For a discussion of the reception of relativity theory around the world, and the different controversies it encountered, see the articles in <a href="#CITEREFGlick1987">Glick (1987)</a>.</span>
</li>
<li id="cite_note-262"><span class="mw-cite-backlink"><b><a href="#cite_ref-262">^</a></b></span> <span class="reference-text">In September 2008 it was reported that Malcolm McCulloch of Oxford University was heading a three-year project to develop more robust appliances that could be used in locales lacking electricity, and that his team had completed a prototype Einstein refrigerator. He was quoted as saying that improving the design and changing the types of gases used might allow the design\'s efficiency to be quadrupled.<sup id="cite_ref-261" class="reference"><a href="#cite_note-261">&#91;256&#93;</a></sup></span>
</li>
</ol></div></div>
<p><b>Citations</b>
</p>
<link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r1011085734"/><div class="reflist">
<div class="mw-references-wrap mw-references-columns"><ol class="references">
<li id="cite_note-66xNO-2"><span class="mw-cite-backlink"><b><a href="#cite_ref-66xNO_2-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHeilbron2003" class="citation book cs1">Heilbron, John L., ed. (2003). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=abqjP-_KfzkC&amp;pg=PA233"><i>The Oxford Companion to the History of Modern Science</i></a>. Oxford University Press. p.&#160;233. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-19-974376-6" title="Special:BookSources/978-0-19-974376-6"><bdi>978-0-19-974376-6</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Oxford+Companion+to+the+History+of+Modern+Science&amp;rft.pages=233&amp;rft.pub=Oxford+University+Press&amp;rft.date=2003&amp;rft.isbn=978-0-19-974376-6&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DabqjP-_KfzkC%26pg%3DPA233&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEPais1982301-3"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982301_3-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, p.&#160;301.</span>
</li>
<li id="cite_note-frs-4"><span class="mw-cite-backlink">^ <a href="#cite_ref-frs_4-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-frs_4-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-frs_4-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-frs_4-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-frs_4-4"><sup><i><b>e</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWhittaker1955" class="citation journal cs1"><a href="/wiki/E._T._Whittaker" title="E. T. Whittaker">Whittaker, E.</a> (1 November 1955). <a rel="nofollow" class="external text" href="https://doi.org/10.1098%2Frsbm.1955.0005">"Albert Einstein. 1879–1955"</a>. <i><a href="/wiki/Biographical_Memoirs_of_Fellows_of_the_Royal_Society" title="Biographical Memoirs of Fellows of the Royal Society">Biographical Memoirs of Fellows of the Royal Society</a></i>. <b>1</b>: 37–67. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1098%2Frsbm.1955.0005">10.1098/rsbm.1955.0005</a></span>. <a href="/wiki/JSTOR_(identifier)" class="mw-redirect" title="JSTOR (identifier)">JSTOR</a>&#160;<a rel="nofollow" class="external text" href="//www.jstor.org/stable/769242">769242</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Biographical+Memoirs+of+Fellows+of+the+Royal+Society&amp;rft.atitle=Albert+Einstein.+1879%E2%80%931955&amp;rft.volume=1&amp;rft.pages=37-67&amp;rft.date=1955-11-01&amp;rft_id=info%3Adoi%2F10.1098%2Frsbm.1955.0005&amp;rft_id=%2F%2Fwww.jstor.org%2Fstable%2F769242%23id-name%3DJSTOR&amp;rft.aulast=Whittaker&amp;rft.aufirst=E.&amp;rft_id=%2F%2Fdoi.org%2F10.1098%252Frsbm.1955.0005&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-NDxay-5"><span class="mw-cite-backlink"><b><a href="#cite_ref-NDxay_5-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWells2008" class="citation book cs1"><a href="/wiki/John_C._Wells" title="John C. Wells">Wells, John</a> (3 April 2008). <i>Longman Pronunciation Dictionary</i> (3rd&#160;ed.). Pearson Longman. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-4058-8118-0" title="Special:BookSources/978-1-4058-8118-0"><bdi>978-1-4058-8118-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Longman+Pronunciation+Dictionary&amp;rft.edition=3rd&amp;rft.pub=Pearson+Longman&amp;rft.date=2008-04-03&amp;rft.isbn=978-1-4058-8118-0&amp;rft.aulast=Wells&amp;rft.aufirst=John&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Bio-6"><span class="mw-cite-backlink">^ <a href="#cite_ref-Bio_6-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Bio_6-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-Bio_6-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-Bio_6-3"><sup><i><b>d</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://nobelprize.org/nobel_prizes/physics/laureates/1921/einstein-bio.html">"Albert Einstein&#160;– Biography"</a>. <a href="/wiki/Nobel_Foundation" title="Nobel Foundation">Nobel Foundation</a>. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20070306133522/http://nobelprize.org/nobel_prizes/physics/laureates/1921/einstein-bio.html">Archived</a> from the original on 6 March 2007<span class="reference-accessdate">. Retrieved <span class="nowrap">7 March</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Albert+Einstein+%E2%80%93+Biography&amp;rft.pub=Nobel+Foundation&amp;rft_id=http%3A%2F%2Fnobelprize.org%2Fnobel_prizes%2Fphysics%2Flaureates%2F1921%2Feinstein-bio.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-YangHamilton2010-7"><span class="mw-cite-backlink"><b><a href="#cite_ref-YangHamilton2010_7-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFYangHamilton2010" class="citation book cs1">Yang, Fujia; Hamilton, Joseph H. (2010). <i>Modern Atomic and Nuclear Physics</i>. World Scientific. p.&#160;274. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-981-4277-16-7" title="Special:BookSources/978-981-4277-16-7"><bdi>978-981-4277-16-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Modern+Atomic+and+Nuclear+Physics&amp;rft.pages=274&amp;rft.pub=World+Scientific&amp;rft.date=2010&amp;rft.isbn=978-981-4277-16-7&amp;rft.aulast=Yang&amp;rft.aufirst=Fujia&amp;rft.au=Hamilton%2C+Joseph+H.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-LnLVo-8"><span class="mw-cite-backlink"><b><a href="#cite_ref-LnLVo_8-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFBodanis2000" class="citation book cs1">Bodanis, David (2000). <i>E&#160;=&#160;mc<sup>2</sup>: A Biography of the World\'s Most Famous Equation</i>. New York: Walker.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=E+%3D+mc%3Csup%3E2%3C%2Fsup%3E%3A+A+Biography+of+the+World%27s+Most+Famous+Equation&amp;rft.place=New+York&amp;rft.pub=Walker&amp;rft.date=2000&amp;rft.aulast=Bodanis&amp;rft.aufirst=David&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-xZQWt-9"><span class="mw-cite-backlink"><b><a href="#cite_ref-xZQWt_9-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHoward2014" class="citation journal cs1">Howard, Don A., ed. (2014) [First published 11 February 2004]. <a rel="nofollow" class="external text" href="http://plato.stanford.edu/entries/einstein-philscience/#IntWasEinEpiOpp">"Einstein\'s Philosophy of Science"</a>. <i>Stanford Encyclopedia of Philosophy</i>. The Metaphysics Research Lab, Center for the Study of Language and Information (CSLI), Stanford University<span class="reference-accessdate">. Retrieved <span class="nowrap">4 February</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Stanford+Encyclopedia+of+Philosophy&amp;rft.atitle=Einstein%27s+Philosophy+of+Science&amp;rft.date=2014&amp;rft_id=http%3A%2F%2Fplato.stanford.edu%2Fentries%2Feinstein-philscience%2F%23IntWasEinEpiOpp&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-3UiiT-10"><span class="mw-cite-backlink"><b><a href="#cite_ref-3UiiT_10-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHoward2005" class="citation journal cs1">Howard, Don A. (December 2005). <a rel="nofollow" class="external text" href="http://www3.nd.edu/~dhoward1/vol58no12p34_40.pdf">"Albert Einstein as a Philosopher of Science"</a> <span class="cs1-format">(PDF)</span>. <i>Physics Today</i>. <b>58</b> (12): 34–40. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2005PhT....58l..34H">2005PhT....58l..34H</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1063%2F1.2169442">10.1063/1.2169442</a><span class="reference-accessdate">. Retrieved <span class="nowrap">8 March</span> 2015</span> &#8211; via University of Notre Dame, Notre Dame, IN, author\'s personal webpage.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physics+Today&amp;rft.atitle=Albert+Einstein+as+a+Philosopher+of+Science&amp;rft.volume=58&amp;rft.issue=12&amp;rft.pages=34-40&amp;rft.date=2005-12&amp;rft_id=info%3Adoi%2F10.1063%2F1.2169442&amp;rft_id=info%3Abibcode%2F2005PhT....58l..34H&amp;rft.aulast=Howard&amp;rft.aufirst=Don+A.&amp;rft_id=http%3A%2F%2Fwww3.nd.edu%2F~dhoward1%2Fvol58no12p34_40.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Nobel_Prize-11"><span class="mw-cite-backlink">^ <a href="#cite_ref-Nobel_Prize_11-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Nobel_Prize_11-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-Nobel_Prize_11-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.nobelprize.org/nobel_prizes/physics/laureates/1921/">"The Nobel Prize in Physics 1921"</a>. Nobel Prize<span class="reference-accessdate">. Retrieved <span class="nowrap">11 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Nobel+Prize+in+Physics+1921&amp;rft.pub=Nobel+Prize&amp;rft_id=https%3A%2F%2Fwww.nobelprize.org%2Fnobel_prizes%2Fphysics%2Flaureates%2F1921%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-wordnetweb.princeton.edu-12"><span class="mw-cite-backlink">^ <a href="#cite_ref-wordnetweb.princeton.edu_12-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-wordnetweb.princeton.edu_12-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://wordnetweb.princeton.edu/perl/webwn?s=Einstein">"Result of WordNet Search for Einstein"</a>. 3.1. The Trustees of Princeton University<span class="reference-accessdate">. Retrieved <span class="nowrap">4 January</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Result+of+WordNet+Search+for+Einstein&amp;rft.series=3.1&amp;rft.pub=The+Trustees+of+Princeton+University&amp;rft_id=http%3A%2F%2Fwordnetweb.princeton.edu%2Fperl%2Fwebwn%3Fs%3DEinstein&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Nobel-13"><span class="mw-cite-backlink">^ <a href="#cite_ref-Nobel_13-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Nobel_13-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20120516052710/https://www.nobelprize.org/nobel_prizes/physics/laureates/2011/advanced-physicsprize2011.pdf">"Scientific Background on the Nobel Prize in Physics 2011. The accelerating universe"</a> <span class="cs1-format">(PDF)</span>. Nobel Media AB. p.&#160;2. Archived from <a rel="nofollow" class="external text" href="https://www.nobelprize.org/nobel_prizes/physics/laureates/2011/advanced-physicsprize2011.pdf">the original</a> <span class="cs1-format">(PDF)</span> on 16 May 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">4 January</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Scientific+Background+on+the+Nobel+Prize+in+Physics+2011.+The+accelerating+universe&amp;rft.pages=2&amp;rft.pub=Nobel+Media+AB&amp;rft_id=https%3A%2F%2Fwww.nobelprize.org%2Fnobel_prizes%2Fphysics%2Flaureates%2F2011%2Fadvanced-physicsprize2011.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-NYT-20151124-14"><span class="mw-cite-backlink"><b><a href="#cite_ref-NYT-20151124_14-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOverbye2015" class="citation news cs1"><a href="/wiki/Dennis_Overbye" title="Dennis Overbye">Overbye, Dennis</a> (24 November 2015). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2015/11/24/science/a-century-ago-einsteins-theory-of-relativity-changed-everything.html">"A Century Ago, Einstein\'s Theory of Relativity Changed Everything"</a>. <i><a href="/wiki/The_New_York_Times" title="The New York Times">The New York Times</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">24 November</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=A+Century+Ago%2C+Einstein%27s+Theory+of+Relativity+Changed+Everything&amp;rft.date=2015-11-24&amp;rft.aulast=Overbye&amp;rft.aufirst=Dennis&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2015%2F11%2F24%2Fscience%2Fa-century-ago-einsteins-theory-of-relativity-changed-everything.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-15"><span class="mw-cite-backlink"><b><a href="#cite_ref-15">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRobinson2018" class="citation journal cs1">Robinson, Andrew (30 April 2018). <a rel="nofollow" class="external text" href="https://www.nature.com/articles/d41586-018-05004-4">"Did Einstein really say that?"</a>. <i><a href="/wiki/Nature_(journal)" title="Nature (journal)">Nature</a></i>. <b>557</b> (30): 30. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1038%2Fd41586-018-05004-4">10.1038/d41586-018-05004-4</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:14013938">14013938</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature&amp;rft.atitle=Did+Einstein+really+say+that%3F&amp;rft.volume=557&amp;rft.issue=30&amp;rft.pages=30&amp;rft.date=2018-04-30&amp;rft_id=info%3Adoi%2F10.1038%2Fd41586-018-05004-4&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A14013938%23id-name%3DS2CID&amp;rft.aulast=Robinson&amp;rft.aufirst=Andrew&amp;rft_id=https%3A%2F%2Fwww.nature.com%2Farticles%2Fd41586-018-05004-4&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-zE9Bz-16"><span class="mw-cite-backlink"><b><a href="#cite_ref-zE9Bz_16-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLevenson2017" class="citation journal cs1">Levenson, Thomas (9 June 2017). <a rel="nofollow" class="external text" href="https://www.theatlantic.com/science/archive/2017/06/einstein-germany-and-the-bomb/528534/">"The Scientist and the Fascist"</a>. <i>The Atlantic</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Atlantic&amp;rft.atitle=The+Scientist+and+the+Fascist&amp;rft.date=2017-06-09&amp;rft.aulast=Levenson&amp;rft.aufirst=Thomas&amp;rft_id=https%3A%2F%2Fwww.theatlantic.com%2Fscience%2Farchive%2F2017%2F06%2Feinstein-germany-and-the-bomb%2F528534%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-BoyerDubofsky2001-17"><span class="mw-cite-backlink"><b><a href="#cite_ref-BoyerDubofsky2001_17-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPaul_S._BoyerMelvyn_Dubofsky2001" class="citation book cs1">Paul S. Boyer; Melvyn Dubofsky (2001). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/oxfordcompaniont00paul_0"><i>The Oxford Companion to United States History</i></a></span>. Oxford University Press. p.&#160;<a rel="nofollow" class="external text" href="https://archive.org/details/oxfordcompaniont00paul_0/page/218">218</a>. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-19-508209-8" title="Special:BookSources/978-0-19-508209-8"><bdi>978-0-19-508209-8</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Oxford+Companion+to+United+States+History&amp;rft.pages=218&amp;rft.pub=Oxford+University+Press&amp;rft.date=2001&amp;rft.isbn=978-0-19-508209-8&amp;rft.au=Paul+S.+Boyer&amp;rft.au=Melvyn+Dubofsky&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Foxfordcompaniont00paul_0&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-18"><span class="mw-cite-backlink"><b><a href="#cite_ref-18">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.jewishvirtuallibrary.org/albert-einstein">"Albert Einstein (1879 - 1955)"</a>. Jewisth Virtual Library.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Albert+Einstein+%281879+-+1955%29&amp;rft.pub=Jewisth+Virtual+Library&amp;rft_id=https%3A%2F%2Fwww.jewishvirtuallibrary.org%2Falbert-einstein&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-19"><span class="mw-cite-backlink"><b><a href="#cite_ref-19">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFIsaacson2009" class="citation journal cs1">Isaacson, Walter (2009). <a rel="nofollow" class="external text" href="https://www.theatlantic.com/magazine/archive/2009/12/how-einstein-divided-americas-jews/307763/">"How Einstein Divided America\'s Jews"</a>. <i>The Atlantic</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Atlantic&amp;rft.atitle=How+Einstein+Divided+America%27s+Jews&amp;rft.date=2009&amp;rft.aulast=Isaacson&amp;rft.aufirst=Walter&amp;rft_id=https%3A%2F%2Fwww.theatlantic.com%2Fmagazine%2Farchive%2F2009%2F12%2Fhow-einstein-divided-americas-jews%2F307763%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA59_59–61&#93;-20"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA59_59–61]_20-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel2002">Stachel (2002)</a>, pp.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=OAsQ_hFjhrAC&amp;pg=PA59">59–61</a>.</span>
</li>
<li id="cite_note-EQyag-21"><span class="mw-cite-backlink"><b><a href="#cite_ref-EQyag_21-0">^</a></b></span> <span class="reference-text">Barry R. Parker (2003). <i>Einstein: The Passions of a Scientist</i>, Prometheus Books, p. 31</span>
</li>
<li id="cite_note-FOOTNOTEFölsing199730–31-22"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing199730–31_22-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;30–31.</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._5-23"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._5_23-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, vol. 1 (1987), doc. 5.</span>
</li>
<li id="cite_note-1RgTv-24"><span class="mw-cite-backlink"><b><a href="#cite_ref-1RgTv_24-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMehra2001" class="citation book cs1">Mehra, Jagdish (2001). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=o1XVCgAAQBAJ&amp;pg=PA1">"Albert Einstein\'s "First Paper<span class="cs1-kern-right">"</span>"</a>. <a rel="nofollow" class="external text" href="https://books.google.com/books?id=o1XVCgAAQBAJ"><i>Golden Age Of Theoretical Physics, The (Boxed Set Of 2 Vols)</i></a>. World Scientific. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-981-4492-85-0" title="Special:BookSources/978-981-4492-85-0"><bdi>978-981-4492-85-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Albert+Einstein%27s+%22First+Paper%22&amp;rft.btitle=Golden+Age+Of+Theoretical+Physics%2C+The+%28Boxed+Set+Of+2+Vols%29&amp;rft.pub=World+Scientific&amp;rft.date=2001&amp;rft.isbn=978-981-4492-85-0&amp;rft.aulast=Mehra&amp;rft.aufirst=Jagdish&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3Do1XVCgAAQBAJ%26pg%3DPA1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-25"><span class="mw-cite-backlink"><b><a href="#cite_ref-25">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFBloom2012" class="citation book cs1">Bloom, Howard (2012). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=xlEupJb4ojIC"><i>The God Problem: How a Godless Cosmos Creates</i></a> (illustrated&#160;ed.). Prometheus Books. p.&#160;294. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-61614-552-1" title="Special:BookSources/978-1-61614-552-1"><bdi>978-1-61614-552-1</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+God+Problem%3A+How+a+Godless+Cosmos+Creates&amp;rft.pages=294&amp;rft.edition=illustrated&amp;rft.pub=Prometheus+Books&amp;rft.date=2012&amp;rft.isbn=978-1-61614-552-1&amp;rft.aulast=Bloom&amp;rft.aufirst=Howard&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DxlEupJb4ojIC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> <a rel="nofollow" class="external text" href="https://books.google.com/books?id=xlEupJb4ojIC&amp;pg=PT294">Extract of page 294</a></span>
</li>
<li id="cite_note-FVfDU-26"><span class="mw-cite-backlink"><b><a href="#cite_ref-FVfDU_26-0">^</a></b></span> <span class="reference-text"><i>The Three-body Problem from Pythagoras to Hawking</i>, Mauri Valtonen, Joanna Anosova, Konstantin Kholshevnikov, Aleksandr Mylläri, Victor Orlov, Kiyotaka Tanikawa, (Springer 2016), p. 43, Simon and Schuster, 2008</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson200717-27"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson200717_27-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson200717_27-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson200717_27-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;17.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson200716-28"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson200716_28-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;16.</span>
</li>
<li id="cite_note-FOOTNOTECalapriceLipscombe20058-29"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalapriceLipscombe20058_29-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalapriceLipscombe2005">Calaprice &amp; Lipscombe (2005)</a>, p.&#160;8.</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_p._11-30"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_p._11_30-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, vol. 1 (1987), p. 11.</span>
</li>
<li id="cite_note-FOOTNOTEFölsing199736–37-31"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing199736–37_31-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;36–37.</span>
</li>
<li id="cite_note-FOOTNOTEHighfieldCarter199321,_31,_56–57-32"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEHighfieldCarter199321,_31,_56–57_32-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEHighfieldCarter199321,_31,_56–57_32-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFHighfieldCarter1993">Highfield &amp; Carter (1993)</a>, pp.&#160;21, 31, 56–57.</span>
</li>
<li id="cite_note-FOOTNOTEFölsing199740-33"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing199740_33-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, p.&#160;40.</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_docs._21–27-34"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_docs._21–27_34-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, vol. 1 (1987), docs. 21–27.</span>
</li>
<li id="cite_note-mileva-36"><span class="mw-cite-backlink">^ <a href="#cite_ref-mileva_36-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-mileva_36-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-mileva_36-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-mileva_36-3"><sup><i><b>d</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGagnon2016" class="citation web cs1">Gagnon, Pauline (19 December 2016). <a rel="nofollow" class="external text" href="https://blogs.scientificamerican.com/guest-blog/the-forgotten-life-of-einsteins-first-wife/">"The Forgotten Life of Einstein\'s First Wife"</a>. <i>Scientific American Blog Network</i><span class="reference-accessdate">. Retrieved <span class="nowrap">17 October</span> 2020</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Scientific+American+Blog+Network&amp;rft.atitle=The+Forgotten+Life+of+Einstein%27s+First+Wife&amp;rft.date=2016-12-19&amp;rft.aulast=Gagnon&amp;rft.aufirst=Pauline&amp;rft_id=https%3A%2F%2Fblogs.scientificamerican.com%2Fguest-blog%2Fthe-forgotten-life-of-einsteins-first-wife%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._67-37"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008vol._1_(1987),_doc._67_37-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, vol. 1 (1987), doc. 67.</span>
</li>
<li id="cite_note-7HA7H-38"><span class="mw-cite-backlink"><b><a href="#cite_ref-7HA7H_38-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFTroemel-Ploetz,_D.1990" class="citation journal cs1">Troemel-Ploetz, D. (1990). "Mileva Einstein-Marić: The Woman Who Did Einstein\'s Mathematics". <i>Women\'s Studies International Forum</i>. <b>13</b> (5): 415–432. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1016%2F0277-5395%2890%2990094-e">10.1016/0277-5395(90)90094-e</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Women%27s+Studies+International+Forum&amp;rft.atitle=Mileva+Einstein-Mari%C4%87%3A+The+Woman+Who+Did+Einstein%27s+Mathematics&amp;rft.volume=13&amp;rft.issue=5&amp;rft.pages=415-432&amp;rft.date=1990&amp;rft_id=info%3Adoi%2F10.1016%2F0277-5395%2890%2990094-e&amp;rft.au=Troemel-Ploetz%2C+D.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-1zJdH-39"><span class="mw-cite-backlink"><b><a href="#cite_ref-1zJdH_39-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWalker,_Evan_Harris1989" class="citation journal cs1">Walker, Evan Harris (February 1989). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20120119093653/http://philosci40.unibe.ch/lehre/winter99/einstein/Walker_Stachel.pdf">"Did Einstein Espouse his Spouse\'s Ideas?"</a> <span class="cs1-format">(PDF)</span>. <i>Physics Today</i>. <b>42</b> (2): 9–13. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1989PhT....42b...9W">1989PhT....42b...9W</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1063%2F1.2810898">10.1063/1.2810898</a>. Archived from <a rel="nofollow" class="external text" href="http://philosci40.unibe.ch/lehre/winter99/einstein/Walker_Stachel.pdf">the original</a> <span class="cs1-format">(PDF)</span> on 19 January 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">19 October</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physics+Today&amp;rft.atitle=Did+Einstein+Espouse+his+Spouse%27s+Ideas%3F&amp;rft.volume=42&amp;rft.issue=2&amp;rft.pages=9-13&amp;rft.date=1989-02&amp;rft_id=info%3Adoi%2F10.1063%2F1.2810898&amp;rft_id=info%3Abibcode%2F1989PhT....42b...9W&amp;rft.au=Walker%2C+Evan+Harris&amp;rft_id=http%3A%2F%2Fphilosci40.unibe.ch%2Flehre%2Fwinter99%2Feinstein%2FWalker_Stachel.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEPais19941–29-40"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais19941–29_40-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1994">Pais (1994)</a>, pp.&#160;1–29.</span>
</li>
<li id="cite_note-xKrMG-41"><span class="mw-cite-backlink"><b><a href="#cite_ref-xKrMG_41-0">^</a></b></span> <span class="reference-text">Holton, G., <i>Einstein, History, and Other Passions</i>, Harvard University Press, 1996, pp. 177–193.</span>
</li>
<li id="cite_note-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA49_49–56&#93;-42"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA49_49–56]_42-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel2002">Stachel (2002)</a>, pp.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=OAsQ_hFjhrAC&amp;pg=PA49">49–56</a>.</span>
</li>
<li id="cite_note-dUxMl-43"><span class="mw-cite-backlink"><b><a href="#cite_ref-dUxMl_43-0">^</a></b></span> <span class="reference-text">Martinez, A. A., "Handling evidence in history: the case of Einstein\'s wife", <i>School Science Review</i>, 86 (316), March 2005, pp. 49–56. <a rel="nofollow" class="external text" href="https://webspace.utexas.edu/aam829/1/m/Maric_files/EvidenceMaric.pdf">PDF</a> <a rel="nofollow" class="external text" href="https://web.archive.org/web/20110811141225/https://webspace.utexas.edu/aam829/1/m/Maric_files/EvidenceMaric.pdf">Archived</a> 11 August 2011 at the <a href="/wiki/Wayback_Machine" title="Wayback Machine">Wayback Machine</a></span>
</li>
<li id="cite_note-HBMes-44"><span class="mw-cite-backlink"><b><a href="#cite_ref-HBMes_44-0">^</a></b></span> <span class="reference-text">J. Renn &amp; R. Schulmann, <i>Albert Einstein/Mileva Marić: The Love Letters</i>, 1992, pp.&#160;73–74, 78.</span>
</li>
<li id="cite_note-FOOTNOTECalapriceLipscombe200522–23-45"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalapriceLipscombe200522–23_45-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalapriceLipscombe2005">Calaprice &amp; Lipscombe (2005)</a>, pp.&#160;22–23.</span>
</li>
<li id="cite_note-FOOTNOTEStachel1966-46"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel1966_46-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel1966">Stachel (1966)</a>.</span>
</li>
<li id="cite_note-FOOTNOTECalapriceLipscombe2005&#91;httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50&#93;-47"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50]_47-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPA50_50]_47-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFCalapriceLipscombe2005">Calaprice &amp; Lipscombe (2005)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=5eWh2O_3OAQC&amp;pg=PA50">50</a>.</span>
</li>
<li id="cite_note-48"><span class="mw-cite-backlink"><b><a href="#cite_ref-48">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFSmith1996" class="citation web cs1">Smith, Dinitia (6 November 1996). <a rel="nofollow" class="external text" href="https://www.nytimes.com/1996/11/06/arts/dark-side-of-einstein-emerges-in-his-letters.html">"Dark Side of Einstein Emerges in His Letters"</a> &#8211; via NYTimes.com.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Dark+Side+of+Einstein+Emerges+in+His+Letters&amp;rft.date=1996-11-06&amp;rft.aulast=Smith&amp;rft.aufirst=Dinitia&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F1996%2F11%2F06%2Farts%2Fdark-side-of-einstein-emerges-in-his-letters.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEStachel2002&#91;httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA50_50&#93;-49"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel2002[httpsbooksgooglecombooksidOAsQ_hFjhrACpgPA50_50]_49-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel2002">Stachel (2002)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=OAsQ_hFjhrAC&amp;pg=PA50">50</a>.</span>
</li>
<li id="cite_note-50"><span class="mw-cite-backlink"><b><a href="#cite_ref-50">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20160306044226/http://www.shapell.org/manuscript/einstein-divorce-from-mileva-maric-hebrew-university">"Einstein Works Out Details of His 1919 Divorce from Mileva Marić"</a>. <i>Shapell Manuscript Collection</i>. Shapell Manuscript Foundation. Archived from <a rel="nofollow" class="external text" href="http://www.shapell.org/manuscript/einstein-divorce-from-mileva-maric-hebrew-university">the original</a> on 6 March 2016<span class="reference-accessdate">. Retrieved <span class="nowrap">18 January</span> 2021</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Shapell+Manuscript+Collection&amp;rft.atitle=Einstein+Works+Out+Details+of+His+1919+Divorce+from+Mileva+Mari%C4%87&amp;rft_id=http%3A%2F%2Fwww.shapell.org%2Fmanuscript%2Feinstein-divorce-from-mileva-maric-hebrew-university&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Robinson2015a-51"><span class="mw-cite-backlink"><b><a href="#cite_ref-Robinson2015a_51-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRobinson2015" class="citation book cs1"><a href="/wiki/Walter_Isaacson" title="Walter Isaacson">Robinson, Andrew</a> (2015). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=Px4_CQAAQBAJ&amp;pg=PA144"><i>Einstein: A Hundred Years of Relativity</i></a>. Princeton University Press. pp.&#160;143–145. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-16989-7" title="Special:BookSources/978-0-691-16989-7"><bdi>978-0-691-16989-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+A+Hundred+Years+of+Relativity&amp;rft.pages=143-145&amp;rft.pub=Princeton+University+Press&amp;rft.date=2015&amp;rft.isbn=978-0-691-16989-7&amp;rft.aulast=Robinson&amp;rft.aufirst=Andrew&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DPx4_CQAAQBAJ%26pg%3DPA144&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTENeffe2007&#91;httpsarchiveorgdetailseinsteinbiograph00neffpage203_203&#93;-52"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTENeffe2007[httpsarchiveorgdetailseinsteinbiograph00neffpage203_203]_52-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFNeffe2007">Neffe (2007)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://archive.org/details/einsteinbiograph00neff/page/203">203</a>.</span>
</li>
<li id="cite_note-MlQLY-53"><span class="mw-cite-backlink"><b><a href="#cite_ref-MlQLY_53-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWüthrich2015" class="citation news cs1">Wüthrich, Urs (11 April 2015). <a rel="nofollow" class="external text" href="http://www.bernerzeitung.ch/region/bern/Die-Liebesbriefe-des-untreuen-Einstein/story/11875058">"Die Liebesbriefe des untreuen Einstein"</a> &#91;The love letters of the unfaithful Einstein&#93;. <i>BZ Berner Zeitung</i> (in German). Bern, Switzerland<span class="reference-accessdate">. Retrieved <span class="nowrap">11 April</span> 2015</span>. <q>Ich denke in innigster Liebe an Dich in jeder freien Minute und bin so unglücklich, wie nur ein Mensch es sein kann.</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=BZ+Berner+Zeitung&amp;rft.atitle=Die+Liebesbriefe+des+untreuen+Einstein&amp;rft.date=2015-04-11&amp;rft.aulast=W%C3%BCthrich&amp;rft.aufirst=Urs&amp;rft_id=http%3A%2F%2Fwww.bernerzeitung.ch%2Fregion%2Fbern%2FDie-Liebesbriefe-des-untreuen-Einstein%2Fstory%2F11875058&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007&#91;&#91;Category:Wikipedia_articles_needing_page_number_citations_from_November_2020&#93;&#93;&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;&#91;&#91;Wikipedia:Citing_sources&#124;&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;&#93;&#93;&lt;/i&gt;&amp;#93;&lt;/sup&gt;-54"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007[[Category:Wikipedia_articles_needing_page_number_citations_from_November_2020]]&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;[[Wikipedia:Citing_sources|&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;]]&lt;/i&gt;&amp;#93;&lt;/sup&gt;_54-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;<sup class="noprint Inline-Template" style="white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Citing_sources" title="Wikipedia:Citing sources"><span title="This citation requires a reference to the specific page or range of pages in which the material appears. (November 2020)">page&#160;needed</span></a></i>&#93;</sup>.</span>
</li>
<li id="cite_note-FOOTNOTECalapriceKennefickSchulmann201562-55"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalapriceKennefickSchulmann201562_55-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalapriceKennefickSchulmann2015">Calaprice, Kennefick &amp; Schulmann (2015)</a>, p.&#160;62.</span>
</li>
<li id="cite_note-FOOTNOTEHighfieldCarter1993216-56"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEHighfieldCarter1993216_56-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFHighfieldCarter1993">Highfield &amp; Carter (1993)</a>, p.&#160;216.</span>
</li>
<li id="cite_note-57"><span class="mw-cite-backlink"><b><a href="#cite_ref-57">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHighfield2006" class="citation web cs1">Highfield, Roger (10 July 2006). <a rel="nofollow" class="external text" href="https://www.telegraph.co.uk/news/worldnews/northamerica/usa/1523626/Einsteins-theory-of-fidelity.html">"Einstein\'s theory of fidelity"</a> &#8211; via www.telegraph.co.uk.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Einstein%27s+theory+of+fidelity&amp;rft.date=2006-07-10&amp;rft.aulast=Highfield&amp;rft.aufirst=Roger&amp;rft_id=https%3A%2F%2Fwww.telegraph.co.uk%2Fnews%2Fworldnews%2Fnorthamerica%2Fusa%2F1523626%2FEinsteins-theory-of-fidelity.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-58"><span class="mw-cite-backlink"><b><a href="#cite_ref-58">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOverbye2017" class="citation web cs1">Overbye, Dennis (17 April 2017). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2017/04/17/science/albert-einstein-genius-national-geographic-channel.html">"<span class="cs1-kern-left">\'</span>Genius\' Unravels the Mysteries of Einstein\'s Universe"</a> &#8211; via NYTimes.com.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=%27Genius%27+Unravels+the+Mysteries+of+Einstein%27s+Universe&amp;rft.date=2017-04-17&amp;rft.aulast=Overbye&amp;rft.aufirst=Dennis&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2017%2F04%2F17%2Fscience%2Falbert-einstein-genius-national-geographic-channel.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-59"><span class="mw-cite-backlink"><b><a href="#cite_ref-59">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNatGeo_TV" class="citation web cs1">NatGeo TV. <a rel="nofollow" class="external text" href="https://www.natgeotv.com/za/special/genius-albert-einsteins-theory-of-infidelity">"GENIUS ALBERT EINSTEIN\'S THEORY OF INFIDELITY"</a>. <i>www.natgeotv.com</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.natgeotv.com&amp;rft.atitle=GENIUS+ALBERT+EINSTEIN%27S+THEORY+OF+INFIDELITY&amp;rft.au=NatGeo+TV&amp;rft_id=https%3A%2F%2Fwww.natgeotv.com%2Fza%2Fspecial%2Fgenius-albert-einsteins-theory-of-infidelity&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-60"><span class="mw-cite-backlink"><b><a href="#cite_ref-60">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.jpost.com/health-and-science/getting-up-close-and-personal-with-einstein">"Getting up close and personal with Einstein"</a>. <i>The Jerusalem Post &#124; JPost.com</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Jerusalem+Post+%26%23124%3B+JPost.com&amp;rft.atitle=Getting+up+close+and+personal+with+Einstein&amp;rft_id=https%3A%2F%2Fwww.jpost.com%2Fhealth-and-science%2Fgetting-up-close-and-personal-with-einstein&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-61"><span class="mw-cite-backlink"><b><a href="#cite_ref-61">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.hindustantimes.com/india/einstein-secret-love-affairs-out/story-QVSHrfMYJzCRcIlbBCJKAM.html">"Einstein secret love affairs out!"</a>. <i>Hindustan Times</i>. 13 July 2006.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Hindustan+Times&amp;rft.atitle=Einstein+secret+love+affairs+out%21&amp;rft.date=2006-07-13&amp;rft_id=https%3A%2F%2Fwww.hindustantimes.com%2Findia%2Feinstein-secret-love-affairs-out%2Fstory-QVSHrfMYJzCRcIlbBCJKAM.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-62"><span class="mw-cite-backlink"><b><a href="#cite_ref-62">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.nbcnews.com/id/13804030/ns/technology_and_science-science/t/new-letters-shed-light-einsteins-love-life/">"New letters shed light on Einstein\'s love life"</a>. <i>msnbc.com</i>. 11 July 2006.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=msnbc.com&amp;rft.atitle=New+letters+shed+light+on+Einstein%27s+love+life&amp;rft.date=2006-07-11&amp;rft_id=http%3A%2F%2Fwww.nbcnews.com%2Fid%2F13804030%2Fns%2Ftechnology_and_science-science%2Ft%2Fnew-letters-shed-light-einsteins-love-life%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-63"><span class="mw-cite-backlink"><b><a href="#cite_ref-63">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://economictimes.indiatimes.com/magazines/panache/albert-einstein-may-have-had-the-iq-but-he-needed-to-work-on-his-eq/articleshow/64849211.cms?from=mdr">"Albert Einstein may have had the IQ, but he needed to work on his EQ"</a> &#8211; via The Economic Times.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Albert+Einstein+may+have+had+the+IQ%2C+but+he+needed+to+work+on+his+EQ&amp;rft_id=https%3A%2F%2Feconomictimes.indiatimes.com%2Fmagazines%2Fpanache%2Falbert-einstein-may-have-had-the-iq-but-he-needed-to-work-on-his-eq%2Farticleshow%2F64849211.cms%3Ffrom%3Dmdr&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-64"><span class="mw-cite-backlink"><b><a href="#cite_ref-64">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPruitt" class="citation web cs1">Pruitt, Sarah. <a rel="nofollow" class="external text" href="https://www.history.com/news/einstein-had-no-clue-his-lover-was-a-suspected-russian-spy">"Einstein Had No Clue His Lover Was a Suspected Russian Spy"</a>. <i>HISTORY</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=HISTORY&amp;rft.atitle=Einstein+Had+No+Clue+His+Lover+Was+a+Suspected+Russian+Spy&amp;rft.aulast=Pruitt&amp;rft.aufirst=Sarah&amp;rft_id=https%3A%2F%2Fwww.history.com%2Fnews%2Feinstein-had-no-clue-his-lover-was-a-suspected-russian-spy&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-65"><span class="mw-cite-backlink"><b><a href="#cite_ref-65">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPogrebin1998" class="citation web cs1">Pogrebin, Robin (1 June 1998). <a rel="nofollow" class="external text" href="https://www.nytimes.com/1998/06/01/us/love-letters-by-einstein-at-auction.html">"Love Letters By Einstein At Auction"</a> &#8211; via NYTimes.com.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Love+Letters+By+Einstein+At+Auction&amp;rft.date=1998-06-01&amp;rft.aulast=Pogrebin&amp;rft.aufirst=Robin&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F1998%2F06%2F01%2Fus%2Flove-letters-by-einstein-at-auction.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-66"><span class="mw-cite-backlink"><b><a href="#cite_ref-66">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.independent.co.uk/news/einsteins-letters-show-affair-with-spy-1162418.html">"Einstein\'s letters show affair with spy"</a>. <i>The Independent</i>. 2 June 1998.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Independent&amp;rft.atitle=Einstein%27s+letters+show+affair+with+spy&amp;rft.date=1998-06-02&amp;rft_id=https%3A%2F%2Fwww.independent.co.uk%2Fnews%2Feinsteins-letters-show-affair-with-spy-1162418.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEFölsing199782-67"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing199782_67-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, p.&#160;82.</span>
</li>
<li id="cite_note-ODY5p-68"><span class="mw-cite-backlink"><b><a href="#cite_ref-ODY5p_68-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFJ._J._O&#39;ConnorE._F._Robertson2010" class="citation web cs1">J. J. O\'Connor; E. F. Robertson (May 2010). <a rel="nofollow" class="external text" href="http://www-history.mcs.st-and.ac.uk/Biographies/Grossmann.html">"Grossmann biography"</a>. <i>MacTutor</i>. School of Mathematics and Statistics, University of St Andrews, Scotland<span class="reference-accessdate">. Retrieved <span class="nowrap">27 March</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=MacTutor&amp;rft.atitle=Grossmann+biography&amp;rft.date=2010-05&amp;rft.au=J.+J.+O%27Connor&amp;rft.au=E.+F.+Robertson&amp;rft_id=http%3A%2F%2Fwww-history.mcs.st-and.ac.uk%2FBiographies%2FGrossmann.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson200763-69"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson200763_69-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;63.</span>
</li>
<li id="cite_note-MeZPN-70"><span class="mw-cite-backlink"><b><a href="#cite_ref-MeZPN_70-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.ipi.ch/en/about-us/einstein/einstein-at-the-patent-office.html">"Einstein at the patent office"</a> (official website). Berne, Switzerland: Swiss Federal Institute of Intellectual Property, IGE/IPI. 6 February 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">9 September</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Einstein+at+the+patent+office&amp;rft.place=Berne%2C+Switzerland&amp;rft.pub=Swiss+Federal+Institute+of+Intellectual+Property%2C+IGE%2FIPI&amp;rft.date=2014-02-06&amp;rft_id=https%3A%2F%2Fwww.ipi.ch%2Fen%2Fabout-us%2Feinstein%2Feinstein-at-the-patent-office.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-IGEFAQ-71"><span class="mw-cite-backlink">^ <a href="#cite_ref-IGEFAQ_71-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-IGEFAQ_71-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.ipi.ch/en/about-us/einstein/frequently-asked-questions.html">"FAQ about Einstein and the Institute"</a> (official website). Berne, Switzerland: Swiss Federal Institute of Intellectual Property, IGE/IPI. 27 May 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">27 March</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=FAQ+about+Einstein+and+the+Institute&amp;rft.place=Berne%2C+Switzerland&amp;rft.pub=Swiss+Federal+Institute+of+Intellectual+Property%2C+IGE%2FIPI&amp;rft.date=2014-05-27&amp;rft_id=https%3A%2F%2Fwww.ipi.ch%2Fen%2Fabout-us%2Feinstein%2Ffrequently-asked-questions.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEGalison2000370-72"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEGalison2000370_72-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFGalison2000">Galison (2000)</a>, p.&#160;370.</span>
</li>
<li id="cite_note-FOOTNOTEGalison2000377-73"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEGalison2000377_73-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFGalison2000">Galison (2000)</a>, p.&#160;377.</span>
</li>
<li id="cite_note-FOOTNOTEHighfieldCarter199396–98-74"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEHighfieldCarter199396–98_74-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFHighfieldCarter1993">Highfield &amp; Carter (1993)</a>, pp.&#160;96–98.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson200779–84-75"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson200779–84_75-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp.&#160;79–84.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1901-76"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinstein1901_76-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1901_76-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinstein1901">Einstein (1901)</a>.</span>
</li>
<li id="cite_note-SdDhS-77"><span class="mw-cite-backlink"><b><a href="#cite_ref-SdDhS_77-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGalison2003" class="citation book cs1"><a href="/wiki/Peter_Galison" title="Peter Galison">Galison, Peter</a> (2003). <a rel="nofollow" class="external text" href="https://archive.org/details/einsteinsclocksp00gali"><i>Einstein\'s Clocks, Poincaré\'s Maps: Empires of Time</i></a>. New York: W. W. Norton. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-393-02001-4" title="Special:BookSources/978-0-393-02001-4"><bdi>978-0-393-02001-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%27s+Clocks%2C+Poincar%C3%A9%27s+Maps%3A+Empires+of+Time&amp;rft.place=New+York&amp;rft.pub=W.+W.+Norton&amp;rft.date=2003&amp;rft.isbn=978-0-393-02001-4&amp;rft.aulast=Galison&amp;rft.aufirst=Peter&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinsclocksp00gali&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span><sup class="noprint Inline-Template" style="white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Citing_sources" title="Wikipedia:Citing sources"><span title="This citation requires a reference to the specific page or range of pages in which the material appears. (November 2020)">page&#160;needed</span></a></i>&#93;</sup></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;-78"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;_78-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1905b&quot;Meinem_Freunde_Herr_Dr._Marcel_Grossmann_gewidmet_(Dedicated_to_my_friend,_Dr._Marcel_Grossmann)&quot;_78-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinstein1905b">Einstein (1905b)</a>, "Meinem Freunde Herr Dr. Marcel Grossmann gewidmet (Dedicated to my friend, Dr. Marcel Grossmann)".</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1926bchap._&quot;A_New_Determination_of_Molecular_Dimensions&quot;-79"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1926bchap._&quot;A_New_Determination_of_Molecular_Dimensions&quot;_79-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1926b">Einstein (1926b)</a>, chap. "A New Determination of Molecular Dimensions".</span>
</li>
<li id="cite_note-bG2yp-80"><span class="mw-cite-backlink"><b><a href="#cite_ref-bG2yp_80-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.library.ethz.ch/en/Resources/Digital-library/Einstein-Online/Associate-Professor-at-the-Universiy-of-Zurich-und-professor-in-Prague-1909-1912">"Associate Professor at the University of Zurich und professor in Prague (1909–1912)"</a> (digital library). Einstein Online (in German and English). Bern, Switzerland: ETH-Bibliothek Zurich, ETH Zürich, www.ethz.ch. 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">17 August</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Associate+Professor+at+the+University+of+Zurich+und+professor+in+Prague+%281909%E2%80%931912%29&amp;rft.place=Bern%2C+Switzerland&amp;rft.series=Einstein+Online&amp;rft.pub=ETH-Bibliothek+Zurich%2C+ETH+Z%C3%BCrich%2C+www.ethz.ch&amp;rft.date=2014&amp;rft_id=http%3A%2F%2Fwww.library.ethz.ch%2Fen%2FResources%2FDigital-library%2FEinstein-Online%2FAssociate-Professor-at-the-Universiy-of-Zurich-und-professor-in-Prague-1909-1912&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007164-81"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007164_81-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;164.</span>
</li>
<li id="cite_note-Itl8r-82"><span class="mw-cite-backlink"><b><a href="#cite_ref-Itl8r_82-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFvon_Hirschhausen,_Ulrike2007" class="citation web cs1">von Hirschhausen, Ulrike (2007). <a rel="nofollow" class="external text" href="http://econstor.eu/bitstream/10419/49610/1/569197996.pdf">"Von imperialer Inklusion zur nationalen Exklusion:Staatsbürgerschaft in Österreich- Ungarn 1867–1923"</a> <span class="cs1-format">(PDF)</span> (WZB Discussion Paper). ZKD&#160;&#8211;&#32; Veröffentlichungsreihe der Forschungsgruppe, "Zivilgesellschaft, Citizenship und politische Mobilisierung in Europa" Schwerpunkt Zivilgesellschaft, Konflikte und Demokratie, Wissenschaftszentrum Berlin für Sozialforschung. Berlin, Germany: WZB Social Science Research Center Berlin. p.&#160;8. <a href="/wiki/ISSN_(identifier)" class="mw-redirect" title="ISSN (identifier)">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/1860-4315">1860-4315</a><span class="reference-accessdate">. Retrieved <span class="nowrap">4 August</span> 2015</span>. <q>Eine weitere Diskontinuität bestand viertens darin, dass die Bestimmungen der österreichischen Staatsbürgerschaft, die in den ersten Dritteln des Jahrhunderts auch auf Ungarn angewandt worden waren, seit 1867 nur noch für die cisleithanische Reichshälfte galten. Ungarn entwickelte hingegen jetzt eine eige-ne Staatsbürgerschaft.</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Von+imperialer+Inklusion+zur+nationalen+Exklusion%3AStaatsb%C3%BCrgerschaft+in+%C3%96sterreich-+Ungarn+1867%E2%80%931923&amp;rft.place=Berlin%2C+Germany&amp;rft.series=ZKD+%26ndash%3B%26%2332%3B+Ver%C3%B6ffentlichungsreihe+der+Forschungsgruppe%2C+%22Zivilgesellschaft%2C+Citizenship+und+politische+Mobilisierung+in+Europa%22+Schwerpunkt+Zivilgesellschaft%2C+Konflikte+und+Demokratie%2C+Wissenschaftszentrum+Berlin+f%C3%BCr+Sozialforschung&amp;rft.pages=8&amp;rft.pub=WZB+Social+Science+Research+Center+Berlin&amp;rft.date=2007&amp;rft.issn=1860-4315&amp;rft.au=von+Hirschhausen%2C+Ulrike&amp;rft_id=http%3A%2F%2Feconstor.eu%2Fbitstream%2F10419%2F49610%2F1%2F569197996.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-hXQin-83"><span class="mw-cite-backlink"><b><a href="#cite_ref-hXQin_83-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.library.ethz.ch/en/Resources/Digital-library/Einstein-Online/Professor-at-the-ETH-Zurich-1912-1914">"Professor at the ETH Zurich (1912–1914)"</a> (digital library). Einstein Online (in German and English). Zurich, Switzerland: ETH-Bibliothek Zurich, ETH Zürich, www.ethz.ch. 2014<span class="reference-accessdate">. Retrieved <span class="nowrap">17 August</span> 2014</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Professor+at+the+ETH+Zurich+%281912%E2%80%931914%29&amp;rft.place=Zurich%2C+Switzerland&amp;rft.series=Einstein+Online&amp;rft.pub=ETH-Bibliothek+Zurich%2C+ETH+Z%C3%BCrich%2C+www.ethz.ch&amp;rft.date=2014&amp;rft_id=http%3A%2F%2Fwww.library.ethz.ch%2Fen%2FResources%2FDigital-library%2FEinstein-Online%2FProfessor-at-the-ETH-Zurich-1912-1914&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEScheideler2002333-84"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEScheideler2002333_84-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFScheideler2002">Scheideler 2002</a>, p.&#160;333.</span>
</li>
<li id="cite_note-NYTimes_19191125-85"><span class="mw-cite-backlink"><b><a href="#cite_ref-NYTimes_19191125_85-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="https://newspaperarchive.com/new-york-times-nov-25-1919-p-17/">"A New Physics, Based on Einstein"</a>. <i>The New York Times</i>. 25 November 1919. p.&#160;17.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=A+New+Physics%2C+Based+on+Einstein&amp;rft.pages=17&amp;rft.date=1919-11-25&amp;rft_id=https%3A%2F%2Fnewspaperarchive.com%2Fnew-york-times-nov-25-1919-p-17%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEStachel2002534-86"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel2002534_86-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel2002">Stachel (2002)</a>, p.&#160;534.</span>
</li>
<li id="cite_note-FOOTNOTEWeinstein201518–19-87"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEWeinstein201518–19_87-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFWeinstein2015">Weinstein (2015)</a>, pp.&#160;18–19.</span>
</li>
<li id="cite_note-EXcH6-88"><span class="mw-cite-backlink"><b><a href="#cite_ref-EXcH6_88-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.mpg.de/dossier/einstein/in-berlin">"Director in the attic"</a>. Max-Planck-Gesellschaft, München<span class="reference-accessdate">. Retrieved <span class="nowrap">9 July</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Director+in+the+attic&amp;rft.pub=Max-Planck-Gesellschaft%2C+M%C3%BCnchen&amp;rft_id=https%3A%2F%2Fwww.mpg.de%2Fdossier%2Feinstein%2Fin-berlin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTECalapriceLipscombe2005&#91;httpsbooksgooglecombooksid5eWh2O_3OAQCpgPR19_&quot;Timeline&quot;,_p._xix&#93;-89"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalapriceLipscombe2005[httpsbooksgooglecombooksid5eWh2O_3OAQCpgPR19_&quot;Timeline&quot;,_p._xix]_89-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalapriceLipscombe2005">Calaprice &amp; Lipscombe (2005)</a>, <a rel="nofollow" class="external text" href="https://books.google.com/books?id=5eWh2O_3OAQC&amp;pg=PR19">"Timeline", p. xix</a>.</span>
</li>
<li id="cite_note-Eddington-90"><span class="mw-cite-backlink"><b><a href="#cite_ref-Eddington_90-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAndrzej2003" class="citation journal cs1">Andrzej, Stasiak (2003). <a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1315907">"Myths in science"</a>. <i>EMBO Reports</i>. <b>4</b> (3): 236. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1038%2Fsj.embor.embor779">10.1038/sj.embor.embor779</a></span>. <a href="/wiki/PMC_(identifier)" class="mw-redirect" title="PMC (identifier)">PMC</a>&#160;<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//www.ncbi.nlm.nih.gov/pmc/articles/PMC1315907">1315907</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=EMBO+Reports&amp;rft.atitle=Myths+in+science&amp;rft.volume=4&amp;rft.issue=3&amp;rft.pages=236&amp;rft.date=2003&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1315907%23id-name%3DPMC&amp;rft_id=info%3Adoi%2F10.1038%2Fsj.embor.embor779&amp;rft.aulast=Andrzej&amp;rft.aufirst=Stasiak&amp;rft_id=%2F%2Fwww.ncbi.nlm.nih.gov%2Fpmc%2Farticles%2FPMC1315907&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-3gcYy-91"><span class="mw-cite-backlink"><b><a href="#cite_ref-3gcYy_91-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.dwc.knaw.nl/biografie/pmknaw/?pagetype=authorDetail&amp;aId=PE00000116">"Albert Einstein (1879–1955)"</a>. Royal Netherlands Academy of Arts and Sciences<span class="reference-accessdate">. Retrieved <span class="nowrap">21 July</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Albert+Einstein+%281879%E2%80%931955%29&amp;rft.pub=Royal+Netherlands+Academy+of+Arts+and+Sciences&amp;rft_id=http%3A%2F%2Fwww.dwc.knaw.nl%2Fbiografie%2Fpmknaw%2F%3Fpagetype%3DauthorDetail%26aId%3DPE00000116&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-92"><span class="mw-cite-backlink"><b><a href="#cite_ref-92">^</a></b></span> <span class="reference-text">Falk, Dan, <i><a rel="nofollow" class="external text" href="https://www.smithsonianmag.com/history/one-hundred-years-ago-einstein-was-given-heros-welcome-americas-jews-180977386/">One Hundred Years Ago, Einstein Was Given a Hero’s Welcome by America’s Jews</a></i>, Smithsonian, April 2, 2021</span>
</li>
<li id="cite_note-FOOTNOTEHoffmann1972145–148-93"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEHoffmann1972145–148_93-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFHoffmann1972">Hoffmann (1972)</a>, pp.&#160;145–148.</span>
</li>
<li id="cite_note-FOOTNOTEFölsing1997499–508-94"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing1997499–508_94-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;499–508.</span>
</li>
<li id="cite_note-7gwHd-95"><span class="mw-cite-backlink"><b><a href="#cite_ref-7gwHd_95-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://www.einsteinsworld.com/News-New-York-Herald-Tribune-1931-As-Einstein-Sees-America.htm">"As Einstein Sees American"</a>, <i>Einstein\'s World</i>, a 1931 reprint with minor changes, of his 1921 essay.</span>
</li>
<li id="cite_note-FOOTNOTEHolton198420-96"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEHolton198420_96-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFHolton1984">Holton (1984)</a>, p.&#160;20.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007307–308-97"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007307–308_97-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp.&#160;307–308.</span>
</li>
<li id="cite_note-38YkY-98"><span class="mw-cite-backlink"><b><a href="#cite_ref-38YkY_98-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFlood2018" class="citation news cs1">Flood, Alison (12 June 2018). <a rel="nofollow" class="external text" href="https://www.theguardian.com/books/2018/jun/12/einsteins-travel-diaries-reveal-shocking-xenophobia">"Einstein\'s travel diaries reveal \'shocking\' xenophobia"</a>. <i><a href="/wiki/The_Guardian" title="The Guardian">The Guardian</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">13 June</span> 2018</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Guardian&amp;rft.atitle=Einstein%27s+travel+diaries+reveal+%27shocking%27+xenophobia&amp;rft.date=2018-06-12&amp;rft.aulast=Flood&amp;rft.aufirst=Alison&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Fbooks%2F2018%2Fjun%2F12%2Feinsteins-travel-diaries-reveal-shocking-xenophobia&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-99"><span class="mw-cite-backlink"><b><a href="#cite_ref-99">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFKatz" class="citation web cs1">Katz, Brigit. <a rel="nofollow" class="external text" href="https://www.smithsonianmag.com/smart-news/einsteins-travel-diaries-reveal-his-deeply-troubling-views-race-180969387/">"Einstein\'s Travel Diaries Reveal His Deeply Troubling Views on Race"</a>. <i>Smithsonian Magazine</i><span class="reference-accessdate">. Retrieved <span class="nowrap">3 January</span> 2021</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Smithsonian+Magazine&amp;rft.atitle=Einstein%27s+Travel+Diaries+Reveal+His+Deeply+Troubling+Views+on+Race&amp;rft.aulast=Katz&amp;rft.aufirst=Brigit&amp;rft_id=https%3A%2F%2Fwww.smithsonianmag.com%2Fsmart-news%2Feinsteins-travel-diaries-reveal-his-deeply-troubling-views-race-180969387%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-oxak7-100"><span class="mw-cite-backlink"><b><a href="#cite_ref-oxak7_100-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://www.nobelprize.org/nobel_prizes/physics/laureates/1921/einstein-speech.html">The Nobel Prize in Physics 1921: Albert Einstein. Banquet Speech by R. Nadolny (in German).</a> Retrieved 9 December 2015 via Nobelprize.org</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007308-101"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007308_101-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;308.</span>
</li>
<li id="cite_note-w74nv-102"><span class="mw-cite-backlink"><b><a href="#cite_ref-w74nv_102-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMontes-Santiago2017" class="citation journal cs1">Montes-Santiago, J. (16 July 2017). "[The meeting of Einstein with Cajal (Madrid, 1923): a lost tide of fortune]". <i>Revista de Neurología</i>. <b>43</b> (2): 113–117. <a href="/wiki/ISSN_(identifier)" class="mw-redirect" title="ISSN (identifier)">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/0210-0010">0210-0010</a>. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/16838259">16838259</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Revista+de+Neurolog%C3%ADa&amp;rft.atitle=%5BThe+meeting+of+Einstein+with+Cajal+%28Madrid%2C+1923%29%3A+a+lost+tide+of+fortune%5D&amp;rft.volume=43&amp;rft.issue=2&amp;rft.pages=113-117&amp;rft.date=2017-07-16&amp;rft_id=info%3Apmid%2F16838259&amp;rft.issn=0210-0010&amp;rft.aulast=Montes-Santiago&amp;rft.aufirst=J.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Q5hgx-103"><span class="mw-cite-backlink"><b><a href="#cite_ref-Q5hgx_103-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGrandjean2018" class="citation book cs1">Grandjean, Martin (2018). <a rel="nofollow" class="external text" href="https://tel.archives-ouvertes.fr/tel-01853903/document"><i>Les réseaux de la coopération intellectuelle. La Société des Nations comme actrice des échanges scientifiques et culturels dans l\'entre-deux-guerres</i></a> &#91;<i>The Networks of Intellectual Cooperation. The League of Nations as an Actor of the Scientific and Cultural Exchanges in the Inter-War Period</i>&#93; (in French). Lausanne: Université de Lausanne.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Les+r%C3%A9seaux+de+la+coop%C3%A9ration+intellectuelle.+La+Soci%C3%A9t%C3%A9+des+Nations+comme+actrice+des+%C3%A9changes+scientifiques+et+culturels+dans+l%27entre-deux-guerres&amp;rft.place=Lausanne&amp;rft.pub=Universit%C3%A9+de+Lausanne&amp;rft.date=2018&amp;rft.aulast=Grandjean&amp;rft.aufirst=Martin&amp;rft_id=https%3A%2F%2Ftel.archives-ouvertes.fr%2Ftel-01853903%2Fdocument&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> pp. 296–302</span>
</li>
<li id="cite_note-vNNnX-104"><span class="mw-cite-backlink"><b><a href="#cite_ref-vNNnX_104-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGrandjean2017" class="citation journal cs1">Grandjean, Martin (2017). "Analisi e visualizzazioni delle reti in storia. L\'esempio della cooperazione intellettuale della Società delle Nazioni". <i>Memoria e Ricerca</i> (2): 371–393. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.14647%2F87204">10.14647/87204</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Memoria+e+Ricerca&amp;rft.atitle=Analisi+e+visualizzazioni+delle+reti+in+storia.+L%27esempio+della+cooperazione+intellettuale+della+Societ%C3%A0+delle+Nazioni&amp;rft.issue=2&amp;rft.pages=371-393&amp;rft.date=2017&amp;rft_id=info%3Adoi%2F10.14647%2F87204&amp;rft.aulast=Grandjean&amp;rft.aufirst=Martin&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> See also: <a rel="nofollow" class="external text" href="https://halshs.archives-ouvertes.fr/halshs-01610098v2">French version</a> (PDF) and <a rel="nofollow" class="external text" href="http://www.martingrandjean.ch/complex-structures-and-international-organizations/">English summary</a>.</span>
</li>
<li id="cite_note-e9Xyh-105"><span class="mw-cite-backlink"><b><a href="#cite_ref-e9Xyh_105-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFShine2018" class="citation journal cs1">Shine, Cormac (2018). "Papal Diplomacy by Proxy? Catholic Internationalism at the League of Nations\' International Committee on Intellectual Cooperation". <i><a href="/wiki/The_Journal_of_Ecclesiastical_History" title="The Journal of Ecclesiastical History">The Journal of Ecclesiastical History</a></i>. <b>69</b> (4): 785–805. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1017%2FS0022046917002731">10.1017/S0022046917002731</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Journal+of+Ecclesiastical+History&amp;rft.atitle=Papal+Diplomacy+by+Proxy%3F+Catholic+Internationalism+at+the+League+of+Nations%27+International+Committee+on+Intellectual+Cooperation&amp;rft.volume=69&amp;rft.issue=4&amp;rft.pages=785-805&amp;rft.date=2018&amp;rft_id=info%3Adoi%2F10.1017%2FS0022046917002731&amp;rft.aulast=Shine&amp;rft.aufirst=Cormac&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007368-106"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007368_106-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;368.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007370-107"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson2007370_107-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007370_107-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007370_107-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;370.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007373-108"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007373_108-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;373.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007374-109"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson2007374_109-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007374_109-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;374.</span>
</li>
<li id="cite_note-FOOTNOTEChaplin1964320-110"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEChaplin1964320_110-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFChaplin1964">Chaplin (1964)</a>, p.&#160;320.</span>
</li>
<li id="cite_note-FOOTNOTEChaplin1964322-111"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEChaplin1964322_111-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFChaplin1964">Chaplin (1964)</a>, p.&#160;322.</span>
</li>
<li id="cite_note-FOOTNOTEFölsing1997659-112"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing1997659_112-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, p.&#160;659.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007404-113"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007404_113-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;404.</span>
</li>
<li id="cite_note-114"><span class="mw-cite-backlink"><b><a href="#cite_ref-114">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://newspapers.ushmm.org/events/albert-einstein-quits-germany-renounces-citizenship">"Albert Einstein Quits Germany, Renounces Citizenship"</a>. <i>History Unfolded: US Newspapers and the Holocaust</i><span class="reference-accessdate">. Retrieved <span class="nowrap">14 March</span> 2021</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=History+Unfolded%3A+US+Newspapers+and+the+Holocaust&amp;rft.atitle=Albert+Einstein+Quits+Germany%2C+Renounces+Citizenship&amp;rft_id=https%3A%2F%2Fnewspapers.ushmm.org%2Fevents%2Falbert-einstein-quits-germany-renounces-citizenship&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007407–410-115"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson2007407–410_115-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007407–410_115-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007407–410_115-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007407–410_115-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007407–410_115-4"><sup><i><b>e</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp.&#160;407–410.</span>
</li>
<li id="cite_note-el4GB-116"><span class="mw-cite-backlink"><b><a href="#cite_ref-el4GB_116-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRichard_Kroehling1991" class="citation web cs1">Richard Kroehling (July 1991). <a rel="nofollow" class="external text" href="http://www.pbs.org/wnet/americanmasters/albert-einstein-how-i-see-the-world/585/">"Albert Einstein: How I See the World"</a>. <i>American Masters</i>. PBS<span class="reference-accessdate">. Retrieved <span class="nowrap">29 May</span> 2018</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=American+Masters&amp;rft.atitle=Albert+Einstein%3A+How+I+See+the+World&amp;rft.date=1991-07&amp;rft.au=Richard+Kroehling&amp;rft_id=http%3A%2F%2Fwww.pbs.org%2Fwnet%2Famericanmasters%2Falbert-einstein-how-i-see-the-world%2F585%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEHolton1984-117"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEHolton1984_117-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFHolton1984">Holton (1984)</a>.</span>
</li>
<li id="cite_note-Jerome-118"><span class="mw-cite-backlink">^ <a href="#cite_ref-Jerome_118-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Jerome_118-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFred_JeromeRodger_Taylor2006" class="citation book cs1">Fred Jerome; Rodger Taylor (2006). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=4d79VQdOfFUC&amp;pg=PR10"><i>Einstein on Race and Racism</i></a>. Rutgers University Press. p.&#160;10. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-8135-3952-2" title="Special:BookSources/978-0-8135-3952-2"><bdi>978-0-8135-3952-2</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+on+Race+and+Racism&amp;rft.pages=10&amp;rft.pub=Rutgers+University+Press&amp;rft.date=2006&amp;rft.isbn=978-0-8135-3952-2&amp;rft.au=Fred+Jerome&amp;rft.au=Rodger+Taylor&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D4d79VQdOfFUC%26pg%3DPR10&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1954197-119"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1954197_119-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1954">Einstein (1954)</a>, p.&#160;197.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007422-120"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007422_120-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;422.</span>
</li>
<li id="cite_note-3zIp7-121"><span class="mw-cite-backlink"><b><a href="#cite_ref-3zIp7_121-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://collection.sciencemuseum.org.uk/objects/co8223551/professor-einstein-with-commander-locker-lampson-gelatin-silver-print-photograph">"Professor Einstein with Commander Locker-Lampson"</a>, ScienceMuseum.org, UK</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007419–420-122"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007419–420_122-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp.&#160;419–420.</span>
</li>
<li id="cite_note-Gilbert-123"><span class="mw-cite-backlink">^ <a href="#cite_ref-Gilbert_123-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Gilbert_123-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text">Gilbert, Martin. <i>Churchill and the Jews</i>, Henry Holt and Company, N.Y. (2007) pp. 101, 176</span>
</li>
<li id="cite_note-aDu8s-124"><span class="mw-cite-backlink"><b><a href="#cite_ref-aDu8s_124-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFReisman2006" class="citation web cs1">Reisman, Arnold (20 November 2006). <a rel="nofollow" class="external text" href="http://hnn.us/article/31946">"What a Freshly Discovered Einstein Letter Says About Turkey Today"</a>. History News Network, George Mason University.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=What+a+Freshly+Discovered+Einstein+Letter+Says+About+Turkey+Today&amp;rft.pub=History+News+Network%2C+George+Mason+University&amp;rft.date=2006-11-20&amp;rft.aulast=Reisman&amp;rft.aufirst=Arnold&amp;rft_id=http%3A%2F%2Fhnn.us%2Farticle%2F31946&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEClark1971-125"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEClark1971_125-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEClark1971_125-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-FOOTNOTEClark1971_125-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-FOOTNOTEClark1971_125-3"><sup><i><b>d</b></i></sup></a> <a href="#cite_ref-FOOTNOTEClark1971_125-4"><sup><i><b>e</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFClark1971">Clark (1971)</a>.</span>
</li>
<li id="cite_note-AP-126"><span class="mw-cite-backlink"><b><a href="#cite_ref-AP_126-0">^</a></b></span> <span class="reference-text">"Denunciation of German Policy is a Stirring Event", <i>Associated Press</i>, 27 July 1933</span>
</li>
<li id="cite_note-Guardian-128"><span class="mw-cite-backlink"><b><a href="#cite_ref-Guardian_128-0">^</a></b></span> <span class="reference-text">"Stateless Jews: The Exiles from Germany, Nationality Plan", <i>The Guardian</i> (UK) 27 July 1933</span>
</li>
<li id="cite_note-FOOTNOTEFölsing1997649,_678-129"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing1997649,_678_129-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;649, 678.</span>
</li>
<li id="cite_note-Arntzenius2011-130"><span class="mw-cite-backlink">^ <a href="#cite_ref-Arntzenius2011_130-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Arntzenius2011_130-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFArntzenius2011" class="citation book cs1">Arntzenius, Linda G. (2011). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=zHHguITir80C&amp;pg=PA19"><i>Institute for Advanced Study</i></a>. Arcadia Publishing. p.&#160;19. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-7385-7409-7" title="Special:BookSources/978-0-7385-7409-7"><bdi>978-0-7385-7409-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Institute+for+Advanced+Study&amp;rft.pages=19&amp;rft.pub=Arcadia+Publishing&amp;rft.date=2011&amp;rft.isbn=978-0-7385-7409-7&amp;rft.aulast=Arntzenius&amp;rft.aufirst=Linda+G.&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DzHHguITir80C%26pg%3DPA19&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FFt5E-131"><span class="mw-cite-backlink"><b><a href="#cite_ref-FFt5E_131-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.oxfordchabad.org/templates/articlecco_cdo/aid/457396/jewish/Albert-Einstein.htm">"Oxford Jewish Personalities"</a>. Oxford Chabad Society<span class="reference-accessdate">. Retrieved <span class="nowrap">7 March</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Oxford+Jewish+Personalities&amp;rft.pub=Oxford+Chabad+Society&amp;rft_id=http%3A%2F%2Fwww.oxfordchabad.org%2Ftemplates%2Farticlecco_cdo%2Faid%2F457396%2Fjewish%2FAlbert-Einstein.htm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-v8v06-132"><span class="mw-cite-backlink"><b><a href="#cite_ref-v8v06_132-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="http://www.oxfordtimes.co.uk/leisure/history_heritage/9617968.How_Einstein_fled_from_the_Nazis_to_an_Oxford_college/">"How Einstein fled from the Nazis to an Oxford college"</a>. <i>The Oxford Times</i>. 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">7 March</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Oxford+Times&amp;rft.atitle=How+Einstein+fled+from+the+Nazis+to+an+Oxford+college&amp;rft.date=2012&amp;rft_id=http%3A%2F%2Fwww.oxfordtimes.co.uk%2Fleisure%2Fhistory_heritage%2F9617968.How_Einstein_fled_from_the_Nazis_to_an_Oxford_college%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEFölsing1997686–687-133"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing1997686–687_133-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;686–687.</span>
</li>
<li id="cite_note-mzNc5-134"><span class="mw-cite-backlink"><b><a href="#cite_ref-mzNc5_134-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.ias.edu/people/einstein/in-brief">"In Brief"</a>. Institute for Advanced Study. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20100329064405/http://www.ias.edu/people/einstein/in-brief">Archived</a> from the original on 29 March 2010<span class="reference-accessdate">. Retrieved <span class="nowrap">4 March</span> 2010</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=In+Brief&amp;rft.pub=Institute+for+Advanced+Study&amp;rft_id=http%3A%2F%2Fwww.ias.edu%2Fpeople%2Feinstein%2Fin-brief&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007630-135"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007630_135-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;630.</span>
</li>
<li id="cite_note-o4fkQ-136"><span class="mw-cite-backlink"><b><a href="#cite_ref-o4fkQ_136-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGosling2010" class="citation web cs1">Gosling, F. G. (2010). <a rel="nofollow" class="external text" href="http://energy.gov/management/downloads/gosling-manhattan-project-making-atomic-bomb">"The Manhattan Project: Making the Atomic Bomb"</a>. U.S. Department of Energy, History Division. p.&#160;vii<span class="reference-accessdate">. Retrieved <span class="nowrap">7 June</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=The+Manhattan+Project%3A+Making+the+Atomic+Bomb&amp;rft.pages=vii&amp;rft.pub=U.S.+Department+of+Energy%2C+History+Division&amp;rft.date=2010&amp;rft.aulast=Gosling&amp;rft.aufirst=F.+G.&amp;rft_id=http%3A%2F%2Fenergy.gov%2Fmanagement%2Fdownloads%2Fgosling-manhattan-project-making-atomic-bomb&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-pRqWK-137"><span class="mw-cite-backlink"><b><a href="#cite_ref-pRqWK_137-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLanouetteSilard1992" class="citation book cs1">Lanouette, William; Silard, Bela (1992). <a rel="nofollow" class="external text" href="https://archive.org/details/geniusinshadowsa00lano/page/198"><i>Genius in the Shadows: A Biography of Leo Szilárd: The Man Behind The Bomb</i></a>. New York: Charles Scribner\'s Sons. pp.&#160;<a rel="nofollow" class="external text" href="https://archive.org/details/geniusinshadowsa00lano/page/198">198–200</a>. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-684-19011-2" title="Special:BookSources/978-0-684-19011-2"><bdi>978-0-684-19011-2</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Genius+in+the+Shadows%3A+A+Biography+of+Leo+Szil%C3%A1rd%3A+The+Man+Behind+The+Bomb&amp;rft.place=New+York&amp;rft.pages=198-200&amp;rft.pub=Charles+Scribner%27s+Sons&amp;rft.date=1992&amp;rft.isbn=978-0-684-19011-2&amp;rft.aulast=Lanouette&amp;rft.aufirst=William&amp;rft.au=Silard%2C+Bela&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fgeniusinshadowsa00lano%2Fpage%2F198&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-4Z68g-138"><span class="mw-cite-backlink"><b><a href="#cite_ref-4Z68g_138-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFDiehlMoltz2008" class="citation book cs1">Diehl, Sarah J.; Moltz, James Clay (2008). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=3PN-NEfl_U0C&amp;pg=PA218"><i>Nuclear Weapons and Nonproliferation: A Reference Handbook</i></a>. ABC-CLIO. p.&#160;218. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-59884-071-1" title="Special:BookSources/978-1-59884-071-1"><bdi>978-1-59884-071-1</bdi></a><span class="reference-accessdate">. Retrieved <span class="nowrap">7 June</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Nuclear+Weapons+and+Nonproliferation%3A+A+Reference+Handbook&amp;rft.pages=218&amp;rft.pub=ABC-CLIO&amp;rft.date=2008&amp;rft.isbn=978-1-59884-071-1&amp;rft.aulast=Diehl&amp;rft.aufirst=Sarah+J.&amp;rft.au=Moltz%2C+James+Clay&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D3PN-NEfl_U0C%26pg%3DPA218&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-eZym8-139"><span class="mw-cite-backlink"><b><a href="#cite_ref-eZym8_139-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHewlettAnderson1962" class="citation book cs1">Hewlett, Richard G.; Anderson, Oscar E. (1962). <a rel="nofollow" class="external text" href="https://www.governmentattic.org/5docs/TheNewWorld1939-1946.pdf"><i>The New World, 1939–1946</i></a> <span class="cs1-format">(PDF)</span>. University Park: Pennsylvania State University Press. pp.&#160;15–16. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-520-07186-5" title="Special:BookSources/978-0-520-07186-5"><bdi>978-0-520-07186-5</bdi></a>. <a href="/wiki/OCLC_(identifier)" class="mw-redirect" title="OCLC (identifier)">OCLC</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/oclc/637004643">637004643</a><span class="reference-accessdate">. Retrieved <span class="nowrap">7 June</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+New+World%2C+1939%E2%80%931946&amp;rft.place=University+Park&amp;rft.pages=15-16&amp;rft.pub=Pennsylvania+State+University+Press&amp;rft.date=1962&amp;rft_id=info%3Aoclcnum%2F637004643&amp;rft.isbn=978-0-520-07186-5&amp;rft.aulast=Hewlett&amp;rft.aufirst=Richard+G.&amp;rft.au=Anderson%2C+Oscar+E.&amp;rft_id=https%3A%2F%2Fwww.governmentattic.org%2F5docs%2FTheNewWorld1939-1946.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-z73PK-140"><span class="mw-cite-backlink"><b><a href="#cite_ref-z73PK_140-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFEinstein1952" class="citation web cs1">Einstein, Albert (1952). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20150828230457/http://www.atomicarchive.com/Docs/Hiroshima/EinsteinResponse.shtml">"On My Participation in the Atom Bomb Project"</a>. Archived from <a rel="nofollow" class="external text" href="http://www.atomicarchive.com/Docs/Hiroshima/EinsteinResponse.shtml">the original</a> on 28 August 2015<span class="reference-accessdate">. Retrieved <span class="nowrap">7 June</span> 2015</span> &#8211; via atomicarchive.org.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=On+My+Participation+in+the+Atom+Bomb+Project&amp;rft.date=1952&amp;rft.aulast=Einstein&amp;rft.aufirst=Albert&amp;rft_id=http%3A%2F%2Fwww.atomicarchive.com%2FDocs%2FHiroshima%2FEinsteinResponse.shtml&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEClark1971&#91;&#91;Category:Wikipedia_articles_needing_page_number_citations_from_November_2020&#93;&#93;&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;&#91;&#91;Wikipedia:Citing_sources&#124;&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;&#93;&#93;&lt;/i&gt;&amp;#93;&lt;/sup&gt;-141"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEClark1971[[Category:Wikipedia_articles_needing_page_number_citations_from_November_2020]]&lt;sup_class=&quot;noprint_Inline-Template_&quot;_style=&quot;white-space:nowrap;&quot;&gt;&amp;#91;&lt;i&gt;[[Wikipedia:Citing_sources|&lt;span_title=&quot;This_citation_requires_a_reference_to_the_specific_page_or_range_of_pages_in_which_the_material_appears.&amp;#32;(November_2020)&quot;&gt;page&amp;nbsp;needed&lt;/span&gt;]]&lt;/i&gt;&amp;#93;&lt;/sup&gt;_141-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFClark1971">Clark (1971)</a>, p.&#160;<sup class="noprint Inline-Template" style="white-space:nowrap;">&#91;<i><a href="/wiki/Wikipedia:Citing_sources" title="Wikipedia:Citing sources"><span title="This citation requires a reference to the specific page or range of pages in which the material appears. (November 2020)">page&#160;needed</span></a></i>&#93;</sup>.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007432-142"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007432_142-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;432.</span>
</li>
<li id="cite_note-143"><span class="mw-cite-backlink"><b><a href="#cite_ref-143">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFrancis2017" class="citation news cs1">Francis, Matthew (3 March 2017). <a rel="nofollow" class="external text" href="https://www.smithsonianmag.com/science-nature/how-celebrity-scientist-albert-einstein-used-fame-denounce-american-racism-180962356">"How Albert Einstein Used His Fame to Denounce American Racism"</a>. Smithsonian Magazine.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=How+Albert+Einstein+Used+His+Fame+to+Denounce+American+Racism&amp;rft.date=2017-03-03&amp;rft.aulast=Francis&amp;rft.aufirst=Matthew&amp;rft_id=https%3A%2F%2Fwww.smithsonianmag.com%2Fscience-nature%2Fhow-celebrity-scientist-albert-einstein-used-fame-denounce-american-racism-180962356&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTECalaprice2005148–149-144"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalaprice2005148–149_144-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalaprice2005">Calaprice (2005)</a>, pp.&#160;148–149.</span>
</li>
<li id="cite_note-FOOTNOTERobeson2002565-145"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTERobeson2002565_145-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFRobeson2002">Robeson (2002)</a>, p.&#160;565.</span>
</li>
<li id="cite_note-civil-146"><span class="mw-cite-backlink">^ <a href="#cite_ref-civil_146-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-civil_146-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://news.harvard.edu/gazette/story/2007/04/albert-einstein-civil-rights-activist/">"Albert Einstein, Civil Rights activist"</a>, <i>Harvard Gazette</i>, 12 April 2007</span>
</li>
<li id="cite_note-Jerome_Isis-147"><span class="mw-cite-backlink"><b><a href="#cite_ref-Jerome_Isis_147-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFJerome2004" class="citation journal cs1">Jerome, Fred (December 2004). "Einstein, Race, and the Myth of the Cultural Icon". <i>Isis</i>. <b>95</b> (4): 627–639. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2004Isis...95..627J">2004Isis...95..627J</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1086%2F430653">10.1086/430653</a>. <a href="/wiki/JSTOR_(identifier)" class="mw-redirect" title="JSTOR (identifier)">JSTOR</a>&#160;<a rel="nofollow" class="external text" href="//www.jstor.org/stable/10.1086/430653">10.1086/430653</a>. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/16011298">16011298</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:24738716">24738716</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Isis&amp;rft.atitle=Einstein%2C+Race%2C+and+the+Myth+of+the+Cultural+Icon&amp;rft.volume=95&amp;rft.issue=4&amp;rft.pages=627-639&amp;rft.date=2004-12&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A24738716%23id-name%3DS2CID&amp;rft_id=info%3Abibcode%2F2004Isis...95..627J&amp;rft_id=info%3Apmid%2F16011298&amp;rft_id=info%3Adoi%2F10.1086%2F430653&amp;rft_id=%2F%2Fwww.jstor.org%2Fstable%2F10.1086%2F430653%23id-name%3DJSTOR&amp;rft.aulast=Jerome&amp;rft.aufirst=Fred&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-148"><span class="mw-cite-backlink"><b><a href="#cite_ref-148">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFrancis2017" class="citation web cs1">Francis, Matthew (3 March 2017). <a rel="nofollow" class="external text" href="https://www.smithsonianmag.com/science-nature/how-celebrity-scientist-albert-einstein-used-fame-denounce-american-racism-180962356/">"How Albert Einstein Used His Fame to Denounce American Racism"</a>. <i>Smithsonian Magazine</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Smithsonian+Magazine&amp;rft.atitle=How+Albert+Einstein+Used+His+Fame+to+Denounce+American+Racism&amp;rft.date=2017-03-03&amp;rft.aulast=Francis&amp;rft.aufirst=Matthew&amp;rft_id=https%3A%2F%2Fwww.smithsonianmag.com%2Fscience-nature%2Fhow-celebrity-scientist-albert-einstein-used-fame-denounce-american-racism-180962356%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-149"><span class="mw-cite-backlink"><b><a href="#cite_ref-149">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFDennis_Overbye2005" class="citation news cs1">Dennis Overbye (25 January 2005). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2005/01/25/science/brace-yourself-here-comes-einsteins-year.html">"Brace Yourself! Here Comes Einstein\'s Year"</a>. <i><a href="/wiki/The_New_York_Times" title="The New York Times">The New York Times</a></i>. <q>Hebrew University ... which he helped found</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Brace+Yourself%21+Here+Comes+Einstein%27s+Year&amp;rft.date=2005-01-25&amp;rft.au=Dennis+Overbye&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2005%2F01%2F25%2Fscience%2Fbrace-yourself-here-comes-einsteins-year.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007290-150"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007290_150-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;290.</span>
</li>
<li id="cite_note-FOOTNOTERoweSchulmann2007161-151"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTERoweSchulmann2007161_151-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFRoweSchulmann2007">Rowe &amp; Schulmann (2007)</a>, p.&#160;161.</span>
</li>
<li id="cite_note-FOOTNOTERoweSchulmann2007158-152"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTERoweSchulmann2007158_152-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFRoweSchulmann2007">Rowe &amp; Schulmann (2007)</a>, p.&#160;158.</span>
</li>
<li id="cite_note-153"><span class="mw-cite-backlink"><b><a href="#cite_ref-153">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRosenkranz2011" class="citation book cs1">Rosenkranz, Ze\'ev (2011). <i>Einstein Before Israel: Zionist Icon Or Iconoclast?</i>. Princeton University Press. pp.&#160;4–5. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/9780691144122" title="Special:BookSources/9780691144122"><bdi>9780691144122</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+Before+Israel%3A+Zionist+Icon+Or+Iconoclast%3F&amp;rft.pages=4-5&amp;rft.pub=Princeton+University+Press&amp;rft.date=2011&amp;rft.isbn=9780691144122&amp;rft.aulast=Rosenkranz&amp;rft.aufirst=Ze%27ev&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Time-154"><span class="mw-cite-backlink"><b><a href="#cite_ref-Time_154-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="http://www.time.com/time/magazine/article/0,9171,817454,00.html">"ISRAEL: Einstein Declines"</a>. <i><a href="/wiki/Time_(magazine)" title="Time (magazine)">Time</a></i>. 1 December 1952<span class="reference-accessdate">. Retrieved <span class="nowrap">31 March</span> 2010</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Time&amp;rft.atitle=ISRAEL%3A+Einstein+Declines&amp;rft.date=1952-12-01&amp;rft_id=http%3A%2F%2Fwww.time.com%2Ftime%2Fmagazine%2Farticle%2F0%2C9171%2C817454%2C00.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Msb2q-155"><span class="mw-cite-backlink"><b><a href="#cite_ref-Msb2q_155-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRosenkranz2002" class="citation book cs1">Rosenkranz, Ze\'ev (6 November 2002). <i>The Einstein Scrapbook</i>. Baltimore, Maryland: <a href="/wiki/Johns_Hopkins_University_Press" title="Johns Hopkins University Press">Johns Hopkins University Press</a>. p.&#160;103. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-8018-7203-7" title="Special:BookSources/978-0-8018-7203-7"><bdi>978-0-8018-7203-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Einstein+Scrapbook&amp;rft.place=Baltimore%2C+Maryland&amp;rft.pages=103&amp;rft.pub=Johns+Hopkins+University+Press&amp;rft.date=2002-11-06&amp;rft.isbn=978-0-8018-7203-7&amp;rft.aulast=Rosenkranz&amp;rft.aufirst=Ze%27ev&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007522-156"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson2007522_156-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007522_156-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, p.&#160;522.</span>
</li>
<li id="cite_note-BQH5A-157"><span class="mw-cite-backlink"><b><a href="#cite_ref-BQH5A_157-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFDuchen,_Jessica2011" class="citation news cs1">Duchen, Jessica (28 January 2011). <a rel="nofollow" class="external text" href="https://www.independent.co.uk/arts-entertainment/classical/features/the-relative-beauty-of-the-violin-2196313.html">"The relative beauty of the violin"</a>. <i><a href="/wiki/The_Independent" title="The Independent">The Independent</a></i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Independent&amp;rft.atitle=The+relative+beauty+of+the+violin&amp;rft.date=2011-01-28&amp;rft.au=Duchen%2C+Jessica&amp;rft_id=https%3A%2F%2Fwww.independent.co.uk%2Farts-entertainment%2Fclassical%2Ffeatures%2Fthe-relative-beauty-of-the-violin-2196313.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-aBOjz-158"><span class="mw-cite-backlink"><b><a href="#cite_ref-aBOjz_158-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20150828225916/http://www.pha.jhu.edu/einstein/stuff/einstein%26music.pdf">"Einstein and his love of music"</a> <span class="cs1-format">(PDF)</span>. <a href="/wiki/Physics_World" title="Physics World">Physics World</a>. January 2005. Archived from <a rel="nofollow" class="external text" href="http://www.pha.jhu.edu/einstein/stuff/einstein&amp;music.pdf">the original</a> <span class="cs1-format">(PDF)</span> on 28 August 2015.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=Einstein+and+his+love+of+music&amp;rft.date=2005-01&amp;rft_id=http%3A%2F%2Fwww.pha.jhu.edu%2Feinstein%2Fstuff%2Feinstein%26music.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Botstein-159"><span class="mw-cite-backlink">^ <a href="#cite_ref-Botstein_159-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Botstein_159-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-Botstein_159-2"><sup><i><b>c</b></i></sup></a> <a href="#cite_ref-Botstein_159-3"><sup><i><b>d</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPeter_GalisonGerald_James_HoltonSilvan_S._Schweber2008" class="citation book cs1"><a href="/wiki/Peter_Galison" title="Peter Galison">Peter Galison</a>; <a href="/wiki/Gerald_Holton" title="Gerald Holton">Gerald James Holton</a>; <a href="/wiki/Silvan_S._Schweber" title="Silvan S. Schweber">Silvan S. Schweber</a> (2008). <span class="cs1-lock-limited" title="Free access subject to limited trial, subscription normally required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinforstcen00gali"><i>Einstein for the 21st Century: His Legacy in Science, Art, and Modern Culture</i></a></span>. Princeton University Press. pp.&#160;<a rel="nofollow" class="external text" href="https://archive.org/details/einsteinforstcen00gali/page/n181">161</a>–164. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-13520-5" title="Special:BookSources/978-0-691-13520-5"><bdi>978-0-691-13520-5</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+for+the+21st+Century%3A+His+Legacy+in+Science%2C+Art%2C+and+Modern+Culture&amp;rft.pages=161-164&amp;rft.pub=Princeton+University+Press&amp;rft.date=2008&amp;rft.isbn=978-0-691-13520-5&amp;rft.au=Peter+Galison&amp;rft.au=Gerald+James+Holton&amp;rft.au=Silvan+S.+Schweber&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinforstcen00gali&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-kGuWC-160"><span class="mw-cite-backlink"><b><a href="#cite_ref-kGuWC_160-0">^</a></b></span> <span class="reference-text">Article "Alfred Einstein", in <i><a href="/wiki/The_New_Grove_Dictionary_of_Music_and_Musicians" title="The New Grove Dictionary of Music and Musicians">The New Grove Dictionary of Music and Musicians</a></i>, ed. <a href="/wiki/Stanley_Sadie" title="Stanley Sadie">Stanley Sadie</a>. 20 vol. London, Macmillan Publishers Ltd., 1980. <link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-56159-174-9" title="Special:BookSources/978-1-56159-174-9">978-1-56159-174-9</a></span>
</li>
<li id="cite_note-OIn6p-161"><span class="mw-cite-backlink"><b><a href="#cite_ref-OIn6p_161-0">^</a></b></span> <span class="reference-text"><i>The Concise Edition of <a href="/wiki/Baker%27s_Biographical_Dictionary_of_Musicians" title="Baker&#39;s Biographical Dictionary of Musicians">Baker\'s Biographical Dictionary of Musicians</a></i>, 8th ed. Revised by <a href="/wiki/Nicolas_Slonimsky" title="Nicolas Slonimsky">Nicolas Slonimsky</a>. New York, Schirmer Books, 1993. <link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-02-872416-4" title="Special:BookSources/978-0-02-872416-4">978-0-02-872416-4</a></span>
</li>
<li id="cite_note-Times-162"><span class="mw-cite-backlink"><b><a href="#cite_ref-Times_162-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://articles.latimes.com/1985-12-22/entertainment/ca-20526_1_life-estate">Cariaga, Daniel, "Not Taking It with You: A Tale of Two Estates", <i>Los Angeles Times</i></a>, 22 December 1985. Retrieved April 2012.</span>
</li>
<li id="cite_note-RR-163"><span class="mw-cite-backlink"><b><a href="#cite_ref-RR_163-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.rrauction.com/albert_einstein_signed_photo_to_joseph_zoellner.cfm">"Relaxed Einstein signs for a fellow violinist before sailing to Germany for the last time"</a>. <i>RR Auction</i>. 2010.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=RR+Auction&amp;rft.atitle=Relaxed+Einstein+signs+for+a+fellow+violinist+before+sailing+to+Germany+for+the+last+time&amp;rft.date=2010&amp;rft_id=http%3A%2F%2Fwww.rrauction.com%2Falbert_einstein_signed_photo_to_joseph_zoellner.cfm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTERoweSchulmann200783-164"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTERoweSchulmann200783_164-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFRoweSchulmann2007">Rowe &amp; Schulmann (2007)</a>, p.&#160;83.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1949-165"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1949_165-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1949">Einstein (1949)</a>.</span>
</li>
<li id="cite_note-LXsUJ-166"><span class="mw-cite-backlink"><b><a href="#cite_ref-LXsUJ_166-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRoweSchulmann2007a" class="citation web cs1">Rowe, David E.; Schulmann, Robert (8 June 2007a).  David A., Walsh (ed.). <a rel="nofollow" class="external text" href="http://hnn.us/articles/39445.html">"What Were Einstein\'s Politics?"</a>. <i><a href="/wiki/History_News_Network" title="History News Network">History News Network</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">29 July</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=History+News+Network&amp;rft.atitle=What+Were+Einstein%27s+Politics%3F&amp;rft.date=2007-06-08&amp;rft.aulast=Rowe&amp;rft.aufirst=David+E.&amp;rft.au=Schulmann%2C+Robert&amp;rft_id=http%3A%2F%2Fhnn.us%2Farticles%2F39445.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTERoweSchulmann2013&#91;httpsbooksgooglecombooksid_X1dAAAAQBAJpgPA413_412,_413&#93;-167"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTERoweSchulmann2013[httpsbooksgooglecombooksid_X1dAAAAQBAJpgPA413_412,_413]_167-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFRoweSchulmann2013">Rowe &amp; Schulmann (2013)</a>, pp.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=_X1dAAAAQBAJ&amp;pg=PA413">412, 413</a>.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007487,_494,_550-168"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2007487,_494,_550_168-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp.&#160;487, 494, 550.</span>
</li>
<li id="cite_note-ixWWZ-169"><span class="mw-cite-backlink"><b><a href="#cite_ref-ixWWZ_169-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWaldrop2017" class="citation magazine cs1">Waldrop, Mitch (19 April 2017). <a rel="nofollow" class="external text" href="http://news.nationalgeographic.com/2017/04/science-march-einstein-fbi-genius-science/">"Why the FBI Kept a 1,400-Page File on Einstein"</a>. <i>National Geographic</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=National+Geographic&amp;rft.atitle=Why+the+FBI+Kept+a+1%2C400-Page+File+on+Einstein&amp;rft.date=2017-04-19&amp;rft.aulast=Waldrop&amp;rft.aufirst=Mitch&amp;rft_id=http%3A%2F%2Fnews.nationalgeographic.com%2F2017%2F04%2Fscience-march-einstein-fbi-genius-science%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Albano-Müller-170"><span class="mw-cite-backlink"><b><a href="#cite_ref-Albano-Müller_170-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20120117104005/http://www.gandhiserve.org/streams/einstein.html">"Einstein on Gandhi (Einstein\'s letter to Gandhi&#160;&#8211;&#32; Courtesy:Saraswati Albano-Müller &amp; Notes by Einstein on Gandhi&#160;&#8211;&#32; Source: The Hebrew University of Jerusalem )"</a>. Gandhiserve.org. 18 October 1931. Archived from <a rel="nofollow" class="external text" href="http://www.gandhiserve.org/streams/einstein.html">the original</a> on 17 January 2012<span class="reference-accessdate">. Retrieved <span class="nowrap">24 January</span> 2012</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Einstein+on+Gandhi+%28Einstein%27s+letter+to+Gandhi+%26ndash%3B%26%2332%3B+Courtesy%3ASaraswati+Albano-M%C3%BCller+%26+Notes+by+Einstein+on+Gandhi+%26ndash%3B%26%2332%3B+Source%3A+The+Hebrew+University+of+Jerusalem+%29&amp;rft.pub=Gandhiserve.org&amp;rft.date=1931-10-18&amp;rft_id=http%3A%2F%2Fwww.gandhiserve.org%2Fstreams%2Feinstein.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-018QJ-171"><span class="mw-cite-backlink"><b><a href="#cite_ref-018QJ_171-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHitchens2007" class="citation book cs1"><a href="/wiki/Christopher_Hitchens" title="Christopher Hitchens">Hitchens, Christopher</a>, ed. (2007). "Selected Writings on Religion: Albert Einstein". <a href="/wiki/The_Portable_Atheist" title="The Portable Atheist"><i>The Portable Atheist: Essential Readings for the Nonbeliever</i></a>. Da Capo Press. p.&#160;155. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-306-81608-6" title="Special:BookSources/978-0-306-81608-6"><bdi>978-0-306-81608-6</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Selected+Writings+on+Religion%3A+Albert+Einstein&amp;rft.btitle=The+Portable+Atheist%3A+Essential+Readings+for+the+Nonbeliever&amp;rft.pages=155&amp;rft.pub=Da+Capo+Press&amp;rft.date=2007&amp;rft.isbn=978-0-306-81608-6&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidG_iziBAPXtECpgPA325_325&#93;-172"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidG_iziBAPXtECpgPA325_325]_172-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2008">Isaacson (2008)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=G_iziBAPXtEC&amp;pg=PA325">325</a>.</span>
</li>
<li id="cite_note-FOOTNOTECalaprice2000218-173"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTECalaprice2000218_173-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTECalaprice2000218_173-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFCalaprice2000">Calaprice (2000)</a>, p.&#160;218.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidcdxWNE7NY6QCpgPT390_390&#93;-174"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidcdxWNE7NY6QCpgPT390_390]_174-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2008">Isaacson (2008)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=cdxWNE7NY6QC&amp;pg=PT390">390</a>.</span>
</li>
<li id="cite_note-FOOTNOTECalaprice2010&#91;httpsbooksgooglecombooksidG_iziBAPXtECpgPA340_340&#93;-175"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTECalaprice2010[httpsbooksgooglecombooksidG_iziBAPXtECpgPA340_340]_175-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFCalaprice2010">Calaprice (2010)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=G_iziBAPXtEC&amp;pg=PA340">340</a>.</span>
</li>
<li id="cite_note-flickr2687-176"><span class="mw-cite-backlink"><b><a href="#cite_ref-flickr2687_176-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="http://farm3.static.flickr.com/2687/4496554935_0b573db853_o.jpg">Letter to M. Berkowitz, 25 October 1950.</a> Einstein Archive 59–215.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2008&#91;httpsbooksgooglecombooksidOzSJgdwk5esCpgPT461_461&#93;-177"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEIsaacson2008[httpsbooksgooglecombooksidOzSJgdwk5esCpgPT461_461]_177-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFIsaacson2008">Isaacson (2008)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=OzSJgdwk5esC&amp;pg=PT461">461</a>.</span>
</li>
<li id="cite_note-mKToJ-178"><span class="mw-cite-backlink"><b><a href="#cite_ref-mKToJ_178-0">^</a></b></span> <span class="reference-text">Dowbiggin, Ian (2003). <i>A Merciful End</i>. New York: Oxford University Press, <a rel="nofollow" class="external text" href="https://books.google.com/books?id=E1AKtIEIIvUC&amp;pg=PA41">p. 41.</a></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1995&#91;httpsbooksgooglecombooksid9fJkBqwDD3sCpgPA62_62&#93;-179"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1995[httpsbooksgooglecombooksid9fJkBqwDD3sCpgPA62_62]_179-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1995">Einstein (1995)</a>, p.&#160;<a rel="nofollow" class="external text" href="https://books.google.com/books?id=9fJkBqwDD3sC&amp;pg=PA62">62</a>.</span>
</li>
<li id="cite_note-xI99y-180"><span class="mw-cite-backlink"><b><a href="#cite_ref-xI99y_180-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFDvorsky2012" class="citation web cs1">Dvorsky, George (23 October 2012). <a rel="nofollow" class="external text" href="https://io9.com/5954119/einsteins-i-dont-believe-in-god-letter-has-sold-on-ebay--and-youre-not-going-to-believe-the-price">"Einstein\'s \'I don\'t believe in God\' letter has sold on eBay..."</a> <i>io9.com</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=io9.com&amp;rft.atitle=Einstein%27s+%27I+don%27t+believe+in+God%27+letter+has+sold+on+eBay...&amp;rft.date=2012-10-23&amp;rft.aulast=Dvorsky&amp;rft.aufirst=George&amp;rft_id=http%3A%2F%2Fio9.com%2F5954119%2Feinsteins-i-dont-believe-in-god-letter-has-sold-on-ebay--and-youre-not-going-to-believe-the-price&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-BXLfp-181"><span class="mw-cite-backlink"><b><a href="#cite_ref-BXLfp_181-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://www.medscape.com/viewarticle/436253">"The Case of the Scientist with a Pulsating Mass"</a>. <i><a href="/wiki/Medscape" title="Medscape">Medscape</a></i>. 14 June 2002<span class="reference-accessdate">. Retrieved <span class="nowrap">11 June</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Medscape&amp;rft.atitle=The+Case+of+the+Scientist+with+a+Pulsating+Mass&amp;rft.date=2002-06-14&amp;rft_id=http%3A%2F%2Fwww.medscape.com%2Fviewarticle%2F436253&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-QN45b-182"><span class="mw-cite-backlink"><b><a href="#cite_ref-QN45b_182-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAlbert_Einstein_Archives1955" class="citation web cs1">Albert Einstein Archives (April 1955). <a rel="nofollow" class="external text" href="http://alberteinstein.info/vufind1/Digital/EAR000020078#page/1/mode/1up">"Draft of projected Telecast Israel Independence Day, April 1955 (last statement ever written)"</a>. Einstein Archives Online. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20070313231657/http://www.alberteinstein.info/">Archived</a> from the original on 13 March 2007<span class="reference-accessdate">. Retrieved <span class="nowrap">14 March</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Draft+of+projected+Telecast+Israel+Independence+Day%2C+April+1955+%28last+statement+ever+written%29&amp;rft.pub=Einstein+Archives+Online&amp;rft.date=1955-04&amp;rft.au=Albert+Einstein+Archives&amp;rft_id=http%3A%2F%2Falberteinstein.info%2Fvufind1%2FDigital%2FEAR000020078%23page%2F1%2Fmode%2F1up&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-BhiNM-183"><span class="mw-cite-backlink"><b><a href="#cite_ref-BhiNM_183-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCohen,_J._R.Graver,_L._M.1995" class="citation journal cs1">Cohen, J. R.; Graver, L. M. (November 1995). "The ruptured abdominal aortic aneurysm of Albert Einstein". <i>Surgery, Gynecology &amp; Obstetrics</i>. <b>170</b> (5): 455–458. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/2183375">2183375</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Surgery%2C+Gynecology+%26+Obstetrics&amp;rft.atitle=The+ruptured+abdominal+aortic+aneurysm+of+Albert+Einstein&amp;rft.volume=170&amp;rft.issue=5&amp;rft.pages=455-458&amp;rft.date=1995-11&amp;rft_id=info%3Apmid%2F2183375&amp;rft.au=Cohen%2C+J.+R.&amp;rft.au=Graver%2C+L.+M.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-YUhsl-184"><span class="mw-cite-backlink"><b><a href="#cite_ref-YUhsl_184-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCosgrove,_Ben2014" class="citation news cs1">Cosgrove, Ben (14 March 2014). <a rel="nofollow" class="external text" href="http://time.com/3494553/the-day-albert-einstein-died-a-photographers-story/">"The Day Albert Einstein Died: A Photographer\'s Story"</a>. <i><a href="/wiki/Time_(magazine)" title="Time (magazine)">Time</a></i><span class="reference-accessdate">. Retrieved <span class="nowrap">24 April</span> 2018</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Time&amp;rft.atitle=The+Day+Albert+Einstein+Died%3A+A+Photographer%27s+Story&amp;rft.date=2014-03-14&amp;rft.au=Cosgrove%2C+Ben&amp;rft_id=http%3A%2F%2Ftime.com%2F3494553%2Fthe-day-albert-einstein-died-a-photographers-story%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-MqyYW-185"><span class="mw-cite-backlink"><b><a href="#cite_ref-MqyYW_185-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="https://www.npr.org/templates/story/story.php?storyId=4602913">"The Long, Strange Journey of Einstein\'s Brain"</a>. <a href="/wiki/NPR" title="NPR">NPR</a><span class="reference-accessdate">. Retrieved <span class="nowrap">3 October</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.atitle=The+Long%2C+Strange+Journey+of+Einstein%27s+Brain&amp;rft_id=https%3A%2F%2Fwww.npr.org%2Ftemplates%2Fstory%2Fstory.php%3FstoryId%3D4602913&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-186"><span class="mw-cite-backlink"><b><a href="#cite_ref-186">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCosgroveMorse" class="citation web cs1">Cosgrove, Benjamin; Morse, Ralph. <a rel="nofollow" class="external text" href="https://www.life.com/history/the-day-albert-einstein-died-a-photographers-story/">"The Day Albert Einstein Died: A Photographer\'s Story"</a>. <i>www.life.com</i>. <a href="/wiki/Life_magazine" class="mw-redirect" title="Life magazine">Life</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=www.life.com&amp;rft.atitle=The+Day+Albert+Einstein+Died%3A+A+Photographer%E2%80%99s+Story&amp;rft.aulast=Cosgrove&amp;rft.aufirst=Benjamin&amp;rft.au=Morse%2C+Ralph&amp;rft_id=https%3A%2F%2Fwww.life.com%2Fhistory%2Fthe-day-albert-einstein-died-a-photographers-story%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-GQrBZ-187"><span class="mw-cite-backlink"><b><a href="#cite_ref-GQrBZ_187-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFO&#39;ConnorRobertson1997" class="citation book cs1">O\'Connor, J. J.; Robertson, E.F. (1997). <a rel="nofollow" class="external text" href="http://www-history.mcs.st-andrews.ac.uk/Biographies/Einstein.html">"Albert Einstein"</a>. <i>The MacTutor History of Mathematics archive</i>. School of Mathematics and Statistics, University of St. Andrews.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Albert+Einstein&amp;rft.btitle=The+MacTutor+History+of+Mathematics+archive&amp;rft.pub=School+of+Mathematics+and+Statistics%2C+University+of+St.+Andrews&amp;rft.date=1997&amp;rft.aulast=O%27Connor&amp;rft.aufirst=J.+J.&amp;rft.au=Robertson%2C+E.F.&amp;rft_id=http%3A%2F%2Fwww-history.mcs.st-andrews.ac.uk%2FBiographies%2FEinstein.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Obit-188"><span class="mw-cite-backlink"><b><a href="#cite_ref-Obit_188-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLate_City1955" class="citation news cs1">Late City, ed. (18 April 1955).  Written at Princeton, NJ. <a rel="nofollow" class="external text" href="http://select.nytimes.com/gst/abstract.html?res=F60C1EFC3D55107A93CBA8178FD85F418585F9">"Dr. Albert Einstein Dies in Sleep at 76; World Mourns Loss of Great Scientist, Rupture of Aorta Causes Death, Body Cremated, Memorial Here Set"</a>. <i>The New York Times</i>. <b>CIV</b> (35, 514). New York (published 19 April 1955). p.&#160;1. <a href="/wiki/ISSN_(identifier)" class="mw-redirect" title="ISSN (identifier)">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/0362-4331">0362-4331</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Dr.+Albert+Einstein+Dies+in+Sleep+at+76%3B+World+Mourns+Loss+of+Great+Scientist%2C+Rupture+of+Aorta+Causes+Death%2C+Body+Cremated%2C+Memorial+Here+Set&amp;rft.volume=CIV&amp;rft.issue=35%2C+514&amp;rft.pages=1&amp;rft.date=1955-04-18&amp;rft.issn=0362-4331&amp;rft_id=http%3A%2F%2Fselect.nytimes.com%2Fgst%2Fabstract.html%3Fres%3DF60C1EFC3D55107A93CBA8178FD85F418585F9&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-aJHxn-189"><span class="mw-cite-backlink"><b><a href="#cite_ref-aJHxn_189-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOppenheimer1979" class="citation journal cs1"><a href="/wiki/J._Robert_Oppenheimer" title="J. Robert Oppenheimer">Oppenheimer, J. Robert</a> (March 1979). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=7goAAAAAMBAJ&amp;pg=PA38">"Oppenheimer on Einstein"</a>. <i><a href="/wiki/Bulletin_of_the_Atomic_Scientists" title="Bulletin of the Atomic Scientists">Bulletin of the Atomic Scientists</a></i>. <b>35</b> (3): 38. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1979BuAtS..35c..36O">1979BuAtS..35c..36O</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1080%2F00963402.1979.11458597">10.1080/00963402.1979.11458597</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Bulletin+of+the+Atomic+Scientists&amp;rft.atitle=Oppenheimer+on+Einstein&amp;rft.volume=35&amp;rft.issue=3&amp;rft.pages=38&amp;rft.date=1979-03&amp;rft_id=info%3Adoi%2F10.1080%2F00963402.1979.11458597&amp;rft_id=info%3Abibcode%2F1979BuAtS..35c..36O&amp;rft.aulast=Oppenheimer&amp;rft.aufirst=J.+Robert&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D7goAAAAAMBAJ%26pg%3DPA38&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Paul_Arthur_Schilpp,_editor_1951_730–746-190"><span class="mw-cite-backlink">^ <a href="#cite_ref-Paul_Arthur_Schilpp,_editor_1951_730–746_190-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Paul_Arthur_Schilpp,_editor_1951_730–746_190-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPaul_Arthur_Schilpp1951" class="citation book cs1">Paul Arthur Schilpp, ed. (1951). <i>Albert Einstein: Philosopher-Scientist</i>. <b>II</b>. New York: Harper and Brothers Publishers (Harper Torchbook edition). pp.&#160;730–746.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein%3A+Philosopher-Scientist&amp;rft.place=New+York&amp;rft.pages=730-746&amp;rft.pub=Harper+and+Brothers+Publishers+%28Harper+Torchbook+edition%29&amp;rft.date=1951&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span>. His non-scientific works include: <i>About Zionism: Speeches and Lectures by Professor Albert Einstein</i> (1930), "Why War?" (1933, co-authored by <a href="/wiki/Sigmund_Freud" title="Sigmund Freud">Sigmund Freud</a>), <i>The World As I See It</i> (1934), <i>Out of My Later Years</i> (1950), and a book on science for the general reader, <i><a href="/wiki/The_Evolution_of_Physics" title="The Evolution of Physics">The Evolution of Physics</a></i> (1938, co-authored by <a href="/wiki/Leopold_Infeld" title="Leopold Infeld">Leopold Infeld</a>).</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008-191"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008_191-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>.</span>
</li>
<li id="cite_note-NYT-20141204-DB-192"><span class="mw-cite-backlink"><b><a href="#cite_ref-NYT-20141204-DB_192-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOverbye2014" class="citation news cs1"><a href="/wiki/Dennis_Overbye" title="Dennis Overbye">Overbye, Dennis</a> (4 December 2014). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2014/12/05/science/huge-trove-of-albert-einstein-documents-becomes-available-online.html">"Thousands of Einstein Documents Are Now a Click Away"</a>. <i>The New York Times</i><span class="reference-accessdate">. Retrieved <span class="nowrap">4 January</span> 2015</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Thousands+of+Einstein+Documents+Are+Now+a+Click+Away&amp;rft.date=2014-12-04&amp;rft.aulast=Overbye&amp;rft.aufirst=Dennis&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2014%2F12%2F05%2Fscience%2Fhuge-trove-of-albert-einstein-documents-becomes-available-online.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Instituut-Lorentz-193"><span class="mw-cite-backlink">^ <a href="#cite_ref-Instituut-Lorentz_193-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Instituut-Lorentz_193-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text">"<a rel="nofollow" class="external text" href="http://www.lorentz.leidenuniv.nl/history/Einstein_archive/">Einstein archive at the Instituut-Lorentz</a>". <i>Instituut-Lorentz</i>. 2005. Retrieved on 21 November 2005.</span>
</li>
<li id="cite_note-e5xd8-194"><span class="mw-cite-backlink"><b><a href="#cite_ref-e5xd8_194-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPietrow2019" class="citation journal cs1">Pietrow, Alexander G.M. (2019). "Investigations into the origin of Einstein\'s Sink". <i>Studium</i>. <b>11</b> (4): 260–268. <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1905.09022">1905.09022</a></span>. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2019Studi..11E...1P">2019Studi..11E...1P</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.18352%2Fstudium.10183">10.18352/studium.10183</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:162168640">162168640</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Studium&amp;rft.atitle=Investigations+into+the+origin+of+Einstein%27s+Sink&amp;rft.volume=11&amp;rft.issue=4&amp;rft.pages=260-268&amp;rft.date=2019&amp;rft_id=info%3Aarxiv%2F1905.09022&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A162168640%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.18352%2Fstudium.10183&amp;rft_id=info%3Abibcode%2F2019Studi..11E...1P&amp;rft.aulast=Pietrow&amp;rft.aufirst=Alexander+G.M.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1905a-195"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinstein1905a_195-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1905a_195-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1905a_195-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinstein1905a">Einstein (1905a)</a>.</span>
</li>
<li id="cite_note-1Jhcb-196"><span class="mw-cite-backlink"><b><a href="#cite_ref-1Jhcb_196-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFDas2003" class="citation book cs1">Das, Ashok (2003). <i>Lectures on quantum mechanics</i>. Hindustan Book Agency. p.&#160;59. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-81-85931-41-8" title="Special:BookSources/978-81-85931-41-8"><bdi>978-81-85931-41-8</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Lectures+on+quantum+mechanics&amp;rft.pages=59&amp;rft.pub=Hindustan+Book+Agency&amp;rft.date=2003&amp;rft.isbn=978-81-85931-41-8&amp;rft.aulast=Das&amp;rft.aufirst=Ashok&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-oJBvd-197"><span class="mw-cite-backlink"><b><a href="#cite_ref-oJBvd_197-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFSpielbergAnderson1995" class="citation book cs1">Spielberg, Nathan; Anderson, Bryon D. (1995). <span class="cs1-lock-limited" title="Free access subject to limited trial, subscription normally required"><a rel="nofollow" class="external text" href="https://archive.org/details/sevenideasthatsh00spie_874"><i>Seven ideas that shook the universe</i></a></span> (2nd&#160;ed.). John Wiley &amp; Sons. p.&#160;<a rel="nofollow" class="external text" href="https://archive.org/details/sevenideasthatsh00spie_874/page/n276">263</a>. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-471-30606-1" title="Special:BookSources/978-0-471-30606-1"><bdi>978-0-471-30606-1</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Seven+ideas+that+shook+the+universe&amp;rft.pages=263&amp;rft.edition=2nd&amp;rft.pub=John+Wiley+%26+Sons&amp;rft.date=1995&amp;rft.isbn=978-0-471-30606-1&amp;rft.aulast=Spielberg&amp;rft.aufirst=Nathan&amp;rft.au=Anderson%2C+Bryon+D.&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fsevenideasthatsh00spie_874&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1905c-198"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1905c_198-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1905c">Einstein (1905c)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1905d-199"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinstein1905d_199-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1905d_199-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinstein1905d">Einstein (1905d)</a>.</span>
</li>
<li id="cite_note-RhZ8x-200"><span class="mw-cite-backlink"><b><a href="#cite_ref-RhZ8x_200-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMajor2007" class="citation book cs1">Major, Fouad G. (2007). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=tmdr6Wx_2PYC"><i>The quantum beat: principles and applications of atomic clocks</i></a> (2nd&#160;ed.). Springer. p.&#160;142. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-387-69533-4" title="Special:BookSources/978-0-387-69533-4"><bdi>978-0-387-69533-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+quantum+beat%3A+principles+and+applications+of+atomic+clocks&amp;rft.pages=142&amp;rft.edition=2nd&amp;rft.pub=Springer&amp;rft.date=2007&amp;rft.isbn=978-0-387-69533-4&amp;rft.aulast=Major&amp;rft.aufirst=Fouad+G.&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3Dtmdr6Wx_2PYC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-lhfJ9-201"><span class="mw-cite-backlink"><b><a href="#cite_ref-lhfJ9_201-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLindsayMargenau1981" class="citation book cs1">Lindsay, Robert Bruce; Margenau, Henry (1981). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=dwZltQAACAAJ"><i>Foundations of physics</i></a>. Ox Bow Press. p.&#160;330. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-918024-17-6" title="Special:BookSources/978-0-918024-17-6"><bdi>978-0-918024-17-6</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Foundations+of+physics&amp;rft.pages=330&amp;rft.pub=Ox+Bow+Press&amp;rft.date=1981&amp;rft.isbn=978-0-918024-17-6&amp;rft.aulast=Lindsay&amp;rft.aufirst=Robert+Bruce&amp;rft.au=Margenau%2C+Henry&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DdwZltQAACAAJ&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1905e-202"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1905e_202-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1905e">Einstein (1905e)</a>.</span>
</li>
<li id="cite_note-PubList-203"><span class="mw-cite-backlink">^ <a href="#cite_ref-PubList_203-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-PubList_203-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFKuepper" class="citation web cs1">Kuepper, Hans-Josef. <a rel="nofollow" class="external text" href="http://www.einstein-website.de/z_physics/wisspub-e.html">"List of Scientific Publications of Albert Einstein"</a>. Einstein-website.de<span class="reference-accessdate">. Retrieved <span class="nowrap">3 April</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=List+of+Scientific+Publications+of+Albert+Einstein&amp;rft.pub=Einstein-website.de&amp;rft.aulast=Kuepper&amp;rft.aufirst=Hans-Josef&amp;rft_id=http%3A%2F%2Fwww.einstein-website.de%2Fz_physics%2Fwisspub-e.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-L2N73-204"><span class="mw-cite-backlink"><b><a href="#cite_ref-L2N73_204-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLevenson" class="citation web cs1">Levenson, Thomas. <a rel="nofollow" class="external text" href="https://www.pbs.org/wgbh/nova/einstein/genius/">"Genius Among Geniuses"</a>. <i>Einstein\'s Big Idea</i>. Boston: WBGH<span class="reference-accessdate">. Retrieved <span class="nowrap">20 June</span> 2015</span> &#8211; via NOVA by <a href="/wiki/Public_Broadcasting_Service" class="mw-redirect" title="Public Broadcasting Service">Public Broadcasting Service</a> (PBS).</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Einstein%27s+Big+Idea&amp;rft.atitle=Genius+Among+Geniuses&amp;rft.aulast=Levenson&amp;rft.aufirst=Thomas&amp;rft_id=https%3A%2F%2Fwww.pbs.org%2Fwgbh%2Fnova%2Feinstein%2Fgenius%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEFölsing1997178–198-205"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFölsing1997178–198_205-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFölsing1997">Fölsing (1997)</a>, pp.&#160;178–198.</span>
</li>
<li id="cite_note-FOOTNOTEStachel2002vi,_15,_90,_131,_&#91;httpsbooksgooglecomidOAsQ_hFjhrACpgPA215_215&#93;-207"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel2002vi,_15,_90,_131,_[httpsbooksgooglecomidOAsQ_hFjhrACpgPA215_215]_207-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel2002">Stachel (2002)</a>, pp.&#160;vi, 15, 90, 131, <a rel="nofollow" class="external text" href="https://books.google.com/?id=OAsQ_hFjhrAC&amp;pg=PA215">215</a>.</span>
</li>
<li id="cite_note-FOOTNOTEPais1982382–386-209"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982382–386_209-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, pp.&#160;382–386.</span>
</li>
<li id="cite_note-FOOTNOTEPais1982151–152-210"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982151–152_210-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, pp.&#160;151–152.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1923-211"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1923_211-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1923">Einstein (1923)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEPais1982179–183-212"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982179–183_212-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, pp.&#160;179–183.</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008273–274vol._2:_The_Swiss_Years:_Writings,_1900–1909-213"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008273–274vol._2:_The_Swiss_Years:_Writings,_1900–1909_213-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, pp.&#160;273–274, vol. 2: The Swiss Years: Writings, 1900–1909.</span>
</li>
<li id="cite_note-FOOTNOTEPais1982194–195-214"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982194–195_214-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, pp.&#160;194–195.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1916-215"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1916_215-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1916">Einstein (1916)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1918-216"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1918_216-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1918">Einstein (1918)</a>.</span>
</li>
<li id="cite_note-natgeo-217"><span class="mw-cite-backlink">^ <a href="#cite_ref-natgeo_217-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-natgeo_217-1"><sup><i><b>b</b></i></sup></a> <a href="#cite_ref-natgeo_217-2"><sup><i><b>c</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20160212083049/http://news.nationalgeographic.com/2016/02/160211-gravitational-waves-found-spacetime-science/">"Found! Gravitational Waves, or a Wrinkle in Spacetime"</a>. <i>Nadia Drake</i>. National Geographic. 11 February 2016. Archived from <a rel="nofollow" class="external text" href="http://news.nationalgeographic.com/2016/02/160211-gravitational-waves-found-spacetime-science/">the original</a> on 12 February 2016<span class="reference-accessdate">. Retrieved <span class="nowrap">6 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nadia+Drake&amp;rft.atitle=Found%21+Gravitational+Waves%2C+or+a+Wrinkle+in+Spacetime&amp;rft.date=2016-02-11&amp;rft_id=http%3A%2F%2Fnews.nationalgeographic.com%2F2016%2F02%2F160211-gravitational-waves-found-spacetime-science%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Tf1T0-218"><span class="mw-cite-backlink"><b><a href="#cite_ref-Tf1T0_218-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.nobelprize.org/nobel_prizes/physics/laureates/1993/press.html">"Gravity investigated with a binary pulsar-Press Release: The 1993 Nobel Prize in Physics"</a>. Nobel Foundation<span class="reference-accessdate">. Retrieved <span class="nowrap">6 July</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Gravity+investigated+with+a+binary+pulsar-Press+Release%3A+The+1993+Nobel+Prize+in+Physics&amp;rft.pub=Nobel+Foundation&amp;rft_id=https%3A%2F%2Fwww.nobelprize.org%2Fnobel_prizes%2Fphysics%2Flaureates%2F1993%2Fpress.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-PRL-20160211-219"><span class="mw-cite-backlink"><b><a href="#cite_ref-PRL-20160211_219-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAbbott2016" class="citation journal cs1">Abbott, Benjamin P.;  et&#160;al. (LIGO Scientific Collaboration and Virgo Collaboration) (2016). "Observation of Gravitational Waves from a Binary Black Hole Merger". <i><a href="/wiki/Phys._Rev._Lett." class="mw-redirect" title="Phys. Rev. Lett.">Phys. Rev. Lett.</a></i> <b>116</b> (6): 061102. <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1602.03837">1602.03837</a></span>. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2016PhRvL.116f1102A">2016PhRvL.116f1102A</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1103%2FPhysRevLett.116.061102">10.1103/PhysRevLett.116.061102</a>. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/26918975">26918975</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:124959784">124959784</a>. <a rel="nofollow" class="external text" href="https://www.ligo.caltech.edu/system/media_files/binaries/301/original/detection-science-summary.pdf">Lay summary</a> <span class="cs1-format">(PDF)</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Phys.+Rev.+Lett.&amp;rft.atitle=Observation+of+Gravitational+Waves+from+a+Binary+Black+Hole+Merger&amp;rft.volume=116&amp;rft.issue=6&amp;rft.pages=061102&amp;rft.date=2016&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A124959784%23id-name%3DS2CID&amp;rft_id=info%3Abibcode%2F2016PhRvL.116f1102A&amp;rft_id=info%3Aarxiv%2F1602.03837&amp;rft_id=info%3Apmid%2F26918975&amp;rft_id=info%3Adoi%2F10.1103%2FPhysRevLett.116.061102&amp;rft.aulast=Abbott&amp;rft.aufirst=Benjamin+P.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-CO6kH-220"><span class="mw-cite-backlink"><b><a href="#cite_ref-CO6kH_220-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://space.mit.edu/LIGO/more.html">"Gravitational Waves: Ripples in the fabric of space-time"</a>. LIGO | MIT. 11 February 2016<span class="reference-accessdate">. Retrieved <span class="nowrap">12 February</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Gravitational+Waves%3A+Ripples+in+the+fabric+of+space-time&amp;rft.pub=LIGO+%7C+MIT&amp;rft.date=2016-02-11&amp;rft_id=http%3A%2F%2Fspace.mit.edu%2FLIGO%2Fmore.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-oSmHb-221"><span class="mw-cite-backlink"><b><a href="#cite_ref-oSmHb_221-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://news.mit.edu/2016/ligo-first-detection-gravitational-waves-0211">"Scientists make first direct detection of gravitational waves"</a>. <i>Jennifer Chu</i>. MIT News<span class="reference-accessdate">. Retrieved <span class="nowrap">12 February</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Jennifer+Chu&amp;rft.atitle=Scientists+make+first+direct+detection+of+gravitational+waves&amp;rft_id=https%3A%2F%2Fnews.mit.edu%2F2016%2Fligo-first-detection-gravitational-waves-0211&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-hkKSp-222"><span class="mw-cite-backlink"><b><a href="#cite_ref-hkKSp_222-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGhosh2016" class="citation news cs1">Ghosh, Pallab (11 February 2016). <a rel="nofollow" class="external text" href="https://www.bbc.com/news/science-environment-35524440">"Einstein\'s gravitational waves \'seen\' from black holes"</a>. <i>BBC News</i><span class="reference-accessdate">. Retrieved <span class="nowrap">12 February</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=BBC+News&amp;rft.atitle=Einstein%27s+gravitational+waves+%27seen%27+from+black+holes&amp;rft.date=2016-02-11&amp;rft.aulast=Ghosh&amp;rft.aufirst=Pallab&amp;rft_id=https%3A%2F%2Fwww.bbc.com%2Fnews%2Fscience-environment-35524440&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-38Msx-223"><span class="mw-cite-backlink"><b><a href="#cite_ref-38Msx_223-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOverbye2016" class="citation news cs1">Overbye, Dennis (11 February 2016). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2016/02/12/science/ligo-gravitational-waves-black-holes-einstein.html">"Gravitational Waves Detected, Confirming Einstein\'s Theory"</a>. <i>The New York Times</i>. <a href="/wiki/ISSN_(identifier)" class="mw-redirect" title="ISSN (identifier)">ISSN</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/issn/0362-4331">0362-4331</a><span class="reference-accessdate">. Retrieved <span class="nowrap">12 February</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Gravitational+Waves+Detected%2C+Confirming+Einstein%27s+Theory&amp;rft.date=2016-02-11&amp;rft.issn=0362-4331&amp;rft.aulast=Overbye&amp;rft.aufirst=Dennis&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2016%2F02%2F12%2Fscience%2Fligo-gravitational-waves-black-holes-einstein.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-sOA9t-224"><span class="mw-cite-backlink"><b><a href="#cite_ref-sOA9t_224-0">^</a></b></span> <span class="reference-text">van Dongen, Jeroen (2010) <i>Einstein\'s Unification</i> Cambridge University Press, p. 23.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1917a-225"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1917a_225-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1917a">Einstein (1917a)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEPais1994285–286-226"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1994285–286_226-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1994">Pais (1994)</a>, pp.&#160;285–286.</span>
</li>
<li id="cite_note-iJwuX-227"><span class="mw-cite-backlink"><b><a href="#cite_ref-iJwuX_227-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNorth1965" class="citation book cs1">North, J.D. (1965). <i>The Measure of the Universe: A History of Modern Cosmology</i>. New York: Dover. pp.&#160;81–83.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Measure+of+the+Universe%3A+A+History+of+Modern+Cosmology&amp;rft.place=New+York&amp;rft.pages=81-83&amp;rft.pub=Dover&amp;rft.date=1965&amp;rft.aulast=North&amp;rft.aufirst=J.D.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinstein1931-228"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinstein1931_228-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinstein1931_228-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinstein1931">Einstein (1931)</a>.</span>
</li>
<li id="cite_note-cor-2013-229"><span class="mw-cite-backlink">^ <a href="#cite_ref-cor-2013_229-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-cor-2013_229-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFO&#39;RaifeartaighMcCann2014" class="citation journal cs1">O\'Raifeartaigh, C; McCann, B (2014). <a rel="nofollow" class="external text" href="http://repository.wit.ie/2867/1/cosmic.pdf">"Einstein\'s cosmic model of 1931 revisited: An analysis and translation of a forgotten model of the universe"</a> <span class="cs1-format">(PDF)</span>. <i>The European Physical Journal H</i>. <b>39</b> (2014): 63–85. <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1312.2192">1312.2192</a></span>. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2014EPJH...39...63O">2014EPJH...39...63O</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1140%2Fepjh%2Fe2013-40038-x">10.1140/epjh/e2013-40038-x</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:53419239">53419239</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+European+Physical+Journal+H&amp;rft.atitle=Einstein%27s+cosmic+model+of+1931+revisited%3A+An+analysis+and+translation+of+a+forgotten+model+of+the+universe&amp;rft.volume=39&amp;rft.issue=2014&amp;rft.pages=63-85&amp;rft.date=2014&amp;rft_id=info%3Aarxiv%2F1312.2192&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A53419239%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1140%2Fepjh%2Fe2013-40038-x&amp;rft_id=info%3Abibcode%2F2014EPJH...39...63O&amp;rft.aulast=O%27Raifeartaigh&amp;rft.aufirst=C&amp;rft.au=McCann%2C+B&amp;rft_id=http%3A%2F%2Frepository.wit.ie%2F2867%2F1%2Fcosmic.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinsteinde_Sitter1932-230"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinsteinde_Sitter1932_230-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinsteinde_Sitter1932">Einstein &amp; de Sitter (1932)</a>.</span>
</li>
<li id="cite_note-J9Tqu-231"><span class="mw-cite-backlink"><b><a href="#cite_ref-J9Tqu_231-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNussbaumer2014" class="citation journal cs1">Nussbaumer, Harry (2014). "Einstein\'s conversion from his static to an expanding universe". <i>Eur. Phys. J. H</i>. <b>39</b> (1): 37–62. <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1311.2763">1311.2763</a></span>. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2014EPJH...39...37N">2014EPJH...39...37N</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1140%2Fepjh%2Fe2013-40037-6">10.1140/epjh/e2013-40037-6</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:122011477">122011477</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Eur.+Phys.+J.+H&amp;rft.atitle=Einstein%27s+conversion+from+his+static+to+an+expanding+universe&amp;rft.volume=39&amp;rft.issue=1&amp;rft.pages=37-62&amp;rft.date=2014&amp;rft_id=info%3Aarxiv%2F1311.2763&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A122011477%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1140%2Fepjh%2Fe2013-40037-6&amp;rft_id=info%3Abibcode%2F2014EPJH...39...37N&amp;rft.aulast=Nussbaumer&amp;rft.aufirst=Harry&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-sxfvo-232"><span class="mw-cite-backlink"><b><a href="#cite_ref-sxfvo_232-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNussbaumer_and_Bieri2009" class="citation book cs1">Nussbaumer and Bieri (2009). <i>Discovering the Expanding Universe</i>. Cambridge: Cambridge University Press. pp.&#160;144–152.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Discovering+the+Expanding+Universe&amp;rft.place=Cambridge&amp;rft.pages=144-152&amp;rft.pub=Cambridge+University+Press&amp;rft.date=2009&amp;rft.au=Nussbaumer+and+Bieri&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-qmmVf-233"><span class="mw-cite-backlink"><b><a href="#cite_ref-qmmVf_233-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFZimmer2013" class="citation news cs1">Zimmer, Carl (9 June 2013). <a rel="nofollow" class="external text" href="https://www.nytimes.com/2013/06/09/books/review/brilliant-blunders-by-mario-livio.html">"The Genius of Getting It Wrong"</a>. <i>The New York Times</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=The+Genius+of+Getting+It+Wrong&amp;rft.date=2013-06-09&amp;rft.aulast=Zimmer&amp;rft.aufirst=Carl&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F2013%2F06%2F09%2Fbooks%2Freview%2Fbrilliant-blunders-by-mario-livio.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Tq53z-234"><span class="mw-cite-backlink"><b><a href="#cite_ref-Tq53z_234-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCastelvecchi2014" class="citation journal cs1">Castelvecchi, Davide (2014). <a rel="nofollow" class="external text" href="https://doi.org/10.1038%2F506418a">"Einstein\'s lost theory uncovered"</a>. <i>Nature News &amp; Comment</i>. <b>506</b> (7489): 418–419. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2014Natur.506..418C">2014Natur.506..418C</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1038%2F506418a">10.1038/506418a</a></span>. <a href="/wiki/PMID_(identifier)" class="mw-redirect" title="PMID (identifier)">PMID</a>&#160;<a rel="nofollow" class="external text" href="//pubmed.ncbi.nlm.nih.gov/24572403">24572403</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:205080245">205080245</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Nature+News+%26+Comment&amp;rft.atitle=Einstein%27s+lost+theory+uncovered&amp;rft.volume=506&amp;rft.issue=7489&amp;rft.pages=418-419&amp;rft.date=2014&amp;rft_id=info%3Adoi%2F10.1038%2F506418a&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A205080245%23id-name%3DS2CID&amp;rft_id=info%3Apmid%2F24572403&amp;rft_id=info%3Abibcode%2F2014Natur.506..418C&amp;rft.aulast=Castelvecchi&amp;rft.aufirst=Davide&amp;rft_id=%2F%2Fdoi.org%2F10.1038%252F506418a&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-8pfEk-235"><span class="mw-cite-backlink"><b><a href="#cite_ref-8pfEk_235-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://blogs.discovermagazine.com/outthere/2014/03/14/135th-birthday-einstein-still-full-surprises/">"On His 135th Birthday, Einstein is Still Full of Surprises"</a>. <i>Out There</i>. 14 March 2014.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Out+There&amp;rft.atitle=On+His+135th+Birthday%2C+Einstein+is+Still+Full+of+Surprises&amp;rft.date=2014-03-14&amp;rft_id=http%3A%2F%2Fblogs.discovermagazine.com%2Foutthere%2F2014%2F03%2F14%2F135th-birthday-einstein-still-full-surprises%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-cor-steady-state-236"><span class="mw-cite-backlink">^ <a href="#cite_ref-cor-steady-state_236-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-cor-steady-state_236-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFO&#39;RaifeartaighMcCannNahmMitton2014" class="citation journal cs1">O\'Raifeartaigh, C.; McCann, B.; Nahm, W.; Mitton, S. (2014). <a rel="nofollow" class="external text" href="http://repository.wit.ie/2866/1/cormac.pdf">"Einstein\'s steady-state theory: an abandoned model of the cosmos"</a> <span class="cs1-format">(PDF)</span>. <i>Eur. Phys. J. H</i>. <b>39</b> (3): 353–369. <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1402.0132">1402.0132</a></span>. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2014EPJH...39..353O">2014EPJH...39..353O</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1140%2Fepjh%2Fe2014-50011-x">10.1140/epjh/e2014-50011-x</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:38384067">38384067</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Eur.+Phys.+J.+H&amp;rft.atitle=Einstein%27s+steady-state+theory%3A+an+abandoned+model+of+the+cosmos&amp;rft.volume=39&amp;rft.issue=3&amp;rft.pages=353-369&amp;rft.date=2014&amp;rft_id=info%3Aarxiv%2F1402.0132&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A38384067%23id-name%3DS2CID&amp;rft_id=info%3Adoi%2F10.1140%2Fepjh%2Fe2014-50011-x&amp;rft_id=info%3Abibcode%2F2014EPJH...39..353O&amp;rft.aulast=O%27Raifeartaigh&amp;rft.aufirst=C.&amp;rft.au=McCann%2C+B.&amp;rft.au=Nahm%2C+W.&amp;rft.au=Mitton%2C+S.&amp;rft_id=http%3A%2F%2Frepository.wit.ie%2F2866%2F1%2Fcormac.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Einstein&#39;s_aborted_model-237"><span class="mw-cite-backlink">^ <a href="#cite_ref-Einstein&#39;s_aborted_model_237-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-Einstein&#39;s_aborted_model_237-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNussbaumer2014" class="citation arxiv cs1">Nussbaumer, Harry (2014). "Einstein\'s aborted attempt at a dynamic steady-state universe". <a href="/wiki/ArXiv_(identifier)" class="mw-redirect" title="ArXiv (identifier)">arXiv</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="//arxiv.org/abs/1402.4099">1402.4099</a></span> [<a rel="nofollow" class="external text" href="//arxiv.org/archive/physics.hist-ph">physics.hist-ph</a>].</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=preprint&amp;rft.jtitle=arXiv&amp;rft.atitle=Einstein%27s+aborted+attempt+at+a+dynamic+steady-state+universe&amp;rft.date=2014&amp;rft_id=info%3Aarxiv%2F1402.4099&amp;rft.aulast=Nussbaumer&amp;rft.aufirst=Harry&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-ILjYQ-238"><span class="mw-cite-backlink"><b><a href="#cite_ref-ILjYQ_238-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHoyle1948" class="citation journal cs1">Hoyle (1948). <a rel="nofollow" class="external text" href="https://doi.org/10.1093%2Fmnras%2F108.5.372">"A New Model for the Expanding Universe"</a>. <i>MNRAS</i>. <b>108</b> (5): 372. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1948MNRAS.108..372H">1948MNRAS.108..372H</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1093%2Fmnras%2F108.5.372">10.1093/mnras/108.5.372</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=MNRAS&amp;rft.atitle=A+New+Model+for+the+Expanding+Universe&amp;rft.volume=108&amp;rft.issue=5&amp;rft.pages=372&amp;rft.date=1948&amp;rft_id=info%3Adoi%2F10.1093%2Fmnras%2F108.5.372&amp;rft_id=info%3Abibcode%2F1948MNRAS.108..372H&amp;rft.au=Hoyle&amp;rft_id=%2F%2Fdoi.org%2F10.1093%252Fmnras%252F108.5.372&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-ThZb0-239"><span class="mw-cite-backlink"><b><a href="#cite_ref-ThZb0_239-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFBondiGold1948" class="citation journal cs1">Bondi; Gold (1948). <a rel="nofollow" class="external text" href="https://doi.org/10.1093%2Fmnras%2F108.3.252">"The Steady-State Theory of the Expanding Universe"</a>. <i>MNRAS</i>. <b>108</b> (3): 252. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1948MNRAS.108..252B">1948MNRAS.108..252B</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1093%2Fmnras%2F108.3.252">10.1093/mnras/108.3.252</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=MNRAS&amp;rft.atitle=The+Steady-State+Theory+of+the+Expanding+Universe&amp;rft.volume=108&amp;rft.issue=3&amp;rft.pages=252&amp;rft.date=1948&amp;rft_id=info%3Adoi%2F10.1093%2Fmnras%2F108.3.252&amp;rft_id=info%3Abibcode%2F1948MNRAS.108..252B&amp;rft.au=Bondi&amp;rft.au=Gold&amp;rft_id=%2F%2Fdoi.org%2F10.1093%252Fmnras%252F108.3.252&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-7ShC9-240"><span class="mw-cite-backlink"><b><a href="#cite_ref-7ShC9_240-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAmir_Aczel2014" class="citation web cs1">Amir Aczel (7 March 2014). <a rel="nofollow" class="external text" href="http://blogs.discovermagazine.com/crux/2014/03/07/einsteins-lost-theory-describes-a-universe-without-a-big-bang/">"Einstein\'s Lost Theory Describes a Universe Without a Big Bang"</a>. <i>The Crux</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Crux&amp;rft.atitle=Einstein%27s+Lost+Theory+Describes+a+Universe+Without+a+Big+Bang&amp;rft.date=2014-03-07&amp;rft.au=Amir+Aczel&amp;rft_id=http%3A%2F%2Fblogs.discovermagazine.com%2Fcrux%2F2014%2F03%2F07%2Feinsteins-lost-theory-describes-a-universe-without-a-big-bang%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEEinsteinRosen1935-241"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinsteinRosen1935_241-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinsteinRosen1935">Einstein &amp; Rosen (1935)</a>.</span>
</li>
<li id="cite_note-QNjpt-242"><span class="mw-cite-backlink"><b><a href="#cite_ref-QNjpt_242-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://journals.aps.org/general-relativity-centennial">"2015 – General Relativity\'s Centennial"</a>. <a href="/wiki/American_Physical_Society" title="American Physical Society">American Physical Society</a>. 2015<span class="reference-accessdate">. Retrieved <span class="nowrap">7 April</span> 2017</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=2015+%E2%80%93+General+Relativity%27s+Centennial&amp;rft.pub=American+Physical+Society&amp;rft.date=2015&amp;rft_id=https%3A%2F%2Fjournals.aps.org%2Fgeneral-relativity-centennial&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-ja7FY-243"><span class="mw-cite-backlink"><b><a href="#cite_ref-ja7FY_243-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLindley2005" class="citation journal cs1">Lindley, David (25 March 2005). "Focus: The Birth of Wormholes". <i>Physics</i>. <b>15</b>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1103%2Fphysrevfocus.15.11">10.1103/physrevfocus.15.11</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physics&amp;rft.atitle=Focus%3A+The+Birth+of+Wormholes&amp;rft.volume=15&amp;rft.date=2005-03-25&amp;rft_id=info%3Adoi%2F10.1103%2Fphysrevfocus.15.11&amp;rft.aulast=Lindley&amp;rft.aufirst=David&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-ixm32-244"><span class="mw-cite-backlink"><b><a href="#cite_ref-ixm32_244-0">^</a></b></span> <span class="reference-text"><a rel="nofollow" class="external text" href="https://www.osti.gov/accomplishments/nuggets/einstein/solidcolda.html">Celebrating Einstein "Solid Cold". U.S. DOE.</a>, <a href="/wiki/Office_of_Scientific_and_Technical_Information" title="Office of Scientific and Technical Information">Office of Scientific and Technical Information</a>, 2011.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1924-245"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1924_245-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1924">Einstein (1924)</a>.</span>
</li>
<li id="cite_note-nlagl-246"><span class="mw-cite-backlink"><b><a href="#cite_ref-nlagl_246-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20070610080506/https://www.nist.gov/public_affairs/releases/n01-04.htm">"Cornell and Wieman Share 2001 Nobel Prize in Physics"</a>. 9 October 2001. Archived from <a rel="nofollow" class="external text" href="https://www.nist.gov/public_affairs/releases/n01-04.htm">the original</a> on 10 June 2007<span class="reference-accessdate">. Retrieved <span class="nowrap">11 June</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Cornell+and+Wieman+Share+2001+Nobel+Prize+in+Physics&amp;rft.date=2001-10-09&amp;rft_id=https%3A%2F%2Fwww.nist.gov%2Fpublic_affairs%2Freleases%2Fn01-04.htm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-FOOTNOTEPais1982522-247"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPais1982522_247-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPais1982">Pais (1982)</a>, p.&#160;522.</span>
</li>
<li id="cite_note-FOOTNOTEStachel_et_al.2008270ffvol._4:_The_Swiss_Years:_Writings,_1912–1914-248"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEStachel_et_al.2008270ffvol._4:_The_Swiss_Years:_Writings,_1912–1914_248-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFStachel_et_al.2008">Stachel et al. (2008)</a>, pp.&#160;270ff, vol. 4: The Swiss Years: Writings, 1912–1914.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1917b-249"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1917b_249-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1917b">Einstein (1917b)</a>.</span>
</li>
<li id="cite_note-zZ2hS-250"><span class="mw-cite-backlink"><b><a href="#cite_ref-zZ2hS_250-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAndrews2003" class="citation book cs1">Andrews, Robert (2003). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=VK0vR4fsaigC&amp;pg=PT499"><i>The New Penguin Dictionary of Modern Quotations</i></a>. Penguin UK. p.&#160;499. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-14-196531-4" title="Special:BookSources/978-0-14-196531-4"><bdi>978-0-14-196531-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+New+Penguin+Dictionary+of+Modern+Quotations&amp;rft.pages=499&amp;rft.pub=Penguin+UK&amp;rft.date=2003&amp;rft.isbn=978-0-14-196531-4&amp;rft.aulast=Andrews&amp;rft.aufirst=Robert&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DVK0vR4fsaigC%26pg%3DPT499&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-yzZtL-251"><span class="mw-cite-backlink"><b><a href="#cite_ref-yzZtL_251-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPais1979" class="citation journal cs1">Pais, Abraham (October 1979). <a rel="nofollow" class="external text" href="http://ursula.chem.yale.edu/~batista/classes/vvv/RevModPhys.51.863.pdf">"Einstein and the quantum theory"</a> <span class="cs1-format">(PDF)</span>. <i>Reviews of Modern Physics</i>. <b>51</b> (4): 863–914. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1979RvMP...51..863P">1979RvMP...51..863P</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1103%2FRevModPhys.51.863">10.1103/RevModPhys.51.863</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Reviews+of+Modern+Physics&amp;rft.atitle=Einstein+and+the+quantum+theory&amp;rft.volume=51&amp;rft.issue=4&amp;rft.pages=863-914&amp;rft.date=1979-10&amp;rft_id=info%3Adoi%2F10.1103%2FRevModPhys.51.863&amp;rft_id=info%3Abibcode%2F1979RvMP...51..863P&amp;rft.aulast=Pais&amp;rft.aufirst=Abraham&amp;rft_id=http%3A%2F%2Fursula.chem.yale.edu%2F~batista%2Fclasses%2Fvvv%2FRevModPhys.51.863.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Bohr1949-252"><span class="mw-cite-backlink"><b><a href="#cite_ref-Bohr1949_252-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFBohr,_N." class="citation web cs1">Bohr, N. <a rel="nofollow" class="external text" href="https://www.marxists.org/reference/subject/philosophy/works/dk/bohr.htm">"Discussions with Einstein on Epistemological Problems in Atomic Physics"</a>. <i>The Value of Knowledge: A Miniature Library of Philosophy</i>. <a href="/wiki/Marxists_Internet_Archive" title="Marxists Internet Archive">Marxists Internet Archive</a>. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20100913033345/http://www.marxists.org/reference/subject/philosophy/works/dk/bohr.htm">Archived</a> from the original on 13 September 2010<span class="reference-accessdate">. Retrieved <span class="nowrap">30 August</span> 2010</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=The+Value+of+Knowledge%3A+A+Miniature+Library+of+Philosophy&amp;rft.atitle=Discussions+with+Einstein+on+Epistemological+Problems+in+Atomic+Physics&amp;rft.au=Bohr%2C+N.&amp;rft_id=http%3A%2F%2Fwww.marxists.org%2Freference%2Fsubject%2Fphilosophy%2Fworks%2Fdk%2Fbohr.htm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span> From Albert Einstein: Philosopher-Scientist (1949), publ. Cambridge University Press, 1949. Niels Bohr\'s report of conversations with Einstein.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1969-253"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1969_253-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1969">Einstein (1969)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEEinsteinPodolskyRosen1935-254"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEEinsteinPodolskyRosen1935_254-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEEinsteinPodolskyRosen1935_254-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFEinsteinPodolskyRosen1935">Einstein, Podolsky &amp; Rosen (1935)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEIsaacson2007pp._448–453-255"><span class="mw-cite-backlink">^ <a href="#cite_ref-FOOTNOTEIsaacson2007pp._448–453_255-0"><sup><i><b>a</b></i></sup></a> <a href="#cite_ref-FOOTNOTEIsaacson2007pp._448–453_255-1"><sup><i><b>b</b></i></sup></a></span> <span class="reference-text"><a href="#CITEREFIsaacson2007">Isaacson (2007)</a>, pp. 448–453.</span>
</li>
<li id="cite_note-FOOTNOTEPenrose2007583-256"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEPenrose2007583_256-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFPenrose2007">Penrose (2007)</a>, p.&#160;583.</span>
</li>
<li id="cite_note-FOOTNOTEFine2017-257"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEFine2017_257-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFFine2017">Fine (2017)</a>.</span>
</li>
<li id="cite_note-FOOTNOTEEinstein1950-258"><span class="mw-cite-backlink"><b><a href="#cite_ref-FOOTNOTEEinstein1950_258-0">^</a></b></span> <span class="reference-text"><a href="#CITEREFEinstein1950">Einstein (1950)</a>.</span>
</li>
<li id="cite_note-4IMf2-259"><span class="mw-cite-backlink"><b><a href="#cite_ref-4IMf2_259-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMoore1989" class="citation book cs1">Moore, Walter (1989). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/schrodingerlifet00moor"><i>Schrödinger: Life and Thought</i></a></span>. Cambridge: Cambridge University Press. p.&#160;183. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-521-43767-7" title="Special:BookSources/978-0-521-43767-7"><bdi>978-0-521-43767-7</bdi></a><span class="reference-accessdate">. Retrieved <span class="nowrap">28 February</span> 2021</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Schr%C3%B6dinger%3A+Life+and+Thought&amp;rft.place=Cambridge&amp;rft.pages=183&amp;rft.pub=Cambridge+University+Press&amp;rft.date=1989&amp;rft.isbn=978-0-521-43767-7&amp;rft.aulast=Moore&amp;rft.aufirst=Walter&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fschrodingerlifet00moor&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-Goettling-260"><span class="mw-cite-backlink"><b><a href="#cite_ref-Goettling_260-0">^</a></b></span> <span class="reference-text">Goettling, Gary. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20050525082445/http://gtalumni.org/Publications/magazine/sum98/einsrefr.html">Einstein\'s refrigerator</a> <i>Georgia Tech Alumni Magazine.</i> 1998. Retrieved on 12 November 2014. <a href="/wiki/Le%C3%B3_Szil%C3%A1rd" class="mw-redirect" title="Leó Szilárd">Leó Szilárd</a>, a Hungarian physicist who later worked on the Manhattan Project, is credited with the discovery of the <a href="/wiki/Chain_reaction" title="Chain reaction">chain reaction</a></span>
</li>
<li id="cite_note-261"><span class="mw-cite-backlink"><b><a href="#cite_ref-261">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFAlok2008" class="citation news cs1">Alok, Jha (21 September 2008). <a rel="nofollow" class="external text" href="https://www.theguardian.com/science/2008/sep/21/scienceofclimatechange.climatechange">"Einstein fridge design can help global cooling"</a>. <i>The Guardian</i>. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20110124172925/http://www.guardian.co.uk/science/2008/sep/21/scienceofclimatechange.climatechange">Archived</a> from the original on 24 January 2011<span class="reference-accessdate">. Retrieved <span class="nowrap">22 February</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+Guardian&amp;rft.atitle=Einstein+fridge+design+can+help+global+cooling&amp;rft.date=2008-09-21&amp;rft.aulast=Alok&amp;rft.aufirst=Jha&amp;rft_id=https%3A%2F%2Fwww.theguardian.com%2Fscience%2F2008%2Fsep%2F21%2Fscienceofclimatechange.climatechange&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-margot-obituary-263"><span class="mw-cite-backlink"><b><a href="#cite_ref-margot-obituary_263-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="https://www.nytimes.com/1986/07/12/obituaries/margot-einstein-86-is-dead-stepdaughter-of-physicist.html">"Obituary"</a>. <i>The New York Times</i>. 12 July 1986<span class="reference-accessdate">. Retrieved <span class="nowrap">3 April</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Times&amp;rft.atitle=Obituary&amp;rft.date=1986-07-12&amp;rft_id=https%3A%2F%2Fwww.nytimes.com%2F1986%2F07%2F12%2Fobituaries%2Fmargot-einstein-86-is-dead-stepdaughter-of-physicist.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-letters-love-264"><span class="mw-cite-backlink"><b><a href="#cite_ref-letters-love_264-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="http://news.bbc.co.uk/2/hi/science/nature/5168002.stm">"Letters Reveal Einstein Love Life"</a>. <i><a href="/wiki/BBC_News" title="BBC News">BBC News</a></i>. 11 July 2006<span class="reference-accessdate">. Retrieved <span class="nowrap">14 March</span> 2007</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=BBC+News&amp;rft.atitle=Letters+Reveal+Einstein+Love+Life&amp;rft.date=2006-07-11&amp;rft_id=http%3A%2F%2Fnews.bbc.co.uk%2F2%2Fhi%2Fscience%2Fnature%2F5168002.stm&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-casetext-hebrew-university-265"><span class="mw-cite-backlink"><b><a href="#cite_ref-casetext-hebrew-university_265-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://casetext.com/case/hebrew-univ-of-jerusalem-v-gen-motors-llc">"United States District Court, Central District of California, Case No. CV10–03790 AHM (JCx)"</a>. 15 October 2012.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=United+States+District+Court%2C+Central+District+of+California%2C+Case+No.+CV10%E2%80%9303790+AHM+%28JCx%29&amp;rft.date=2012-10-15&amp;rft_id=https%3A%2F%2Fcasetext.com%2Fcase%2Fhebrew-univ-of-jerusalem-v-gen-motors-llc&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-pacermonitor-hebrew-university-266"><span class="mw-cite-backlink"><b><a href="#cite_ref-pacermonitor-hebrew-university_266-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.pacermonitor.com/public/case/944657/The_Hebrew_University_of_Jerusalem_v_General_Motors_LLC">"United States District Court, Central District of California, Case No.: CV-10-3790-AB (JCx)"</a>. 15 January 2015.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=United+States+District+Court%2C+Central+District+of+California%2C+Case+No.%3A+CV-10-3790-AB+%28JCx%29&amp;rft.date=2015-01-15&amp;rft_id=https%3A%2F%2Fwww.pacermonitor.com%2Fpublic%2Fcase%2F944657%2FThe_Hebrew_University_of_Jerusalem_v_General_Motors_LLC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-einstein.biz-267"><span class="mw-cite-backlink"><b><a href="#cite_ref-einstein.biz_267-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="http://einstein.biz/">"Einstein"</a>. Corbis Rights Representation. <a rel="nofollow" class="external text" href="https://web.archive.org/web/20080819220424/http://einstein.biz/">Archived</a> from the original on 19 August 2008<span class="reference-accessdate">. Retrieved <span class="nowrap">8 August</span> 2008</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Einstein&amp;rft.pub=Corbis+Rights+Representation&amp;rft_id=http%3A%2F%2Feinstein.biz%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-268"><span class="mw-cite-backlink"><b><a href="#cite_ref-268">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHalpern2019" class="citation journal cs1"><a href="/wiki/Paul_Halpern" title="Paul Halpern">Halpern, Paul</a> (2019). <a rel="nofollow" class="external text" href="https://physicstoday.scitation.org/doi/10.1063/PT.3.4183">"Albert Einstein, celebrity scientist"</a>. <i><a href="/wiki/Physics_Today" title="Physics Today">Physics Today</a></i>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1063%2FPT.3.4183">10.1063/PT.3.4183</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physics+Today&amp;rft.atitle=Albert+Einstein%2C+celebrity+scientist&amp;rft.date=2019&amp;rft_id=info%3Adoi%2F10.1063%2FPT.3.4183&amp;rft.aulast=Halpern&amp;rft.aufirst=Paul&amp;rft_id=https%3A%2F%2Fphysicstoday.scitation.org%2Fdoi%2F10.1063%2FPT.3.4183&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-269"><span class="mw-cite-backlink"><b><a href="#cite_ref-269">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFahy2015" class="citation magazine cs1">Fahy, Declan (2015). <a rel="nofollow" class="external text" href="https://skepticalinquirer.org/2015/07/a-brief-history-of-scientific-celebrity/">"A Brief History Of Scientific Celebrity"</a>. <i><a href="/wiki/Skeptical_Inquirer" title="Skeptical Inquirer">Skeptical Inquirer</a></i>. Vol.&#160;39 no.&#160;4.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Skeptical+Inquirer&amp;rft.atitle=A+Brief+History+Of+Scientific+Celebrity&amp;rft.volume=39&amp;rft.issue=4&amp;rft.date=2015&amp;rft.aulast=Fahy&amp;rft.aufirst=Declan&amp;rft_id=https%3A%2F%2Fskepticalinquirer.org%2F2015%2F07%2Fa-brief-history-of-scientific-celebrity%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-270"><span class="mw-cite-backlink"><b><a href="#cite_ref-270">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMissner1985" class="citation journal cs1">Missner, Marshall (May 1985). <a rel="nofollow" class="external text" href="https://www.jstor.org/stable/285389">"Why Einstein Became Famous in America"</a>. <i><a href="/wiki/Social_Studies_of_Science" title="Social Studies of Science">Social Studies of Science</a></i>. <b>15</b> (2): 267–291. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1177%2F030631285015002003">10.1177/030631285015002003</a>. <a href="/wiki/JSTOR_(identifier)" class="mw-redirect" title="JSTOR (identifier)">JSTOR</a>&#160;<a rel="nofollow" class="external text" href="//www.jstor.org/stable/285389">285389</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:143398600">143398600</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Social+Studies+of+Science&amp;rft.atitle=Why+Einstein+Became+Famous+in+America&amp;rft.volume=15&amp;rft.issue=2&amp;rft.pages=267-291&amp;rft.date=1985-05&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A143398600%23id-name%3DS2CID&amp;rft_id=%2F%2Fwww.jstor.org%2Fstable%2F285389%23id-name%3DJSTOR&amp;rft_id=info%3Adoi%2F10.1177%2F030631285015002003&amp;rft.aulast=Missner&amp;rft.aufirst=Marshall&amp;rft_id=https%3A%2F%2Fwww.jstor.org%2Fstable%2F285389&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-disguise-271"><span class="mw-cite-backlink"><b><a href="#cite_ref-disguise_271-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLibman1939" class="citation journal cs1">Libman, E. (14 January 1939). <span class="cs1-lock-limited" title="Free access subject to limited trial, subscription normally required"><a rel="nofollow" class="external text" href="https://www.newyorker.com/magazine/1939/01/14/disguise-2">"Disguise"</a></span>. <i>The New Yorker</i>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+Yorker&amp;rft.atitle=Disguise&amp;rft.date=1939-01-14&amp;rft.aulast=Libman&amp;rft.aufirst=E.&amp;rft_id=https%3A%2F%2Fwww.newyorker.com%2Fmagazine%2F1939%2F01%2F14%2Fdisguise-2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-orchestra-272"><span class="mw-cite-backlink"><b><a href="#cite_ref-orchestra_272-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMcTee" class="citation web cs1">McTee, Cindy. <a rel="nofollow" class="external text" href="http://www.cindymctee.com/einsteins_dream.html">"Einstein\'s Dream for orchestra"</a>. Cindymctee.com.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Einstein%27s+Dream+for+orchestra&amp;rft.pub=Cindymctee.com&amp;rft.aulast=McTee&amp;rft.aufirst=Cindy&amp;rft_id=http%3A%2F%2Fwww.cindymctee.com%2Feinsteins_dream.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-slqbwn-273"><span class="mw-cite-backlink"><b><a href="#cite_ref-slqbwn_273-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGolden2000" class="citation news cs1">Golden, Frederic (3 January 2000). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20060221080452/http://www.time.com/time/time100/poc/magazine/albert_einstein5a.html">"Person of the Century: Albert Einstein"</a>. <i>Time</i>. Archived from <a rel="nofollow" class="external text" href="https://www.time.com/time/time100/poc/magazine/albert_einstein5a.html">the original</a> on 21 February 2006<span class="reference-accessdate">. Retrieved <span class="nowrap">25 February</span> 2006</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Time&amp;rft.atitle=Person+of+the+Century%3A+Albert+Einstein&amp;rft.date=2000-01-03&amp;rft.aulast=Golden&amp;rft.aufirst=Frederic&amp;rft_id=https%3A%2F%2Fwww.time.com%2Ftime%2Ftime100%2Fpoc%2Fmagazine%2Falbert_einstein5a.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-fake-quotes-274"><span class="mw-cite-backlink"><b><a href="#cite_ref-fake-quotes_274-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNovak2015" class="citation web cs1">Novak, Matt (16 May 2015). <a rel="nofollow" class="external text" href="https://www.gizmodo.com.au/2015/05/9-albert-einstein-quotes-that-are-totally-fake/">"9 Albert Einstein Quotes That Are Completely Fake"</a>. <i>Gizmodo</i><span class="reference-accessdate">. Retrieved <span class="nowrap">4 May</span> 2018</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=unknown&amp;rft.jtitle=Gizmodo&amp;rft.atitle=9+Albert+Einstein+Quotes+That+Are+Completely+Fake&amp;rft.date=2015-05-16&amp;rft.aulast=Novak&amp;rft.aufirst=Matt&amp;rft_id=https%3A%2F%2Fwww.gizmodo.com.au%2F2015%2F05%2F9-albert-einstein-quotes-that-are-totally-fake%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
<li id="cite_note-humiliate-atheist-275"><span class="mw-cite-backlink"><b><a href="#cite_ref-humiliate-atheist_275-0">^</a></b></span> <span class="reference-text"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://www.snopes.com/fact-check/false-einstein-humiliates-professor/">"Did Albert Einstein Humiliate an Atheist Professor?"</a>. Snopes<span class="reference-accessdate">. Retrieved <span class="nowrap">4 May</span> 2018</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=Did+Albert+Einstein+Humiliate+an+Atheist+Professor%3F&amp;rft.pub=Snopes&amp;rft_id=https%3A%2F%2Fwww.snopes.com%2Ffact-check%2Ffalse-einstein-humiliates-professor%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></span>
</li>
</ol></div></div>
<h3><span class="mw-headline" id="Works_cited">Works cited</span></h3>
<link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r998391716"/><div class="div-col" style="column-width: 35em;">
<ul><li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCalaprice2000" class="citation book cs1">Calaprice, Alice (2000). <i>The Expanded Quotable Einstein</i>. Princeton University Press.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Expanded+Quotable+Einstein&amp;rft.pub=Princeton+University+Press&amp;rft.date=2000&amp;rft.aulast=Calaprice&amp;rft.aufirst=Alice&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCalaprice2005" class="citation book cs1">Calaprice, Alice (2005). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20090622063213/http://press.princeton.edu/titles/7921.html"><i>The New Quotable Einstein</i></a>. Princeton University Press. Archived from <a rel="nofollow" class="external text" href="http://press.princeton.edu/titles/7921.html">the original</a> on 22 June 2009.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+New+Quotable+Einstein&amp;rft.pub=Princeton+University+Press&amp;rft.date=2005&amp;rft.aulast=Calaprice&amp;rft.aufirst=Alice&amp;rft_id=http%3A%2F%2Fpress.princeton.edu%2Ftitles%2F7921.html&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCalapriceLipscombe2005" class="citation book cs1">Calaprice, Alice; Lipscombe, Trevor (2005). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=5eWh2O_3OAQC"><i>Albert Einstein: A Biography</i></a>. Greenwood Publishing Group. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-313-33080-3" title="Special:BookSources/978-0-313-33080-3"><bdi>978-0-313-33080-3</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein%3A+A+Biography&amp;rft.pub=Greenwood+Publishing+Group&amp;rft.date=2005&amp;rft.isbn=978-0-313-33080-3&amp;rft.aulast=Calaprice&amp;rft.aufirst=Alice&amp;rft.au=Lipscombe%2C+Trevor&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D5eWh2O_3OAQC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCalaprice2010" class="citation book cs1">Calaprice, Alice (2010). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=G_iziBAPXtEC"><i>The Ultimate Quotable Einstein</i></a>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-4008-3596-6" title="Special:BookSources/978-1-4008-3596-6"><bdi>978-1-4008-3596-6</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Ultimate+Quotable+Einstein&amp;rft.pub=Princeton+University+Press&amp;rft.date=2010&amp;rft.isbn=978-1-4008-3596-6&amp;rft.aulast=Calaprice&amp;rft.aufirst=Alice&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DG_iziBAPXtEC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFCalapriceKennefickSchulmann2015" class="citation book cs1">Calaprice, Alice; Kennefick, Daniel; Schulmann, Robert (2015). <i>An Einstein Encyclopedia</i>. Princeton University Press.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=An+Einstein+Encyclopedia&amp;rft.pub=Princeton+University+Press&amp;rft.date=2015&amp;rft.aulast=Calaprice&amp;rft.aufirst=Alice&amp;rft.au=Kennefick%2C+Daniel&amp;rft.au=Schulmann%2C+Robert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFChaplin1964" class="citation book cs1">Chaplin, Charles (1964). <i>Charles Chaplin: My Autobiography</i>. New York: Simon and Schuster.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Charles+Chaplin%3A+My+Autobiography&amp;rft.place=New+York&amp;rft.pub=Simon+and+Schuster&amp;rft.date=1964&amp;rft.aulast=Chaplin&amp;rft.aufirst=Charles&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFClark1971" class="citation book cs1"><a href="/wiki/Ronald_W._Clark" title="Ronald W. Clark">Clark, Ronald W.</a> (1971). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einstein00rona"><i>Einstein: The Life and Times</i></a></span>. New York: Avon Books. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-380-44123-5" title="Special:BookSources/978-0-380-44123-5"><bdi>978-0-380-44123-5</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+The+Life+and+Times&amp;rft.place=New+York&amp;rft.pub=Avon+Books&amp;rft.date=1971&amp;rft.isbn=978-0-380-44123-5&amp;rft.aulast=Clark&amp;rft.aufirst=Ronald+W.&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinstein00rona&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFölsing1997" class="citation book cs1">Fölsing, Albrecht (1997). <a rel="nofollow" class="external text" href="https://archive.org/details/alberteinsteinbi00fols"><i>Albert Einstein</i></a>. Translated by Osers, Ewald. Abridged by Ewald Osers. New York: Penguin Viking. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-670-85545-2" title="Special:BookSources/978-0-670-85545-2"><bdi>978-0-670-85545-2</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein&amp;rft.place=New+York&amp;rft.pub=Penguin+Viking&amp;rft.date=1997&amp;rft.isbn=978-0-670-85545-2&amp;rft.aulast=F%C3%B6lsing&amp;rft.aufirst=Albrecht&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Falberteinsteinbi00fols&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFFine2017" class="citation journal cs1">Fine, Arthur (2017). <a rel="nofollow" class="external text" href="https://plato.stanford.edu/entries/qt-epr/">"The Einstein-Podolsky-Rosen Argument in Quantum Theory"</a>. <i>Stanford Encyclopedia of Philosophy</i>. Metaphysics Research Lab, Stanford University.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Stanford+Encyclopedia+of+Philosophy&amp;rft.atitle=The+Einstein-Podolsky-Rosen+Argument+in+Quantum+Theory&amp;rft.date=2017&amp;rft.aulast=Fine&amp;rft.aufirst=Arthur&amp;rft_id=https%3A%2F%2Fplato.stanford.edu%2Fentries%2Fqt-epr%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGalison2000" class="citation journal cs1">Galison, Peter (Winter 2000). "Einstein\'s Clocks: The Question of Time". <i>Critical Inquiry</i>. <b>26</b> (2): 355–389. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1086%2F448970">10.1086/448970</a>. <a href="/wiki/JSTOR_(identifier)" class="mw-redirect" title="JSTOR (identifier)">JSTOR</a>&#160;<a rel="nofollow" class="external text" href="//www.jstor.org/stable/1344127">1344127</a>. <a href="/wiki/S2CID_(identifier)" class="mw-redirect" title="S2CID (identifier)">S2CID</a>&#160;<a rel="nofollow" class="external text" href="https://api.semanticscholar.org/CorpusID:144484466">144484466</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Critical+Inquiry&amp;rft.atitle=Einstein%27s+Clocks%3A+The+Question+of+Time&amp;rft.ssn=winter&amp;rft.volume=26&amp;rft.issue=2&amp;rft.pages=355-389&amp;rft.date=2000&amp;rft_id=https%3A%2F%2Fapi.semanticscholar.org%2FCorpusID%3A144484466%23id-name%3DS2CID&amp;rft_id=%2F%2Fwww.jstor.org%2Fstable%2F1344127%23id-name%3DJSTOR&amp;rft_id=info%3Adoi%2F10.1086%2F448970&amp;rft.aulast=Galison&amp;rft.aufirst=Peter&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGlick1987" class="citation book cs1">Glick, Thomas F., ed. (1987). <i>The Comparative Reception of Relativity</i>. Kluwer Academic Publishers. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-90-277-2498-4" title="Special:BookSources/978-90-277-2498-4"><bdi>978-90-277-2498-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Comparative+Reception+of+Relativity&amp;rft.pub=Kluwer+Academic+Publishers&amp;rft.date=1987&amp;rft.isbn=978-90-277-2498-4&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHighfieldCarter1993" class="citation book cs1"><a href="/wiki/Roger_Highfield" title="Roger Highfield">Highfield, Roger</a>; Carter, Paul (1993). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/privatelivesofal00high_1"><i>The Private Lives of Albert Einstein</i></a></span>. London: Faber and Faber. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-571-17170-5" title="Special:BookSources/978-0-571-17170-5"><bdi>978-0-571-17170-5</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Private+Lives+of+Albert+Einstein&amp;rft.place=London&amp;rft.pub=Faber+and+Faber&amp;rft.date=1993&amp;rft.isbn=978-0-571-17170-5&amp;rft.aulast=Highfield&amp;rft.aufirst=Roger&amp;rft.au=Carter%2C+Paul&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fprivatelivesofal00high_1&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHoffmann1972" class="citation book cs1">Hoffmann, Banesh (1972). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/alberteinsteincr0000hoff_y3a8"><i>Albert Einstein: Creator and Rebel</i></a></span>. Collaboration with Helen Dukas. New York: Viking Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-670-11181-7" title="Special:BookSources/978-0-670-11181-7"><bdi>978-0-670-11181-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein%3A+Creator+and+Rebel&amp;rft.place=New+York&amp;rft.pub=Viking+Press&amp;rft.date=1972&amp;rft.isbn=978-0-670-11181-7&amp;rft.aulast=Hoffmann&amp;rft.aufirst=Banesh&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Falberteinsteincr0000hoff_y3a8&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFHolton1984" class="citation journal cs1">Holton, Gerald (April 1984). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=prgDAAAAMBAJ&amp;pg=PA18">"The migration of physicists to the United States"</a>. <i>Bulletin of the Atomic Scientists</i>. Educational Foundation for Nuclear Science. <b>40</b> (4): 18–24. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/1984BuAtS..40d..18H">1984BuAtS..40d..18H</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1080%2F00963402.1984.11459207">10.1080/00963402.1984.11459207</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Bulletin+of+the+Atomic+Scientists&amp;rft.atitle=The+migration+of+physicists+to+the+United+States&amp;rft.volume=40&amp;rft.issue=4&amp;rft.pages=18-24&amp;rft.date=1984-04&amp;rft_id=info%3Adoi%2F10.1080%2F00963402.1984.11459207&amp;rft_id=info%3Abibcode%2F1984BuAtS..40d..18H&amp;rft.aulast=Holton&amp;rft.aufirst=Gerald&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DprgDAAAAMBAJ%26pg%3DPA18&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFIsaacson2007" class="citation book cs1"><a href="/wiki/Walter_Isaacson" title="Walter Isaacson">Isaacson, Walter</a> (2007). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinhislifeu0000isaa"><i>Einstein: His Life and Universe</i></a></span>. New York: Simon &amp; Schuster Paperbacks. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-7432-6473-0" title="Special:BookSources/978-0-7432-6473-0"><bdi>978-0-7432-6473-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+His+Life+and+Universe&amp;rft.place=New+York&amp;rft.pub=Simon+%26+Schuster+Paperbacks&amp;rft.date=2007&amp;rft.isbn=978-0-7432-6473-0&amp;rft.aulast=Isaacson&amp;rft.aufirst=Walter&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinhislifeu0000isaa&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFIsaacson2008" class="citation book cs1"><a href="/wiki/Walter_Isaacson" title="Walter Isaacson">Isaacson, Walter</a> (2008). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=OzSJgdwk5esC"><i>Einstein: His Life and Universe</i></a>. New York: Simon &amp; Schuster. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-8473-9589-4" title="Special:BookSources/978-1-8473-9589-4"><bdi>978-1-8473-9589-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+His+Life+and+Universe&amp;rft.place=New+York&amp;rft.pub=Simon+%26+Schuster&amp;rft.date=2008&amp;rft.isbn=978-1-8473-9589-4&amp;rft.aulast=Isaacson&amp;rft.aufirst=Walter&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DOzSJgdwk5esC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFNeffe2007" class="citation book cs1">Neffe, Jürgen (2007). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=B8K6n177ZwcC"><i>Einstein: A Biography</i></a>. Translated by Frisch, Shelley. <a href="/wiki/Farrar,_Straus_and_Giroux" title="Farrar, Straus and Giroux">Farrar, Straus and Giroux</a>. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-374-14664-1" title="Special:BookSources/978-0-374-14664-1"><bdi>978-0-374-14664-1</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+A+Biography&amp;rft.pub=Farrar%2C+Straus+and+Giroux&amp;rft.date=2007&amp;rft.isbn=978-0-374-14664-1&amp;rft.aulast=Neffe&amp;rft.aufirst=J%C3%BCrgen&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DB8K6n177ZwcC&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPais1982" class="citation book cs1">Pais, Abraham (1982). <i><a href="/wiki/Subtle_is_the_Lord:_The_Science_and_the_Life_of_Albert_Einstein" class="mw-redirect" title="Subtle is the Lord: The Science and the Life of Albert Einstein">Subtle is the Lord: The Science and the Life of Albert Einstein</a></i>. Oxford University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-19-853907-0" title="Special:BookSources/978-0-19-853907-0"><bdi>978-0-19-853907-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Subtle+is+the+Lord%3A+The+Science+and+the+Life+of+Albert+Einstein&amp;rft.pub=Oxford+University+Press&amp;rft.date=1982&amp;rft.isbn=978-0-19-853907-0&amp;rft.aulast=Pais&amp;rft.aufirst=Abraham&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPais1994" class="citation book cs1">Pais, Abraham (1994). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinlivedher00pais"><i>Einstein Lived Here</i></a></span>. Oxford University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-19-280672-7" title="Special:BookSources/978-0-19-280672-7"><bdi>978-0-19-280672-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+Lived+Here&amp;rft.pub=Oxford+University+Press&amp;rft.date=1994&amp;rft.isbn=978-0-19-280672-7&amp;rft.aulast=Pais&amp;rft.aufirst=Abraham&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinlivedher00pais&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFPenrose2007" class="citation book cs1">Penrose, Roger (2007). <i>The Road to Reality</i>. Vintage Books. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-679-77631-4" title="Special:BookSources/978-0-679-77631-4"><bdi>978-0-679-77631-4</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+Road+to+Reality&amp;rft.pub=Vintage+Books&amp;rft.date=2007&amp;rft.isbn=978-0-679-77631-4&amp;rft.aulast=Penrose&amp;rft.aufirst=Roger&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRobeson2002" class="citation book cs1">Robeson, Paul (2002). <i>Paul Robeson Speaks</i>. Citadel. p.&#160;333.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Paul+Robeson+Speaks&amp;rft.pages=333&amp;rft.pub=Citadel&amp;rft.date=2002&amp;rft.aulast=Robeson&amp;rft.aufirst=Paul&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRoweSchulmann2007" class="citation book cs1">Rowe, David E.; Schulmann, Robert, eds. (2007). <i>Einstein on Politics: His Private Thoughts and Public Stands on Nationalism, Zionism, War, Peace, and the Bomb</i>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-12094-2" title="Special:BookSources/978-0-691-12094-2"><bdi>978-0-691-12094-2</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+on+Politics%3A+His+Private+Thoughts+and+Public+Stands+on+Nationalism%2C+Zionism%2C+War%2C+Peace%2C+and+the+Bomb&amp;rft.pub=Princeton+University+Press&amp;rft.date=2007&amp;rft.isbn=978-0-691-12094-2&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRoweSchulmann2013" class="citation book cs1">Rowe, David E.; Schulmann, Robert, eds. (2013). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=_X1dAAAAQBAJ"><i>Einstein on Politics: His Private Thoughts and Public Stands on Nationalism, Zionism, War, Peace, and the Bomb</i></a>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-4008-4828-7" title="Special:BookSources/978-1-4008-4828-7"><bdi>978-1-4008-4828-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+on+Politics%3A+His+Private+Thoughts+and+Public+Stands+on+Nationalism%2C+Zionism%2C+War%2C+Peace%2C+and+the+Bomb&amp;rft.pub=Princeton+University+Press&amp;rft.date=2013&amp;rft.isbn=978-1-4008-4828-7&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3D_X1dAAAAQBAJ&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFScheideler2002" class="citation journal cs1">Scheideler, Britta (2002). <a rel="nofollow" class="external text" href="https://www.jstor.org/stable/10.1525/hsps.2002.32.2.319">"The Scientist as Moral Authority: Albert Einstein between Elitism and Democracy, 1914–1933"</a>. <i>Historical Studies in the Physical and Biological Sciences</i>. <b>32</b> (2): 319–346. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<a rel="nofollow" class="external text" href="https://doi.org/10.1525%2Fhsps.2002.32.2.319">10.1525/hsps.2002.32.2.319</a>. <a href="/wiki/JSTOR_(identifier)" class="mw-redirect" title="JSTOR (identifier)">JSTOR</a>&#160;<a rel="nofollow" class="external text" href="//www.jstor.org/stable/10.1525/hsps.2002.32.2.319">10.1525/hsps.2002.32.2.319</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Historical+Studies+in+the+Physical+and+Biological+Sciences&amp;rft.atitle=The+Scientist+as+Moral+Authority%3A+Albert+Einstein+between+Elitism+and+Democracy%2C+1914%E2%80%931933&amp;rft.volume=32&amp;rft.issue=2&amp;rft.pages=319-346&amp;rft.date=2002&amp;rft_id=info%3Adoi%2F10.1525%2Fhsps.2002.32.2.319&amp;rft_id=%2F%2Fwww.jstor.org%2Fstable%2F10.1525%2Fhsps.2002.32.2.319%23id-name%3DJSTOR&amp;rft.aulast=Scheideler&amp;rft.aufirst=Britta&amp;rft_id=https%3A%2F%2Fwww.jstor.org%2Fstable%2F10.1525%2Fhsps.2002.32.2.319&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFStachel1966" class="citation book cs1">Stachel, John J. (1966). <a rel="nofollow" class="external text" href="https://web.archive.org/web/20080307015425/http://philoscience.unibe.ch/lehre/winter99/einstein/Stachel1966.pdf"><i>Albert Einstein and Mileva Marić</i></a> <span class="cs1-format">(PDF)</span>. Archived from <a rel="nofollow" class="external text" href="http://philoscience.unibe.ch/lehre/winter99/einstein/Stachel1966.pdf">the original</a> <span class="cs1-format">(PDF)</span> on 7 March 2008<span class="reference-accessdate">. Retrieved <span class="nowrap">13 May</span> 2016</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Albert+Einstein+and+Mileva+Mari%C4%87&amp;rft.date=1966&amp;rft.aulast=Stachel&amp;rft.aufirst=John+J.&amp;rft_id=http%3A%2F%2Fphiloscience.unibe.ch%2Flehre%2Fwinter99%2Feinstein%2FStachel1966.pdf&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFStachel2002" class="citation book cs1">Stachel, John J. (2002). <i>Einstein from \'B\' to \'Z\'<span></span></i>. Einstein Studies. <b>9</b>. Birkhäuser. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-8176-4143-6" title="Special:BookSources/978-0-8176-4143-6"><bdi>978-0-8176-4143-6</bdi></a>. <a href="/wiki/OCLC_(identifier)" class="mw-redirect" title="OCLC (identifier)">OCLC</a>&#160;<a rel="nofollow" class="external text" href="//www.worldcat.org/oclc/237532460">237532460</a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+from+%27B%27+to+%27Z%27&amp;rft.series=Einstein+Studies&amp;rft.pub=Birkh%C3%A4user&amp;rft.date=2002&amp;rft_id=info%3Aoclcnum%2F237532460&amp;rft.isbn=978-0-8176-4143-6&amp;rft.aulast=Stachel&amp;rft.aufirst=John+J.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWeinstein2015" class="citation book cs1">Weinstein, G. (2015). <a rel="nofollow" class="external text" href="https://books.google.com/books?id=LQz5DAAAQBAJ"><i>General Relativity Conflict and Rivalries: Einstein\'s Polemics with Physicists</i></a>. Newcastle upon Tyne (UK): Cambridge Scholars Publishing. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-4438-8362-7" title="Special:BookSources/978-1-4438-8362-7"><bdi>978-1-4438-8362-7</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=General+Relativity+Conflict+and+Rivalries%3A+Einstein%27s+Polemics+with+Physicists&amp;rft.place=Newcastle+upon+Tyne+%28UK%29&amp;rft.pub=Cambridge+Scholars+Publishing&amp;rft.date=2015&amp;rft.isbn=978-1-4438-8362-7&amp;rft.aulast=Weinstein&amp;rft.aufirst=G.&amp;rft_id=https%3A%2F%2Fbooks.google.com%2Fbooks%3Fid%3DLQz5DAAAQBAJ&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li></ul>
</div>
<h2><span class="mw-headline" id="Further_reading">Further reading</span></h2>
<link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r998391716"/><div class="div-col" style="column-width: 35em;">
<ul><li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFBrian1996" class="citation book cs1">Brian, Denis (1996). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einstein00deni"><i>Einstein: A Life</i></a></span>. New York: John Wiley.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%3A+A+Life&amp;rft.place=New+York&amp;rft.pub=John+Wiley&amp;rft.date=1996&amp;rft.aulast=Brian&amp;rft.aufirst=Denis&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinstein00deni&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFGordin2020" class="citation book cs1">Gordin, Michael D. (2020). <i>Einstein in Bohemia</i>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-17737-3" title="Special:BookSources/978-0-691-17737-3"><bdi>978-0-691-17737-3</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+in+Bohemia&amp;rft.pub=Princeton+University+Press&amp;rft.date=2020&amp;rft.isbn=978-0-691-17737-3&amp;rft.aulast=Gordin&amp;rft.aufirst=Michael+D.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFLindemann1922" class="citation encyclopaedia cs1"><a href="/wiki/Frederick_Alexander_Lindemann" class="mw-redirect" title="Frederick Alexander Lindemann">Lindemann, Frederick Alexander</a> (1922). <span class="cs1-ws-icon" title="s:1922 Encyclopædia Britannica/Einstein, Albert"><a class="external text" href="https://en.wikisource.org/wiki/1922_Encyclop%C3%A6dia_Britannica/Einstein,_Albert">"Einstein, Albert"&#160;</a></span>.  In Chisholm, Hugh (ed.). <i><a href="/wiki/Encyclop%C3%A6dia_Britannica" title="Encyclopædia Britannica">Encyclopædia Britannica</a></i> (12th&#160;ed.). London &amp; New York: The Encyclopædia Britannica Company.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=bookitem&amp;rft.atitle=Einstein%2C+Albert&amp;rft.btitle=Encyclop%C3%A6dia+Britannica&amp;rft.place=London+%26+New+York&amp;rft.edition=12th&amp;rft.pub=The+Encyclop%C3%A6dia+Britannica+Company&amp;rft.date=1922&amp;rft.aulast=Lindemann&amp;rft.aufirst=Frederick+Alexander&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFMoring2004" class="citation book cs1">Moring, Gary (2004). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/completeidiotsgu00mori_0"><i>The complete idiot\'s guide to understanding Einstein</i></a></span> (1st&#160;ed.). Indianapolis, Indiana: Alpha books (Macmillan). <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-02-863180-6" title="Special:BookSources/978-0-02-863180-6"><bdi>978-0-02-863180-6</bdi></a>. <q>idiots guide to einstein.</q></cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=The+complete+idiot%27s+guide+to+understanding+Einstein&amp;rft.place=Indianapolis%2C+Indiana&amp;rft.edition=1st&amp;rft.pub=Alpha+books+%28Macmillan%29&amp;rft.date=2004&amp;rft.isbn=978-0-02-863180-6&amp;rft.aulast=Moring&amp;rft.aufirst=Gary&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Fcompleteidiotsgu00mori_0&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFOppenheimer1971" class="citation journal cs1"><a href="/wiki/J._Robert_Oppenheimer" title="J. Robert Oppenheimer">Oppenheimer, J. Robert</a> (1971). Lecture delivered at the UNESCO House in Paris on 13 December 1965. "On Albert Einstein". <i>Science and Synthesis: An International Colloquium Organized by Unesco on the Tenth Anniversary of the Death of Albert Einstein and Teilhard de Chardin</i>: 8–12, 208.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Science+and+Synthesis%3A+An+International+Colloquium+Organized+by+Unesco+on+the+Tenth+Anniversary+of+the+Death+of+Albert+Einstein+and+Teilhard+de+Chardin&amp;rft.atitle=On+Albert+Einstein&amp;rft.pages=8-12%2C+208&amp;rft.date=1971&amp;rft.aulast=Oppenheimer&amp;rft.aufirst=J.+Robert&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span>, or <link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation news cs1"><a rel="nofollow" class="external text" href="http://www.nybooks.com/articles/archives/1966/mar/17/on-albert-einstein/?pagination=false">"On Albert Einstein by Robert Oppenheimer"</a>. <i><a href="/wiki/The_New_York_Review_of_Books" title="The New York Review of Books">The New York Review of Books</a></i>. 17 March 1966.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=The+New+York+Review+of+Books&amp;rft.atitle=On+Albert+Einstein+by+Robert+Oppenheimer&amp;rft.date=1966-03-17&amp;rft_id=http%3A%2F%2Fwww.nybooks.com%2Farticles%2Farchives%2F1966%2Fmar%2F17%2Fon-albert-einstein%2F%3Fpagination%3Dfalse&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFParker2000" class="citation book cs1">Parker, Barry (2000). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinsbrainch00barr"><i>Einstein\'s Brainchild: Relativity Made Relatively Easy!</i></a></span>. Illustrated by Lori Scoffield-Beer. Prometheus Books. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-1-59102-522-1" title="Special:BookSources/978-1-59102-522-1"><bdi>978-1-59102-522-1</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%27s+Brainchild%3A+Relativity+Made+Relatively+Easy%21&amp;rft.pub=Prometheus+Books&amp;rft.date=2000&amp;rft.isbn=978-1-59102-522-1&amp;rft.aulast=Parker&amp;rft.aufirst=Barry&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinsbrainch00barr&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFRogers2005" class="citation book cs1">Rogers, Donald W. (2005). <i>Einstein\'s "Other" Theory: The Planck-Bose-Einstein Theory of Heat Capacity</i>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-11826-0" title="Special:BookSources/978-0-691-11826-0"><bdi>978-0-691-11826-0</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein%27s+%22Other%22+Theory%3A+The+Planck-Bose-Einstein+Theory+of+Heat+Capacity&amp;rft.pub=Princeton+University+Press&amp;rft.date=2005&amp;rft.isbn=978-0-691-11826-0&amp;rft.aulast=Rogers&amp;rft.aufirst=Donald+W.&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFSchweber2008" class="citation book cs1"><a href="/wiki/Silvan_S._Schweber" title="Silvan S. Schweber">Schweber, Silvan S.</a> (2008). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinoppenhei00schw"><i>Einstein and Oppenheimer: The Meaning of Genius</i></a></span>. Harvard University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-674-02828-9" title="Special:BookSources/978-0-674-02828-9"><bdi>978-0-674-02828-9</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+and+Oppenheimer%3A+The+Meaning+of+Genius&amp;rft.pub=Harvard+University+Press&amp;rft.date=2008&amp;rft.isbn=978-0-674-02828-9&amp;rft.aulast=Schweber&amp;rft.aufirst=Silvan+S.&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinoppenhei00schw&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFStone2013" class="citation book cs1">Stone, A. Douglas (2013). <span class="cs1-lock-registration" title="Free registration required"><a rel="nofollow" class="external text" href="https://archive.org/details/einsteinquantumq0000ston"><i>Einstein and the Quantum</i></a></span>. Princeton University Press. <a href="/wiki/ISBN_(identifier)" class="mw-redirect" title="ISBN (identifier)">ISBN</a>&#160;<a href="/wiki/Special:BookSources/978-0-691-13968-5" title="Special:BookSources/978-0-691-13968-5"><bdi>978-0-691-13968-5</bdi></a>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=book&amp;rft.btitle=Einstein+and+the+Quantum&amp;rft.pub=Princeton+University+Press&amp;rft.date=2013&amp;rft.isbn=978-0-691-13968-5&amp;rft.aulast=Stone&amp;rft.aufirst=A.+Douglas&amp;rft_id=https%3A%2F%2Farchive.org%2Fdetails%2Feinsteinquantumq0000ston&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite id="CITEREFWeinberg2005" class="citation journal cs1">Weinberg, Steven (2005). <a rel="nofollow" class="external text" href="https://doi.org/10.1063%2F1.2155755">"Einstein\'s mistakes"</a>. <i>Physics Today</i>. <b>58</b> (11): 31–35. <a href="/wiki/Bibcode_(identifier)" class="mw-redirect" title="Bibcode (identifier)">Bibcode</a>:<a rel="nofollow" class="external text" href="https://ui.adsabs.harvard.edu/abs/2005PhT....58k..31W">2005PhT....58k..31W</a>. <a href="/wiki/Doi_(identifier)" class="mw-redirect" title="Doi (identifier)">doi</a>:<span class="cs1-lock-free" title="Freely accessible"><a rel="nofollow" class="external text" href="https://doi.org/10.1063%2F1.2155755">10.1063/1.2155755</a></span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Ajournal&amp;rft.genre=article&amp;rft.jtitle=Physics+Today&amp;rft.atitle=Einstein%27s+mistakes&amp;rft.volume=58&amp;rft.issue=11&amp;rft.pages=31-35&amp;rft.date=2005&amp;rft_id=info%3Adoi%2F10.1063%2F1.2155755&amp;rft_id=info%3Abibcode%2F2005PhT....58k..31W&amp;rft.aulast=Weinberg&amp;rft.aufirst=Steven&amp;rft_id=%2F%2Fdoi.org%2F10.1063%252F1.2155755&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span></li></ul>
</div>
<h2><span class="mw-headline" id="External_links">External links</span></h2>
<div role="navigation" aria-labelledby="sister-projects" class="metadata plainlinks sistersitebox plainlist mbox-small" style="border:1px solid #aaa;padding:0;background:#f9f9f9"><div style="padding:0.75em 0;text-align:center"><b style="display:block">Albert Einstein</b>at Wikipedia\'s <a href="/wiki/Wikipedia:Wikimedia_sister_projects" title="Wikipedia:Wikimedia sister projects"><span id="sister-projects">sister projects</span></a></div><ul style="border-top:1px solid #aaa;padding:0.75em 0;width:217px;margin:0 auto"><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/en/thumb/0/06/Wiktionary-logo-v2.svg/27px-Wiktionary-logo-v2.svg.png" decoding="async" width="27" height="27" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/en/thumb/0/06/Wiktionary-logo-v2.svg/41px-Wiktionary-logo-v2.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/0/06/Wiktionary-logo-v2.svg/54px-Wiktionary-logo-v2.svg.png 2x" data-file-width="391" data-file-height="391" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wiktionary.org/wiki/Einstein" class="extiw" title="wikt:Einstein">Definitions</a> from Wiktionary</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/20px-Commons-logo.svg.png" decoding="async" width="20" height="27" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/30px-Commons-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/4/4a/Commons-logo.svg/40px-Commons-logo.svg.png 2x" data-file-width="1024" data-file-height="1376" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://commons.wikimedia.org/wiki/Albert_Einstein" class="extiw" title="c:Albert Einstein">Media</a> from Wikimedia Commons</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/2/24/Wikinews-logo.svg/27px-Wikinews-logo.svg.png" decoding="async" width="27" height="15" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/2/24/Wikinews-logo.svg/41px-Wikinews-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/24/Wikinews-logo.svg/54px-Wikinews-logo.svg.png 2x" data-file-width="759" data-file-height="415" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wikinews.org/wiki/Einstein%27s_equation_turns_100" class="extiw" title="n:Einstein&#39;s equation turns 100">News</a> from Wikinews</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/23px-Wikiquote-logo.svg.png" decoding="async" width="23" height="27" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/35px-Wikiquote-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikiquote-logo.svg/46px-Wikiquote-logo.svg.png 2x" data-file-width="300" data-file-height="355" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wikiquote.org/wiki/Albert_Einstein" class="extiw" title="q:Albert Einstein">Quotations</a> from Wikiquote</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Wikisource-logo.svg/26px-Wikisource-logo.svg.png" decoding="async" width="26" height="27" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Wikisource-logo.svg/39px-Wikisource-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/4/4c/Wikisource-logo.svg/51px-Wikisource-logo.svg.png 2x" data-file-width="410" data-file-height="430" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wikisource.org/wiki/Author:Albert_Einstein" class="extiw" title="s:Author:Albert Einstein">Texts</a> from Wikisource</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikibooks-logo.svg/27px-Wikibooks-logo.svg.png" decoding="async" width="27" height="27" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikibooks-logo.svg/41px-Wikibooks-logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/f/fa/Wikibooks-logo.svg/54px-Wikibooks-logo.svg.png 2x" data-file-width="300" data-file-height="300" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wikibooks.org/wiki/Introduction_to_Astrophysics/Albert_Einstein" class="extiw" title="b:Introduction to Astrophysics/Albert Einstein">Textbooks</a> from Wikibooks</span></li><li style="min-height:31px"><span style="display:inline-block;width:31px;line-height:31px;vertical-align:middle;text-align:center"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/0/0b/Wikiversity_logo_2017.svg/27px-Wikiversity_logo_2017.svg.png" decoding="async" width="27" height="22" style="vertical-align: middle" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/0/0b/Wikiversity_logo_2017.svg/41px-Wikiversity_logo_2017.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/0/0b/Wikiversity_logo_2017.svg/54px-Wikiversity_logo_2017.svg.png 2x" data-file-width="626" data-file-height="512" /></span><span style="display:inline-block;margin-left:4px;width:182px;vertical-align:middle"><a href="https://en.wikiversity.org/wiki/Albert_Einstein" class="extiw" title="v:Albert Einstein">Resources</a> from Wikiversity</span></li></ul></div>
<table role="presentation" class="metadata mbox-small" style="background-color:#f9f9f9;border:1px solid #aaa;color:#000">
<tbody><tr>
<td class="mbox-image"><img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/3/32/Scholia_logo.svg/40px-Scholia_logo.svg.png" decoding="async" width="40" height="39" class="noviewer" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/3/32/Scholia_logo.svg/60px-Scholia_logo.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/32/Scholia_logo.svg/80px-Scholia_logo.svg.png 2x" data-file-width="107" data-file-height="104" /></td>
<td class="mbox-text plainlist"><a href="https://www.wikidata.org/wiki/Wikidata:Scholia" class="extiw" title="d:Wikidata:Scholia">Scholia</a> has an <i>author</i> profile for <i><b><a href="https://iw.toolforge.org/scholia/author/Q937" class="extiw" title="toolforge:scholia/author/Q937">Albert Einstein</a></b></i>.</td></tr>
</tbody></table>
<ul><li><a rel="nofollow" class="external text" href="https://curlie.org/Science/Physics/History/People/Einstein%2C_Albert/">Albert Einstein</a> at <a href="/wiki/Curlie" class="mw-redirect" title="Curlie">Curlie</a></li>
<li><a rel="nofollow" class="external text" href="https://www.gutenberg.org/author/Albert_Einstein">Works by Albert Einstein</a> at <a href="/wiki/Project_Gutenberg" title="Project Gutenberg">Project Gutenberg</a></li>
<li><a rel="nofollow" class="external text" href="https://archive.org/search.php?query=%28%28subject%3A%22Einstein%2C%20Albert%22%20OR%20subject%3A%22Albert%20Einstein%22%20OR%20creator%3A%22Einstein%2C%20Albert%22%20OR%20creator%3A%22Albert%20Einstein%22%20OR%20creator%3A%22Einstein%2C%20A%2E%22%20OR%20title%3A%22Albert%20Einstein%22%20OR%20description%3A%22Einstein%2C%20Albert%22%20OR%20description%3A%22Albert%20Einstein%22%29%20OR%20%28%221879-1955%22%20AND%20Einstein%29%29%20AND%20%28-mediatype:software%29">Works by or about Albert Einstein</a> at <a href="/wiki/Internet_Archive" title="Internet Archive">Internet Archive</a></li>
<li><a rel="nofollow" class="external text" href="https://librivox.org/author/1035">Works by Albert Einstein</a> at <a href="/wiki/LibriVox" title="LibriVox">LibriVox</a> (public domain audiobooks) <img alt="" src="//upload.wikimedia.org/wikipedia/commons/thumb/2/21/Speaker_Icon.svg/15px-Speaker_Icon.svg.png" decoding="async" width="15" height="15" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/2/21/Speaker_Icon.svg/23px-Speaker_Icon.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/21/Speaker_Icon.svg/30px-Speaker_Icon.svg.png 2x" data-file-width="500" data-file-height="500" /></li>
<li><a rel="nofollow" class="external text" href="http://www.shapell.org/Collection/Jewish-Figures/Einstein-Albert">Einstein\'s Personal Correspondence: Religion, Politics, The Holocaust, and Philosophy</a> Shapell Manuscript Foundation</li>
<li><a rel="nofollow" class="external text" href="https://vault.fbi.gov/Albert%20Einstein">Federal Bureau of Investigation file on Albert Einstein</a></li>
<li><a rel="nofollow" class="external text" href="https://web.archive.org/web/20150828225916/http://www.pha.jhu.edu/einstein/stuff/einstein%26music.pdf">Einstein and his love of music</a>, <i><a href="/wiki/Physics_World" title="Physics World">Physics World</a></i></li>
<li><a rel="nofollow" class="external text" href="https://www.nobelprize.org/laureate/26">Albert Einstein</a> on Nobelprize.org <a href="https://www.wikidata.org/wiki/Q937#P8024" title="Edit this at Wikidata"><img alt="Edit this at Wikidata" src="//upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/10px-OOjs_UI_icon_edit-ltr-progressive.svg.png" decoding="async" width="10" height="10" style="vertical-align: text-top" srcset="//upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/15px-OOjs_UI_icon_edit-ltr-progressive.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/20px-OOjs_UI_icon_edit-ltr-progressive.svg.png 2x" data-file-width="20" data-file-height="20" /></a> including the Nobel Lecture 11 July 1923 <i>Fundamental ideas and problems of the theory of relativity</i></li>
<li><a rel="nofollow" class="external text" href="http://www.history.com/topics/albert-einstein">Albert Einstein</a>, videos on History.com</li>
<li><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r999302996"/><cite class="citation web cs1"><a rel="nofollow" class="external text" href="https://web.archive.org/web/20110608004818/http://ocw.mit.edu/courses/science-technology-and-society/sts-042j-einstein-oppenheimer-feynman-physics-in-the-20th-century-spring-2006/">"MIT OpenCourseWare STS.042J/8.225J: Einstein, Oppenheimer, Feynman: Physics in the 20th century"</a>. Archived from <a rel="nofollow" class="external text" href="http://ocw.mit.edu/courses/science-technology-and-society/sts-042j-einstein-oppenheimer-feynman-physics-in-the-20th-century-spring-2006/">the original</a> on 8 June 2011<span class="reference-accessdate">. Retrieved <span class="nowrap">31 March</span> 2011</span>.</cite><span title="ctx_ver=Z39.88-2004&amp;rft_val_fmt=info%3Aofi%2Ffmt%3Akev%3Amtx%3Abook&amp;rft.genre=unknown&amp;rft.btitle=MIT+OpenCourseWare+STS.042J%2F8.225J%3A+Einstein%2C+Oppenheimer%2C+Feynman%3A+Physics+in+the+20th+century&amp;rft_id=http%3A%2F%2Focw.mit.edu%2Fcourses%2Fscience-technology-and-society%2Fsts-042j-einstein-oppenheimer-feynman-physics-in-the-20th-century-spring-2006%2F&amp;rfr_id=info%3Asid%2Fen.wikipedia.org%3AAlbert+Einstein" class="Z3988"></span>&#160;&#8211;&#32; free study course that explores the changing roles of physics and physicists during the 20th century</li>
<li><a rel="nofollow" class="external text" href="http://www.alberteinstein.info/">Albert Einstein Archives Online (80,000+ Documents)</a> (<a rel="nofollow" class="external text" href="http://www.nbcnews.com/id/46785542">MSNBC, 19 March 2012</a>)</li>
<li><a rel="nofollow" class="external text" href="http://www.wdl.org/en/item/2745/">Einstein\'s declaration of intention for American citizenship</a> on the <a href="/wiki/World_Digital_Library" title="World Digital Library">World Digital Library</a></li>
<li><a rel="nofollow" class="external text" href="https://web.archive.org/web/20130929151059/http://archon.brandeis.edu/?p=collections%2Ffindingaid&amp;id=41">Albert Einstein Collection</a> at <a href="/wiki/Brandeis_University" title="Brandeis University">Brandeis University</a></li>
<li><a rel="nofollow" class="external text" href="http://einsteinpapers.press.princeton.edu/">The Collected Papers of Albert Einstein "Digital Einstein"</a> at <a href="/wiki/Princeton_University" title="Princeton University">Princeton University</a></li>
<li><a rel="nofollow" class="external text" href="http://einstein-virtuell.mpiwg-berlin.mpg.de/VEA/SC516287227_MOD-1744214250_SEQ1202484_SL861364620_en.html">16 May 1953 letter to William Frauenglass</a> (see resultant <a rel="nofollow" class="external text" href="https://www.nytimes.com/1953/06/12/archives/-refuse-to-testify-einstein-advises-intellectuals-called-in-by.html">NYT on academic freedom / McCarthyism</a>)</li>
<li><a rel="nofollow" class="external text" href="http://purl.org/pressemappe20/folder/pe/004590">Newspaper clippings about Albert Einstein</a> in the <a href="/wiki/20th_Century_Press_Archives" title="20th Century Press Archives">20th Century Press Archives</a> of the <a href="/wiki/German_National_Library_of_Economics" title="German National Library of Economics">ZBW</a></li>
<li><a rel="nofollow" class="external text" href="https://nobel.bh.org.il/en/persona/einstein-albert/">Albert Einstein</a>, Nobel Luminaries&#160;&#8211;&#32; Jewish Nobel Prize Winners, on the <a rel="nofollow" class="external text" href="https://www.bh.org.il/">Beit Hatfutsot-The Museum of the Jewish People</a> Website.</li>
<li><a rel="nofollow" class="external text" href="https://io9.com/5954119/einsteins-i-dont-believe-in-god-letter-has-sold-on-ebay--and-youre-not-going-to-believe-the-price">"Einstein\'s "I don\'t believe in God" letter has sold on eBay..."</a>, 23 October 2012</li>
<li>Albert Einstein\'s "God Letter" fetches US$2,400,000 at Christie\'s New York auction house on 4 December 2018 <a rel="nofollow" class="external text" href="https://www.abc.net.au/news/2018-12-05/einstein-god-letter-fetches-3.9-million-at-new-york-auction/10584228">Einstein\'s \'God Letter\' fetches $3.9 million at New York auction</a></li></ul>
<div role="navigation" class="navbox" aria-labelledby="Albert_Einstein" style="padding:3px"><table class="nowraplinks mw-collapsible expanded navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><style data-mw-deduplicate="TemplateStyles:r992953826">.mw-parser-output .navbar{display:inline;font-size:88%;font-weight:normal}.mw-parser-output .navbar-collapse{float:left;text-align:left}.mw-parser-output .navbar-boxtext{word-spacing:0}.mw-parser-output .navbar ul{display:inline-block;white-space:nowrap;line-height:inherit}.mw-parser-output .navbar-brackets::before{margin-right:-0.125em;content:"[ "}.mw-parser-output .navbar-brackets::after{margin-left:-0.125em;content:" ]"}.mw-parser-output .navbar li{word-spacing:-0.125em}.mw-parser-output .navbar-mini abbr{font-variant:small-caps;border-bottom:none;text-decoration:none;cursor:inherit}.mw-parser-output .navbar-ct-full{font-size:114%;margin:0 7em}.mw-parser-output .navbar-ct-mini{font-size:114%;margin:0 4em}.mw-parser-output .infobox .navbar{font-size:100%}.mw-parser-output .navbox .navbar{display:block;font-size:100%}.mw-parser-output .navbox-title .navbar{float:left;text-align:left;margin-right:0.5em}</style><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:Albert_Einstein" title="Template:Albert Einstein"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:Albert_Einstein" title="Template talk:Albert Einstein"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:Albert_Einstein&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Albert_Einstein" style="font-size:114%;margin:0 4em"><a class="mw-selflink selflink">Albert Einstein</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">Physics</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Special_relativity" title="Special relativity">Special relativity</a></li>
<li><a href="/wiki/General_relativity" title="General relativity">General relativity</a></li>
<li><a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence">Mass–energy equivalence (E=mc<sup>2</sup>)</a></li>
<li><a href="/wiki/Brownian_motion" title="Brownian motion">Brownian motion</a></li>
<li><a href="/wiki/Photoelectric_effect" title="Photoelectric effect">Photoelectric effect</a></li>
<li><a href="/wiki/Einstein_coefficients" title="Einstein coefficients">Einstein coefficients</a></li>
<li><a href="/wiki/Einstein_solid" title="Einstein solid">Einstein solid</a></li>
<li><a href="/wiki/Equivalence_principle" title="Equivalence principle">Equivalence principle</a></li>
<li><a href="/wiki/Einstein_field_equations" title="Einstein field equations">Einstein field equations</a></li>
<li><a href="/wiki/Einstein_radius" title="Einstein radius">Einstein radius</a></li>
<li><a href="/wiki/Einstein_relation_(kinetic_theory)" title="Einstein relation (kinetic theory)">Einstein relation (kinetic theory)</a></li>
<li><a href="/wiki/Cosmological_constant" title="Cosmological constant">Cosmological constant</a></li>
<li><a href="/wiki/Bose%E2%80%93Einstein_condensate" title="Bose–Einstein condensate">Bose–Einstein condensate</a></li>
<li><a href="/wiki/Bose%E2%80%93Einstein_statistics" title="Bose–Einstein statistics">Bose–Einstein statistics</a></li>
<li><a href="/wiki/Bose%E2%80%93Einstein_correlations" title="Bose–Einstein correlations">Bose–Einstein correlations</a></li>
<li><a href="/wiki/Einstein%E2%80%93Cartan_theory" title="Einstein–Cartan theory">Einstein–Cartan theory</a></li>
<li><a href="/wiki/Einstein%E2%80%93Infeld%E2%80%93Hoffmann_equations" title="Einstein–Infeld–Hoffmann equations">Einstein–Infeld–Hoffmann equations</a></li>
<li><a href="/wiki/Einstein%E2%80%93de_Haas_effect" title="Einstein–de Haas effect">Einstein–de Haas effect</a></li>
<li><a href="/wiki/EPR_paradox" title="EPR paradox">EPR paradox</a></li>
<li><a href="/wiki/Bohr%E2%80%93Einstein_debates" title="Bohr–Einstein debates">Bohr–Einstein debates</a></li>
<li><a href="/wiki/Teleparallelism" title="Teleparallelism">Teleparallelism</a></li>
<li><a href="/wiki/Einstein%27s_thought_experiments" title="Einstein&#39;s thought experiments">Thought experiments</a></li>
<li><a href="/wiki/Einstein%27s_unsuccessful_investigations" title="Einstein&#39;s unsuccessful investigations">Unsuccessful investigations</a></li>
<li><a href="/wiki/Wave%E2%80%93particle_duality" title="Wave–particle duality">Wave–particle duality</a></li>
<li><a href="/wiki/Gravitational_wave" title="Gravitational wave">Gravitational wave</a></li>
<li><a href="/wiki/Tea_leaf_paradox" title="Tea leaf paradox">Tea leaf paradox</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/List_of_scientific_publications_by_Albert_Einstein" title="List of scientific publications by Albert Einstein">Works</a></th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Annus_Mirabilis_papers" title="Annus Mirabilis papers"><i>Annus Mirabilis</i> papers</a> (1905)</li>
<li>"<a href="/wiki/%C3%9Cber_die_von_der_molekularkinetischen_Theorie_der_W%C3%A4rme_geforderte_Bewegung_von_in_ruhenden_Fl%C3%BCssigkeiten_suspendierten_Teilchen" title="Über die von der molekularkinetischen Theorie der Wärme geforderte Bewegung von in ruhenden Flüssigkeiten suspendierten Teilchen">Investigations on the Theory of Brownian Movement</a>" (1905)</li>
<li><i><a href="/wiki/Relativity:_The_Special_and_the_General_Theory" title="Relativity: The Special and the General Theory">Relativity: The Special and the General Theory</a></i> (1916)</li>
<li><i><a href="/wiki/The_Meaning_of_Relativity" title="The Meaning of Relativity">The Meaning of Relativity</a></i> (1922)</li>
<li><i><a href="/wiki/The_World_as_I_See_It_(book)" title="The World as I See It (book)">The World as I See It</a></i> (1934)</li>
<li><i><a href="/wiki/The_Evolution_of_Physics" title="The Evolution of Physics">The Evolution of Physics</a></i> (1938)</li>
<li>"<a href="/wiki/Why_Socialism%3F" title="Why Socialism?">Why Socialism?</a>" (1949)</li>
<li><a href="/wiki/Russell%E2%80%93Einstein_Manifesto" title="Russell–Einstein Manifesto">Russell–Einstein Manifesto</a> (1955)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Einstein_family" title="Einstein family">Family</a></th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Pauline_Koch" class="mw-redirect" title="Pauline Koch">Pauline Koch</a> <small>(mother)</small></li>
<li><a href="/wiki/Hermann_Einstein" class="mw-redirect" title="Hermann Einstein">Hermann Einstein</a> <small>(father)</small></li>
<li><a href="/wiki/Maja_Einstein" class="mw-redirect" title="Maja Einstein">Maja Einstein</a> <small>(sister)</small></li>
<li><a href="/wiki/Mileva_Mari%C4%87" title="Mileva Marić">Mileva Marić</a> <small>(first wife)</small></li>
<li><a href="/wiki/Elsa_Einstein" title="Elsa Einstein">Elsa Einstein</a> <small>(second wife; cousin)</small></li>
<li><a href="/wiki/Lieserl_Einstein" class="mw-redirect" title="Lieserl Einstein">Lieserl Einstein</a> <small>(daughter)</small></li>
<li><a href="/wiki/Hans_Albert_Einstein" title="Hans Albert Einstein">Hans Albert Einstein</a> <small>(son)</small></li>
<li><a href="/wiki/Einstein_family#Eduard_&quot;Tete&quot;_Einstein_(Albert&#39;s_second_son)" title="Einstein family">Eduard Einstein</a> <small>(son)</small></li>
<li><a href="/wiki/Bernhard_Caesar_Einstein" title="Bernhard Caesar Einstein">Bernhard Caesar Einstein</a> <small>(grandson)</small></li>
<li><a href="/wiki/Evelyn_Einstein" title="Evelyn Einstein">Evelyn Einstein</a> <small>(granddaughter)</small></li>
<li><a href="/wiki/Thomas_Martin_Einstein" class="mw-redirect" title="Thomas Martin Einstein">Thomas Martin Einstein</a> <small>(great-grandson)</small></li>
<li><a href="/wiki/Murder_of_the_family_of_Robert_Einstein" title="Murder of the family of Robert Einstein">Robert Einstein</a> <small>(cousin)</small></li>
<li><a href="/wiki/Siegbert_Einstein" title="Siegbert Einstein">Siegbert Einstein</a> <small>(distant cousin)</small></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Albert_Einstein_in_popular_culture" title="Albert Einstein in popular culture">In popular<br />culture</a></th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><i><a href="/wiki/Die_Grundlagen_der_Einsteinschen_Relativit%C3%A4ts-Theorie" title="Die Grundlagen der Einsteinschen Relativitäts-Theorie">Die Grundlagen der Einsteinschen Relativitäts-Theorie</a></i> (1922 documentary)</li>
<li><i><a href="/wiki/The_Einstein_Theory_of_Relativity" title="The Einstein Theory of Relativity">The Einstein Theory of Relativity</a></i> (1923 documentary)</li>
<li><i><a href="/wiki/Relics:_Einstein%27s_Brain" title="Relics: Einstein&#39;s Brain">Relics: Einstein\'s Brain</a></i> (1994 documentary)</li>
<li><i><a href="/wiki/Insignificance_(film)" title="Insignificance (film)">Insignificance</a></i> (1985 film)</li>
<li><i><a href="/wiki/I.Q._(film)" title="I.Q. (film)">I.Q.</a></i> (1994 film)</li>
<li><i><a href="/wiki/Einstein%27s_Gift" title="Einstein&#39;s Gift">Einstein\'s Gift</a></i> (2003 play)</li>
<li><i><a href="/wiki/Einstein_and_Eddington" title="Einstein and Eddington">Einstein and Eddington</a></i> (2008 TV film)</li>
<li><i><a href="/wiki/Genius_(American_TV_series)" title="Genius (American TV series)">Genius</a></i> (2017 series)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Related</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Einstein%27s_awards_and_honors" title="Einstein&#39;s awards and honors">Awards and honors</a></li>
<li><a href="/wiki/Albert_Einstein%27s_brain" title="Albert Einstein&#39;s brain">Brain</a></li>
<li><a href="/wiki/Albert_Einstein_House" title="Albert Einstein House">House</a></li>
<li><a href="/wiki/Albert_Einstein_Memorial" title="Albert Einstein Memorial">Memorial</a></li>
<li><a href="/wiki/Political_views_of_Albert_Einstein" title="Political views of Albert Einstein">Political views</a></li>
<li><a href="/wiki/Religious_and_philosophical_views_of_Albert_Einstein" title="Religious and philosophical views of Albert Einstein">Religious views</a></li>
<li><a href="/wiki/List_of_things_named_after_Albert_Einstein" title="List of things named after Albert Einstein">List of things named after Albert Einstein</a></li>
<li><a href="/wiki/Albert_Einstein_Archives" title="Albert Einstein Archives">Albert Einstein Archives</a></li>
<li><a href="/wiki/Einstein_Papers_Project" title="Einstein Papers Project">Einstein Papers Project</a></li>
<li><a href="/wiki/Einstein_refrigerator" title="Einstein refrigerator">Einstein refrigerator</a></li>
<li><a href="/wiki/Einsteinhaus" title="Einsteinhaus">Einsteinhaus</a></li>
<li><a href="/wiki/Einsteinium" title="Einsteinium">Einsteinium</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Prizes</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Albert_Einstein_Award" title="Albert Einstein Award">Albert Einstein Award</a></li>
<li><a href="/wiki/Albert_Einstein_Medal" title="Albert Einstein Medal">Albert Einstein Medal</a></li>
<li><a href="/wiki/UNESCO_Albert_Einstein_medal" title="UNESCO Albert Einstein medal">UNESCO Albert Einstein medal</a></li>
<li><a href="/wiki/Albert_Einstein_Peace_Prize" title="Albert Einstein Peace Prize">Albert Einstein Peace Prize</a></li>
<li><a href="/wiki/Albert_Einstein_World_Award_of_Science" title="Albert Einstein World Award of Science">Albert Einstein World Award of Science</a></li>
<li><a href="/wiki/Einstein_Prize_for_Laser_Science" title="Einstein Prize for Laser Science">Einstein Prize for Laser Science</a></li>
<li><a href="/wiki/Einstein_Prize_(APS)" title="Einstein Prize (APS)">Einstein Prize (APS)</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Books about<br />Einstein</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><i><a href="/wiki/Albert_Einstein:_Creator_and_Rebel" title="Albert Einstein: Creator and Rebel">Albert Einstein: Creator and Rebel</a></i></li>
<li><i><a href="/wiki/Einstein_and_Religion" title="Einstein and Religion">Einstein and Religion</a></i></li>
<li><i><a href="/wiki/Einstein_for_Beginners" title="Einstein for Beginners">Einstein for Beginners</a></i></li>
<li><i><a href="/wiki/Einstein:_His_Life_and_Universe" title="Einstein: His Life and Universe">Einstein: His Life and Universe</a></i></li>
<li><i><a href="/wiki/Einstein%27s_Cosmos" title="Einstein&#39;s Cosmos">Einstein\'s Cosmos</a></i></li>
<li><i><a href="/wiki/I_Am_Albert_Einstein" title="I Am Albert Einstein">I Am Albert Einstein</a></i></li>
<li><i><a href="/wiki/Introducing_Relativity" title="Introducing Relativity">Introducing Relativity</a></i></li>
<li><i><a href="/wiki/Subtle_is_the_Lord" title="Subtle is the Lord">Subtle is the Lord</a></i></li></ul>
</div></td></tr><tr><td class="navbox-abovebelow hlist" colspan="2"><div>
<ul><li><img alt="Wikipedia book" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/16px-Symbol_book_class2.svg.png" decoding="async" title="Wikipedia book" width="16" height="16" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/23px-Symbol_book_class2.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/89/Symbol_book_class2.svg/31px-Symbol_book_class2.svg.png 2x" data-file-width="180" data-file-height="185" /> <a href="/wiki/Book:Albert_Einstein" title="Book:Albert Einstein">Book</a></li>
<li><img alt="Category" src="//upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/16px-Symbol_category_class.svg.png" decoding="async" title="Category" width="16" height="16" srcset="//upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/23px-Symbol_category_class.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/9/96/Symbol_category_class.svg/31px-Symbol_category_class.svg.png 2x" data-file-width="180" data-file-height="185" /> <a href="/wiki/Category:Albert_Einstein" title="Category:Albert Einstein">Category</a></li></ul>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="Copley_Medallists_(1901–1950)" style="padding:3px"><table class="nowraplinks hlist mw-collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:Copley_Medallists_1901%E2%80%931950" title="Template:Copley Medallists 1901–1950"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:Copley_Medallists_1901%E2%80%931950" title="Template talk:Copley Medallists 1901–1950"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:Copley_Medallists_1901%E2%80%931950&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Copley_Medallists_(1901–1950)" style="font-size:114%;margin:0 4em"><a href="/wiki/Copley_Medal" title="Copley Medal">Copley Medallists</a> (1901–1950)</div></th></tr><tr><td colspan="2" class="navbox-list navbox-odd" style="width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap"><a href="/wiki/Josiah_Willard_Gibbs" title="Josiah Willard Gibbs">Josiah Willard Gibbs</a> (1901)</span></li>
<li><span class="nowrap"><a href="/wiki/Joseph_Lister" title="Joseph Lister">Joseph Lister</a> (1902)</span></li>
<li><span class="nowrap"><a href="/wiki/Eduard_Suess" title="Eduard Suess">Eduard Suess</a> (1903)</span></li>
<li><span class="nowrap"><a href="/wiki/William_Crookes" title="William Crookes">William Crookes</a> (1904)</span></li>
<li><span class="nowrap"><a href="/wiki/Dmitri_Mendeleev" title="Dmitri Mendeleev">Dmitri Mendeleev</a> (1905)</span></li>
<li><span class="nowrap"><a href="/wiki/%C3%89lie_Metchnikoff" title="Élie Metchnikoff">Élie Metchnikoff</a> (1906)</span></li>
<li><span class="nowrap"><a href="/wiki/Albert_A._Michelson" title="Albert A. Michelson">Albert A. Michelson</a> (1907)</span></li>
<li><span class="nowrap"><a href="/wiki/Alfred_Russel_Wallace" title="Alfred Russel Wallace">Alfred Russel Wallace</a> (1908)</span></li>
<li><span class="nowrap"><a href="/wiki/George_William_Hill" title="George William Hill">George William Hill</a> (1909)</span></li>
<li><span class="nowrap"><a href="/wiki/Francis_Galton" title="Francis Galton">Francis Galton</a> (1910)</span></li>
<li><span class="nowrap"><a href="/wiki/George_Darwin" title="George Darwin">George Darwin</a> (1911)</span></li>
<li><span class="nowrap"><a href="/wiki/Felix_Klein" title="Felix Klein">Felix Klein</a> (1912)</span></li>
<li><span class="nowrap"><a href="/wiki/Ray_Lankester" title="Ray Lankester">Ray Lankester</a> (1913)</span></li>
<li><span class="nowrap"><a href="/wiki/J._J._Thomson" title="J. J. Thomson">J. J. Thomson</a> (1914)</span></li>
<li><span class="nowrap"><a href="/wiki/Ivan_Pavlov" title="Ivan Pavlov">Ivan Pavlov</a> (1915)</span></li>
<li><span class="nowrap"><a href="/wiki/James_Dewar" title="James Dewar">James Dewar</a> (1916)</span></li>
<li><span class="nowrap"><a href="/wiki/Pierre_Paul_%C3%89mile_Roux" title="Pierre Paul Émile Roux">Pierre Paul Émile Roux</a> (1917)</span></li>
<li><span class="nowrap"><a href="/wiki/Hendrik_Lorentz" title="Hendrik Lorentz">Hendrik Lorentz</a> (1918)</span></li>
<li><span class="nowrap"><a href="/wiki/William_Bayliss" title="William Bayliss">William Bayliss</a> (1919)</span></li>
<li><span class="nowrap"><a href="/wiki/Horace_Tabberer_Brown" title="Horace Tabberer Brown">Horace Tabberer Brown</a> (1920)</span></li>
<li><span class="nowrap"><a href="/wiki/Joseph_Larmor" title="Joseph Larmor">Joseph Larmor</a> (1921)</span></li>
<li><span class="nowrap"><a href="/wiki/Ernest_Rutherford" title="Ernest Rutherford">Ernest Rutherford</a> (1922)</span></li>
<li><span class="nowrap"><a href="/wiki/Horace_Lamb" title="Horace Lamb">Horace Lamb</a> (1923)</span></li>
<li><span class="nowrap"><a href="/wiki/Edward_Albert_Sharpey-Schafer" title="Edward Albert Sharpey-Schafer">Edward Albert Sharpey-Schafer</a> (1924)</span></li>
<li><span class="nowrap"><a class="mw-selflink selflink">Albert Einstein</a> (1925)</span></li>
<li><span class="nowrap"><a href="/wiki/Frederick_Gowland_Hopkins" title="Frederick Gowland Hopkins">Frederick Gowland Hopkins</a> (1926)</span></li>
<li><span class="nowrap"><a href="/wiki/Charles_Scott_Sherrington" title="Charles Scott Sherrington">Charles Scott Sherrington</a> (1927)</span></li>
<li><span class="nowrap"><a href="/wiki/Charles_Algernon_Parsons" title="Charles Algernon Parsons">Charles Algernon Parsons</a> (1928)</span></li>
<li><span class="nowrap"><a href="/wiki/Max_Planck" title="Max Planck">Max Planck</a> (1929)</span></li>
<li><span class="nowrap"><a href="/wiki/William_Henry_Bragg" title="William Henry Bragg">William Henry Bragg</a> (1930)</span></li>
<li><span class="nowrap"><a href="/wiki/Arthur_Schuster" title="Arthur Schuster">Arthur Schuster</a> (1931)</span></li>
<li><span class="nowrap"><a href="/wiki/George_Ellery_Hale" title="George Ellery Hale">George Ellery Hale</a> (1932)</span></li>
<li><span class="nowrap"><a href="/wiki/Theobald_Smith" title="Theobald Smith">Theobald Smith</a> (1933)</span></li>
<li><span class="nowrap"><a href="/wiki/John_Scott_Haldane" title="John Scott Haldane">John Scott Haldane</a> (1934)</span></li>
<li><span class="nowrap"><a href="/wiki/Charles_Thomson_Rees_Wilson" title="Charles Thomson Rees Wilson">Charles Thomson Rees Wilson</a> (1935)</span></li>
<li><span class="nowrap"><a href="/wiki/Arthur_Evans" title="Arthur Evans">Arthur Evans</a> (1936)</span></li>
<li><span class="nowrap"><a href="/wiki/Henry_Hallett_Dale" title="Henry Hallett Dale">Henry Hallett Dale</a> (1937)</span></li>
<li><span class="nowrap"><a href="/wiki/Niels_Bohr" title="Niels Bohr">Niels Bohr</a> (1938)</span></li>
<li><span class="nowrap"><a href="/wiki/Thomas_Hunt_Morgan" title="Thomas Hunt Morgan">Thomas Hunt Morgan</a> (1939)</span></li>
<li><span class="nowrap"><a href="/wiki/Paul_Langevin" title="Paul Langevin">Paul Langevin</a> (1940)</span></li>
<li><span class="nowrap"><a href="/wiki/Thomas_Lewis_(cardiologist)" title="Thomas Lewis (cardiologist)">Thomas Lewis</a> (1941)</span></li>
<li><span class="nowrap"><a href="/wiki/Robert_Robinson_(chemist)" title="Robert Robinson (chemist)">Robert Robinson</a> (1942)</span></li>
<li><span class="nowrap"><a href="/wiki/Joseph_Barcroft" title="Joseph Barcroft">Joseph Barcroft</a> (1943)</span></li>
<li><span class="nowrap"><a href="/wiki/G._I._Taylor" title="G. I. Taylor">Geoffrey Ingram Taylor</a> (1944)</span></li>
<li><span class="nowrap"><a href="/wiki/Oswald_Avery" title="Oswald Avery">Oswald Avery</a> (1945)</span></li>
<li><span class="nowrap"><a href="/wiki/Edgar_Adrian" title="Edgar Adrian">Edgar Douglas Adrian</a> (1946)</span></li>
<li><span class="nowrap"><a href="/wiki/G._H._Hardy" title="G. H. Hardy">G. H. Hardy</a> (1947)</span></li>
<li><span class="nowrap"><a href="/wiki/Archibald_Hill" title="Archibald Hill">Archibald Hill</a> (1948)</span></li>
<li><span class="nowrap"><a href="/wiki/George_de_Hevesy" title="George de Hevesy">George de Hevesy</a> (1949)</span></li>
<li><span class="nowrap"><a href="/wiki/James_Chadwick" title="James Chadwick">James Chadwick</a> (1950)</span></li></ul>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="Laureates_of_the_Nobel_Prize_in_Physics" style="padding:3px"><table class="nowraplinks hlist mw-collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:Nobel_Prize_in_Physics" title="Template:Nobel Prize in Physics"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:Nobel_Prize_in_Physics" title="Template talk:Nobel Prize in Physics"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:Nobel_Prize_in_Physics&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Laureates_of_the_Nobel_Prize_in_Physics" style="font-size:114%;margin:0 4em"><a href="/wiki/List_of_Nobel_laureates_in_Physics" title="List of Nobel laureates in Physics">Laureates</a> of the <a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Nobel Prize in Physics</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">1901–1925</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap">1901: <a href="/wiki/Wilhelm_R%C3%B6ntgen" title="Wilhelm Röntgen">Röntgen</a></span></li>
<li><span class="nowrap">1902: <a href="/wiki/Hendrik_Lorentz" title="Hendrik Lorentz">Lorentz</a> / <a href="/wiki/Pieter_Zeeman" title="Pieter Zeeman">Zeeman</a></span></li>
<li><span class="nowrap">1903: <a href="/wiki/Henri_Becquerel" title="Henri Becquerel">Becquerel</a> / <a href="/wiki/Pierre_Curie" title="Pierre Curie">P. Curie</a> / <a href="/wiki/Marie_Curie" title="Marie Curie">M. Curie</a></span></li>
<li><span class="nowrap">1904: <a href="/wiki/John_William_Strutt,_3rd_Baron_Rayleigh" title="John William Strutt, 3rd Baron Rayleigh">Rayleigh</a></span></li>
<li><span class="nowrap">1905: <a href="/wiki/Philipp_Lenard" title="Philipp Lenard">Lenard</a></span></li>
<li><span class="nowrap">1906: <a href="/wiki/J._J._Thomson" title="J. J. Thomson">J. J. Thomson</a></span></li>
<li><span class="nowrap">1907: <a href="/wiki/Albert_A._Michelson" title="Albert A. Michelson">Michelson</a></span></li>
<li><span class="nowrap">1908: <a href="/wiki/Gabriel_Lippmann" title="Gabriel Lippmann">Lippmann</a></span></li>
<li><span class="nowrap">1909: <a href="/wiki/Guglielmo_Marconi" title="Guglielmo Marconi">Marconi</a> / <a href="/wiki/Karl_Ferdinand_Braun" title="Karl Ferdinand Braun">Braun</a></span></li>
<li><span class="nowrap">1910: <a href="/wiki/Johannes_Diderik_van_der_Waals" title="Johannes Diderik van der Waals">Van der Waals</a></span></li>
<li><span class="nowrap">1911: <a href="/wiki/Wilhelm_Wien" title="Wilhelm Wien">Wien</a></span></li>
<li><span class="nowrap">1912: <a href="/wiki/Gustaf_Dal%C3%A9n" title="Gustaf Dalén">Dalén</a></span></li>
<li><span class="nowrap">1913: <a href="/wiki/Heike_Kamerlingh_Onnes" title="Heike Kamerlingh Onnes">Kamerlingh Onnes</a></span></li>
<li><span class="nowrap">1914: <a href="/wiki/Max_von_Laue" title="Max von Laue">Laue</a></span></li>
<li><span class="nowrap">1915: <a href="/wiki/Lawrence_Bragg" title="Lawrence Bragg">W. L. Bragg</a> / <a href="/wiki/William_Henry_Bragg" title="William Henry Bragg">W. H. Bragg</a></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1916</span></span></li>
<li><span class="nowrap">1917: <a href="/wiki/Charles_Glover_Barkla" title="Charles Glover Barkla">Barkla</a></span></li>
<li><span class="nowrap">1918: <a href="/wiki/Max_Planck" title="Max Planck">Planck</a></span></li>
<li><span class="nowrap">1919: <a href="/wiki/Johannes_Stark" title="Johannes Stark">Stark</a></span></li>
<li><span class="nowrap">1920: <a href="/wiki/Charles_%C3%89douard_Guillaume" title="Charles Édouard Guillaume">Guillaume</a></span></li>
<li><span class="nowrap">1921: <a class="mw-selflink selflink">Einstein</a></span></li>
<li><span class="nowrap">1922: <a href="/wiki/Niels_Bohr" title="Niels Bohr">N. Bohr</a></span></li>
<li><span class="nowrap">1923: <a href="/wiki/Robert_Andrews_Millikan" title="Robert Andrews Millikan">Millikan</a></span></li>
<li><span class="nowrap">1924: <a href="/wiki/Manne_Siegbahn" title="Manne Siegbahn">M. Siegbahn</a></span></li>
<li><span class="nowrap">1925: <a href="/wiki/James_Franck" title="James Franck">Franck</a> / <a href="/wiki/Gustav_Ludwig_Hertz" title="Gustav Ludwig Hertz">Hertz</a></span></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">1926–1950</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap">1926: <a href="/wiki/Jean_Baptiste_Perrin" title="Jean Baptiste Perrin">Perrin</a></span></li>
<li><span class="nowrap">1927: <a href="/wiki/Arthur_Compton" title="Arthur Compton">Compton</a> / <a href="/wiki/Charles_Thomson_Rees_Wilson" title="Charles Thomson Rees Wilson">C. Wilson</a></span></li>
<li><span class="nowrap">1928: <a href="/wiki/Owen_Willans_Richardson" title="Owen Willans Richardson">O. Richardson</a></span></li>
<li><span class="nowrap">1929: <a href="/wiki/Louis_de_Broglie" title="Louis de Broglie">De Broglie</a></span></li>
<li><span class="nowrap">1930: <a href="/wiki/C._V._Raman" title="C. V. Raman">Raman</a></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1931</span></span></li>
<li><span class="nowrap">1932: <a href="/wiki/Werner_Heisenberg" title="Werner Heisenberg">Heisenberg</a></span></li>
<li><span class="nowrap">1933: <a href="/wiki/Erwin_Schr%C3%B6dinger" title="Erwin Schrödinger">Schrödinger</a> / <a href="/wiki/Paul_Dirac" title="Paul Dirac">Dirac</a></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1934</span></span></li>
<li><span class="nowrap">1935: <a href="/wiki/James_Chadwick" title="James Chadwick">Chadwick</a></span></li>
<li><span class="nowrap">1936: <a href="/wiki/Victor_Francis_Hess" title="Victor Francis Hess">Hess</a> / <a href="/wiki/Carl_David_Anderson" title="Carl David Anderson">C. D. Anderson</a></span></li>
<li><span class="nowrap">1937: <a href="/wiki/Clinton_Davisson" title="Clinton Davisson">Davisson</a> / <a href="/wiki/George_Paget_Thomson" title="George Paget Thomson">G. P. Thomson</a></span></li>
<li><span class="nowrap">1938: <a href="/wiki/Enrico_Fermi" title="Enrico Fermi">Fermi</a></span></li>
<li><span class="nowrap">1939: <a href="/wiki/Ernest_Lawrence" title="Ernest Lawrence">Lawrence</a></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1940</span></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1941</span></span></li>
<li><span class="nowrap"><span style="color:darkgrey">1942</span></span></li>
<li><span class="nowrap">1943: <a href="/wiki/Otto_Stern" title="Otto Stern">Stern</a></span></li>
<li><span class="nowrap">1944: <a href="/wiki/Isidor_Isaac_Rabi" title="Isidor Isaac Rabi">Rabi</a></span></li>
<li><span class="nowrap">1945: <a href="/wiki/Wolfgang_Pauli" title="Wolfgang Pauli">Pauli</a></span></li>
<li><span class="nowrap">1946: <a href="/wiki/Percy_Williams_Bridgman" title="Percy Williams Bridgman">Bridgman</a></span></li>
<li><span class="nowrap">1947: <a href="/wiki/Edward_Victor_Appleton" title="Edward Victor Appleton">Appleton</a></span></li>
<li><span class="nowrap">1948: <a href="/wiki/Patrick_Blackett" title="Patrick Blackett">Blackett</a></span></li>
<li><span class="nowrap">1949: <a href="/wiki/Hideki_Yukawa" title="Hideki Yukawa">Yukawa</a></span></li>
<li><span class="nowrap">1950: <a href="/wiki/C._F._Powell" title="C. F. Powell">Powell</a></span></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">1951–1975</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap">1951: <a href="/wiki/John_Cockcroft" title="John Cockcroft">Cockcroft</a> / <a href="/wiki/Ernest_Walton" title="Ernest Walton">Walton</a></span></li>
<li><span class="nowrap">1952: <a href="/wiki/Felix_Bloch" title="Felix Bloch">Bloch</a> / <a href="/wiki/Edward_Mills_Purcell" title="Edward Mills Purcell">Purcell</a></span></li>
<li><span class="nowrap">1953: <a href="/wiki/Frits_Zernike" title="Frits Zernike">Zernike</a></span></li>
<li><span class="nowrap">1954: <a href="/wiki/Max_Born" title="Max Born">Born</a> / <a href="/wiki/Walther_Bothe" title="Walther Bothe">Bothe</a></span></li>
<li><span class="nowrap">1955: <a href="/wiki/Willis_Lamb" title="Willis Lamb">Lamb</a> / <a href="/wiki/Polykarp_Kusch" title="Polykarp Kusch">Kusch</a></span></li>
<li><span class="nowrap">1956: <a href="/wiki/William_Shockley" title="William Shockley">Shockley</a> / <a href="/wiki/John_Bardeen" title="John Bardeen">Bardeen</a> / <a href="/wiki/Walter_Houser_Brattain" title="Walter Houser Brattain">Brattain</a></span></li>
<li><span class="nowrap">1957: <a href="/wiki/Yang_Chen-Ning" title="Yang Chen-Ning">C. N. Yang</a> / <a href="/wiki/Tsung-Dao_Lee" title="Tsung-Dao Lee">T. D. Lee</a></span></li>
<li><span class="nowrap">1958: <a href="/wiki/Pavel_Cherenkov" title="Pavel Cherenkov">Cherenkov</a> / <a href="/wiki/Ilya_Frank" title="Ilya Frank">Frank</a> / <a href="/wiki/Igor_Tamm" title="Igor Tamm">Tamm</a></span></li>
<li><span class="nowrap">1959: <a href="/wiki/Emilio_Segr%C3%A8" title="Emilio Segrè">Segrè</a> / <a href="/wiki/Owen_Chamberlain" title="Owen Chamberlain">Chamberlain</a></span></li>
<li><span class="nowrap">1960: <a href="/wiki/Donald_A._Glaser" title="Donald A. Glaser">Glaser</a></span></li>
<li><span class="nowrap">1961: <a href="/wiki/Robert_Hofstadter" title="Robert Hofstadter">Hofstadter</a> / <a href="/wiki/Rudolf_M%C3%B6ssbauer" title="Rudolf Mössbauer">Mössbauer</a></span></li>
<li><span class="nowrap">1962: <a href="/wiki/Lev_Landau" title="Lev Landau">Landau</a></span></li>
<li><span class="nowrap">1963: <a href="/wiki/Eugene_Wigner" title="Eugene Wigner">Wigner</a> / <a href="/wiki/Maria_Goeppert_Mayer" title="Maria Goeppert Mayer">Goeppert Mayer</a> / <a href="/wiki/J._Hans_D._Jensen" title="J. Hans D. Jensen">Jensen</a></span></li>
<li><span class="nowrap">1964: <a href="/wiki/Charles_H._Townes" title="Charles H. Townes">Townes</a> / <a href="/wiki/Nikolay_Basov" title="Nikolay Basov">Basov</a> / <a href="/wiki/Alexander_Prokhorov" title="Alexander Prokhorov">Prokhorov</a></span></li>
<li><span class="nowrap">1965: <a href="/wiki/Shin%27ichir%C5%8D_Tomonaga" title="Shin&#39;ichirō Tomonaga">Tomonaga</a> / <a href="/wiki/Julian_Schwinger" title="Julian Schwinger">Schwinger</a> / <a href="/wiki/Richard_Feynman" title="Richard Feynman">Feynman</a></span></li>
<li><span class="nowrap">1966: <a href="/wiki/Alfred_Kastler" title="Alfred Kastler">Kastler</a></span></li>
<li><span class="nowrap">1967: <a href="/wiki/Hans_Bethe" title="Hans Bethe">Bethe</a></span></li>
<li><span class="nowrap">1968: <a href="/wiki/Luis_Walter_Alvarez" title="Luis Walter Alvarez">Alvarez</a></span></li>
<li><span class="nowrap">1969: <a href="/wiki/Murray_Gell-Mann" title="Murray Gell-Mann">Gell-Mann</a></span></li>
<li><span class="nowrap">1970: <a href="/wiki/Hannes_Alfv%C3%A9n" title="Hannes Alfvén">Alfvén</a> / <a href="/wiki/Louis_N%C3%A9el" title="Louis Néel">Néel</a></span></li>
<li><span class="nowrap">1971: <a href="/wiki/Dennis_Gabor" title="Dennis Gabor">Gabor</a></span></li>
<li><span class="nowrap">1972: <a href="/wiki/John_Bardeen" title="John Bardeen">Bardeen</a> / <a href="/wiki/Leon_Cooper" title="Leon Cooper">Cooper</a> / <a href="/wiki/John_Robert_Schrieffer" title="John Robert Schrieffer">Schrieffer</a></span></li>
<li><span class="nowrap">1973: <a href="/wiki/Leo_Esaki" title="Leo Esaki">Esaki</a> / <a href="/wiki/Ivar_Giaever" title="Ivar Giaever">Giaever</a> / <a href="/wiki/Brian_Josephson" title="Brian Josephson">Josephson</a></span></li>
<li><span class="nowrap">1974: <a href="/wiki/Martin_Ryle" title="Martin Ryle">Ryle</a> / <a href="/wiki/Antony_Hewish" title="Antony Hewish">Hewish</a></span></li>
<li><span class="nowrap">1975: <a href="/wiki/Aage_Bohr" title="Aage Bohr">A. Bohr</a> / <a href="/wiki/Ben_Roy_Mottelson" title="Ben Roy Mottelson">Mottelson</a> / <a href="/wiki/James_Rainwater" title="James Rainwater">Rainwater</a></span></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">1976–2000</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap">1976: <a href="/wiki/Burton_Richter" title="Burton Richter">Richter</a> / <a href="/wiki/Samuel_C._C._Ting" title="Samuel C. C. Ting">Ting</a></span></li>
<li><span class="nowrap">1977: <a href="/wiki/Philip_W._Anderson" title="Philip W. Anderson">P. W. Anderson</a> / <a href="/wiki/Nevill_Francis_Mott" title="Nevill Francis Mott">Mott</a> / <a href="/wiki/John_Hasbrouck_Van_Vleck" title="John Hasbrouck Van Vleck">Van Vleck</a></span></li>
<li><span class="nowrap">1978: <a href="/wiki/Pyotr_Kapitsa" title="Pyotr Kapitsa">Kapitsa</a> / <a href="/wiki/Arno_Allan_Penzias" title="Arno Allan Penzias">Penzias</a> / <a href="/wiki/Robert_Woodrow_Wilson" title="Robert Woodrow Wilson">R. Wilson</a></span></li>
<li><span class="nowrap">1979: <a href="/wiki/Sheldon_Lee_Glashow" title="Sheldon Lee Glashow">Glashow</a> / <a href="/wiki/Abdus_Salam" title="Abdus Salam">Salam</a> / <a href="/wiki/Steven_Weinberg" title="Steven Weinberg">Weinberg</a></span></li>
<li><span class="nowrap">1980: <a href="/wiki/James_Cronin" title="James Cronin">Cronin</a> / <a href="/wiki/Val_Logsdon_Fitch" title="Val Logsdon Fitch">Fitch</a></span></li>
<li><span class="nowrap">1981: <a href="/wiki/Nicolaas_Bloembergen" title="Nicolaas Bloembergen">Bloembergen</a> / <a href="/wiki/Arthur_Leonard_Schawlow" title="Arthur Leonard Schawlow">Schawlow</a> / <a href="/wiki/Kai_Siegbahn" title="Kai Siegbahn">K. Siegbahn</a></span></li>
<li><span class="nowrap">1982: <a href="/wiki/Kenneth_G._Wilson" title="Kenneth G. Wilson">K. Wilson</a></span></li>
<li><span class="nowrap">1983: <a href="/wiki/Subrahmanyan_Chandrasekhar" title="Subrahmanyan Chandrasekhar">Chandrasekhar</a> / <a href="/wiki/William_Alfred_Fowler" title="William Alfred Fowler">Fowler</a></span></li>
<li><span class="nowrap">1984: <a href="/wiki/Carlo_Rubbia" title="Carlo Rubbia">Rubbia</a> / <a href="/wiki/Simon_van_der_Meer" title="Simon van der Meer">Van der Meer</a></span></li>
<li><span class="nowrap">1985: <a href="/wiki/Klaus_von_Klitzing" title="Klaus von Klitzing">von Klitzing</a></span></li>
<li><span class="nowrap">1986: <a href="/wiki/Ernst_Ruska" title="Ernst Ruska">Ruska</a> / <a href="/wiki/Gerd_Binnig" title="Gerd Binnig">Binnig</a> / <a href="/wiki/Heinrich_Rohrer" title="Heinrich Rohrer">Rohrer</a></span></li>
<li><span class="nowrap">1987: <a href="/wiki/Georg_Bednorz" title="Georg Bednorz">Bednorz</a> / <a href="/wiki/K._Alex_M%C3%BCller" title="K. Alex Müller">Müller</a></span></li>
<li><span class="nowrap">1988: <a href="/wiki/Leon_M._Lederman" title="Leon M. Lederman">Lederman</a> / <a href="/wiki/Melvin_Schwartz" title="Melvin Schwartz">Schwartz</a> / <a href="/wiki/Jack_Steinberger" title="Jack Steinberger">Steinberger</a></span></li>
<li><span class="nowrap">1989: <a href="/wiki/Norman_Foster_Ramsey_Jr." title="Norman Foster Ramsey Jr.">Ramsey</a> / <a href="/wiki/Hans_Georg_Dehmelt" title="Hans Georg Dehmelt">Dehmelt</a> / <a href="/wiki/Wolfgang_Paul" title="Wolfgang Paul">Paul</a></span></li>
<li><span class="nowrap">1990: <a href="/wiki/Jerome_Isaac_Friedman" title="Jerome Isaac Friedman">Friedman</a> / <a href="/wiki/Henry_Way_Kendall" title="Henry Way Kendall">Kendall</a> / <a href="/wiki/Richard_E._Taylor" title="Richard E. Taylor">R. Taylor</a></span></li>
<li><span class="nowrap">1991: <a href="/wiki/Pierre-Gilles_de_Gennes" title="Pierre-Gilles de Gennes">de Gennes</a></span></li>
<li><span class="nowrap">1992: <a href="/wiki/Georges_Charpak" title="Georges Charpak">Charpak</a></span></li>
<li><span class="nowrap">1993: <a href="/wiki/Russell_Alan_Hulse" title="Russell Alan Hulse">Hulse</a> / <a href="/wiki/Joseph_Hooton_Taylor_Jr." title="Joseph Hooton Taylor Jr.">J. Taylor</a></span></li>
<li><span class="nowrap">1994: <a href="/wiki/Bertram_Brockhouse" title="Bertram Brockhouse">Brockhouse</a> / <a href="/wiki/Clifford_Shull" title="Clifford Shull">Shull</a></span></li>
<li><span class="nowrap">1995: <a href="/wiki/Martin_Lewis_Perl" title="Martin Lewis Perl">Perl</a> / <a href="/wiki/Frederick_Reines" title="Frederick Reines">Reines</a></span></li>
<li><span class="nowrap">1996: <a href="/wiki/David_Lee_(physicist)" title="David Lee (physicist)">D. Lee</a> / <a href="/wiki/Douglas_Osheroff" title="Douglas Osheroff">Osheroff</a> / <a href="/wiki/Robert_Coleman_Richardson" title="Robert Coleman Richardson">R. Richardson</a></span></li>
<li><span class="nowrap">1997: <a href="/wiki/Steven_Chu" title="Steven Chu">Chu</a> / <a href="/wiki/Claude_Cohen-Tannoudji" title="Claude Cohen-Tannoudji">Cohen-Tannoudji</a> / <a href="/wiki/William_Daniel_Phillips" title="William Daniel Phillips">Phillips</a></span></li>
<li><span class="nowrap">1998: <a href="/wiki/Robert_B._Laughlin" title="Robert B. Laughlin">Laughlin</a> / <a href="/wiki/Horst_Ludwig_St%C3%B6rmer" title="Horst Ludwig Störmer">Störmer</a> / <a href="/wiki/Daniel_C._Tsui" title="Daniel C. Tsui">Tsui</a></span></li>
<li><span class="nowrap">1999: <a href="/wiki/Gerard_%27t_Hooft" title="Gerard &#39;t Hooft">\'t Hooft</a> / <a href="/wiki/Martinus_J._G._Veltman" title="Martinus J. G. Veltman">Veltman</a></span></li>
<li><span class="nowrap">2000: <a href="/wiki/Zhores_Alferov" title="Zhores Alferov">Alferov</a> / <a href="/wiki/Herbert_Kroemer" title="Herbert Kroemer">Kroemer</a> / <a href="/wiki/Jack_Kilby" title="Jack Kilby">Kilby</a></span></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">2001–<br />present</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap">2001: <a href="/wiki/Eric_Allin_Cornell" title="Eric Allin Cornell">Cornell</a> / <a href="/wiki/Wolfgang_Ketterle" title="Wolfgang Ketterle">Ketterle</a> / <a href="/wiki/Carl_Wieman" title="Carl Wieman">Wieman</a></span></li>
<li><span class="nowrap">2002: <a href="/wiki/Raymond_Davis_Jr." title="Raymond Davis Jr.">Davis</a> / <a href="/wiki/Masatoshi_Koshiba" title="Masatoshi Koshiba">Koshiba</a> / <a href="/wiki/Riccardo_Giacconi" title="Riccardo Giacconi">Giacconi</a></span></li>
<li><span class="nowrap">2003: <a href="/wiki/Alexei_Abrikosov_(physicist)" title="Alexei Abrikosov (physicist)">Abrikosov</a> / <a href="/wiki/Vitaly_Ginzburg" title="Vitaly Ginzburg">Ginzburg</a> / <a href="/wiki/Anthony_James_Leggett" title="Anthony James Leggett">Leggett</a></span></li>
<li><span class="nowrap">2004: <a href="/wiki/David_Gross" title="David Gross">Gross</a> / <a href="/wiki/Hugh_David_Politzer" title="Hugh David Politzer">Politzer</a> / <a href="/wiki/Frank_Wilczek" title="Frank Wilczek">Wilczek</a></span></li>
<li><span class="nowrap">2005: <a href="/wiki/Roy_J._Glauber" title="Roy J. Glauber">Glauber</a> / <a href="/wiki/John_L._Hall" title="John L. Hall">Hall</a> / <a href="/wiki/Theodor_W._H%C3%A4nsch" title="Theodor W. Hänsch">Hänsch</a></span></li>
<li><span class="nowrap">2006: <a href="/wiki/John_C._Mather" title="John C. Mather">Mather</a> / <a href="/wiki/George_Smoot" title="George Smoot">Smoot</a></span></li>
<li><span class="nowrap">2007: <a href="/wiki/Albert_Fert" title="Albert Fert">Fert</a> / <a href="/wiki/Peter_Gr%C3%BCnberg" title="Peter Grünberg">Grünberg</a></span></li>
<li><span class="nowrap">2008: <a href="/wiki/Yoichiro_Nambu" title="Yoichiro Nambu">Nambu</a> / <a href="/wiki/Makoto_Kobayashi_(physicist)" title="Makoto Kobayashi (physicist)">Kobayashi</a> / <a href="/wiki/Toshihide_Maskawa" title="Toshihide Maskawa">Maskawa</a></span></li>
<li><span class="nowrap">2009: <a href="/wiki/Charles_K._Kao" title="Charles K. Kao">Kao</a> / <a href="/wiki/Willard_Boyle" title="Willard Boyle">Boyle</a> / <a href="/wiki/George_E._Smith" title="George E. Smith">Smith</a></span></li>
<li><span class="nowrap">2010: <a href="/wiki/Andre_Geim" title="Andre Geim">Geim</a> / <a href="/wiki/Konstantin_Novoselov" title="Konstantin Novoselov">Novoselov</a></span></li>
<li><span class="nowrap">2011: <a href="/wiki/Saul_Perlmutter" title="Saul Perlmutter">Perlmutter</a> / <a href="/wiki/Adam_Riess" title="Adam Riess">Riess</a> / <a href="/wiki/Brian_Schmidt" title="Brian Schmidt">Schmidt</a></span></li>
<li><span class="nowrap">2012: <a href="/wiki/David_J._Wineland" title="David J. Wineland">Wineland</a> / <a href="/wiki/Serge_Haroche" title="Serge Haroche">Haroche</a></span></li>
<li><span class="nowrap">2013: <a href="/wiki/Fran%C3%A7ois_Englert" title="François Englert">Englert</a> / <a href="/wiki/Peter_Higgs" title="Peter Higgs">Higgs</a></span></li>
<li><span class="nowrap">2014: <a href="/wiki/Isamu_Akasaki" title="Isamu Akasaki">Akasaki</a> / <a href="/wiki/Hiroshi_Amano" title="Hiroshi Amano">Amano</a> / <a href="/wiki/Shuji_Nakamura" title="Shuji Nakamura">Nakamura</a></span></li>
<li><span class="nowrap">2015: <a href="/wiki/Takaaki_Kajita" title="Takaaki Kajita">Kajita</a> / <a href="/wiki/Arthur_B._McDonald" title="Arthur B. McDonald">McDonald</a></span></li>
<li><span class="nowrap">2016: <a href="/wiki/David_J._Thouless" title="David J. Thouless">Thouless</a> / <a href="/wiki/Duncan_Haldane" title="Duncan Haldane">Haldane</a> / <a href="/wiki/J._Michael_Kosterlitz" title="J. Michael Kosterlitz">Kosterlitz</a></span></li>
<li><span class="nowrap">2017: <a href="/wiki/Rainer_Weiss" title="Rainer Weiss">Weiss</a> / <a href="/wiki/Barry_Barish" title="Barry Barish">Barish</a> / <a href="/wiki/Kip_Thorne" title="Kip Thorne">Thorne</a></span></li>
<li><span class="nowrap">2018: <a href="/wiki/Arthur_Ashkin" title="Arthur Ashkin">Ashkin</a> / <a href="/wiki/G%C3%A9rard_Mourou" title="Gérard Mourou">Mourou</a> / <a href="/wiki/Donna_Strickland" title="Donna Strickland">Strickland</a></span></li>
<li><span class="nowrap">2019: <a href="/wiki/Jim_Peebles" title="Jim Peebles">Peebles</a> / <a href="/wiki/Michel_Mayor" title="Michel Mayor">Mayor</a> / <a href="/wiki/Didier_Queloz" title="Didier Queloz">Queloz</a></span></li>
<li><span class="nowrap">2020: <a href="/wiki/Roger_Penrose" title="Roger Penrose">Penrose</a> / <a href="/wiki/Reinhard_Genzel" title="Reinhard Genzel">Genzel</a> / <a href="/wiki/Andrea_M._Ghez" title="Andrea M. Ghez">Ghez</a></span></li></ul>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="1921_Nobel_Prize_laureates" style="padding:3px"><table class="nowraplinks hlist mw-collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="3"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:1921_Nobel_Prize_winners" title="Template:1921 Nobel Prize winners"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:1921_Nobel_Prize_winners" title="Template talk:1921 Nobel Prize winners"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:1921_Nobel_Prize_winners&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="1921_Nobel_Prize_laureates" style="font-size:114%;margin:0 4em">1921 <a href="/wiki/Nobel_Prize" title="Nobel Prize">Nobel Prize</a> laureates</div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Nobel_Prize_in_Chemistry" title="Nobel Prize in Chemistry">Chemistry</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Frederick_Soddy" title="Frederick Soddy">Frederick Soddy</a> (Great Britain)</li></ul>
</div></td><td class="noviewer navbox-image" rowspan="5" style="width:1px;padding:0px 0px 0px 2px"><div><img alt="" src="//upload.wikimedia.org/wikipedia/en/thumb/e/ed/Nobel_Prize.png/80px-Nobel_Prize.png" decoding="async" width="80" height="79" srcset="//upload.wikimedia.org/wikipedia/en/thumb/e/ed/Nobel_Prize.png/120px-Nobel_Prize.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/e/ed/Nobel_Prize.png/160px-Nobel_Prize.png 2x" data-file-width="500" data-file-height="492" /></div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Nobel_Prize_in_Literature" title="Nobel Prize in Literature">Literature</a></th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Anatole_France" title="Anatole France">Anatole France</a> (France)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Nobel_Peace_Prize" title="Nobel Peace Prize">Peace</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Hjalmar_Branting" title="Hjalmar Branting">Hjalmar Branting</a> (Sweden)</li>
<li><a href="/wiki/Christian_Lous_Lange" title="Christian Lous Lange">Christian Lous Lange</a> (Norway)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Nobel_Prize_in_Physics" title="Nobel Prize in Physics">Physics</a></th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a class="mw-selflink selflink">Albert Einstein</a> (Germany)</li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Nobel_Prize_in_Physiology_or_Medicine" title="Nobel Prize in Physiology or Medicine">Physiology or Medicine</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li>None</li></ul>
</div></td></tr><tr><td class="navbox-abovebelow" colspan="3"><div>
<dl><dt><style data-mw-deduplicate="TemplateStyles:r886047488">.mw-parser-output .nobold{font-weight:normal}</style><span class="nobold"><a href="/wiki/List_of_Nobel_laureates" title="List of Nobel laureates">Nobel Prize recipients</a></span></dt>
<dd><a href="/wiki/Template:1916_Nobel_Prize_winners" title="Template:1916 Nobel Prize winners">1916</a></dd>
<dd><a href="/wiki/Template:1917_Nobel_Prize_winners" title="Template:1917 Nobel Prize winners">1917</a></dd>
<dd><a href="/wiki/Template:1918_Nobel_Prize_winners" title="Template:1918 Nobel Prize winners">1918</a></dd>
<dd><a href="/wiki/Template:1919_Nobel_Prize_winners" title="Template:1919 Nobel Prize winners">1919</a></dd>
<dd><a href="/wiki/Template:1920_Nobel_Prize_winners" title="Template:1920 Nobel Prize winners">1920</a></dd>
<dd><b>1921 </b></dd>
<dd><a href="/wiki/Template:1922_Nobel_Prize_winners" title="Template:1922 Nobel Prize winners">1922</a></dd>
<dd><a href="/wiki/Template:1923_Nobel_Prize_winners" title="Template:1923 Nobel Prize winners">1923</a></dd>
<dd><a href="/wiki/Template:1924_Nobel_Prize_winners" title="Template:1924 Nobel Prize winners">1924</a></dd>
<dd><a href="/wiki/Template:1925_Nobel_Prize_winners" title="Template:1925 Nobel Prize winners">1925</a></dd>
<dd><a href="/wiki/Template:1926_Nobel_Prize_winners" title="Template:1926 Nobel Prize winners">1926</a></dd></dl>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="Fellows_of_the_Royal_Society_elected_in_1921" style="padding:3px"><table class="nowraplinks mw-collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:FRS_1921" title="Template:FRS 1921"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:FRS_1921" title="Template talk:FRS 1921"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:FRS_1921&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Fellows_of_the_Royal_Society_elected_in_1921" style="font-size:114%;margin:0 4em"><a href="/wiki/Fellow_of_the_Royal_Society" title="Fellow of the Royal Society">Fellows</a> of the <a href="/wiki/Royal_Society" title="Royal Society">Royal Society</a> elected <a href="/wiki/List_of_Fellows_of_the_Royal_Society_elected_in_1921" class="mw-redirect" title="List of Fellows of the Royal Society elected in 1921">in 1921</a></div></th></tr><tr><th scope="row" class="navbox-group" style="width:1%">Fellows</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Wilfred_Eade_Agar" title="Wilfred Eade Agar">Wilfred Eade Agar</a></li>
<li><a href="/wiki/Francis_William_Aston" title="Francis William Aston">Francis William Aston</a></li>
<li><a href="/wiki/Lawrence_Bragg" title="Lawrence Bragg">Lawrence Bragg</a>&#160;</li>
<li><a href="/wiki/William_Thomas_Calman" title="William Thomas Calman">William Thomas Calman</a></li>
<li><a href="/wiki/Arthur_Harry_Church" title="Arthur Harry Church">Arthur Harry Church</a></li>
<li><a href="/wiki/Georges_Dreyer" title="Georges Dreyer">Georges Dreyer</a></li>
<li><a href="/wiki/William_Eccles" title="William Eccles">William Eccles</a></li>
<li><a href="/wiki/John_Charles_Grant_Ledingham" title="John Charles Grant Ledingham">John Charles Grant Ledingham</a></li>
<li><a href="https://www.wikidata.org/wiki/Q18223301" class="extiw" title="d:Q18223301">Kennedy Joseph Previte&#160;Orton</a></li>
<li><a href="/wiki/John_Herbert_Parsons" title="John Herbert Parsons">John Herbert Parsons</a></li>
<li><a href="https://www.wikidata.org/wiki/Q15633439" class="extiw" title="d:Q15633439">James Charles&#160;Philip</a></li>
<li><a href="/wiki/Alfred_Robb" title="Alfred Robb">Alfred Robb</a></li>
<li><a href="/wiki/Eustace_Tennyson_d%27Eyncourt" title="Eustace Tennyson d&#39;Eyncourt">Eustace Tennyson d\'Eyncourt</a></li>
<li><a href="/wiki/Udny_Yule" title="Udny Yule">Udny Yule</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:1%">Foreign</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Albert_Calmette" title="Albert Calmette">Albert Calmette</a></li>
<li><a href="/wiki/Henri-Alexandre_Deslandres" title="Henri-Alexandre Deslandres">Henri-Alexandre Deslandres</a></li>
<li><a class="mw-selflink selflink">Albert&#160;Einstein</a></li>
<li><a href="/wiki/Albin_Haller" title="Albin Haller">Albin Haller</a></li>
<li><a href="/wiki/Edmund_Beecher_Wilson" title="Edmund Beecher Wilson">Edmund Beecher Wilson</a></li>
<li><a href="/wiki/Pieter_Zeeman" title="Pieter Zeeman">Pieter Zeeman</a></li></ul>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="Philosophy_of_science" style="padding:3px"><table class="nowraplinks hlist mw-collapsible autocollapse navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:Philosophy_of_science" title="Template:Philosophy of science"><abbr title="View this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:Philosophy_of_science" title="Template talk:Philosophy of science"><abbr title="Discuss this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:Philosophy_of_science&amp;action=edit"><abbr title="Edit this template" style=";;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Philosophy_of_science" style="font-size:114%;margin:0 4em"><a href="/wiki/Philosophy_of_science" title="Philosophy of science">Philosophy of science</a></div></th></tr><tr><td colspan="2" class="navbox-list navbox-odd" style="width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:7.5em">Concepts</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Philosophical_analysis" title="Philosophical analysis">Analysis</a></li>
<li><a href="/wiki/Analytic%E2%80%93synthetic_distinction" title="Analytic–synthetic distinction">Analytic–synthetic distinction</a></li>
<li><a href="/wiki/A_priori_and_a_posteriori" title="A priori and a posteriori"><i>A priori</i> and <i>a posteriori</i></a></li>
<li><a href="/wiki/Causality" title="Causality">Causality</a></li>
<li><a href="/wiki/Commensurability_(philosophy_of_science)" title="Commensurability (philosophy of science)">Commensurability</a></li>
<li><a href="/wiki/Consilience" title="Consilience">Consilience</a></li>
<li><a href="/wiki/Construct_(philosophy)" title="Construct (philosophy)">Construct</a></li>
<li><a href="/wiki/Creative_synthesis" title="Creative synthesis">Creative synthesis</a></li>
<li><a href="/wiki/Demarcation_problem" title="Demarcation problem">Demarcation problem</a></li>
<li><a href="/wiki/Empirical_evidence" title="Empirical evidence">Empirical evidence</a></li>
<li><a href="/wiki/Explanatory_power" title="Explanatory power">Explanatory power</a></li>
<li><a href="/wiki/Fact" title="Fact">Fact</a></li>
<li><a href="/wiki/Falsifiability" title="Falsifiability">Falsifiability</a></li>
<li><a href="/wiki/Feminist_method" title="Feminist method">Feminist method</a></li>
<li><a href="/wiki/Functional_contextualism" title="Functional contextualism">Functional contextualism</a></li></ul>
<ul><li><i><a href="/wiki/Ignoramus_et_ignorabimus" title="Ignoramus et ignorabimus">Ignoramus et ignorabimus</a></i></li>
<li><a href="/wiki/Inductive_reasoning" title="Inductive reasoning">Inductive reasoning</a></li>
<li><a href="/wiki/Intertheoretic_reduction" title="Intertheoretic reduction">Intertheoretic reduction</a></li>
<li><a href="/wiki/Inquiry" title="Inquiry">Inquiry</a></li>
<li><a href="/wiki/Nature_(philosophy)" title="Nature (philosophy)">Nature</a></li>
<li><a href="/wiki/Objectivity_(philosophy)" title="Objectivity (philosophy)">Objectivity</a></li>
<li><a href="/wiki/Observation" title="Observation">Observation</a></li>
<li><a href="/wiki/Paradigm" title="Paradigm">Paradigm</a></li>
<li><a href="/wiki/Problem_of_induction" title="Problem of induction">Problem of induction</a></li>
<li><a href="/wiki/Scientific_law" title="Scientific law">Scientific law</a></li>
<li><a href="/wiki/Scientific_method" title="Scientific method">Scientific method</a></li>
<li><a href="/wiki/Scientific_revolution" class="mw-redirect" title="Scientific revolution">Scientific revolution</a></li>
<li><a href="/wiki/Scientific_theory" title="Scientific theory">Scientific theory</a></li>
<li><a href="/wiki/Testability" title="Testability">Testability</a></li>
<li><a href="/wiki/Theory_choice" title="Theory choice">Theory choice</a></li>
<li><a href="/wiki/Theory-ladenness" title="Theory-ladenness">Theory-ladenness</a></li>
<li><a href="/wiki/Underdetermination" title="Underdetermination">Underdetermination</a></li>
<li><a href="/wiki/Unity_of_science" title="Unity of science">Unity of science</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em"><a href="/wiki/Category:Metatheory_of_science" title="Category:Metatheory of science">Metatheory<br />of science</a></th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Coherentism" title="Coherentism">Coherentism</a></li>
<li><a href="/wiki/Confirmation_holism" title="Confirmation holism">Confirmation holism</a></li>
<li><a href="/wiki/Constructive_empiricism" title="Constructive empiricism">Constructive empiricism</a></li>
<li><a href="/wiki/Constructive_realism" title="Constructive realism">Constructive realism</a></li>
<li><a href="/wiki/Constructivist_epistemology" class="mw-redirect" title="Constructivist epistemology">Constructivist epistemology</a></li>
<li><a href="/wiki/Contextualism" title="Contextualism">Contextualism</a></li>
<li><a href="/wiki/Conventionalism" title="Conventionalism">Conventionalism</a></li>
<li><a href="/wiki/Deductive-nomological_model" title="Deductive-nomological model">Deductive-nomological model</a></li>
<li><a href="/wiki/Hypothetico-deductive_model" title="Hypothetico-deductive model">Hypothetico-deductive model</a></li>
<li><a href="/wiki/Inductionism" title="Inductionism">Inductionism</a></li>
<li><a href="/wiki/Epistemological_anarchism" title="Epistemological anarchism">Epistemological anarchism</a></li>
<li><a href="/wiki/Evolutionism" title="Evolutionism">Evolutionism</a></li>
<li><a href="/wiki/Fallibilism" title="Fallibilism">Fallibilism</a></li>
<li><a href="/wiki/Foundationalism" title="Foundationalism">Foundationalism</a></li>
<li><a href="/wiki/Instrumentalism" title="Instrumentalism">Instrumentalism</a></li>
<li><a href="/wiki/Pragmatism" title="Pragmatism">Pragmatism</a></li>
<li><a href="/wiki/Model-dependent_realism" title="Model-dependent realism">Model-dependent realism</a></li>
<li><a href="/wiki/Naturalism_(philosophy)" title="Naturalism (philosophy)">Naturalism</a></li>
<li><a href="/wiki/Physicalism" title="Physicalism">Physicalism</a></li>
<li><a href="/wiki/Positivism" title="Positivism">Positivism</a>&#160;/&#32;<a href="/wiki/Reductionism" title="Reductionism">Reductionism</a>&#160;/&#32;<a href="/wiki/Determinism" title="Determinism">Determinism</a></li>
<li><a href="/wiki/Rationalism" title="Rationalism">Rationalism</a>&#160;/&#32;<a href="/wiki/Empiricism" title="Empiricism">Empiricism</a></li>
<li><a href="/wiki/Received_view_of_theories" title="Received view of theories">Received view</a>&#160;/&#32;<a href="/wiki/Semantic_view_of_theories" title="Semantic view of theories">Semantic view of theories</a></li>
<li><a href="/wiki/Scientific_realism" title="Scientific realism">Scientific realism</a>&#160;/&#32;<a href="/wiki/Anti-realism" title="Anti-realism">Anti-realism</a></li>
<li><a href="/wiki/Scientific_essentialism" title="Scientific essentialism">Scientific essentialism</a></li>
<li><a href="/wiki/Scientific_formalism" title="Scientific formalism">Scientific formalism</a></li>
<li><a href="/wiki/Scientific_skepticism" class="mw-redirect" title="Scientific skepticism">Scientific skepticism</a></li>
<li><a href="/wiki/Scientism" title="Scientism">Scientism</a></li>
<li><a href="/wiki/Structuralism_(philosophy_of_science)" title="Structuralism (philosophy of science)">Structuralism</a></li>
<li><a href="/wiki/Uniformitarianism" title="Uniformitarianism">Uniformitarianism</a></li>
<li><a href="/wiki/Vitalism" title="Vitalism">Vitalism</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em">Philosophy of</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Philosophy_of_physics" title="Philosophy of physics">Physics</a>
<ul><li><a href="/wiki/Philosophy_of_thermal_and_statistical_physics" title="Philosophy of thermal and statistical physics">thermal and statistical</a></li>
<li><a href="/wiki/Philosophy_of_motion" title="Philosophy of motion">Motion</a></li></ul></li>
<li><a href="/wiki/Philosophy_of_chemistry" title="Philosophy of chemistry">Chemistry</a></li>
<li><a href="/wiki/Philosophy_of_biology" title="Philosophy of biology">Biology</a></li>
<li><a href="/wiki/Philosophy_of_geography" title="Philosophy of geography">Geography</a></li>
<li><a href="/wiki/Philosophy_of_social_science" title="Philosophy of social science">Social science</a></li>
<li><a href="/wiki/Philosophy_of_technology" title="Philosophy of technology">Technology</a>
<ul><li><a href="/wiki/Philosophy_of_engineering" title="Philosophy of engineering">Engineering</a></li>
<li><a href="/wiki/Philosophy_of_artificial_intelligence" title="Philosophy of artificial intelligence">Artificial intelligence</a></li>
<li><a href="/wiki/Philosophy_of_computer_science" title="Philosophy of computer science">Computer science</a></li></ul></li>
<li><a href="/wiki/Philosophy_of_information" title="Philosophy of information">Information</a></li>
<li><a href="/wiki/Philosophy_of_mind" title="Philosophy of mind">Mind</a></li>
<li><a href="/wiki/Philosophy_of_psychiatry" title="Philosophy of psychiatry">Psychiatry</a></li>
<li><a href="/wiki/Philosophy_of_psychology" title="Philosophy of psychology">Psychology</a></li>
<li><a href="/wiki/Philosophy_of_perception" title="Philosophy of perception">Perception</a></li>
<li><a href="/wiki/Philosophy_of_space_and_time" title="Philosophy of space and time">Space and time</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em"><a href="/wiki/Index_of_philosophy_of_science_articles" title="Index of philosophy of science articles">Related topics</a></th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Alchemy" title="Alchemy">Alchemy</a></li>
<li><a href="/wiki/Criticism_of_science" title="Criticism of science">Criticism of science</a></li>
<li><a href="/wiki/Descriptive_research" title="Descriptive research">Descriptive science</a></li>
<li><a href="/wiki/Epistemology" title="Epistemology">Epistemology</a></li>
<li><a href="/wiki/Faith_and_rationality" title="Faith and rationality">Faith and rationality</a></li>
<li><a href="/wiki/Hard_and_soft_science" title="Hard and soft science">Hard and soft science</a></li>
<li><a href="/wiki/History_and_philosophy_of_science" title="History and philosophy of science">History and philosophy of science</a></li>
<li><a href="/wiki/History_of_science" title="History of science">History of science</a></li>
<li><a href="/wiki/History_of_evolutionary_thought" title="History of evolutionary thought">History of evolutionary thought</a></li>
<li><a href="/wiki/Logic" title="Logic">Logic</a></li>
<li><a href="/wiki/Metaphysics" title="Metaphysics">Metaphysics</a></li>
<li><a href="/wiki/Normative_science" title="Normative science">Normative science</a></li>
<li><a href="/wiki/Pseudoscience" title="Pseudoscience">Pseudoscience</a></li>
<li><a href="/wiki/Relationship_between_religion_and_science" title="Relationship between religion and science">Relationship between religion and science</a></li>
<li><a href="/wiki/Rhetoric_of_science" title="Rhetoric of science">Rhetoric of science</a></li>
<li><a href="/wiki/Science_studies" title="Science studies">Science studies</a></li>
<li><a href="/wiki/Sociology_of_scientific_knowledge" title="Sociology of scientific knowledge">Sociology of scientific knowledge</a></li>
<li><a href="/wiki/Sociology_of_scientific_ignorance" title="Sociology of scientific ignorance">Sociology of scientific ignorance</a></li></ul>
</div></td></tr></tbody></table><div></div></td></tr><tr><td colspan="2" class="navbox-list navbox-odd" style="width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks mw-collapsible mw-collapsed navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="col" class="navbox-title" colspan="2"><div id="Philosophers_of_science_by_era" style="font-size:114%;margin:0 4em"><a href="/wiki/List_of_philosophers_of_science" title="List of philosophers of science">Philosophers of science</a> by era</div></th></tr><tr><td colspan="2" class="navbox-list navbox-odd" style="width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:7.5em">Ancient</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Plato" title="Plato">Plato</a></li>
<li><a href="/wiki/Aristotle" title="Aristotle">Aristotle</a></li>
<li><a href="/wiki/Stoicism" title="Stoicism">Stoicism</a></li>
<li><a href="/wiki/Epicureanism" title="Epicureanism">Epicureans</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em">Medieval</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Averroes" title="Averroes">Averroes</a></li>
<li><a href="/wiki/Avicenna" title="Avicenna">Avicenna</a></li>
<li><a href="/wiki/Roger_Bacon" title="Roger Bacon">Roger Bacon</a></li>
<li><a href="/wiki/William_of_Ockham" title="William of Ockham">William of Ockham</a></li>
<li><a href="/wiki/Hugh_of_Saint_Victor" title="Hugh of Saint Victor">Hugh of Saint Victor</a></li>
<li><a href="/wiki/Dominicus_Gundissalinus" title="Dominicus Gundissalinus">Dominicus Gundissalinus</a></li>
<li><a href="/wiki/Robert_Kilwardby" title="Robert Kilwardby">Robert Kilwardby</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em">Early modern</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Francis_Bacon" title="Francis Bacon">Francis Bacon</a></li>
<li><a href="/wiki/Thomas_Hobbes" title="Thomas Hobbes">Thomas Hobbes</a></li>
<li><a href="/wiki/Ren%C3%A9_Descartes" title="René Descartes">René Descartes</a></li>
<li><a href="/wiki/Galileo_Galilei" title="Galileo Galilei">Galileo Galilei</a></li>
<li><a href="/wiki/Pierre_Gassendi" title="Pierre Gassendi">Pierre Gassendi</a></li>
<li><a href="/wiki/Isaac_Newton" title="Isaac Newton">Isaac Newton</a></li>
<li><a href="/wiki/David_Hume" title="David Hume">David Hume</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em">Late modern</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Immanuel_Kant" title="Immanuel Kant">Immanuel Kant</a></li>
<li><a href="/wiki/Friedrich_Wilhelm_Joseph_Schelling" title="Friedrich Wilhelm Joseph Schelling">Friedrich Schelling</a></li>
<li><a href="/wiki/William_Whewell" title="William Whewell">William Whewell</a></li>
<li><a href="/wiki/Auguste_Comte" title="Auguste Comte">Auguste Comte</a></li>
<li><a href="/wiki/John_Stuart_Mill" title="John Stuart Mill">John Stuart Mill</a></li>
<li><a href="/wiki/Herbert_Spencer" title="Herbert Spencer">Herbert Spencer</a></li>
<li><a href="/wiki/Wilhelm_Wundt" title="Wilhelm Wundt">Wilhelm Wundt</a></li>
<li><a href="/wiki/Charles_Sanders_Peirce" title="Charles Sanders Peirce">Charles Sanders Peirce</a></li>
<li><a href="/wiki/Wilhelm_Windelband" title="Wilhelm Windelband">Wilhelm Windelband</a></li>
<li><a href="/wiki/Henri_Poincar%C3%A9" title="Henri Poincaré">Henri Poincaré</a></li>
<li><a href="/wiki/Pierre_Duhem" title="Pierre Duhem">Pierre Duhem</a></li>
<li><a href="/wiki/Rudolf_Steiner" title="Rudolf Steiner">Rudolf Steiner</a></li>
<li><a href="/wiki/Karl_Pearson" title="Karl Pearson">Karl Pearson</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:7.5em">Contemporary</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Alfred_North_Whitehead" title="Alfred North Whitehead">Alfred North Whitehead</a></li>
<li><a href="/wiki/Bertrand_Russell" title="Bertrand Russell">Bertrand Russell</a></li>
<li><a class="mw-selflink selflink">Albert Einstein</a></li>
<li><a href="/wiki/Otto_Neurath" title="Otto Neurath">Otto Neurath</a></li>
<li><a href="/wiki/C._D._Broad" title="C. D. Broad">C. D. Broad</a></li>
<li><a href="/wiki/Michael_Polanyi" title="Michael Polanyi">Michael Polanyi</a></li>
<li><a href="/wiki/Hans_Reichenbach" title="Hans Reichenbach">Hans Reichenbach</a></li>
<li><a href="/wiki/Rudolf_Carnap" title="Rudolf Carnap">Rudolf Carnap</a></li>
<li><a href="/wiki/Karl_Popper" title="Karl Popper">Karl Popper</a></li>
<li><a href="/wiki/Carl_Gustav_Hempel" title="Carl Gustav Hempel">Carl Gustav Hempel</a></li>
<li><a href="/wiki/Willard_Van_Orman_Quine" title="Willard Van Orman Quine">W. V. O. Quine</a></li>
<li><a href="/wiki/Thomas_Kuhn" title="Thomas Kuhn">Thomas Kuhn</a></li>
<li><a href="/wiki/Imre_Lakatos" title="Imre Lakatos">Imre Lakatos</a></li>
<li><a href="/wiki/Paul_Feyerabend" title="Paul Feyerabend">Paul Feyerabend</a></li>
<li><a href="/wiki/J%C3%BCrgen_Habermas" title="Jürgen Habermas">Jürgen Habermas</a></li>
<li><a href="/wiki/Ian_Hacking" title="Ian Hacking">Ian Hacking</a></li>
<li><a href="/wiki/Bas_van_Fraassen" title="Bas van Fraassen">Bas van Fraassen</a></li>
<li><a href="/wiki/Larry_Laudan" title="Larry Laudan">Larry Laudan</a></li>
<li><a href="/wiki/Daniel_Dennett" title="Daniel Dennett">Daniel Dennett</a></li></ul>
</div></td></tr></tbody></table><div></div></td></tr></tbody></table><div></div></td></tr><tr><td class="navbox-abovebelow" colspan="2"><div>
<ul><li><a href="/wiki/Category:Philosophy_of_science" title="Category:Philosophy of science">Category</a></li>
<li><a href="/wiki/File:Socrates.png" class="image"><img alt="Socrates.png" src="//upload.wikimedia.org/wikipedia/commons/thumb/c/cd/Socrates.png/18px-Socrates.png" decoding="async" width="18" height="28" class="noviewer" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/c/cd/Socrates.png/27px-Socrates.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/c/cd/Socrates.png/36px-Socrates.png 2x" data-file-width="326" data-file-height="500" /></a>&#160;<a href="/wiki/Portal:Philosophy" title="Portal:Philosophy">Philosophy&#32;portal</a></li>
<li><a href="/wiki/File:Nuvola_apps_kalzium.svg" class="image"><img alt="Nuvola apps kalzium.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/28px-Nuvola_apps_kalzium.svg.png" decoding="async" width="28" height="28" class="noviewer" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/42px-Nuvola_apps_kalzium.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/56px-Nuvola_apps_kalzium.svg.png 2x" data-file-width="128" data-file-height="128" /></a>&#160;<a href="/wiki/Portal:Science" title="Portal:Science">Science&#32;portal</a></li></ul>
</div></td></tr></tbody></table></div>
<div role="navigation" class="navbox" aria-labelledby="Relativity" style="padding:3px"><table class="nowraplinks mw-collapsible mw-collapsed navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th scope="col" class="navbox-title" colspan="3" style="text-align:center;"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r992953826"/><div class="navbar plainlinks hlist navbar-mini"><ul><li class="nv-view"><a href="/wiki/Template:Relativity" title="Template:Relativity"><abbr title="View this template" style="text-align:center;;;background:none transparent;border:none;box-shadow:none;padding:0;">v</abbr></a></li><li class="nv-talk"><a href="/wiki/Template_talk:Relativity" title="Template talk:Relativity"><abbr title="Discuss this template" style="text-align:center;;;background:none transparent;border:none;box-shadow:none;padding:0;">t</abbr></a></li><li class="nv-edit"><a class="external text" href="https://en.wikipedia.org/w/index.php?title=Template:Relativity&amp;action=edit"><abbr title="Edit this template" style="text-align:center;;;background:none transparent;border:none;box-shadow:none;padding:0;">e</abbr></a></li></ul></div><div id="Relativity" style="font-size:114%;margin:0 4em"><a href="/wiki/Theory_of_relativity" title="Theory of relativity">Relativity</a></div></th></tr><tr><th scope="row" class="navbox-group" style="text-align:center;;width:1%"><a href="/wiki/Special_relativity" title="Special relativity">Special<br />relativity</a></th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Background</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Principle_of_relativity" title="Principle of relativity">Principle of relativity</a> (<a href="/wiki/Galilean_invariance" title="Galilean invariance">Galilean relativity</a></li>
<li><a href="/wiki/Galilean_transformation" title="Galilean transformation">Galilean transformation</a>)</li>
<li><a href="/wiki/Special_relativity" title="Special relativity">Special relativity</a></li>
<li><a href="/wiki/Doubly_special_relativity" title="Doubly special relativity">Doubly special relativity</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Fundamental<br />concepts</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Frame_of_reference" title="Frame of reference">Frame of reference</a></li>
<li><a href="/wiki/Speed_of_light" title="Speed of light">Speed of light</a></li>
<li><a href="/wiki/Hyperbolic_orthogonality" title="Hyperbolic orthogonality">Hyperbolic orthogonality</a></li>
<li><a href="/wiki/Rapidity" title="Rapidity">Rapidity</a></li>
<li><a href="/wiki/Maxwell%27s_equations" title="Maxwell&#39;s equations">Maxwell\'s equations</a></li>
<li><a href="/wiki/Proper_length" title="Proper length">Proper length</a></li>
<li><a href="/wiki/Proper_time" title="Proper time">Proper time</a></li>
<li><a href="/wiki/Mass_in_special_relativity" title="Mass in special relativity">Relativistic mass</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Formulation</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Lorentz_transformation" title="Lorentz transformation">Lorentz transformation</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Phenomena</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Time_dilation" title="Time dilation">Time dilation</a></li>
<li><a href="/wiki/Mass%E2%80%93energy_equivalence" title="Mass–energy equivalence">Mass–energy equivalence</a></li>
<li><a href="/wiki/Length_contraction" title="Length contraction">Length contraction</a></li>
<li><a href="/wiki/Relativity_of_simultaneity" title="Relativity of simultaneity">Relativity of simultaneity</a></li>
<li><a href="/wiki/Relativistic_Doppler_effect" title="Relativistic Doppler effect">Relativistic Doppler effect</a></li>
<li><a href="/wiki/Thomas_precession" title="Thomas precession">Thomas precession</a></li>
<li><a href="/wiki/Ladder_paradox" title="Ladder paradox">Ladder paradox</a></li>
<li><a href="/wiki/Twin_paradox" title="Twin paradox">Twin paradox</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;"><a href="/wiki/Spacetime" title="Spacetime">Spacetime</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Light_cone" title="Light cone">Light cone</a></li>
<li><a href="/wiki/World_line" title="World line">World line</a></li>
<li><a href="/wiki/Minkowski_diagram" class="mw-redirect" title="Minkowski diagram">Minkowski diagram</a></li>
<li><a href="/wiki/Biquaternion" title="Biquaternion">Biquaternions</a></li>
<li><a href="/wiki/Minkowski_space" title="Minkowski space">Minkowski space</a></li></ul>
</div></td></tr></tbody></table><div></div></td><td class="noviewer navbox-image" rowspan="4" style="width:1px;padding:0px 0px 0px 2px"><div><a href="/wiki/File:Spacetime_curvature.png" class="image"><img alt="Spacetime curvature.png" src="//upload.wikimedia.org/wikipedia/commons/thumb/2/22/Spacetime_curvature.png/150px-Spacetime_curvature.png" decoding="async" width="150" height="66" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/2/22/Spacetime_curvature.png/225px-Spacetime_curvature.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/2/22/Spacetime_curvature.png/300px-Spacetime_curvature.png 2x" data-file-width="660" data-file-height="291" /></a></div></td></tr><tr><th scope="row" class="navbox-group" style="text-align:center;;width:1%"><a href="/wiki/General_relativity" title="General relativity">General<br />relativity</a></th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"></div><table class="nowraplinks navbox-subgroup" style="border-spacing:0"><tbody><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Background</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Introduction_to_general_relativity" title="Introduction to general relativity">Introduction</a></li>
<li><a href="/wiki/Mathematics_of_general_relativity" title="Mathematics of general relativity">Mathematical formulation</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Fundamental<br />concepts</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Equivalence_principle" title="Equivalence principle">Equivalence principle</a></li>
<li><a href="/wiki/Riemannian_geometry" title="Riemannian geometry">Riemannian geometry</a></li>
<li><a href="/wiki/Penrose_diagram" title="Penrose diagram">Penrose diagram</a></li>
<li><a href="/wiki/Geodesics_in_general_relativity" title="Geodesics in general relativity">Geodesics</a></li>
<li><a href="/wiki/Mach%27s_principle" title="Mach&#39;s principle">Mach\'s principle</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Formulation</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/ADM_formalism" title="ADM formalism">ADM formalism</a></li>
<li><a href="/wiki/BSSN_formalism" title="BSSN formalism">BSSN formalism</a></li>
<li><a href="/wiki/Einstein_field_equations" title="Einstein field equations">Einstein field equations</a></li>
<li><a href="/wiki/Linearized_gravity" title="Linearized gravity">Linearized gravity</a></li>
<li><a href="/wiki/Parameterized_post-Newtonian_formalism" title="Parameterized post-Newtonian formalism">Post-Newtonian formalism</a></li>
<li><a href="/wiki/Raychaudhuri_equation" title="Raychaudhuri equation">Raychaudhuri equation</a></li>
<li><a href="/wiki/Hamilton%E2%80%93Jacobi%E2%80%93Einstein_equation" title="Hamilton–Jacobi–Einstein equation">Hamilton–Jacobi–Einstein equation</a></li>
<li><a href="/wiki/Ernst_equation" title="Ernst equation">Ernst equation</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Phenomena</th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Black_hole" title="Black hole">Black hole</a></li>
<li><a href="/wiki/Event_horizon" title="Event horizon">Event horizon</a></li>
<li><a href="/wiki/Gravitational_singularity" title="Gravitational singularity">Singularity</a></li>
<li><a href="/wiki/Two-body_problem_in_general_relativity" title="Two-body problem in general relativity">Two-body problem</a></li></ul>
<ul><li><a href="/wiki/Gravitational_wave" title="Gravitational wave">Gravitational waves</a>: <a href="/wiki/Gravitational-wave_astronomy" title="Gravitational-wave astronomy">astronomy</a></li>
<li><a href="/wiki/Gravitational-wave_observatory" title="Gravitational-wave observatory">detectors</a> (<a href="/wiki/LIGO" title="LIGO">LIGO</a> and <a href="/wiki/LIGO_Scientific_Collaboration" title="LIGO Scientific Collaboration">collaboration</a></li>
<li><a href="/wiki/Virgo_interferometer" title="Virgo interferometer">Virgo</a></li>
<li><a href="/wiki/LISA_Pathfinder" title="LISA Pathfinder">LISA Pathfinder</a></li>
<li><a href="/wiki/GEO600" title="GEO600">GEO</a>)</li>
<li><a href="/wiki/Hulse%E2%80%93Taylor_binary" title="Hulse–Taylor binary">Hulse–Taylor binary</a></li></ul>
<ul><li><a href="/wiki/Tests_of_general_relativity" title="Tests of general relativity">Other tests</a>: <a href="/wiki/Apsidal_precession" title="Apsidal precession">precession</a> of Mercury</li>
<li><a href="/wiki/Gravitational_lens" title="Gravitational lens">lensing</a></li>
<li><a href="/wiki/Gravitational_redshift" title="Gravitational redshift">redshift</a></li>
<li><a href="/wiki/Shapiro_time_delay" title="Shapiro time delay">Shapiro delay</a></li>
<li><a href="/wiki/Frame-dragging" title="Frame-dragging">frame-dragging</a> / <a href="/wiki/Geodetic_effect" title="Geodetic effect">geodetic effect</a> (<a href="/wiki/Lense%E2%80%93Thirring_precession" title="Lense–Thirring precession">Lense–Thirring precession</a>)</li>
<li><a href="/wiki/Pulsar_timing_array" title="Pulsar timing array">pulsar timing arrays</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;">Advanced<br />theories</th><td class="navbox-list navbox-even" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Brans%E2%80%93Dicke_theory" title="Brans–Dicke theory">Brans–Dicke theory</a></li>
<li><a href="/wiki/Kaluza%E2%80%93Klein_theory" title="Kaluza–Klein theory">Kaluza–Klein</a></li>
<li><a href="/wiki/Quantum_gravity" title="Quantum gravity">Quantum gravity</a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="width:6em;text-align:center;"><a href="/wiki/Exact_solutions_in_general_relativity" title="Exact solutions in general relativity">Solutions</a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;padding:0px"><div style="padding:0em 0.25em">
<ul><li>Cosmological: <a href="/wiki/Friedmann%E2%80%93Lema%C3%AEtre%E2%80%93Robertson%E2%80%93Walker_metric" title="Friedmann–Lemaître–Robertson–Walker metric">Friedmann–Lemaître–Robertson–Walker</a> (<a href="/wiki/Friedmann_equations" title="Friedmann equations">Friedmann equations</a>)</li>
<li><a href="/wiki/Kasner_metric" title="Kasner metric">Kasner</a></li>
<li><a href="/wiki/BKL_singularity" title="BKL singularity">BKL singularity</a></li>
<li><a href="/wiki/G%C3%B6del_metric" title="Gödel metric">Gödel</a></li>
<li><a href="/wiki/Milne_model" title="Milne model">Milne</a></li></ul>
<ul><li>Spherical: <a href="/wiki/Schwarzschild_metric" title="Schwarzschild metric">Schwarzschild</a> (<a href="/wiki/Interior_Schwarzschild_metric" title="Interior Schwarzschild metric">interior</a></li>
<li><a href="/wiki/Tolman%E2%80%93Oppenheimer%E2%80%93Volkoff_equation" title="Tolman–Oppenheimer–Volkoff equation">Tolman–Oppenheimer–Volkoff equation</a>)</li>
<li><a href="/wiki/Reissner%E2%80%93Nordstr%C3%B6m_metric" title="Reissner–Nordström metric">Reissner–Nordström</a></li>
<li><a href="/wiki/Lema%C3%AEtre%E2%80%93Tolman_metric" title="Lemaître–Tolman metric">Lemaître–Tolman</a></li></ul>
<ul><li>Axisymmetric: <a href="/wiki/Kerr_metric" title="Kerr metric">Kerr</a> (<a href="/wiki/Kerr%E2%80%93Newman_metric" title="Kerr–Newman metric">Kerr–Newman</a>)</li>
<li><a href="/wiki/Weyl%E2%88%92Lewis%E2%88%92Papapetrou_coordinates" class="mw-redirect" title="Weyl−Lewis−Papapetrou coordinates">Weyl−Lewis−Papapetrou</a></li>
<li><a href="/wiki/Taub%E2%80%93NUT_space" title="Taub–NUT space">Taub–NUT</a></li>
<li><a href="/wiki/Van_Stockum_dust" title="Van Stockum dust">van Stockum dust</a></li>
<li><a href="/wiki/Relativistic_disk" title="Relativistic disk">discs</a></li></ul>
<ul><li>Others: <a href="/wiki/Pp-wave_spacetime" title="Pp-wave spacetime">pp-wave</a></li>
<li><a href="/wiki/Ozsv%C3%A1th%E2%80%93Sch%C3%BCcking_metric" title="Ozsváth–Schücking metric">Ozsváth–Schücking metric</a></li></ul>
</div></td></tr></tbody></table><div></div></td></tr><tr><th scope="row" class="navbox-group" style="text-align:center;;width:1%">Scientists</th><td class="navbox-list navbox-even hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><a href="/wiki/Henri_Poincar%C3%A9" title="Henri Poincaré">Poincaré</a></li>
<li><a href="/wiki/Hendrik_Lorentz" title="Hendrik Lorentz">Lorentz</a></li>
<li><a class="mw-selflink selflink">Einstein</a></li>
<li><a href="/wiki/David_Hilbert" title="David Hilbert">Hilbert</a></li>
<li><a href="/wiki/Karl_Schwarzschild" title="Karl Schwarzschild">Schwarzschild</a></li>
<li><a href="/wiki/Willem_de_Sitter" title="Willem de Sitter">de Sitter</a></li>
<li><a href="/wiki/Hermann_Weyl" title="Hermann Weyl">Weyl</a></li>
<li><a href="/wiki/Arthur_Eddington" title="Arthur Eddington">Eddington</a></li>
<li><a href="/wiki/Alexander_Friedmann" title="Alexander Friedmann">Friedmann</a></li>
<li><a href="/wiki/Georges_Lema%C3%AEtre" title="Georges Lemaître">Lemaître</a></li>
<li><a href="/wiki/Edward_Arthur_Milne" title="Edward Arthur Milne">Milne</a></li>
<li><a href="/wiki/Howard_P._Robertson" title="Howard P. Robertson">Robertson</a></li>
<li><a href="/wiki/Subrahmanyan_Chandrasekhar" title="Subrahmanyan Chandrasekhar">Chandrasekhar</a></li>
<li><a href="/wiki/Fritz_Zwicky" title="Fritz Zwicky">Zwicky</a></li>
<li><a href="/wiki/John_Archibald_Wheeler" title="John Archibald Wheeler">Wheeler</a></li>
<li><a href="/wiki/Yvonne_Choquet-Bruhat" title="Yvonne Choquet-Bruhat">Choquet-Bruhat</a></li>
<li><a href="/wiki/Roy_Kerr" title="Roy Kerr">Kerr</a></li>
<li><a href="/wiki/Yakov_Zeldovich" title="Yakov Zeldovich">Zel\'dovich</a></li>
<li><a href="/wiki/Igor_Dmitriyevich_Novikov" title="Igor Dmitriyevich Novikov">Novikov</a></li>
<li><a href="/wiki/J%C3%BCrgen_Ehlers" title="Jürgen Ehlers">Ehlers</a></li>
<li><a href="/wiki/Robert_Geroch" title="Robert Geroch">Geroch</a></li>
<li><a href="/wiki/Roger_Penrose" title="Roger Penrose">Penrose</a></li>
<li><a href="/wiki/Stephen_Hawking" title="Stephen Hawking">Hawking</a></li>
<li><a href="/wiki/Joseph_Hooton_Taylor_Jr." title="Joseph Hooton Taylor Jr.">Taylor</a></li>
<li><a href="/wiki/Russell_Alan_Hulse" title="Russell Alan Hulse">Hulse</a></li>
<li><a href="/wiki/Hermann_Bondi" title="Hermann Bondi">Bondi</a></li>
<li><a href="/wiki/Charles_W._Misner" title="Charles W. Misner">Misner</a></li>
<li><a href="/wiki/Shing-Tung_Yau" title="Shing-Tung Yau">Yau</a></li>
<li><a href="/wiki/Kip_Thorne" title="Kip Thorne">Thorne</a></li>
<li><a href="/wiki/Rainer_Weiss" title="Rainer Weiss">Weiss</a></li>
<li><a href="/wiki/List_of_contributors_to_general_relativity" title="List of contributors to general relativity"><i>others</i></a></li></ul>
</div></td></tr><tr><th scope="row" class="navbox-group" style="text-align:center;;width:1%">Categories</th><td class="navbox-list navbox-odd hlist" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em"><link rel="mw-deduplicated-inline-style" href="mw-data:TemplateStyles:r998391716"/><div class="div-col">
<div class="CategoryTreeTag" data-ct-mode="20" data-ct-options="{&quot;mode&quot;:20,&quot;hideprefix&quot;:20,&quot;showcount&quot;:false,&quot;namespaces&quot;:false,&quot;notranslations&quot;:false}"><div class="CategoryTreeSection"><div class="CategoryTreeItem"><span class="CategoryTreeBullet"><span class="CategoryTreeToggle" data-ct-title="Theory_of_relativity" data-ct-state="collapsed">►</span> </span> <a href="/wiki/Category:Theory_of_relativity" title="Category:Theory of relativity">Theory of relativity</a></div><div class="CategoryTreeChildren" style="display:none"></div></div></div>
</div></div></td></tr></tbody></table></div>
<p class="mw-empty-elt">
</p>
<div class="noprint metadata navbox" role="navigation" aria-label="Portals" style="font-weight:bold;padding:0.4em 2em"><ul style="margin:0.1em 0 0"><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:P_vip.svg" class="image"><img alt="P vip.svg" src="//upload.wikimedia.org/wikipedia/en/thumb/6/69/P_vip.svg/21px-P_vip.svg.png" decoding="async" width="21" height="21" srcset="//upload.wikimedia.org/wikipedia/en/thumb/6/69/P_vip.svg/31px-P_vip.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/6/69/P_vip.svg/41px-P_vip.svg.png 2x" data-file-width="1911" data-file-height="1944" /></a></span><a href="/wiki/Portal:Biography" title="Portal:Biography">Biography portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Flag_of_Germany.svg" class="image"><img alt="Flag of Germany.svg" src="//upload.wikimedia.org/wikipedia/en/thumb/b/ba/Flag_of_Germany.svg/24px-Flag_of_Germany.svg.png" decoding="async" width="24" height="14" srcset="//upload.wikimedia.org/wikipedia/en/thumb/b/ba/Flag_of_Germany.svg/36px-Flag_of_Germany.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/b/ba/Flag_of_Germany.svg/48px-Flag_of_Germany.svg.png 2x" data-file-width="1000" data-file-height="600" /></a></span><a href="/wiki/Portal:Germany" title="Portal:Germany">Germany portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Star_of_David.svg" class="image"><img alt="Star of David.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/4/49/Star_of_David.svg/18px-Star_of_David.svg.png" decoding="async" width="18" height="21" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/4/49/Star_of_David.svg/28px-Star_of_David.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/4/49/Star_of_David.svg/36px-Star_of_David.svg.png 2x" data-file-width="600" data-file-height="693" /></a></span><a href="/wiki/Portal:Judaism" title="Portal:Judaism">Judaism portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Nuvola_apps_edu_mathematics_blue-p.svg" class="image"><img alt="Nuvola apps edu mathematics blue-p.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Nuvola_apps_edu_mathematics_blue-p.svg/21px-Nuvola_apps_edu_mathematics_blue-p.svg.png" decoding="async" width="21" height="21" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Nuvola_apps_edu_mathematics_blue-p.svg/32px-Nuvola_apps_edu_mathematics_blue-p.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/3/3e/Nuvola_apps_edu_mathematics_blue-p.svg/42px-Nuvola_apps_edu_mathematics_blue-p.svg.png 2x" data-file-width="128" data-file-height="128" /></a></span><a href="/wiki/Portal:Mathematics" title="Portal:Mathematics">Mathematics portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg" class="image"><img alt="Stylised atom with three Bohr model orbits and stylised nucleus.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg/18px-Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg.png" decoding="async" width="18" height="21" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg/28px-Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/6/6f/Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg/37px-Stylised_atom_with_three_Bohr_model_orbits_and_stylised_nucleus.svg.png 2x" data-file-width="530" data-file-height="600" /></a></span><a href="/wiki/Portal:Physics" title="Portal:Physics">Physics portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Nuvola_apps_kalzium.svg" class="image"><img alt="Nuvola apps kalzium.svg" src="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/21px-Nuvola_apps_kalzium.svg.png" decoding="async" width="21" height="21" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/32px-Nuvola_apps_kalzium.svg.png 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/8/8b/Nuvola_apps_kalzium.svg/42px-Nuvola_apps_kalzium.svg.png 2x" data-file-width="128" data-file-height="128" /></a></span><a href="/wiki/Portal:Science" title="Portal:Science">Science portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Earth-moon.jpg" class="image"><img alt="Earth-moon.jpg" src="//upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Earth-moon.jpg/24px-Earth-moon.jpg" decoding="async" width="24" height="19" srcset="//upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Earth-moon.jpg/36px-Earth-moon.jpg 1.5x, //upload.wikimedia.org/wikipedia/commons/thumb/5/5c/Earth-moon.jpg/48px-Earth-moon.jpg 2x" data-file-width="3000" data-file-height="2400" /></a></span><a href="/wiki/Portal:Space" class="mw-redirect" title="Portal:Space">Space portal</a></span></li><li style="display:inline"><span style="display:inline-block;white-space:nowrap"><span style="margin:0 0.5em"><a href="/wiki/File:Flag_of_the_United_States.svg" class="image"><img alt="Flag of the United States.svg" src="//upload.wikimedia.org/wikipedia/en/thumb/a/a4/Flag_of_the_United_States.svg/24px-Flag_of_the_United_States.svg.png" decoding="async" width="24" height="13" srcset="//upload.wikimedia.org/wikipedia/en/thumb/a/a4/Flag_of_the_United_States.svg/36px-Flag_of_the_United_States.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/a/a4/Flag_of_the_United_States.svg/48px-Flag_of_the_United_States.svg.png 2x" data-file-width="1235" data-file-height="650" /></a></span><a href="/wiki/Portal:United_States" title="Portal:United States">United States portal</a></span></li></ul></div>
<div role="navigation" class="navbox authority-control" aria-labelledby="Authority_control_frameless_&amp;#124;text-top_&amp;#124;10px_&amp;#124;alt=Edit_this_at_Wikidata_&amp;#124;link=https&amp;#58;//www.wikidata.org/wiki/Q937#identifiers&amp;#124;Edit_this_at_Wikidata" style="padding:3px"><table class="nowraplinks hlist navbox-inner" style="border-spacing:0;background:transparent;color:inherit"><tbody><tr><th id="Authority_control_frameless_&amp;#124;text-top_&amp;#124;10px_&amp;#124;alt=Edit_this_at_Wikidata_&amp;#124;link=https&amp;#58;//www.wikidata.org/wiki/Q937#identifiers&amp;#124;Edit_this_at_Wikidata" scope="row" class="navbox-group" style="width:1%"><a href="/wiki/Help:Authority_control" title="Help:Authority control">Authority control</a> <a href="https://www.wikidata.org/wiki/Q937#identifiers" title="Edit this at Wikidata"><img alt="Edit this at Wikidata" src="//upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/10px-OOjs_UI_icon_edit-ltr-progressive.svg.png" decoding="async" width="10" height="10" style="vertical-align: text-top" srcset="//upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/15px-OOjs_UI_icon_edit-ltr-progressive.svg.png 1.5x, //upload.wikimedia.org/wikipedia/en/thumb/8/8a/OOjs_UI_icon_edit-ltr-progressive.svg/20px-OOjs_UI_icon_edit-ltr-progressive.svg.png 2x" data-file-width="20" data-file-height="20" /></a></th><td class="navbox-list navbox-odd" style="text-align:left;border-left-width:2px;border-left-style:solid;width:100%;padding:0px"><div style="padding:0em 0.25em">
<ul><li><span class="nowrap"><a href="/wiki/BIBSYS_(identifier)" class="mw-redirect" title="BIBSYS (identifier)">BIBSYS</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://authority.bibsys.no/authority/rest/authorities/html/90053072">90053072</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/BNC_(identifier)" class="mw-redirect" title="BNC (identifier)">BNC</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://www.bncatalogo.cl/F?func=direct&amp;local_base=red10&amp;doc_number=000034649">000034649</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/BNE_(identifier)" class="mw-redirect" title="BNE (identifier)">BNE</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://catalogo.bne.es/uhtbin/authoritybrowse.cgi?action=display&amp;authority_id=XX834035">XX834035</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/BNF_(identifier)" class="mw-redirect" title="BNF (identifier)">BNF</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://catalogue.bnf.fr/ark:/12148/cb119016075">cb119016075</a> <a rel="nofollow" class="external text" href="https://data.bnf.fr/ark:/12148/cb119016075">(data)</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/CANTIC_(identifier)" class="mw-redirect" title="CANTIC (identifier)">CANTIC</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://cantic.bnc.cat/registres/CUCId/a10077078">a10077078</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/CiNii_(identifier)" class="mw-redirect" title="CiNii (identifier)">CiNii</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://ci.nii.ac.jp/author/DA00708434?l=en">DA00708434</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/GND_(identifier)" class="mw-redirect" title="GND (identifier)">GND</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://d-nb.info/gnd/118529579">118529579</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/HDS_(identifier)" class="mw-redirect" title="HDS (identifier)">HDS</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://hls-dhs-dss.ch/fr/articles/028814">028814</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/ICCU_(identifier)" class="mw-redirect" title="ICCU (identifier)">ICCU</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://opac.sbn.it/opacsbn/opac/iccu/scheda_authority.jsp?bid=IT\\ICCU\\CFIV\\035853">IT\\ICCU\\CFIV\\035853</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/ISNI_(identifier)" class="mw-redirect" title="ISNI (identifier)">ISNI</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://isni.org/isni/000000012281955X">0000 0001 2281 955X</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/LCCN_(identifier)" class="mw-redirect" title="LCCN (identifier)">LCCN</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://id.loc.gov/authorities/names/n79022889">n79022889</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/LNB_(identifier)" class="mw-redirect" title="LNB (identifier)">LNB</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://kopkatalogs.lv/F?func=direct&amp;local_base=lnc10&amp;doc_number=000027126&amp;P_CON_LNG=ENG">000027126</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/MBA_(identifier)" class="mw-redirect" title="MBA (identifier)">MBA</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://musicbrainz.org/artist/c98c325e-7277-46e8-8b44-e3517f3e041a">c98c325e-7277-46e8-8b44-e3517f3e041a</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/MGP_(identifier)" class="mw-redirect" title="MGP (identifier)">MGP</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://genealogy.math.ndsu.nodak.edu/id.php?id=53269">53269</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NARA_(identifier)" class="mw-redirect" title="NARA (identifier)">NARA</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://catalog.archives.gov/id/10582637">10582637</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NCL_(identifier)" class="mw-redirect" title="NCL (identifier)">NBL</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://aleweb.ncl.edu.tw/F/?func=accref&amp;acc_sequence=369710&amp;CON_LNG=ENG">369710</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NDL_(identifier)" class="mw-redirect" title="NDL (identifier)">NDL</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://id.ndl.go.jp/auth/ndlna/00438728">00438728</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NKC_(identifier)" class="mw-redirect" title="NKC (identifier)">NKC</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://aleph.nkp.cz/F/?func=find-c&amp;local_base=aut&amp;ccl_term=ica=jn19990002019&amp;CON_LNG=ENG">jn19990002019</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLA_(identifier)" class="mw-redirect" title="NLA (identifier)">NLA</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://nla.gov.au/anbd.aut-an36582360">36582360</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLG_(identifier)" class="mw-redirect" title="NLG (identifier)">NLG</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://data.nlg.gr/resource/authority/record76370">76370</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLI_(identifier)" class="mw-redirect" title="NLI (identifier)">NLI</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://uli.nli.org.il/F/?func=direct&amp;doc_number=000042773&amp;local_base=nlx10">000042773</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLK_(identifier)" class="mw-redirect" title="NLK (identifier)">NLK</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://nl.go.kr/authorities/resource/KAC200103196">KAC200103196</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLP_(identifier)" class="mw-redirect" title="NLP (identifier)">NLP</a>: <span class="uid"><a class="external text" href="https://tools.wmflabs.org/wikidata-externalid-url?p=1695&amp;id=A11787673">A11787673</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NLR_(identifier)" class="mw-redirect" title="NLR (identifier)">NLR</a>: <span class="uid"><a rel="nofollow" class="external autonumber" href="http://aleph.bibnat.ro:8991/F/?func=direct&amp;local_base=NLR10&amp;doc_number=000074139">[1]</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NSK_(identifier)" class="mw-redirect" title="NSK (identifier)">NSK</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://katalog.nsk.hr/F/?func=direct&amp;doc_number=000012537&amp;local_base=nsk10">000012537</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/NTA_(identifier)" class="mw-redirect" title="NTA (identifier)">NTA</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://data.bibliotheken.nl/id/thes/p068350767">068350767</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/PLWABN_(identifier)" class="mw-redirect" title="PLWABN (identifier)">PLWABN</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://mak.bn.org.pl/cgi-bin/KHW/makwww.exe?BM=1&amp;NU=1&amp;IM=4&amp;WI=9810646540205606">9810646540205606</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/RERO_(identifier)" class="mw-redirect" title="RERO (identifier)">RERO</a>: <span class="uid"><a rel="nofollow" class="external text" href="http://data.rero.ch/02-A003212458">02-A003212458</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/SELIBR_(identifier)" class="mw-redirect" title="SELIBR (identifier)">SELIBR</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://libris.kb.se/auth/184709">184709</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/SNAC-ID_(identifier)" class="mw-redirect" title="SNAC-ID (identifier)">SNAC</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://snaccooperative.org/ark:/99166/w63c6p77">w63c6p77</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/SUDOC_(identifier)" class="mw-redirect" title="SUDOC (identifier)">SUDOC</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://www.idref.fr/026849186">026849186</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/Trove_(identifier)" class="mw-redirect" title="Trove (identifier)">Trove</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://trove.nla.gov.au/people/382451">382451</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/ULAN_(identifier)" class="mw-redirect" title="ULAN (identifier)">ULAN</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://www.getty.edu/vow/ULANFullDisplay?find=&amp;role=&amp;nation=&amp;subjectid=500240971">500240971</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/VcBA_(identifier)" class="mw-redirect" title="VcBA (identifier)">VcBA</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://opac.vatlib.it/auth/detail/495_91752">495/91752</a></span></span></li>
<li><span class="nowrap"><a href="/wiki/VIAF_(identifier)" class="mw-redirect" title="VIAF (identifier)">VIAF</a>: <span class="uid"><a rel="nofollow" class="external text" href="https://viaf.org/viaf/75121530">75121530</a></span></span></li>
<li><span class="nowrap"> <a href="/wiki/WorldCat_Identities_(identifier)" class="mw-redirect" title="WorldCat Identities (identifier)">WorldCat Identities</a>: <a rel="nofollow" class="external text" href="https://www.worldcat.org/identities/lccn-n79022889">lccn-n79022889</a></span></li></ul>
</div></td></tr></tbody></table></div>
<!-- 
NewPP limit report
Parsed by mw1290
Cached time: 20210404015308
Cache expiry: 21600
Dynamic content: true
Complications: [vary‐revision‐sha1]
CPU time usage: 4.116 seconds
Real time usage: 4.718 seconds
Preprocessor visited node count: 19367/1000000
Post‐expand include size: 672424/2097152 bytes
Template argument size: 35019/2097152 bytes
Highest expansion depth: 24/40
Expensive parser function count: 58/500
Unstrip recursion depth: 1/20
Unstrip post‐expand size: 682462/5000000 bytes
Lua time usage: 2.283/10.000 seconds
Lua memory usage: 32088388/52428800 bytes
Lua Profile:
    ?                                                                440 ms       18.2%
    Scribunto_LuaSandboxCallback::callParserFunction                 420 ms       17.4%
    recursiveClone <mwInit.lua:41>                                   220 ms        9.1%
    dataWrapper <mw.lua:668>                                         160 ms        6.6%
    Scribunto_LuaSandboxCallback::getExpandedArgument                160 ms        6.6%
    Scribunto_LuaSandboxCallback::getEntity                          120 ms        5.0%
    Scribunto_LuaSandboxCallback::gsub                               120 ms        5.0%
    Scribunto_LuaSandboxCallback::match                              100 ms        4.1%
    Scribunto_LuaSandboxCallback::plain                               60 ms        2.5%
    (for generator)                                                   60 ms        2.5%
    [others]                                                         560 ms       23.1%
Number of Wikibase entities loaded: 1/400
-->
<!--
Transclusion expansion time report (%,ms,calls,template)
100.00% 3878.805      1 -total
 27.97% 1084.879      2 Template:Reflist
 19.79%  767.444      1 Template:Infobox_scientist
 19.35%  750.504      1 Template:Infobox_person
 18.85%  731.033      2 Template:Infobox
 11.60%  449.992    131 Template:Sfnp
  9.97%  386.901     52 Template:Cite_journal
  9.40%  364.679     65 Template:Cite_book
  7.40%  286.941     60 Template:Cite_web
  6.95%  269.611      5 Template:If_empty
-->

<!-- Saved in parser cache with key enwiki:pcache:idhash:736-0!canonical and timestamp 20210404015303 and revision id 1015872965. Serialized with JSON.
 -->
</div><noscript><img src="//en.wikipedia.org/wiki/Special:CentralAutoLogin/start?type=1x1" alt="" title="" width="1" height="1" style="border: none; position: absolute;" /></noscript>
<div class="printfooter">Retrieved from "<a dir="ltr" href="https://en.wikipedia.org/w/index.php?title=Albert_Einstein&amp;oldid=1015872965">https://en.wikipedia.org/w/index.php?title=Albert_Einstein&amp;oldid=1015872965</a>"</div></div>
		<div id="catlinks" class="catlinks" data-mw="interface"><div id="mw-normal-catlinks" class="mw-normal-catlinks"><a href="/wiki/Help:Category" title="Help:Category">Categories</a>: <ul><li><a href="/wiki/Category:Albert_Einstein" title="Category:Albert Einstein">Albert Einstein</a></li><li><a href="/wiki/Category:1879_births" title="Category:1879 births">1879 births</a></li><li><a href="/wiki/Category:1955_deaths" title="Category:1955 deaths">1955 deaths</a></li><li><a href="/wiki/Category:20th-century_American_engineers" title="Category:20th-century American engineers">20th-century American engineers</a></li><li><a href="/wiki/Category:20th-century_American_physicists" title="Category:20th-century American physicists">20th-century American physicists</a></li><li><a href="/wiki/Category:20th-century_American_writers" title="Category:20th-century American writers">20th-century American writers</a></li><li><a href="/wiki/Category:20th-century_German_physicists" title="Category:20th-century German physicists">20th-century German physicists</a></li><li><a href="/wiki/Category:Activists_from_New_Jersey" title="Category:Activists from New Jersey">Activists from New Jersey</a></li><li><a href="/wiki/Category:American_agnostics" title="Category:American agnostics">American agnostics</a></li><li><a href="/wiki/Category:American_anti-capitalists" title="Category:American anti-capitalists">American anti-capitalists</a></li><li><a href="/wiki/Category:American_humanists" title="Category:American humanists">American humanists</a></li><li><a href="/wiki/Category:American_inventors" title="Category:American inventors">American inventors</a></li><li><a href="/wiki/Category:American_letter_writers" title="Category:American letter writers">American letter writers</a></li><li><a href="/wiki/Category:American_Nobel_laureates" title="Category:American Nobel laureates">American Nobel laureates</a></li><li><a href="/wiki/Category:American_pacifists" title="Category:American pacifists">American pacifists</a></li><li><a href="/wiki/Category:American_relativity_theorists" title="Category:American relativity theorists">American relativity theorists</a></li><li><a href="/wiki/Category:American_science_writers" title="Category:American science writers">American science writers</a></li><li><a href="/wiki/Category:American_socialists" title="Category:American socialists">American socialists</a></li><li><a href="/wiki/Category:American_Zionists" title="Category:American Zionists">American Zionists</a></li><li><a href="/wiki/Category:Ashkenazi_Jews" title="Category:Ashkenazi Jews">Ashkenazi Jews</a></li><li><a href="/wiki/Category:Charles_University_faculty" title="Category:Charles University faculty">Charles University faculty</a></li><li><a href="/wiki/Category:Corresponding_Members_of_the_Russian_Academy_of_Sciences_(1917%E2%80%931925)" title="Category:Corresponding Members of the Russian Academy of Sciences (1917–1925)">Corresponding Members of the Russian Academy of Sciences (1917–1925)</a></li><li><a href="/wiki/Category:Cosmologists" title="Category:Cosmologists">Cosmologists</a></li><li><a href="/wiki/Category:Deaths_from_abdominal_aortic_aneurysm" title="Category:Deaths from abdominal aortic aneurysm">Deaths from abdominal aortic aneurysm</a></li><li><a href="/wiki/Category:Determinists" title="Category:Determinists">Determinists</a></li><li><a href="/wiki/Category:Disease-related_deaths_in_New_Jersey" title="Category:Disease-related deaths in New Jersey">Disease-related deaths in New Jersey</a></li><li><a href="/wiki/Category:Einstein_family" title="Category:Einstein family">Einstein family</a></li><li><a href="/wiki/Category:ETH_Zurich_alumni" title="Category:ETH Zurich alumni">ETH Zurich alumni</a></li><li><a href="/wiki/Category:ETH_Zurich_faculty" title="Category:ETH Zurich faculty">ETH Zurich faculty</a></li><li><a href="/wiki/Category:European_democratic_socialists" title="Category:European democratic socialists">European democratic socialists</a></li><li><a href="/wiki/Category:Foreign_associates_of_the_National_Academy_of_Sciences" title="Category:Foreign associates of the National Academy of Sciences">Foreign associates of the National Academy of Sciences</a></li><li><a href="/wiki/Category:Foreign_Fellows_of_the_Indian_National_Science_Academy" title="Category:Foreign Fellows of the Indian National Science Academy">Foreign Fellows of the Indian National Science Academy</a></li><li><a href="/wiki/Category:Foreign_Members_of_the_Royal_Society" title="Category:Foreign Members of the Royal Society">Foreign Members of the Royal Society</a></li><li><a href="/wiki/Category:German_agnostics" title="Category:German agnostics">German agnostics</a></li><li><a href="/wiki/Category:German_anti-capitalists" title="Category:German anti-capitalists">German anti-capitalists</a></li><li><a href="/wiki/Category:German_emigrants_to_Switzerland" title="Category:German emigrants to Switzerland">German emigrants to Switzerland</a></li><li><a href="/wiki/Category:German_humanists" title="Category:German humanists">German humanists</a></li><li><a href="/wiki/Category:German_inventors" title="Category:German inventors">German inventors</a></li><li><a href="/wiki/Category:German_Jews" title="Category:German Jews">German Jews</a></li><li><a href="/wiki/Category:German_Nobel_laureates" title="Category:German Nobel laureates">German Nobel laureates</a></li><li><a href="/wiki/Category:German_relativity_theorists" title="Category:German relativity theorists">German relativity theorists</a></li><li><a href="/wiki/Category:German_socialists" title="Category:German socialists">German socialists</a></li><li><a href="/wiki/Category:Honorary_Members_of_the_USSR_Academy_of_Sciences" title="Category:Honorary Members of the USSR Academy of Sciences">Honorary Members of the USSR Academy of Sciences</a></li><li><a href="/wiki/Category:Institute_for_Advanced_Study_faculty" title="Category:Institute for Advanced Study faculty">Institute for Advanced Study faculty</a></li><li><a href="/wiki/Category:Jewish_agnostics" title="Category:Jewish agnostics">Jewish agnostics</a></li><li><a href="/wiki/Category:Jewish_American_physicists" title="Category:Jewish American physicists">Jewish American physicists</a></li><li><a href="/wiki/Category:Jewish_emigrants_from_Nazi_Germany_to_the_United_States" title="Category:Jewish emigrants from Nazi Germany to the United States">Jewish emigrants from Nazi Germany to the United States</a></li><li><a href="/wiki/Category:Jewish_inventors" title="Category:Jewish inventors">Jewish inventors</a></li><li><a href="/wiki/Category:Jewish_Nobel_laureates" title="Category:Jewish Nobel laureates">Jewish Nobel laureates</a></li><li><a href="/wiki/Category:Jewish_physicists" title="Category:Jewish physicists">Jewish physicists</a></li><li><a href="/wiki/Category:Jewish_socialists" title="Category:Jewish socialists">Jewish socialists</a></li><li><a href="/wiki/Category:Leiden_University_faculty" title="Category:Leiden University faculty">Leiden University faculty</a></li><li><a href="/wiki/Category:Mathematicians_involved_with_Mathematische_Annalen" title="Category:Mathematicians involved with Mathematische Annalen">Mathematicians involved with Mathematische Annalen</a></li><li><a href="/wiki/Category:Members_of_the_American_Philosophical_Society" title="Category:Members of the American Philosophical Society">Members of the American Philosophical Society</a></li><li><a href="/wiki/Category:Members_of_the_Bavarian_Academy_of_Sciences" title="Category:Members of the Bavarian Academy of Sciences">Members of the Bavarian Academy of Sciences</a></li><li><a href="/wiki/Category:Members_of_the_Lincean_Academy" title="Category:Members of the Lincean Academy">Members of the Lincean Academy</a></li><li><a href="/wiki/Category:Members_of_the_Royal_Netherlands_Academy_of_Arts_and_Sciences" title="Category:Members of the Royal Netherlands Academy of Arts and Sciences">Members of the Royal Netherlands Academy of Arts and Sciences</a></li><li><a href="/wiki/Category:Members_of_the_United_States_National_Academy_of_Sciences" title="Category:Members of the United States National Academy of Sciences">Members of the United States National Academy of Sciences</a></li><li><a href="/wiki/Category:Naturalised_citizens_of_Austria" title="Category:Naturalised citizens of Austria">Naturalised citizens of Austria</a></li><li><a href="/wiki/Category:Naturalised_citizens_of_Switzerland" title="Category:Naturalised citizens of Switzerland">Naturalised citizens of Switzerland</a></li><li><a href="/wiki/Category:Naturalized_citizens_of_the_United_States" title="Category:Naturalized citizens of the United States">Naturalized citizens of the United States</a></li><li><a href="/wiki/Category:New_Jersey_socialists" title="Category:New Jersey socialists">New Jersey socialists</a></li><li><a href="/wiki/Category:Nobel_laureates_in_Physics" title="Category:Nobel laureates in Physics">Nobel laureates in Physics</a></li><li><a href="/wiki/Category:Pantheists" title="Category:Pantheists">Pantheists</a></li><li><a href="/wiki/Category:Patent_examiners" title="Category:Patent examiners">Patent examiners</a></li><li><a href="/wiki/Category:People_from_Princeton,_New_Jersey" title="Category:People from Princeton, New Jersey">People from Princeton, New Jersey</a></li><li><a href="/wiki/Category:People_who_lost_German_citizenship" title="Category:People who lost German citizenship">People who lost German citizenship</a></li><li><a href="/wiki/Category:Philosophers_of_mathematics" title="Category:Philosophers of mathematics">Philosophers of mathematics</a></li><li><a href="/wiki/Category:Philosophers_of_science" title="Category:Philosophers of science">Philosophers of science</a></li><li><a href="/wiki/Category:Philosophy_of_science" title="Category:Philosophy of science">Philosophy of science</a></li><li><a href="/wiki/Category:Quantum_physicists" title="Category:Quantum physicists">Quantum physicists</a></li><li><a href="/wiki/Category:Recipients_of_the_Gold_Medal_of_the_Royal_Astronomical_Society" title="Category:Recipients of the Gold Medal of the Royal Astronomical Society">Recipients of the Gold Medal of the Royal Astronomical Society</a></li><li><a href="/wiki/Category:Recipients_of_the_Pour_le_M%C3%A9rite_(civil_class)" title="Category:Recipients of the Pour le Mérite (civil class)">Recipients of the Pour le Mérite (civil class)</a></li><li><a href="/wiki/Category:Scientists_from_Munich" title="Category:Scientists from Munich">Scientists from Munich</a></li><li><a href="/wiki/Category:Spinozists" title="Category:Spinozists">Spinozists</a></li><li><a href="/wiki/Category:Stateless_people" title="Category:Stateless people">Stateless people</a></li><li><a href="/wiki/Category:Swiss_agnostics" title="Category:Swiss agnostics">Swiss agnostics</a></li><li><a href="/wiki/Category:Swiss_emigrants_to_the_United_States" title="Category:Swiss emigrants to the United States">Swiss emigrants to the United States</a></li><li><a href="/wiki/Category:Swiss_Jews" title="Category:Swiss Jews">Swiss Jews</a></li><li><a href="/wiki/Category:Swiss_physicists" title="Category:Swiss physicists">Swiss physicists</a></li><li><a href="/wiki/Category:Winners_of_the_Max_Planck_Medal" title="Category:Winners of the Max Planck Medal">Winners of the Max Planck Medal</a></li><li><a href="/wiki/Category:World_federalists" title="Category:World federalists">World federalists</a></li></ul></div><div id="mw-hidden-catlinks" class="mw-hidden-catlinks mw-hidden-cats-hidden">Hidden categories: <ul><li><a href="/wiki/Category:Webarchive_template_wayback_links" title="Category:Webarchive template wayback links">Webarchive template wayback links</a></li><li><a href="/wiki/Category:CS1_German-language_sources_(de)" title="Category:CS1 German-language sources (de)">CS1 German-language sources (de)</a></li><li><a href="/wiki/Category:Wikipedia_articles_needing_page_number_citations_from_November_2020" title="Category:Wikipedia articles needing page number citations from November 2020">Wikipedia articles needing page number citations from November 2020</a></li><li><a href="/wiki/Category:CS1:_Julian%E2%80%93Gregorian_uncertainty" title="Category:CS1: Julian–Gregorian uncertainty">CS1: Julian–Gregorian uncertainty</a></li><li><a href="/wiki/Category:CS1_French-language_sources_(fr)" title="Category:CS1 French-language sources (fr)">CS1 French-language sources (fr)</a></li><li><a href="/wiki/Category:CS1_location_test" title="Category:CS1 location test">CS1 location test</a></li><li><a href="/wiki/Category:Wikipedia_indefinitely_semi-protected_pages" title="Category:Wikipedia indefinitely semi-protected pages">Wikipedia indefinitely semi-protected pages</a></li><li><a href="/wiki/Category:Use_American_English_from_April_2020" title="Category:Use American English from April 2020">Use American English from April 2020</a></li><li><a href="/wiki/Category:All_Wikipedia_articles_written_in_American_English" title="Category:All Wikipedia articles written in American English">All Wikipedia articles written in American English</a></li><li><a href="/wiki/Category:Articles_with_short_description" title="Category:Articles with short description">Articles with short description</a></li><li><a href="/wiki/Category:Short_description_is_different_from_Wikidata" title="Category:Short description is different from Wikidata">Short description is different from Wikidata</a></li><li><a href="/wiki/Category:Use_dmy_dates_from_March_2021" title="Category:Use dmy dates from March 2021">Use dmy dates from March 2021</a></li><li><a href="/wiki/Category:Articles_containing_German-language_text" title="Category:Articles containing German-language text">Articles containing German-language text</a></li><li><a href="/wiki/Category:Biography_with_signature" title="Category:Biography with signature">Biography with signature</a></li><li><a href="/wiki/Category:Articles_with_hCards" title="Category:Articles with hCards">Articles with hCards</a></li><li><a href="/wiki/Category:Articles_with_hAudio_microformats" title="Category:Articles with hAudio microformats">Articles with hAudio microformats</a></li><li><a href="/wiki/Category:Wikipedia_articles_needing_clarification_from_September_2020" title="Category:Wikipedia articles needing clarification from September 2020">Wikipedia articles needing clarification from September 2020</a></li><li><a href="/wiki/Category:All_articles_with_unsourced_statements" title="Category:All articles with unsourced statements">All articles with unsourced statements</a></li><li><a href="/wiki/Category:Articles_with_unsourced_statements_from_April_2020" title="Category:Articles with unsourced statements from April 2020">Articles with unsourced statements from April 2020</a></li><li><a href="/wiki/Category:Wikipedia_articles_incorporating_a_citation_from_the_1922_Encyclopaedia_Britannica_with_Wikisource_reference" title="Category:Wikipedia articles incorporating a citation from the 1922 Encyclopaedia Britannica with Wikisource reference">Wikipedia articles incorporating a citation from the 1922 Encyclopaedia Britannica with Wikisource reference</a></li><li><a href="/wiki/Category:Pages_using_Sister_project_links_with_hidden_wikidata" title="Category:Pages using Sister project links with hidden wikidata">Pages using Sister project links with hidden wikidata</a></li><li><a href="/wiki/Category:Articles_with_Curlie_links" title="Category:Articles with Curlie links">Articles with Curlie links</a></li><li><a href="/wiki/Category:Articles_with_Project_Gutenberg_links" title="Category:Articles with Project Gutenberg links">Articles with Project Gutenberg links</a></li><li><a href="/wiki/Category:Articles_with_Internet_Archive_links" title="Category:Articles with Internet Archive links">Articles with Internet Archive links</a></li><li><a href="/wiki/Category:Articles_with_LibriVox_links" title="Category:Articles with LibriVox links">Articles with LibriVox links</a></li><li><a href="/wiki/Category:Nobelprize_template_using_Wikidata_property_P8024" title="Category:Nobelprize template using Wikidata property P8024">Nobelprize template using Wikidata property P8024</a></li><li><a href="/wiki/Category:Good_articles" title="Category:Good articles">Good articles</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_BIBSYS_identifiers" title="Category:Wikipedia articles with BIBSYS identifiers">Wikipedia articles with BIBSYS identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_BNC_identifiers" title="Category:Wikipedia articles with BNC identifiers">Wikipedia articles with BNC identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_BNE_identifiers" title="Category:Wikipedia articles with BNE identifiers">Wikipedia articles with BNE identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_BNF_identifiers" title="Category:Wikipedia articles with BNF identifiers">Wikipedia articles with BNF identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_CANTIC_identifiers" title="Category:Wikipedia articles with CANTIC identifiers">Wikipedia articles with CANTIC identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_CINII_identifiers" title="Category:Wikipedia articles with CINII identifiers">Wikipedia articles with CINII identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_GND_identifiers" title="Category:Wikipedia articles with GND identifiers">Wikipedia articles with GND identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_HDS_identifiers" title="Category:Wikipedia articles with HDS identifiers">Wikipedia articles with HDS identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_ICCU_identifiers" title="Category:Wikipedia articles with ICCU identifiers">Wikipedia articles with ICCU identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_ISNI_identifiers" title="Category:Wikipedia articles with ISNI identifiers">Wikipedia articles with ISNI identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_LCCN_identifiers" title="Category:Wikipedia articles with LCCN identifiers">Wikipedia articles with LCCN identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_LNB_identifiers" title="Category:Wikipedia articles with LNB identifiers">Wikipedia articles with LNB identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_MusicBrainz_identifiers" title="Category:Wikipedia articles with MusicBrainz identifiers">Wikipedia articles with MusicBrainz identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_MGP_identifiers" title="Category:Wikipedia articles with MGP identifiers">Wikipedia articles with MGP identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NARA_identifiers" title="Category:Wikipedia articles with NARA identifiers">Wikipedia articles with NARA identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NCL_identifiers" title="Category:Wikipedia articles with NCL identifiers">Wikipedia articles with NCL identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NDL_identifiers" title="Category:Wikipedia articles with NDL identifiers">Wikipedia articles with NDL identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NKC_identifiers" title="Category:Wikipedia articles with NKC identifiers">Wikipedia articles with NKC identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLA_identifiers" title="Category:Wikipedia articles with NLA identifiers">Wikipedia articles with NLA identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLG_identifiers" title="Category:Wikipedia articles with NLG identifiers">Wikipedia articles with NLG identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLI_identifiers" title="Category:Wikipedia articles with NLI identifiers">Wikipedia articles with NLI identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLK_identifiers" title="Category:Wikipedia articles with NLK identifiers">Wikipedia articles with NLK identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLP_identifiers" title="Category:Wikipedia articles with NLP identifiers">Wikipedia articles with NLP identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NLR_identifiers" title="Category:Wikipedia articles with NLR identifiers">Wikipedia articles with NLR identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NSK_identifiers" title="Category:Wikipedia articles with NSK identifiers">Wikipedia articles with NSK identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_NTA_identifiers" title="Category:Wikipedia articles with NTA identifiers">Wikipedia articles with NTA identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_PLWABN_identifiers" title="Category:Wikipedia articles with PLWABN identifiers">Wikipedia articles with PLWABN identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_RERO_identifiers" title="Category:Wikipedia articles with RERO identifiers">Wikipedia articles with RERO identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_SELIBR_identifiers" title="Category:Wikipedia articles with SELIBR identifiers">Wikipedia articles with SELIBR identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_SNAC-ID_identifiers" title="Category:Wikipedia articles with SNAC-ID identifiers">Wikipedia articles with SNAC-ID identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_SUDOC_identifiers" title="Category:Wikipedia articles with SUDOC identifiers">Wikipedia articles with SUDOC identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_Trove_identifiers" title="Category:Wikipedia articles with Trove identifiers">Wikipedia articles with Trove identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_ULAN_identifiers" title="Category:Wikipedia articles with ULAN identifiers">Wikipedia articles with ULAN identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_VcBA_identifiers" title="Category:Wikipedia articles with VcBA identifiers">Wikipedia articles with VcBA identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_VIAF_identifiers" title="Category:Wikipedia articles with VIAF identifiers">Wikipedia articles with VIAF identifiers</a></li><li><a href="/wiki/Category:Wikipedia_articles_with_WORLDCATID_identifiers" title="Category:Wikipedia articles with WORLDCATID identifiers">Wikipedia articles with WORLDCATID identifiers</a></li><li><a href="/wiki/Category:AC_with_35_elements" title="Category:AC with 35 elements">AC with 35 elements</a></li><li><a href="/wiki/Category:Articles_containing_timelines" title="Category:Articles containing timelines">Articles containing timelines</a></li></ul></div></div>
	</div>
</div>
<div id=\'mw-data-after-content\'>
	<div class="read-more-container"></div>
</div>

<div id="mw-navigation">
	<h2>Navigation menu</h2>
	<div id="mw-head">
		<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-personal" class="mw-portlet mw-portlet-personal vector-menu" aria-labelledby="p-personal-label" role="navigation" 
	 >
	<h3 id="p-personal-label" class="vector-menu-heading">
		<span>Personal tools</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="pt-anonuserpage">Not logged in</li><li id="pt-anontalk"><a href="/wiki/Special:MyTalk" title="Discussion about edits from this IP address [n]" accesskey="n">Talk</a></li><li id="pt-anoncontribs"><a href="/wiki/Special:MyContributions" title="A list of edits made from this IP address [y]" accesskey="y">Contributions</a></li><li id="pt-createaccount"><a href="/w/index.php?title=Special:CreateAccount&amp;returnto=Albert+Einstein" title="You are encouraged to create an account and log in; however, it is not mandatory">Create account</a></li><li id="pt-login"><a href="/w/index.php?title=Special:UserLogin&amp;returnto=Albert+Einstein" title="You&#039;re encouraged to log in; however, it&#039;s not mandatory. [o]" accesskey="o">Log in</a></li></ul>
		
	</div>
</nav>

		<div id="left-navigation">
			<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-namespaces" class="mw-portlet mw-portlet-namespaces vector-menu vector-menu-tabs" aria-labelledby="p-namespaces-label" role="navigation" 
	 >
	<h3 id="p-namespaces-label" class="vector-menu-heading">
		<span>Namespaces</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="ca-nstab-main" class="selected"><a href="/wiki/Albert_Einstein" title="View the content page [c]" accesskey="c">Article</a></li><li id="ca-talk"><a href="/wiki/Talk:Albert_Einstein" rel="discussion" title="Discuss improvements to the content page [t]" accesskey="t">Talk</a></li></ul>
		
	</div>
</nav>

			<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-variants" class="mw-portlet mw-portlet-variants emptyPortlet vector-menu vector-menu-dropdown" aria-labelledby="p-variants-label" role="navigation" 
	 >
	<input type="checkbox" class="vector-menu-checkbox" aria-labelledby="p-variants-label" />
	<h3 id="p-variants-label" class="vector-menu-heading">
		<span>Variants</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"></ul>
		
	</div>
</nav>

		</div>
		<div id="right-navigation">
			<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-views" class="mw-portlet mw-portlet-views vector-menu vector-menu-tabs" aria-labelledby="p-views-label" role="navigation" 
	 >
	<h3 id="p-views-label" class="vector-menu-heading">
		<span>Views</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="ca-view" class="selected"><a href="/wiki/Albert_Einstein">Read</a></li><li id="ca-viewsource"><a href="/w/index.php?title=Albert_Einstein&amp;action=edit" title="This page is protected.&#10;You can view its source [e]" accesskey="e">View source</a></li><li id="ca-history"><a href="/w/index.php?title=Albert_Einstein&amp;action=history" title="Past revisions of this page [h]" accesskey="h">View history</a></li></ul>
		
	</div>
</nav>

			<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-cactions" class="mw-portlet mw-portlet-cactions emptyPortlet vector-menu vector-menu-dropdown" aria-labelledby="p-cactions-label" role="navigation" 
	 >
	<input type="checkbox" class="vector-menu-checkbox" aria-labelledby="p-cactions-label" />
	<h3 id="p-cactions-label" class="vector-menu-heading">
		<span>More</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"></ul>
		
	</div>
</nav>

			<div id="p-search" role="search" >
	<h3 >
		<label for="searchInput">Search</label>
	</h3>
	<form action="/w/index.php" id="searchform">
		<div id="simpleSearch" data-search-loc="header-navigation">
			<input type="search" name="search" placeholder="Search Wikipedia" autocapitalize="sentences" title="Search Wikipedia [f]" accesskey="f" id="searchInput"/>
			<input type="hidden" name="title" value="Special:Search"/>
			<input type="submit" name="fulltext" value="Search" title="Search Wikipedia for this text" id="mw-searchButton" class="searchButton mw-fallbackSearchButton"/>
			<input type="submit" name="go" value="Go" title="Go to a page with this exact name if it exists" id="searchButton" class="searchButton"/>
		</div>
	</form>
</div>

		</div>
	</div>
	
<div id="mw-panel">
	<div id="p-logo" role="banner">
		<a class="mw-wiki-logo" href="/wiki/Main_Page"
			title="Visit the main page"></a>
	</div>
	<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-navigation" class="mw-portlet mw-portlet-navigation vector-menu vector-menu-portal portal" aria-labelledby="p-navigation-label" role="navigation" 
	 >
	<h3 id="p-navigation-label" class="vector-menu-heading">
		<span>Navigation</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="n-mainpage-description"><a href="/wiki/Main_Page" title="Visit the main page [z]" accesskey="z">Main page</a></li><li id="n-contents"><a href="/wiki/Wikipedia:Contents" title="Guides to browsing Wikipedia">Contents</a></li><li id="n-currentevents"><a href="/wiki/Portal:Current_events" title="Articles related to current events">Current events</a></li><li id="n-randompage"><a href="/wiki/Special:Random" title="Visit a randomly selected article [x]" accesskey="x">Random article</a></li><li id="n-aboutsite"><a href="/wiki/Wikipedia:About" title="Learn about Wikipedia and how it works">About Wikipedia</a></li><li id="n-contactpage"><a href="//en.wikipedia.org/wiki/Wikipedia:Contact_us" title="How to contact Wikipedia">Contact us</a></li><li id="n-sitesupport"><a href="https://donate.wikimedia.org/wiki/Special:FundraiserRedirector?utm_source=donate&amp;utm_medium=sidebar&amp;utm_campaign=C13_en.wikipedia.org&amp;uselang=en" title="Support us by donating to the Wikimedia Foundation">Donate</a></li></ul>
		
	</div>
</nav>

	<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-interaction" class="mw-portlet mw-portlet-interaction vector-menu vector-menu-portal portal" aria-labelledby="p-interaction-label" role="navigation" 
	 >
	<h3 id="p-interaction-label" class="vector-menu-heading">
		<span>Contribute</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="n-help"><a href="/wiki/Help:Contents" title="Guidance on how to use and edit Wikipedia">Help</a></li><li id="n-introduction"><a href="/wiki/Help:Introduction" title="Learn how to edit Wikipedia">Learn to edit</a></li><li id="n-portal"><a href="/wiki/Wikipedia:Community_portal" title="The hub for editors">Community portal</a></li><li id="n-recentchanges"><a href="/wiki/Special:RecentChanges" title="A list of recent changes to Wikipedia [r]" accesskey="r">Recent changes</a></li><li id="n-upload"><a href="/wiki/Wikipedia:File_Upload_Wizard" title="Add images or other media for use on Wikipedia">Upload file</a></li></ul>
		
	</div>
</nav>
<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-tb" class="mw-portlet mw-portlet-tb vector-menu vector-menu-portal portal" aria-labelledby="p-tb-label" role="navigation" 
	 >
	<h3 id="p-tb-label" class="vector-menu-heading">
		<span>Tools</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="t-whatlinkshere"><a href="/wiki/Special:WhatLinksHere/Albert_Einstein" title="List of all English Wikipedia pages containing links to this page [j]" accesskey="j">What links here</a></li><li id="t-recentchangeslinked"><a href="/wiki/Special:RecentChangesLinked/Albert_Einstein" rel="nofollow" title="Recent changes in pages linked from this page [k]" accesskey="k">Related changes</a></li><li id="t-upload"><a href="/wiki/Wikipedia:File_Upload_Wizard" title="Upload files [u]" accesskey="u">Upload file</a></li><li id="t-specialpages"><a href="/wiki/Special:SpecialPages" title="A list of all special pages [q]" accesskey="q">Special pages</a></li><li id="t-permalink"><a href="/w/index.php?title=Albert_Einstein&amp;oldid=1015872965" title="Permanent link to this revision of this page">Permanent link</a></li><li id="t-info"><a href="/w/index.php?title=Albert_Einstein&amp;action=info" title="More information about this page">Page information</a></li><li id="t-cite"><a href="/w/index.php?title=Special:CiteThisPage&amp;page=Albert_Einstein&amp;id=1015872965&amp;wpFormIdentifier=titleform" title="Information on how to cite this page">Cite this page</a></li><li id="t-wikibase"><a href="https://www.wikidata.org/wiki/Special:EntityPage/Q937" title="Structured data on this page hosted by Wikidata [g]" accesskey="g">Wikidata item</a></li></ul>
		
	</div>
</nav>
<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-coll-print_export" class="mw-portlet mw-portlet-coll-print_export vector-menu vector-menu-portal portal" aria-labelledby="p-coll-print_export-label" role="navigation" 
	 >
	<h3 id="p-coll-print_export-label" class="vector-menu-heading">
		<span>Print/export</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li id="coll-download-as-rl"><a href="/w/index.php?title=Special:DownloadAsPdf&amp;page=Albert_Einstein&amp;action=show-download-screen" title="Download this page as a PDF file">Download as PDF</a></li><li id="t-print"><a href="/w/index.php?title=Albert_Einstein&amp;printable=yes" title="Printable version of this page [p]" accesskey="p">Printable version</a></li></ul>
		
	</div>
</nav>
<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-wikibase-otherprojects" class="mw-portlet mw-portlet-wikibase-otherprojects vector-menu vector-menu-portal portal" aria-labelledby="p-wikibase-otherprojects-label" role="navigation" 
	 >
	<h3 id="p-wikibase-otherprojects-label" class="vector-menu-heading">
		<span>In other projects</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li class="wb-otherproject-link wb-otherproject-commons"><a href="https://commons.wikimedia.org/wiki/Category:Albert_Einstein" hreflang="en">Wikimedia Commons</a></li><li class="wb-otherproject-link wb-otherproject-wikiquote"><a href="https://en.wikiquote.org/wiki/Albert_Einstein" hreflang="en">Wikiquote</a></li><li class="wb-otherproject-link wb-otherproject-wikisource"><a href="https://en.wikisource.org/wiki/Author:Albert_Einstein" hreflang="en">Wikisource</a></li><li class="wb-otherproject-link wb-otherproject-wikiversity"><a href="https://en.wikiversity.org/wiki/Albert_Einstein" hreflang="en">Wikiversity</a></li></ul>
		
	</div>
</nav>

	<!-- Please do not use role attribute as CSS selector, it is deprecated. -->
<nav id="p-lang" class="mw-portlet mw-portlet-lang vector-menu vector-menu-portal portal" aria-labelledby="p-lang-label" role="navigation" 
	 >
	<h3 id="p-lang-label" class="vector-menu-heading">
		<span>Languages</span>
	</h3>
	<div class="vector-menu-content">
		<ul class="vector-menu-content-list"><li class="interlanguage-link interwiki-af"><a href="https://af.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Afrikaans" lang="af" hreflang="af" class="interlanguage-link-target">Afrikaans</a></li><li class="interlanguage-link interwiki-als"><a href="https://als.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Alemannisch" lang="gsw" hreflang="gsw" class="interlanguage-link-target">Alemannisch</a></li><li class="interlanguage-link interwiki-am"><a href="https://am.wikipedia.org/wiki/%E1%8A%A0%E1%88%8D%E1%89%A0%E1%88%AD%E1%89%B5_%E1%8A%A0%E1%8B%AD%E1%8A%95%E1%88%B5%E1%89%B3%E1%8B%AD%E1%8A%95" title="አልበርት አይንስታይን – Amharic" lang="am" hreflang="am" class="interlanguage-link-target">አማርኛ</a></li><li class="interlanguage-link interwiki-ang"><a href="https://ang.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Old English" lang="ang" hreflang="ang" class="interlanguage-link-target">Ænglisc</a></li><li class="interlanguage-link interwiki-ab"><a href="https://ab.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%95%D0%B8%D0%BD%D1%88%D1%82%D0%B5%D0%B8%D0%BD" title="Алберт Еинштеин – Abkhazian" lang="ab" hreflang="ab" class="interlanguage-link-target">Аҧсшәа</a></li><li class="interlanguage-link interwiki-ar badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://ar.wikipedia.org/wiki/%D8%A3%D9%84%D8%A8%D8%B1%D8%AA_%D8%A3%D9%8A%D9%86%D8%B4%D8%AA%D8%A7%D9%8A%D9%86" title="ألبرت أينشتاين – Arabic" lang="ar" hreflang="ar" class="interlanguage-link-target">العربية</a></li><li class="interlanguage-link interwiki-an badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://an.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Aragonese" lang="an" hreflang="an" class="interlanguage-link-target">Aragonés</a></li><li class="interlanguage-link interwiki-hyw"><a href="https://hyw.wikipedia.org/wiki/%D4%B1%D5%AC%D5%BA%D5%A5%D6%80%D5%A9_%D4%B1%D5%B5%D5%B6%D5%B7%D5%A9%D5%A1%D5%B5%D5%B6" title="Ալպերթ Այնշթայն – Western Armenian" lang="hyw" hreflang="hyw" class="interlanguage-link-target">Արեւմտահայերէն</a></li><li class="interlanguage-link interwiki-roa-rup"><a href="https://roa-rup.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Aromanian" lang="rup" hreflang="rup" class="interlanguage-link-target">Armãneashti</a></li><li class="interlanguage-link interwiki-frp"><a href="https://frp.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Arpitan" lang="frp" hreflang="frp" class="interlanguage-link-target">Arpetan</a></li><li class="interlanguage-link interwiki-as"><a href="https://as.wikipedia.org/wiki/%E0%A6%8F%E0%A6%B2%E0%A6%AC%E0%A6%BE%E0%A7%B0%E0%A7%8D%E0%A6%9F_%E0%A6%86%E0%A6%87%E0%A6%A8%E0%A6%B7%E0%A7%8D%E0%A6%9F%E0%A6%BE%E0%A6%87%E0%A6%A8" title="এলবাৰ্ট আইনষ্টাইন – Assamese" lang="as" hreflang="as" class="interlanguage-link-target">অসমীয়া</a></li><li class="interlanguage-link interwiki-ast"><a href="https://ast.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Asturian" lang="ast" hreflang="ast" class="interlanguage-link-target">Asturianu</a></li><li class="interlanguage-link interwiki-gn"><a href="https://gn.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Guarani" lang="gn" hreflang="gn" class="interlanguage-link-target">Avañe\'ẽ</a></li><li class="interlanguage-link interwiki-ay"><a href="https://ay.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Aymara" lang="ay" hreflang="ay" class="interlanguage-link-target">Aymar aru</a></li><li class="interlanguage-link interwiki-az"><a href="https://az.wikipedia.org/wiki/Albert_Eyn%C5%9Fteyn" title="Albert Eynşteyn – Azerbaijani" lang="az" hreflang="az" class="interlanguage-link-target">Azərbaycanca</a></li><li class="interlanguage-link interwiki-azb"><a href="https://azb.wikipedia.org/wiki/%D8%A2%D9%84%D8%A8%D8%B1%D8%AA_%D8%A2%DB%8C%D9%86%D8%B4%D8%AA%D8%A7%DB%8C%D9%86" title="آلبرت آینشتاین – South Azerbaijani" lang="azb" hreflang="azb" class="interlanguage-link-target">تۆرکجه</a></li><li class="interlanguage-link interwiki-ban"><a href="https://ban.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Balinese" lang="ban" hreflang="ban" class="interlanguage-link-target">Basa Bali</a></li><li class="interlanguage-link interwiki-bm"><a href="https://bm.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Bambara" lang="bm" hreflang="bm" class="interlanguage-link-target">Bamanankan</a></li><li class="interlanguage-link interwiki-bn"><a href="https://bn.wikipedia.org/wiki/%E0%A6%86%E0%A6%B2%E0%A6%AC%E0%A6%BE%E0%A6%B0%E0%A7%8D%E0%A6%9F_%E0%A6%86%E0%A6%87%E0%A6%A8%E0%A6%B8%E0%A7%8D%E0%A6%9F%E0%A6%BE%E0%A6%87%E0%A6%A8" title="আলবার্ট আইনস্টাইন – Bangla" lang="bn" hreflang="bn" class="interlanguage-link-target">বাংলা</a></li><li class="interlanguage-link interwiki-zh-min-nan"><a href="https://zh-min-nan.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Chinese (Min Nan)" lang="nan" hreflang="nan" class="interlanguage-link-target">Bân-lâm-gú</a></li><li class="interlanguage-link interwiki-map-bms"><a href="https://map-bms.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Basa Banyumasan" lang="jv-x-bms" hreflang="jv-x-bms" class="interlanguage-link-target">Basa Banyumasan</a></li><li class="interlanguage-link interwiki-ba"><a href="https://ba.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Bashkir" lang="ba" hreflang="ba" class="interlanguage-link-target">Башҡортса</a></li><li class="interlanguage-link interwiki-be badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://be.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D1%8D%D0%B9%D0%BD" title="Альберт Эйнштэйн – Belarusian" lang="be" hreflang="be" class="interlanguage-link-target">Беларуская</a></li><li class="interlanguage-link interwiki-be-x-old"><a href="https://be-tarask.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D1%8D%D1%80%D1%82_%D0%90%D0%B9%D0%BD%D1%88%D1%82%D0%B0%D0%B9%D0%BD" title="Альбэрт Айнштайн – Belarusian (Taraškievica orthography)" lang="be-tarask" hreflang="be-tarask" class="interlanguage-link-target">Беларуская (тарашкевіца)‎</a></li><li class="interlanguage-link interwiki-bh"><a href="https://bh.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%82%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A5%80%E0%A4%A8" title="अल्बर्ट आइंस्टीन – Bhojpuri" lang="bh" hreflang="bh" class="interlanguage-link-target">भोजपुरी</a></li><li class="interlanguage-link interwiki-bcl"><a href="https://bcl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Central Bikol" lang="bcl" hreflang="bcl" class="interlanguage-link-target">Bikol Central</a></li><li class="interlanguage-link interwiki-bg"><a href="https://bg.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%90%D0%B9%D0%BD%D1%89%D0%B0%D0%B9%D0%BD" title="Алберт Айнщайн – Bulgarian" lang="bg" hreflang="bg" class="interlanguage-link-target">Български</a></li><li class="interlanguage-link interwiki-bs"><a href="https://bs.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Bosnian" lang="bs" hreflang="bs" class="interlanguage-link-target">Bosanski</a></li><li class="interlanguage-link interwiki-br"><a href="https://br.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Breton" lang="br" hreflang="br" class="interlanguage-link-target">Brezhoneg</a></li><li class="interlanguage-link interwiki-bxr"><a href="https://bxr.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%90%D0%B9%D0%BD%D1%88%D1%82%D0%B0%D0%B9%D0%BD" title="Альберт Айнштайн – Russia Buriat" lang="bxr" hreflang="bxr" class="interlanguage-link-target">Буряад</a></li><li class="interlanguage-link interwiki-ca"><a href="https://ca.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Catalan" lang="ca" hreflang="ca" class="interlanguage-link-target">Català</a></li><li class="interlanguage-link interwiki-cv"><a href="https://cv.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн Альберт – Chuvash" lang="cv" hreflang="cv" class="interlanguage-link-target">Чӑвашла</a></li><li class="interlanguage-link interwiki-ceb"><a href="https://ceb.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Cebuano" lang="ceb" hreflang="ceb" class="interlanguage-link-target">Cebuano</a></li><li class="interlanguage-link interwiki-cs"><a href="https://cs.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Czech" lang="cs" hreflang="cs" class="interlanguage-link-target">Čeština</a></li><li class="interlanguage-link interwiki-cbk-zam"><a href="https://cbk-zam.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Chavacano" lang="cbk" hreflang="cbk" class="interlanguage-link-target">Chavacano de Zamboanga</a></li><li class="interlanguage-link interwiki-co"><a href="https://co.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Corsican" lang="co" hreflang="co" class="interlanguage-link-target">Corsu</a></li><li class="interlanguage-link interwiki-cy"><a href="https://cy.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Welsh" lang="cy" hreflang="cy" class="interlanguage-link-target">Cymraeg</a></li><li class="interlanguage-link interwiki-da"><a href="https://da.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Danish" lang="da" hreflang="da" class="interlanguage-link-target">Dansk</a></li><li class="interlanguage-link interwiki-ary"><a href="https://ary.wikipedia.org/wiki/%D8%A2%D9%84%D8%A8%D9%8A%D8%B1%D8%B7_%D8%A5%D9%8A%D9%86%D8%B4%D8%B7%D8%A7%D9%8A%D9%86" title="آلبيرط إينشطاين – Moroccan Arabic" lang="ary" hreflang="ary" class="interlanguage-link-target">الدارجة</a></li><li class="interlanguage-link interwiki-se"><a href="https://se.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Northern Sami" lang="se" hreflang="se" class="interlanguage-link-target">Davvisámegiella</a></li><li class="interlanguage-link interwiki-de badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://de.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – German" lang="de" hreflang="de" class="interlanguage-link-target">Deutsch</a></li><li class="interlanguage-link interwiki-nv"><a href="https://nv.wikipedia.org/wiki/Hastiin_Albert_Einstein" title="Hastiin Albert Einstein – Navajo" lang="nv" hreflang="nv" class="interlanguage-link-target">Diné bizaad</a></li><li class="interlanguage-link interwiki-dty"><a href="https://dty.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%A8%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A4%BE%E0%A4%87%E0%A4%A8" title="अल्बर्ट आइनस्टाइन – Doteli" lang="dty" hreflang="dty" class="interlanguage-link-target">डोटेली</a></li><li class="interlanguage-link interwiki-et"><a href="https://et.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Estonian" lang="et" hreflang="et" class="interlanguage-link-target">Eesti</a></li><li class="interlanguage-link interwiki-el"><a href="https://el.wikipedia.org/wiki/%CE%86%CE%BB%CE%BC%CF%80%CE%B5%CF%81%CF%84_%CE%91%CF%8A%CE%BD%CF%83%CF%84%CE%AC%CE%B9%CE%BD" title="Άλμπερτ Αϊνστάιν – Greek" lang="el" hreflang="el" class="interlanguage-link-target">Ελληνικά</a></li><li class="interlanguage-link interwiki-myv"><a href="https://myv.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD,_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн, Альберт – Erzya" lang="myv" hreflang="myv" class="interlanguage-link-target">Эрзянь</a></li><li class="interlanguage-link interwiki-es"><a href="https://es.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Spanish" lang="es" hreflang="es" class="interlanguage-link-target">Español</a></li><li class="interlanguage-link interwiki-eo"><a href="https://eo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Esperanto" lang="eo" hreflang="eo" class="interlanguage-link-target">Esperanto</a></li><li class="interlanguage-link interwiki-ext"><a href="https://ext.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Extremaduran" lang="ext" hreflang="ext" class="interlanguage-link-target">Estremeñu</a></li><li class="interlanguage-link interwiki-eu badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://eu.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Basque" lang="eu" hreflang="eu" class="interlanguage-link-target">Euskara</a></li><li class="interlanguage-link interwiki-fa badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://fa.wikipedia.org/wiki/%D8%A2%D9%84%D8%A8%D8%B1%D8%AA_%D8%A7%DB%8C%D9%86%D8%B4%D8%AA%DB%8C%D9%86" title="آلبرت اینشتین – Persian" lang="fa" hreflang="fa" class="interlanguage-link-target">فارسی</a></li><li class="interlanguage-link interwiki-hif"><a href="https://hif.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Fiji Hindi" lang="hif" hreflang="hif" class="interlanguage-link-target">Fiji Hindi</a></li><li class="interlanguage-link interwiki-fo"><a href="https://fo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Faroese" lang="fo" hreflang="fo" class="interlanguage-link-target">Føroyskt</a></li><li class="interlanguage-link interwiki-fr"><a href="https://fr.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – French" lang="fr" hreflang="fr" class="interlanguage-link-target">Français</a></li><li class="interlanguage-link interwiki-fy"><a href="https://fy.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Western Frisian" lang="fy" hreflang="fy" class="interlanguage-link-target">Frysk</a></li><li class="interlanguage-link interwiki-ga"><a href="https://ga.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Irish" lang="ga" hreflang="ga" class="interlanguage-link-target">Gaeilge</a></li><li class="interlanguage-link interwiki-gv"><a href="https://gv.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Manx" lang="gv" hreflang="gv" class="interlanguage-link-target">Gaelg</a></li><li class="interlanguage-link interwiki-gd"><a href="https://gd.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Scottish Gaelic" lang="gd" hreflang="gd" class="interlanguage-link-target">Gàidhlig</a></li><li class="interlanguage-link interwiki-gl"><a href="https://gl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Galician" lang="gl" hreflang="gl" class="interlanguage-link-target">Galego</a></li><li class="interlanguage-link interwiki-gan"><a href="https://gan.wikipedia.org/wiki/%E6%84%9B%E5%9B%A0%E6%96%AF%E5%9D%A6" title="愛因斯坦 – Gan Chinese" lang="gan" hreflang="gan" class="interlanguage-link-target">贛語</a></li><li class="interlanguage-link interwiki-gu"><a href="https://gu.wikipedia.org/wiki/%E0%AA%86%E0%AA%B2%E0%AB%8D%E0%AA%AC%E0%AA%B0%E0%AB%8D%E0%AA%9F_%E0%AA%86%E0%AA%87%E0%AA%A8%E0%AB%8D%E0%AA%B8%E0%AB%8D%E0%AA%9F%E0%AA%BE%E0%AA%87%E0%AA%A8" title="આલ્બર્ટ આઇન્સ્ટાઇન – Gujarati" lang="gu" hreflang="gu" class="interlanguage-link-target">ગુજરાતી</a></li><li class="interlanguage-link interwiki-gom"><a href="https://gom.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Goan Konkani" lang="gom" hreflang="gom" class="interlanguage-link-target">गोंयची कोंकणी / Gõychi Konknni</a></li><li class="interlanguage-link interwiki-hak"><a href="https://hak.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Hakka Chinese" lang="hak" hreflang="hak" class="interlanguage-link-target">客家語/Hak-kâ-ngî</a></li><li class="interlanguage-link interwiki-ko"><a href="https://ko.wikipedia.org/wiki/%EC%95%8C%EB%B2%A0%EB%A5%B4%ED%8A%B8_%EC%95%84%EC%9D%B8%EC%8A%88%ED%83%80%EC%9D%B8" title="알베르트 아인슈타인 – Korean" lang="ko" hreflang="ko" class="interlanguage-link-target">한국어</a></li><li class="interlanguage-link interwiki-ha"><a href="https://ha.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Hausa" lang="ha" hreflang="ha" class="interlanguage-link-target">Hausa</a></li><li class="interlanguage-link interwiki-haw"><a href="https://haw.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Hawaiian" lang="haw" hreflang="haw" class="interlanguage-link-target">Hawaiʻi</a></li><li class="interlanguage-link interwiki-hy badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://hy.wikipedia.org/wiki/%D4%B1%D5%AC%D5%A2%D5%A5%D6%80%D5%BF_%D4%B1%D5%B5%D5%B6%D5%B7%D5%BF%D5%A1%D5%B5%D5%B6" title="Ալբերտ Այնշտայն – Armenian" lang="hy" hreflang="hy" class="interlanguage-link-target">Հայերեն</a></li><li class="interlanguage-link interwiki-hi"><a href="https://hi.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%82%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A5%80%E0%A4%A8" title="अल्बर्ट आइंस्टीन – Hindi" lang="hi" hreflang="hi" class="interlanguage-link-target">हिन्दी</a></li><li class="interlanguage-link interwiki-hsb"><a href="https://hsb.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Upper Sorbian" lang="hsb" hreflang="hsb" class="interlanguage-link-target">Hornjoserbsce</a></li><li class="interlanguage-link interwiki-hr badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://hr.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Croatian" lang="hr" hreflang="hr" class="interlanguage-link-target">Hrvatski</a></li><li class="interlanguage-link interwiki-gor"><a href="https://gor.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Gorontalo" lang="gor" hreflang="gor" class="interlanguage-link-target">Bahasa Hulontalo</a></li><li class="interlanguage-link interwiki-io"><a href="https://io.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Ido" lang="io" hreflang="io" class="interlanguage-link-target">Ido</a></li><li class="interlanguage-link interwiki-ig"><a href="https://ig.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Igbo" lang="ig" hreflang="ig" class="interlanguage-link-target">Igbo</a></li><li class="interlanguage-link interwiki-ilo"><a href="https://ilo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Iloko" lang="ilo" hreflang="ilo" class="interlanguage-link-target">Ilokano</a></li><li class="interlanguage-link interwiki-bpy"><a href="https://bpy.wikipedia.org/wiki/%E0%A6%86%E0%A6%B2%E0%A6%AC%E0%A6%BE%E0%A6%B0%E0%A7%8D%E0%A6%9F_%E0%A6%86%E0%A6%87%E0%A6%A8%E0%A6%B8%E0%A7%8D%E0%A6%9F%E0%A6%BE%E0%A6%87%E0%A6%A8" title="আলবার্ট আইনস্টাইন – Bishnupriya" lang="bpy" hreflang="bpy" class="interlanguage-link-target">বিষ্ণুপ্রিয়া মণিপুরী</a></li><li class="interlanguage-link interwiki-id"><a href="https://id.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Indonesian" lang="id" hreflang="id" class="interlanguage-link-target">Bahasa Indonesia</a></li><li class="interlanguage-link interwiki-ia"><a href="https://ia.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Interlingua" lang="ia" hreflang="ia" class="interlanguage-link-target">Interlingua</a></li><li class="interlanguage-link interwiki-ie"><a href="https://ie.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Interlingue" lang="ie" hreflang="ie" class="interlanguage-link-target">Interlingue</a></li><li class="interlanguage-link interwiki-os"><a href="https://os.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD,_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн, Альберт – Ossetic" lang="os" hreflang="os" class="interlanguage-link-target">Ирон</a></li><li class="interlanguage-link interwiki-is"><a href="https://is.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Icelandic" lang="is" hreflang="is" class="interlanguage-link-target">Íslenska</a></li><li class="interlanguage-link interwiki-it"><a href="https://it.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Italian" lang="it" hreflang="it" class="interlanguage-link-target">Italiano</a></li><li class="interlanguage-link interwiki-he badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://he.wikipedia.org/wiki/%D7%90%D7%9C%D7%91%D7%A8%D7%98_%D7%90%D7%99%D7%99%D7%A0%D7%A9%D7%98%D7%99%D7%99%D7%9F" title="אלברט איינשטיין – Hebrew" lang="he" hreflang="he" class="interlanguage-link-target">עברית</a></li><li class="interlanguage-link interwiki-jv"><a href="https://jv.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Javanese" lang="jv" hreflang="jv" class="interlanguage-link-target">Jawa</a></li><li class="interlanguage-link interwiki-kbp"><a href="https://kbp.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Kabiye" lang="kbp" hreflang="kbp" class="interlanguage-link-target">Kabɩyɛ</a></li><li class="interlanguage-link interwiki-kn"><a href="https://kn.wikipedia.org/wiki/%E0%B2%85%E0%B2%B2%E0%B3%8D%E0%B2%AC%E0%B2%B0%E0%B3%8D%E0%B2%9F%E0%B3%8D_%E0%B2%90%E0%B2%A8%E0%B3%8D%E2%80%8D%E0%B2%B8%E0%B3%8D%E0%B2%9F%E0%B3%88%E0%B2%A8%E0%B3%8D" title="ಅಲ್ಬರ್ಟ್ ಐನ್‍ಸ್ಟೈನ್ – Kannada" lang="kn" hreflang="kn" class="interlanguage-link-target">ಕನ್ನಡ</a></li><li class="interlanguage-link interwiki-pam"><a href="https://pam.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Pampanga" lang="pam" hreflang="pam" class="interlanguage-link-target">Kapampangan</a></li><li class="interlanguage-link interwiki-ka"><a href="https://ka.wikipedia.org/wiki/%E1%83%90%E1%83%9A%E1%83%91%E1%83%94%E1%83%A0%E1%83%A2_%E1%83%90%E1%83%98%E1%83%9C%E1%83%A8%E1%83%A2%E1%83%90%E1%83%98%E1%83%9C%E1%83%98" title="ალბერტ აინშტაინი – Georgian" lang="ka" hreflang="ka" class="interlanguage-link-target">ქართული</a></li><li class="interlanguage-link interwiki-kk"><a href="https://kk.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Kazakh" lang="kk" hreflang="kk" class="interlanguage-link-target">Қазақша</a></li><li class="interlanguage-link interwiki-kw"><a href="https://kw.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Cornish" lang="kw" hreflang="kw" class="interlanguage-link-target">Kernowek</a></li><li class="interlanguage-link interwiki-sw"><a href="https://sw.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Swahili" lang="sw" hreflang="sw" class="interlanguage-link-target">Kiswahili</a></li><li class="interlanguage-link interwiki-ht"><a href="https://ht.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Haitian Creole" lang="ht" hreflang="ht" class="interlanguage-link-target">Kreyòl ayisyen</a></li><li class="interlanguage-link interwiki-gcr"><a href="https://gcr.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Guianan Creole" lang="gcr" hreflang="gcr" class="interlanguage-link-target">Kriyòl gwiyannen</a></li><li class="interlanguage-link interwiki-ku"><a href="https://ku.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Kurdish" lang="ku" hreflang="ku" class="interlanguage-link-target">Kurdî</a></li><li class="interlanguage-link interwiki-ky"><a href="https://ky.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Kyrgyz" lang="ky" hreflang="ky" class="interlanguage-link-target">Кыргызча</a></li><li class="interlanguage-link interwiki-lad"><a href="https://lad.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Ladino" lang="lad" hreflang="lad" class="interlanguage-link-target">Ladino</a></li><li class="interlanguage-link interwiki-la"><a href="https://la.wikipedia.org/wiki/Albertus_Einstein" title="Albertus Einstein – Latin" lang="la" hreflang="la" class="interlanguage-link-target">Latina</a></li><li class="interlanguage-link interwiki-lv"><a href="https://lv.wikipedia.org/wiki/Alberts_Ein%C5%A1teins" title="Alberts Einšteins – Latvian" lang="lv" hreflang="lv" class="interlanguage-link-target">Latviešu</a></li><li class="interlanguage-link interwiki-lb"><a href="https://lb.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Luxembourgish" lang="lb" hreflang="lb" class="interlanguage-link-target">Lëtzebuergesch</a></li><li class="interlanguage-link interwiki-lez"><a href="https://lez.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Lezghian" lang="lez" hreflang="lez" class="interlanguage-link-target">Лезги</a></li><li class="interlanguage-link interwiki-lt"><a href="https://lt.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Lithuanian" lang="lt" hreflang="lt" class="interlanguage-link-target">Lietuvių</a></li><li class="interlanguage-link interwiki-lij"><a href="https://lij.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Ligurian" lang="lij" hreflang="lij" class="interlanguage-link-target">Ligure</a></li><li class="interlanguage-link interwiki-li"><a href="https://li.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Limburgish" lang="li" hreflang="li" class="interlanguage-link-target">Limburgs</a></li><li class="interlanguage-link interwiki-lfn"><a href="https://lfn.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Lingua Franca Nova" lang="lfn" hreflang="lfn" class="interlanguage-link-target">Lingua Franca Nova</a></li><li class="interlanguage-link interwiki-olo"><a href="https://olo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Livvi-Karelian" lang="olo" hreflang="olo" class="interlanguage-link-target">Livvinkarjala</a></li><li class="interlanguage-link interwiki-jbo"><a href="https://jbo.wikipedia.org/wiki/albert._ainctain" title="albert. ainctain – Lojban" lang="jbo" hreflang="jbo" class="interlanguage-link-target">La .lojban.</a></li><li class="interlanguage-link interwiki-lg"><a href="https://lg.wikipedia.org/wiki/Alubbaati_Ansitayini" title="Alubbaati Ansitayini – Ganda" lang="lg" hreflang="lg" class="interlanguage-link-target">Luganda</a></li><li class="interlanguage-link interwiki-lmo"><a href="https://lmo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Lombard" lang="lmo" hreflang="lmo" class="interlanguage-link-target">Lumbaart</a></li><li class="interlanguage-link interwiki-hu"><a href="https://hu.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Hungarian" lang="hu" hreflang="hu" class="interlanguage-link-target">Magyar</a></li><li class="interlanguage-link interwiki-mai"><a href="https://mai.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%A8%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A4%BE%E0%A4%87%E0%A4%A8" title="अल्बर्ट आइनस्टाइन – Maithili" lang="mai" hreflang="mai" class="interlanguage-link-target">मैथिली</a></li><li class="interlanguage-link interwiki-mk"><a href="https://mk.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%90%D1%98%D0%BD%D1%88%D1%82%D0%B0%D1%98%D0%BD" title="Алберт Ајнштајн – Macedonian" lang="mk" hreflang="mk" class="interlanguage-link-target">Македонски</a></li><li class="interlanguage-link interwiki-mg"><a href="https://mg.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Malagasy" lang="mg" hreflang="mg" class="interlanguage-link-target">Malagasy</a></li><li class="interlanguage-link interwiki-ml"><a href="https://ml.wikipedia.org/wiki/%E0%B4%86%E0%B5%BD%E0%B4%AC%E0%B5%BC%E0%B4%9F%E0%B5%8D%E0%B4%9F%E0%B5%8D_%E0%B4%90%E0%B5%BB%E0%B4%B8%E0%B5%8D%E0%B4%B1%E0%B5%8D%E0%B4%B1%E0%B5%88%E0%B5%BB" title="ആൽബർട്ട് ഐൻസ്റ്റൈൻ – Malayalam" lang="ml" hreflang="ml" class="interlanguage-link-target">മലയാളം</a></li><li class="interlanguage-link interwiki-mr"><a href="https://mr.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%A8%E0%A5%8D%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A4%BE%E0%A4%87%E0%A4%A8" title="अल्बर्ट आइन्स्टाइन – Marathi" lang="mr" hreflang="mr" class="interlanguage-link-target">मराठी</a></li><li class="interlanguage-link interwiki-xmf"><a href="https://xmf.wikipedia.org/wiki/%E1%83%90%E1%83%9A%E1%83%91%E1%83%94%E1%83%A0%E1%83%A2_%E1%83%90%E1%83%98%E1%83%9C%E1%83%A8%E1%83%A2%E1%83%90%E1%83%98%E1%83%9C%E1%83%98" title="ალბერტ აინშტაინი – Mingrelian" lang="xmf" hreflang="xmf" class="interlanguage-link-target">მარგალური</a></li><li class="interlanguage-link interwiki-arz"><a href="https://arz.wikipedia.org/wiki/%D8%A7%D9%84%D8%A8%D8%B1%D8%AA_%D8%A7%D9%8A%D9%86%D8%B4%D8%AA%D8%A7%D9%8A%D9%86" title="البرت اينشتاين – Egyptian Arabic" lang="arz" hreflang="arz" class="interlanguage-link-target">مصرى</a></li><li class="interlanguage-link interwiki-mnw"><a href="https://mnw.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Mon" lang="mnw" hreflang="mnw" class="interlanguage-link-target">ဘာသာ မန်</a></li><li class="interlanguage-link interwiki-mzn"><a href="https://mzn.wikipedia.org/wiki/%D8%A2%D9%84%D8%A8%D8%B1%D8%AA_%D8%A7%DB%8C%D9%86%D8%B4%D8%AA%DB%8C%D9%86" title="آلبرت اینشتین – Mazanderani" lang="mzn" hreflang="mzn" class="interlanguage-link-target">مازِرونی</a></li><li class="interlanguage-link interwiki-ms"><a href="https://ms.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Malay" lang="ms" hreflang="ms" class="interlanguage-link-target">Bahasa Melayu</a></li><li class="interlanguage-link interwiki-cdo"><a href="https://cdo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Min Dong Chinese" lang="cdo" hreflang="cdo" class="interlanguage-link-target">Mìng-dĕ̤ng-ngṳ̄</a></li><li class="interlanguage-link interwiki-mwl"><a href="https://mwl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Mirandese" lang="mwl" hreflang="mwl" class="interlanguage-link-target">Mirandés</a></li><li class="interlanguage-link interwiki-mn"><a href="https://mn.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Mongolian" lang="mn" hreflang="mn" class="interlanguage-link-target">Монгол</a></li><li class="interlanguage-link interwiki-my"><a href="https://my.wikipedia.org/wiki/%E1%80%A1%E1%80%B2%E1%80%9C%E1%80%BA%E1%80%98%E1%80%90%E1%80%BA_%E1%80%A1%E1%80%AD%E1%80%AF%E1%80%84%E1%80%BA%E1%80%B8%E1%80%85%E1%80%90%E1%80%AD%E1%80%AF%E1%80%84%E1%80%BA%E1%80%B8" title="အဲလ်ဘတ် အိုင်းစတိုင်း – Burmese" lang="my" hreflang="my" class="interlanguage-link-target">မြန်မာဘာသာ</a></li><li class="interlanguage-link interwiki-nah"><a href="https://nah.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Nāhuatl" lang="nah" hreflang="nah" class="interlanguage-link-target">Nāhuatl</a></li><li class="interlanguage-link interwiki-na"><a href="https://na.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Nauru" lang="na" hreflang="na" class="interlanguage-link-target">Dorerin Naoero</a></li><li class="interlanguage-link interwiki-nl"><a href="https://nl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Dutch" lang="nl" hreflang="nl" class="interlanguage-link-target">Nederlands</a></li><li class="interlanguage-link interwiki-nds-nl"><a href="https://nds-nl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Low Saxon" lang="nds-NL" hreflang="nds-NL" class="interlanguage-link-target">Nedersaksies</a></li><li class="interlanguage-link interwiki-ne"><a href="https://ne.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%B5%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%A8%E0%A5%8D%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A4%BE%E0%A4%87%E0%A4%A8" title="अल्वर्ट आइन्स्टाइन – Nepali" lang="ne" hreflang="ne" class="interlanguage-link-target">नेपाली</a></li><li class="interlanguage-link interwiki-new"><a href="https://new.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F_%E0%A4%86%E0%A4%87%E0%A4%A8%E0%A5%8D%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A4%BE%E0%A4%87%E0%A4%A8" title="अल्बर्ट आइन्स्टाइन – Newari" lang="new" hreflang="new" class="interlanguage-link-target">नेपाल भाषा</a></li><li class="interlanguage-link interwiki-ja"><a href="https://ja.wikipedia.org/wiki/%E3%82%A2%E3%83%AB%E3%83%99%E3%83%AB%E3%83%88%E3%83%BB%E3%82%A2%E3%82%A4%E3%83%B3%E3%82%B7%E3%83%A5%E3%82%BF%E3%82%A4%E3%83%B3" title="アルベルト・アインシュタイン – Japanese" lang="ja" hreflang="ja" class="interlanguage-link-target">日本語</a></li><li class="interlanguage-link interwiki-ce"><a href="https://ce.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD,_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн, Альберт – Chechen" lang="ce" hreflang="ce" class="interlanguage-link-target">Нохчийн</a></li><li class="interlanguage-link interwiki-frr"><a href="https://frr.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Northern Frisian" lang="frr" hreflang="frr" class="interlanguage-link-target">Nordfriisk</a></li><li class="interlanguage-link interwiki-no badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://no.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Norwegian Bokmål" lang="nb" hreflang="nb" class="interlanguage-link-target">Norsk bokmål</a></li><li class="interlanguage-link interwiki-nn"><a href="https://nn.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Norwegian Nynorsk" lang="nn" hreflang="nn" class="interlanguage-link-target">Norsk nynorsk</a></li><li class="interlanguage-link interwiki-nov"><a href="https://nov.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Novial" lang="nov" hreflang="nov" class="interlanguage-link-target">Novial</a></li><li class="interlanguage-link interwiki-oc"><a href="https://oc.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Occitan" lang="oc" hreflang="oc" class="interlanguage-link-target">Occitan</a></li><li class="interlanguage-link interwiki-or"><a href="https://or.wikipedia.org/wiki/%E0%AC%86%E0%AC%B2%E0%AC%AC%E0%AC%B0%E0%AD%8D%E0%AC%9F_%E0%AC%86%E0%AC%87%E0%AC%A8%E0%AC%B7%E0%AD%8D%E0%AC%9F%E0%AC%BE%E0%AC%87%E0%AC%A8" title="ଆଲବର୍ଟ ଆଇନଷ୍ଟାଇନ – Odia" lang="or" hreflang="or" class="interlanguage-link-target">ଓଡ଼ିଆ</a></li><li class="interlanguage-link interwiki-om"><a href="https://om.wikipedia.org/wiki/Alberti_Anistaayin" title="Alberti Anistaayin – Oromo" lang="om" hreflang="om" class="interlanguage-link-target">Oromoo</a></li><li class="interlanguage-link interwiki-uz"><a href="https://uz.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Uzbek" lang="uz" hreflang="uz" class="interlanguage-link-target">Oʻzbekcha/ўзбекча</a></li><li class="interlanguage-link interwiki-pa"><a href="https://pa.wikipedia.org/wiki/%E0%A8%85%E0%A8%B2%E0%A8%AC%E0%A8%B0%E0%A8%9F_%E0%A8%86%E0%A8%88%E0%A8%A8%E0%A8%B8%E0%A8%9F%E0%A8%BE%E0%A8%88%E0%A8%A8" title="ਅਲਬਰਟ ਆਈਨਸਟਾਈਨ – Punjabi" lang="pa" hreflang="pa" class="interlanguage-link-target">ਪੰਜਾਬੀ</a></li><li class="interlanguage-link interwiki-pnb"><a href="https://pnb.wikipedia.org/wiki/%D8%A7%DB%8C%D9%84%D8%A8%D8%B1%D9%B9_%D8%A2%D8%A6%DB%8C%D9%86%D8%B3%D9%B9%D8%A7%D8%A6%D9%86" title="ایلبرٹ آئینسٹائن – Western Punjabi" lang="pnb" hreflang="pnb" class="interlanguage-link-target">پنجابی</a></li><li class="interlanguage-link interwiki-ps"><a href="https://ps.wikipedia.org/wiki/%D8%A7%D9%84%D8%A8%D8%B1%D9%BC_%D8%A2%D9%8A%D9%86%D8%B3%D9%BC%D8%A7%D9%8A%D9%86" title="البرټ آينسټاين – Pashto" lang="ps" hreflang="ps" class="interlanguage-link-target">پښتو</a></li><li class="interlanguage-link interwiki-jam"><a href="https://jam.wikipedia.org/wiki/Alboert_Ainstain" title="Alboert Ainstain – Jamaican Creole English" lang="jam" hreflang="jam" class="interlanguage-link-target">Patois</a></li><li class="interlanguage-link interwiki-km"><a href="https://km.wikipedia.org/wiki/%E1%9E%A2%E1%9E%B6%E1%9E%9B%E1%9F%8B%E1%9E%94%E1%9E%BA%E1%9E%8F_%E1%9E%A2%E1%9F%82%E1%9E%84%E1%9E%9F%E1%9F%92%E1%9E%8F%E1%9F%82%E1%9E%84" title="អាល់បឺត អែងស្តែង – Khmer" lang="km" hreflang="km" class="interlanguage-link-target">ភាសាខ្មែរ</a></li><li class="interlanguage-link interwiki-pcd"><a href="https://pcd.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Picard" lang="pcd" hreflang="pcd" class="interlanguage-link-target">Picard</a></li><li class="interlanguage-link interwiki-pms"><a href="https://pms.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Piedmontese" lang="pms" hreflang="pms" class="interlanguage-link-target">Piemontèis</a></li><li class="interlanguage-link interwiki-tpi"><a href="https://tpi.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Tok Pisin" lang="tpi" hreflang="tpi" class="interlanguage-link-target">Tok Pisin</a></li><li class="interlanguage-link interwiki-nds"><a href="https://nds.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Low German" lang="nds" hreflang="nds" class="interlanguage-link-target">Plattdüütsch</a></li><li class="interlanguage-link interwiki-pl"><a href="https://pl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Polish" lang="pl" hreflang="pl" class="interlanguage-link-target">Polski</a></li><li class="interlanguage-link interwiki-pt badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://pt.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Portuguese" lang="pt" hreflang="pt" class="interlanguage-link-target">Português</a></li><li class="interlanguage-link interwiki-kaa"><a href="https://kaa.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Kara-Kalpak" lang="kaa" hreflang="kaa" class="interlanguage-link-target">Qaraqalpaqsha</a></li><li class="interlanguage-link interwiki-ksh"><a href="https://ksh.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Colognian" lang="ksh" hreflang="ksh" class="interlanguage-link-target">Ripoarisch</a></li><li class="interlanguage-link interwiki-ro"><a href="https://ro.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Romanian" lang="ro" hreflang="ro" class="interlanguage-link-target">Română</a></li><li class="interlanguage-link interwiki-rm"><a href="https://rm.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Romansh" lang="rm" hreflang="rm" class="interlanguage-link-target">Rumantsch</a></li><li class="interlanguage-link interwiki-qu"><a href="https://qu.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Quechua" lang="qu" hreflang="qu" class="interlanguage-link-target">Runa Simi</a></li><li class="interlanguage-link interwiki-rue"><a href="https://rue.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%90%D0%B9%D0%BD%D1%88%D1%82%D0%B0%D0%B9%D0%BD" title="Алберт Айнштайн – Rusyn" lang="rue" hreflang="rue" class="interlanguage-link-target">Русиньскый</a></li><li class="interlanguage-link interwiki-ru badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://ru.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD,_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн, Альберт – Russian" lang="ru" hreflang="ru" class="interlanguage-link-target">Русский</a></li><li class="interlanguage-link interwiki-sah"><a href="https://sah.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Sakha" lang="sah" hreflang="sah" class="interlanguage-link-target">Саха тыла</a></li><li class="interlanguage-link interwiki-sa"><a href="https://sa.wikipedia.org/wiki/%E0%A4%85%E0%A4%B2%E0%A5%8D%E0%A4%AC%E0%A4%B0%E0%A5%8D%E0%A4%9F%E0%A5%8D_%E0%A4%90%E0%A4%A8%E0%A5%8D%E0%A4%B8%E0%A5%8D%E0%A4%9F%E0%A5%88%E0%A4%A8%E0%A5%8D" title="अल्बर्ट् ऐन्स्टैन् – Sanskrit" lang="sa" hreflang="sa" class="interlanguage-link-target">संस्कृतम्</a></li><li class="interlanguage-link interwiki-sat"><a href="https://sat.wikipedia.org/wiki/%E1%B1%9F%E1%B1%9E%E1%B1%B5%E1%B1%9A%E1%B1%A8%E1%B1%B4_%E1%B1%9F%E1%B1%AD%E1%B1%A4%E1%B1%B1%E1%B1%A5%E1%B1%B4%E1%B1%9F%E1%B1%AD%E1%B1%A4%E1%B1%B1" title="ᱟᱞᱵᱚᱨᱴ ᱟᱭᱤᱱᱥᱴᱟᱭᱤᱱ – Santali" lang="sat" hreflang="sat" class="interlanguage-link-target">ᱥᱟᱱᱛᱟᱲᱤ</a></li><li class="interlanguage-link interwiki-sc"><a href="https://sc.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Sardinian" lang="sc" hreflang="sc" class="interlanguage-link-target">Sardu</a></li><li class="interlanguage-link interwiki-sco"><a href="https://sco.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Scots" lang="sco" hreflang="sco" class="interlanguage-link-target">Scots</a></li><li class="interlanguage-link interwiki-sq"><a href="https://sq.wikipedia.org/wiki/Albert_Ajnshtajni" title="Albert Ajnshtajni – Albanian" lang="sq" hreflang="sq" class="interlanguage-link-target">Shqip</a></li><li class="interlanguage-link interwiki-scn"><a href="https://scn.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Sicilian" lang="scn" hreflang="scn" class="interlanguage-link-target">Sicilianu</a></li><li class="interlanguage-link interwiki-si"><a href="https://si.wikipedia.org/wiki/%E0%B6%87%E0%B6%BD%E0%B7%8A%E0%B6%B6%E0%B6%A7%E0%B7%8A%E2%80%8D_%E0%B6%85%E0%B6%BA%E0%B7%92%E0%B6%B1%E0%B7%8A%E0%B7%83%E0%B7%8A%E0%B6%A7%E0%B6%BA%E0%B7%92%E0%B6%B1%E0%B7%8A" title="ඇල්බට්‍ අයින්ස්ටයින් – Sinhala" lang="si" hreflang="si" class="interlanguage-link-target">සිංහල</a></li><li class="interlanguage-link interwiki-simple"><a href="https://simple.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Simple English" lang="en-simple" hreflang="en-simple" class="interlanguage-link-target">Simple English</a></li><li class="interlanguage-link interwiki-sd"><a href="https://sd.wikipedia.org/wiki/%D8%A7%D9%84%D8%A8%D8%B1%D9%BD_%D8%A2%D8%A6%D9%86%D8%B3%D9%BD%D8%A7%D8%A6%D9%86" title="البرٽ آئنسٽائن – Sindhi" lang="sd" hreflang="sd" class="interlanguage-link-target">سنڌي</a></li><li class="interlanguage-link interwiki-sk"><a href="https://sk.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Slovak" lang="sk" hreflang="sk" class="interlanguage-link-target">Slovenčina</a></li><li class="interlanguage-link interwiki-sl"><a href="https://sl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Slovenian" lang="sl" hreflang="sl" class="interlanguage-link-target">Slovenščina</a></li><li class="interlanguage-link interwiki-szl"><a href="https://szl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Silesian" lang="szl" hreflang="szl" class="interlanguage-link-target">Ślůnski</a></li><li class="interlanguage-link interwiki-so"><a href="https://so.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Somali" lang="so" hreflang="so" class="interlanguage-link-target">Soomaaliga</a></li><li class="interlanguage-link interwiki-ckb"><a href="https://ckb.wikipedia.org/wiki/%D8%A6%DB%95%D9%84%D8%A8%DB%95%D8%B1%D8%AA_%D8%A6%D8%A7%DB%8C%D9%86%D8%B4%D8%AA%D8%A7%DB%8C%D9%86" title="ئەلبەرت ئاینشتاین – Central Kurdish" lang="ckb" hreflang="ckb" class="interlanguage-link-target">کوردی</a></li><li class="interlanguage-link interwiki-sr badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://sr.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%90%D1%98%D0%BD%D1%88%D1%82%D0%B0%D1%98%D0%BD" title="Алберт Ајнштајн – Serbian" lang="sr" hreflang="sr" class="interlanguage-link-target">Српски / srpski</a></li><li class="interlanguage-link interwiki-sh badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://sh.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Serbo-Croatian" lang="sh" hreflang="sh" class="interlanguage-link-target">Srpskohrvatski / српскохрватски</a></li><li class="interlanguage-link interwiki-su"><a href="https://su.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Sundanese" lang="su" hreflang="su" class="interlanguage-link-target">Sunda</a></li><li class="interlanguage-link interwiki-fi"><a href="https://fi.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Finnish" lang="fi" hreflang="fi" class="interlanguage-link-target">Suomi</a></li><li class="interlanguage-link interwiki-sv"><a href="https://sv.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Swedish" lang="sv" hreflang="sv" class="interlanguage-link-target">Svenska</a></li><li class="interlanguage-link interwiki-tl"><a href="https://tl.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Tagalog" lang="tl" hreflang="tl" class="interlanguage-link-target">Tagalog</a></li><li class="interlanguage-link interwiki-ta"><a href="https://ta.wikipedia.org/wiki/%E0%AE%86%E0%AE%B2%E0%AF%8D%E0%AE%AA%E0%AE%B0%E0%AF%8D%E0%AE%9F%E0%AF%8D_%E0%AE%90%E0%AE%A9%E0%AF%8D%E0%AE%B8%E0%AF%8D%E0%AE%9F%E0%AF%88%E0%AE%A9%E0%AF%8D" title="ஆல்பர்ட் ஐன்ஸ்டைன் – Tamil" lang="ta" hreflang="ta" class="interlanguage-link-target">தமிழ்</a></li><li class="interlanguage-link interwiki-kab"><a href="https://kab.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Kabyle" lang="kab" hreflang="kab" class="interlanguage-link-target">Taqbaylit</a></li><li class="interlanguage-link interwiki-tt"><a href="https://tt.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Эйнштейн – Tatar" lang="tt" hreflang="tt" class="interlanguage-link-target">Татарча/tatarça</a></li><li class="interlanguage-link interwiki-te"><a href="https://te.wikipedia.org/wiki/%E0%B0%86%E0%B0%B2%E0%B1%8D%E0%B0%AC%E0%B0%B0%E0%B1%8D%E0%B0%9F%E0%B1%8D_%E0%B0%90%E0%B0%A8%E0%B1%8D%E2%80%8C%E0%B0%B8%E0%B1%8D%E0%B0%9F%E0%B1%80%E0%B0%A8%E0%B1%8D" title="ఆల్బర్ట్ ఐన్‌స్టీన్ – Telugu" lang="te" hreflang="te" class="interlanguage-link-target">తెలుగు</a></li><li class="interlanguage-link interwiki-th"><a href="https://th.wikipedia.org/wiki/%E0%B8%AD%E0%B8%B1%E0%B8%A5%E0%B9%80%E0%B8%9A%E0%B8%B4%E0%B8%A3%E0%B9%8C%E0%B8%95_%E0%B9%84%E0%B8%AD%E0%B8%99%E0%B9%8C%E0%B8%AA%E0%B9%84%E0%B8%95%E0%B8%99%E0%B9%8C" title="อัลเบิร์ต ไอน์สไตน์ – Thai" lang="th" hreflang="th" class="interlanguage-link-target">ไทย</a></li><li class="interlanguage-link interwiki-tg"><a href="https://tg.wikipedia.org/wiki/%D0%90%D0%BB%D0%B1%D0%B5%D1%80%D1%82_%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Алберт Эйнштейн – Tajik" lang="tg" hreflang="tg" class="interlanguage-link-target">Тоҷикӣ</a></li><li class="interlanguage-link interwiki-tcy"><a href="https://tcy.wikipedia.org/wiki/%E0%B2%86%E0%B2%B2%E0%B3%8D%E0%B2%AC%E0%B2%B0%E0%B3%8D%E0%B2%9F%E0%B3%8D_%E0%B2%90%E0%B2%A8%E0%B3%8D%E2%80%8D%E0%B2%B8%E0%B3%8D%E0%B2%9F%E0%B3%80%E0%B2%A8%E0%B3%8D" title="ಆಲ್ಬರ್ಟ್ ಐನ್‍ಸ್ಟೀನ್ – Tulu" lang="tcy" hreflang="tcy" class="interlanguage-link-target">ತುಳು</a></li><li class="interlanguage-link interwiki-tr"><a href="https://tr.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Turkish" lang="tr" hreflang="tr" class="interlanguage-link-target">Türkçe</a></li><li class="interlanguage-link interwiki-tk"><a href="https://tk.wikipedia.org/wiki/Albert_E%C3%BDn%C5%9Fte%C3%BDn" title="Albert Eýnşteýn – Turkmen" lang="tk" hreflang="tk" class="interlanguage-link-target">Türkmençe</a></li><li class="interlanguage-link interwiki-tyv"><a href="https://tyv.wikipedia.org/wiki/%D0%AD%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD,_%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82" title="Эйнштейн, Альберт – Tuvinian" lang="tyv" hreflang="tyv" class="interlanguage-link-target">Тыва дыл</a></li><li class="interlanguage-link interwiki-uk"><a href="https://uk.wikipedia.org/wiki/%D0%90%D0%BB%D1%8C%D0%B1%D0%B5%D1%80%D1%82_%D0%95%D0%B9%D0%BD%D1%88%D1%82%D0%B5%D0%B9%D0%BD" title="Альберт Ейнштейн – Ukrainian" lang="uk" hreflang="uk" class="interlanguage-link-target">Українська</a></li><li class="interlanguage-link interwiki-ur badge-Q17437796 badge-featuredarticle" title="featured article badge"><a href="https://ur.wikipedia.org/wiki/%D8%A7%D9%84%D8%A8%D8%B1%D9%B9_%D8%A2%D8%A6%D9%86%D8%B3%D9%B9%D8%A7%D8%A6%D9%86" title="البرٹ آئنسٹائن – Urdu" lang="ur" hreflang="ur" class="interlanguage-link-target">اردو</a></li><li class="interlanguage-link interwiki-ug"><a href="https://ug.wikipedia.org/wiki/%D8%A6%D8%A7%D9%84%D8%A8%DB%90%D8%B1%D8%AA_%D8%A6%DB%90%D9%8A%D9%86%D9%89%D8%B4%D8%AA%DB%90%D9%8A%D9%89%D9%86" title="ئالبېرت ئېينىشتېيىن – Uyghur" lang="ug" hreflang="ug" class="interlanguage-link-target">ئۇيغۇرچە / Uyghurche</a></li><li class="interlanguage-link interwiki-za"><a href="https://za.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Zhuang" lang="za" hreflang="za" class="interlanguage-link-target">Vahcuengh</a></li><li class="interlanguage-link interwiki-vec"><a href="https://vec.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Venetian" lang="vec" hreflang="vec" class="interlanguage-link-target">Vèneto</a></li><li class="interlanguage-link interwiki-vep"><a href="https://vep.wikipedia.org/wiki/Ein%C5%A1tein_Al%27bert" title="Einštein Al&#039;bert – Veps" lang="vep" hreflang="vep" class="interlanguage-link-target">Vepsän kel’</a></li><li class="interlanguage-link interwiki-vi"><a href="https://vi.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Vietnamese" lang="vi" hreflang="vi" class="interlanguage-link-target">Tiếng Việt</a></li><li class="interlanguage-link interwiki-vo"><a href="https://vo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Volapük" lang="vo" hreflang="vo" class="interlanguage-link-target">Volapük</a></li><li class="interlanguage-link interwiki-fiu-vro"><a href="https://fiu-vro.wikipedia.org/wiki/Einsteini_Albert" title="Einsteini Albert – võro" lang="vro" hreflang="vro" class="interlanguage-link-target">Võro</a></li><li class="interlanguage-link interwiki-wa"><a href="https://wa.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Walloon" lang="wa" hreflang="wa" class="interlanguage-link-target">Walon</a></li><li class="interlanguage-link interwiki-zh-classical"><a href="https://zh-classical.wikipedia.org/wiki/%E6%84%9B%E5%9B%A0%E6%96%AF%E5%9D%A6" title="愛因斯坦 – Classical Chinese" lang="lzh" hreflang="lzh" class="interlanguage-link-target">文言</a></li><li class="interlanguage-link interwiki-war"><a href="https://war.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Waray" lang="war" hreflang="war" class="interlanguage-link-target">Winaray</a></li><li class="interlanguage-link interwiki-wo"><a href="https://wo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Wolof" lang="wo" hreflang="wo" class="interlanguage-link-target">Wolof</a></li><li class="interlanguage-link interwiki-wuu"><a href="https://wuu.wikipedia.org/wiki/%E9%98%BF%E7%88%BE%E4%BC%AF%E7%89%B9%C2%B7%E6%84%9B%E5%9B%A0%E6%96%AF%E5%9D%A6" title="阿爾伯特·愛因斯坦 – Wu Chinese" lang="wuu" hreflang="wuu" class="interlanguage-link-target">吴语</a></li><li class="interlanguage-link interwiki-yi"><a href="https://yi.wikipedia.org/wiki/%D7%90%D7%9C%D7%91%D7%A2%D7%A8%D7%98_%D7%90%D7%99%D7%99%D7%A0%D7%A9%D7%98%D7%99%D7%99%D7%9F" title="אלבערט איינשטיין – Yiddish" lang="yi" hreflang="yi" class="interlanguage-link-target">ייִדיש</a></li><li class="interlanguage-link interwiki-yo"><a href="https://yo.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Yoruba" lang="yo" hreflang="yo" class="interlanguage-link-target">Yorùbá</a></li><li class="interlanguage-link interwiki-zh-yue"><a href="https://zh-yue.wikipedia.org/wiki/%E6%84%9B%E5%9B%A0%E6%96%AF%E5%9D%A6" title="愛因斯坦 – Cantonese" lang="yue" hreflang="yue" class="interlanguage-link-target">粵語</a></li><li class="interlanguage-link interwiki-diq"><a href="https://diq.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Zazaki" lang="diq" hreflang="diq" class="interlanguage-link-target">Zazaki</a></li><li class="interlanguage-link interwiki-zea"><a href="https://zea.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Zeelandic" lang="zea" hreflang="zea" class="interlanguage-link-target">Zeêuws</a></li><li class="interlanguage-link interwiki-bat-smg"><a href="https://bat-smg.wikipedia.org/wiki/Alberts_Ein%C5%A1teins" title="Alberts Einšteins – Samogitian" lang="sgs" hreflang="sgs" class="interlanguage-link-target">Žemaitėška</a></li><li class="interlanguage-link interwiki-zh badge-Q17437798 badge-goodarticle" title="good article badge"><a href="https://zh.wikipedia.org/wiki/%E9%98%BF%E5%B0%94%E4%BC%AF%E7%89%B9%C2%B7%E7%88%B1%E5%9B%A0%E6%96%AF%E5%9D%A6" title="阿尔伯特·爱因斯坦 – Chinese" lang="zh" hreflang="zh" class="interlanguage-link-target">中文</a></li><li class="interlanguage-link interwiki-mad"><a href="https://mad.wikipedia.org/wiki/Albert_Einstein" title="Albert Einstein – Madurese" lang="mad" hreflang="mad" class="interlanguage-link-target">Madhurâ</a></li><li class="interlanguage-link interwiki-mni"><a href="https://mni.wikipedia.org/wiki/%EA%AF%91%EA%AF%9C%EA%AF%95%EA%AF%94%EA%AF%AD%EA%AF%A0_%EA%AF%91%EA%AF%A5%EA%AF%A2%EA%AF%9F%EA%AF%81%EA%AF%AD%EA%AF%87%EA%AF%A5%EA%AF%A2%EA%AF%9F" title="ꯑꯜꯕꯔ꯭ꯠ ꯑꯥꯢꯟꯁ꯭ꯇꯥꯢꯟ – Manipuri" lang="mni" hreflang="mni" class="interlanguage-link-target">ꯃꯤꯇꯩ ꯂꯣꯟ</a></li></ul>
		<div class="after-portlet after-portlet-lang"><span class="wb-langlinks-edit wb-langlinks-link"><a href="https://www.wikidata.org/wiki/Special:EntityPage/Q937#sitelinks-wikipedia" title="Edit interlanguage links" class="wbc-editpage">Edit links</a></span></div>
	</div>
</nav>

</div>

</div>
<footer id="footer" class="mw-footer" role="contentinfo" >
	<ul id="footer-info" >
	<li id="footer-info-lastmod"> This page was last edited on 4 April 2021, at 01:52<span class="anonymous-show">&#160;(UTC)</span>.</li>
	<li id="footer-info-copyright">Text is available under the <a rel="license" href="//en.wikipedia.org/wiki/Wikipedia:Text_of_Creative_Commons_Attribution-ShareAlike_3.0_Unported_License">Creative Commons Attribution-ShareAlike License</a><a rel="license" href="//creativecommons.org/licenses/by-sa/3.0/" style="display:none;"></a>;
additional terms may apply.  By using this site, you agree to the <a href="//foundation.wikimedia.org/wiki/Terms_of_Use">Terms of Use</a> and <a href="//foundation.wikimedia.org/wiki/Privacy_policy">Privacy Policy</a>. Wikipedia® is a registered trademark of the <a href="//www.wikimediafoundation.org/">Wikimedia Foundation, Inc.</a>, a non-profit organization.</li>
</ul>

	<ul id="footer-places" >
	<li id="footer-places-privacy"><a href="https://foundation.wikimedia.org/wiki/Privacy_policy" class="extiw" title="wmf:Privacy policy">Privacy policy</a></li>
	<li id="footer-places-about"><a href="/wiki/Wikipedia:About" title="Wikipedia:About">About Wikipedia</a></li>
	<li id="footer-places-disclaimer"><a href="/wiki/Wikipedia:General_disclaimer" title="Wikipedia:General disclaimer">Disclaimers</a></li>
	<li id="footer-places-contact"><a href="//en.wikipedia.org/wiki/Wikipedia:Contact_us">Contact Wikipedia</a></li>
	<li id="footer-places-mobileview"><a href="//en.m.wikipedia.org/w/index.php?title=Albert_Einstein&amp;mobileaction=toggle_view_mobile" class="noprint stopMobileRedirectToggle">Mobile view</a></li>
	<li id="footer-places-developers"><a href="https://www.mediawiki.org/wiki/Special:MyLanguage/How_to_contribute">Developers</a></li>
	<li id="footer-places-statslink"><a href="https://stats.wikimedia.org/#/en.wikipedia.org">Statistics</a></li>
	<li id="footer-places-cookiestatement"><a href="https://foundation.wikimedia.org/wiki/Cookie_statement">Cookie statement</a></li>
</ul>

	<ul id="footer-icons" class="noprint">
	<li id="footer-copyrightico"><a href="https://wikimediafoundation.org/"><img src="/static/images/footer/wikimedia-button.png" srcset="/static/images/footer/wikimedia-button-1.5x.png 1.5x, /static/images/footer/wikimedia-button-2x.png 2x" width="88" height="31" alt="Wikimedia Foundation" loading="lazy" /></a></li>
	<li id="footer-poweredbyico"><a href="https://www.mediawiki.org/"><img src="/static/images/footer/poweredby_mediawiki_88x31.png" alt="Powered by MediaWiki" srcset="/static/images/footer/poweredby_mediawiki_132x47.png 1.5x, /static/images/footer/poweredby_mediawiki_176x62.png 2x" width="88" height="31" loading="lazy"/></a></li>
</ul>

</footer>


<script>(RLQ=window.RLQ||[]).push(function(){mw.config.set({"wgPageParseReport":{"limitreport":{"cputime":"4.116","walltime":"4.718","ppvisitednodes":{"value":19367,"limit":1000000},"postexpandincludesize":{"value":672424,"limit":2097152},"templateargumentsize":{"value":35019,"limit":2097152},"expansiondepth":{"value":24,"limit":40},"expensivefunctioncount":{"value":58,"limit":500},"unstrip-depth":{"value":1,"limit":20},"unstrip-size":{"value":682462,"limit":5000000},"entityaccesscount":{"value":1,"limit":400},"timingprofile":["100.00% 3878.805      1 -total"," 27.97% 1084.879      2 Template:Reflist"," 19.79%  767.444      1 Template:Infobox_scientist"," 19.35%  750.504      1 Template:Infobox_person"," 18.85%  731.033      2 Template:Infobox"," 11.60%  449.992    131 Template:Sfnp","  9.97%  386.901     52 Template:Cite_journal","  9.40%  364.679     65 Template:Cite_book","  7.40%  286.941     60 Template:Cite_web","  6.95%  269.611      5 Template:If_empty"]},"scribunto":{"limitreport-timeusage":{"value":"2.283","limit":"10.000"},"limitreport-memusage":{"value":32088388,"limit":52428800},"limitreport-logs":"anchor_id_list = table#1 {\\n  [\\"CITEREFAbbott2016\\"] = 1,\\n  [\\"CITEREFAlbert_Einstein_Archives1955\\"] = 1,\\n  [\\"CITEREFAlok2008\\"] = 1,\\n  [\\"CITEREFAmir_Aczel2014\\"] = 1,\\n  [\\"CITEREFAndrews2003\\"] = 1,\\n  [\\"CITEREFAndrzej2003\\"] = 1,\\n  [\\"CITEREFArntzenius2011\\"] = 1,\\n  [\\"CITEREFBloom2012\\"] = 1,\\n  [\\"CITEREFBodanis2000\\"] = 1,\\n  [\\"CITEREFBohr,_N.\\"] = 1,\\n  [\\"CITEREFBondiGold1948\\"] = 1,\\n  [\\"CITEREFBrian1996\\"] = 1,\\n  [\\"CITEREFCalaprice2000\\"] = 1,\\n  [\\"CITEREFCalaprice2005\\"] = 1,\\n  [\\"CITEREFCalaprice2010\\"] = 1,\\n  [\\"CITEREFCalapriceKennefickSchulmann2015\\"] = 1,\\n  [\\"CITEREFCalapriceLipscombe2005\\"] = 1,\\n  [\\"CITEREFCastelvecchi2014\\"] = 1,\\n  [\\"CITEREFChaplin1964\\"] = 1,\\n  [\\"CITEREFClark1971\\"] = 1,\\n  [\\"CITEREFCohen,_J._R.Graver,_L._M.1995\\"] = 1,\\n  [\\"CITEREFCosgrove,_Ben2014\\"] = 1,\\n  [\\"CITEREFCosgroveMorse\\"] = 1,\\n  [\\"CITEREFDas2003\\"] = 1,\\n  [\\"CITEREFDennis_Overbye2005\\"] = 1,\\n  [\\"CITEREFDiehlMoltz2008\\"] = 1,\\n  [\\"CITEREFDuchen,_Jessica2011\\"] = 1,\\n  [\\"CITEREFDvorsky2012\\"] = 1,\\n  [\\"CITEREFEinstein1901\\"] = 1,\\n  [\\"CITEREFEinstein1905a\\"] = 1,\\n  [\\"CITEREFEinstein1905b\\"] = 1,\\n  [\\"CITEREFEinstein1905c\\"] = 1,\\n  [\\"CITEREFEinstein1905d\\"] = 1,\\n  [\\"CITEREFEinstein1905e\\"] = 1,\\n  [\\"CITEREFEinstein1915\\"] = 1,\\n  [\\"CITEREFEinstein1916\\"] = 1,\\n  [\\"CITEREFEinstein1917a\\"] = 1,\\n  [\\"CITEREFEinstein1917b\\"] = 1,\\n  [\\"CITEREFEinstein1918\\"] = 1,\\n  [\\"CITEREFEinstein1923\\"] = 1,\\n  [\\"CITEREFEinstein1924\\"] = 1,\\n  [\\"CITEREFEinstein1926\\"] = 1,\\n  [\\"CITEREFEinstein1926b\\"] = 1,\\n  [\\"CITEREFEinstein1931\\"] = 1,\\n  [\\"CITEREFEinstein1948\\"] = 1,\\n  [\\"CITEREFEinstein1949\\"] = 1,\\n  [\\"CITEREFEinstein1950\\"] = 1,\\n  [\\"CITEREFEinstein1952\\"] = 1,\\n  [\\"CITEREFEinstein1954\\"] = 1,\\n  [\\"CITEREFEinstein1969\\"] = 1,\\n  [\\"CITEREFEinstein1979\\"] = 1,\\n  [\\"CITEREFEinstein1995\\"] = 1,\\n  [\\"CITEREFEinstein2009\\"] = 1,\\n  [\\"CITEREFEinsteinPodolskyRosen1935\\"] = 1,\\n  [\\"CITEREFEinsteinRosen1935\\"] = 1,\\n  [\\"CITEREFEinsteinde_Sitter1932\\"] = 1,\\n  [\\"CITEREFFahy2015\\"] = 1,\\n  [\\"CITEREFFine2017\\"] = 1,\\n  [\\"CITEREFFlood2018\\"] = 1,\\n  [\\"CITEREFFrancis2017\\"] = 2,\\n  [\\"CITEREFFred_JeromeRodger_Taylor2006\\"] = 1,\\n  [\\"CITEREFFölsing1997\\"] = 1,\\n  [\\"CITEREFGagnon2016\\"] = 1,\\n  [\\"CITEREFGalison2000\\"] = 1,\\n  [\\"CITEREFGalison2003\\"] = 1,\\n  [\\"CITEREFGhosh2016\\"] = 1,\\n  [\\"CITEREFGlick1987\\"] = 1,\\n  [\\"CITEREFGolden2000\\"] = 1,\\n  [\\"CITEREFGordin2020\\"] = 1,\\n  [\\"CITEREFGosling2010\\"] = 1,\\n  [\\"CITEREFGrandjean2017\\"] = 1,\\n  [\\"CITEREFGrandjean2018\\"] = 1,\\n  [\\"CITEREFHalpern2019\\"] = 1,\\n  [\\"CITEREFHeilbron2003\\"] = 1,\\n  [\\"CITEREFHewlettAnderson1962\\"] = 1,\\n  [\\"CITEREFHighfield2006\\"] = 1,\\n  [\\"CITEREFHighfieldCarter1993\\"] = 1,\\n  [\\"CITEREFHitchens2007\\"] = 1,\\n  [\\"CITEREFHoffmann1972\\"] = 1,\\n  [\\"CITEREFHolton1984\\"] = 1,\\n  [\\"CITEREFHoward2005\\"] = 1,\\n  [\\"CITEREFHoward2014\\"] = 1,\\n  [\\"CITEREFHoyle1948\\"] = 1,\\n  [\\"CITEREFIsaacson2007\\"] = 1,\\n  [\\"CITEREFIsaacson2008\\"] = 1,\\n  [\\"CITEREFIsaacson2009\\"] = 1,\\n  [\\"CITEREFJ._J._O\\u0026#039;ConnorE._F._Robertson2010\\"] = 1,\\n  [\\"CITEREFJerome2004\\"] = 1,\\n  [\\"CITEREFKatz\\"] = 1,\\n  [\\"CITEREFKuepper\\"] = 1,\\n  [\\"CITEREFLanouetteSilard1992\\"] = 1,\\n  [\\"CITEREFLate_City1955\\"] = 1,\\n  [\\"CITEREFLevenson\\"] = 1,\\n  [\\"CITEREFLevenson2017\\"] = 1,\\n  [\\"CITEREFLibman1939\\"] = 1,\\n  [\\"CITEREFLindemann\\"] = 1,\\n  [\\"CITEREFLindley2005\\"] = 1,\\n  [\\"CITEREFLindsayMargenau1981\\"] = 1,\\n  [\\"CITEREFMajor2007\\"] = 1,\\n  [\\"CITEREFMcTee\\"] = 1,\\n  [\\"CITEREFMehra2001\\"] = 1,\\n  [\\"CITEREFMissner1985\\"] = 1,\\n  [\\"CITEREFMontes-Santiago2017\\"] = 1,\\n  [\\"CITEREFMoore1989\\"] = 1,\\n  [\\"CITEREFMoring2004\\"] = 1,\\n  [\\"CITEREFNatGeo_TV\\"] = 1,\\n  [\\"CITEREFNeffe2007\\"] = 1,\\n  [\\"CITEREFNorth1965\\"] = 1,\\n  [\\"CITEREFNovak2015\\"] = 1,\\n  [\\"CITEREFNussbaumer2014\\"] = 2,\\n  [\\"CITEREFNussbaumer_and_Bieri2009\\"] = 1,\\n  [\\"CITEREFO\\u0026#039;ConnorRobertson1997\\"] = 1,\\n  [\\"CITEREFO\\u0026#039;RaifeartaighMcCann2014\\"] = 1,\\n  [\\"CITEREFO\\u0026#039;RaifeartaighMcCannNahmMitton2014\\"] = 1,\\n  [\\"CITEREFOppenheimer1971\\"] = 1,\\n  [\\"CITEREFOppenheimer1979\\"] = 1,\\n  [\\"CITEREFOverbye2014\\"] = 1,\\n  [\\"CITEREFOverbye2015\\"] = 1,\\n  [\\"CITEREFOverbye2016\\"] = 1,\\n  [\\"CITEREFOverbye2017\\"] = 1,\\n  [\\"CITEREFPais1979\\"] = 1,\\n  [\\"CITEREFPais1982\\"] = 1,\\n  [\\"CITEREFPais1994\\"] = 1,\\n  [\\"CITEREFParker2000\\"] = 1,\\n  [\\"CITEREFPaul_Arthur_Schilpp1951\\"] = 1,\\n  [\\"CITEREFPaul_S._BoyerMelvyn_Dubofsky2001\\"] = 1,\\n  [\\"CITEREFPenrose2007\\"] = 1,\\n  [\\"CITEREFPeter_GalisonGerald_James_HoltonSilvan_S._Schweber2008\\"] = 1,\\n  [\\"CITEREFPietrow2019\\"] = 1,\\n  [\\"CITEREFPogrebin1998\\"] = 1,\\n  [\\"CITEREFPruitt\\"] = 1,\\n  [\\"CITEREFReisman2006\\"] = 1,\\n  [\\"CITEREFRichard_Kroehling1991\\"] = 1,\\n  [\\"CITEREFRobeson2002\\"] = 1,\\n  [\\"CITEREFRobinson2015\\"] = 1,\\n  [\\"CITEREFRobinson2018\\"] = 1,\\n  [\\"CITEREFRogers2005\\"] = 1,\\n  [\\"CITEREFRosenkranz2002\\"] = 1,\\n  [\\"CITEREFRosenkranz2011\\"] = 1,\\n  [\\"CITEREFRoweSchulmann2007\\"] = 1,\\n  [\\"CITEREFRoweSchulmann2007a\\"] = 1,\\n  [\\"CITEREFRoweSchulmann2013\\"] = 1,\\n  [\\"CITEREFScheideler2002\\"] = 1,\\n  [\\"CITEREFSchweber2008\\"] = 1,\\n  [\\"CITEREFShine2018\\"] = 1,\\n  [\\"CITEREFSmith1996\\"] = 1,\\n  [\\"CITEREFSpielbergAnderson1995\\"] = 1,\\n  [\\"CITEREFStachel1966\\"] = 1,\\n  [\\"CITEREFStachel2002\\"] = 1,\\n  [\\"CITEREFStachel_et_al.2008\\"] = 1,\\n  [\\"CITEREFStone2013\\"] = 1,\\n  [\\"CITEREFTroemel-Ploetz,_D.1990\\"] = 1,\\n  [\\"CITEREFWaldrop2017\\"] = 1,\\n  [\\"CITEREFWalker,_Evan_Harris1989\\"] = 1,\\n  [\\"CITEREFWeinberg2005\\"] = 1,\\n  [\\"CITEREFWeinstein2015\\"] = 1,\\n  [\\"CITEREFWells2008\\"] = 1,\\n  [\\"CITEREFWhittaker1955\\"] = 1,\\n  [\\"CITEREFWüthrich2015\\"] = 1,\\n  [\\"CITEREFYangHamilton2010\\"] = 1,\\n  [\\"CITEREFZimmer2013\\"] = 1,\\n  [\\"CITEREFvon_Hirschhausen,_Ulrike2007\\"] = 1,\\n}\\ntemplate_list = table#1 {\\n  [\\"!\\"] = 1,\\n  [\\"1921 Nobel Prize winners\\"] = 1,\\n  [\\"Authority control\\"] = 1,\\n  [\\"Birth date\\"] = 1,\\n  [\\"Circa\\"] = 1,\\n  [\\"Citation needed\\"] = 1,\\n  [\\"Cite EB1922\\"] = 1,\\n  [\\"Cite arxiv\\"] = 1,\\n  [\\"Cite book\\"] = 65,\\n  [\\"Cite journal\\"] = 52,\\n  [\\"Cite magazine\\"] = 2,\\n  [\\"Cite news\\"] = 23,\\n  [\\"Cite newspaper\\"] = 1,\\n  [\\"Cite speech\\"] = 1,\\n  [\\"Cite thesis\\"] = 1,\\n  [\\"Cite web\\"] = 60,\\n  [\\"Clarify\\"] = 2,\\n  [\\"Copley Medallists 1901–1950\\"] = 1,\\n  [\\"Credit\\"] = 1,\\n  [\\"Curlie\\"] = 1,\\n  [\\"DEFAULTSORT:Einstein, Albert\\"] = 1,\\n  [\\"Death date and age\\"] = 1,\\n  [\\"Div col\\"] = 5,\\n  [\\"Div col end\\"] = 5,\\n  [\\"Einstein\\"] = 1,\\n  [\\"FRS 1921\\"] = 1,\\n  [\\"Good article\\"] = 1,\\n  [\\"Gutenberg author\\"] = 1,\\n  [\\"Harvid\\"] = 1,\\n  [\\"Harvp\\"] = 1,\\n  [\\"IPA-de\\"] = 1,\\n  [\\"IPAc-en\\"] = 1,\\n  [\\"ISBN\\"] = 3,\\n  [\\"Infobox scientist\\"] = 1,\\n  [\\"Internet Archive author\\"] = 1,\\n  [\\"Lang\\"] = 1,\\n  [\\"Librivox author\\"] = 1,\\n  [\\"Main\\"] = 19,\\n  [\\"Marriage\\"] = 2,\\n  [\\"Math\\"] = 1,\\n  [\\"Mdash\\"] = 1,\\n  [\\"More\\"] = 1,\\n  [\\"Nobel Prize in Physics Laureates 1901–1925\\"] = 1,\\n  [\\"Nobelprize\\"] = 1,\\n  [\\"Nowrap\\"] = 3,\\n  [\\"PM20\\"] = 1,\\n  [\\"Page needed\\"] = 3,\\n  [\\"Philosophy of science\\"] = 1,\\n  [\\"Plainlist\\"] = 9,\\n  [\\"Portal bar\\"] = 1,\\n  [\\"Pp\\"] = 1,\\n  [\\"Redirect\\"] = 1,\\n  [\\"Reflist\\"] = 2,\\n  [\\"Refn\\"] = 1,\\n  [\\"Relativity\\"] = 1,\\n  [\\"Respell\\"] = 1,\\n  [\\"Scholia\\"] = 1,\\n  [\\"See also\\"] = 3,\\n  [\\"Sfn\\"] = 1,\\n  [\\"Sfnp\\"] = 131,\\n  [\\"Short description\\"] = 1,\\n  [\\"Sister project links\\"] = 1,\\n  [\\"Snd\\"] = 6,\\n  [\\"TOC limit\\"] = 1,\\n  [\\"US patent\\"] = 1,\\n  [\\"Use American English\\"] = 1,\\n  [\\"Use dmy dates\\"] = 1,\\n  [\\"W\\"] = 2,\\n  [\\"Webarchive\\"] = 1,\\n}\\narticle_whitelist = table#1 {\\n}\\ntable#1 {\\n}\\ntable#1 {\\n}\\n","limitreport-profile":[["?","440","18.2"],["Scribunto_LuaSandboxCallback::callParserFunction","420","17.4"],["recursiveClone \\u003CmwInit.lua:41\\u003E","220","9.1"],["dataWrapper \\u003Cmw.lua:668\\u003E","160","6.6"],["Scribunto_LuaSandboxCallback::getExpandedArgument","160","6.6"],["Scribunto_LuaSandboxCallback::getEntity","120","5.0"],["Scribunto_LuaSandboxCallback::gsub","120","5.0"],["Scribunto_LuaSandboxCallback::match","100","4.1"],["Scribunto_LuaSandboxCallback::plain","60","2.5"],["(for generator)","60","2.5"],["[others]","560","23.1"]]},"cachereport":{"origin":"mw1290","timestamp":"20210404015308","ttl":21600,"transientcontent":true}}});});</script>
<script type="application/ld+json">{"@context":"https:\\/\\/schema.org","@type":"Article","name":"Albert Einstein","url":"https:\\/\\/en.wikipedia.org\\/wiki\\/Albert_Einstein","sameAs":"http:\\/\\/www.wikidata.org\\/entity\\/Q937","mainEntity":"http:\\/\\/www.wikidata.org\\/entity\\/Q937","author":{"@type":"Organization","name":"Contributors to Wikimedia projects"},"publisher":{"@type":"Organization","name":"Wikimedia Foundation, Inc.","logo":{"@type":"ImageObject","url":"https:\\/\\/www.wikimedia.org\\/static\\/images\\/wmf-hor-googpub.png"}},"datePublished":"2001-11-05T18:26:16Z","dateModified":"2021-04-04T01:52:51Z","image":"https:\\/\\/upload.wikimedia.org\\/wikipedia\\/commons\\/3\\/3e\\/Einstein_1921_by_F_Schmutzer_-_restoration.jpg","headline":"German-born theoretical physicist; developer of the theory of relativity (1879\\u20131955)"}</script>
<script>(RLQ=window.RLQ||[]).push(function(){mw.config.set({"wgBackendResponseTime":196,"wgHostname":"mw1393"});});</script>
</body></html>'
];
