# 30aug17abu
# (c) Software Lab. Alexander Burger

(symbols 'gis 'pico)

(push1 '*JS (allow "@lib/gis.js"))

(local) nm
(de nm (Lat Lon)
   (pack
      (round (- Lat 90.0))
      ", "
      (round (- Lon 180.0)) ) )

(local) [lat lon fmt]
(de lat (Lat)
   (format (- Lat 90.0) `*Scl) )

(de lon (Lon)
   (format (- Lon 180.0) `*Scl) )

(de fmt (Lat Str Lon)
   (when (or Lat Lon)
      (pack (lat Lat) Str (lon Lon)) ) )

# Short distance, assuming flat earth
(de distance (Lat1 Lon1 Lat2 Lon2)  # [m]
   (let
      (DX (*/ (- Lon2 Lon1) 6378000 pi 180.0)
         DY (*/ (cos (*/ Lat1 pi 180.0)) (- Lat2 Lat1) 6378000 pi `(* 1.0 180.0)) )
      (sqrt (+ (* DX DX) (* DY DY))) ) )

# Latitude Field
(local) +LatField
(class +LatField +Fmt +FixField)

(dm T @
   (pass super
      '((Num) (- Num 90.0))
      '((Lat) (+ Lat 90.0))
      `*Scl ) )

# Longitude Field
(local) +LonField
(class +LonField +Fmt +FixField)

(dm T @
   (pass super
      '((Num) (- Num 180.0))
      '((Lon) (+ Lon 180.0))
      `*Scl ) )

# Clickable position field
(local) [+LatLonField msg obj lt ln]
(class +LatLonField +TextField)

(dm T (Msg . @)
   (=: msg Msg)
   (pass super)
   (=: able) )

(dm set> (X Dn)
   (=: obj (car X))
   (=: lt (cadr X))
   (=: ln (cddr X))
   (super (fmt (: lt) ", " (: ln)) Dn) )

(dm js> ()
   (if (try (: msg) (: obj) (: lt) (: ln))
      (pack
         (fmt (: lt) ", " (: ln))
         "&+"
         (ht:Fmt (sesId (mkUrl @))) )
      (super) ) )

(dm val> ()
   (cons (: obj) (: lt) (: ln)) )

(dm show> ("Var")
   (showFld
      (if (try (: msg) (: obj) (: lt) (: ln))
         (<href>
            (fmt (: lt) ", " (: ln))
            (mkUrl @) )
         (super "Var") ) ) )

# OpenLayers / OpenStreetMap
# (val *Osm) -> ((lat1 . lat2) (lon1 . lon2) . zoom)
(local) [*Osm <osm> osmStat osmClick osmDrag <poi> <line>]

(mapc allow '(osmStat osmClick osmDrag))

(de <osm> (Lat Lon Zoom Click Upd)
   (<div> '(map (id . map)))
   (when (val *Osm)
      (setq
         Lat (*/ (+ (caar @) (cdar @)) 2)
         Lon (*/ (+ (caadr @) (cdadr @)) 2)
         Zoom (cddr @) ) )
   (with *Top
      (css "https://openlayers.org/en/v4.2.0/css/ol.css")
      (javascript "https://openlayers.org/en/v4.2.0/build/ol.js"
         "osm('map', " Lat ", " Lon ", " Zoom ", "
         (if2 Click (and Upd (: able)) 2 1 0 0) ")" )
      (=: osmClick Click) ) )

(de osmStat (Lat1 Lon1 Lat2 Lon2 Zoom)
   (when *Osm
      (set @
         (cons
            (cons Lat1 Lat2)
            (cons Lon1 Lon2)
            Zoom ) ) ) )

(de osmClick (Lat Lon)
   (with *Top
      (and (: osmClick) (@ Lat Lon)) ) )

(de osmDrag (Txt Lat Lon)
   (with *Top
      (and
         (: able)
         (assoc Txt (: osmDrag))
         ((cdr @) Txt Lat Lon) ) ) )

(de <poi> (Lat Lon Img X Y Txt DY Col Url Drag Upd)
   (with *Top
      (javascript NIL
         "poi(" Lat ", " Lon ", '" (sesId Img) "', " X ", " Y ", '"
         Txt "', " DY ", '" Col "', '" (and Url (sesId @)) "', "
         (if2 (and Drag (: able)) Upd 2 1 0 0) ")" )
      (and Drag (push (:: osmDrag) (cons Txt @))) ) )

(de <line> (Col Lat1 Lon1 Lat2 Lon2)
   (with *Top
      (javascript NIL
         "line('" Col "', " Lat1 ", " Lon1 ", " Lat2 ", " Lon2 ")" ) ) )

# Google Maps
(local) [google <google>]
(de google (Ttl Lat Lon Zoom Tar)
   (<href> Ttl
      (pack "https://www.google.com/maps/@" (fmt Lat "," Lon) "," Zoom "z")
      Tar ) )

(de <google> (Lat Lon DX DY)
   (prinl
      "<iframe width=\"" DX "\" height=\"" DY "\" frameborder=\"3\" \
      src=\"https://www.google.com/maps?source=s_q&amp;q="
      (fmt Lat "," Lon)
      "&amp;output=embed\"></iframe>" ) )

# vi:et:ts=3:sw=3
