/*
    SPDX-FileCopyrightText: 2010 Marco Martin <notmart@gmail.com>
    SPDX-FileCopyrightText: 2016 Jan Grulich <jgrulich@redhat.com>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

import QtQuick 2.1
import org.kde.plasma.core 2.0 as PlasmaCore
import org.kde.kirigami 2.15 as Kirigami

Item {
    id: listItem

    default property alias content: paddingItem.data
    property alias containsMouse: itemMouse.containsMouse
    property alias enabled: itemMouse.enabled
    property bool checked: false
    property bool sectionDelegate: false

    signal clicked

    width: parent ? parent.width : childrenRect.width
    height: paddingItem.childrenRect.height + background.margins.top + background.margins.bottom

    implicitHeight: paddingItem.childrenRect.height + Math.round(Kirigami.Units.gridUnit / 2)

    Connections {
        target: listItem
        function onCheckedChanged() {
            background.color = (listItem.checked ? highlightColor : baseColor)
        }
        function onSectionDelegateChanged() {
            background.color = (listItem.sectionDelegate ? alternateBaseColor : baseColor)
        }
    }

    Rectangle {
        id : background

        anchors.fill: parent
        visible: listItem.ListView.view ? listItem.ListView.view.highlight === null : true
        opacity: itemMouse.containsMouse && !itemMouse.pressed ? 0.5 : 1
        Component.onCompleted: {
            color = (listItem.sectionDelegate ? alternateBaseColor : (listItem.checked ? highlightColor : baseColor))
        }
        Behavior on opacity { NumberAnimation { duration: Kirigami.Units.longDuration } }
    }

    PlasmaCore.SvgItem {
        svg: PlasmaCore.Svg {imagePath: "widgets/listitem"}
        elementId: "separator"
        anchors {
            left: parent.left
            right: parent.right
            top: parent.top
        }
        height: naturalSize.height
        visible: listItem.sectionDelegate || (typeof(index) != "undefined" && index > 0 && !listItem.checked && !itemMouse.pressed)
    }

    MouseArea {
        id: itemMouse
        property bool changeBackgroundOnPress: !listItem.checked && !listItem.sectionDelegate
        anchors.fill: background
        enabled: false

        onClicked: listItem.clicked()
        onPressAndHold: listItem.pressAndHold()
        onPressed: if (changeBackgroundOnPress) background.prefix = "pressed"
        onReleased: if (changeBackgroundOnPress) background.prefix = "normal"
        onCanceled: if (changeBackgroundOnPress) background.prefix = "normal"

        Item {
            id: paddingItem
            anchors {
                fill: parent
                margins: Math.round(Kirigami.Units.gridUnit / 3)
            }
        }
    }

    Accessible.role: Accessible.ListItem
}
