from sdl2 cimport *
cimport sdl2

from pygame_sdl2.rect import Rect
from pygame_sdl2.color import Color

include "event_list.pxi"
ACTIVEEVENT = SDL_LASTEVENT - 1
VIDEORESIZE = SDL_LASTEVENT - 2
VIDEOEXPOSE = SDL_LASTEVENT - 3

include "keycode_list.pxi"

include "glattr.pxi"
GL_SWAP_CONTROL = -1

GL_CONTEXT_PROFILE_CORE = SDL_GL_CONTEXT_PROFILE_CORE
GL_CONTEXT_PROFILE_COMPATIBILITY = SDL_GL_CONTEXT_PROFILE_COMPATIBILITY
GL_CONTEXT_PROFILE_ES = SDL_GL_CONTEXT_PROFILE_ES

RLEACCEL = SDL_RLEACCEL
SRCCOLORKEY = 0

# Surface flags.
SRCALPHA  = 0x80000000
HWSURFACE = 0x40000000
SWSURFACE = 0

# Window flags.
FULLSCREEN = SDL_WINDOW_FULLSCREEN
OPENGL = SDL_WINDOW_OPENGL
NOFRAME = SDL_WINDOW_BORDERLESS
RESIZABLE = SDL_WINDOW_RESIZABLE
DOUBLEBUF = 0

WINDOW_FULLSCREEN = SDL_WINDOW_FULLSCREEN
WINDOW_SHOWN = SDL_WINDOW_SHOWN
WINDOW_HIDDEN = SDL_WINDOW_HIDDEN
WINDOW_OPENGL = SDL_WINDOW_OPENGL
WINDOW_NOFRAME = SDL_WINDOW_BORDERLESS
WINDOW_BORDERLESS = SDL_WINDOW_BORDERLESS
WINDOW_RESIZABLE = SDL_WINDOW_RESIZABLE
WINDOW_MINIMIZED = SDL_WINDOW_MINIMIZED
WINDOW_MAXIMIZED = SDL_WINDOW_MAXIMIZED
WINDOW_INPUT_GRABBED = SDL_WINDOW_INPUT_GRABBED
WINDOW_INPUT_FOCUS = SDL_WINDOW_MOUSE_FOCUS
WINDOW_FULLSCREEN_DESKTOP = SDL_WINDOW_FULLSCREEN_DESKTOP
WINDOW_FOREIGN = SDL_WINDOW_FOREIGN
WINDOW_ALLOW_HIGHDPI = SDL_WINDOW_ALLOW_HIGHDPI

WINDOWPOS_CENTERED = SDL_WINDOWPOS_CENTERED
WINDOWPOS_UNDEFINED = SDL_WINDOWPOS_UNDEFINED

# Blend modes
BLEND_RGB_ADD = BLEND_ADD = 0x1
BLEND_RGB_SUB = BLEND_SUB = 0x2
BLEND_RGB_MULT = BLEND_MULT = 0x3
BLEND_RGB_MIN = BLEND_MIN = 0x4
BLEND_RGB_MAX = BLEND_MAX = 0x5

BLEND_RGBA_ADD = 0x6
BLEND_RGBA_SUB = 0x7
BLEND_RGBA_MULT = 0x8
BLEND_RGBA_MIN = 0x9
BLEND_RGBA_MAX = 0x10

BLEND_PREMULTIPLIED = 0x11

# Scrap types.
SCRAP_TEXT = "text/plain"

BYTEORDER = SDL_BYTEORDER
LIL_ENDIAN = SDL_LIL_ENDIAN
BIG_ENDIAN = SDL_BIG_ENDIAN

SDL_VERSION_TUPLE = (SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL)

globals().update(dict(
    KMOD_NONE = sdl2.KMOD_NONE,

    KMOD_LSHIFT = sdl2.KMOD_LSHIFT,
    KMOD_RSHIFT = sdl2.KMOD_RSHIFT,
    KMOD_SHIFT = sdl2.KMOD_SHIFT,

    KMOD_LCTRL = sdl2.KMOD_LCTRL,
    KMOD_RCTRL = sdl2.KMOD_RCTRL,
    KMOD_CTRL = sdl2.KMOD_CTRL,

    KMOD_LALT = sdl2.KMOD_LALT,
    KMOD_RALT = sdl2.KMOD_RALT,
    KMOD_ALT = sdl2.KMOD_ALT,

    KMOD_LGUI = sdl2.KMOD_LGUI,
    KMOD_RGUI = sdl2.KMOD_RGUI,
    KMOD_GUI = sdl2.KMOD_GUI,

    KMOD_LMETA = sdl2.KMOD_LGUI,
    KMOD_RMETA = sdl2.KMOD_RGUI,
    KMOD_META = sdl2.KMOD_GUI,

    KMOD_NUM = sdl2.KMOD_NUM,
    KMOD_CAPS = sdl2.KMOD_CAPS,

    KMOD_MODE = sdl2.KMOD_MODE,

    K_FIRST = 0,
    K_LAST = sdl2.SDLK_SLEEP,

    K_BREAK = sdl2.SDLK_PAUSE,
    K_EURO = sdl2.SDLK_CURRENCYUNIT,

    K_KP0 = sdl2.SDLK_KP_0,
    K_KP1 = sdl2.SDLK_KP_1,
    K_KP2 = sdl2.SDLK_KP_2,
    K_KP3 = sdl2.SDLK_KP_3,
    K_KP4 = sdl2.SDLK_KP_4,
    K_KP5 = sdl2.SDLK_KP_5,
    K_KP6 = sdl2.SDLK_KP_6,
    K_KP7 = sdl2.SDLK_KP_7,
    K_KP8 = sdl2.SDLK_KP_8,
    K_KP9 = sdl2.SDLK_KP_9,

    K_LMETA = sdl2.SDLK_LGUI,
    K_LSUPER = sdl2.SDLK_LGUI,
    K_RMETA = sdl2.SDLK_RGUI,
    K_RSUPER = sdl2.SDLK_RGUI,

    K_NUMLOCK = sdl2.SDLK_NUMLOCKCLEAR,
    K_SCROLLOCK = sdl2.SDLK_SCROLLLOCK,
    K_PRINT = sdl2.SDLK_PRINTSCREEN,
))

TOUCH_MOUSEID = -1

include "controller.pxi"

POWERSTATE_UNKNOWN = SDL_POWERSTATE_UNKNOWN
POWERSTATE_ON_BATTERY = SDL_POWERSTATE_ON_BATTERY
POWERSTATE_NO_BATTERY = SDL_POWERSTATE_NO_BATTERY
POWERSTATE_CHARGING = SDL_POWERSTATE_CHARGING
POWERSTATE_CHARGED = SDL_POWERSTATE_CHARGED

