//
// C++ Implementation: CSceneEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CSceneEdit.hpp"

CSceneEditDlg::CSceneEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);
    
   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.color_back, SIGNAL(released()), this, SLOT(slotEditColor()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CSceneEditDlg::~CSceneEditDlg() {
}

void CSceneEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CSceneEditDlg::slotGetData(FolderListItem *i)
{
    char mybuff[256];
    unsigned int colorr;
    unsigned int colorg;
    unsigned int colorb;

    point=i;
    
    ui.text->setText(i->text(0));
    
    ui.wgx->setValue(i->GetValue("wgx",i).toDouble());
    ui.wgy->setValue(i->GetValue("wgy",i).toDouble());
    ui.wgz->setValue(i->GetValue("wgz",i).toDouble());

    ui.cgplane->setChecked(i->GetValue("cgplane",i).toInt());

    strncpy(mybuff,i->GetValue("color_back",i).toAscii().constData() ,8);
    sscanf(mybuff,"%02X%02X%02X",&colorr,&colorg,&colorb);
    mycolor.setRgb(colorr,colorg,colorb);
    if ( mycolor.isValid() ){
      QPixmap pix (100,15);
      pix.fill( mycolor );
      QIcon icon(pix);
      ui.color_back->setIcon( icon );
      QSize size(100,15);
      ui.color_back->setIconSize( size );      
    }
    qWarning( "CSceneEditDlg::slotGetData(): Geht !" );
}

void CSceneEditDlg::slotEditData()
{
    char mybuff[256];
    
    if(point != NULL){
        point->setText(0,ui.text->text());
        point->SetValue("wgx",ui.wgx->text());
        point->SetValue("wgy",ui.wgy->text());
        point->SetValue("wgz",ui.wgz->text());
        point->SetValue("cgplane", ui.cgplane->isChecked() ? "1" : "0");

        sprintf(mybuff,"%02X%02X%02X",mycolor.red(),mycolor.green(),mycolor.blue());
        point->SetValue("color_back",mybuff);

        point->updategl();
    }
    qWarning( "CSceneEditDlg::slotEditData(): Geht !" );
}

void CSceneEditDlg::slotEditColor()
{
    QColor color = QColorDialog::getColor(mycolor,this );
    if ( color.isValid() ) {
       QPixmap pix (100,15) ;
       pix.fill( color );
       QIcon icon(pix);
       ui.color_back->setIcon( icon );
       QSize size(100,15);
       ui.color_back->setIconSize( size );      
       mycolor = color;
    }
    qWarning( "MyLampEditDlg::slotEditColorAmb(): Geht !" );
}
