/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef COLORLABEL_H
#define COLORLABEL_H

#include <QLabel>
#include <QColor>
#include <QMouseEvent>
/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class ColorLabel : public QLabel
{
  Q_OBJECT
  private:
    QColor m_color;

  public:
    ColorLabel(QWidget *parent = 0, QColor color = Qt::white);
    ColorLabel(const ColorLabel &);
    ~ColorLabel(){};

    const QColor & color() const {return m_color;}
    void setColor(const QColor & color);

  protected:
    void mousePressEvent(QMouseEvent * ev)
    {
      if(ev->button() == Qt::LeftButton)
        setFrameStyle(QFrame::StyledPanel | QFrame::Sunken);
    }
    void mouseReleaseEvent(QMouseEvent * ev)
    {
      if(ev->button() == Qt::LeftButton)
      {
        setFrameStyle(QFrame::StyledPanel);
        if((ev->x() >= 0 && ev->y() >= 0) && (ev->x() < width() && ev->y() < height()))
          emit clicked();
      }
    }

  signals:
    void clicked();
};

#endif
