/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef USERLISTICONCONFIGUREWGT_H
#define USERLISTICONCONFIGUREWGT_H

#include <QWidget>
#include <QSpinBox>
#include <QLabel>
#include <QLineEdit>

class UserListIconFormat;
#include "userlisticonformat.h"

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class UserListIconConfigureWgt : public QWidget
{
  Q_OBJECT
  private:
    UserListIconFormat m_format;

    QLabel*            m_textLab;
    QLabel*            m_totalLab;
    QLabel*            m_genderLab;
    QLabel*            m_statusLab;
    QLabel*            m_avatarLab;

    QLabel*            m_heightLab;
    QLabel*            m_widthLab;
    QLabel*            m_xOffsetLab;
    QLabel*            m_yOffsetLab;

//     QSpinBox*          m_spacingSpbx;
    QSpinBox*          m_totalWidthSpbx;
    QSpinBox*          m_totalHeightSpbx;

    QSpinBox*          m_genderWidthSpbx;
    QSpinBox*          m_genderHeightSpbx;
    QSpinBox*          m_statusWidthSpbx;
    QSpinBox*          m_statusHeightSpbx;
    QSpinBox*          m_avatarWidthSpbx;
    QSpinBox*          m_avatarHeightSpbx;

    QSpinBox*          m_genderXSpbx;
    QSpinBox*          m_genderYSpbx;
    QSpinBox*          m_statusXSpbx;
    QSpinBox*          m_statusYSpbx;
    QSpinBox*          m_avatarXSpbx;
    QSpinBox*          m_avatarYSpbx;

    QLineEdit*         m_textEdit;

  public:
    UserListIconConfigureWgt(QWidget *parent = 0, const UserListIconFormat& = UserListIconFormat());
    ~UserListIconConfigureWgt();

    void retranslate();
    void setFormat(const UserListIconFormat&);

  public slots:
    void changeFormat();

  signals:
    void formatChanged(const UserListIconFormat&);

};

#endif
