% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{getPearsonResiduals}
\alias{getPearsonResiduals}
\alias{getPearsonResiduals.default}
\alias{getPearsonResiduals.gam}
\title{Get Pearson residuals}
\usage{
getPearsonResiduals(object, ...)

\method{getPearsonResiduals}{default}(object, ...)

\method{getPearsonResiduals}{gam}(object, ...)
}
\arguments{
\item{object}{a fitted model.}

\item{...}{additional parameters to be passed on, usually to the residual function of the respective model class.}
}
\description{
Wrapper to get the Pearson residuals of a fitted model.
}
\details{
The purpose of this wrapper is to extract the Pearson residuals of a fitted model.

This needed to be adopted because for some reason, mgcv uses the argument "scaled.pearson" for what most packags define as "pearson". See comments in ?residuals.gam.
}
\examples{
testData = createData(sampleSize = 400, family = gaussian())

fittedModel <- lm(observedResponse ~ Environment1 , data = testData)

# response that was used to fit the model
getObservedResponse(fittedModel)

# predictions of the model for these points
getFitted(fittedModel)

# extract simulations from the model as matrix
getSimulations(fittedModel, nsim = 2)

# extract simulations from the model for refit (often requires different structure)
x = getSimulations(fittedModel, nsim = 2, type = "refit")

getRefit(fittedModel, x[[1]])

getRefit(fittedModel, getObservedResponse(fittedModel))
}
\seealso{
\link{getObservedResponse}, \link{getSimulations}, \link{getRefit}, \link{getFixedEffects}, \link{getFitted}
}
\author{
Florian Hartig
}
