% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{wrap_rmd}
\alias{wrap_rmd}
\title{Wrap long lines in Rmd files}
\usage{
wrap_rmd(file, width = 80, text = NULL, backup)
}
\arguments{
\item{file}{The input Rmd file.}

\item{width}{The expected line width.}

\item{text}{A character vector of text lines, as an alternative to \code{file}. If
\code{text} is not \code{NULL}, \code{file} is ignored.}

\item{backup}{Path to back up the original file in case anything goes
wrong. If set to \code{NULL}, no backup is made. The default value is constructed
from \code{file} by adding \code{__} before the base filename.}
}
\value{
If \code{file} is provided, it is overwritten; if \code{text} is
  provided, a character vector is returned.
}
\description{
This function wraps long paragraphs in an R Markdown file. Other elements are
not wrapped: the YAML preamble, fenced code blocks, section headers and
indented elements. The main reason for wrapping long lines is to make it
easier to review differences in version control.
}
\note{
Currently it does not wrap blockquotes or lists (ordered or unordered).
  This feature may or may not be added in the future.
}
\examples{
wrap_rmd(text = c("```", "1+1", "```", "- a list item", "> a quote", "", 
    paste(rep("this is a normal paragraph", 5), collapse = " ")))
}
