% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSD.pie.R
\name{LSD.pie}
\alias{LSD.pie}
\title{Custom-built piechart version}
\usage{
LSD.pie(
  props,
  x = 0,
  y = 0,
  radius = 1,
  colpal = "prgn",
  simulate = FALSE,
  daltonize = FALSE,
  cvd = "p",
  edges = 1000,
  add = FALSE,
  xlim = c(-1, 1),
  ylim = c(-1, 1),
  main = "LSD.pie: piecharts",
  alpha = NULL,
  addPercent = FALSE,
  textcol = "black",
  clockwise = FALSE,
  init.angle = 0,
  labels = c(),
  cex = 1,
  cex.percentage = cex,
  border = NA,
  ...
)
}
\arguments{
\item{props}{a numeric vector giving the relations of the pie pieces (need not to be normalized).}

\item{x}{x-position of the piechart.}

\item{y}{y-position of the piechart.}

\item{radius}{a numeric value giving the radius of the piechart.}

\item{colpal}{a character vector containing R built-in color names or a name of a \code{LSD} colorpalette as a character string (see disco() or \code{\link{disco}}) (defaults to "heat", if not specified).}

\item{simulate}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to simulate dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{daltonize}{logical: if \code{TRUE} (\code{FALSE} by default), a converted colorpalette is used to enhance dichromat vision according to \url{http://www.daltonize.org} (see \code{\link{daltonize}}).}

\item{cvd}{character string implying the type of color vision deficiency ("p" for protanope, "d" for deuteranope or "t" for tritanope).}

\item{edges}{an integer giving the number of edges the "circle" will have.}

\item{add}{logical: if \code{TRUE} (\code{FALSE} by default), the pie is added to an existing plot.}

\item{xlim}{x limits, standard graphics parameter.}

\item{ylim}{y limits, standard graphics parameter.}

\item{main}{title(s) of the plot, standard graphics parameter.}

\item{alpha}{alpha value: a two-digit integer between 01 and 99 for color opacity, i.e. appearance of partial or full transparency (usage omitted by default).}

\item{addPercent}{logical: if \code{TRUE} (\code{FALSE} by default), the percentage of each slice is written inside of the pie.}

\item{textcol}{a R build-in color for the percentages of \code{addPercent}.}

\item{clockwise}{if \code{TRUE} (\code{FALSE} by default), slices drawn clockwise (counter clockwise, if \code{FALSE}).}

\item{init.angle}{a numerical value representing an angle as a starting angle for the drawn slices.}

\item{labels}{a character vector giving the names for the pie slices.}

\item{cex}{scaling a numeric value giving the expansion factor for the slice names (if labels are given).}

\item{cex.percentage}{a numeric value giving the expansion factor for the percentage values (if \code{addPercent = TRUE}).}

\item{border}{a R build-in color giving the border color (NA by default).}

\item{...}{additional parameters to be passed to points and plot.}
}
\description{
Piecharts at arbitrary position and radii.
}
\examples{
emptyplot(xlim=c(1,9),ylim=c(1,9))
mtext(paste("LSD.pie: piecharts"),3,2,cex=1.25)
polygon(c(4,2,4,7,8),c(4,8,4,2,8))
LSD.pie(sample(1:50,5),4,4,add=TRUE,radius=2,colpal="prgn",alpha=75)
LSD.pie(sample(1:50,5),2,8,add=TRUE,colpal="prgn",alpha=75)
LSD.pie(sample(1:50,5),8,8,add=TRUE,colpal="prgn",alpha=75)
LSD.pie(sample(1:50,5),7,2,add=TRUE,colpal="prgn",alpha=75)
}
\seealso{
\code{\link{demotour}}, \code{\link{disco}}, \code{\link{colorpalette}}
}
\author{
Bjoern Schwalb, Carina Demel
}
\keyword{pie}
