% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{cloneWorksheet}
\alias{cloneWorksheet}
\title{Clone a worksheet to a workbook}
\usage{
cloneWorksheet(wb, sheetName, clonedSheet)
}
\arguments{
\item{wb}{A Workbook object to attach the new worksheet}

\item{sheetName}{A name for the new worksheet}

\item{clonedSheet}{The name of the existing worksheet to be cloned.}
}
\value{
XML tree
}
\description{
Clone a worksheet to a Workbook object
}
\examples{
## Create a new workbook
wb <- createWorkbook("Fred")

## Add 3 worksheets
addWorksheet(wb, "Sheet 1")
cloneWorksheet(wb, "Sheet 2", clonedSheet = "Sheet 1")

## Save workbook
\dontrun{
saveWorkbook(wb, "cloneWorksheetExample.xlsx", overwrite = TRUE)
}
}
\author{
Reinhold Kainhofer
}
