% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_factorstructure.R
\name{check_sphericity_bartlett}
\alias{check_sphericity_bartlett}
\title{Bartlett's Test of Sphericity}
\usage{
check_sphericity_bartlett(x, ...)
}
\arguments{
\item{x}{A dataframe.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A list of indices related to sphericity.
}
\description{
Bartlett's (1951) test of sphericity tests whether a matrix (of correlations)
is significantly different from an identity matrix. The test provides
probability that the correlation matrix has significant correlations among at
least some of the variables in a dataset, a prerequisite for factor analysis
to work. In other words, before starting with factor analysis, one needs to
check whether Bartlett’s test of sphericity is significant.
}
\details{
This function is strongly inspired by the \code{cortest.bartlett}
function in the \pkg{psych} package (Revelle, 2016). All credit goes to its
author.
}
\examples{
library(parameters)
check_sphericity_bartlett(mtcars)
}
\references{
\itemize{
\item Revelle, W. (2016). How To: Use the psych package for Factor Analysis
and data reduction.
\item Bartlett, M. S. (1951). The effect of standardization on a Chi-square
approximation in factor analysis. Biometrika, 38(3/4), 337-344.
}
}
