% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_ls.r
\name{ls}
\alias{ls}
\title{A wrapper function for base::ls}
\usage{
ls(
  name,
  pos = -1L,
  envir = as.environment(pos),
  all.names = FALSE,
  pattern,
  sorted = TRUE
)
}
\arguments{
\item{name, pos, envir, all.names, pattern, sorted}{as the original \code{base::ls()}.}
}
\value{
As the original \code{base::ls()} except when \code{all.names} is \code{TRUE}
and \code{envir} is \code{.GlobalEnv}, hidden pbd objects such as
\code{.pbd_env} and \code{.pbdenv} will not be returned.
}
\description{
The \code{ls()} function with modification to avoid listing hidden
pbd objects.
}
\details{
As the original \code{base::ls()}, it returns the names of the objects.
}
\examples{
\dontrun{
library(pbdRPC, quietly = TRUE)
ls(all.names = TRUE)
base::ls(all.names = TRUE)
}

}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.
}
