% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_vcovG.R
\name{vcovNW}
\alias{vcovNW}
\alias{vcovNW.plm}
\alias{vcovNW.pcce}
\title{Newey and West (1987) Robust Covariance Matrix Estimator}
\usage{
vcovNW(x, ...)

\method{vcovNW}{plm}(
  x,
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  maxlag = NULL,
  wj = function(j, maxlag) 1 - j/(maxlag + 1),
  ...
)

\method{vcovNW}{pcce}(
  x,
  type = c("HC0", "sss", "HC1", "HC2", "HC3", "HC4"),
  maxlag = NULL,
  wj = function(j, maxlag) 1 - j/(maxlag + 1),
  ...
)
}
\arguments{
\item{x}{an object of class \code{"plm"} or \code{"pcce"}}

\item{\dots}{further arguments}

\item{type}{the weighting scheme used, one of \code{"HC0"}, \code{"sss"},
\code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, see Details,}

\item{maxlag}{either \code{NULL} or a positive integer specifying the
maximum lag order before truncation}

\item{wj}{weighting function to be applied to lagged terms,}
}
\value{
An object of class \code{"matrix"} containing the estimate of
the covariance matrix of coefficients.
}
\description{
Nonparametric robust covariance matrix estimators \emph{a la Newey
and West} for panel models with serial correlation.
}
\details{
\code{vcovNW} is a function for estimating a robust covariance matrix of
parameters for a panel model according to the
\insertCite{NEWE:WEST:87;textual}{plm} method.  The function works
as a restriction of the \insertCite{DRIS:KRAA:98;textual}{plm} covariance (see
\code{\link[=vcovSCC]{vcovSCC()}}) to no cross--sectional correlation.

Weighting schemes specified by \code{type} are analogous to those in
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} in package \CRANpkg{sandwich} and are
justified theoretically (although in the context of the standard
linear model) by \insertCite{MACK:WHIT:85;textual}{plm} and
\insertCite{CRIB:04;textual}{plm} \insertCite{@see @ZEIL:04}{plm}.

The main use of \code{vcovNW} (and the other variance-covariance estimators
provided in the package \code{vcovHC}, \code{vcovBK}, \code{vcovDC}, \code{vcovSCC}) is to pass
it to plm's own functions like \code{summary}, \code{pwaldtest}, and \code{phtest} or
together with testing functions from the \code{lmtest} and \code{car} packages. All of
these typically allow passing the \code{vcov} or \code{vcov.} parameter either as a
matrix or as a function, e.g., for Wald--type testing: argument \code{vcov.} to
\code{coeftest()}, argument \code{vcov} to \code{waldtest()} and other methods in the
\CRANpkg{lmtest} package; and argument \code{vcov.} to
\code{linearHypothesis()} in the \CRANpkg{car} package (see the
examples), see \insertCite{@ZEIL:04, 4.1-2 and examples below}{plm}.
}
\examples{

data("Produc", package="plm")
zz <- plm(log(gsp)~log(pcap)+log(pc)+log(emp)+unemp, data=Produc, model="pooling")
## as function input to plm's summary method (with and without additional arguments):
summary(zz, vcov = vcovNW)
summary(zz, vcov = function(x) vcovNW(x, method="arellano", type="HC1"))
## standard coefficient significance test
library(lmtest)
coeftest(zz)
## NW robust significance test, default
coeftest(zz, vcov.=vcovNW)
## idem with parameters, pass vcov as a function argument
coeftest(zz, vcov.=function(x) vcovNW(x, type="HC1", maxlag=4))
## joint restriction test
waldtest(zz, update(zz, .~.-log(emp)-unemp), vcov=vcovNW)
\dontrun{
## test of hyp.: 2*log(pc)=log(emp)
library(car)
linearHypothesis(zz, "2*log(pc)=log(emp)", vcov.=vcovNW)
}
}
\references{
\insertRef{CRIB:04}{plm}

\insertRef{DRIS:KRAA:98}{plm}

\insertRef{MACK:WHIT:85}{plm}

\insertRef{NEWE:WEST:87}{plm}

\insertRef{ZEIL:04}{plm}
}
\seealso{
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} from the \CRANpkg{sandwich} package
for weighting schemes (\code{type} argument).
}
\author{
Giovanni Millo
}
\keyword{regression}
