% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repr_recordedplot.r
\name{repr_*.recordedplot}
\alias{repr_*.recordedplot}
\alias{repr_text.recordedplot}
\alias{repr_png.recordedplot}
\alias{repr_jpg.recordedplot}
\alias{repr_svg.recordedplot}
\alias{repr_pdf.recordedplot}
\title{Plot representations}
\usage{
\method{repr_text}{recordedplot}(obj, ...)

\method{repr_png}{recordedplot}(
  obj,
  width = getOption("repr.plot.width"),
  height = getOption("repr.plot.height"),
  bg = getOption("repr.plot.bg"),
  pointsize = getOption("repr.plot.pointsize"),
  antialias = getOption("repr.plot.antialias"),
  res = getOption("repr.plot.res"),
  ...
)

\method{repr_jpg}{recordedplot}(
  obj,
  width = getOption("repr.plot.width"),
  height = getOption("repr.plot.height"),
  bg = getOption("repr.plot.bg"),
  pointsize = getOption("repr.plot.pointsize"),
  antialias = getOption("repr.plot.antialias"),
  res = getOption("repr.plot.res"),
  quality = getOption("repr.plot.quality"),
  ...
)

\method{repr_svg}{recordedplot}(
  obj,
  width = getOption("repr.plot.width"),
  height = getOption("repr.plot.height"),
  bg = getOption("repr.plot.bg"),
  pointsize = getOption("repr.plot.pointsize"),
  antialias = getOption("repr.plot.antialias"),
  family = getOption("repr.plot.family"),
  ...
)

\method{repr_pdf}{recordedplot}(
  obj,
  width = getOption("repr.plot.width"),
  height = getOption("repr.plot.height"),
  bg = getOption("repr.plot.bg"),
  pointsize = getOption("repr.plot.pointsize"),
  antialias = getOption("repr.plot.antialias"),
  family = getOption("repr.plot.family"),
  ...
)
}
\arguments{
\item{obj}{The plot to create a representation for}

\item{...}{ignored}

\item{width}{Plot area width in inches (default: 7)}

\item{height}{Plot area height in inches (default: 7)}

\item{bg}{Background color (default: white)}

\item{pointsize}{Text height in pt (default: 12)}

\item{antialias}{Which kind of antialiasing to use for for lines and text? 'gray', 'subpixel' or 'none'? (default: gray)}

\item{res}{For PNG and JPEG, specifies the PPI for rasterization (default: 120)}

\item{quality}{For JPEG, determines the compression quality in \% (default: 90)}

\item{family}{Font family for SVG and PDF. 'sans', 'serif', 'mono' or a specific one (default: sans)}
}
\description{
\code{repr_text.recordedplot} only returns a small info string containing the title (if any)
while the others return a character vector (SVG) or a raw vector (the rest) containing the image data.
}
\details{
All parameters can also be specified using the eponymous \code{repr.plot.*} \link{repr-options}.
}
\examples{
dev.new()
dev.control(displaylist = 'enable')
plot(sqrt, main = 'Square root')
p <- recordPlot()
dev.off()

repr_text(p)

}
