\name{anova.lppm}
\alias{anova.lppm}
\title{ANOVA for Fitted Point Process Models on Linear Network}
\description{
Performs analysis of deviance for two or more fitted point process
models on a linear network.
}
\usage{
  \method{anova}{lppm}(object, \dots, test=NULL, override=FALSE)
}
\arguments{
  \item{object}{A fitted point process model on a linear network
    (object of class \code{"lppm"}).
    }
    \item{\dots}{
      One or more fitted point process models on the same
      linear network.
    }
    \item{test}{
      Character string, partially matching one of
      \code{"Chisq"}, \code{"F"} or \code{"Cp"}.
    }
    \item{override}{
      Logical flag indicating whether to proceed even when there is
      no statistical theory to support the calculation.
    }
}
\value{
  An object of class \code{"anova"}, or \code{NULL}.
}
\details{
  This is a method for \code{\link{anova}} for 
  fitted point process models on a linear network
  (objects of class \code{"lppm"},
  usually generated by the model-fitting function \code{\link{lppm}}).

  If the fitted models are all Poisson point processes,
  then this function performs an Analysis of Deviance of
  the fitted models. The output shows the deviance differences
  (i.e. 2 times log likelihood ratio),
  the difference in degrees of freedom, and (if \code{test="Chi"})
  the two-sided p-values for the chi-squared tests. Their interpretation
  is very similar to that in \code{\link{anova.glm}}.

  If some of the fitted models are \emph{not} Poisson point processes,
  then there is no statistical theory available to support
  a similar analysis. The function issues a warning,
  and (by default) returns a \code{NULL} value.

  However if \code{override=TRUE},
  then a kind of analysis of deviance table will be printed.
  The `deviance' differences in this table are equal to 2 times the differences
  in the maximised values of the log pseudolikelihood (see
  \code{\link{ppm}}). At the time of writing, there is no statistical
  theory to support inferential interpretation of log pseudolikelihood
  ratios. The \code{override} option is provided for research purposes
  only!
}
\section{Errors and warnings}{
  \describe{
    \item{models not nested:}{
      There may be an error message that the models are not \dQuote{nested}.
      For an Analysis of Deviance the models must be nested, i.e. one model
      must be a special case of the other. For example the point process
      model with formula \code{~x} is a special case of the model with
      formula \code{~x+y}, so these models are nested. However
      the two point process
      models with formulae \code{~x} and \code{~y} are not nested.
      
      If you get this error message and you believe that the models should
      be nested, the problem may be the inability of \R to recognise that
      the two formulae are nested. Try modifying the formulae to make
      their relationship more obvious.
    }
    \item{different sizes of dataset:}{
      There may be an error message from \code{anova.glmlist} that
      \dQuote{models were not all fitted to the same size of dataset}.
      This generally occurs when the point process models
      are fitted on different linear networks.
    }
  }
}
\seealso{
  \code{\link{lppm}}
}
\examples{
 example(lpp)
 mod0 <- lppm(X, ~1)
 modx <- lppm(X, ~x)
 anova(mod0, modx, test="Chi")
}
\author{Adrian Baddeley
  \email{Adrian.Baddeley@uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
}
\references{
  Ang, Q.W. (2010)
  \emph{Statistical methodology for events on a network}.
  Master's thesis, School of Mathematics and Statistics, University of
  Western Australia.
  
  Ang, Q.W., Baddeley, A. and Nair, G. (2012)
  Geometrically corrected second-order analysis of 
  events on a linear network, with applications to
  ecology and criminology.
  \emph{Scandinavian Journal of Statistics} \bold{39}, 591--617.

  McSwiggan, G., Nair, M.G. and Baddeley, A. (2012)
  Fitting Poisson point process models to events 
  on a linear network. Manuscript in preparation.
}
\keyword{spatial}
\keyword{models}
\keyword{methods}
 
 
