#include "rheolef.h"
using namespace std;
using namespace rheolef;
struct f : field_functor<f,Float> {
  Float operator() (const point& x) const { return x[0]; }
};
template <class Expr>
field_nonlinear_expr<Expr>
make_expr (const Expr& e) {
  typedef field_nonlinear_expr<Expr> type;
  return type(e);
}
int main (int argc, char **argv){
  environment rheolef(argc,argv);
  geo omega (argv[1]);
  space Xh (omega, argv[2]);
  space Wh (omega["top"], argv[2]);
  Float  tol = (argc > 3) ? atof(argv[3]) : 1e-10;
  trial u (Xh), u_top (Wh); test v (Xh);
  form mb = integrate ("top", u_top*v); // TODO: omit "top"
  field one (Xh, 1);
  //
  // test 1: with a field weight arg
  //
  field id_top (Wh, 1);
  form m1_top = integrate ("top", u*v*id_top);
  field mr1a =     mb*one["top"];
  field mr1b = m1_top*one;
  field e1h = mr1a - mr1b;
  Float err1 = e1h.max_abs();
  derr << "err1 = " << err1 << endl;
  //
  // test 2: with a class-fct weight arg (polynomial P1)
  //
  form m2_top = integrate ("top", u*v*f());
  field mr2a = mb*interpolate(Wh, f()); 
  field mr2b = m2_top*one;
  field e2h = mr2a - mr2b;
  Float err2 = e2h.max_abs();
  derr << "err2 = " << err2 << endl;
  //
  // test 3: with a complex field expression (from lave/fournaise-ray.cc)
  //
  Float Nu = 0.5;
  Float Ra = 0.5;
  Float alpha = 0;
  field tmp1 = id_top+2*alpha;
  form m3_top = integrate ("top", u*v*(Nu + Ra*(tmp1*(id_top+alpha))));
#ifdef TODO
  // TODO: compile pb with boost::proto 1.54 & field_expr (linear) when expanding tmp1 as:
  form m3_top = integrate ("top", u*v*(Nu + Ra*(id_top+2*alpha)*(sqr(id_top+alpha) + sqr(alpha))));
#endif // TODO
  field mr3b = m3_top*one;
  field e3h = mr1a - mr3b;
  Float err3 = e3h.max_abs();
  derr << "err3 = " << err3 << endl;

  return (err1 + err2 + err3 < tol) ? 0 : 1;
}
