// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{PageSetup, PaperSize, PrintCapabilities};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::boxed::Box as Box_;

glib::wrapper! {
    #[doc(alias = "GtkPrinter")]
    pub struct Printer(Object<ffi::GtkPrinter>);

    match fn {
        type_ => || ffi::gtk_printer_get_type(),
    }
}

impl Printer {
    #[doc(alias = "gtk_printer_accepts_pdf")]
    pub fn accepts_pdf(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_accepts_pdf(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_accepts_ps")]
    pub fn accepts_ps(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_accepts_ps(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_compare")]
    pub fn compare(&self, b: &Printer) -> i32 {
        unsafe { ffi::gtk_printer_compare(self.to_glib_none().0, b.to_glib_none().0) }
    }

    #[doc(alias = "gtk_printer_get_capabilities")]
    #[doc(alias = "get_capabilities")]
    pub fn capabilities(&self) -> PrintCapabilities {
        unsafe { from_glib(ffi::gtk_printer_get_capabilities(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_get_default_page_size")]
    #[doc(alias = "get_default_page_size")]
    pub fn default_page_size(&self) -> PageSetup {
        unsafe {
            from_glib_full(ffi::gtk_printer_get_default_page_size(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_printer_get_description")]
    #[doc(alias = "get_description")]
    pub fn description(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_printer_get_description(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_get_hard_margins")]
    #[doc(alias = "get_hard_margins")]
    pub fn hard_margins(&self) -> Option<(f64, f64, f64, f64)> {
        unsafe {
            let mut top = std::mem::MaybeUninit::uninit();
            let mut bottom = std::mem::MaybeUninit::uninit();
            let mut left = std::mem::MaybeUninit::uninit();
            let mut right = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_printer_get_hard_margins(
                self.to_glib_none().0,
                top.as_mut_ptr(),
                bottom.as_mut_ptr(),
                left.as_mut_ptr(),
                right.as_mut_ptr(),
            ));
            if ret {
                Some((
                    top.assume_init(),
                    bottom.assume_init(),
                    left.assume_init(),
                    right.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_printer_get_hard_margins_for_paper_size")]
    #[doc(alias = "get_hard_margins_for_paper_size")]
    pub fn hard_margins_for_paper_size(
        &self,
        paper_size: &mut PaperSize,
    ) -> Option<(f64, f64, f64, f64)> {
        unsafe {
            let mut top = std::mem::MaybeUninit::uninit();
            let mut bottom = std::mem::MaybeUninit::uninit();
            let mut left = std::mem::MaybeUninit::uninit();
            let mut right = std::mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gtk_printer_get_hard_margins_for_paper_size(
                self.to_glib_none().0,
                paper_size.to_glib_none_mut().0,
                top.as_mut_ptr(),
                bottom.as_mut_ptr(),
                left.as_mut_ptr(),
                right.as_mut_ptr(),
            ));
            if ret {
                Some((
                    top.assume_init(),
                    bottom.assume_init(),
                    left.assume_init(),
                    right.assume_init(),
                ))
            } else {
                None
            }
        }
    }

    #[doc(alias = "gtk_printer_get_icon_name")]
    #[doc(alias = "get_icon_name")]
    pub fn icon_name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_printer_get_icon_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_get_job_count")]
    #[doc(alias = "get_job_count")]
    pub fn job_count(&self) -> i32 {
        unsafe { ffi::gtk_printer_get_job_count(self.to_glib_none().0) }
    }

    #[doc(alias = "gtk_printer_get_location")]
    #[doc(alias = "get_location")]
    pub fn location(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_printer_get_location(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_get_name")]
    #[doc(alias = "get_name")]
    pub fn name(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_printer_get_name(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_get_state_message")]
    #[doc(alias = "get_state_message")]
    pub fn state_message(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_printer_get_state_message(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_has_details")]
    pub fn has_details(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_has_details(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_is_accepting_jobs")]
    pub fn is_accepting_jobs(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_is_accepting_jobs(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_is_active")]
    pub fn is_active(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_is_active(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_is_default")]
    pub fn is_default(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_is_default(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_is_paused")]
    pub fn is_paused(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_is_paused(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_is_virtual")]
    pub fn is_virtual(&self) -> bool {
        unsafe { from_glib(ffi::gtk_printer_is_virtual(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_printer_list_papers")]
    pub fn list_papers(&self) -> Vec<PageSetup> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::gtk_printer_list_papers(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_printer_request_details")]
    pub fn request_details(&self) {
        unsafe {
            ffi::gtk_printer_request_details(self.to_glib_none().0);
        }
    }

    #[doc(alias = "details-acquired")]
    pub fn connect_details_acquired<F: Fn(&Self, bool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn details_acquired_trampoline<F: Fn(&Printer, bool) + 'static>(
            this: *mut ffi::GtkPrinter,
            success: glib::ffi::gboolean,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this), from_glib(success))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"details-acquired\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    details_acquired_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "accepting-jobs")]
    pub fn connect_accepting_jobs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accepting_jobs_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accepting-jobs\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_accepting_jobs_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "icon-name")]
    pub fn connect_icon_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_icon_name_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::icon-name\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_icon_name_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "job-count")]
    pub fn connect_job_count_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_job_count_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::job-count\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_job_count_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "location")]
    pub fn connect_location_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_location_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::location\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_location_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "paused")]
    pub fn connect_paused_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paused_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paused\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_paused_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[doc(alias = "state-message")]
    pub fn connect_state_message_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_message_trampoline<F: Fn(&Printer) + 'static>(
            this: *mut ffi::GtkPrinter,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::state-message\0".as_ptr() as *const _,
                Some(std::mem::transmute::<_, unsafe extern "C" fn()>(
                    notify_state_message_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl std::fmt::Display for Printer {
    #[inline]
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        f.write_str(&self.name())
    }
}
