/************************************************************************
 *
 * Copyright (C) 2009-2022 IRCAD France
 * Copyright (C) 2012-2020 IHU Strasbourg
 *
 * This file is part of Sight.
 *
 * Sight is free software: you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sight is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with Sight. If not, see <https://www.gnu.org/licenses/>.
 *
 ***********************************************************************/

#include "core/runtime/helper.hpp"

#include <core/runtime/detail/ExtensionPoint.hpp>
#include <core/runtime/detail/Runtime.hpp>

#include <boost/property_tree/xml_parser.hpp>

#include <iostream>

namespace sight::core::runtime::property_tree
{

//------------------------------------------------------------------------------

std::string toString(const boost::property_tree::ptree& pt)
{
    std::stringstream ss;

    // We specify xml settings for pretty printing
    boost::property_tree::write_xml(ss, pt, boost::property_tree::xml_parser::xml_writer_settings<std::string>(' ', 4));

    auto str = ss.str();
    str.erase(0, str.find('\n') + 1); // Remove the <xml?> tag which adds unnecessary noise
    return str;
}

//------------------------------------------------------------------------------

} // namespace sight::core::runtime::property_tree
