# encoding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014 Ralph Amissah,
   All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.sisudoc.org/sisu/en/SiSU/download.html>

 * Git
   <http://sources.sisudoc.org/gitweb/?p=code/sisu.git;a=summary>
   <http://sources.sisudoc.org/?p=code/sisu.git;a=blob;f=lib/sisu/v6/remote.rb;hb=HEAD>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: remote operations, get source from or copy output to remote server

=end
module SiSU_Remote
  require_relative 'sysenv'                             # sysenv.rb
    include SiSU_Env
  class Put
    def initialize(opt)
      @opt=opt
      @dir=SiSU_Env::InfoEnv.new(@opt.fns)
      @put=(@opt.fns =~/\.ssm\.sst$/) \
      ? opt.fns.gsub(/(.+)?\.ssm\.sst$/,'\1.ssm')
      : opt.fns
      @remote=SiSU_Env::InfoRemote.new(opt)
    end
    def rsync
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement ->',@put).dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.rsync.document
    end
    def rsync_base
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement ->','rsync').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.rsync.site_base
    end
    def rsync_base_sync
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement ->','rsync and sync').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.rsync.site_base_sync
    end
    def rsync_sitemaps
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement sitemaps ->','rsync').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.rsync_sitemaps
    end
    def rsync_harvest
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement metadata harvest ->','rsync_harvest').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.rsync.site_harvest
    end
    def scp
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement ->',@put).dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.scp.document
    end
    def scp_base
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement of base site ->','excluding images').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.scp.site_base
    end
    def scp_base_all
      SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],'Remote placement ->','complete').dark_grey_title_hi unless @opt.act[:quiet][:set]==:on
      @remote.scp.site_base_all
    end
  end
  class Get
    def initialize(opt,get_s)
      @opt,@get_s=opt,get_s
      @msg,@msgs='',nil
      @tell=lambda { SiSU_Screen::Ansi.new(@opt.act[:color_state][:set],@msg,"#{@msgs.inspect if @msgs}") }
    end
    def fns
      begin
        require 'open-uri'
        require 'pp'
      rescue LoadError
        SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('open-uri or pp NOT FOUND (LoadError)')
      end
      require_relative 'composite'                      # composite.rb
      @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      threads=[]
      for requested_page in @get_s
        re_fnb=/((?:https?|file):\/\/[^\/ ]+?\/[^\/ ]+?)\/\S+?\/([^\/]+?)\.ss(t)/ #revisit and remove DO
        threads << Thread.new(requested_page) do |url|
          open(url) do |f|
            raise "#{url} not found" unless f
            base_uri,fnb=re_fnb.match(url)[1..2] if re_fnb
            imagedir=base_uri + '/_sisu/image' #check on
            downloaded_file=File.new("#{fnb}.-sst",'w+')
            image_download_url=SiSU_Assemble::RemoteImage.new.image(imagedir)
            images=[]
            f.collect.each do |r|                            # work area
              unless r =~/^%+\s/
                if r !~/^%+\s/ \
                and r =~@rgx_image
                  images << r.scan(@rgx_image).uniq
                end
              end
              downloaded_file << r
            end
            if images \
            and images.length > 1
              images=images.flatten.uniq
              images.delete_if {|x| x =~/https?:\/\// }
              images=images.sort
              @msg,@msgs='downloading images:', [ images.join(',') ]
              @tell.call.warn unless @opt.act[:quiet][:set]==:on
              image_info=image_download_url + images
              SiSU_Assemble::RemoteImage.new.download_images(image_info)
              #SiSU_Assemble::RemoteImage.new.download_images(image_download_url,images)
              @msg,@msgs='downloading done',nil
              @tell.call.warn unless @opt.act[:quiet][:set]==:on
            end
            downloaded_file.close
          end
        end
      end
      threads.each {|thr| thr.join} if threads #and threads.length > 0
    end
    def sisupod
      get_p=@get_s
      if get_p.length > 0                                     #% remote sisupod
        begin
          require 'net/http'
        rescue LoadError
          SiSU_Utils::CodeMarker.new(__LINE__,__FILE__,:fuchsia).error('net/http NOT FOUND (LoadError)')
        end
        for requested_pod in get_p
          pod_info=RemoteDownload.new(requested_pod)
          Net::HTTP.start(pod_info.pod.site) do |http|
            resp=http.get("#{pod_info.pod.path}/#{pod_info.pod.name_source}")
            open(pod_info.pod.name,'wb') do |file|
              file.write(resp.body)
             end
          end
        end
      end
    end
  end
  class RemoteDownload
    def initialize(requested_file)
      @requested_file=requested_file
    end
    def pod
      re_p_div=/https?:\/\/([^\/]+)(\/\S+)\/(sisupod\.(?:txz|zip)|\S+?(?:\.ss[mt]\.(?:txz|zip))?|[^\/]+?\.ssp)$/
      re_p=/(sisupod\.(?:txz|zip)|\S+?\.ss[mt]\.(?:txz|zip)?|[^\/]+?\.ssp)$/
      if @requested_file =~ re_p_div
        @site,@pth,@pod= re_p_div.match(@requested_file).captures
      elsif @requested_file =~ re_p
        @pod=re_p.match(@requested_file).captures.join
      end
      def site
        @site
      end
      def path
        @pth
      end
      def dir_stub
        re_p_stub=/.+?([^\/]+)$/
        re_p_stub.match(path).captures.join if path
      end
      def name_source
        @pod
      end
      def name
        name_source
      end
      self
    end
  end
end
__END__
