/* Public domain. */

#include "bytestr.h"

#ifdef USE_BASE_LIBC

#include <string.h>

unsigned int str_copy (char *s, char const *t)
{
  strcpy(s, t) ;
  return strlen(t) ;
}

#else

unsigned int str_copy (char *s, char const *t)
{
  register unsigned int len = 0 ;
  while ((*s = *t)) (s++, t++, len++) ;
  return len ;
}

#endif
