use core:lang;

// TODO: A hash table with weak keys would be better here.
private WeakSet<Function> acquireFns on Compiler;
private WeakSet<Function> releaseFns on Compiler;

progvis:program:Barrier fnBarrier(Function f) on Compiler {
	progvis:program:Barrier result = progvis:program:Barrier:none;
	if (acquireFns.has(f))
		result += progvis:program:Barrier:acquire;
	if (releaseFns.has(f))
		result += progvis:program:Barrier:release;
	result;
}

void registerBarrier(Function fn, progvis:program:Barrier type) on Compiler {
	if (type.has(progvis:program:Barrier:acquire))
		acquireFns.put(fn);
	if (type.has(progvis:program:Barrier:release))
		releaseFns.put(fn);
}
