/* ====================================================================
 * Copyright (c) 2009  Martin Hauner
 *                     http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _PROJECTWRITER_H
#define _PROJECTWRITER_H

// sc
#include "../Project.h"
#include "sublib/config/ConfigData.h"
#include "sublib/config/ConfigValue.h"

// qt
#include <QtCore/QString>


class ProjectWriter
{
public:
  ProjectWriter( ConfigData* cfg, const Project* prj );
  virtual ~ProjectWriter();

  void write();

private:
  void writeRoot();
  void writeTrunkItem();
  void writeBranchesItem();
  void writeTagsItem();
  void writeWorkingCopyItems();
  void writeRepositoryItems();
  void writeWorkingCopySubItems( const QString& key, const
    Project::Item& item );

  void writeRepositoryItem( const QString& key, const Project::Item&
    item );
  void writeWorkingCopyItem( const QString& key, const Project::Item&
    item );
  void writeWorkingCopySubItem( const QString& key, const
    Project::SubItem& item );

  void addValue( const QString& key, const sc::String& value );
  void addValue( const QString& key, sc::String& value );
  void addValue( const QString& key, long value );
  void addValue( const QString& key, bool value );

  // in
  const Project* _prj;
  ConfigData*    _cfg;

  // state
  ConfigValues _values;
  QString      _keyRoot;
};

#endif // _PROJECTWRITER_H
