.\" $XFree86: xc/programs/Xserver/hw/darwin/XDarwin.man,v 1.4 2002/01/09 18:01:58 torrey Exp $
.\"
.TH XQUARTZ 1 __vendorversion__
.SH NAME
Xquartz \- X window system server for Quartz operating system
.SH SYNOPSIS
.B Xquartz
[ options ] ...
.SH DESCRIPTION
.I Xquartz
is the X window server for Mac OS X provided by Apple.
.I Xquartz
runs in parallel with Aqua in rootless mode. In rootless mode, the X
window system and Mac OS X share your display.  The root window of the
X11 display is the size of the screen and contains all the other
windows. The X11 root window is not displayed in rootless mode as Mac
OS X handles the desktop background.
.SH OPTIONS
.PP
In addition to the normal server options described in the \fIXserver(1)\fP
manual page, \fIXquartz\fP accepts the following command line switches:
.TP 8
.B \-fakebuttons
Emulates a 3 button mouse using modifier keys. By default, the Command modifier
is used to emulate button 2 and Option is used for button 3. Thus, clicking the
first mouse button while holding down Command will act like clicking
button 2. Holding down Option will simulate button 3.
.TP 8
.B \-nofakebuttons
Do not emulate a 3 button mouse. This is the default.
.TP 8
.B "\-fakemouse2 \fImodifiers\fP"
Change the modifier keys used to emulate the second mouse button. By default,
Command is used to emulate the second button. Any combination of the following
modifier names may be used: Shift, Option, Control, Command, Fn. For example,
.B \-fakemouse2 """Option,Shift""
will set holding Option, Shift and clicking on button one as equivalent to
clicking the second mouse button.
.TP 8
.B "\-fakemouse3 \fImodifiers\fP"
Change the modifier keys used to emulate the third mouse button. By default,
Option is used to emulate the third button. Any combination of the following
modifier names may be used: Shift, Option, Control, Command, Fn. For example,
.B \-fakemouse3 """Control,Shift""
will set holding Control, Shift and clicking on button one as equivalent to
clicking the third mouse button.
.TP 8
.B "\-swapAltMeta"
Swaps the meaning of the Alt and Meta modifier keys.
.TP 8
.B "\-keymap \fIfile\fP"
On startup \fIXquartz\fP translates a Darwin keymapping into an X keymap.
The default is to read this keymapping from USA.keymapping. With this option
the keymapping will be read from \fIfile\fP instead. If the file's path is
not specified, it will be searched for in Library/Keyboards/ underneath the
following directories (in order): ~, /, /Network, /System.
.TP 8
.B \-nokeymap
On startup \fIXquartz\fP translates a Darwin keymapping into an X keymap.
With this option \fIXquartz\fP queries the kernel for the current keymapping
instead of reading it from a file. This will often fail on newer kernels.
.TP 8
.B "\-depth \fIdepth\fP"
Specifies the color bit depth to use. Currently only 15, and 24 color
bits per pixel are supported. If not specified, defaults to the depth
of the main display.
.SH CUSTOMIZATION
\fIXquartz\fP can also be customized using the defaults(1) command. The available options are:
.TP 8
.B defaults write com.apple.x11 enable_fake_buttons -boolean true
Equivalent to the \fB-fakebuttons\fP command line option.
.TP 8
.B defaults write com.apple.x11 fake_button2 \fImodifiers\fP
Equivalent to the \fB-fakemouse2\fP option.
.TP 8
.B defaults write com.apple.x11 fake_button3 \fImodifiers\fP
Equivalent to the \fB-fakemouse3\fP option.
.TP 8
.B defaults write com.apple.x11 swap_alt_meta -boolean true
Equivalent to the \fB-swapAltMeta\fP option.
.TP 8
.B defaults write com.apple.x11 keymap_file \fIfilename\fP
Equivalent to the \fB-keymap\fP option.
.TP 8
.B defaults write com.apple.x11 no_quit_alert -boolean true
Disables the alert dialog displayed when attempting to quit X11.
.TP 8
.B defaults write com.apple.x11 no_auth -boolean true
Stops the X server requiring that clients authenticate themselves when
connecting. See Xsecurity(__miscmansuffix__).
.TP 8
.B defaults write com.apple.x11 nolisten_tcp -boolean true
Prevents the X server accepting remote connections.
.TP 8
.B defaults write com.apple.x11 xinit_kills_server -boolean false
Stops the X server exiting when the xinitrc script terminates.
.TP 8
.B defaults write com.apple.x11 fullscreen_hotkeys -boolean false
Allows system hotkeys to be handled while in X11 fullscreen mode.
.TP 8
.B defaults write com.apple.x11 enable_system_beep -boolean false
Don't use the standard system beep effect for X11 alerts.
.TP 8
.B defaults write com.apple.x11 enable_key_equivalents -boolean false
Disable menu keyboard equivalents while X11 windows are focused.
.TP 8
.B defaults write com.apple.x11 depth \fIdepth\fP
Equivalent to the \fB-depth\fP option.
.SH "SEE ALSO"
.PP
X(__miscmansuffix__), XFree86(1), Xserver(1), xdm(1), xinit(1)
.PP
.SH AUTHORS
XFree86 was originally ported to Mac OS X Server by John Carmack. Dave
Zarzycki used this as the basis of his port of XFree86 4.0 to Darwin 1.0.
Torrey T. Lyons improved and integrated this code into the XFree86
Project's mainline for the 4.0.2 release.
.PP
The following members of the XonX Team contributed to the following
releases (in alphabetical order):
.TP 4
XFree86 4.1.0:
.br
Rob Braun - Darwin x86 support
.br
Torrey T. Lyons - Project Lead
.br
Andreas Monitzer - Cocoa version of XDarwin front end
.br
Gregory Robert Parker - Original Quartz implementation
.br
Christoph Pfisterer - Dynamic shared X libraries
.br
Toshimitsu Tanaka - Japanese localization
.TP 4
XFree86 4.2.0:
.br
Rob Braun - Darwin x86 support
.br
Pablo Di Noto - Spanish localization
.br
Paul Edens - Dutch localization
.br
Kyunghwan Kim - Korean localization
.br
Mario Klebsch - Non-US keyboard support
.br
Torrey T. Lyons - Project Lead
.br
Andreas Monitzer - German localization
.br
Patrik Montgomery - Swedish localization
.br
Greg Parker - Rootless support
.br
Toshimitsu Tanaka - Japanese localization
.br
Olivier Verdier - French localization
