from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_PROXY_ALLOWED = _Mock()

_caller = _Mock()

_callers_globals = _Mock()

_callers_modules = _Mock()

_errout = _Mock()

_foo = _Mock()

_loadmodule = _Mock()

_locate = _Mock()

_unknown = _Mock()

_update_proxy_types = _Mock()

_verbose = _Mock()

absolute_import = _Mock()

division = _Mock()

load = _Mock()

pickle = _Mock()

print_function = _Mock()

save = _Mock()

sys = _Mock()

test = _Mock()

SAVEFILE = 'session.dat'

VERBOSE = _Mock()

class ObjectNotFound(_Mock):
  pass


class _ModuleProxy(_Mock):
  pass


class _ObjectProxy(_Mock):
  pass


class _ProxyingFailure(_Mock):
  pass


class _SaveSession(_Mock):
  pass


