/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "WindowMenu.hpp"

#include "Window.hpp"

#include "wx/config.h"

#include <vector>

using namespace indii;

WindowMenu::WindowMenu(Window* window) : window(window) {
  AppendSeparator();
  Append(ID_DEFAULTS, _("Restore Default Layout"));
}

void WindowMenu::add(const wxString& name) {
  unsigned i = GetMenuItemCount() - 2;
  InsertCheckItem(i, ID_SELECT + i, name);
}

void WindowMenu::update() {
  unsigned i;
  for (i = 0; i < GetMenuItemCount() - 2; ++i) {
    FindItemByPosition(i)->Check(window->isShown(i));
  }
}

void WindowMenu::OnShow(wxMenuEvent& evt) {
  update();
}

void WindowMenu::OnSelect(wxCommandEvent& evt) {
  unsigned i = evt.GetId() - ID_SELECT;
  window->show(i, !window->isShown(i));
}

void WindowMenu::OnDefault(wxCommandEvent& evt) {
  window->layoutDefault();
}

BEGIN_EVENT_TABLE(WindowMenu, wxMenu)
#ifdef __WXOSX__
/* events handled here on Mac, in Window on other platforms */
EVT_MENU_OPEN(WindowMenu::OnShow)
EVT_MENU(ID_SELECT, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 1u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 2u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 3u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 4u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 5u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 6u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 7u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 8u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 9u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 10u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 11u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 12u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 13u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 14u, WindowMenu::OnSelect)
EVT_MENU(ID_SELECT + 15u, WindowMenu::OnSelect)
EVT_MENU(ID_DEFAULTS, WindowMenu::OnDefault)
#endif
END_EVENT_TABLE()
