/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2012  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/


#include "header.h"

#ifdef Z_HAVE_SDL


#include "cor.h"
#include "cordata.h"
#include "main.h"
#include "map.h"
#include "session.h"
#include "subwin.h"
#include "tsdl.h"

struct tcor *gcor = NULL;
static struct tcor *gcor2 = NULL;

struct kmarray *kmarray_new(void){
    struct kmarray *kma;

    kma = g_new0(struct kmarray, 1);
    kma->size=100;
    kma->data=g_new0(struct kmpoint, kma->size);
    return kma;
}

void kmarray_add(GHashTable *hash, gpointer key, struct kmpoint *km){
	struct kmarray *kma;
	gpointer orig_key, value;
	
	if (g_hash_table_lookup_extended(hash, key, &orig_key, &value)){
		kma=(struct kmarray *)value;
	}else{
		kma=kmarray_new();
	 /*   dbg("new kma for %p: %p\n",key,  kma);*/
		g_hash_table_insert(hash, key, kma);
	}
		
    if (kma->len == kma->size){
        kma->size+=100; 
        kma->data = g_renew(struct kmpoint, kma->data, kma->size);
    }
    memcpy(&kma->data[kma->len], km, sizeof(struct kmpoint));    
    kma->len++;
}


#define TO_READ 1000


struct tcor *init_cor(){
	struct tcor *cor;


    cor = g_new0(struct tcor, 1);
	cor->km = g_hash_table_new(g_direct_hash, g_direct_equal);
	cor->wwl4 = g_hash_table_new(g_direct_hash, g_direct_equal);
	cor->wwl2 = g_hash_table_new(g_direct_hash, g_direct_equal);
	cor->az =   g_hash_table_new(g_direct_hash, g_direct_equal);
    cor->thread_break = 0;
	cor->file=cor_tucnakcor;
	cor->items=COR_ITEMS;
	cor->loc = g_strdup("");
    return cor;
}

void free_cor(struct tcor *cor){

	if (!cor) return;


    if (cor && cor->thread){
        cor->thread_break = 1;

        //dbg("join cor...\n");
        g_thread_join(cor->thread);
        //dbg("done\n");
        cor->thread = NULL;
    }
	g_free(cor->loc);
	g_hash_table_foreach_remove(cor->km, free_km_item, NULL); 
	g_hash_table_foreach_remove(cor->wwl4, free_km_item, NULL); 
	g_hash_table_foreach_remove(cor->wwl2, free_km_item, NULL); 
	g_hash_table_foreach_remove(cor->az, free_km_item, NULL); 
	
    g_free(cor);
}

void free_cors(){
	free_cor(gcor2);
	free_cor(gcor);
}

int cor_recalc(struct subwin *sw, gchar *locator){ 
    //dbg("--------\ncor_recalc('%s', '%s') %d %d\n", sw->title, locator, sw->myh, sw->myw);

	if (gcor && strcmp(gcor->loc, locator) == 0){
		//dbg("same locators as gcor\n");
		return 0;
	}
    if (gcor2 && strcmp(gcor2->loc, locator) == 0){
		//dbg("same locators as gcor2, wait for pending recalc\n");
		return 0;
	}
    if (gcor2) {
        free_cor(gcor2);
    }
    gcor2 = init_cor();
	gcor2->loc = g_strdup(locator);
    gcor2->sw_myw = sw->myw;
    gcor2->sw_myh = sw->myh;
    gcor2->thread = g_thread_try_new("cor", cor_thread_func, (gpointer)gcor2, NULL);
    if (!gcor2->thread) zinternal("Can't run cor thread");
    return 0;
}


gpointer cor_thread_func(gpointer arg){ 
    int i,j;
	const struct cpoint *cp;
    struct kmpoint km, kmfirst, kmlast;
	double h2, w2;
    gpointer hash, oldhash;
	int kx, ky, color;
    struct tcor *cor = (struct tcor *)arg;
	
	zg_thread_set_name("Tucnak cor");
   /* dbg("recalc_cor(%s)\n", locator);*/
   /* return 0; */
//    ST_START;

    kmfirst.c=0;
    //dbg("cor_thread_func: items=%d h=%f w=%f\n", cor->items, cor->sw_myh, cor->sw_myw);
	g_hash_table_foreach_remove(cor->km, free_km_item, NULL); 
    oldhash=(gpointer)-1;
	for (i=0, cp=cor->file; i<cor->items; i++, cp++){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        w2=(M_PI*(double)cp->w)/18000;
		h2=(M_PI*(double)cp->h)/18000;
		hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
		hash=k2key(kx, ky);
		km.c=cp->c;
		km.kx=kx;
		km.ky=ky;
//        dbg("cp=%d %d %d  km=%d %d %d\n", cp->w, cp->h, cp->c, km.kx, km.ky, km.c);
		if (km.c<0) {
			memcpy(&kmfirst, &km, sizeof(kmfirst));
		}
		if (oldhash!=(gpointer)-1 && hash!=oldhash) {
			kmarray_add(cor->km, oldhash, &km);
			kmlast.c=kmfirst.c;
            kmarray_add(cor->km, hash, &kmlast);
		}    
			
		kmarray_add(cor->km, hash, &km);
		memcpy(&kmlast, &km, sizeof(kmlast));
		oldhash=hash;
	}
    
    /* large wwls (JN69) */
	g_hash_table_foreach_remove(cor->wwl4, free_km_item, NULL); 
    for (i=-89;i<90;i++){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        if (i%10==0) color=-128;
        else color=-127;
        oldhash=(gpointer)-1;
        km.c=color;
        for (j=0;j<=360;j++){
            w2=(M_PI*i)/180;
            h2=(M_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl4, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl4, hash, &kmlast);
                km.c=0;
            }
            
            kmarray_add(cor->wwl4, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            
            oldhash=hash;
            km.c=0;
        }
    }
    for (j=0;j<360;j+=2){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        oldhash=(gpointer)-1;
        if (j%20==0) color=-128;
        else color=-127;
        km.c=color;
        for (i=-89;i<=89;i++){
            w2=(M_PI*i)/180;
            h2=(M_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl4, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl4, hash, &kmlast);
                km.c=0;
            }
            kmarray_add(cor->wwl4, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            oldhash=hash;
            km.c=0;
        }
    } 
    /* very large wwls (JN) */
	g_hash_table_foreach_remove(cor->wwl2, free_km_item, NULL); 
    for (i=-80;i<90;i+=10){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        if (i%10==0) color=-128;
        else color=-127;
        oldhash=(gpointer)-1;
        km.c=color;
        for (j=0;j<=360;j++){
            w2=(M_PI*i)/180;
            h2=(M_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl2, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl2, hash, &kmlast);
                km.c=0;
            }
            
            kmarray_add(cor->wwl2, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            
            oldhash=hash;
            km.c=0;
        }
    }
    for (j=0;j<360;j+=20){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        oldhash=(gpointer)-1;
        if (j%10==0) color=-128;
        else color=-127;
        km.c=color;
        for (i=-89;i<=89;i++){
            w2=(M_PI*i)/180;
            h2=(M_PI*j)/180;
            hw2km(cor->sw_myh, cor->sw_myw, h2, w2, &kx, &ky);
            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->wwl2, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->wwl2, hash, &kmlast);
                km.c=0;
            }
            kmarray_add(cor->wwl2, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            oldhash=hash;
            km.c=0;
        }
    } 

	g_hash_table_foreach_remove(cor->az, free_km_item, NULL); 
	for (j = 0; j < 360; j += 15){
        if (cor->thread_break) {
			dbg("cor thread breaked\n");
			return NULL;
		}
        oldhash=(gpointer)-1;
		color = j % 90 ? -127 : -128; 
		km.c = color;
		for (i = 50; i < (int)(ZLOC_R_EARTH * M_PI); i += 50){
			kx = i * cos(j * M_PI / 180.0);
			ky = i * sin(j * M_PI / 180.0);

            hash=k2key(kx, ky);
            km.kx=kx;
            km.ky=ky;
            if (oldhash!=(gpointer)-1 && hash!=oldhash) {
                kmarray_add(cor->az, oldhash, &km);
                kmlast.c=color;
                kmarray_add(cor->az, hash, &kmlast);
                km.c=0;
            }
            kmarray_add(cor->az, hash, &km);
			memcpy(&kmlast, &km, sizeof(kmlast));
            oldhash=hash;
            km.c=0;
		}
	}
//    ST_STOP;
   // sleep(5); 

	zselect_msg_send(zsel, "COR");
	//dbg("cor finished\n");
	return NULL;
}

void cor_read_handler(int n, char **items){
//    dbg("cor_read_handler\n");
    if (!gcor2 || !gcor2->thread) return;

    free_cor(gcor);
    gcor = gcor2;
    gcor2 = NULL;
	if (!gses) return;
	//cor_dump(cor);
    if (gses->ontop->type!=SWT_MAP) return;
    gses->ontop->gdirty = 1;
    sw_map_redraw(gses->ontop, aband, 0);
}



gboolean free_km_item(gpointer key, gpointer value, gpointer user_data){
	struct kmarray *kma;

	/* key is int, not freeed */
	kma=(struct kmarray *) value;
   	if (!kma) return 0;
	g_free(kma->data);
	g_free(kma);
    return 1;
}


gpointer k2key(int kx, int ky){
	return GINT_TO_POINTER((kx & COR_KM_MASK) | ( (ky & COR_KM_MASK) << 16)) ; 
}


static void cor_dump1(gpointer key, gpointer value, gpointer data){
	FILE *f = (FILE *)data;
	struct kmarray *kma = (struct kmarray *)value;
	int i;

	fprintf(f, "hash=%p\n", key);
	for (i = 0; i < kma->len; i++){
		fprintf(f, "%d %d %d\n", (int)kma->data[i].c, (int)kma->data[i].kx, (int)kma->data[i].ky);
	}
}

void cor_dump(struct tcor *cor){
	FILE *f = fopen("cordump.txt", "wt");
	if (!f) return;
	fprintf(f, "cor_dump start\n");
	g_hash_table_foreach(cor->km, cor_dump1, f);
	fprintf(f, "cor_dump end\n");
	fclose(f);
}


#endif
