/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2010  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"



/*gchar *qw(GString *gs, gchar *s){
	char *c;

    g_string_truncate(gs,0);
    if (!s) return gs->str;
    
    g_string_append(gs, "<nowiki>");
	for (c=s; *c!='\0'; c++) {
        switch (*c){
            case '<':
                g_string_append(gs, "&lt;");
                break;
            case '>':
                g_string_append(gs, "&gt;");
                break;
            case '"':
                g_string_append(gs, "&quot;");
                break;
            case '&':
                g_string_append(gs, "&amp;");
                break;
            case '\'':
                g_string_append(gs, "&#39;");
                break;
            default:
                g_string_append_c(gs, *c);    
        }
    }
    g_string_append(gs, "</nowiki>");
	return gs->str;
}*/
  
void wiki_header(GString *gs){
    int i;
    
    zg_string_eprintfa("w", gs, "=%s=\n", ctest->tname);

    g_string_sprintfa(gs, "{| style=\"background-color:#ffffcc;\"\n");
    zg_string_eprintfa("w", gs, "|-\n|Call:||%S\n", ctest->pcall);
    zg_string_eprintfa("w", gs, "|-\n|WWL:||%S\n", ctest->pwwlo);
    if (ctest->padr1 && *ctest->padr1)
        zg_string_eprintfa("w", gs, "|-\n|QTH:||%s\n", ctest->padr1);
    if (ctest->padr2 && *ctest->padr2)
        zg_string_eprintfa("w", gs, "|-\n| ||%s\n", ctest->padr2);

    i = atoi(ctest->cdate);
    g_string_sprintfa(gs, "|-\n|Date:||%d.%d.%d\n", i % 100, (i / 100) % 100, i / 10000);
    g_string_sprintfa(gs, "|}\n");
}


static void wiki_wwl_func(gpointer key, gpointer value, gpointer user_data){
    gchar       *wwl;
    struct cntpts *n;
    GIndexArray *ia;
    
    
    wwl   = (gchar *)       key;  
	n     = (struct cntpts *) value;
    ia    = (GIndexArray *) user_data;

    g_index_array_add(ia, g_strdup_printf("%4s||align=\"right\"|\t%d||align=\"right\"|%d", wwl, n->points, n->count));
}

static gint wiki_compare_colon_int (gconstpointer a, gconstpointer b){
	gchar **ca, **cb, *c;
	int ia, ib;

	ca=(gchar **)a;
	cb=(gchar **)b;

	c=strchr(*ca, '\t');
	if (c) ia=atoi(c+1);
	else ia=0;
	c=strchr(*cb, '\t');
	if (c) ib=atoi(c+1);
	else ib=0;

	return ib-ia;
}


#define TOPS_NUM	10
void wiki_band_header(GString *gs, struct band *b, int flags){
    struct qso *q, *top[TOPS_NUM];
    int i, j, cnt = 0, w;
    GIndexArray *ia;
    char *c;
	int ntotal;
    struct subwin *map = NULL;
    struct subwin *chart = NULL;
    struct band *oldaband;
    
    
    for (i = 0; i < gses->subwins->len; i++){
        struct subwin *sw = (struct subwin*)g_ptr_array_index(gses->subwins, i);
        if ((flags & HTML_MAP) && sw->type == SWT_MAP) map = sw;
        if ((flags & HTML_CHART) && sw->type == SWT_CHART) chart = sw;
    }
    oldaband = aband;
#if defined(HAVE_SDL) && defined(HAVE_LINPNG) && !defined(_MSC_VER)
    if (map){
        char *filename;
        aband = b;
        map->gdirty = 1;
        map_for_photo(map);
        sw_map_redraw(map, HTML_FOR_PHOTO);
        filename = g_strdup_printf("%s/map%c.png", ctest->directory, tolower(b->bandchar));
        do_png_save(map->screen, filename);
        g_free(filename);
    }
    if (chart){
        char *filename;
        aband = b;
        chart->gdirty = 1;
        sw_chart_recalc_extremes(chart);
        sw_chart_redraw(chart, 0);
        filename = g_strdup_printf("%s/chart%c.png", ctest->directory, tolower(b->bandchar));
        do_png_save(chart->screen, filename);
        g_free(filename);
    }
#endif
    aband = oldaband;

    g_string_sprintfa(gs, "\n\n=Band %s=\n", b->bandname);

    ntotal = b->stats->ntotal;
    if (ntotal < 10000){
        ntotal = ( ntotal / 100 ) * 100;
    }else{
        ntotal = ( ntotal / 1000 ) * 1000;
    }
    g_string_sprintfa(gs, "{| style=\"background-color:#ffffcc;\"\n");
    g_string_sprintfa(gs, "|+ %s\n", b->bandname);
    g_string_sprintfa(gs, "|-\n|QSOs:||%d\n", b->stats->nqsos);
    g_string_sprintfa(gs, "|-\n|Points:||%d\n", ntotal);
    g_string_sprintfa(gs, "|-\n|WWLs:||%d\n", g_hash_table_size(b->stats->wwls));
    g_string_sprintfa(gs, "|-\n|DXCCs:||%d\n", g_hash_table_size(b->stats->dxcs));
    g_string_sprintfa(gs, "|-\n|AVG:||%d pts/qso\n", b->stats->ntotal/b->stats->nqsos);
    g_string_sprintfa(gs, "|}\n");

	/* top 10 */

	memset(top, 0, TOPS_NUM * sizeof(struct qso *));
	for (i = 0; i < b->qsos->len; i++) {
		if (!top[0]) { /* init first item */
			q = get_qso(b, i);
			if (!q->error && !q->dupe) {
				cnt = 0;
				top[cnt++] = q;
				/*dbg("init: %s %u\n=\n", top[0]->callsign, (int) top[0]->qrb);*/
			}
			continue;
		}

		q = get_qso(b, i);
		/*dbg("selected %u: %s %u\n", i, q->callsign, (int) q->qrb);*/
		if (q->error || q->dupe)
			continue;

		if (cnt >= TOPS_NUM)
			cnt = TOPS_NUM - 1;
		
		/* initialize or find top dx and sort top array */
		if (!top[cnt] || q->qrb > top[cnt]->qrb) {
			for (j = cnt; j >= 0; j--) {
				if (j && q->qrb > top[j - 1]->qrb) {
					top[j] = top[j - 1]; /* move down */
					/*dbg("down %u: %s %u\n", j, top[j]->callsign, (int) top[j]->qrb);*/
				} else {
					top[j] = q; /* insert */
					cnt++;
					/*dbg("insert %u: %s %u\n", j, top[j]->callsign, (int) top[j]->qrb);*/
					break;
				}
			}
		}
	}

    g_string_sprintfa(gs, "\n\n");


    //tabulka kolem

    g_string_sprintfa(gs, "{| cellpadding=\"10\" style=\"background: transparent;\"\n");
    g_string_sprintfa(gs, "|\n");

    g_string_sprintfa(gs, "{| cellpadding=\"5\" style=\"background-color:#ffffcc;\"\n");
    g_string_sprintfa(gs, "|+ Top 10 calls\n");
    g_string_sprintfa(gs, "!Call!!QRB!!Operator!!Mode\n");
	for (i = 0; i < TOPS_NUM && i < b->qsos->len && top[i]; i++) {
		q = top[i];
		g_string_sprintfa(gs, "|-\n|%s||align=\"right\"|%4u km||%s||%s\n", q->callsign, (int) q->qrb, q->operator_, mode_msg[q->mode]);
	}

    g_string_sprintfa(gs, "|}\n");

    ia = g_index_array_new();
    g_hash_table_foreach(b->stats->wwls, wiki_wwl_func, ia);
    g_index_array_qsort(ia, wiki_compare_colon_int);
    
    g_string_sprintfa(gs, "|\n");

    g_string_sprintfa(gs, "{| cellpadding=\"5\" style=\"background-color:#ffffcc;\"\n");
    g_string_sprintfa(gs, "|+ Top 10 WWLs\n");
    g_string_sprintfa(gs, "!WWL!!Points!!QSOs\n");
    for (i = 0; i < ia->len && i < 10; i++){
        c = (gchar *)g_index_array_index(ia, i);
		g_string_sprintfa(gs, "|-\n|%s\n", c);
    }

    g_string_sprintfa(gs, "|}\n");
    g_index_array_free_all(ia);

    g_string_sprintfa(gs, "|}\n\n");

#ifdef HAVE_SDL
    w = 640;
    if (map && map->screen) w = map->screen->w;

	g_string_sprintfa(gs, "[[File:map_%s_%s_%c.png|border|%dpx|%s %s %s]]\n", 
		ctest->pcall, ctest->cdate, b->bandchar, w,
		ctest->pcall, ctest->tname, b->bandname);

    w = 640;
    if (chart && chart->screen) w = chart->screen->w;
	g_string_sprintfa(gs, "[[File:chart_%s_%s_%c.png|border|%dpx|%s %s %s]]\n", 
		ctest->pcall, ctest->cdate, b->bandchar, w, 
		ctest->pcall, ctest->tname, b->bandname);
#endif
    
}

void wiki_footer(GString *gs){
    g_string_sprintfa(gs, "\n\nCreated by [http://tucnak.nagano.cz TUCNAK ver. %s]\n", VERSION_STRING);
}


void wiki_complete(GString *gs){
    int i;
    struct band *band;
    struct config_band *confb;
    int header_saved=0;

    for (i=0; i<ctest->bands->len; i++){
        band = (struct band *)g_ptr_array_index(ctest->bands, i);
        confb = get_config_band_by_bandchar(band->bandchar);

        stats_thread_join(band);
        if (band->stats->nqsos <=0) continue;

        if (!header_saved){
            wiki_header(gs);
            header_saved=1;
        }
        wiki_band_header(gs, band, HTML_MAP | HTML_CHART);
    }

    wiki_footer(gs);
}

int export_all_bands_wiki(){
    gchar *filename;
    FILE *f;
    char callbuf[20];
    GString *gs;
    
    if (!ctest) return -1;
    
    dbg("export_all_bands_wiki()\n");
	
	filename = g_strdup_printf("%s/%s_%s.wiki",
					ctest->directory,
					ctest->cdate,
					uc(get_raw_call(callbuf,ctest->pcall)));
        
	f=fopen(filename,"wt");
	if (!f) {
		errbox(VTEXT(T_CANT_WRITE), errno);
		g_free(filename);
		return -1;
	}
    
    gs = g_string_sized_new(100000);
    wiki_complete(gs);

    if (fprintf(f, "%s", gs->str) <= 0){
		errbox(VTEXT(T_CANT_WRITE), 0);
		g_free(filename);
        g_string_free(gs, TRUE);
		return -1;
	}
	
	fclose(f);
	log_addf(VTEXT(T_SAVED_S), filename);
	g_free(filename);
    g_string_free(gs, TRUE);
    return 0;
}

