/*
 * RedisModule Compatibility Header - Snapshot for Redis 7.2.4 
 *
 * This header file facilitates backward compatibility for existing Redis modules
 * by mapping legacy REDISMODULE_* prefixed macros and identifiers to their
 * new equivalents prefixed with VALKEYMODULE_*. It acts as an adapter allowing
 * modules written for the older REDISMODULE API to compile and function correctly
 * with the newer VALKEYMODULE API without requiring source code changes. New modules
 * should be developed using "valkeymodule.h" instead.
 *
 * Important Note: 
 * This file represents a snapshot of the Redis module interfaces as they existed
 * in Redis 7.2.4. Compatibility with future Redis versions is not guaranteed.
 * 
 * Usage:
 * Include this header in Redis modules that originally depend on the older
 * REDISMODULE_* definitions. This file should be included instead of
 * directly including valkeymodule.h to ensure the legacy code recognizes
 * the new Valkey module interfaces.
 *
 * Example:
 * #include "redismodule.h"
 *
 * The above directive will pull in the VALKEYMODULE_* definitions while
 * ensuring that any reference to REDISMODULE_* in the module's source
 * will resolve to the appropriate VALKEYMODULE_* counterpart.
 */

#include "valkeymodule.h"
#define REDISMODULE_H VALKEYMODULE_H
#define REDISMODULE_OK VALKEYMODULE_OK
#define REDISMODULE_ERR VALKEYMODULE_ERR
#define REDISMODULE_AUTH_HANDLED VALKEYMODULE_AUTH_HANDLED
#define REDISMODULE_AUTH_NOT_HANDLED VALKEYMODULE_AUTH_NOT_HANDLED
#define REDISMODULE_APIVER_1 VALKEYMODULE_APIVER_1
#define REDISMODULE_TYPE_METHOD_VERSION VALKEYMODULE_TYPE_METHOD_VERSION
#define REDISMODULE_READ VALKEYMODULE_READ
#define REDISMODULE_WRITE VALKEYMODULE_WRITE
#define REDISMODULE_OPEN_KEY_NOTOUCH VALKEYMODULE_OPEN_KEY_NOTOUCH
#define REDISMODULE_OPEN_KEY_NONOTIFY VALKEYMODULE_OPEN_KEY_NONOTIFY
#define REDISMODULE_OPEN_KEY_NOSTATS VALKEYMODULE_OPEN_KEY_NOSTATS
#define REDISMODULE_OPEN_KEY_NOEXPIRE VALKEYMODULE_OPEN_KEY_NOEXPIRE
#define REDISMODULE_OPEN_KEY_NOEFFECTS VALKEYMODULE_OPEN_KEY_NOEFFECTS
#define REDISMODULE_LIST_HEAD VALKEYMODULE_LIST_HEAD
#define REDISMODULE_LIST_TAIL VALKEYMODULE_LIST_TAIL
#define REDISMODULE_KEYTYPE_EMPTY VALKEYMODULE_KEYTYPE_EMPTY
#define REDISMODULE_KEYTYPE_STRING VALKEYMODULE_KEYTYPE_STRING
#define REDISMODULE_KEYTYPE_LIST VALKEYMODULE_KEYTYPE_LIST
#define REDISMODULE_KEYTYPE_HASH VALKEYMODULE_KEYTYPE_HASH
#define REDISMODULE_KEYTYPE_SET VALKEYMODULE_KEYTYPE_SET
#define REDISMODULE_KEYTYPE_ZSET VALKEYMODULE_KEYTYPE_ZSET
#define REDISMODULE_KEYTYPE_MODULE VALKEYMODULE_KEYTYPE_MODULE
#define REDISMODULE_KEYTYPE_STREAM VALKEYMODULE_KEYTYPE_STREAM
#define REDISMODULE_REPLY_UNKNOWN VALKEYMODULE_REPLY_UNKNOWN
#define REDISMODULE_REPLY_STRING VALKEYMODULE_REPLY_STRING
#define REDISMODULE_REPLY_ERROR VALKEYMODULE_REPLY_ERROR
#define REDISMODULE_REPLY_INTEGER VALKEYMODULE_REPLY_INTEGER
#define REDISMODULE_REPLY_ARRAY VALKEYMODULE_REPLY_ARRAY
#define REDISMODULE_REPLY_NULL VALKEYMODULE_REPLY_NULL
#define REDISMODULE_REPLY_MAP VALKEYMODULE_REPLY_MAP
#define REDISMODULE_REPLY_SET VALKEYMODULE_REPLY_SET
#define REDISMODULE_REPLY_BOOL VALKEYMODULE_REPLY_BOOL
#define REDISMODULE_REPLY_DOUBLE VALKEYMODULE_REPLY_DOUBLE
#define REDISMODULE_REPLY_BIG_NUMBER VALKEYMODULE_REPLY_BIG_NUMBER
#define REDISMODULE_REPLY_VERBATIM_STRING VALKEYMODULE_REPLY_VERBATIM_STRING
#define REDISMODULE_REPLY_ATTRIBUTE VALKEYMODULE_REPLY_ATTRIBUTE
#define REDISMODULE_REPLY_PROMISE VALKEYMODULE_REPLY_PROMISE
#define REDISMODULE_POSTPONED_ARRAY_LEN VALKEYMODULE_POSTPONED_ARRAY_LEN
#define REDISMODULE_POSTPONED_LEN VALKEYMODULE_POSTPONED_LEN
#define REDISMODULE_NO_EXPIRE VALKEYMODULE_NO_EXPIRE
#define REDISMODULE_ZADD_XX VALKEYMODULE_ZADD_XX
#define REDISMODULE_ZADD_NX VALKEYMODULE_ZADD_NX
#define REDISMODULE_ZADD_ADDED VALKEYMODULE_ZADD_ADDED
#define REDISMODULE_ZADD_UPDATED VALKEYMODULE_ZADD_UPDATED
#define REDISMODULE_ZADD_NOP VALKEYMODULE_ZADD_NOP
#define REDISMODULE_ZADD_GT VALKEYMODULE_ZADD_GT
#define REDISMODULE_ZADD_LT VALKEYMODULE_ZADD_LT
#define REDISMODULE_HASH_NONE VALKEYMODULE_HASH_NONE
#define REDISMODULE_HASH_NX VALKEYMODULE_HASH_NX
#define REDISMODULE_HASH_XX VALKEYMODULE_HASH_XX
#define REDISMODULE_HASH_CFIELDS VALKEYMODULE_HASH_CFIELDS
#define REDISMODULE_HASH_EXISTS VALKEYMODULE_HASH_EXISTS
#define REDISMODULE_HASH_COUNT_ALL VALKEYMODULE_HASH_COUNT_ALL
#define REDISMODULE_CONFIG_DEFAULT VALKEYMODULE_CONFIG_DEFAULT
#define REDISMODULE_CONFIG_IMMUTABLE VALKEYMODULE_CONFIG_IMMUTABLE
#define REDISMODULE_CONFIG_SENSITIVE VALKEYMODULE_CONFIG_SENSITIVE
#define REDISMODULE_CONFIG_HIDDEN VALKEYMODULE_CONFIG_HIDDEN
#define REDISMODULE_CONFIG_PROTECTED VALKEYMODULE_CONFIG_PROTECTED
#define REDISMODULE_CONFIG_DENY_LOADING VALKEYMODULE_CONFIG_DENY_LOADING
#define REDISMODULE_CONFIG_MEMORY VALKEYMODULE_CONFIG_MEMORY
#define REDISMODULE_CONFIG_BITFLAGS VALKEYMODULE_CONFIG_BITFLAGS
#define REDISMODULE_STREAM_ADD_AUTOID VALKEYMODULE_STREAM_ADD_AUTOID
#define REDISMODULE_STREAM_ITERATOR_EXCLUSIVE VALKEYMODULE_STREAM_ITERATOR_EXCLUSIVE
#define REDISMODULE_STREAM_ITERATOR_REVERSE VALKEYMODULE_STREAM_ITERATOR_REVERSE
#define REDISMODULE_STREAM_TRIM_APPROX VALKEYMODULE_STREAM_TRIM_APPROX
#define REDISMODULE_CTX_FLAGS_LUA VALKEYMODULE_CTX_FLAGS_LUA
#define REDISMODULE_CTX_FLAGS_MULTI VALKEYMODULE_CTX_FLAGS_MULTI
#define REDISMODULE_CTX_FLAGS_MASTER VALKEYMODULE_CTX_FLAGS_PRIMARY
#define REDISMODULE_CTX_FLAGS_SLAVE VALKEYMODULE_CTX_FLAGS_REPLICA
#define REDISMODULE_CTX_FLAGS_READONLY VALKEYMODULE_CTX_FLAGS_READONLY
#define REDISMODULE_CTX_FLAGS_CLUSTER VALKEYMODULE_CTX_FLAGS_CLUSTER
#define REDISMODULE_CTX_FLAGS_AOF VALKEYMODULE_CTX_FLAGS_AOF
#define REDISMODULE_CTX_FLAGS_RDB VALKEYMODULE_CTX_FLAGS_RDB
#define REDISMODULE_CTX_FLAGS_MAXMEMORY VALKEYMODULE_CTX_FLAGS_MAXMEMORY
#define REDISMODULE_CTX_FLAGS_EVICT VALKEYMODULE_CTX_FLAGS_EVICT
#define REDISMODULE_CTX_FLAGS_OOM VALKEYMODULE_CTX_FLAGS_OOM
#define REDISMODULE_CTX_FLAGS_OOM_WARNING VALKEYMODULE_CTX_FLAGS_OOM_WARNING
#define REDISMODULE_CTX_FLAGS_REPLICATED VALKEYMODULE_CTX_FLAGS_REPLICATED
#define REDISMODULE_CTX_FLAGS_LOADING VALKEYMODULE_CTX_FLAGS_LOADING
#define REDISMODULE_CTX_FLAGS_REPLICA_IS_STALE VALKEYMODULE_CTX_FLAGS_REPLICA_IS_STALE
#define REDISMODULE_CTX_FLAGS_REPLICA_IS_CONNECTING VALKEYMODULE_CTX_FLAGS_REPLICA_IS_CONNECTING
#define REDISMODULE_CTX_FLAGS_REPLICA_IS_TRANSFERRING VALKEYMODULE_CTX_FLAGS_REPLICA_IS_TRANSFERRING
#define REDISMODULE_CTX_FLAGS_REPLICA_IS_ONLINE VALKEYMODULE_CTX_FLAGS_REPLICA_IS_ONLINE
#define REDISMODULE_CTX_FLAGS_ACTIVE_CHILD VALKEYMODULE_CTX_FLAGS_ACTIVE_CHILD
#define REDISMODULE_CTX_FLAGS_MULTI_DIRTY VALKEYMODULE_CTX_FLAGS_MULTI_DIRTY
#define REDISMODULE_CTX_FLAGS_IS_CHILD VALKEYMODULE_CTX_FLAGS_IS_CHILD
#define REDISMODULE_CTX_FLAGS_DENY_BLOCKING VALKEYMODULE_CTX_FLAGS_DENY_BLOCKING
#define REDISMODULE_CTX_FLAGS_RESP3 VALKEYMODULE_CTX_FLAGS_RESP3
#define REDISMODULE_CTX_FLAGS_ASYNC_LOADING VALKEYMODULE_CTX_FLAGS_ASYNC_LOADING
#define REDISMODULE_CTX_FLAGS_SERVER_STARTUP VALKEYMODULE_CTX_FLAGS_SERVER_STARTUP
#define REDISMODULE_NOTIFY_KEYSPACE VALKEYMODULE_NOTIFY_KEYSPACE
#define REDISMODULE_NOTIFY_KEYEVENT VALKEYMODULE_NOTIFY_KEYEVENT
#define REDISMODULE_NOTIFY_GENERIC VALKEYMODULE_NOTIFY_GENERIC
#define REDISMODULE_NOTIFY_STRING VALKEYMODULE_NOTIFY_STRING
#define REDISMODULE_NOTIFY_LIST VALKEYMODULE_NOTIFY_LIST
#define REDISMODULE_NOTIFY_SET VALKEYMODULE_NOTIFY_SET
#define REDISMODULE_NOTIFY_HASH VALKEYMODULE_NOTIFY_HASH
#define REDISMODULE_NOTIFY_ZSET VALKEYMODULE_NOTIFY_ZSET
#define REDISMODULE_NOTIFY_EXPIRED VALKEYMODULE_NOTIFY_EXPIRED
#define REDISMODULE_NOTIFY_EVICTED VALKEYMODULE_NOTIFY_EVICTED
#define REDISMODULE_NOTIFY_STREAM VALKEYMODULE_NOTIFY_STREAM
#define REDISMODULE_NOTIFY_KEY_MISS VALKEYMODULE_NOTIFY_KEY_MISS
#define REDISMODULE_NOTIFY_LOADED VALKEYMODULE_NOTIFY_LOADED
#define REDISMODULE_NOTIFY_MODULE VALKEYMODULE_NOTIFY_MODULE
#define REDISMODULE_NOTIFY_NEW VALKEYMODULE_NOTIFY_NEW
#define REDISMODULE_NOTIFY_ALL VALKEYMODULE_NOTIFY_ALL
#define REDISMODULE_HASH_DELETE VALKEYMODULE_HASH_DELETE
#define REDISMODULE_ERRORMSG_WRONGTYPE VALKEYMODULE_ERRORMSG_WRONGTYPE
#define REDISMODULE_POSITIVE_INFINITE VALKEYMODULE_POSITIVE_INFINITE
#define REDISMODULE_NEGATIVE_INFINITE VALKEYMODULE_NEGATIVE_INFINITE
#define REDISMODULE_NODE_ID_LEN VALKEYMODULE_NODE_ID_LEN
#define REDISMODULE_NODE_MYSELF VALKEYMODULE_NODE_MYSELF
#define REDISMODULE_NODE_MASTER VALKEYMODULE_NODE_PRIMARY
#define REDISMODULE_NODE_SLAVE VALKEYMODULE_NODE_REPLICA
#define REDISMODULE_NODE_PFAIL VALKEYMODULE_NODE_PFAIL
#define REDISMODULE_NODE_FAIL VALKEYMODULE_NODE_FAIL
#define REDISMODULE_NODE_NOFAILOVER VALKEYMODULE_NODE_NOFAILOVER
#define REDISMODULE_CLUSTER_FLAG_NONE VALKEYMODULE_CLUSTER_FLAG_NONE
#define REDISMODULE_CLUSTER_FLAG_NO_FAILOVER VALKEYMODULE_CLUSTER_FLAG_NO_FAILOVER
#define REDISMODULE_CLUSTER_FLAG_NO_REDIRECTION VALKEYMODULE_CLUSTER_FLAG_NO_REDIRECTION
#define REDISMODULE_NOT_USED(V) VALKEYMODULE_NOT_USED(V)
#define REDISMODULE_LOGLEVEL_DEBUG VALKEYMODULE_LOGLEVEL_DEBUG
#define REDISMODULE_LOGLEVEL_VERBOSE VALKEYMODULE_LOGLEVEL_VERBOSE
#define REDISMODULE_LOGLEVEL_NOTICE VALKEYMODULE_LOGLEVEL_NOTICE
#define REDISMODULE_LOGLEVEL_WARNING VALKEYMODULE_LOGLEVEL_WARNING
#define REDISMODULE_AUX_BEFORE_RDB VALKEYMODULE_AUX_BEFORE_RDB
#define REDISMODULE_AUX_AFTER_RDB VALKEYMODULE_AUX_AFTER_RDB
#define REDISMODULE_YIELD_FLAG_NONE VALKEYMODULE_YIELD_FLAG_NONE
#define REDISMODULE_YIELD_FLAG_CLIENTS VALKEYMODULE_YIELD_FLAG_CLIENTS
#define REDISMODULE_BLOCK_UNBLOCK_DEFAULT VALKEYMODULE_BLOCK_UNBLOCK_DEFAULT
#define REDISMODULE_BLOCK_UNBLOCK_DELETED VALKEYMODULE_BLOCK_UNBLOCK_DELETED
#define REDISMODULE_CMDFILTER_NOSELF VALKEYMODULE_CMDFILTER_NOSELF
#define REDISMODULE_OPTIONS_HANDLE_IO_ERRORS VALKEYMODULE_OPTIONS_HANDLE_IO_ERRORS
#define REDISMODULE_OPTION_NO_IMPLICIT_SIGNAL_MODIFIED VALKEYMODULE_OPTION_NO_IMPLICIT_SIGNAL_MODIFIED
#define REDISMODULE_OPTIONS_HANDLE_REPL_ASYNC_LOAD VALKEYMODULE_OPTIONS_HANDLE_REPL_ASYNC_LOAD
#define REDISMODULE_OPTIONS_ALLOW_NESTED_KEYSPACE_NOTIFICATIONS VALKEYMODULE_OPTIONS_ALLOW_NESTED_KEYSPACE_NOTIFICATIONS
#define REDISMODULE_CMD_ARG_NONE VALKEYMODULE_CMD_ARG_NONE
#define REDISMODULE_CMD_ARG_OPTIONAL VALKEYMODULE_CMD_ARG_OPTIONAL
#define REDISMODULE_CMD_ARG_MULTIPLE VALKEYMODULE_CMD_ARG_MULTIPLE
#define REDISMODULE_CMD_ARG_MULTIPLE_TOKEN VALKEYMODULE_CMD_ARG_MULTIPLE_TOKEN
#define REDISMODULE_CMD_KEY_RO VALKEYMODULE_CMD_KEY_RO
#define REDISMODULE_CMD_KEY_RW VALKEYMODULE_CMD_KEY_RW
#define REDISMODULE_CMD_KEY_OW VALKEYMODULE_CMD_KEY_OW
#define REDISMODULE_CMD_KEY_RM VALKEYMODULE_CMD_KEY_RM
#define REDISMODULE_CMD_KEY_ACCESS VALKEYMODULE_CMD_KEY_ACCESS
#define REDISMODULE_CMD_KEY_UPDATE VALKEYMODULE_CMD_KEY_UPDATE
#define REDISMODULE_CMD_KEY_INSERT VALKEYMODULE_CMD_KEY_INSERT
#define REDISMODULE_CMD_KEY_DELETE VALKEYMODULE_CMD_KEY_DELETE
#define REDISMODULE_CMD_KEY_NOT_KEY VALKEYMODULE_CMD_KEY_NOT_KEY
#define REDISMODULE_CMD_KEY_INCOMPLETE VALKEYMODULE_CMD_KEY_INCOMPLETE
#define REDISMODULE_CMD_KEY_VARIABLE_FLAGS VALKEYMODULE_CMD_KEY_VARIABLE_FLAGS
#define REDISMODULE_CMD_CHANNEL_PATTERN VALKEYMODULE_CMD_CHANNEL_PATTERN
#define REDISMODULE_CMD_CHANNEL_PUBLISH VALKEYMODULE_CMD_CHANNEL_PUBLISH
#define REDISMODULE_CMD_CHANNEL_SUBSCRIBE VALKEYMODULE_CMD_CHANNEL_SUBSCRIBE
#define REDISMODULE_CMD_CHANNEL_UNSUBSCRIBE VALKEYMODULE_CMD_CHANNEL_UNSUBSCRIBE
#define REDISMODULE_COMMAND_INFO_VERSION VALKEYMODULE_COMMAND_INFO_VERSION
#define REDISMODULE_EVENTLOOP_READABLE VALKEYMODULE_EVENTLOOP_READABLE
#define REDISMODULE_EVENTLOOP_WRITABLE VALKEYMODULE_EVENTLOOP_WRITABLE
#define REDISMODULE_EVENT_REPLICATION_ROLE_CHANGED VALKEYMODULE_EVENT_REPLICATION_ROLE_CHANGED
#define REDISMODULE_EVENT_PERSISTENCE VALKEYMODULE_EVENT_PERSISTENCE
#define REDISMODULE_EVENT_FLUSHDB VALKEYMODULE_EVENT_FLUSHDB
#define REDISMODULE_EVENT_LOADING VALKEYMODULE_EVENT_LOADING
#define REDISMODULE_EVENT_CLIENT_CHANGE VALKEYMODULE_EVENT_CLIENT_CHANGE
#define REDISMODULE_EVENT_SHUTDOWN VALKEYMODULE_EVENT_SHUTDOWN
#define REDISMODULE_EVENT_REPLICA_CHANGE VALKEYMODULE_EVENT_REPLICA_CHANGE
#define REDISMODULE_EVENT_MASTER_LINK_CHANGE VALKEYMODULE_EVENT_PRIMARY_LINK_CHANGE
#define REDISMODULE_EVENT_CRON_LOOP VALKEYMODULE_EVENT_CRON_LOOP
#define REDISMODULE_EVENT_MODULE_CHANGE VALKEYMODULE_EVENT_MODULE_CHANGE
#define REDISMODULE_EVENT_LOADING_PROGRESS VALKEYMODULE_EVENT_LOADING_PROGRESS
#define REDISMODULE_EVENT_SWAPDB VALKEYMODULE_EVENT_SWAPDB
#define REDISMODULE_EVENT_REPL_BACKUP VALKEYMODULE_EVENT_REPL_BACKUP
#define REDISMODULE_EVENT_FORK_CHILD VALKEYMODULE_EVENT_FORK_CHILD
#define REDISMODULE_EVENT_REPL_ASYNC_LOAD VALKEYMODULE_EVENT_REPL_ASYNC_LOAD
#define REDISMODULE_EVENT_EVENTLOOP VALKEYMODULE_EVENT_EVENTLOOP
#define REDISMODULE_EVENT_CONFIG VALKEYMODULE_EVENT_CONFIG
#define REDISMODULE_EVENT_KEY VALKEYMODULE_EVENT_KEY
#define REDISMODULE_SUBEVENT_PERSISTENCE_RDB_START VALKEYMODULE_SUBEVENT_PERSISTENCE_RDB_START
#define REDISMODULE_SUBEVENT_PERSISTENCE_AOF_START VALKEYMODULE_SUBEVENT_PERSISTENCE_AOF_START
#define REDISMODULE_SUBEVENT_PERSISTENCE_SYNC_RDB_START VALKEYMODULE_SUBEVENT_PERSISTENCE_SYNC_RDB_START
#define REDISMODULE_SUBEVENT_PERSISTENCE_ENDED VALKEYMODULE_SUBEVENT_PERSISTENCE_ENDED
#define REDISMODULE_SUBEVENT_PERSISTENCE_FAILED VALKEYMODULE_SUBEVENT_PERSISTENCE_FAILED
#define REDISMODULE_SUBEVENT_PERSISTENCE_SYNC_AOF_START VALKEYMODULE_SUBEVENT_PERSISTENCE_SYNC_AOF_START
#define REDISMODULE_SUBEVENT_LOADING_RDB_START VALKEYMODULE_SUBEVENT_LOADING_RDB_START
#define REDISMODULE_SUBEVENT_LOADING_AOF_START VALKEYMODULE_SUBEVENT_LOADING_AOF_START
#define REDISMODULE_SUBEVENT_LOADING_REPL_START VALKEYMODULE_SUBEVENT_LOADING_REPL_START
#define REDISMODULE_SUBEVENT_LOADING_ENDED VALKEYMODULE_SUBEVENT_LOADING_ENDED
#define REDISMODULE_SUBEVENT_LOADING_FAILED VALKEYMODULE_SUBEVENT_LOADING_FAILED
#define REDISMODULE_SUBEVENT_CLIENT_CHANGE_CONNECTED VALKEYMODULE_SUBEVENT_CLIENT_CHANGE_CONNECTED
#define REDISMODULE_SUBEVENT_CLIENT_CHANGE_DISCONNECTED VALKEYMODULE_SUBEVENT_CLIENT_CHANGE_DISCONNECTED
#define REDISMODULE_SUBEVENT_MASTER_LINK_UP VALKEYMODULE_SUBEVENT_PRIMARY_LINK_UP
#define REDISMODULE_SUBEVENT_MASTER_LINK_DOWN VALKEYMODULE_SUBEVENT_PRIMARY_LINK_DOWN
#define REDISMODULE_SUBEVENT_REPLICA_CHANGE_ONLINE VALKEYMODULE_SUBEVENT_REPLICA_CHANGE_ONLINE
#define REDISMODULE_SUBEVENT_REPLICA_CHANGE_OFFLINE VALKEYMODULE_SUBEVENT_REPLICA_CHANGE_OFFLINE
#define REDISMODULE_EVENT_REPLROLECHANGED_NOW_MASTER VALKEYMODULE_EVENT_REPLROLECHANGED_NOW_PRIMARY
#define REDISMODULE_EVENT_REPLROLECHANGED_NOW_REPLICA VALKEYMODULE_EVENT_REPLROLECHANGED_NOW_REPLICA
#define REDISMODULE_SUBEVENT_FLUSHDB_START VALKEYMODULE_SUBEVENT_FLUSHDB_START
#define REDISMODULE_SUBEVENT_FLUSHDB_END VALKEYMODULE_SUBEVENT_FLUSHDB_END
#define REDISMODULE_SUBEVENT_MODULE_LOADED VALKEYMODULE_SUBEVENT_MODULE_LOADED
#define REDISMODULE_SUBEVENT_MODULE_UNLOADED VALKEYMODULE_SUBEVENT_MODULE_UNLOADED
#define REDISMODULE_SUBEVENT_CONFIG_CHANGE VALKEYMODULE_SUBEVENT_CONFIG_CHANGE
#define REDISMODULE_SUBEVENT_LOADING_PROGRESS_RDB VALKEYMODULE_SUBEVENT_LOADING_PROGRESS_RDB
#define REDISMODULE_SUBEVENT_LOADING_PROGRESS_AOF VALKEYMODULE_SUBEVENT_LOADING_PROGRESS_AOF
#define REDISMODULE_SUBEVENT_REPL_BACKUP_CREATE VALKEYMODULE_SUBEVENT_REPL_BACKUP_CREATE
#define REDISMODULE_SUBEVENT_REPL_BACKUP_RESTORE VALKEYMODULE_SUBEVENT_REPL_BACKUP_RESTORE
#define REDISMODULE_SUBEVENT_REPL_BACKUP_DISCARD VALKEYMODULE_SUBEVENT_REPL_BACKUP_DISCARD
#define REDISMODULE_SUBEVENT_REPL_ASYNC_LOAD_STARTED VALKEYMODULE_SUBEVENT_REPL_ASYNC_LOAD_STARTED
#define REDISMODULE_SUBEVENT_REPL_ASYNC_LOAD_ABORTED VALKEYMODULE_SUBEVENT_REPL_ASYNC_LOAD_ABORTED
#define REDISMODULE_SUBEVENT_REPL_ASYNC_LOAD_COMPLETED VALKEYMODULE_SUBEVENT_REPL_ASYNC_LOAD_COMPLETED
#define REDISMODULE_SUBEVENT_FORK_CHILD_BORN VALKEYMODULE_SUBEVENT_FORK_CHILD_BORN
#define REDISMODULE_SUBEVENT_FORK_CHILD_DIED VALKEYMODULE_SUBEVENT_FORK_CHILD_DIED
#define REDISMODULE_SUBEVENT_EVENTLOOP_BEFORE_SLEEP VALKEYMODULE_SUBEVENT_EVENTLOOP_BEFORE_SLEEP
#define REDISMODULE_SUBEVENT_EVENTLOOP_AFTER_SLEEP VALKEYMODULE_SUBEVENT_EVENTLOOP_AFTER_SLEEP
#define REDISMODULE_SUBEVENT_KEY_DELETED VALKEYMODULE_SUBEVENT_KEY_DELETED
#define REDISMODULE_SUBEVENT_KEY_EXPIRED VALKEYMODULE_SUBEVENT_KEY_EXPIRED
#define REDISMODULE_SUBEVENT_KEY_EVICTED VALKEYMODULE_SUBEVENT_KEY_EVICTED
#define REDISMODULE_SUBEVENT_KEY_OVERWRITTEN VALKEYMODULE_SUBEVENT_KEY_OVERWRITTEN
#define REDISMODULE_CLIENTINFO_FLAG_SSL VALKEYMODULE_CLIENTINFO_FLAG_SSL
#define REDISMODULE_CLIENTINFO_FLAG_PUBSUB VALKEYMODULE_CLIENTINFO_FLAG_PUBSUB
#define REDISMODULE_CLIENTINFO_FLAG_BLOCKED VALKEYMODULE_CLIENTINFO_FLAG_BLOCKED
#define REDISMODULE_CLIENTINFO_FLAG_TRACKING VALKEYMODULE_CLIENTINFO_FLAG_TRACKING
#define REDISMODULE_CLIENTINFO_FLAG_UNIXSOCKET VALKEYMODULE_CLIENTINFO_FLAG_UNIXSOCKET
#define REDISMODULE_CLIENTINFO_FLAG_MULTI VALKEYMODULE_CLIENTINFO_FLAG_MULTI
#define REDISMODULE_CLIENTINFO_VERSION VALKEYMODULE_CLIENTINFO_VERSION
#define REDISMODULE_CLIENTINFO_INITIALIZER_V1 VALKEYMODULE_CLIENTINFO_INITIALIZER_V1
#define REDISMODULE_REPLICATIONINFO_VERSION VALKEYMODULE_REPLICATIONINFO_VERSION
#define REDISMODULE_FLUSHINFO_VERSION VALKEYMODULE_FLUSHINFO_VERSION
#define REDISMODULE_MODULE_CHANGE_VERSION VALKEYMODULE_MODULE_CHANGE_VERSION
#define REDISMODULE_CONFIGCHANGE_VERSION VALKEYMODULE_CONFIGCHANGE_VERSION
#define REDISMODULE_CRON_LOOP_VERSION VALKEYMODULE_CRON_LOOP_VERSION
#define REDISMODULE_LOADING_PROGRESS_VERSION VALKEYMODULE_LOADING_PROGRESS_VERSION
#define REDISMODULE_SWAPDBINFO_VERSION VALKEYMODULE_SWAPDBINFO_VERSION
#define REDISMODULE_KEYINFO_VERSION VALKEYMODULE_KEYINFO_VERSION
#define REDISMODULE_GET_API(name) VALKEYMODULE_GET_API(name)
#define REDISMODULE_API VALKEYMODULE_API
#define REDISMODULE_ATTR VALKEYMODULE_ATTR

#define REDISMODULE_ACL_LOG_AUTH VALKEYMODULE_ACL_LOG_AUTH
#define REDISMODULE_ACL_LOG_CMD VALKEYMODULE_ACL_LOG_CMD
#define REDISMODULE_ACL_LOG_KEY VALKEYMODULE_ACL_LOG_KEY
#define REDISMODULE_ACL_LOG_CHANNEL VALKEYMODULE_ACL_LOG_CHANNEL

#define REDISMODULE_KSPEC_BS_INVALID VALKEYMODULE_KSPEC_BS_INVALID
#define REDISMODULE_KSPEC_BS_UNKNOWN VALKEYMODULE_KSPEC_BS_UNKNOWN
#define REDISMODULE_KSPEC_BS_INDEX VALKEYMODULE_KSPEC_BS_INDEX
#define REDISMODULE_KSPEC_BS_KEYWORD VALKEYMODULE_KSPEC_BS_KEYWORD

#define REDISMODULE_KSPEC_FK_OMITTED VALKEYMODULE_KSPEC_FK_OMITTED
#define REDISMODULE_KSPEC_FK_UNKNOWN VALKEYMODULE_KSPEC_FK_UNKNOWN
#define REDISMODULE_KSPEC_FK_RANGE VALKEYMODULE_KSPEC_FK_RANGE
#define REDISMODULE_KSPEC_FK_KEYNUM VALKEYMODULE_KSPEC_FK_KEYNUM

#define REDISMODULE_ARG_TYPE_STRING VALKEYMODULE_ARG_TYPE_STRING
#define REDISMODULE_ARG_TYPE_INTEGER VALKEYMODULE_ARG_TYPE_INTEGER
#define REDISMODULE_ARG_TYPE_DOUBLE VALKEYMODULE_ARG_TYPE_DOUBLE
#define REDISMODULE_ARG_TYPE_KEY VALKEYMODULE_ARG_TYPE_KEY
#define REDISMODULE_ARG_TYPE_PATTERN VALKEYMODULE_ARG_TYPE_PATTERN
#define REDISMODULE_ARG_TYPE_UNIX_TIME VALKEYMODULE_ARG_TYPE_UNIX_TIME
#define REDISMODULE_ARG_TYPE_PURE_TOKEN VALKEYMODULE_ARG_TYPE_PURE_TOKEN
#define REDISMODULE_ARG_TYPE_ONEOF VALKEYMODULE_ARG_TYPE_ONEOF
#define REDISMODULE_ARG_TYPE_BLOCK VALKEYMODULE_ARG_TYPE_BLOCK

/* RedisModule typedefs */
#define RedisModuleString ValkeyModuleString
#define RedisModuleKey ValkeyModuleKey
#define RedisModuleStreamID ValkeyModuleStreamID
#define RedisModuleCommandArg ValkeyModuleCommandArg
#define RedisModuleEvent ValkeyModuleEvent
#define RedisModuleClientInfo ValkeyModuleClientInfo
#define RedisModuleReplicationInfo ValkeyModuleReplicationInfo
#define RedisModuleFlushInfo ValkeyModuleFlushInfo
#define RedisModuleModuleChange ValkeyModuleModuleChange
#define RedisModuleConfigChange ValkeyModuleConfigChange
#define RedisModuleCronLoopInfo ValkeyModuleCronLoopInfo
#define RedisModuleLoadingProgressInfo ValkeyModuleLoadingProgressInfo
#define RedisModuleSwapDbInfo ValkeyModuleSwapDbInfo
#define RedisModuleKeyInfo ValkeyModuleKeyInfo
#define RedisModuleIO ValkeyModuleIO
#define RedisModuleDigest ValkeyModuleDigest
#define RedisModuleInfoCtx ValkeyModuleInfoCtx
#define RedisModuleDefragCtx ValkeyModuleDefragCtx
#define RedisModuleCtx ValkeyModuleCtx
#define RedisModuleCommand ValkeyModuleCommand
#define RedisModuleCallReply ValkeyModuleCallReply
#define RedisModuleType ValkeyModuleType
#define RedisModuleBlockedClient ValkeyModuleBlockedClient
#define RedisModuleClusterInfo ValkeyModuleClusterInfo
#define RedisModuleDict ValkeyModuleDict
#define RedisModuleDictIter ValkeyModuleDictIter
#define RedisModuleCommandFilterCtx ValkeyModuleCommandFilterCtx
#define RedisModuleCommandFilter ValkeyModuleCommandFilter
#define RedisModuleServerInfoData ValkeyModuleServerInfoData
#define RedisModuleScanCursor ValkeyModuleScanCursor
#define RedisModuleUser ValkeyModuleUser
#define RedisModuleKeyOptCtx ValkeyModuleKeyOptCtx
#define RedisModuleRdbStream ValkeyModuleRdbStream
#define RedisModuleTypeMethods ValkeyModuleTypeMethods
#define RedisModuleTimerID ValkeyModuleTimerID
#define RedisModuleClientInfo ValkeyModuleClientInfo
#define RedisModuleClientInfoV1 ValkeyModuleClientInfoV1
#define RedisModuleLoadingProgress ValkeyModuleLoadingProgress
#define RedisModuleCronLoop ValkeyModuleCronLoop
#define RedisModuleConfigChangeV1 ValkeyModuleConfigChangeV1
#define RedisModuleKeyInfoV1 ValkeyModuleKeyInfoV1
#define RedisModuleCommandInfo ValkeyModuleCommandInfo
#define RedisModuleCommandKeySpec ValkeyModuleCommandKeySpec
#define RedisModuleCommandHistoryEntry ValkeyModuleCommandHistoryEntry

/* RedisModule APIs */
#define RedisModule_OnLoad ValkeyModule_OnLoad
#define RedisModule_Init ValkeyModule_Init
#define RedisModule_Assert ValkeyModule_Assert
#define RedisModule_Alloc ValkeyModule_Alloc
#define RedisModule_TryAlloc ValkeyModule_TryAlloc
#define RedisModule_Realloc ValkeyModule_Realloc
#define RedisModule_TryRealloc ValkeyModule_TryRealloc
#define RedisModule_Free ValkeyModule_Free
#define RedisModule_Calloc ValkeyModule_Calloc
#define RedisModule_TryCalloc ValkeyModule_TryCalloc
#define RedisModule_Strdup ValkeyModule_Strdup
#define RedisModule_GetApi ValkeyModule_GetApi
#define RedisModule_CreateCommand ValkeyModule_CreateCommand
#define RedisModule_GetCommand ValkeyModule_GetCommand
#define RedisModule_CreateSubcommand ValkeyModule_CreateSubcommand
#define RedisModule_SetCommandInfo ValkeyModule_SetCommandInfo
#define RedisModule_SetCommandACLCategories ValkeyModule_SetCommandACLCategories
#define RedisModule_AddACLCategory ValkeyModule_AddACLCategory
#define RedisModule_SetModuleAttribs ValkeyModule_SetModuleAttribs
#define RedisModule_IsModuleNameBusy ValkeyModule_IsModuleNameBusy
#define RedisModule_WrongArity ValkeyModule_WrongArity
#define RedisModule_ReplyWithLongLong ValkeyModule_ReplyWithLongLong
#define RedisModule_GetSelectedDb ValkeyModule_GetSelectedDb
#define RedisModule_SelectDb ValkeyModule_SelectDb
#define RedisModule_KeyExists ValkeyModule_KeyExists
#define RedisModule_OpenKey ValkeyModule_OpenKey
#define RedisModule_GetOpenKeyModesAll ValkeyModule_GetOpenKeyModesAll
#define RedisModule_CloseKey ValkeyModule_CloseKey
#define RedisModule_KeyType ValkeyModule_KeyType
#define RedisModule_ValueLength ValkeyModule_ValueLength
#define RedisModule_ListPush ValkeyModule_ListPush
#define RedisModule_ListPop ValkeyModule_ListPop
#define RedisModule_ListGet ValkeyModule_ListGet
#define RedisModule_ListSet ValkeyModule_ListSet
#define RedisModule_ListInsert ValkeyModule_ListInsert
#define RedisModule_ListDelete ValkeyModule_ListDelete
#define RedisModule_Call ValkeyModule_Call
#define RedisModule_CallReplyProto ValkeyModule_CallReplyProto
#define RedisModule_FreeCallReply ValkeyModule_FreeCallReply
#define RedisModule_CallReplyType ValkeyModule_CallReplyType
#define RedisModule_CallReplyInteger ValkeyModule_CallReplyInteger
#define RedisModule_CallReplyDouble ValkeyModule_CallReplyDouble
#define RedisModule_CallReplyBool ValkeyModule_CallReplyBool
#define RedisModule_CallReplyBigNumber ValkeyModule_CallReplyBigNumber
#define RedisModule_CallReplyVerbatim ValkeyModule_CallReplyVerbatim
#define RedisModule_CallReplySetElement ValkeyModule_CallReplySetElement
#define RedisModule_CallReplyMapElement ValkeyModule_CallReplyMapElement
#define RedisModule_CallReplyAttributeElement ValkeyModule_CallReplyAttributeElement
#define RedisModule_CallReplyPromiseSetUnblockHandler ValkeyModule_CallReplyPromiseSetUnblockHandler
#define RedisModule_CallReplyPromiseAbort ValkeyModule_CallReplyPromiseAbort
#define RedisModule_CallReplyAttribute ValkeyModule_CallReplyAttribute
#define RedisModule_CallReplyLength ValkeyModule_CallReplyLength
#define RedisModule_CallReplyArrayElement ValkeyModule_CallReplyArrayElement
#define RedisModule_CreateString ValkeyModule_CreateString
#define RedisModule_CreateStringFromLongLong ValkeyModule_CreateStringFromLongLong
#define RedisModule_CreateStringFromULongLong ValkeyModule_CreateStringFromULongLong
#define RedisModule_CreateStringFromDouble ValkeyModule_CreateStringFromDouble
#define RedisModule_CreateStringFromLongDouble ValkeyModule_CreateStringFromLongDouble
#define RedisModule_CreateStringFromString ValkeyModule_CreateStringFromString
#define RedisModule_CreateStringFromStreamID ValkeyModule_CreateStringFromStreamID
#define RedisModule_CreateStringPrintf ValkeyModule_CreateStringPrintf
#define RedisModule_FreeString ValkeyModule_FreeString
#define RedisModule_StringPtrLen ValkeyModule_StringPtrLen
#define RedisModule_ReplyWithError ValkeyModule_ReplyWithError
#define RedisModule_ReplyWithErrorFormat ValkeyModule_ReplyWithErrorFormat
#define RedisModule_ReplyWithSimpleString ValkeyModule_ReplyWithSimpleString
#define RedisModule_ReplyWithArray ValkeyModule_ReplyWithArray
#define RedisModule_ReplyWithMap ValkeyModule_ReplyWithMap
#define RedisModule_ReplyWithSet ValkeyModule_ReplyWithSet
#define RedisModule_ReplyWithAttribute ValkeyModule_ReplyWithAttribute
#define RedisModule_ReplyWithNullArray ValkeyModule_ReplyWithNullArray
#define RedisModule_ReplyWithEmptyArray ValkeyModule_ReplyWithEmptyArray
#define RedisModule_ReplySetArrayLength ValkeyModule_ReplySetArrayLength
#define RedisModule_ReplySetMapLength ValkeyModule_ReplySetMapLength
#define RedisModule_ReplySetSetLength ValkeyModule_ReplySetSetLength
#define RedisModule_ReplySetAttributeLength ValkeyModule_ReplySetAttributeLength
#define RedisModule_ReplySetPushLength ValkeyModule_ReplySetPushLength
#define RedisModule_ReplyWithStringBuffer ValkeyModule_ReplyWithStringBuffer
#define RedisModule_ReplyWithCString ValkeyModule_ReplyWithCString
#define RedisModule_ReplyWithString ValkeyModule_ReplyWithString
#define RedisModule_ReplyWithEmptyString ValkeyModule_ReplyWithEmptyString
#define RedisModule_ReplyWithVerbatimString ValkeyModule_ReplyWithVerbatimString
#define RedisModule_ReplyWithVerbatimStringType ValkeyModule_ReplyWithVerbatimStringType
#define RedisModule_ReplyWithNull ValkeyModule_ReplyWithNull
#define RedisModule_ReplyWithBool ValkeyModule_ReplyWithBool
#define RedisModule_ReplyWithLongDouble ValkeyModule_ReplyWithLongDouble
#define RedisModule_ReplyWithDouble ValkeyModule_ReplyWithDouble
#define RedisModule_ReplyWithBigNumber ValkeyModule_ReplyWithBigNumber
#define RedisModule_ReplyWithCallReply ValkeyModule_ReplyWithCallReply
#define RedisModule_StringToLongLong ValkeyModule_StringToLongLong
#define RedisModule_StringToULongLong ValkeyModule_StringToULongLong
#define RedisModule_StringToDouble ValkeyModule_StringToDouble
#define RedisModule_StringToLongDouble ValkeyModule_StringToLongDouble
#define RedisModule_StringToStreamID ValkeyModule_StringToStreamID
#define RedisModule_AutoMemory ValkeyModule_AutoMemory
#define RedisModule_Replicate ValkeyModule_Replicate
#define RedisModule_ReplicateVerbatim ValkeyModule_ReplicateVerbatim
#define RedisModule_CallReplyStringPtr ValkeyModule_CallReplyStringPtr
#define RedisModule_CreateStringFromCallReply ValkeyModule_CreateStringFromCallReply
#define RedisModule_DeleteKey ValkeyModule_DeleteKey
#define RedisModule_UnlinkKey ValkeyModule_UnlinkKey
#define RedisModule_StringSet ValkeyModule_StringSet
#define RedisModule_StringDMA ValkeyModule_StringDMA
#define RedisModule_StringTruncate ValkeyModule_StringTruncate
#define RedisModule_GetExpire ValkeyModule_GetExpire
#define RedisModule_SetExpire ValkeyModule_SetExpire
#define RedisModule_GetAbsExpire ValkeyModule_GetAbsExpire
#define RedisModule_SetAbsExpire ValkeyModule_SetAbsExpire
#define RedisModule_ResetDataset ValkeyModule_ResetDataset
#define RedisModule_DbSize ValkeyModule_DbSize
#define RedisModule_RandomKey ValkeyModule_RandomKey
#define RedisModule_ZsetAdd ValkeyModule_ZsetAdd
#define RedisModule_ZsetIncrby ValkeyModule_ZsetIncrby
#define RedisModule_ZsetScore ValkeyModule_ZsetScore
#define RedisModule_ZsetRem ValkeyModule_ZsetRem
#define RedisModule_ZsetRangeStop ValkeyModule_ZsetRangeStop
#define RedisModule_ZsetFirstInScoreRange ValkeyModule_ZsetFirstInScoreRange
#define RedisModule_ZsetLastInScoreRange ValkeyModule_ZsetLastInScoreRange
#define RedisModule_ZsetFirstInLexRange ValkeyModule_ZsetFirstInLexRange
#define RedisModule_ZsetLastInLexRange ValkeyModule_ZsetLastInLexRange
#define RedisModule_ZsetRangeCurrentElement ValkeyModule_ZsetRangeCurrentElement
#define RedisModule_ZsetRangeNext ValkeyModule_ZsetRangeNext
#define RedisModule_ZsetRangePrev ValkeyModule_ZsetRangePrev
#define RedisModule_ZsetRangeEndReached ValkeyModule_ZsetRangeEndReached
#define RedisModule_HashSet ValkeyModule_HashSet
#define RedisModule_HashGet ValkeyModule_HashGet
#define RedisModule_StreamAdd ValkeyModule_StreamAdd
#define RedisModule_StreamDelete ValkeyModule_StreamDelete
#define RedisModule_StreamIteratorStart ValkeyModule_StreamIteratorStart
#define RedisModule_StreamIteratorStop ValkeyModule_StreamIteratorStop
#define RedisModule_StreamIteratorNextID ValkeyModule_StreamIteratorNextID
#define RedisModule_StreamIteratorNextField ValkeyModule_StreamIteratorNextField
#define RedisModule_StreamIteratorDelete ValkeyModule_StreamIteratorDelete
#define RedisModule_StreamTrimByLength ValkeyModule_StreamTrimByLength
#define RedisModule_StreamTrimByID ValkeyModule_StreamTrimByID
#define RedisModule_IsKeysPositionRequest ValkeyModule_IsKeysPositionRequest
#define RedisModule_KeyAtPos ValkeyModule_KeyAtPos
#define RedisModule_KeyAtPosWithFlags ValkeyModule_KeyAtPosWithFlags
#define RedisModule_IsChannelsPositionRequest ValkeyModule_IsChannelsPositionRequest
#define RedisModule_ChannelAtPosWithFlags ValkeyModule_ChannelAtPosWithFlags
#define RedisModule_GetClientId ValkeyModule_GetClientId
#define RedisModule_GetClientUserNameById ValkeyModule_GetClientUserNameById
#define RedisModule_GetClientInfoById ValkeyModule_GetClientInfoById
#define RedisModule_GetClientNameById ValkeyModule_GetClientNameById
#define RedisModule_SetClientNameById ValkeyModule_SetClientNameById
#define RedisModule_PublishMessage ValkeyModule_PublishMessage
#define RedisModule_PublishMessageShard ValkeyModule_PublishMessageShard
#define RedisModule_GetContextFlags ValkeyModule_GetContextFlags
#define RedisModule_AvoidReplicaTraffic ValkeyModule_AvoidReplicaTraffic
#define RedisModule_PoolAlloc ValkeyModule_PoolAlloc
#define RedisModule_CreateDataType ValkeyModule_CreateDataType
#define RedisModule_ModuleTypeSetValue ValkeyModule_ModuleTypeSetValue
#define RedisModule_ModuleTypeReplaceValue ValkeyModule_ModuleTypeReplaceValue
#define RedisModule_ModuleTypeGetType ValkeyModule_ModuleTypeGetType
#define RedisModule_ModuleTypeGetValue ValkeyModule_ModuleTypeGetValue
#define RedisModule_IsIOError ValkeyModule_IsIOError
#define RedisModule_SetModuleOptions ValkeyModule_SetModuleOptions
#define RedisModule_SignalModifiedKey ValkeyModule_SignalModifiedKey
#define RedisModule_SaveUnsigned ValkeyModule_SaveUnsigned
#define RedisModule_LoadUnsigned ValkeyModule_LoadUnsigned
#define RedisModule_SaveSigned ValkeyModule_SaveSigned
#define RedisModule_LoadSigned ValkeyModule_LoadSigned
#define RedisModule_EmitAOF ValkeyModule_EmitAOF
#define RedisModule_SaveString ValkeyModule_SaveString
#define RedisModule_SaveStringBuffer ValkeyModule_SaveStringBuffer
#define RedisModule_LoadString ValkeyModule_LoadString
#define RedisModule_LoadStringBuffer ValkeyModule_LoadStringBuffer
#define RedisModule_SaveDouble ValkeyModule_SaveDouble
#define RedisModule_LoadDouble ValkeyModule_LoadDouble
#define RedisModule_SaveFloat ValkeyModule_SaveFloat
#define RedisModule_LoadFloat ValkeyModule_LoadFloat
#define RedisModule_SaveLongDouble ValkeyModule_SaveLongDouble
#define RedisModule_LoadLongDouble ValkeyModule_LoadLongDouble
#define RedisModule_LoadDataTypeFromString ValkeyModule_LoadDataTypeFromString
#define RedisModule_LoadDataTypeFromStringEncver ValkeyModule_LoadDataTypeFromStringEncver
#define RedisModule_SaveDataTypeToString ValkeyModule_SaveDataTypeToString
#define RedisModule_Log ValkeyModule_Log
#define RedisModule_LogIOError ValkeyModule_LogIOError
#define RedisModule__Assert ValkeyModule__Assert
#define RedisModule_LatencyAddSample ValkeyModule_LatencyAddSample
#define RedisModule_StringAppendBuffer ValkeyModule_StringAppendBuffer
#define RedisModule_TrimStringAllocation ValkeyModule_TrimStringAllocation
#define RedisModule_RetainString ValkeyModule_RetainString
#define RedisModule_HoldString ValkeyModule_HoldString
#define RedisModule_StringCompare ValkeyModule_StringCompare
#define RedisModule_GetContextFromIO ValkeyModule_GetContextFromIO
#define RedisModule_GetKeyNameFromIO ValkeyModule_GetKeyNameFromIO
#define RedisModule_GetKeyNameFromModuleKey ValkeyModule_GetKeyNameFromModuleKey
#define RedisModule_GetDbIdFromModuleKey ValkeyModule_GetDbIdFromModuleKey
#define RedisModule_GetDbIdFromIO ValkeyModule_GetDbIdFromIO
#define RedisModule_GetDbIdFromOptCtx ValkeyModule_GetDbIdFromOptCtx
#define RedisModule_GetToDbIdFromOptCtx ValkeyModule_GetToDbIdFromOptCtx
#define RedisModule_GetKeyNameFromOptCtx ValkeyModule_GetKeyNameFromOptCtx
#define RedisModule_GetToKeyNameFromOptCtx ValkeyModule_GetToKeyNameFromOptCtx
#define RedisModule_Milliseconds ValkeyModule_Milliseconds
#define RedisModule_MonotonicMicroseconds ValkeyModule_MonotonicMicroseconds
#define RedisModule_Microseconds ValkeyModule_Microseconds
#define RedisModule_CachedMicroseconds ValkeyModule_CachedMicroseconds
#define RedisModule_DigestAddStringBuffer ValkeyModule_DigestAddStringBuffer
#define RedisModule_DigestAddLongLong ValkeyModule_DigestAddLongLong
#define RedisModule_DigestEndSequence ValkeyModule_DigestEndSequence
#define RedisModule_GetDbIdFromDigest ValkeyModule_GetDbIdFromDigest
#define RedisModule_GetKeyNameFromDigest ValkeyModule_GetKeyNameFromDigest
#define RedisModule_CreateDict ValkeyModule_CreateDict
#define RedisModule_FreeDict ValkeyModule_FreeDict
#define RedisModule_DictSize ValkeyModule_DictSize
#define RedisModule_DictSetC ValkeyModule_DictSetC
#define RedisModule_DictReplaceC ValkeyModule_DictReplaceC
#define RedisModule_DictSet ValkeyModule_DictSet
#define RedisModule_DictReplace ValkeyModule_DictReplace
#define RedisModule_DictGetC ValkeyModule_DictGetC
#define RedisModule_DictGet ValkeyModule_DictGet
#define RedisModule_DictDelC ValkeyModule_DictDelC
#define RedisModule_DictDel ValkeyModule_DictDel
#define RedisModule_DictIteratorStartC ValkeyModule_DictIteratorStartC
#define RedisModule_DictIteratorStart ValkeyModule_DictIteratorStart
#define RedisModule_DictIteratorStop ValkeyModule_DictIteratorStop
#define RedisModule_DictIteratorReseekC ValkeyModule_DictIteratorReseekC
#define RedisModule_DictIteratorReseek ValkeyModule_DictIteratorReseek
#define RedisModule_DictNextC ValkeyModule_DictNextC
#define RedisModule_DictPrevC ValkeyModule_DictPrevC
#define RedisModule_DictNext ValkeyModule_DictNext
#define RedisModule_DictPrev ValkeyModule_DictPrev
#define RedisModule_DictCompareC ValkeyModule_DictCompareC
#define RedisModule_DictCompare ValkeyModule_DictCompare
#define RedisModule_RegisterInfoFunc ValkeyModule_RegisterInfoFunc
#define RedisModule_RegisterAuthCallback ValkeyModule_RegisterAuthCallback
#define RedisModule_InfoAddSection ValkeyModule_InfoAddSection
#define RedisModule_InfoBeginDictField ValkeyModule_InfoBeginDictField
#define RedisModule_InfoEndDictField ValkeyModule_InfoEndDictField
#define RedisModule_InfoAddFieldString ValkeyModule_InfoAddFieldString
#define RedisModule_InfoAddFieldCString ValkeyModule_InfoAddFieldCString
#define RedisModule_InfoAddFieldDouble ValkeyModule_InfoAddFieldDouble
#define RedisModule_InfoAddFieldLongLong ValkeyModule_InfoAddFieldLongLong
#define RedisModule_InfoAddFieldULongLong ValkeyModule_InfoAddFieldULongLong
#define RedisModule_GetServerInfo ValkeyModule_GetServerInfo
#define RedisModule_FreeServerInfo ValkeyModule_FreeServerInfo
#define RedisModule_ServerInfoGetField ValkeyModule_ServerInfoGetField
#define RedisModule_ServerInfoGetFieldC ValkeyModule_ServerInfoGetFieldC
#define RedisModule_ServerInfoGetFieldSigned ValkeyModule_ServerInfoGetFieldSigned
#define RedisModule_ServerInfoGetFieldUnsigned ValkeyModule_ServerInfoGetFieldUnsigned
#define RedisModule_ServerInfoGetFieldDouble ValkeyModule_ServerInfoGetFieldDouble
#define RedisModule_SubscribeToServerEvent ValkeyModule_SubscribeToServerEvent
#define RedisModule_SetLRU ValkeyModule_SetLRU
#define RedisModule_GetLRU ValkeyModule_GetLRU
#define RedisModule_SetLFU ValkeyModule_SetLFU
#define RedisModule_GetLFU ValkeyModule_GetLFU
#define RedisModule_BlockClientOnKeys ValkeyModule_BlockClientOnKeys
#define RedisModule_BlockClientOnKeysWithFlags ValkeyModule_BlockClientOnKeysWithFlags
#define RedisModule_SignalKeyAsReady ValkeyModule_SignalKeyAsReady
#define RedisModule_GetBlockedClientReadyKey ValkeyModule_GetBlockedClientReadyKey
#define RedisModule_ScanCursorCreate ValkeyModule_ScanCursorCreate
#define RedisModule_ScanCursorRestart ValkeyModule_ScanCursorRestart
#define RedisModule_ScanCursorDestroy ValkeyModule_ScanCursorDestroy
#define RedisModule_Scan ValkeyModule_Scan
#define RedisModule_ScanKey ValkeyModule_ScanKey
#define RedisModule_GetContextFlagsAll ValkeyModule_GetContextFlagsAll
#define RedisModule_GetModuleOptionsAll ValkeyModule_GetModuleOptionsAll
#define RedisModule_GetKeyspaceNotificationFlagsAll ValkeyModule_GetKeyspaceNotificationFlagsAll
#define RedisModule_IsSubEventSupported ValkeyModule_IsSubEventSupported
#define RedisModule_GetServerVersion ValkeyModule_GetServerVersion
#define RedisModule_GetTypeMethodVersion ValkeyModule_GetTypeMethodVersion
#define RedisModule_Yield ValkeyModule_Yield
#define RedisModule_BlockClient ValkeyModule_BlockClient
#define RedisModule_BlockClientGetPrivateData ValkeyModule_BlockClientGetPrivateData
#define RedisModule_BlockClientSetPrivateData ValkeyModule_BlockClientSetPrivateData
#define RedisModule_BlockClientOnAuth ValkeyModule_BlockClientOnAuth
#define RedisModule_UnblockClient ValkeyModule_UnblockClient
#define RedisModule_IsBlockedReplyRequest ValkeyModule_IsBlockedReplyRequest
#define RedisModule_IsBlockedTimeoutRequest ValkeyModule_IsBlockedTimeoutRequest
#define RedisModule_GetBlockedClientPrivateData ValkeyModule_GetBlockedClientPrivateData
#define RedisModule_GetBlockedClientHandle ValkeyModule_GetBlockedClientHandle
#define RedisModule_AbortBlock ValkeyModule_AbortBlock
#define RedisModule_BlockedClientMeasureTimeStart ValkeyModule_BlockedClientMeasureTimeStart
#define RedisModule_BlockedClientMeasureTimeEnd ValkeyModule_BlockedClientMeasureTimeEnd
#define RedisModule_GetThreadSafeContext ValkeyModule_GetThreadSafeContext
#define RedisModule_GetDetachedThreadSafeContext ValkeyModule_GetDetachedThreadSafeContext
#define RedisModule_FreeThreadSafeContext ValkeyModule_FreeThreadSafeContext
#define RedisModule_ThreadSafeContextLock ValkeyModule_ThreadSafeContextLock
#define RedisModule_ThreadSafeContextTryLock ValkeyModule_ThreadSafeContextTryLock
#define RedisModule_ThreadSafeContextUnlock ValkeyModule_ThreadSafeContextUnlock
#define RedisModule_SubscribeToKeyspaceEvents ValkeyModule_SubscribeToKeyspaceEvents
#define RedisModule_AddPostNotificationJob ValkeyModule_AddPostNotificationJob
#define RedisModule_NotifyKeyspaceEvent ValkeyModule_NotifyKeyspaceEvent
#define RedisModule_GetNotifyKeyspaceEvents ValkeyModule_GetNotifyKeyspaceEvents
#define RedisModule_BlockedClientDisconnected ValkeyModule_BlockedClientDisconnected
#define RedisModule_RegisterClusterMessageReceiver ValkeyModule_RegisterClusterMessageReceiver
#define RedisModule_SendClusterMessage ValkeyModule_SendClusterMessage
#define RedisModule_GetClusterNodeInfo ValkeyModule_GetClusterNodeInfo
#define RedisModule_GetClusterNodesList ValkeyModule_GetClusterNodesList
#define RedisModule_FreeClusterNodesList ValkeyModule_FreeClusterNodesList
#define RedisModule_CreateTimer ValkeyModule_CreateTimer
#define RedisModule_StopTimer ValkeyModule_StopTimer
#define RedisModule_GetTimerInfo ValkeyModule_GetTimerInfo
#define RedisModule_GetMyClusterID ValkeyModule_GetMyClusterID
#define RedisModule_GetClusterSize ValkeyModule_GetClusterSize
#define RedisModule_GetRandomBytes ValkeyModule_GetRandomBytes
#define RedisModule_GetRandomHexChars ValkeyModule_GetRandomHexChars
#define RedisModule_SetDisconnectCallback ValkeyModule_SetDisconnectCallback
#define RedisModule_SetClusterFlags ValkeyModule_SetClusterFlags
#define RedisModule_ClusterKeySlot ValkeyModule_ClusterKeySlot
#define RedisModule_ClusterCanonicalKeyNameInSlot ValkeyModule_ClusterCanonicalKeyNameInSlot
#define RedisModule_ExportSharedAPI ValkeyModule_ExportSharedAPI
#define RedisModule_GetSharedAPI ValkeyModule_GetSharedAPI
#define RedisModule_RegisterCommandFilter ValkeyModule_RegisterCommandFilter
#define RedisModule_UnregisterCommandFilter ValkeyModule_UnregisterCommandFilter
#define RedisModule_CommandFilterArgsCount ValkeyModule_CommandFilterArgsCount
#define RedisModule_CommandFilterArgGet ValkeyModule_CommandFilterArgGet
#define RedisModule_CommandFilterArgInsert ValkeyModule_CommandFilterArgInsert
#define RedisModule_CommandFilterArgReplace ValkeyModule_CommandFilterArgReplace
#define RedisModule_CommandFilterArgDelete ValkeyModule_CommandFilterArgDelete
#define RedisModule_CommandFilterGetClientId ValkeyModule_CommandFilterGetClientId
#define RedisModule_Fork ValkeyModule_Fork
#define RedisModule_SendChildHeartbeat ValkeyModule_SendChildHeartbeat
#define RedisModule_ExitFromChild ValkeyModule_ExitFromChild
#define RedisModule_KillForkChild ValkeyModule_KillForkChild
#define RedisModule_GetUsedMemoryRatio ValkeyModule_GetUsedMemoryRatio
#define RedisModule_MallocSize ValkeyModule_MallocSize
#define RedisModule_MallocUsableSize ValkeyModule_MallocUsableSize
#define RedisModule_MallocSizeString ValkeyModule_MallocSizeString
#define RedisModule_MallocSizeDict ValkeyModule_MallocSizeDict
#define RedisModule_CreateModuleUser ValkeyModule_CreateModuleUser
#define RedisModule_FreeModuleUser ValkeyModule_FreeModuleUser
#define RedisModule_SetContextUser ValkeyModule_SetContextUser
#define RedisModule_SetModuleUserACL ValkeyModule_SetModuleUserACL
#define RedisModule_SetModuleUserACLString ValkeyModule_SetModuleUserACLString
#define RedisModule_GetModuleUserACLString ValkeyModule_GetModuleUserACLString
#define RedisModule_GetCurrentUserName ValkeyModule_GetCurrentUserName
#define RedisModule_GetModuleUserFromUserName ValkeyModule_GetModuleUserFromUserName
#define RedisModule_ACLCheckCommandPermissions ValkeyModule_ACLCheckCommandPermissions
#define RedisModule_ACLCheckKeyPermissions ValkeyModule_ACLCheckKeyPermissions
#define RedisModule_ACLCheckChannelPermissions ValkeyModule_ACLCheckChannelPermissions
#define RedisModule_ACLAddLogEntry ValkeyModule_ACLAddLogEntry
#define RedisModule_ACLAddLogEntryByUserName ValkeyModule_ACLAddLogEntryByUserName
#define RedisModule_AuthenticateClientWithACLUser ValkeyModule_AuthenticateClientWithACLUser
#define RedisModule_AuthenticateClientWithUser ValkeyModule_AuthenticateClientWithUser
#define RedisModule_DeauthenticateAndCloseClient ValkeyModule_DeauthenticateAndCloseClient
#define RedisModule_RedactClientCommandArgument ValkeyModule_RedactClientCommandArgument
#define RedisModule_GetClientCertificate ValkeyModule_GetClientCertificate
#define RedisModule_GetCommandKeys ValkeyModule_GetCommandKeys
#define RedisModule_GetCommandKeysWithFlags ValkeyModule_GetCommandKeysWithFlags
#define RedisModule_GetCurrentCommandName ValkeyModule_GetCurrentCommandName
#define RedisModule_RegisterDefragFunc ValkeyModule_RegisterDefragFunc
#define RedisModule_DefragAlloc ValkeyModule_DefragAlloc
#define RedisModule_DefragRedisModuleString ValkeyModule_DefragValkeyModuleString
#define RedisModule_DefragShouldStop ValkeyModule_DefragShouldStop
#define RedisModule_DefragCursorSet ValkeyModule_DefragCursorSet
#define RedisModule_DefragCursorGet ValkeyModule_DefragCursorGet
#define RedisModule_GetDbIdFromDefragCtx ValkeyModule_GetDbIdFromDefragCtx
#define RedisModule_GetKeyNameFromDefragCtx ValkeyModule_GetKeyNameFromDefragCtx
#define RedisModule_EventLoopAdd ValkeyModule_EventLoopAdd
#define RedisModule_EventLoopDel ValkeyModule_EventLoopDel
#define RedisModule_EventLoopAddOneShot ValkeyModule_EventLoopAddOneShot
#define RedisModule_RegisterBoolConfig ValkeyModule_RegisterBoolConfig
#define RedisModule_RegisterNumericConfig ValkeyModule_RegisterNumericConfig
#define RedisModule_RegisterStringConfig ValkeyModule_RegisterStringConfig
#define RedisModule_RegisterEnumConfig ValkeyModule_RegisterEnumConfig
#define RedisModule_LoadConfigs ValkeyModule_LoadConfigs
#define RedisModule_RdbStreamCreateFromFile ValkeyModule_RdbStreamCreateFromFile
#define RedisModule_RdbStreamFree ValkeyModule_RdbStreamFree
#define RedisModule_RdbLoad ValkeyModule_RdbLoad
#define RedisModule_RdbSave ValkeyModule_RdbSave

/* RedisModuleEvent */
#define RedisModuleEvent_FlushDB ValkeyModuleEvent_FlushDB
#define RedisModuleEvent_FlushDBV2 ValkeyModuleEvent_FlushDBV2
#define RedisModuleEvent_FlushDBV1 ValkeyModuleEvent_FlushDBV1
#define RedisModuleEvent_FlushDB ValkeyModuleEvent_FlushDB
#define RedisModuleEvent_ReplicationRoleChanged ValkeyModuleEvent_ReplicationRoleChanged
#define RedisModuleEvent_Persistence ValkeyModuleEvent_Persistence
#define RedisModuleEvent_FlushDB ValkeyModuleEvent_FlushDB
#define RedisModuleEvent_Loading ValkeyModuleEvent_Loading
#define RedisModuleEvent_ClientChange ValkeyModuleEvent_ClientChange
#define RedisModuleEvent_Shutdown ValkeyModuleEvent_Shutdown
#define RedisModuleEvent_ReplicaChange ValkeyModuleEvent_ReplicaChange
#define RedisModuleEvent_CronLoop ValkeyModuleEvent_CronLoop
#define RedisModuleEvent_MasterLinkChange ValkeyModuleEvent_PrimaryLinkChange
#define RedisModuleEvent_ModuleChange ValkeyModuleEvent_ModuleChange
#define RedisModuleEvent_LoadingProgress ValkeyModuleEvent_LoadingProgress
#define RedisModuleEvent_SwapDB ValkeyModuleEvent_SwapDB
#define RedisModuleEvent_ReplAsyncLoad ValkeyModuleEvent_ReplAsyncLoad
#define RedisModuleEvent_ForkChild ValkeyModuleEvent_ForkChild
#define RedisModuleEvent_EventLoop ValkeyModuleEvent_EventLoop
#define RedisModuleEvent_Config ValkeyModuleEvent_Config
#define RedisModuleEvent_Key ValkeyModuleEvent_Key
