/*
 * ===========================
 * VDK Builder
 * Version 1.2
 * November 2000
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library 
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
/*
  this file contains patches that fix bugs
  that can't be completely removed without
  break compatibility with older versions
*/
#include <stdio.h>
#include <string.h>

/*
  returns a new string where double slashes "//" are replaced with 
  a singol one "/" into project full path names.  This bug was 
  introduced by project wizard and disseminate into project files
  so bug can't be removed without break compatibility with old or
  already uncorrect files.
 */
char* BugFix01(const char* where)
{
  char* local = new char[strlen(where)+1];
  char* local1 = new char[strlen(where)+1];
  char* ret = NULL;
  strcpy(local,where);
  char* p = strstr(local,"//");
  if(p)
    {
      *p ='\0';
      strcpy(local1,local);
      strcat(local1,"/");
      p += 2;
      strcat(local1,p);
      ret = local1;
    }
  delete[] local;
  if(!ret)
    delete[] local1;
  return ret;
}
