/* packet-parlay.c
 *
 * Routines for IDL dissection
 *
 * Autogenerated from idl2wrs
 * Copyright 2001 Frank Singleton <frank.singleton@ericsson.com>
 */


/*
 * Wireshark - Network traffic analyzer
 * By Gerald Combs
 * Copyright 1999 - 2012 Gerald Combs
 */

/*
 * SPDX-License-Identifier: GPL-2.0-or-later
 */


#include "config.h"

#include <gmodule.h>

#include <string.h>
#include <glib.h>
#include <epan/packet.h>
#include <epan/proto.h>
#include <epan/dissectors/packet-giop.h>
#include <epan/expert.h>

#include "ws_diag_control.h"
#include "ws_compiler_tests.h"

#ifdef _MSC_VER
/* disable warning: "unreference local variable" */
#pragma warning(disable:4101)
#endif

/* XXX this should be autogenerated, or the warnings fixed in the generator */
DIAG_OFF(unused-function)
DIAG_OFF(unused-variable)
#if WS_IS_AT_LEAST_GNUC_VERSION(6,0)
DIAG_OFF(unused-const-variable)
#endif

void proto_register_giop_parlay(void);
void proto_reg_handoff_giop_parlay(void);

/* Initialise the protocol and subtree pointers */
static int proto_parlay = -1;
static gint ett_parlay = -1;


/* Initialise the initial Alignment */
static guint32  boundary = GIOP_HEADER_SIZE;  /* initial value */

static int hf_operationrequest = -1;/* Request_Operation field */

        /* Operation filters */
static int hf_org_csapi_IpService_setCallbackWithSessionID_sessionID = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthentication_authType = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthenticationWithVersion_authType = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthenticationWithVersion_frameworkVersion = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAuthentication_requestAccess_accessType = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_terminationText = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_signingAlgorithm = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterface_interfaceName = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterfaceWithCallback_interfaceName = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_releaseInterface_interfaceName = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_selectSigningAlgorithm_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_selectSigningAlgorithm_signingAlgorithmCaps = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_terminationText = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_interfaceName = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_terminationText = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectEncryptionMethod_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectEncryptionMethod_encryptionCaps = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectAuthenticationMechanism_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectAuthenticationMechanism_authMechanismList = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge_loop = -1;
static int hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge = -1;
static int hf_org_csapi_fw_fw_application_notification_IpAppEventNotification_reportNotification_assignmentID = -1;
static int hf_org_csapi_fw_fw_application_notification_IpEventNotification_createNotification_return = -1;
static int hf_org_csapi_fw_fw_application_notification_IpEventNotification_destroyNotification_assignmentID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestRes_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestRes_activityTestResult = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appActivityTestReq_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultReportInd_fault = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultRecoveryInd_fault = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcUnavailableInd_serviceID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcUnavailableInd_reason = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwUnavailableInd_reason = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestErr_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appUnavailableInd_serviceID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcAvailStatusInd_serviceID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryAppLoadStatsReq_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsErr_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_reportLoad_loadLevel = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsErr_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppOAM_systemDateTimeQuery_return = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppOAM_systemDateTimeQuery_systemDateAndTime = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpOAM_systemDateTimeQuery_return = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpOAM_systemDateTimeQuery_clientDateAndTime = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_activityTestReq_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_activityTestReq_svcID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestRes_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestRes_activityTestResult = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_svcUnavailableInd_serviceID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestErr_activityTestID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appUnavailableInd_serviceID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_enableHeartBeat_interval = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_changeInterval_interval = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_enableAppHeartBeat_interval = -1;
static int hf_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_changeInterval_interval = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return_loop = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_describeServiceType_name = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return_loop = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_serviceTypeName = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList_loop = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_max = -1;
static int hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return_loop = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return_loop = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_serviceToken = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_agreementText = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_signingAlgorithm = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_serviceToken = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_terminationText = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature_loop = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_serviceToken = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_agreementText = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_signingAlgorithm = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_serviceToken = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_terminationText = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature_loop = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_selectService_return = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_selectService_serviceID = -1;
static int hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_initiateSignServiceAgreement_serviceToken = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_createServiceProfile_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deleteServiceProfile_serviceProfileID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_assign_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_assign_serviceProfileID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deassign_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deassign_serviceProfileID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_describeServiceProfile_serviceProfileID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_serviceProfileID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_createServiceContract_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_deleteServiceContract_serviceContractID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_describeServiceContract_serviceContractID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_serviceContractID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteClientApp_clientAppID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteSAG_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeClientApp_clientAppID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeSAG_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeSAG_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_sagID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return_loop = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_clientAppID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_notification_IpClientEventNotification_reportNotification_assignmentID = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_createNotification_return = -1;
static int hf_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_destroyNotification_assignmentID = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return_loop = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_describeServiceType_name = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return_loop = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_serviceTypeName = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList_loop = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_max = -1;
static int hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return_loop = -1;
static int hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_application = -1;
static int hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties_loop = -1;
static int hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceInstanceID = -1;
static int hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_destroyServiceManager_serviceInstance = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_return = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_serviceTypeName = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList_loop = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_announceServiceAvailability_serviceID = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unregisterService_serviceID = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_describeService_serviceID = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unannounceService_serviceID = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_return = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_serviceTypeName = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList_loop = -1;
static int hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_querySvcLoadStatsReq_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsErr_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsErr_loadStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_reportLoad_loadLevel = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadReq_querySubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadErr_loadStatisticError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_createLoadLevelNotification_notificationSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_destroyLoadLevelNotification_notificationSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_suspendNotification_notificationSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_resumeNotification_notificationSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadStatsReq_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadStatsReq_querySubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsErr_loadStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsErr_loadStatisticError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestRes_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestRes_activityTestResult = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_svcActivityTestReq_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultReportInd_fault = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultRecoveryInd_fault = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwUnavailableInd_reason = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordRes_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestErr_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordErr_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_appAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordRes_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_activityTestReq_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_activityTestReq_testSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestRes_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestRes_activityTestResult = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordReq_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcUnavailableInd_reason = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestErr_activityTestID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs_loop = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcAvailStatusInd_reason = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordReq_recordSubject = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcOAM_systemDateTimeQuery_return = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcOAM_systemDateTimeQuery_systemDateAndTime = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwOAM_systemDateTimeQuery_return = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwOAM_systemDateTimeQuery_clientDateAndTime = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_enableHeartBeat_interval = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_changeInterval_interval = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_enableSvcHeartBeat_interval = -1;
static int hf_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_changeInterval_interval = -1;
static int hf_org_csapi_fw_fw_service_notification_IpFwEventNotification_createNotification_return = -1;
static int hf_org_csapi_fw_fw_service_notification_IpFwEventNotification_destroyNotification_assignmentID = -1;
static int hf_org_csapi_fw_fw_service_notification_IpSvcEventNotification_reportNotification_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_routeRes_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_routeRes_callLegSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_routeErr_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_routeErr_callLegSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_getCallInfoRes_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_getCallInfoErr_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_report = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_usedTime = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_superviseCallErr_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_callFaultDetected_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_callFaultDetected_fault = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsRes_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsRes_digits = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsErr_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCall_callEnded_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_routeReq_return = -1;
static int hf_org_csapi_cc_gccs_IpCall_routeReq_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_routeReq_responseRequested_loop = -1;
static int hf_org_csapi_cc_gccs_IpCall_routeReq_appInfo_loop = -1;
static int hf_org_csapi_cc_gccs_IpCall_release_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_deassignCall_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_getCallInfoReq_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_getCallInfoReq_callInfoRequested = -1;
static int hf_org_csapi_cc_gccs_IpCall_setCallChargePlan_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_setAdviceOfCharge_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_setAdviceOfCharge_tariffSwitch = -1;
static int hf_org_csapi_cc_gccs_IpCall_getMoreDialledDigitsReq_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_getMoreDialledDigitsReq_length = -1;
static int hf_org_csapi_cc_gccs_IpCall_superviseCallReq_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpCall_superviseCallReq_time = -1;
static int hf_org_csapi_cc_gccs_IpCall_superviseCallReq_treatment = -1;
static int hf_org_csapi_cc_gccs_IpCall_continueProcessing_callSessionID = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_callAborted_callReference = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_callEventNotify_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadEncountered_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadCeased_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet_loop = -1;
static int hf_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_enableCallNotification_return = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_disableCallNotification_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_setCallLoadControl_return = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_setCallLoadControl_duration = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_changeCallNotification_assignmentID = -1;
static int hf_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return_loop = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_eventReportRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_eventReportErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_getInfoRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_getInfoErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_routeErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_report = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_usedTime = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseErr_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_callLegEnded_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppCallLeg_callLegEnded_cause = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_createNotification_return = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_destroyNotification_assignmentID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_changeNotification_assignmentID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return_loop = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_setCallLoadControl_return = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_setCallLoadControl_duration = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_enableNotifications_return = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNextNotification_reset = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_routeReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo_loop = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested_loop = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_release_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_release_cause = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getInfoReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getInfoReq_callLegInfoRequested = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getCall_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_attachMediaReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_detachMediaReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getCurrentDestinationAddress_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_continueProcessing_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_setChargePlan_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_setAdviceOfCharge_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_setAdviceOfCharge_tariffSwitch = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_superviseReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_superviseReq_time = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_superviseReq_treatment = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_deassign_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getProperties_return_loop = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getProperties_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getProperties_propertyNames_loop = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_getProperties_propertyNames = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_setProperties_callLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpCallLeg_setProperties_properties_loop = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_getInfoRes_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_getInfoErr_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_superviseRes_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_superviseRes_report = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_superviseRes_usedTime = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_superviseErr_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_callEnded_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCall_createAndRouteCallLegErr_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_getCallLegs_return_loop = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_getCallLegs_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_createCallLeg_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_createAndRouteCallLegReq_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_createAndRouteCallLegReq_eventsRequested_loop = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_createAndRouteCallLegReq_appInfo_loop = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_release_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_release_cause = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_deassignCall_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_getInfoReq_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_getInfoReq_callInfoRequested = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_setChargePlan_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_setAdviceOfCharge_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_setAdviceOfCharge_tariffSwitch = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_superviseReq_callSessionID = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_superviseReq_time = -1;
static int hf_org_csapi_cc_mpccs_IpMultiPartyCall_superviseReq_treatment = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_reportNotification_callLegReferenceSet_loop = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_reportNotification_assignmentID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_callAborted_callReference = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_callOverloadEncountered_assignmentID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_callOverloadCeased_assignmentID = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_abortMultipleCalls_callReferenceSet_loop = -1;
static int hf_org_csapi_cc_mpccs_IpAppMultiPartyCallControlManager_abortMultipleCalls_callReferenceSet = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCall_superviseVolumeRes_callSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCall_superviseVolumeRes_report = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCall_superviseVolumeRes_qualityOfService = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCall_superviseVolumeErr_callSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallLeg_mediaStreamMonitorRes_callLegSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallLeg_mediaStreamMonitorRes_streams_loop = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallLeg_mediaStreamMonitorRes_type = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaStream_subtract_mediaStreamSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_mediaStreamAllow_callLegSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_mediaStreamAllow_mediaStreamList_loop = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_mediaStreamAllow_mediaStreamList = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_mediaStreamMonitorReq_callLegSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_mediaStreamMonitorReq_mediaStreamEventCriteria_loop = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_getMediaStreams_return_loop = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallLeg_getMediaStreams_callLegSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCall_superviseVolumeReq_callSessionID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCall_superviseVolumeReq_treatment = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallControlManager_reportMediaNotification_callLegReferenceSet_loop = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallControlManager_reportMediaNotification_mediaStreams_loop = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallControlManager_reportMediaNotification_type = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallControlManager_reportMediaNotification_qualityOfService = -1;
static int hf_org_csapi_cc_mmccs_IpAppMultiMediaCallControlManager_reportMediaNotification_assignmentID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallControlManager_createMediaNotification_return = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallControlManager_destroyMediaNotification_assignmentID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallControlManager_changeMediaNotification_assignmentID = -1;
static int hf_org_csapi_cc_mmccs_IpMultiMediaCallControlManager_getMediaNotification_return_loop = -1;
static int hf_org_csapi_cc_cccs_IpAppSubConfCall_chairSelection_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppSubConfCall_chairSelection_callLegSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppSubConfCall_floorRequest_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppSubConfCall_floorRequest_callLegSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppConfCall_partyJoined_conferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppConfCall_leaveMonitorRes_conferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpAppConfCall_leaveMonitorRes_callLeg = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_createConference_numberOfSubConferences = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_createConference_numberOfParticipants = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_createConference_duration = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_reserveResources_startTime = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_reserveResources_numberOfParticipants = -1;
static int hf_org_csapi_cc_cccs_IpConfCallControlManager_reserveResources_duration = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_splitSubConference_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_splitSubConference_callLegList_loop = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_splitSubConference_callLegList = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_mergeSubConference_subConferenceCallSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_mergeSubConference_targetSubConferenceCall = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_moveCallLeg_subConferenceCallSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_moveCallLeg_targetSubConferenceCall = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_moveCallLeg_callLeg = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_inspectVideo_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_inspectVideo_inspectedCallLeg = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_inspectVideoCancel_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_appointSpeaker_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_appointSpeaker_speakerCallLeg = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_chairSelection_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_chairSelection_chairCallLeg = -1;
static int hf_org_csapi_cc_cccs_IpSubConfCall_changeConferencePolicy_subConferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpConfCall_getSubConferences_return_loop = -1;
static int hf_org_csapi_cc_cccs_IpConfCall_getSubConferences_conferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpConfCall_createSubConference_conferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpConfCall_leaveMonitorReq_conferenceSessionID = -1;
static int hf_org_csapi_cc_cccs_IpConfCall_getConferenceAddress_conferenceSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoRes_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoRes_response = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoErr_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoErr_error = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectRes_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectRes_response = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectRes_collectedInfo = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectErr_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUI_sendInfoAndCollectErr_error = -1;
static int hf_org_csapi_ui_IpAppUI_userInteractionFaultDetected_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUI_userInteractionFaultDetected_fault = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageRes_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageRes_response = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageRes_messageID = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageErr_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_recordMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageRes_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageRes_response = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageErr_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUICall_deleteMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_abortActionRes_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_abortActionRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_abortActionErr_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_abortActionErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_abortActionErr_error = -1;
static int hf_org_csapi_ui_IpAppUICall_getMessageRes_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_getMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_getMessageErr_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUICall_getMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUICall_getMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUIManager_reportEventNotification_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIManager_abortMultipleUserInteractions_userInteractionSet_loop = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_return = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_language = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_variableInfo_loop = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_repeatIndicator = -1;
static int hf_org_csapi_ui_IpUI_sendInfoReq_responseRequested = -1;
static int hf_org_csapi_ui_IpUI_sendInfoAndCollectReq_return = -1;
static int hf_org_csapi_ui_IpUI_sendInfoAndCollectReq_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUI_sendInfoAndCollectReq_language = -1;
static int hf_org_csapi_ui_IpUI_sendInfoAndCollectReq_variableInfo_loop = -1;
static int hf_org_csapi_ui_IpUI_sendInfoAndCollectReq_responseRequested = -1;
static int hf_org_csapi_ui_IpUI_release_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUI_setOriginatingAddress_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUI_setOriginatingAddress_origin = -1;
static int hf_org_csapi_ui_IpUI_getOriginatingAddress_return = -1;
static int hf_org_csapi_ui_IpUI_getOriginatingAddress_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUICall_recordMessageReq_return = -1;
static int hf_org_csapi_ui_IpUICall_recordMessageReq_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUICall_deleteMessageReq_return = -1;
static int hf_org_csapi_ui_IpUICall_deleteMessageReq_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUICall_deleteMessageReq_messageID = -1;
static int hf_org_csapi_ui_IpUICall_abortActionReq_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUICall_abortActionReq_assignmentID = -1;
static int hf_org_csapi_ui_IpUICall_getMessageReq_return = -1;
static int hf_org_csapi_ui_IpUICall_getMessageReq_userInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUICall_getMessageReq_messageID = -1;
static int hf_org_csapi_ui_IpUIManager_createNotification_return = -1;
static int hf_org_csapi_ui_IpUIManager_destroyNotification_assignmentID = -1;
static int hf_org_csapi_ui_IpUIManager_changeNotification_assignmentID = -1;
static int hf_org_csapi_ui_IpUIManager_getNotification_return_loop = -1;
static int hf_org_csapi_ui_IpUIManager_enableNotifications_return = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageRes_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageErr_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageRes_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageRes_response = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageErr_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_deleteMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageRes_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageRes_messageID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageErr_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_putMessageErr_error = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListRes_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListRes_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListRes_messageIDList_loop = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListRes_messageIDList = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListRes_final = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListErr_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListErr_assignmentID = -1;
static int hf_org_csapi_ui_IpAppUIAdminManager_getMessageListErr_error = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageReq_return = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageReq_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageReq_messageID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_putMessageReq_return = -1;
static int hf_org_csapi_ui_IpUIAdminManager_putMessageReq_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_deleteMessageReq_return = -1;
static int hf_org_csapi_ui_IpUIAdminManager_deleteMessageReq_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_deleteMessageReq_messageID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageListReq_return = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageListReq_usrInteractionSessionID = -1;
static int hf_org_csapi_ui_IpUIAdminManager_getMessageListReq_reset = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_locationReportRes_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_locationReportRes_locations_loop = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_locationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_locationReportErr_cause = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_locationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_extendedLocationReportRes_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_extendedLocationReportRes_locations_loop = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_extendedLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_extendedLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_extendedLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_periodicLocationReport_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_periodicLocationReport_locations_loop = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_periodicLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_periodicLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ul_IpAppUserLocation_periodicLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_locationReportReq_return = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_locationReportReq_users_loop = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_extendedLocationReportReq_return = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_extendedLocationReportReq_users_loop = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_periodicLocationReportingStartReq_return = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_periodicLocationReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_periodicLocationReportingStartReq_reportingInterval = -1;
static int hf_org_csapi_mm_ul_IpUserLocation_getNextPeriodicLocationRequest_reset = -1;
static int hf_org_csapi_mm_ul_IpAppTriggeredUserLocation_triggeredLocationReport_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppTriggeredUserLocation_triggeredLocationReport_criterion = -1;
static int hf_org_csapi_mm_ul_IpAppTriggeredUserLocation_triggeredLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ul_IpAppTriggeredUserLocation_triggeredLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ul_IpAppTriggeredUserLocation_triggeredLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ul_IpTriggeredUserLocation_triggeredLocationReportingStartReq_return = -1;
static int hf_org_csapi_mm_ul_IpTriggeredUserLocation_triggeredLocationReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_ul_IpTriggeredUserLocation_triggeredLocationReportingStartReq_triggers_loop = -1;
static int hf_org_csapi_mm_ul_IpTriggeredUserLocation_getNextTriggeredLocationRequest_reset = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_locationReportRes_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_locationReportRes_locations_loop = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_locationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_locationReportErr_cause = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_locationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_periodicLocationReport_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_periodicLocationReport_locations_loop = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_periodicLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_periodicLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_periodicLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_triggeredLocationReport_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_triggeredLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_triggeredLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ulc_IpAppUserLocationCamel_triggeredLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_locationReportReq_return = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_locationReportReq_users_loop = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_periodicLocationReportingStartReq_return = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_periodicLocationReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_periodicLocationReportingStartReq_reportingInterval = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_triggeredLocationReportingStartReq_return = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_triggeredLocationReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_getNextPeriodicLocationRequest_reset = -1;
static int hf_org_csapi_mm_ulc_IpUserLocationCamel_getNextTriggeredLocationRequest_reset = -1;
static int hf_org_csapi_mm_ule_IpAppUserLocationEmergency_emergencyLocationReport_assignmentId = -1;
static int hf_org_csapi_mm_ule_IpAppUserLocationEmergency_emergencyLocationReportErr_assignmentId = -1;
static int hf_org_csapi_mm_ule_IpAppUserLocationEmergency_emergencyLocationReportErr_cause = -1;
static int hf_org_csapi_mm_ule_IpAppUserLocationEmergency_emergencyLocationReportErr_diagnostic = -1;
static int hf_org_csapi_mm_ule_IpUserLocationEmergency_emergencyLocationReportReq_return = -1;
static int hf_org_csapi_mm_ule_IpUserLocationEmergency_subscribeEmergencyLocationReports_return = -1;
static int hf_org_csapi_mm_ule_IpUserLocationEmergency_unSubscribeEmergencyLocationReports_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_statusReportRes_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_statusReportRes_status_loop = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_statusReportErr_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_statusReportErr_cause = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_statusReportErr_diagnostic = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_triggeredStatusReport_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_triggeredStatusReportErr_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_triggeredStatusReportErr_cause = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_triggeredStatusReportErr_diagnostic = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extendedStatusReportRes_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extendedStatusReportRes_status_loop = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extendedStatusReportErr_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extendedStatusReportErr_cause = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extendedStatusReportErr_diagnostic = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extTriggeredStatusReport_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extTriggeredStatusReportErr_assignmentId = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extTriggeredStatusReportErr_cause = -1;
static int hf_org_csapi_mm_us_IpAppUserStatus_extTriggeredStatusReportErr_diagnostic = -1;
static int hf_org_csapi_mm_us_IpUserStatus_statusReportReq_return = -1;
static int hf_org_csapi_mm_us_IpUserStatus_statusReportReq_users_loop = -1;
static int hf_org_csapi_mm_us_IpUserStatus_triggeredStatusReportingStartReq_return = -1;
static int hf_org_csapi_mm_us_IpUserStatus_triggeredStatusReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_us_IpUserStatus_getNextTriggeredStatusRequest_reset = -1;
static int hf_org_csapi_mm_us_IpUserStatus_extendedStatusReportReq_return = -1;
static int hf_org_csapi_mm_us_IpUserStatus_extendedStatusReportReq_users_loop = -1;
static int hf_org_csapi_mm_us_IpUserStatus_extTriggeredStatusReportingStartReq_return = -1;
static int hf_org_csapi_mm_us_IpUserStatus_extTriggeredStatusReportingStartReq_users_loop = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotification_return_loop = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotification_assignmentId = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotification_contactInformation_loop = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotificationStartErr_assignmentId = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotificationStartErr_cause = -1;
static int hf_org_csapi_mm_ub_IpAppUserBinding_triggeredBindingRequestNotificationStartErr_diagnostic = -1;
static int hf_org_csapi_mm_ub_IpUserBinding_triggeredBindingRequestNotificationStartReq_return = -1;
static int hf_org_csapi_mm_ub_IpUserBinding_triggeredBindingRequestNotificationStartReq_users_loop = -1;
static int hf_org_csapi_mm_ub_IpUserBinding_triggeredBindingRequestNotificationStartReq_criteria_loop = -1;
static int hf_org_csapi_mm_ub_IpUserBinding_triggeredBindingRequestNotificationStop_assignmentId = -1;
static int hf_org_csapi_termcap_IpTerminalCapabilities_getTerminalCapabilities_terminalIdentity = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReport_assignmentID = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReport_terminals_loop = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReport_criteria = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReportErr_assignmentId = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReportErr_terminals_loop = -1;
static int hf_org_csapi_termcap_IpAppExtendedTerminalCapabilities_triggeredTerminalCapabilityReportErr_cause = -1;
static int hf_org_csapi_termcap_IpExtendedTerminalCapabilities_triggeredTerminalCapabilityStartReq_return = -1;
static int hf_org_csapi_termcap_IpExtendedTerminalCapabilities_triggeredTerminalCapabilityStartReq_terminals_loop = -1;
static int hf_org_csapi_termcap_IpExtendedTerminalCapabilities_triggeredTerminalCapabilityStartReq_criteria = -1;
static int hf_org_csapi_termcap_IpExtendedTerminalCapabilities_triggeredTerminalCapabilityStop_assignmentID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_connectRes_dataSessionID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_connectRes_assignmentID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_connectErr_dataSessionID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_connectErr_assignmentID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_superviseDataSessionRes_dataSessionID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_superviseDataSessionRes_report = -1;
static int hf_org_csapi_dsc_IpAppDataSession_superviseDataSessionRes_qualityOfService = -1;
static int hf_org_csapi_dsc_IpAppDataSession_superviseDataSessionErr_dataSessionID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_dataSessionFaultDetected_dataSessionID = -1;
static int hf_org_csapi_dsc_IpAppDataSession_dataSessionFaultDetected_fault = -1;
static int hf_org_csapi_dsc_IpAppDataSessionControlManager_dataSessionAborted_dataSession = -1;
static int hf_org_csapi_dsc_IpAppDataSessionControlManager_reportNotification_assignmentID = -1;
static int hf_org_csapi_dsc_IpAppDataSessionControlManager_abortMultipleDataSessions_dataSessionSet_loop = -1;
static int hf_org_csapi_dsc_IpAppDataSessionControlManager_abortMultipleDataSessions_dataSessionSet = -1;
static int hf_org_csapi_dsc_IpDataSession_connectReq_return = -1;
static int hf_org_csapi_dsc_IpDataSession_connectReq_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_connectReq_responseRequested_loop = -1;
static int hf_org_csapi_dsc_IpDataSession_release_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_superviseDataSessionReq_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_superviseDataSessionReq_treatment = -1;
static int hf_org_csapi_dsc_IpDataSession_setDataSessionChargePlan_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_setAdviceOfCharge_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_setAdviceOfCharge_tariffSwitch = -1;
static int hf_org_csapi_dsc_IpDataSession_deassignDataSession_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSession_continueProcessing_dataSessionID = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_createNotification_return = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_destroyNotification_assignmentID = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_changeNotification_assignmentID = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_enableNotifications_return = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_getNotifications_return_loop = -1;
static int hf_org_csapi_dsc_IpDataSessionControlManager_createNotifications_return = -1;
static int hf_org_csapi_gms_IpMessagingManager_openMailbox_authenticationInfo = -1;
static int hf_org_csapi_gms_IpMessagingManager_enableMessagingNotification_return = -1;
static int hf_org_csapi_gms_IpMessagingManager_disableMessagingNotification_assignmentID = -1;
static int hf_org_csapi_gms_IpAppMessagingManager_mailboxTerminated_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpAppMessagingManager_mailboxFaultDetected_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpAppMessagingManager_mailboxFaultDetected_fault = -1;
static int hf_org_csapi_gms_IpAppMessagingManager_messagingEventNotify_assignmentID = -1;
static int hf_org_csapi_gms_IpMailbox_close_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_lock_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_unlock_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoAmount_return = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoAmount_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoProperties_return_loop = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoProperties_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMailbox_getInfoProperties_numberOfProperties = -1;
static int hf_org_csapi_gms_IpMailbox_setInfoProperties_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_setInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMailbox_setInfoProperties_mailboxInfoProperties_loop = -1;
static int hf_org_csapi_gms_IpMailbox_openFolder_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_openFolder_folderID = -1;
static int hf_org_csapi_gms_IpMailbox_createFolder_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailbox_createFolder_folderID = -1;
static int hf_org_csapi_gms_IpMailbox_remove_authenticationInfo = -1;
static int hf_org_csapi_gms_IpMessage_getInfoAmount_return = -1;
static int hf_org_csapi_gms_IpMessage_getInfoAmount_folderSessionID = -1;
static int hf_org_csapi_gms_IpMessage_getInfoAmount_messageID = -1;
static int hf_org_csapi_gms_IpMessage_getInfoProperties_return_loop = -1;
static int hf_org_csapi_gms_IpMessage_getInfoProperties_folderSessionID = -1;
static int hf_org_csapi_gms_IpMessage_getInfoProperties_messageID = -1;
static int hf_org_csapi_gms_IpMessage_getInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMessage_getInfoProperties_numberOfProperties = -1;
static int hf_org_csapi_gms_IpMessage_setInfoProperties_folderSessionID = -1;
static int hf_org_csapi_gms_IpMessage_setInfoProperties_messageID = -1;
static int hf_org_csapi_gms_IpMessage_setInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMessage_setInfoProperties_messageInfoProperties_loop = -1;
static int hf_org_csapi_gms_IpMessage_remove_folderSessionID = -1;
static int hf_org_csapi_gms_IpMessage_remove_messageID = -1;
static int hf_org_csapi_gms_IpMessage_getContent_return = -1;
static int hf_org_csapi_gms_IpMessage_getContent_folderSessionID = -1;
static int hf_org_csapi_gms_IpMessage_getContent_messageID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoAmount_return = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoAmount_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoProperties_return_loop = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoProperties_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getInfoProperties_numberOfProperties = -1;
static int hf_org_csapi_gms_IpMailboxFolder_setInfoProperties_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_setInfoProperties_firstProperty = -1;
static int hf_org_csapi_gms_IpMailboxFolder_setInfoProperties_folderInfoProperties_loop = -1;
static int hf_org_csapi_gms_IpMailboxFolder_putMessage_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_putMessage_message = -1;
static int hf_org_csapi_gms_IpMailboxFolder_putMessage_messageInfoProperties_loop = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getMessage_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_getMessage_messageID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_close_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_close_folderSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_remove_mailboxSessionID = -1;
static int hf_org_csapi_gms_IpMailboxFolder_remove_folderID = -1;
static int hf_org_csapi_cm_IpVPrP_getVPrPID_return = -1;
static int hf_org_csapi_cm_IpVPrP_getSlaID_return = -1;
static int hf_org_csapi_cm_IpVPrP_getStatus_return = -1;
static int hf_org_csapi_cm_IpVPrN_getVPrPList_return_loop = -1;
static int hf_org_csapi_cm_IpVPrN_getVPrPList_return = -1;
static int hf_org_csapi_cm_IpVPrN_getVPrP_vPrPID = -1;
static int hf_org_csapi_cm_IpVPrN_deleteVPrP_vPrPID = -1;
static int hf_org_csapi_cm_IpQoSMenu_getTemplate_templateType = -1;
static int hf_org_csapi_cm_IpQoSMenu_getTemplateList_return_loop = -1;
static int hf_org_csapi_cm_IpQoSMenu_getTemplateList_return = -1;
static int hf_org_csapi_cm_IpQoSTemplate_getTemplateType_return = -1;
static int hf_org_csapi_cm_IpQoSTemplate_getDescription_return = -1;
static int hf_org_csapi_cm_IpQoSTemplate_setSlaID_slaID = -1;
static int hf_org_csapi_cm_IpEnterpriseNetwork_getSiteList_return_loop = -1;
static int hf_org_csapi_cm_IpEnterpriseNetwork_getSiteList_return = -1;
static int hf_org_csapi_cm_IpEnterpriseNetwork_getSite_siteID = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSAPList_return_loop = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSAPList_return = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSiteID_return = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSiteLocation_return = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSiteDescription_return = -1;
static int hf_org_csapi_cm_IpEnterpriseNetworkSite_getSAPIPSubnet_sapID = -1;
static int hf_org_csapi_am_IpAppAccountManager_reportNotification_assignmentId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceRes_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceRes_balances_loop = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceErr_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_retrieveTransactionHistoryRes_retrievalID = -1;
static int hf_org_csapi_am_IpAppAccountManager_retrieveTransactionHistoryRes_transactionHistory_loop = -1;
static int hf_org_csapi_am_IpAppAccountManager_retrieveTransactionHistoryErr_retrievalID = -1;
static int hf_org_csapi_am_IpAppAccountManager_retrieveTransactionHistoryErr_transactionHistoryError = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceExpiryDateRes_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceExpiryDateRes_dates_loop = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceExpiryDateErr_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryBalanceExpiryDateErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_updateBalanceRes_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_updateBalanceErr_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_updateBalanceErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_createVoucherRes_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_createVoucherRes_voucherId = -1;
static int hf_org_csapi_am_IpAppAccountManager_createVoucherErr_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_createVoucherErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_destroyVoucherRes_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_destroyVoucherRes_voucherId = -1;
static int hf_org_csapi_am_IpAppAccountManager_destroyVoucherErr_requestId = -1;
static int hf_org_csapi_am_IpAppAccountManager_destroyVoucherErr_voucherId = -1;
static int hf_org_csapi_am_IpAppAccountManager_destroyVoucherErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryVoucherRes_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryVoucherErr_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryVoucherErr_voucherId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryVoucherErr_cause = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryUserVouchersRes_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryUserVouchersRes_vouchers_loop = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryUserVouchersErr_queryId = -1;
static int hf_org_csapi_am_IpAppAccountManager_queryUserVouchersErr_cause = -1;
static int hf_org_csapi_am_IpAccountManager_createNotification_return = -1;
static int hf_org_csapi_am_IpAccountManager_destroyNotification_assignmentId = -1;
static int hf_org_csapi_am_IpAccountManager_queryBalanceReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_queryBalanceReq_users_loop = -1;
static int hf_org_csapi_am_IpAccountManager_changeNotification_assignmentID = -1;
static int hf_org_csapi_am_IpAccountManager_getNotification_return_loop = -1;
static int hf_org_csapi_am_IpAccountManager_retrieveTransactionHistoryReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_enableNotifications_return = -1;
static int hf_org_csapi_am_IpAccountManager_queryBalanceExpiryDateReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_queryBalanceExpiryDateReq_users_loop = -1;
static int hf_org_csapi_am_IpAccountManager_updateBalanceReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_updateBalanceReq_debit = -1;
static int hf_org_csapi_am_IpAccountManager_updateBalanceReq_period = -1;
static int hf_org_csapi_am_IpAccountManager_createVoucherReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_destroyVoucherReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_destroyVoucherReq_voucherId = -1;
static int hf_org_csapi_am_IpAccountManager_queryVoucherReq_return = -1;
static int hf_org_csapi_am_IpAccountManager_queryVoucherReq_voucherId = -1;
static int hf_org_csapi_am_IpAccountManager_queryUserVouchersReq_return = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditAmountRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitRes_creditedVolumes_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitRes_reservedUnitsLeft_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_creditUnitRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitAmountRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitRes_debitedVolumes_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitRes_reservedUnitsLeft_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_debitUnitRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditAmountRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitRes_creditedVolumes_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directCreditUnitRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitAmountRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitRes_debitedVolumes_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_directDebitUnitRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_extendLifeTimeErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_extendLifeTimeErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_extendLifeTimeRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_extendLifeTimeRes_sessionTimeLeft = -1;
static int hf_org_csapi_cs_IpAppChargingSession_rateErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_rateErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_rateRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_rateRes_rates_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_rateRes_validityTimeLeft = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountRes_sessionTimeLeft = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveAmountRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitErr_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitErr_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitErr_error = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitErr_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitRes_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitRes_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitRes_reservedUnits_loop = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitRes_sessionTimeLeft = -1;
static int hf_org_csapi_cs_IpAppChargingSession_reserveUnitRes_requestNumberNextRequest = -1;
static int hf_org_csapi_cs_IpAppChargingSession_sessionEnded_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingSession_sessionEnded_report = -1;
static int hf_org_csapi_cs_IpChargingSession_creditAmountReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_creditAmountReq_closeReservation = -1;
static int hf_org_csapi_cs_IpChargingSession_creditAmountReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_creditUnitReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_creditUnitReq_volumes_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_creditUnitReq_closeReservation = -1;
static int hf_org_csapi_cs_IpChargingSession_creditUnitReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_debitAmountReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_debitAmountReq_closeReservation = -1;
static int hf_org_csapi_cs_IpChargingSession_debitAmountReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_debitUnitReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_debitUnitReq_volumes_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_debitUnitReq_closeReservation = -1;
static int hf_org_csapi_cs_IpChargingSession_debitUnitReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditAmountReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditAmountReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditAmountReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditUnitReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditUnitReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditUnitReq_volumes_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directCreditUnitReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitAmountReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitAmountReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitAmountReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitUnitReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitUnitReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitUnitReq_volumes_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_directDebitUnitReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_extendLifeTimeReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_getAmountLeft_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_getLifeTimeLeft_return = -1;
static int hf_org_csapi_cs_IpChargingSession_getLifeTimeLeft_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_getUnitLeft_return_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_getUnitLeft_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_rateReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_rateReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_release_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_release_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveAmountReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveAmountReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveAmountReq_requestNumber = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveUnitReq_sessionID = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveUnitReq_chargingParameters_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveUnitReq_volumes_loop = -1;
static int hf_org_csapi_cs_IpChargingSession_reserveUnitReq_requestNumber = -1;
static int hf_org_csapi_cs_IpAppChargingManager_sessionAborted_sessionID = -1;
static int hf_org_csapi_cs_IpAppChargingManager_abortMultipleChargingSessions_chargingSessionSet_loop = -1;
static int hf_org_csapi_cs_IpAppChargingManager_abortMultipleChargingSessions_chargingSessionSet = -1;
static int hf_org_csapi_cs_IpChargingManager_createChargingSession_sessionDescription = -1;
static int hf_org_csapi_cs_IpChargingManager_createSplitChargingSession_sessionDescription = -1;
static int hf_org_csapi_cs_IpChargingManager_createSplitChargingSession_users_loop = -1;
static int hf_org_csapi_policy_evaluation_IpAppPolicyDomain_reportNotification_assignmentID = -1;
static int hf_org_csapi_policy_evaluation_IpAppPolicyDomain_evalPolicyRes_assignmentID = -1;
static int hf_org_csapi_policy_evaluation_IpAppPolicyDomain_evalPolicyRes_outputVariables_loop = -1;
static int hf_org_csapi_policy_evaluation_IpAppPolicyDomain_evalPolicyErr_assignmentID = -1;
static int hf_org_csapi_policy_evaluation_IpAppPolicyDomain_evalPolicyErr_error = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicy_return_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicy_domainName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicy_signatureName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicy_inputVariables_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicyReq_return = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicyReq_domainName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicyReq_signatureName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_evalPolicyReq_inputVariables_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_abortEvalPolicyReq_domainName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_abortEvalPolicyReq_assignmentID = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_generateEvent_domainName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_generateEvent_eventDefinitionName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_generateEvent_attributes_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_createNotification_return = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_createNotification_domainName = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_createNotification_events_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_createNotification_events = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_destroyNotification_assignmentID = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_destroyNotification_events_loop = -1;
static int hf_org_csapi_policy_evaluation_IpPolicyEvalManager_destroyNotification_events = -1;
static int hf_org_csapi_policy_provisioning_IpPolicy_getAttribute_attributeName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicy_getAttributes_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicy_getAttributes_attributeNames_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicy_getAttributes_attributeNames = -1;
static int hf_org_csapi_policy_provisioning_IpPolicy_setAttributes_targetAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyIterator_getList_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyIterator_getList_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyIterator_getList_startIndex = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyIterator_getList_numberRequested = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_removeRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getRepositoryCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createCondition_conditionType = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createCondition_conditionAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_removeCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getConditionCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createAction_actionType = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_createAction_actionAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_removeAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRepository_getActionCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createCondition_conditionType = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createCondition_conditionAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_removeCondition_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getConditionCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createAction_actionType = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_createAction_actionAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_removeAction_actionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getActionCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_setValidityPeriodConditionByName_conditionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_setConditionList_conditionList_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getConditionList_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_setActionList_actionList_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyRule_getActionList_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_createDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_getDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_removeDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_getDomainCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_findMatchingDomains_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_findMatchingDomains_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_findMatchingDomains_matchingAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_createRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_getRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_removeRepository_repositoryName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_getRepositoryCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyManager_commitTransaction_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_createGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_getGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_removeGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_getGroupCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_createRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_getRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_removeRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyGroup_getRuleCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyEventDefinition_setRequiredAttributes_requiredAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyEventDefinition_setOptionalAttributes_optionalAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyEventDefinition_getRequiredAttributes_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyEventDefinition_getOptionalAttributes_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setInputVariables_inputVariables_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setInputVariables_inputVariables = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setOutputVariables_outputVariables_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setOutputVariables_outputVariables = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getInputVariables_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getInputVariables_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getOutputVariables_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getOutputVariables_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setGroupNames_groupNames_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setGroupNames_groupNames = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setPolicyRoles_roleNames_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_setPolicyRoles_roleNames = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getGroupNames_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getGroupNames_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getPolicyRoles_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicySignature_getPolicyRoles_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeDomain_domainName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getDomainCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeGroup_groupName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getGroupCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeRule_ruleName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getRuleCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createEventDefinition_eventDefinitionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createEventDefinition_requiredAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createEventDefinition_requiredAttributes = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createEventDefinition_optionalAttributes_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createEventDefinition_optionalAttributes = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getEventDefinition_eventDefinitionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeEventDefinition_eventDefinitionName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getEventDefinitionCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createVariableSet_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableSet_return_loop = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableSet_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeVariableSet_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableSetCount_return = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createVariable_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createVariable_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_setVariableValue_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_setVariableValue_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableType_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableType_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableValue_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariableValue_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariable_variableSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getVariable_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeVariable_variablSetName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeVariable_variableName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_createSignature_signatureName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getSignature_signatureName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_removeSignature_signatureName = -1;
static int hf_org_csapi_policy_provisioning_IpPolicyDomain_getSignatureCount_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createIdentity_identityTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createIdentity_identityTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isIdentity_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createGroupIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createGroupIdentity_identityTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createGroupIdentity_identityTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createGroupIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_createGroupIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteGroupIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteGroupIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_deleteGroupIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addToGroup_group = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addToGroup_member = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addToGroup_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addToGroup_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeFromGroup_group = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeFromGroup_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeFromGroup_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeFromGroup_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listMembers_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listMembers_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listMembers_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listMembers_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listMembers_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isGroupIdentity_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isGroupIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isGroupIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_isGroupIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listGroupMembership_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listGroupMembership_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listGroupMembership_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listGroupMembership_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listGroupMembership_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addAlias_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addAlias_alias = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addAlias_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_addAlias_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeAliases_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeAliases_alias = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeAliases_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_removeAliases_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listAliases_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listAliases_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listAliases_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listAliases_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listAliases_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_lookupByAlias_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_lookupByAlias_alias = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_lookupByAlias_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_lookupByAlias_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_associateTypes_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_associateTypes_identityTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_associateTypes_identityTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_associateTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_associateTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_disassociateTypes_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_disassociateTypes_identityTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_disassociateTypes_identityTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_disassociateTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_disassociateTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listTypesOfIdentity_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listTypesOfIdentity_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listTypesOfIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listTypesOfIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_listTypesOfIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_hasType_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_hasType_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_hasType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_hasType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_hasType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_identityType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_getIdentityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_setIdentityAttributes_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_setIdentityAttributes_identityType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_setIdentityAttributes_attributes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_setIdentityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityManagement_setIdentityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_createAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_createAgent_agentTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_createAgent_agentTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_createAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_createAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_deleteAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_deleteAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_deleteAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isAgent_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_enableCapabilities_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_enableCapabilities_capabilities_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_enableCapabilities_capabilities = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_enableCapabilities_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_enableCapabilities_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disableCapabilities_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disableCapabilities_capabilities_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disableCapabilities_capabilities = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disableCapabilities_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disableCapabilities_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listEnabledCapabilities_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listEnabledCapabilities_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listEnabledCapabilities_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listEnabledCapabilities_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listEnabledCapabilities_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listAllCapabilities_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listAllCapabilities_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listAllCapabilities_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listAllCapabilities_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listAllCapabilities_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isCapableOf_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isCapableOf_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isCapableOf_capability = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isCapableOf_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_isCapableOf_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_associateTypes_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_associateTypes_agentTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_associateTypes_agentTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_associateTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_associateTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disassociateTypes_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disassociateTypes_agentTypes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disassociateTypes_agentTypes = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disassociateTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_disassociateTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listTypesOfAgent_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listTypesOfAgent_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listTypesOfAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listTypesOfAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_listTypesOfAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_hasType_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_hasType_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_hasType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_hasType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_hasType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_agentType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_getAgentAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_setAgentAttributes_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_setAgentAttributes_agentType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_setAgentAttributes_attributes_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_setAgentAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentManagement_setAgentAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_assignAgent_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_assignAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_assignAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_assignAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_unassignAgent_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_unassignAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_unassignAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_unassignAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgents_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgents_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgents_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgents_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgents_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssociatedIdentitiesOfAgent_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssociatedIdentitiesOfAgent_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssociatedIdentitiesOfAgent_agentName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssociatedIdentitiesOfAgent_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssociatedIdentitiesOfAgent_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_capability = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listAssignedAgentsByCapability_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listCapabilitiesOfIdentity_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listCapabilitiesOfIdentity_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listCapabilitiesOfIdentity_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listCapabilitiesOfIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_listCapabilitiesOfIdentity_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_isIdentityCapableOf_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_isIdentityCapableOf_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_isIdentityCapableOf_capability = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_isIdentityCapableOf_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentAssignment_isIdentityCapableOf_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityAttribute_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_getIdentityAttributeDefinition_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_getIdentityAttributeDefinition_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_getIdentityAttributeDefinition_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listAllIdentityAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listAllIdentityAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listAllIdentityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listAllIdentityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityType_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityType_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_createIdentityType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_deleteIdentityType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_addIdentityTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_addIdentityTypeAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_addIdentityTypeAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_addIdentityTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_addIdentityTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_removeIdentityTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_removeIdentityTypeAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_removeIdentityTypeAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_removeIdentityTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_removeIdentityTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypeAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypeAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMIdentityTypeManagement_listIdentityTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentAttribute_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_getAgentAttributeDefinition_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_getAgentAttributeDefinition_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_getAgentAttributeDefinition_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAllAgentAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAllAgentAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAllAgentAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAllAgentAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentType_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentType_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_createAgentType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentType_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_deleteAgentType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_addAgentTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_addAgentTypeAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_addAgentTypeAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_addAgentTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_addAgentTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_removeAgentTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_removeAgentTypeAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_removeAgentTypeAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_removeAgentTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_removeAgentTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypeAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypeAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypeAttributes_typeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypeAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMAgentTypeManagement_listAgentTypeAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapabilityAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapabilityAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapabilityAttribute_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapabilityAttribute_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapabilityAttribute_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_getCapabilityAttributeDefinition_attributeName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_getCapabilityAttributeDefinition_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_getCapabilityAttributeDefinition_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listAllCapabilityAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listAllCapabilityAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listAllCapabilityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listAllCapabilityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapability_capabilityName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapability_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapability_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapability_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_createCapability_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapability_capabilityName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapability_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_deleteCapability_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilities_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilities_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilities_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilities_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_addCapabilityAttributes_capabilityName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_addCapabilityAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_addCapabilityAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_addCapabilityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_addCapabilityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_removeCapabilityAttributes_capabilityName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_removeCapabilityAttributes_attributeNames_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_removeCapabilityAttributes_attributeNames = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_removeCapabilityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_removeCapabilityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilityAttributes_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilityAttributes_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilityAttributes_capabilityName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilityAttributes_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilityAttributes_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_assignCapabilitiesToType_agentType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_assignCapabilitiesToType_capabilities_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_assignCapabilitiesToType_capabilities = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_assignCapabilitiesToType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_assignCapabilitiesToType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_unassignCapabilitiesFromType_agentType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_unassignCapabilitiesFromType_capabilities_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_unassignCapabilitiesFromType_capabilities = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_unassignCapabilitiesFromType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_unassignCapabilitiesFromType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilitiesOfType_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilitiesOfType_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilitiesOfType_agentType = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilitiesOfType_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMCapabilityManagement_listCapabilitiesOfType_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAuthToken_return_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAuthToken_return = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAuthToken_askerData_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_obtainInterface_interfaceName = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAccessControl_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_getAccessControl_authToken = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_setAccessControl_identity = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_setAccessControl_operation = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_setAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_provisioning_IpPAMProvisioningManager_setAccessControl_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresence_identity = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresence_identityType = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresence_attributes_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_identity = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_identityType = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_expiresIn = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_setIdentityPresenceExpiration_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_return_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_identity = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_identityType = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMIdentityPresence_getIdentityPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresence_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresence_agentType = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresence_attributes_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresence_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresence_capability = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresence_attributes_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_agentType = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_expiresIn = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setAgentPresenceExpiration_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_capability = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_expiresIn = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_setCapabilityPresenceExpiration_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_return_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_agentType = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getAgentPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_return_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_agent = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_capability = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAgentPresence_getCapabilityPresence_authToken = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_return_loop = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_identity = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_attributeNames = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpAppPAMPreferenceCheck_computeAvailability_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_return_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_identity = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_attributeNames_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_attributeNames = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getAvailability_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getPreference_identity = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getPreference_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_getPreference_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_setPreference_identity = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_setPreference_operation = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_setPreference_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMAvailability_setPreference_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAuthToken_return_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAuthToken_return = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAuthToken_askerData_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_obtainInterface_interfaceName = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAccessControl_identity = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_getAccessControl_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_setAccessControl_identity = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_setAccessControl_operation = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_setAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_setAccessControl_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_activateService_identity = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_activateService_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_activateService_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_deactivateService_identity = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_deactivateService_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_deactivateService_authToken = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_isActiveIdentity_return = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_isActiveIdentity_identity = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_isActiveIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_access_IpPAMPresenceAvailabilityManager_isActiveIdentity_authToken = -1;
static int hf_org_csapi_pam_event_IpAppPAMEventHandler_eventNotify_eventID = -1;
static int hf_org_csapi_pam_event_IpAppPAMEventHandler_eventNotify_eventInfo_loop = -1;
static int hf_org_csapi_pam_event_IpAppPAMEventHandler_eventNotifyErr_eventID = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_isRegistered_return = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_isRegistered_clientID = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_isRegistered_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_isRegistered_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerAppInterface_return = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerAppInterface_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerAppInterface_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_return = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_clientID = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_eventList_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_validFor = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_registerForEvent_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterAppInterface_clientID = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterAppInterface_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterAppInterface_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterFromEvent_eventID = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterFromEvent_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventHandler_deregisterFromEvent_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAuthToken_return_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAuthToken_return = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAuthToken_askerData_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_obtainInterface_interfaceName = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAccessControl_identity = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_getAccessControl_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_setAccessControl_identity = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_setAccessControl_operation = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_setAccessControl_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_setAccessControl_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_activateService_identity = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_activateService_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_activateService_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_deactivateService_identity = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_deactivateService_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_deactivateService_authToken = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_isActiveIdentity_return = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_isActiveIdentity_identity = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_isActiveIdentity_authToken_loop = -1;
static int hf_org_csapi_pam_event_IpPAMEventManager_isActiveIdentity_authToken = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessagingManager_reportNotification_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessagingManager_reportNotification_eventInfo_loop = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessagingManager_terminateMultipleMailboxes_mailboxSet_loop = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessagingManager_terminateMultipleMultiMediaMessagingSessions_multiMediaMessagingSet_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_openMailbox_mailboxID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_openMailbox_authenticationInfo = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_createNotification_return = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_createNotification_eventCriteria_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_destroyNotification_assignmentID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_changeNotification_assignmentID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_changeNotification_eventCriteria_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_getNextNotification_reset = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessagingManager_enableNotifications_return = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderRes_folderID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_createFolderErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersRes_folderID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersRes_folderNames_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersRes_folderNames = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersErr_folderID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFoldersErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteFolderErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyFolderErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveFolderErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageRes_messageID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_putMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_copyMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_moveMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_deleteMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesRes_messageList_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesRes_final = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessagesErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsRes_partsList_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_listMessageBodyPartsErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsRes_bodyParts_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageBodyPartsErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersRes_headers_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageHeadersErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_contentType = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_contentTransferEncoding = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_content_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentRes_content = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageContentErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageRes_message_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageRes_message = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFullMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesRes_returnedProperties_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesRes_folderID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesRes_returnedProperties_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesRes_messageID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesRes_returnedProperties_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesRes_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesRes_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesRes_messageID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesRes_propertiesUpdated_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesErr_messageID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_setMessageInfoPropertiesErr_propertiesNotUpdated_loop = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMailboxInfoPropertiesErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getFolderInfoPropertiesErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesErr_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesErr_requestID = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesErr_error = -1;
static int hf_org_csapi_mmm_IpAppMailbox_getMessageInfoPropertiesErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpMailbox_close_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_createFolderReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_createFolderReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_createFolderReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFoldersReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getFoldersReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFoldersReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteFolderReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteFolderReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteFolderReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyFolderReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_copyFolderReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyFolderReq_sourceFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyFolderReq_destinationFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveFolderReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_moveFolderReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveFolderReq_sourceFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveFolderReq_destinationFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_putMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_putMessageReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_putMessageReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_putMessageReq_message_loop = -1;
static int hf_org_csapi_mmm_IpMailbox_putMessageReq_message = -1;
static int hf_org_csapi_mmm_IpMailbox_copyMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_copyMessageReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyMessageReq_fromFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyMessageReq_toFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_copyMessageReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_moveMessageReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveMessageReq_fromFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveMessageReq_toFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_moveMessageReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteMessageReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteMessageReq_fromFolderID = -1;
static int hf_org_csapi_mmm_IpMailbox_deleteMessageReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessagesReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessagesReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessagesReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessagesReq_reset = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessageBodyPartsReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessageBodyPartsReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessageBodyPartsReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessageBodyPartsReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_listMessageBodyPartsReq_maxNestingLevel = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_partIDs_loop = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageBodyPartsReq_partIDs = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageHeadersReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageHeadersReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageHeadersReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageHeadersReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageContentReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageContentReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageContentReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageContentReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFullMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getFullMessageReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFullMessageReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFullMessageReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMailboxInfoPropertiesReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getMailboxInfoPropertiesReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFolderInfoPropertiesReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getFolderInfoPropertiesReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getFolderInfoPropertiesReq_folderID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageInfoPropertiesReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageInfoPropertiesReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_getMessageInfoPropertiesReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_setMessageInfoPropertiesReq_return = -1;
static int hf_org_csapi_mmm_IpMailbox_setMessageInfoPropertiesReq_mailboxSessionID = -1;
static int hf_org_csapi_mmm_IpMailbox_setMessageInfoPropertiesReq_messageID = -1;
static int hf_org_csapi_mmm_IpMailbox_setMessageInfoPropertiesReq_properties_loop = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageRes_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageRes_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageErr_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageErr_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_sendMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageRes_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageRes_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageErr_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageErr_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageErr_error = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_cancelMessageErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusRes_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusRes_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusRes_result_loop = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusErr_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusErr_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusErr_error = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_queryStatusErr_errorDetails = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageStatusReport_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageStatusReport_assignmentID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageStatusReport_deliveryReportType = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageStatusReport_deliveryReportInfo = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageReceived_sessionID = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageReceived_message_loop = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageReceived_message = -1;
static int hf_org_csapi_mmm_IpAppMultiMediaMessaging_messageReceived_headers_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_return = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_sessionID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_deliveryType = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_messageTreatment_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_message_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_message = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_sendMessageReq_additionalHeaders_loop = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_cancelMessageReq_sessionID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_cancelMessageReq_assignmentID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_queryStatusReq_sessionID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_queryStatusReq_assignmentID = -1;
static int hf_org_csapi_mmm_IpMultiMediaMessaging_close_sessionID = -1;
        /* Struct filters */
static int hf_org_csapi_TpAddress_Plan = -1;
static int hf_org_csapi_TpAddress_AddrString = -1;
static int hf_org_csapi_TpAddress_Name = -1;
static int hf_org_csapi_TpAddress_Presentation = -1;
static int hf_org_csapi_TpAddress_Screening = -1;
static int hf_org_csapi_TpAddress_SubAddressString = -1;
static int hf_org_csapi_TpAddressRange_Plan = -1;
static int hf_org_csapi_TpAddressRange_AddrString = -1;
static int hf_org_csapi_TpAddressRange_Name = -1;
static int hf_org_csapi_TpAddressRange_SubAddressString = -1;
static int hf_org_csapi_TpCAIElements_UnitsPerInterval = -1;
static int hf_org_csapi_TpCAIElements_SecondsPerTimeInterval = -1;
static int hf_org_csapi_TpCAIElements_ScalingFactor = -1;
static int hf_org_csapi_TpCAIElements_UnitIncrement = -1;
static int hf_org_csapi_TpCAIElements_UnitsPerDataInterval = -1;
static int hf_org_csapi_TpCAIElements_SegmentsPerDataInterval = -1;
static int hf_org_csapi_TpCAIElements_InitialSecsPerTimeInterval = -1;
static int hf_org_csapi_TpChargePerTime_InitialCharge = -1;
static int hf_org_csapi_TpChargePerTime_CurrentChargePerMinute = -1;
static int hf_org_csapi_TpChargePerTime_NextChargePerMinute = -1;
static int hf_org_csapi_TpAoCInfo_Currency = -1;
static int hf_org_csapi_TpTimeInterval_StartTime = -1;
static int hf_org_csapi_TpTimeInterval_StopTime = -1;
static int hf_org_csapi_TpStructuredAttributeValue_Type = -1;
static int hf_org_csapi_TpAttribute_AttributeName = -1;
static int hf_org_csapi_fw_TpFaultStats_Fault = -1;
static int hf_org_csapi_fw_TpFaultStats_Occurrences = -1;
static int hf_org_csapi_fw_TpFaultStats_MaxDuration = -1;
static int hf_org_csapi_fw_TpFaultStats_TotalDuration = -1;
static int hf_org_csapi_fw_TpFaultStats_NumberOfClientsAffected = -1;
static int hf_org_csapi_fw_TpFaultStatsRecord_FaultStatsSet_loop = -1;
static int hf_org_csapi_fw_TpLoadPolicy_LoadPolicy = -1;
static int hf_org_csapi_fw_TpLoadStatisticData_LoadValue = -1;
static int hf_org_csapi_fw_TpLoadStatisticData_LoadLevel = -1;
static int hf_org_csapi_fw_TpLoadThreshold_LoadThreshold = -1;
static int hf_org_csapi_fw_TpLoadInitVal_LoadLevel = -1;
static int hf_org_csapi_fw_TpProperty_PropertyName = -1;
static int hf_org_csapi_fw_TpProperty_PropertyValue = -1;
static int hf_org_csapi_fw_TpClientAppDescription_ClientAppID = -1;
static int hf_org_csapi_fw_TpClientAppDescription_ClientAppProperties_loop = -1;
static int hf_org_csapi_fw_TpClientAppDescription_HasAccessSession = -1;
static int hf_org_csapi_fw_TpClientAppDescription_HasServiceInstances = -1;
static int hf_org_csapi_fw_TpEntOp_EntOpID = -1;
static int hf_org_csapi_fw_TpEntOp_EntOpProperties_loop = -1;
static int hf_org_csapi_fw_TpSag_SagID = -1;
static int hf_org_csapi_fw_TpSag_SagDescription = -1;
static int hf_org_csapi_fw_TpServiceProperty_ServicePropertyName = -1;
static int hf_org_csapi_fw_TpServiceProperty_ServicePropertyValueList_loop = -1;
static int hf_org_csapi_fw_TpServiceProperty_ServicePropertyValueList = -1;
static int hf_org_csapi_fw_TpServiceDescription_ServiceTypeName = -1;
static int hf_org_csapi_fw_TpServiceDescription_ServicePropertyList_loop = -1;
static int hf_org_csapi_fw_TpService_ServiceID = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceContractID = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceStartDate = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceEndDate = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceTypeName = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceSubscriptionProperties_loop = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_InUse = -1;
static int hf_org_csapi_fw_TpServiceProfileDescription_ServiceID = -1;
static int hf_org_csapi_fw_TpServiceTypeProperty_ServicePropertyName = -1;
static int hf_org_csapi_fw_TpServiceTypeProperty_ServiceTypePropertyMode = -1;
static int hf_org_csapi_fw_TpServiceTypeProperty_ServicePropertyTypeName = -1;
static int hf_org_csapi_fw_TpServiceTypeDescription_ServiceTypePropertyList_loop = -1;
static int hf_org_csapi_fw_TpServiceTypeDescription_ServiceTypeNameList_loop = -1;
static int hf_org_csapi_fw_TpServiceTypeDescription_ServiceTypeNameList = -1;
static int hf_org_csapi_fw_TpServiceTypeDescription_AvailableOrUnavailable = -1;
static int hf_org_csapi_fw_TpSignatureAndServiceMgr_DigitalSignature_loop = -1;
static int hf_org_csapi_fw_TpSignatureAndServiceMgr_DigitalSignature = -1;
static int hf_org_csapi_fw_TpPerson_PersonName = -1;
static int hf_org_csapi_fw_TpPerson_PostalAddress = -1;
static int hf_org_csapi_fw_TpPerson_TelephoneNumber = -1;
static int hf_org_csapi_fw_TpPerson_Email = -1;
static int hf_org_csapi_fw_TpPerson_HomePage = -1;
static int hf_org_csapi_fw_TpPerson_PersonProperties_loop = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_ServiceStartDate = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_ServiceEndDate = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_ServiceTypeName = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_ServiceID = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_ServiceSubscriptionProperties_loop = -1;
static int hf_org_csapi_fw_TpServiceContractDescription_InUse = -1;
static int hf_org_csapi_fw_TpLoadStatistic_TimeStamp = -1;
static int hf_org_csapi_fw_TpServiceContract_ServiceContractID = -1;
static int hf_org_csapi_fw_TpServiceProfile_ServiceProfileID = -1;
static int hf_org_csapi_fw_TpSagProfilePair_Sag = -1;
static int hf_org_csapi_fw_TpSagProfilePair_ServiceProfile = -1;
static int hf_org_csapi_fw_TpAddSagMembersConflict_ClientApplication = -1;
static int hf_org_csapi_fw_TpAddSagMembersConflict_Service = -1;
static int hf_org_csapi_fw_TpAssignSagToServiceProfileConflict_ClientApplication = -1;
static int hf_org_csapi_fw_TpAssignSagToServiceProfileConflict_Service = -1;
static int hf_org_csapi_fw_TpServiceTypePropertyValue_ServicePropertyName = -1;
static int hf_org_csapi_fw_TpServiceTypePropertyValue_ServiceTypePropertyMode = -1;
static int hf_org_csapi_fw_TpServiceTypePropertyValue_ServicePropertyTypeName = -1;
static int hf_org_csapi_fw_TpServiceTypePropertyValue_ServicePropertyValueList_loop = -1;
static int hf_org_csapi_fw_TpServiceTypePropertyValue_ServicePropertyValueList = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_ServiceType = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_ServiceID = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_CompatibleServiceID = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_BackwardCompatibilityLevel = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_MigrationRequired = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_DataMigrated = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_MigrationDataAndTime = -1;
static int hf_org_csapi_fw_TpFwMigrationServiceAvailableInfo_MigrationAdditionalInfo_loop = -1;
static int hf_org_csapi_fw_TpFwAgreementInfo_ClientApplicationID = -1;
static int hf_org_csapi_fw_TpFwAgreementInfo_ServiceID = -1;
static int hf_org_csapi_fw_TpFwAgreementInfo_ServiceContractID = -1;
static int hf_org_csapi_fw_TpFwAgreementInfo_ServiceProfileID = -1;
static int hf_org_csapi_ui_TpUIMessageCriteria_EndSequence = -1;
static int hf_org_csapi_ui_TpUIMessageCriteria_MaxMessageTime = -1;
static int hf_org_csapi_ui_TpUIMessageCriteria_MaxMessageSize = -1;
static int hf_org_csapi_ui_TpUIEventInfo_ServiceCode = -1;
static int hf_org_csapi_ui_TpUIEventInfo_DataTypeIndication = -1;
static int hf_org_csapi_ui_TpUIEventInfo_DataString = -1;
static int hf_org_csapi_ui_TpUIEventCriteria_ServiceCode = -1;
static int hf_org_csapi_ui_TpUIEventCriteriaResult_AssignmentID = -1;
static int hf_org_csapi_ui_TpUIEventNotificationInfo_ServiceCode = -1;
static int hf_org_csapi_ui_TpUIEventNotificationInfo_DataTypeIndication = -1;
static int hf_org_csapi_ui_TpUIEventNotificationInfo_UIEventData_loop = -1;
static int hf_org_csapi_ui_TpUIEventNotificationInfo_UIEventData = -1;
static int hf_org_csapi_ui_TpUIRecognitionProperty_PropertyName = -1;
static int hf_org_csapi_ui_TpUIRecognitionProperty_PropertyValue = -1;
static int hf_org_csapi_ui_TpUIRecognitionCriteria_SpeakerID = -1;
static int hf_org_csapi_ui_TpUIRecognitionCriteria_Properties_loop = -1;
static int hf_org_csapi_ui_TpUIRecognitionCriteria_Grammar = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_MinLength = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_MaxLength = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_EndSequence = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_StartTimeout = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_InterCharTimeout = -1;
static int hf_org_csapi_ui_TpUICollectCriteria_CollectMode = -1;
static int hf_org_csapi_ui_TpUIWordOverride_Spelling = -1;
static int hf_org_csapi_ui_TpUIWordOverride_PronounceType = -1;
static int hf_org_csapi_ui_TpUIWordOverride_PronounceAs = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_SpeakerGender = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_SpeakerAge = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_SpeakerRate = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_SpeakerRange = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_TextData = -1;
static int hf_org_csapi_ui_TpUISynthesisInfoData_WordOverrideSet_loop = -1;
static int hf_org_csapi_cc_TpCallError_ErrorTime = -1;
static int hf_org_csapi_cc_TpCallError_ErrorType = -1;
static int hf_org_csapi_cc_TpCallEndedReport_CallLegSessionID = -1;
static int hf_org_csapi_cc_TpCallEndedReport_Cause = -1;
static int hf_org_csapi_cc_TpCallInfoReport_CallInfoType = -1;
static int hf_org_csapi_cc_TpCallInfoReport_CallInitiationStartTime = -1;
static int hf_org_csapi_cc_TpCallInfoReport_CallConnectedToResourceTime = -1;
static int hf_org_csapi_cc_TpCallInfoReport_CallConnectedToDestinationTime = -1;
static int hf_org_csapi_cc_TpCallInfoReport_CallEndTime = -1;
static int hf_org_csapi_cc_TpCallInfoReport_Cause = -1;
static int hf_org_csapi_cc_TpCallServiceCode_CallServiceCodeType = -1;
static int hf_org_csapi_cc_TpCallServiceCode_ServiceCodeValue = -1;
static int hf_org_csapi_cc_TpCallTreatment_CallTreatmentType = -1;
static int hf_org_csapi_cc_TpCallTreatment_ReleaseCause = -1;
static int hf_org_csapi_cc_TpCallChargePlan_ChargeOrderType = -1;
static int hf_org_csapi_cc_TpCallChargePlan_TransparentCharge_loop = -1;
static int hf_org_csapi_cc_TpCallChargePlan_TransparentCharge = -1;
static int hf_org_csapi_cc_TpCallChargePlan_ChargePlan = -1;
static int hf_org_csapi_cc_TpCallChargePlan_AdditionalInfo_loop = -1;
static int hf_org_csapi_cc_TpCallChargePlan_AdditionalInfo = -1;
static int hf_org_csapi_cc_TpCallChargePlan_PartyToCharge = -1;
static int hf_org_csapi_cc_gccs_TpCallEventCriteria_CallEventName = -1;
static int hf_org_csapi_cc_gccs_TpCallEventCriteria_CallNotificationType = -1;
static int hf_org_csapi_cc_gccs_TpCallEventCriteria_MonitorMode = -1;
static int hf_org_csapi_cc_gccs_TpCallEventCriteriaResult_AssignmentID = -1;
static int hf_org_csapi_cc_gccs_TpCallReleaseCause_Value = -1;
static int hf_org_csapi_cc_gccs_TpCallReleaseCause_Location = -1;
static int hf_org_csapi_cc_gccs_TpCallReport_MonitorMode = -1;
static int hf_org_csapi_cc_gccs_TpCallReport_CallEventTime = -1;
static int hf_org_csapi_cc_gccs_TpCallReport_CallReportType = -1;
static int hf_org_csapi_cc_gccs_TpCallReportRequest_MonitorMode = -1;
static int hf_org_csapi_cc_gccs_TpCallReportRequest_CallReportType = -1;
static int hf_org_csapi_cc_gccs_TpCallEventInfo_CallAppInfo_loop = -1;
static int hf_org_csapi_cc_gccs_TpCallEventInfo_CallEventName = -1;
static int hf_org_csapi_cc_gccs_TpCallEventInfo_CallNotificationType = -1;
static int hf_org_csapi_cc_gccs_TpCallEventInfo_MonitorMode = -1;
static int hf_org_csapi_cc_gccs_TpCallEndedReport_CallLegSessionID = -1;
static int hf_org_csapi_cc_gccs_TpCallInfoReport_CallInfoType = -1;
static int hf_org_csapi_cc_gccs_TpCallInfoReport_CallInitiationStartTime = -1;
static int hf_org_csapi_cc_gccs_TpCallInfoReport_CallConnectedToResourceTime = -1;
static int hf_org_csapi_cc_gccs_TpCallInfoReport_CallConnectedToDestinationTime = -1;
static int hf_org_csapi_cc_gccs_TpCallInfoReport_CallEndTime = -1;
static int hf_org_csapi_cc_gccs_TpCallTreatment_CallTreatmentType = -1;
static int hf_org_csapi_cc_gccs_TpCallIdentifier_CallSessionID = -1;
static int hf_org_csapi_cc_TpCallEventRequest_CallEventType = -1;
static int hf_org_csapi_cc_TpCallEventRequest_CallMonitorMode = -1;
static int hf_org_csapi_cc_TpCallNotificationRequest_CallEventsRequested_loop = -1;
static int hf_org_csapi_cc_TpNotificationRequested_AssignmentID = -1;
static int hf_org_csapi_cc_TpCallLegConnectionProperties_AttachMechanism = -1;
static int hf_org_csapi_cc_TpCallEventInfo_CallEventType = -1;
static int hf_org_csapi_cc_TpCallEventInfo_CallMonitorMode = -1;
static int hf_org_csapi_cc_TpCallEventInfo_CallEventTime = -1;
static int hf_org_csapi_cc_TpNotificationRequestedSetEntry_NotificationRequestSet_loop = -1;
static int hf_org_csapi_cc_TpNotificationRequestedSetEntry_Final = -1;
static int hf_org_csapi_cc_TpCarrier_CarrierID_loop = -1;
static int hf_org_csapi_cc_TpCarrier_CarrierID = -1;
static int hf_org_csapi_cc_TpCarrier_CarrierSelectionField = -1;
static int hf_org_csapi_cc_TpCallNotificationInfo_CallAppInfo_loop = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegInfoType = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegStartTime = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegConnectedToResourceTime = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegConnectedToAddressTime = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegEndTime = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallLegReleaseCause = -1;
static int hf_org_csapi_cc_TpCallLegInfoReport_CallAppInfo_loop = -1;
static int hf_org_csapi_cc_TpCallLegProperty_CallLegPropertyName = -1;
static int hf_org_csapi_cc_TpCallLegProperty_CallLegPropertyValue = -1;
static int hf_org_csapi_cc_mpccs_TpMultiPartyCallIdentifier_CallSessionID = -1;
static int hf_org_csapi_cc_mpccs_TpCallLegIdentifier_CallLegSessionID = -1;
static int hf_org_csapi_cc_mpccs_TpAppCallLegCallBack_AppCallLegSet_loop = -1;
static int hf_org_csapi_cc_mmccs_TpCallSuperviseVolume_VolumeQuantity = -1;
static int hf_org_csapi_cc_mmccs_TpCallSuperviseVolume_VolumeUnit = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamRequest_Direction = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamRequest_MediaMonitorMode = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamRequest_EventType = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStream_Direction = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStream_ChannelSessionID = -1;
static int hf_org_csapi_cc_mmccs_TpNotificationMediaRequest_MediaStreamsRequested_loop = -1;
static int hf_org_csapi_cc_mmccs_TpMediaNotificationRequested_AssignmentID = -1;
static int hf_org_csapi_cc_mmccs_TpMultiMediaCallIdentifier_MMCallSessionID = -1;
static int hf_org_csapi_cc_mmccs_TpMultiMediaCallLegIdentifier_MMCallLegSessionID = -1;
static int hf_org_csapi_cc_mmccs_TpAppMultiMediaCallLegCallBack_AppCallLegSet_loop = -1;
static int hf_org_csapi_cc_cccs_TpMonoMediaConfPolicy_JoinAllowed = -1;
static int hf_org_csapi_cc_cccs_TpJoinEventInfo_CallAppInfo_loop = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchCriteria_StartSearch = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchCriteria_StopSearch = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchCriteria_RequestedResources = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchCriteria_RequestedDuration = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchResult_MatchFound = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchResult_ActualStartTime = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchResult_ActualResources = -1;
static int hf_org_csapi_cc_cccs_TpConfSearchResult_ActualDuration = -1;
static int hf_org_csapi_cc_cccs_TpMultiMediaConfPolicy_JoinAllowed = -1;
static int hf_org_csapi_cc_cccs_TpMultiMediaConfPolicy_MediaAllowed = -1;
static int hf_org_csapi_cc_cccs_TpMultiMediaConfPolicy_Chaired = -1;
static int hf_org_csapi_cc_cccs_TpMultiMediaConfPolicy_VideoHandling = -1;
static int hf_org_csapi_cc_cccs_TpResourceReservation_ReservationID = -1;
static int hf_org_csapi_cc_cccs_TpConfCallIdentifier_ConfCallSessionID = -1;
static int hf_org_csapi_cc_cccs_TpSubConfCallIdentifier_SubConfCallSessionID = -1;
static int hf_org_csapi_ui_TpUIIdentifier_UserInteractionSessionID = -1;
static int hf_org_csapi_ui_TpUICallIdentifier_UserInteractionSessionID = -1;
static int hf_org_csapi_mm_TpLocationResponseTime_ResponseTime = -1;
static int hf_org_csapi_mm_TpLocationResponseTime_TimerValue = -1;
static int hf_org_csapi_mm_TpLocationTrigger_Longitude = -1;
static int hf_org_csapi_mm_TpLocationTrigger_Latitude = -1;
static int hf_org_csapi_mm_TpLocationTrigger_AreaSemiMajor = -1;
static int hf_org_csapi_mm_TpLocationTrigger_AreaSemiMinor = -1;
static int hf_org_csapi_mm_TpLocationTrigger_AngleOfSemiMajor = -1;
static int hf_org_csapi_mm_TpLocationTrigger_Criterion = -1;
static int hf_org_csapi_mm_TpLocationTrigger_ReportingInterval = -1;
static int hf_org_csapi_mm_TpLocationRequest_RequestedAccuracy = -1;
static int hf_org_csapi_mm_TpLocationRequest_AltitudeRequested = -1;
static int hf_org_csapi_mm_TpLocationRequest_Type = -1;
static int hf_org_csapi_mm_TpLocationRequest_Priority = -1;
static int hf_org_csapi_mm_TpLocationRequest_RequestedLocationMethod = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_Longitude = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_Latitude = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_TypeOfUncertaintyShape = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_UncertaintyInnerSemiMajor = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_UncertaintyOuterSemiMajor = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_UncertaintyInnerSemiMinor = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_UncertaintyOuterSemiMinor = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_AngleOfSemiMajor = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_SegmentStartAngle = -1;
static int hf_org_csapi_mm_TpGeographicalPosition_SegmentEndAngle = -1;
static int hf_org_csapi_mm_TpMobilityStopAssignmentData_AssignmentId = -1;
static int hf_org_csapi_mm_TpMobilityStopAssignmentData_StopScope = -1;
static int hf_org_csapi_mm_TpMobilityStopAssignmentData_Users_loop = -1;
static int hf_org_csapi_mm_TpUlExtendedData_TerminalType = -1;
static int hf_org_csapi_mm_TpUlExtendedData_AltitudePresent = -1;
static int hf_org_csapi_mm_TpUlExtendedData_Altitude = -1;
static int hf_org_csapi_mm_TpUlExtendedData_UncertaintyAltitude = -1;
static int hf_org_csapi_mm_TpUlExtendedData_TimestampPresent = -1;
static int hf_org_csapi_mm_TpUlExtendedData_Timestamp = -1;
static int hf_org_csapi_mm_TpUlExtendedData_UsedLocationMethod = -1;
static int hf_org_csapi_mm_TpUserLocation_StatusCode = -1;
static int hf_org_csapi_mm_TpUserLocationExtended_StatusCode = -1;
static int hf_org_csapi_mm_TpUserLocationExtended_Locations_loop = -1;
static int hf_org_csapi_mm_TpLocationTriggerCamel_UpdateInsideVlr = -1;
static int hf_org_csapi_mm_TpLocationTriggerCamel_UpdateOutsideVlr = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_StatusCode = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_GeographicalPositionPresent = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_TimestampPresent = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_Timestamp = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_VlrNumberPresent = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_LocationNumberPresent = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_CellIdOrLaiPresent = -1;
static int hf_org_csapi_mm_TpUserLocationCamel_CellIdOrLai = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_UserAddressPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_NaEsrdPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_NaEsrd = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_NaEsrkPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_NaEsrk = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_ImeiPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergencyRequest_Imei = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_StatusCode = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_UserIdPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_NaEsrdPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_NaEsrd = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_NaEsrkPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_NaEsrk = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_ImeiPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_Imei = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_TriggeringEvent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_GeographicalPositionPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_AltitudePresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_Altitude = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_UncertaintyAltitude = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_TimestampPresent = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_Timestamp = -1;
static int hf_org_csapi_mm_TpUserLocationEmergency_UsedLocationMethod = -1;
static int hf_org_csapi_mm_TpUserStatus_StatusCode = -1;
static int hf_org_csapi_mm_TpUserStatus_Status = -1;
static int hf_org_csapi_mm_TpUserStatus_TerminalType = -1;
static int hf_org_csapi_mm_TpTriggeredStatusRequest_Users_loop = -1;
static int hf_org_csapi_mm_TpTriggeredStatusRequest_AssignmentID = -1;
static int hf_org_csapi_mm_TpTriggeredStatusRequestSetEntry_Requests_loop = -1;
static int hf_org_csapi_mm_TpTriggeredStatusRequestSetEntry_Final = -1;
static int hf_org_csapi_mm_TpPeriodicLocationRequest_Users_loop = -1;
static int hf_org_csapi_mm_TpPeriodicLocationRequest_ReportingInterval = -1;
static int hf_org_csapi_mm_TpPeriodicLocationRequest_AssignmentID = -1;
static int hf_org_csapi_mm_TpPeriodicLocationRequestSetEntry_Requests_loop = -1;
static int hf_org_csapi_mm_TpPeriodicLocationRequestSetEntry_Final = -1;
static int hf_org_csapi_mm_TpTriggeredLocationRequest_Users_loop = -1;
static int hf_org_csapi_mm_TpTriggeredLocationRequest_AssignmentID = -1;
static int hf_org_csapi_mm_TpTriggeredLocationRequestSetEntry_Requests_loop = -1;
static int hf_org_csapi_mm_TpTriggeredLocationRequestSetEntry_Final = -1;
static int hf_org_csapi_mm_TpUserStatusIndicatorExtended_UserStatusIndicator = -1;
static int hf_org_csapi_mm_TpUserStatusIndicatorExtended_PDPContextActive = -1;
static int hf_org_csapi_mm_TpUserInfo_UserName = -1;
static int hf_org_csapi_mm_TpUserInfo_Password = -1;
static int hf_org_csapi_mm_TpNetworkStatusIndicator_CountryCode = -1;
static int hf_org_csapi_mm_TpNetworkStatusIndicator_MobileNetworkCode = -1;
static int hf_org_csapi_mm_TpNetworkStatusIndicator_AccessTechnology = -1;
static int hf_org_csapi_mm_TpNetworkStatusIndicator_RoamingStatus = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_UserID = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_StatusCode = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_TerminalType = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_AuthenticationStatus = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_UserIPAddress = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_UserMSISDN = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_UserConnectionID = -1;
static int hf_org_csapi_mm_TpUserStatusExtended_AccessPointName = -1;
static int hf_org_csapi_mm_TpBindingNotificationCriteria_NotificationCriteriaType = -1;
static int hf_org_csapi_mm_TpBindingNotificationCriteria_ContactAddressSet_loop = -1;
static int hf_org_csapi_termcap_TpTerminalCapabilities_TerminalCapabilities = -1;
static int hf_org_csapi_termcap_TpTerminalCapabilities_StatusCode = -1;
static int hf_org_csapi_termcap_TpTerminalCapabilityScope_ScopeType = -1;
static int hf_org_csapi_termcap_TpTerminalCapabilityScope_Scope = -1;
static int hf_org_csapi_dsc_TpChargePerVolume_InitialCharge = -1;
static int hf_org_csapi_dsc_TpChargePerVolume_CurrentChargePerKilobyte = -1;
static int hf_org_csapi_dsc_TpChargePerVolume_NextChargePerKilobyte = -1;
static int hf_org_csapi_dsc_TpDataSessionChargePlan_Currency = -1;
static int hf_org_csapi_dsc_TpDataSessionChargePlan_AdditionalInfo = -1;
static int hf_org_csapi_dsc_TpDataSessionError_ErrorTime = -1;
static int hf_org_csapi_dsc_TpDataSessionError_ErrorType = -1;
static int hf_org_csapi_dsc_TpDataSessionEventCriteria_DataSessionEventName = -1;
static int hf_org_csapi_dsc_TpDataSessionEventCriteria_MonitorMode = -1;
static int hf_org_csapi_dsc_TpDataSessionEventInfo_DataSessionEventName = -1;
static int hf_org_csapi_dsc_TpDataSessionEventInfo_MonitorMode = -1;
static int hf_org_csapi_dsc_TpDataSessionEventInfo_QoSClass = -1;
static int hf_org_csapi_dsc_TpDataSessionReleaseCause_Value = -1;
static int hf_org_csapi_dsc_TpDataSessionReleaseCause_Location = -1;
static int hf_org_csapi_dsc_TpDataSessionReport_MonitorMode = -1;
static int hf_org_csapi_dsc_TpDataSessionReport_DataSessionEventTime = -1;
static int hf_org_csapi_dsc_TpDataSessionReport_DataSessionReportType = -1;
static int hf_org_csapi_dsc_TpDataSessionReportRequest_MonitorMode = -1;
static int hf_org_csapi_dsc_TpDataSessionReportRequest_DataSessionReportType = -1;
static int hf_org_csapi_dsc_TpDataSessionSuperviseVolume_VolumeQuantity = -1;
static int hf_org_csapi_dsc_TpDataSessionSuperviseVolume_VolumeUnit = -1;
static int hf_org_csapi_dsc_TpDataSessionEventCriteriaResult_AssignmentID = -1;
static int hf_org_csapi_dsc_TpDataSessionIdentifier_DataSessionID = -1;
static int hf_org_csapi_gms_TpGMSNewMessageArrivedInfo_FolderID = -1;
static int hf_org_csapi_gms_TpGMSNewMessageArrivedInfo_MessageID = -1;
static int hf_org_csapi_gms_TpGMSNewMessageArrivedInfo_NumberOfProperties = -1;
static int hf_org_csapi_gms_TpGMSNewMessageArrivedCriteria_AuthenticationInfo = -1;
static int hf_org_csapi_gms_TpMailboxIdentifier_SessionID = -1;
static int hf_org_csapi_gms_TpMailboxFolderIdentifier_SessionID = -1;
static int hf_org_csapi_cm_TpNameDescrpTagTimePeriod_duration = -1;
static int hf_org_csapi_cm_TpNameDescrpTagTimeOfDay_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagTimeOfDay_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagTimeOfDay_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagTimeOfDay_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagString_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagString_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagString_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagString_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagMonth_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagMonth_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagMonth_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagMonth_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagInt_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagInt_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagInt_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagInt_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDir_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDir_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDir_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDir_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDayOfWeek_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDayOfWeek_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDayOfWeek_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDayOfWeek_value = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDateTime_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDateTime_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDateTime_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagDateTime_value = -1;
static int hf_org_csapi_cm_TpEndpoint_type = -1;
static int hf_org_csapi_cm_TpEndpoint_id = -1;
static int hf_org_csapi_cm_TpNameDescrpTagExcessLoadAction_name = -1;
static int hf_org_csapi_cm_TpNameDescrpTagExcessLoadAction_description = -1;
static int hf_org_csapi_cm_TpNameDescrpTagExcessLoadAction_tag = -1;
static int hf_org_csapi_cm_TpNameDescrpTagExcessLoadAction_value = -1;
static int hf_org_csapi_cm_TpDsCodepoint_match = -1;
static int hf_org_csapi_cm_TpDsCodepoint_mask = -1;
static int hf_org_csapi_cm_TpIPSubnet_subnetNumber = -1;
static int hf_org_csapi_cm_TpIPSubnet_subnetMask = -1;
static int hf_org_csapi_cm_TpIPSubnet_addressType = -1;
static int hf_org_csapi_cm_TpIPSubnet_IPVersionSupport = -1;
static int hf_org_csapi_am_TpBalanceInfo_Currency = -1;
static int hf_org_csapi_am_TpBalanceInfo_ValuePartA = -1;
static int hf_org_csapi_am_TpBalanceInfo_ValuePartB = -1;
static int hf_org_csapi_am_TpBalanceInfo_Exponent = -1;
static int hf_org_csapi_am_TpBalanceInfo_AdditionalInfo = -1;
static int hf_org_csapi_am_TpChargingEventInfo_ChargingEventName = -1;
static int hf_org_csapi_am_TpChargingEventInfo_ChargingEventTime = -1;
static int hf_org_csapi_am_TpBalance_StatusCode = -1;
static int hf_org_csapi_am_TpTransactionHistory_TransactionID = -1;
static int hf_org_csapi_am_TpTransactionHistory_TimeStamp = -1;
static int hf_org_csapi_am_TpTransactionHistory_AdditionalInfo = -1;
static int hf_org_csapi_am_TpChargingEventCriteria_ChargingEvents_loop = -1;
static int hf_org_csapi_am_TpChargingEventCriteria_ChargingEvents = -1;
static int hf_org_csapi_am_TpChargingEventCriteria_Users_loop = -1;
static int hf_org_csapi_am_TpChargingEventCriteriaResult_AssignmentID = -1;
static int hf_org_csapi_am_TpBalanceExpiryDate_StatusCode = -1;
static int hf_org_csapi_am_TpBalanceExpiryDate_ExpiryDate = -1;
static int hf_org_csapi_am_TpVoucher_VoucherID = -1;
static int hf_org_csapi_cs_TpMerchantAccountID_MerchantID = -1;
static int hf_org_csapi_cs_TpMerchantAccountID_AccountID = -1;
static int hf_org_csapi_cs_TpCorrelationID_CorrelationID = -1;
static int hf_org_csapi_cs_TpCorrelationID_CorrelationType = -1;
static int hf_org_csapi_cs_TpAmount_Number = -1;
static int hf_org_csapi_cs_TpAmount_Exponent = -1;
static int hf_org_csapi_cs_TpChargingPrice_Currency = -1;
static int hf_org_csapi_cs_TpVolume_Unit = -1;
static int hf_org_csapi_cs_TpChargingSessionID_ChargingSessionID = -1;
static int hf_org_csapi_cs_TpChargingSessionID_RequestNumberFirstRequest = -1;
static int hf_org_csapi_cs_TpApplicationDescription_Text = -1;
static int hf_org_csapi_cs_TpApplicationDescription_AppInformation_loop = -1;
static int hf_org_csapi_cs_TpChargingParameter_ParameterID = -1;
static int hf_org_csapi_policy_TpPolicyEvent_EventID = -1;
static int hf_org_csapi_policy_TpPolicyEvent_TimeGenerated = -1;
static int hf_org_csapi_policy_TpPolicyEvent_Attributes_loop = -1;
static int hf_org_csapi_policy_TpPolicyEvent_EventDefinitionName = -1;
static int hf_org_csapi_policy_TpPolicyEvent_EventDomainName = -1;
static int hf_org_csapi_policy_TpPolicyNameValue_Name = -1;
static int hf_org_csapi_policy_TpPolicyType_TpPolicyRecordType_Names_loop = -1;
static int hf_org_csapi_policy_TpPolicyType_TpPolicyRecordType_Names = -1;
static int hf_org_csapi_policy_TpPolicyType_TpPolicyRecordType_Types_loop = -1;
static int hf_org_csapi_policy_TpPolicyType_TpPolicyListType_ElementType_loop = -1;
static int hf_org_csapi_policy_TpPolicyVar_VarName = -1;
static int hf_org_csapi_policy_TpPolicyConditionListElement_GroupNumber = -1;
static int hf_org_csapi_policy_TpPolicyConditionListElement_Negated = -1;
static int hf_org_csapi_policy_TpPolicyActionListElement_SequenceNumber = -1;
static int hf_org_csapi_pam_TpPAMAttributeDef_Name = -1;
static int hf_org_csapi_pam_TpPAMAttributeDef_Type = -1;
static int hf_org_csapi_pam_TpPAMAttributeDef_IsStatic = -1;
static int hf_org_csapi_pam_TpPAMAttributeDef_IsRevertOnExpiration = -1;
static int hf_org_csapi_pam_TpPAMAttribute_AttributeName = -1;
static int hf_org_csapi_pam_TpPAMAttribute_ExpiresIn = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_Name = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_subscriberStatus = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_networkStatus = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_communicationMeans = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_subscriberProvidedLocation = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_networkProvidedLocation = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_Priority = -1;
static int hf_org_csapi_pam_TpPAMPresenceData_otherInfo = -1;
static int hf_org_csapi_pam_TpPAMAvailabilityProfile_PrivacyCode = -1;
static int hf_org_csapi_pam_TpPAMCommunicationContext_CommunicationCapability = -1;
static int hf_org_csapi_pam_TpPAMContext_AskerData_loop = -1;
static int hf_org_csapi_pam_TpPAMAccessControlData_DefaultPolicy = -1;
static int hf_org_csapi_pam_TpPAMAccessControlData_AllowList_loop = -1;
static int hf_org_csapi_pam_TpPAMAccessControlData_AllowList = -1;
static int hf_org_csapi_pam_TpPAMAccessControlData_DenyList_loop = -1;
static int hf_org_csapi_pam_TpPAMAccessControlData_DenyList = -1;
static int hf_org_csapi_pam_TpPAMICEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMICEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMICNotificationData_Identities_loop = -1;
static int hf_org_csapi_pam_TpPAMICNotificationData_Identities = -1;
static int hf_org_csapi_pam_TpPAMIDEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMIDEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMIDEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMIDEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMIDNotificationData_Identities_loop = -1;
static int hf_org_csapi_pam_TpPAMIDNotificationData_Identities = -1;
static int hf_org_csapi_pam_TpPAMGMCEventData_GroupName_loop = -1;
static int hf_org_csapi_pam_TpPAMGMCEventData_GroupName = -1;
static int hf_org_csapi_pam_TpPAMGMCEventData_GroupType_loop = -1;
static int hf_org_csapi_pam_TpPAMGMCEventData_GroupType = -1;
static int hf_org_csapi_pam_TpPAMGMCNotificationData_Groups_loop = -1;
static int hf_org_csapi_pam_TpPAMGMCNotificationData_Groups = -1;
static int hf_org_csapi_pam_TpPAMACEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMACEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMACNotificationData_Agents_loop = -1;
static int hf_org_csapi_pam_TpPAMACNotificationData_Agents = -1;
static int hf_org_csapi_pam_TpPAMADEventData_AgentName_loop = -1;
static int hf_org_csapi_pam_TpPAMADEventData_AgentName = -1;
static int hf_org_csapi_pam_TpPAMADEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMADEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMADNotificationData_Agents_loop = -1;
static int hf_org_csapi_pam_TpPAMADNotificationData_Agents = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_AgentName_loop = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_AgentName = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMAAEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMAANotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMAANotificationData_Agent = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_AgentName_loop = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_AgentName = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMAUEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMAUNotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMAUNotificationData_Agent = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_Capabilities_loop = -1;
static int hf_org_csapi_pam_TpPAMCCEventData_Capabilities = -1;
static int hf_org_csapi_pam_TpPAMCCNotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMCCNotificationData_Capabilities_loop = -1;
static int hf_org_csapi_pam_TpPAMCCNotificationData_Capabilities = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AgentName_loop = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AgentName = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_Capabilities_loop = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_Capabilities = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMACPSEventData_ReportingPeriod = -1;
static int hf_org_csapi_pam_TpPAMACPSNotificationData_Agent = -1;
static int hf_org_csapi_pam_TpPAMACPSNotificationData_Capability = -1;
static int hf_org_csapi_pam_TpPAMACPSNotificationData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMACPSNotificationData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AgentName_loop = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AgentName = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AgentType_loop = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AgentType = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMAPSEventData_ReportingPeriod = -1;
static int hf_org_csapi_pam_TpPAMAPSNotificationData_Agent = -1;
static int hf_org_csapi_pam_TpPAMAPSNotificationData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMAPSNotificationData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMIPSEventData_ReportingPeriod = -1;
static int hf_org_csapi_pam_TpPAMIPSNotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMIPSNotificationData_Attributes_loop = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_PAMContext_loop = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_AttributeNames_loop = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_AttributeNames = -1;
static int hf_org_csapi_pam_TpPAMAVCEventData_ReportingPeriod = -1;
static int hf_org_csapi_pam_TpPAMAVCNotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMAVCNotificationData_Availability_loop = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_Events_loop = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_Events = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_IdentityName_loop = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_IdentityName = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_IdentityType_loop = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_IdentityType = -1;
static int hf_org_csapi_pam_TpPAMWCEventData_ReportingPeriod = -1;
static int hf_org_csapi_pam_TpPAMWCNotificationData_Event = -1;
static int hf_org_csapi_pam_TpPAMWCNotificationData_ChangeType = -1;
static int hf_org_csapi_pam_TpPAMWCNotificationData_Identity = -1;
static int hf_org_csapi_pam_TpPAMWCNotificationData_Watchers_loop = -1;
static int hf_org_csapi_pam_TpPAMWCNotificationData_Watchers = -1;
static int hf_org_csapi_pam_TpPAMErrorInfo_Cause = -1;
static int hf_org_csapi_mmm_TpMailboxIdentifier_SessionID = -1;
static int hf_org_csapi_mmm_TpMultiMediaMessagingIdentifier_SessionID = -1;
static int hf_org_csapi_mmm_TpListMessagesCriteria_OnlyUnreadMessages = -1;
static int hf_org_csapi_mmm_TpMailboxFolderStatusInformation_TotalMessageCount = -1;
static int hf_org_csapi_mmm_TpMessageDescription_MessageID = -1;
static int hf_org_csapi_mmm_TpMessageDescription_To_loop = -1;
static int hf_org_csapi_mmm_TpMessageDescription_Subject = -1;
static int hf_org_csapi_mmm_TpMessageDescription_ReceivedDate = -1;
static int hf_org_csapi_mmm_TpMessageDescription_Size = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentDescription = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentSize = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentType = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentTransferEncoding = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentID = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_ContentDisposition = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_PartID = -1;
static int hf_org_csapi_mmm_TpBodyPartDescription_NestingLevel = -1;
static int hf_org_csapi_mmm_TpBodyPart_BodyPartContent_loop = -1;
static int hf_org_csapi_mmm_TpBodyPart_BodyPartContent = -1;
static int hf_org_csapi_mmm_TpGenericHeaderField_FieldName = -1;
static int hf_org_csapi_mmm_TpGenericHeaderField_FieldValue = -1;
static int hf_org_csapi_mmm_TpMessageInfoPropertyError_MessagePropertyName = -1;
static int hf_org_csapi_mmm_TpMessageInfoPropertyError_Error = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedCriteria_MailboxID = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedCriteria_AuthenticationInfo = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedInfo_MailboxID = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedInfo_FolderID = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedInfo_MessageDescription_loop = -1;
static int hf_org_csapi_mmm_TpNewMailboxMessageArrivedInfo_ExtendedHeaderInformation_loop = -1;
static int hf_org_csapi_mmm_TpQueryStatusReport_ReportedStatus = -1;
static int hf_org_csapi_mmm_TpTerminatingAddressList_ToAddressList_loop = -1;
static int hf_org_csapi_mmm_TpTerminatingAddressList_CcAddressList_loop = -1;
static int hf_org_csapi_mmm_TpTerminatingAddressList_BccAddressList_loop = -1;
static int hf_org_csapi_mmm_TpNewMessageArrivedCriteria_CreateMultiMediaMessagingSession = -1;
static int hf_org_csapi_mmm_TpMessagingNotificationRequested_EventCriteria_loop = -1;
static int hf_org_csapi_mmm_TpMessagingNotificationRequested_AssignmentID = -1;
static int hf_org_csapi_mmm_TpMessagingNotificationRequestedSetEntry_MessagingNotificationRequestedSet_loop = -1;
static int hf_org_csapi_mmm_TpMessagingNotificationRequestedSetEntry_Final = -1;
static int hf_org_csapi_mmm_TpNewMessageArrivedInfo_DestinationAddressSet_loop = -1;
static int hf_org_csapi_mmm_TpNewMessageArrivedInfo_Message_loop = -1;
static int hf_org_csapi_mmm_TpNewMessageArrivedInfo_Message = -1;
static int hf_org_csapi_mmm_TpNewMessageArrivedInfo_Headers_loop = -1;
        /* User exception filters */
static int hf_org_csapi_P_INVALID_ASSIGNMENT_ID_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_TIME_AND_DATE_FORMAT_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_EVENT_TYPE_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_INTERFACE_NAME_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_INTERFACE_TYPE_ExtraInformation = -1;
static int hf_org_csapi_P_UNKNOWN_SUBSCRIBER_ExtraInformation = -1;
static int hf_org_csapi_P_INFORMATION_NOT_AVAILABLE_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_CRITERIA_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_SESSION_ID_ExtraInformation = -1;
static int hf_org_csapi_TpCommonExceptions_ExceptionType = -1;
static int hf_org_csapi_TpCommonExceptions_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_CURRENCY_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_AMOUNT_ExtraInformation = -1;
static int hf_org_csapi_P_APPLICATION_NOT_ACTIVATED_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_ADDRESS_ExtraInformation = -1;
static int hf_org_csapi_P_UNSUPPORTED_ADDRESS_PLAN_ExtraInformation = -1;
static int hf_org_csapi_P_UNAUTHORISED_PARAMETER_VALUE_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_VERSION_ExtraInformation = -1;
static int hf_org_csapi_P_INVALID_NETWORK_STATE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SERVICE_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_SERVICE_ACCESS_DENIED_ExtraInformation = -1;
static int hf_org_csapi_fw_P_ACCESS_DENIED_ExtraInformation = -1;
static int hf_org_csapi_fw_P_SERVICE_NOT_ENABLED_ExtraInformation = -1;
static int hf_org_csapi_fw_P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_AGREEMENT_TEXT_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SERVICE_TOKEN_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SIGNATURE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SIGNING_ALGORITHM_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_DOMAIN_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_PROPERTY_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_ACCESS_TYPE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_ILLEGAL_SERVICE_TYPE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_UNKNOWN_SERVICE_TYPE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_MISSING_MANDATORY_PROPERTY_ExtraInformation = -1;
static int hf_org_csapi_fw_P_DUPLICATE_PROPERTY_NAME_ExtraInformation = -1;
static int hf_org_csapi_fw_P_PROPERTY_TYPE_MISMATCH_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_CLIENT_APP_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_AUTH_TYPE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SAG_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SERVICE_PROFILE_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SERVICE_CONTRACT_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_ACTIVITY_TEST_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_ILLEGAL_SERVICE_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_UNKNOWN_SERVICE_ID_ExtraInformation = -1;
static int hf_org_csapi_fw_P_SERVICE_TYPE_UNAVAILABLE_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_ADDITION_TO_SAG_ExtraInformation = -1;
static int hf_org_csapi_fw_P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT_ExtraInformation = -1;
static int hf_org_csapi_fw_P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM_ExtraInformation = -1;
static int hf_org_csapi_fw_P_NO_ACCEPTABLE_SIGNING_ALGORITHM_ExtraInformation = -1;
static int hf_org_csapi_ui_P_ID_NOT_FOUND_ExtraInformation = -1;
static int hf_org_csapi_ui_P_ILLEGAL_ID_ExtraInformation = -1;
static int hf_org_csapi_ui_P_ILLEGAL_RANGE_ExtraInformation = -1;
static int hf_org_csapi_ui_P_INVALID_COLLECTION_CRITERIA_ExtraInformation = -1;
static int hf_org_csapi_mm_P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED_ExtraInformation = -1;
static int hf_org_csapi_mm_P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED_ExtraInformation = -1;
static int hf_org_csapi_mm_P_INVALID_REPORTING_INTERVAL_ExtraInformation = -1;
static int hf_org_csapi_mm_P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED_ExtraInformation = -1;
static int hf_org_csapi_termcap_P_INVALID_TERMINAL_ID_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_INVALID_FOLDER_ID_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_INSUFFICIENT_PRIVILEGE_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_INVALID_AUTHENTICATION_INFORMATION_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_INVALID_MAILBOX_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_INVALID_MESSAGE_ID_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_LOCKING_LOCKED_MAILBOX_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_MESSAGE_NOT_REMOVED_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_NUMBER_NOT_POSITIVE_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_UNLOCKING_UNLOCKED_MAILBOX_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_MAILBOX_LOCKED_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_CANNOT_UNLOCK_MAILBOX_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_PROPERTY_NOT_SET_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_FOLDER_IS_OPEN_ExtraInformation = -1;
static int hf_org_csapi_gms_P_GMS_MAILBOX_OPEN_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_VPRP_ID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SLA_ID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_STATUS_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_QOS_INFO_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_VALIDITY_INFO_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_PIPEQOSINFO_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_DSCODEPOINT_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_VPRPID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_REF_VALUE_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_INTERFACE_ExtraInformation = -1;
static int hf_org_csapi_cm_P_CANT_DELETE_VPRP_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_TEMPLATES_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_MENU_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_ENTERPRISE_NETWORK_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_TEMPLATE_TYPE_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_DESCRIPTION_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_SLA_ID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_TAG_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_VALUE_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_COMBINATION_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SITES_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_VPRN_ExtraInformation = -1;
static int hf_org_csapi_cm_P_ILLEGAL_SITE_ID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SITE_ID_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SAPS_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SITE_LOCATION_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SITE_DESCRIPTION_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_IPSUBNET_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_SAP_ExtraInformation = -1;
static int hf_org_csapi_cm_P_UNKNOWN_VPRP_ExtraInformation = -1;
static int hf_org_csapi_am_P_UNAUTHORIZED_APPLICATION_ExtraInformation = -1;
static int hf_org_csapi_cs_P_INVALID_USER_ExtraInformation = -1;
static int hf_org_csapi_cs_P_INVALID_ACCOUNT_ExtraInformation = -1;
static int hf_org_csapi_cs_P_INVALID_REQUEST_NUMBER_ExtraInformation = -1;
static int hf_org_csapi_cs_P_INVALID_VOLUME_ExtraInformation = -1;
static int hf_org_csapi_policy_P_ACCESS_VIOLATION_ExtraInformation = -1;
static int hf_org_csapi_policy_P_SYNTAX_ERROR_ExtraInformation = -1;
static int hf_org_csapi_policy_P_NAME_SPACE_ERROR_ExtraInformation = -1;
static int hf_org_csapi_policy_P_NO_TRANSACTION_IN_PROCESS_ExtraInformation = -1;
static int hf_org_csapi_policy_P_TRANSACTION_IN_PROCESS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_TYPE_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_MEMBER_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_IDENTITY_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_GROUP_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_CAPABILITY_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTES_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTE_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_ASSIGNMENT_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_ALIAS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNKNOWN_AGENT_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNASSIGNED_ALIAS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_TYPE_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_TYPE_ASSOCIATED_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_NOT_REGISTERED_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_NOT_MEMBER_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_NO_CAPABILITY_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_MEMBER_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_IS_CYCLIC_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_IDENTITY_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_DISASSOCIATED_TYPE_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_ATTRIBUTE_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_ALIAS_NOT_UNIQUE_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_ALIAS_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_AGENT_EXISTS_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_UNAVAILABLE_INTERFACE_ExtraInformation = -1;
static int hf_org_csapi_pam_P_PAM_INVALID_CREDENTIAL_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_AUTHENTICATION_INFORMATION_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_MAILBOX_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TYPE_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_MAX_MESSAGE_SIZE_EXCEEDED_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_FOLDER_ID_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_MESSAGE_ID_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_PART_ID_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_PROPERTY_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TIME_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_VALIDITY_TIME_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_MAX_SUBJECT_SIZE_EXCEEDED_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INFORMATION_NOT_AVAILABLE_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_CANNOT_CANCEL_ExtraInformation = -1;
static int hf_org_csapi_mmm_P_MMM_INVALID_HEADER_ExtraInformation = -1;
        /* Union filters */
static int hf_org_csapi_TpAoCOrder_TpAoCOrder = -1;
static int hf_org_csapi_TpAoCOrder_NetworkCharge = -1;
static int hf_org_csapi_TpSimpleAttributeValue_TpSimpleAttributeValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_BooleanValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_OctetValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_CharValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_WCharValue_len = -1;
static int hf_org_csapi_TpSimpleAttributeValue_WCharValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_StringValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_WStringValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_Int16Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_UnsignedInt16Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_Int32Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_UnsignedInt32Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_Int64Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_UnsignedInt64Value = -1;
static int hf_org_csapi_TpSimpleAttributeValue_FloatValue = -1;
static int hf_org_csapi_TpSimpleAttributeValue_DoubleValue = -1;
static int hf_org_csapi_TpAttributeValue_TpAttributeValue = -1;
static int hf_org_csapi_TpAttributeValue_XMLValue = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_TpFwEventCriteria = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_EventNameUndefined = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_ServiceTypeNameList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_ServiceTypeNameList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_UnavailableServiceTypeNameList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_UnavailableServiceTypeNameList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_CompatibleServiceTypeNameList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_CompatibleServiceTypeNameList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_SessionCreatedList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_SessionCreatedList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_SessionTerminatedList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_SessionTerminatedList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_AgreementSignedList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_AgreementSignedList = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_AgreementEndedList_loop = -1;
static int hf_org_csapi_fw_TpFwEventCriteria_AgreementEndedList = -1;
static int hf_org_csapi_fw_TpLoadStatisticEntityID_TpLoadStatisticEntityID = -1;
static int hf_org_csapi_fw_TpLoadStatisticEntityID_FrameworkID = -1;
static int hf_org_csapi_fw_TpLoadStatisticEntityID_ServiceID = -1;
static int hf_org_csapi_fw_TpLoadStatisticEntityID_ClientAppID = -1;
static int hf_org_csapi_fw_TpLoadStatisticInfo_TpLoadStatisticInfo = -1;
static int hf_org_csapi_fw_TpLoadStatisticInfo_LoadStatisticError = -1;
static int hf_org_csapi_fw_TpDomainID_TpDomainID = -1;
static int hf_org_csapi_fw_TpDomainID_FwID = -1;
static int hf_org_csapi_fw_TpDomainID_ClientAppID = -1;
static int hf_org_csapi_fw_TpDomainID_EntOpID = -1;
static int hf_org_csapi_fw_TpDomainID_ServiceID = -1;
static int hf_org_csapi_fw_TpDomainID_ServiceSupplierID = -1;
static int hf_org_csapi_fw_TpMigrationAdditionalInfo_TpMigrationAdditionalInfo = -1;
static int hf_org_csapi_fw_TpMigrationAdditionalInfo_Dummy = -1;
static int hf_org_csapi_fw_TpFwEventInfo_TpFwEventInfo = -1;
static int hf_org_csapi_fw_TpFwEventInfo_EventNameUndefined = -1;
static int hf_org_csapi_fw_TpFwEventInfo_ServiceIDList_loop = -1;
static int hf_org_csapi_fw_TpFwEventInfo_ServiceIDList = -1;
static int hf_org_csapi_fw_TpFwEventInfo_UnavailableServiceIDList_loop = -1;
static int hf_org_csapi_fw_TpFwEventInfo_UnavailableServiceIDList = -1;
static int hf_org_csapi_fw_TpFwEventInfo_AppSessionCreated = -1;
static int hf_org_csapi_fw_TpFwEventInfo_AppSessionTerminated = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_TpUIVariableInfo = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_VariablePartInteger = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_VariablePartAddress = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_VariablePartTime = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_VariablePartDate = -1;
static int hf_org_csapi_ui_TpUIVariableInfo_VariablePartPrice = -1;
static int hf_org_csapi_ui_TpUIInfo_TpUIInfo = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoID = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoAddress = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoBinData_loop = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoBinData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoUUEncData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoMimeData_loop = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoMimeData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoWaveData_loop = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoWaveData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoAuData_loop = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoAuData = -1;
static int hf_org_csapi_ui_TpUIInfo_InfoVXMLData = -1;
static int hf_org_csapi_cc_TpCallAdditionalErrorInfo_TpCallAdditionalErrorInfo = -1;
static int hf_org_csapi_cc_TpCallAdditionalErrorInfo_CallErrorInvalidAddress = -1;
static int hf_org_csapi_cc_TpCallAdditionalErrorInfo_Dummy = -1;
static int hf_org_csapi_cc_TpCallLoadControlMechanism_TpCallLoadControlMechanism = -1;
static int hf_org_csapi_cc_TpCallLoadControlMechanism_CallLoadControlPerInterval = -1;
static int hf_org_csapi_cc_TpCallAdditionalTreatmentInfo_TpCallAdditionalTreatmentInfo = -1;
static int hf_org_csapi_cc_TpCallAdditionalTreatmentInfo_Dummy = -1;
static int hf_org_csapi_cc_TpCallPartyToChargeAdditionalInfo_TpCallPartyToChargeAdditionalInfo = -1;
static int hf_org_csapi_cc_TpCallPartyToChargeAdditionalInfo_Dummy = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_TpCallAppInfo = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppAlertingMechanism = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppNetworkAccessType = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppTeleService = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppBearerService = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppPartyCategory = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_CallAppGenericInfo = -1;
static int hf_org_csapi_cc_gccs_TpCallAppInfo_Dummy = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportInfo_TpCallAdditionalReportInfo = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportInfo_QueueStatus = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportInfo_Dummy = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportCriteria_TpCallAdditionalReportCriteria = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportCriteria_NoAnswerDuration = -1;
static int hf_org_csapi_cc_gccs_TpCallAdditionalReportCriteria_Dummy = -1;
static int hf_org_csapi_cc_TpCallAdditionalEventInfo_TpCallAdditionalEventInfo = -1;
static int hf_org_csapi_cc_TpCallAdditionalEventInfo_OriginatingReleaseCause = -1;
static int hf_org_csapi_cc_TpCallAdditionalEventInfo_TerminatingReleaseCause = -1;
static int hf_org_csapi_cc_TpCallAdditionalEventInfo_Dummy = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_TpAdditionalCallEventCriteria = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_MinAddressLength = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_OriginatingServiceCode_loop = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_OriginatingReleaseCauseSet_loop = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_OriginatingReleaseCauseSet = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_TerminatingReleaseCauseSet_loop = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_TerminatingReleaseCauseSet = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_TerminatingServiceCode_loop = -1;
static int hf_org_csapi_cc_TpAdditionalCallEventCriteria_Dummy = -1;
static int hf_org_csapi_cc_TpCallAppInfo_TpCallAppInfo = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppAlertingMechanism = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppNetworkAccessType = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppTeleService = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppBearerService = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppPartyCategory = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppGenericInfo = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallHighProbabilityCompletion = -1;
static int hf_org_csapi_cc_TpCallAppInfo_CallAppCarrier_loop = -1;
static int hf_org_csapi_cc_TpCallAppInfo_Dummy = -1;
static int hf_org_csapi_cc_mpccs_TpAppMultiPartyCallBack_TpAppMultiPartyCallBack = -1;
static int hf_org_csapi_cc_mpccs_TpAppMultiPartyCallBack_Dummy = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamDataTypeRequest_TpMediaStreamDataTypeRequest = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamDataTypeRequest_Audio = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamDataTypeRequest_Video = -1;
static int hf_org_csapi_cc_mmccs_TpMediaStreamDataTypeRequest_Data = -1;
static int hf_org_csapi_cc_mmccs_TpAppMultiMediaCallBack_TpAppMultiMediaCallBack = -1;
static int hf_org_csapi_cc_mmccs_TpAppMultiMediaCallBack_Dummy = -1;
static int hf_org_csapi_cc_cccs_TpConfPolicy_TpConfPolicy = -1;
static int hf_org_csapi_cc_cccs_TpConfPolicy_Dummy = -1;
static int hf_org_csapi_ui_TpUITargetObject_TpUITargetObject = -1;
static int hf_org_csapi_mm_TpBindingEntry_TpBindingEntry = -1;
static int hf_org_csapi_mm_TpBindingEntry_UBExpires = -1;
static int hf_org_csapi_mm_TpBindingEntry_UBPreference = -1;
static int hf_org_csapi_mm_TpBindingEntry_Dummy = -1;
static int hf_org_csapi_dsc_TpDataSessionChargeOrder_TpDataSessionChargeOrder = -1;
static int hf_org_csapi_dsc_TpDataSessionChargeOrder_NetworkCharge = -1;
static int hf_org_csapi_dsc_TpDataSessionAdditionalErrorInfo_TpDataSessionAdditionalErrorInfo = -1;
static int hf_org_csapi_dsc_TpDataSessionAdditionalErrorInfo_DataSessionErrorInvalidAddress = -1;
static int hf_org_csapi_dsc_TpDataSessionAdditionalErrorInfo_Dummy = -1;
static int hf_org_csapi_dsc_TpDataSessionAdditionalReportInfo_TpDataSessionAdditionalReportInfo = -1;
static int hf_org_csapi_dsc_TpDataSessionAdditionalReportInfo_Dummy = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_TpMessageInfoProperty = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageID = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageSubject = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageDateSent = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageDateReceived = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageDateChanged = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageSize = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessagePriority = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageFormat = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageFolder = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_MessagingMessageStatus = -1;
static int hf_org_csapi_gms_TpMessageInfoProperty_Dummy = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_TpMailboxInfoProperty = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_MessagingMailboxOwner = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_MessagingMailboxFolder = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_MessagingMailboxDateCreated = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_MessagingMailboxDateChanged = -1;
static int hf_org_csapi_gms_TpMailboxInfoProperty_Dummy = -1;
static int hf_org_csapi_gms_TpMessagingEventInfo_TpMessagingEventInfo = -1;
static int hf_org_csapi_gms_TpMessagingEventInfo_EventNameUndefined = -1;
static int hf_org_csapi_gms_TpMessagingEventCriteria_TpMessagingEventCriteria = -1;
static int hf_org_csapi_gms_TpMessagingEventCriteria_Dummy = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_TpFolderInfoProperty = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_MessagingFolderID = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_MessagingFolderMessage = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_MessagingFolderSubfolder = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_MessagingFolderDateCreated = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_MessagingFolderDateChanged = -1;
static int hf_org_csapi_gms_TpFolderInfoProperty_Dummy = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_TpChargingParameterValue = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_IntValue = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_FloatValue = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_StringValue = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_BooleanValue = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_OctetValue_loop = -1;
static int hf_org_csapi_cs_TpChargingParameterValue_OctetValue = -1;
static int hf_org_csapi_cs_TpAppInformation_TpAppInformation = -1;
static int hf_org_csapi_cs_TpAppInformation_Timestamp = -1;
static int hf_org_csapi_policy_TpPolicyType_TpPolicyType = -1;
static int hf_org_csapi_policy_TpPolicyType_SimpleType = -1;
static int hf_org_csapi_policy_TpPolicyType_StructuredType = -1;
static int hf_org_csapi_policy_TpPolicyType_XMLString = -1;
static int hf_org_csapi_pam_TpPAMContextData_TpPAMContextData = -1;
static int hf_org_csapi_pam_TpPAMContextData_Dummy = -1;
static int hf_org_csapi_pam_TpPAMEventInfo_TpPAMEventInfo = -1;
static int hf_org_csapi_pam_TpPAMNotificationInfo_TpPAMNotificationInfo = -1;
static int hf_org_csapi_pam_TpPAMPreferenceData_TpPAMPreferenceData = -1;
static int hf_org_csapi_pam_TpPAMPreferenceData_Dummy = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_TpFolderInfoProperty = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_FolderDateCreated = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_FolderDateChanged = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_FolderSize = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_FolderNumberOfMessages = -1;
static int hf_org_csapi_mmm_TpFolderInfoProperty_Dummy = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_TpMailboxInfoProperty = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_MailboxOwner = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_MailboxDateCreated = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_MailboxDateChanged = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_MailboxSize = -1;
static int hf_org_csapi_mmm_TpMailboxInfoProperty_Dummy = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_TpMessageInfoProperty = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_MessageDateCreated = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_MessageDateReceived = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_MessageDateChanged = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_MessageSize = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_MessageStatus = -1;
static int hf_org_csapi_mmm_TpMessageInfoProperty_Dummy = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_TpMessageHeaderField = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_DateSent = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_From_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_ReplyTo_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_To_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Cc_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Bcc_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_RFC822MessageID = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_InReplyTo_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_InReplyTo = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_References_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_References = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Subject = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Comments = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Keywords_loop = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Keywords = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeVersion = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeContent = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeEncoding = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeID = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeDescription = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_MimeDisposition = -1;
static int hf_org_csapi_mmm_TpMessageHeaderField_Priority = -1;
static int hf_org_csapi_mmm_TpDeliveryTime_TpDeliveryTime = -1;
static int hf_org_csapi_mmm_TpDeliveryTime_DeliveryTime = -1;
static int hf_org_csapi_mmm_TpDeliveryTime_Dummy = -1;
static int hf_org_csapi_mmm_TpMessageTreatment_TpMessageTreatment = -1;
static int hf_org_csapi_mmm_TpMessageTreatment_DeliveryReport = -1;
static int hf_org_csapi_mmm_TpMessageTreatment_BillingID = -1;
static int hf_org_csapi_mmm_TpMessageTreatment_ValidityTime = -1;
static int hf_org_csapi_mmm_TpMessagingEventCriteria_TpMessagingEventCriteria = -1;
static int hf_org_csapi_mmm_TpMessagingEventCriteria_Dummy = -1;
static int hf_org_csapi_mmm_TpMessagingEventInfo_TpMessagingEventInfo = -1;
static int hf_org_csapi_mmm_TpMessagingEventInfo_EventNameUndefined = -1;
        /* Expert info filters */
static expert_field ei_parlay_unknown_giop_msg = EI_INIT;
static expert_field ei_parlay_unknown_exception = EI_INIT;
static expert_field ei_parlay_unknown_reply_status = EI_INIT;


static proto_tree *start_dissecting(tvbuff_t *tvb, packet_info *pinfo, proto_tree *ptree, int *offset);


/* Struct prototype declaration Start */

/* Struct = IDL:org/csapi/TpAddress:1.0 */
static void decode_org_csapi_TpAddress_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpAddressRange:1.0 */
static void decode_org_csapi_TpAddressRange_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpCAIElements:1.0 */
static void decode_org_csapi_TpCAIElements_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpChargeAdviceInfo:1.0 */
static void decode_org_csapi_TpChargeAdviceInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpChargePerTime:1.0 */
static void decode_org_csapi_TpChargePerTime_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpAoCInfo:1.0 */
static void decode_org_csapi_TpAoCInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpTimeInterval:1.0 */
static void decode_org_csapi_TpTimeInterval_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpStructuredAttributeValue:1.0 */
static void decode_org_csapi_TpStructuredAttributeValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/TpAttribute:1.0 */
static void decode_org_csapi_TpAttribute_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpFaultStats:1.0 */
static void decode_org_csapi_fw_TpFaultStats_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpFaultStatsRecord:1.0 */
static void decode_org_csapi_fw_TpFaultStatsRecord_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpLoadPolicy:1.0 */
static void decode_org_csapi_fw_TpLoadPolicy_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpLoadStatisticData:1.0 */
static void decode_org_csapi_fw_TpLoadStatisticData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpLoadThreshold:1.0 */
static void decode_org_csapi_fw_TpLoadThreshold_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpLoadInitVal:1.0 */
static void decode_org_csapi_fw_TpLoadInitVal_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpProperty:1.0 */
static void decode_org_csapi_fw_TpProperty_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpClientAppDescription:1.0 */
static void decode_org_csapi_fw_TpClientAppDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpEntOp:1.0 */
static void decode_org_csapi_fw_TpEntOp_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpSag:1.0 */
static void decode_org_csapi_fw_TpSag_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceProperty:1.0 */
static void decode_org_csapi_fw_TpServiceProperty_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceDescription:1.0 */
static void decode_org_csapi_fw_TpServiceDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpService:1.0 */
static void decode_org_csapi_fw_TpService_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceProfileDescription:1.0 */
static void decode_org_csapi_fw_TpServiceProfileDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceTypeProperty:1.0 */
static void decode_org_csapi_fw_TpServiceTypeProperty_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceTypeDescription:1.0 */
static void decode_org_csapi_fw_TpServiceTypeDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpSignatureAndServiceMgr:1.0 */
static void decode_org_csapi_fw_TpSignatureAndServiceMgr_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpPerson:1.0 */
static void decode_org_csapi_fw_TpPerson_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceContractDescription:1.0 */
static void decode_org_csapi_fw_TpServiceContractDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpLoadStatistic:1.0 */
static void decode_org_csapi_fw_TpLoadStatistic_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceContract:1.0 */
static void decode_org_csapi_fw_TpServiceContract_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceProfile:1.0 */
static void decode_org_csapi_fw_TpServiceProfile_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpAuthDomain:1.0 */
static void decode_org_csapi_fw_TpAuthDomain_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpSagProfilePair:1.0 */
static void decode_org_csapi_fw_TpSagProfilePair_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpAddSagMembersConflict:1.0 */
static void decode_org_csapi_fw_TpAddSagMembersConflict_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpAssignSagToServiceProfileConflict:1.0 */
static void decode_org_csapi_fw_TpAssignSagToServiceProfileConflict_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpServiceTypePropertyValue:1.0 */
static void decode_org_csapi_fw_TpServiceTypePropertyValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpFwMigrationServiceAvailableInfo:1.0 */
static void decode_org_csapi_fw_TpFwMigrationServiceAvailableInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/fw/TpFwAgreementInfo:1.0 */
static void decode_org_csapi_fw_TpFwAgreementInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIMessageCriteria:1.0 */
static void decode_org_csapi_ui_TpUIMessageCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIEventInfo:1.0 */
static void decode_org_csapi_ui_TpUIEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIEventCriteria:1.0 */
static void decode_org_csapi_ui_TpUIEventCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIEventCriteriaResult:1.0 */
static void decode_org_csapi_ui_TpUIEventCriteriaResult_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIEventNotificationInfo:1.0 */
static void decode_org_csapi_ui_TpUIEventNotificationInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIRecognitionProperty:1.0 */
static void decode_org_csapi_ui_TpUIRecognitionProperty_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIRecognitionCriteria:1.0 */
static void decode_org_csapi_ui_TpUIRecognitionCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUICollectCriteria:1.0 */
static void decode_org_csapi_ui_TpUICollectCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIWordOverride:1.0 */
static void decode_org_csapi_ui_TpUIWordOverride_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUISynthesisInfoData:1.0 */
static void decode_org_csapi_ui_TpUISynthesisInfoData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallError:1.0 */
static void decode_org_csapi_cc_TpCallError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallEndedReport:1.0 */
static void decode_org_csapi_cc_TpCallEndedReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallInfoReport:1.0 */
static void decode_org_csapi_cc_TpCallInfoReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallServiceCode:1.0 */
static void decode_org_csapi_cc_TpCallServiceCode_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallTreatment:1.0 */
static void decode_org_csapi_cc_TpCallTreatment_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallChargePlan:1.0 */
static void decode_org_csapi_cc_TpCallChargePlan_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallEventCriteria:1.0 */
static void decode_org_csapi_cc_gccs_TpCallEventCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallEventCriteriaResult:1.0 */
static void decode_org_csapi_cc_gccs_TpCallEventCriteriaResult_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallReleaseCause:1.0 */
static void decode_org_csapi_cc_gccs_TpCallReleaseCause_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallReport:1.0 */
static void decode_org_csapi_cc_gccs_TpCallReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallReportRequest:1.0 */
static void decode_org_csapi_cc_gccs_TpCallReportRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallEventInfo:1.0 */
static void decode_org_csapi_cc_gccs_TpCallEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallEndedReport:1.0 */
static void decode_org_csapi_cc_gccs_TpCallEndedReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallInfoReport:1.0 */
static void decode_org_csapi_cc_gccs_TpCallInfoReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallTreatment:1.0 */
static void decode_org_csapi_cc_gccs_TpCallTreatment_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/gccs/TpCallIdentifier:1.0 */
static void decode_org_csapi_cc_gccs_TpCallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallNotificationScope:1.0 */
static void decode_org_csapi_cc_TpCallNotificationScope_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallNotificationReportScope:1.0 */
static void decode_org_csapi_cc_TpCallNotificationReportScope_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallEventRequest:1.0 */
static void decode_org_csapi_cc_TpCallEventRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallNotificationRequest:1.0 */
static void decode_org_csapi_cc_TpCallNotificationRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpNotificationRequested:1.0 */
static void decode_org_csapi_cc_TpNotificationRequested_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallLegConnectionProperties:1.0 */
static void decode_org_csapi_cc_TpCallLegConnectionProperties_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallEventInfo:1.0 */
static void decode_org_csapi_cc_TpCallEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpNotificationRequestedSetEntry:1.0 */
static void decode_org_csapi_cc_TpNotificationRequestedSetEntry_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCarrier:1.0 */
static void decode_org_csapi_cc_TpCarrier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallNotificationInfo:1.0 */
static void decode_org_csapi_cc_TpCallNotificationInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallLegInfoReport:1.0 */
static void decode_org_csapi_cc_TpCallLegInfoReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/TpCallLegProperty:1.0 */
static void decode_org_csapi_cc_TpCallLegProperty_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mpccs/TpMultiPartyCallIdentifier:1.0 */
static void decode_org_csapi_cc_mpccs_TpMultiPartyCallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mpccs/TpCallLegIdentifier:1.0 */
static void decode_org_csapi_cc_mpccs_TpCallLegIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mpccs/TpAppCallLegCallBack:1.0 */
static void decode_org_csapi_cc_mpccs_TpAppCallLegCallBack_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpCallSuperviseVolume:1.0 */
static void decode_org_csapi_cc_mmccs_TpCallSuperviseVolume_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpMediaStreamRequest:1.0 */
static void decode_org_csapi_cc_mmccs_TpMediaStreamRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpMediaStream:1.0 */
static void decode_org_csapi_cc_mmccs_TpMediaStream_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpNotificationMediaRequest:1.0 */
static void decode_org_csapi_cc_mmccs_TpNotificationMediaRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpMediaNotificationRequested:1.0 */
static void decode_org_csapi_cc_mmccs_TpMediaNotificationRequested_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpMultiMediaCallIdentifier:1.0 */
static void decode_org_csapi_cc_mmccs_TpMultiMediaCallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpMultiMediaCallLegIdentifier:1.0 */
static void decode_org_csapi_cc_mmccs_TpMultiMediaCallLegIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/mmccs/TpAppMultiMediaCallLegCallBack:1.0 */
static void decode_org_csapi_cc_mmccs_TpAppMultiMediaCallLegCallBack_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpMonoMediaConfPolicy:1.0 */
static void decode_org_csapi_cc_cccs_TpMonoMediaConfPolicy_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpJoinEventInfo:1.0 */
static void decode_org_csapi_cc_cccs_TpJoinEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpConfSearchCriteria:1.0 */
static void decode_org_csapi_cc_cccs_TpConfSearchCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpConfSearchResult:1.0 */
static void decode_org_csapi_cc_cccs_TpConfSearchResult_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpMultiMediaConfPolicy:1.0 */
static void decode_org_csapi_cc_cccs_TpMultiMediaConfPolicy_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpResourceReservation:1.0 */
static void decode_org_csapi_cc_cccs_TpResourceReservation_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpConfCallIdentifier:1.0 */
static void decode_org_csapi_cc_cccs_TpConfCallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cc/cccs/TpSubConfCallIdentifier:1.0 */
static void decode_org_csapi_cc_cccs_TpSubConfCallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUIIdentifier:1.0 */
static void decode_org_csapi_ui_TpUIIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/ui/TpUICallIdentifier:1.0 */
static void decode_org_csapi_ui_TpUICallIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpLocationResponseTime:1.0 */
static void decode_org_csapi_mm_TpLocationResponseTime_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpLocationTrigger:1.0 */
static void decode_org_csapi_mm_TpLocationTrigger_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpLocationRequest:1.0 */
static void decode_org_csapi_mm_TpLocationRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpGeographicalPosition:1.0 */
static void decode_org_csapi_mm_TpGeographicalPosition_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpMobilityStopAssignmentData:1.0 */
static void decode_org_csapi_mm_TpMobilityStopAssignmentData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUlExtendedData:1.0 */
static void decode_org_csapi_mm_TpUlExtendedData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserLocation:1.0 */
static void decode_org_csapi_mm_TpUserLocation_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserLocationExtended:1.0 */
static void decode_org_csapi_mm_TpUserLocationExtended_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpLocationTriggerCamel:1.0 */
static void decode_org_csapi_mm_TpLocationTriggerCamel_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserLocationCamel:1.0 */
static void decode_org_csapi_mm_TpUserLocationCamel_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserLocationEmergencyRequest:1.0 */
static void decode_org_csapi_mm_TpUserLocationEmergencyRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserLocationEmergency:1.0 */
static void decode_org_csapi_mm_TpUserLocationEmergency_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserStatus:1.0 */
static void decode_org_csapi_mm_TpUserStatus_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpTriggeredStatusRequest:1.0 */
static void decode_org_csapi_mm_TpTriggeredStatusRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpTriggeredStatusRequestSetEntry:1.0 */
static void decode_org_csapi_mm_TpTriggeredStatusRequestSetEntry_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpPeriodicLocationRequest:1.0 */
static void decode_org_csapi_mm_TpPeriodicLocationRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpPeriodicLocationRequestSetEntry:1.0 */
static void decode_org_csapi_mm_TpPeriodicLocationRequestSetEntry_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpTriggeredLocationRequest:1.0 */
static void decode_org_csapi_mm_TpTriggeredLocationRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpTriggeredLocationRequestSetEntry:1.0 */
static void decode_org_csapi_mm_TpTriggeredLocationRequestSetEntry_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserStatusIndicatorExtended:1.0 */
static void decode_org_csapi_mm_TpUserStatusIndicatorExtended_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserInfo:1.0 */
static void decode_org_csapi_mm_TpUserInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpNetworkStatusIndicator:1.0 */
static void decode_org_csapi_mm_TpNetworkStatusIndicator_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpUserStatusExtended:1.0 */
static void decode_org_csapi_mm_TpUserStatusExtended_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mm/TpBindingNotificationCriteria:1.0 */
static void decode_org_csapi_mm_TpBindingNotificationCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/termcap/TpTerminalCapabilities:1.0 */
static void decode_org_csapi_termcap_TpTerminalCapabilities_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/termcap/TpTerminalCapabilityScope:1.0 */
static void decode_org_csapi_termcap_TpTerminalCapabilityScope_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpChargePerVolume:1.0 */
static void decode_org_csapi_dsc_TpChargePerVolume_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionChargePlan:1.0 */
static void decode_org_csapi_dsc_TpDataSessionChargePlan_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionError:1.0 */
static void decode_org_csapi_dsc_TpDataSessionError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionEventCriteria:1.0 */
static void decode_org_csapi_dsc_TpDataSessionEventCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionEventInfo:1.0 */
static void decode_org_csapi_dsc_TpDataSessionEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionReleaseCause:1.0 */
static void decode_org_csapi_dsc_TpDataSessionReleaseCause_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionReport:1.0 */
static void decode_org_csapi_dsc_TpDataSessionReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionReportRequest:1.0 */
static void decode_org_csapi_dsc_TpDataSessionReportRequest_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionSuperviseVolume:1.0 */
static void decode_org_csapi_dsc_TpDataSessionSuperviseVolume_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionEventCriteriaResult:1.0 */
static void decode_org_csapi_dsc_TpDataSessionEventCriteriaResult_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/dsc/TpDataSessionIdentifier:1.0 */
static void decode_org_csapi_dsc_TpDataSessionIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/gms/TpGMSNewMessageArrivedInfo:1.0 */
static void decode_org_csapi_gms_TpGMSNewMessageArrivedInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/gms/TpGMSNewMessageArrivedCriteria:1.0 */
static void decode_org_csapi_gms_TpGMSNewMessageArrivedCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/gms/TpMailboxIdentifier:1.0 */
static void decode_org_csapi_gms_TpMailboxIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/gms/TpMailboxFolderIdentifier:1.0 */
static void decode_org_csapi_gms_TpMailboxFolderIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagTimePeriod:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagTimePeriod_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagTimeOfDay:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagTimeOfDay_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagString:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagString_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagMonth:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagMonth_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagInt:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagInt_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagDir:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagDir_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagDayOfWeek:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagDayOfWeek_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagDateTime:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagDateTime_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpLossDescriptor:1.0 */
static void decode_org_csapi_cm_TpLossDescriptor_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpLoadDescriptor:1.0 */
static void decode_org_csapi_cm_TpLoadDescriptor_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpJitterDescriptor:1.0 */
static void decode_org_csapi_cm_TpJitterDescriptor_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpEndpoint:1.0 */
static void decode_org_csapi_cm_TpEndpoint_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpDelayDescriptor:1.0 */
static void decode_org_csapi_cm_TpDelayDescriptor_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpNameDescrpTagExcessLoadAction:1.0 */
static void decode_org_csapi_cm_TpNameDescrpTagExcessLoadAction_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpValidityInfo:1.0 */
static void decode_org_csapi_cm_TpValidityInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpProvisionedQoSInfo:1.0 */
static void decode_org_csapi_cm_TpProvisionedQoSInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpPipeQoSInfo:1.0 */
static void decode_org_csapi_cm_TpPipeQoSInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpDsCodepoint:1.0 */
static void decode_org_csapi_cm_TpDsCodepoint_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cm/TpIPSubnet:1.0 */
static void decode_org_csapi_cm_TpIPSubnet_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpBalanceInfo:1.0 */
static void decode_org_csapi_am_TpBalanceInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpChargingEventInfo:1.0 */
static void decode_org_csapi_am_TpChargingEventInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpBalance:1.0 */
static void decode_org_csapi_am_TpBalance_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpTransactionHistory:1.0 */
static void decode_org_csapi_am_TpTransactionHistory_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpChargingEventCriteria:1.0 */
static void decode_org_csapi_am_TpChargingEventCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpChargingEventCriteriaResult:1.0 */
static void decode_org_csapi_am_TpChargingEventCriteriaResult_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpBalanceExpiryDate:1.0 */
static void decode_org_csapi_am_TpBalanceExpiryDate_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/am/TpVoucher:1.0 */
static void decode_org_csapi_am_TpVoucher_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpMerchantAccountID:1.0 */
static void decode_org_csapi_cs_TpMerchantAccountID_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpCorrelationID:1.0 */
static void decode_org_csapi_cs_TpCorrelationID_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpAmount:1.0 */
static void decode_org_csapi_cs_TpAmount_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpChargingPrice:1.0 */
static void decode_org_csapi_cs_TpChargingPrice_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpVolume:1.0 */
static void decode_org_csapi_cs_TpVolume_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpChargingSessionID:1.0 */
static void decode_org_csapi_cs_TpChargingSessionID_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpPriceVolume:1.0 */
static void decode_org_csapi_cs_TpPriceVolume_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpApplicationDescription:1.0 */
static void decode_org_csapi_cs_TpApplicationDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/cs/TpChargingParameter:1.0 */
static void decode_org_csapi_cs_TpChargingParameter_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyEvent:1.0 */
static void decode_org_csapi_policy_TpPolicyEvent_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyNameValue:1.0 */
static void decode_org_csapi_policy_TpPolicyNameValue_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyType/TpPolicyRecordType:1.0 */
static void decode_org_csapi_policy_TpPolicyType_TpPolicyRecordType_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyType/TpPolicyListType:1.0 */
static void decode_org_csapi_policy_TpPolicyType_TpPolicyListType_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyVar:1.0 */
static void decode_org_csapi_policy_TpPolicyVar_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyConditionListElement:1.0 */
static void decode_org_csapi_policy_TpPolicyConditionListElement_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/policy/TpPolicyActionListElement:1.0 */
static void decode_org_csapi_policy_TpPolicyActionListElement_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAttributeDef:1.0 */
static void decode_org_csapi_pam_TpPAMAttributeDef_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAttribute:1.0 */
static void decode_org_csapi_pam_TpPAMAttribute_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMPresenceData:1.0 */
static void decode_org_csapi_pam_TpPAMPresenceData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAvailabilityProfile:1.0 */
static void decode_org_csapi_pam_TpPAMAvailabilityProfile_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMCommunicationContext:1.0 */
static void decode_org_csapi_pam_TpPAMCommunicationContext_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMContext:1.0 */
static void decode_org_csapi_pam_TpPAMContext_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAccessControlData:1.0 */
static void decode_org_csapi_pam_TpPAMAccessControlData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMICEventData:1.0 */
static void decode_org_csapi_pam_TpPAMICEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMICNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMICNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMIDEventData:1.0 */
static void decode_org_csapi_pam_TpPAMIDEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMIDNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMIDNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMGMCEventData:1.0 */
static void decode_org_csapi_pam_TpPAMGMCEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMGMCNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMGMCNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMACEventData:1.0 */
static void decode_org_csapi_pam_TpPAMACEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMACNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMACNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMADEventData:1.0 */
static void decode_org_csapi_pam_TpPAMADEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMADNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMADNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAAEventData:1.0 */
static void decode_org_csapi_pam_TpPAMAAEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAANotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMAANotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAUEventData:1.0 */
static void decode_org_csapi_pam_TpPAMAUEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAUNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMAUNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMCCEventData:1.0 */
static void decode_org_csapi_pam_TpPAMCCEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMCCNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMCCNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMACPSEventData:1.0 */
static void decode_org_csapi_pam_TpPAMACPSEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMACPSNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMACPSNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAPSEventData:1.0 */
static void decode_org_csapi_pam_TpPAMAPSEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAPSNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMAPSNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMIPSEventData:1.0 */
static void decode_org_csapi_pam_TpPAMIPSEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMIPSNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMIPSNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAVCEventData:1.0 */
static void decode_org_csapi_pam_TpPAMAVCEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMAVCNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMAVCNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMWCEventData:1.0 */
static void decode_org_csapi_pam_TpPAMWCEventData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMWCNotificationData:1.0 */
static void decode_org_csapi_pam_TpPAMWCNotificationData_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/pam/TpPAMErrorInfo:1.0 */
static void decode_org_csapi_pam_TpPAMErrorInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMailboxIdentifier:1.0 */
static void decode_org_csapi_mmm_TpMailboxIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMultiMediaMessagingIdentifier:1.0 */
static void decode_org_csapi_mmm_TpMultiMediaMessagingIdentifier_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpListMessagesCriteria:1.0 */
static void decode_org_csapi_mmm_TpListMessagesCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMailboxFolderStatusInformation:1.0 */
static void decode_org_csapi_mmm_TpMailboxFolderStatusInformation_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMessageDescription:1.0 */
static void decode_org_csapi_mmm_TpMessageDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpBodyPartDescription:1.0 */
static void decode_org_csapi_mmm_TpBodyPartDescription_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpBodyPart:1.0 */
static void decode_org_csapi_mmm_TpBodyPart_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpGenericHeaderField:1.0 */
static void decode_org_csapi_mmm_TpGenericHeaderField_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMessageInfoPropertyError:1.0 */
static void decode_org_csapi_mmm_TpMessageInfoPropertyError_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpNewMailboxMessageArrivedCriteria:1.0 */
static void decode_org_csapi_mmm_TpNewMailboxMessageArrivedCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpNewMailboxMessageArrivedInfo:1.0 */
static void decode_org_csapi_mmm_TpNewMailboxMessageArrivedInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpQueryStatusReport:1.0 */
static void decode_org_csapi_mmm_TpQueryStatusReport_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpTerminatingAddressList:1.0 */
static void decode_org_csapi_mmm_TpTerminatingAddressList_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpNewMessageArrivedCriteria:1.0 */
static void decode_org_csapi_mmm_TpNewMessageArrivedCriteria_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMessagingNotificationRequested:1.0 */
static void decode_org_csapi_mmm_TpMessagingNotificationRequested_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpMessagingNotificationRequestedSetEntry:1.0 */
static void decode_org_csapi_mmm_TpMessagingNotificationRequestedSetEntry_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct = IDL:org/csapi/mmm/TpNewMessageArrivedInfo:1.0 */
static void decode_org_csapi_mmm_TpNewMessageArrivedInfo_st(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Struct prototype declaration End */

/* Union prototype declaration Start */

/* Union = IDL:org/csapi/TpAoCOrder:1.0 */
static void decode_org_csapi_TpAoCOrder_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/TpSimpleAttributeValue:1.0 */
static void decode_org_csapi_TpSimpleAttributeValue_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/TpAttributeValue:1.0 */
static void decode_org_csapi_TpAttributeValue_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpFwEventCriteria:1.0 */
static void decode_org_csapi_fw_TpFwEventCriteria_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpLoadStatisticEntityID:1.0 */
static void decode_org_csapi_fw_TpLoadStatisticEntityID_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpLoadStatisticInfo:1.0 */
static void decode_org_csapi_fw_TpLoadStatisticInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpDomainID:1.0 */
static void decode_org_csapi_fw_TpDomainID_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpMigrationAdditionalInfo:1.0 */
static void decode_org_csapi_fw_TpMigrationAdditionalInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/fw/TpFwEventInfo:1.0 */
static void decode_org_csapi_fw_TpFwEventInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/ui/TpUIVariableInfo:1.0 */
static void decode_org_csapi_ui_TpUIVariableInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/ui/TpUIInfo:1.0 */
static void decode_org_csapi_ui_TpUIInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallAdditionalErrorInfo:1.0 */
static void decode_org_csapi_cc_TpCallAdditionalErrorInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallLoadControlMechanism:1.0 */
static void decode_org_csapi_cc_TpCallLoadControlMechanism_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallAdditionalTreatmentInfo:1.0 */
static void decode_org_csapi_cc_TpCallAdditionalTreatmentInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallPartyToChargeAdditionalInfo:1.0 */
static void decode_org_csapi_cc_TpCallPartyToChargeAdditionalInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/gccs/TpCallAppInfo:1.0 */
static void decode_org_csapi_cc_gccs_TpCallAppInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/gccs/TpCallAdditionalReportInfo:1.0 */
static void decode_org_csapi_cc_gccs_TpCallAdditionalReportInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/gccs/TpCallAdditionalReportCriteria:1.0 */
static void decode_org_csapi_cc_gccs_TpCallAdditionalReportCriteria_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallAdditionalEventInfo:1.0 */
static void decode_org_csapi_cc_TpCallAdditionalEventInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpAdditionalCallEventCriteria:1.0 */
static void decode_org_csapi_cc_TpAdditionalCallEventCriteria_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/TpCallAppInfo:1.0 */
static void decode_org_csapi_cc_TpCallAppInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/mpccs/TpAppMultiPartyCallBack:1.0 */
static void decode_org_csapi_cc_mpccs_TpAppMultiPartyCallBack_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/mmccs/TpMediaStreamDataTypeRequest:1.0 */
static void decode_org_csapi_cc_mmccs_TpMediaStreamDataTypeRequest_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/mmccs/TpAppMultiMediaCallBack:1.0 */
static void decode_org_csapi_cc_mmccs_TpAppMultiMediaCallBack_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cc/cccs/TpConfPolicy:1.0 */
static void decode_org_csapi_cc_cccs_TpConfPolicy_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/ui/TpUITargetObject:1.0 */
static void decode_org_csapi_ui_TpUITargetObject_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mm/TpBindingEntry:1.0 */
static void decode_org_csapi_mm_TpBindingEntry_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/dsc/TpDataSessionChargeOrder:1.0 */
static void decode_org_csapi_dsc_TpDataSessionChargeOrder_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/dsc/TpDataSessionAdditionalErrorInfo:1.0 */
static void decode_org_csapi_dsc_TpDataSessionAdditionalErrorInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/dsc/TpDataSessionAdditionalReportInfo:1.0 */
static void decode_org_csapi_dsc_TpDataSessionAdditionalReportInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/gms/TpMessageInfoProperty:1.0 */
static void decode_org_csapi_gms_TpMessageInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/gms/TpMailboxInfoProperty:1.0 */
static void decode_org_csapi_gms_TpMailboxInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/gms/TpMessagingEventInfo:1.0 */
static void decode_org_csapi_gms_TpMessagingEventInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/gms/TpMessagingEventCriteria:1.0 */
static void decode_org_csapi_gms_TpMessagingEventCriteria_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/gms/TpFolderInfoProperty:1.0 */
static void decode_org_csapi_gms_TpFolderInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cs/TpChargingParameterValue:1.0 */
static void decode_org_csapi_cs_TpChargingParameterValue_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/cs/TpAppInformation:1.0 */
static void decode_org_csapi_cs_TpAppInformation_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/policy/TpPolicyType:1.0 */
static void decode_org_csapi_policy_TpPolicyType_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/pam/TpPAMContextData:1.0 */
static void decode_org_csapi_pam_TpPAMContextData_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/pam/TpPAMEventInfo:1.0 */
static void decode_org_csapi_pam_TpPAMEventInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/pam/TpPAMNotificationInfo:1.0 */
static void decode_org_csapi_pam_TpPAMNotificationInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/pam/TpPAMPreferenceData:1.0 */
static void decode_org_csapi_pam_TpPAMPreferenceData_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpFolderInfoProperty:1.0 */
static void decode_org_csapi_mmm_TpFolderInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMailboxInfoProperty:1.0 */
static void decode_org_csapi_mmm_TpMailboxInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMessageInfoProperty:1.0 */
static void decode_org_csapi_mmm_TpMessageInfoProperty_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMessageHeaderField:1.0 */
static void decode_org_csapi_mmm_TpMessageHeaderField_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpDeliveryTime:1.0 */
static void decode_org_csapi_mmm_TpDeliveryTime_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMessageTreatment:1.0 */
static void decode_org_csapi_mmm_TpMessageTreatment_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMessagingEventCriteria:1.0 */
static void decode_org_csapi_mmm_TpMessagingEventCriteria_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);


/* Union = IDL:org/csapi/mmm/TpMessagingEventInfo:1.0 */
static void decode_org_csapi_mmm_TpMessagingEventInfo_un(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_);

/* Union prototype declaration End */
/*
 * IDL Enums Start
 */

/*
 * Enum = IDL:org/csapi/TpAddressError:1.0
 */
static const value_string org_csapi_TpAddressError[] = {

    { 0, "P_ADDRESS_INVALID_UNDEFINED" },
    { 1, "P_ADDRESS_INVALID_MISSING" },
    { 2, "P_ADDRESS_INVALID_MISSING_ELEMENT" },
    { 3, "P_ADDRESS_INVALID_OUT_OF_RANGE" },
    { 4, "P_ADDRESS_INVALID_INCOMPLETE" },
    { 5, "P_ADDRESS_INVALID_CANNOT_DECODE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpAddressPlan:1.0
 */
static const value_string org_csapi_TpAddressPlan[] = {

    { 0, "P_ADDRESS_PLAN_NOT_PRESENT" },
    { 1, "P_ADDRESS_PLAN_UNDEFINED" },
    { 2, "P_ADDRESS_PLAN_IP" },
    { 3, "P_ADDRESS_PLAN_MULTICAST" },
    { 4, "P_ADDRESS_PLAN_UNICAST" },
    { 5, "P_ADDRESS_PLAN_E164" },
    { 6, "P_ADDRESS_PLAN_AESA" },
    { 7, "P_ADDRESS_PLAN_URL" },
    { 8, "P_ADDRESS_PLAN_NSAP" },
    { 9, "P_ADDRESS_PLAN_SMTP" },
    { 10, "P_ADDRESS_PLAN_MSMAIL" },
    { 11, "P_ADDRESS_PLAN_X400" },
    { 12, "P_ADDRESS_PLAN_SIP" },
    { 13, "P_ADDRESS_PLAN_ANY" },
    { 14, "P_ADDRESS_PLAN_NATIONAL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpAddressPresentation:1.0
 */
static const value_string org_csapi_TpAddressPresentation[] = {

    { 0, "P_ADDRESS_PRESENTATION_UNDEFINED" },
    { 1, "P_ADDRESS_PRESENTATION_ALLOWED" },
    { 2, "P_ADDRESS_PRESENTATION_RESTRICTED" },
    { 3, "P_ADDRESS_PRESENTATION_ADDRESS_NOT_AVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpAddressScreening:1.0
 */
static const value_string org_csapi_TpAddressScreening[] = {

    { 0, "P_ADDRESS_SCREENING_UNDEFINED" },
    { 1, "P_ADDRESS_SCREENING_USER_VERIFIED_PASSED" },
    { 2, "P_ADDRESS_SCREENING_USER_NOT_VERIFIED" },
    { 3, "P_ADDRESS_SCREENING_USER_VERIFIED_FAILED" },
    { 4, "P_ADDRESS_SCREENING_NETWORK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpCallAoCOrderCategory:1.0
 */
static const value_string org_csapi_TpCallAoCOrderCategory[] = {

    { 0, "P_CHARGE_ADVICE_INFO" },
    { 1, "P_CHARGE_PER_TIME" },
    { 2, "P_CHARGE_NETWORK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpDataSessionQosClass:1.0
 */
static const value_string org_csapi_TpDataSessionQosClass[] = {

    { 0, "P_DATA_SESSION_QOS_CLASS_CONVERSATIONAL" },
    { 1, "P_DATA_SESSION_QOS_CLASS_STREAMING" },
    { 2, "P_DATA_SESSION_QOS_CLASS_INTERACTIVE" },
    { 3, "P_DATA_SESSION_QOS_CLASS_BACKGROUND" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpSimpleAttributeTypeInfo:1.0
 */
static const value_string org_csapi_TpSimpleAttributeTypeInfo[] = {

    { 0, "P_BOOLEAN" },
    { 1, "P_OCTET" },
    { 2, "P_CHAR" },
    { 3, "P_WCHAR" },
    { 4, "P_STRING" },
    { 5, "P_WSTRING" },
    { 6, "P_INT16" },
    { 7, "P_UNSIGNED_INT16" },
    { 8, "P_INT32" },
    { 9, "P_UNSIGNED_INT32" },
    { 10, "P_INT64" },
    { 11, "P_UNSIGNED_INT64" },
    { 12, "P_FLOAT" },
    { 13, "P_DOUBLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/TpAttributeTagInfo:1.0
 */
static const value_string org_csapi_TpAttributeTagInfo[] = {

    { 0, "P_SIMPLE_TYPE" },
    { 1, "P_STRUCTURED_TYPE" },
    { 2, "P_XML_TYPE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpAPIUnavailReason:1.0
 */
static const value_string org_csapi_fw_TpAPIUnavailReason[] = {

    { 0, "API_UNAVAILABLE_UNDEFINED" },
    { 1, "API_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "API_UNAVAILABLE_GATEWAY_FAILURE" },
    { 3, "API_UNAVAILABLE_OVERLOADED" },
    { 4, "API_UNAVAILABLE_CLOSED" },
    { 5, "API_UNAVAILABLE_PROTOCOL_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpDomainIDType:1.0
 */
static const value_string org_csapi_fw_TpDomainIDType[] = {

    { 0, "P_FW" },
    { 1, "P_CLIENT_APPLICATION" },
    { 2, "P_ENT_OP" },
    { 3, "P_SERVICE_INSTANCE" },
    { 4, "P_SERVICE_SUPPLIER" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpFwEventName:1.0
 */
static const value_string org_csapi_fw_TpFwEventName[] = {

    { 0, "P_EVENT_FW_NAME_UNDEFINED" },
    { 1, "P_EVENT_FW_SERVICE_AVAILABLE" },
    { 2, "P_EVENT_FW_SERVICE_UNAVAILABLE" },
    { 3, "P_EVENT_FW_MIGRATION_SERVICE_AVAILABLE" },
    { 4, "P_EVENT_FW_APP_SESSION_CREATED" },
    { 5, "P_EVENT_FW_APP_SESSION_TERMINATED" },
    { 6, "P_EVENT_FW_APP_AGREEMENT_SIGNED" },
    { 7, "P_EVENT_FW_APP_AGREEMENT_ENDED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpFWExceptionType:1.0
 */
static const value_string org_csapi_fw_TpFWExceptionType[] = {

    { 0, "P_FW_DUMMY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpFwUnavailReason:1.0
 */
static const value_string org_csapi_fw_TpFwUnavailReason[] = {

    { 0, "FW_UNAVAILABLE_UNDEFINED" },
    { 1, "FW_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "FW_UNAVAILABLE_GATEWAY_FAILURE" },
    { 3, "FW_UNAVAILABLE_OVERLOADED" },
    { 4, "FW_UNAVAILABLE_CLOSED" },
    { 5, "FW_UNAVAILABLE_PROTOCOL_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpInterfaceFault:1.0
 */
static const value_string org_csapi_fw_TpInterfaceFault[] = {

    { 0, "INTERFACE_FAULT_UNDEFINED" },
    { 1, "INTERFACE_FAULT_LOCAL_FAILURE" },
    { 2, "INTERFACE_FAULT_GATEWAY_FAILURE" },
    { 3, "INTERFACE_FAULT_PROTOCOL_ERROR" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpLoadLevel:1.0
 */
static const value_string org_csapi_fw_TpLoadLevel[] = {

    { 0, "LOAD_LEVEL_NORMAL" },
    { 1, "LOAD_LEVEL_OVERLOAD" },
    { 2, "LOAD_LEVEL_SEVERE_OVERLOAD" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpLoadStatisticEntityType:1.0
 */
static const value_string org_csapi_fw_TpLoadStatisticEntityType[] = {

    { 0, "P_LOAD_STATISTICS_FW_TYPE" },
    { 1, "P_LOAD_STATISTICS_SVC_TYPE" },
    { 2, "P_LOAD_STATISTICS_APP_TYPE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpLoadStatisticInfoType:1.0
 */
static const value_string org_csapi_fw_TpLoadStatisticInfoType[] = {

    { 0, "P_LOAD_STATISTICS_VALID" },
    { 1, "P_LOAD_STATISTICS_INVALID" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpLoadStatusError:1.0
 */
static const value_string org_csapi_fw_TpLoadStatusError[] = {

    { 0, "LOAD_STATUS_ERROR_UNDEFINED" },
    { 1, "LOAD_STATUS_ERROR_UNAVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpServiceTypePropertyMode:1.0
 */
static const value_string org_csapi_fw_TpServiceTypePropertyMode[] = {

    { 0, "NORMAL" },
    { 1, "MANDATORY" },
    { 2, "READONLY" },
    { 3, "MANDATORY_READONLY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpSvcUnavailReason:1.0
 */
static const value_string org_csapi_fw_TpSvcUnavailReason[] = {

    { 0, "SERVICE_UNAVAILABLE_UNDEFINED" },
    { 1, "SERVICE_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "SERVICE_UNAVAILABLE_GATEWAY_FAILURE" },
    { 3, "SERVICE_UNAVAILABLE_OVERLOADED" },
    { 4, "SERVICE_UNAVAILABLE_CLOSED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpLoadStatisticError:1.0
 */
static const value_string org_csapi_fw_TpLoadStatisticError[] = {

    { 0, "P_LOAD_INFO_ERROR_UNDEFINED" },
    { 1, "P_LOAD_INFO_UNAVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpSubjectType:1.0
 */
static const value_string org_csapi_fw_TpSubjectType[] = {

    { 0, "P_SUBJECT_UNDEFINED" },
    { 1, "P_SUBJECT_CLIENT_APP" },
    { 2, "P_SUBJECT_FW" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpFaultStatisticsError:1.0
 */
static const value_string org_csapi_fw_TpFaultStatisticsError[] = {

    { 0, "P_FAULT_INFO_ERROR_UNDEFINED" },
    { 1, "P_FAULT_INFO_UNAVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpSvcAvailStatusReason:1.0
 */
static const value_string org_csapi_fw_TpSvcAvailStatusReason[] = {

    { 0, "SVC_UNAVAILABLE_UNDEFINED" },
    { 1, "SVC_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "SVC_UNAVAILABLE_GATEWAY_FAILURE" },
    { 3, "SVC_UNAVAILABLE_OVERLOADED" },
    { 4, "SVC_UNAVAILABLE_CLOSED" },
    { 5, "SVC_UNAVAILABLE_NO_RESPONSE" },
    { 6, "SVC_UNAVAILABLE_SW_UPGRADE" },
    { 7, "SVC_AVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpAppAvailStatusReason:1.0
 */
static const value_string org_csapi_fw_TpAppAvailStatusReason[] = {

    { 0, "APP_UNAVAILABLE_UNDEFINED" },
    { 1, "APP_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "APP_UNAVAILABLE_REMOTE_FAILURE" },
    { 3, "APP_UNAVAILABLE_OVERLOADED" },
    { 4, "APP_UNAVAILABLE_CLOSED" },
    { 5, "APP_UNAVAILABLE_NO_RESPONSE" },
    { 6, "APP_UNAVAILABLE_SW_UPGRADE" },
    { 7, "APP_AVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpMigrationAdditionalInfoType:1.0
 */
static const value_string org_csapi_fw_TpMigrationAdditionalInfoType[] = {

    { 0, "P_MIGRATION_INFO_UNDEFINED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/fw/TpFwAvailStatusReason:1.0
 */
static const value_string org_csapi_fw_TpFwAvailStatusReason[] = {

    { 0, "FRAMEWORK_UNAVAILABLE_UNDEFINED" },
    { 1, "FRAMEWORK_UNAVAILABLE_LOCAL_FAILURE" },
    { 2, "FRAMEWORK_UNAVAILABLE_REMOTE_FAILURE" },
    { 3, "FRAMEWORK_UNAVAILABLE_OVERLOADED" },
    { 4, "FRAMEWORK_UNAVAILABLE_CLOSED" },
    { 5, "FRAMEWORK_UNAVAILABLE_PROTOCOL_FAILURE" },
    { 6, "FRAMEWORK_UNAVAILABLE_SW_UPGRADE" },
    { 7, "FRAMEWORK_AVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIVariablePartType:1.0
 */
static const value_string org_csapi_ui_TpUIVariablePartType[] = {

    { 0, "P_UI_VARIABLE_PART_INT" },
    { 1, "P_UI_VARIABLE_PART_ADDRESS" },
    { 2, "P_UI_VARIABLE_PART_TIME" },
    { 3, "P_UI_VARIABLE_PART_DATE" },
    { 4, "P_UI_VARIABLE_PART_PRICE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIReport:1.0
 */
static const value_string org_csapi_ui_TpUIReport[] = {

    { 0, "P_UI_REPORT_UNDEFINED" },
    { 1, "P_UI_REPORT_INFO_SENT" },
    { 2, "P_UI_REPORT_INFO_COLLECTED" },
    { 3, "P_UI_REPORT_NO_INPUT" },
    { 4, "P_UI_REPORT_TIMEOUT" },
    { 5, "P_UI_REPORT_MESSAGE_STORED" },
    { 6, "P_UI_REPORT_MESSAGE_NOT_STORED" },
    { 7, "P_UI_REPORT_MESSAGE_DELETED" },
    { 8, "P_UI_REPORT_MESSAGE_NOT_DELETED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIInfoType:1.0
 */
static const value_string org_csapi_ui_TpUIInfoType[] = {

    { 0, "P_UI_INFO_ID" },
    { 1, "P_UI_INFO_DATA" },
    { 2, "P_UI_INFO_ADDRESS" },
    { 3, "P_UI_INFO_BIN_DATA" },
    { 4, "P_UI_INFO_UUENCODED" },
    { 5, "P_UI_INFO_MIME" },
    { 6, "P_UI_INFO_WAVE" },
    { 7, "P_UI_INFO_AU" },
    { 8, "P_UI_INFO_VXML" },
    { 9, "P_UI_INFO_SYNTHESIS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIFault:1.0
 */
static const value_string org_csapi_ui_TpUIFault[] = {

    { 0, "P_UI_FAULT_UNDEFINED" },
    { 1, "P_UI_CALL_ENDED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIEventInfoDataType:1.0
 */
static const value_string org_csapi_ui_TpUIEventInfoDataType[] = {

    { 0, "P_UI_EVENT_DATA_TYPE_UNDEFINED" },
    { 1, "P_UI_EVENT_DATA_TYPE_UNSPECIFIED" },
    { 2, "P_UI_EVENT_DATA_TYPE_TEXT" },
    { 3, "P_UI_EVENT_DATA_TYPE_USSD_DATA" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIError:1.0
 */
static const value_string org_csapi_ui_TpUIError[] = {

    { 0, "P_UI_ERROR_UNDEFINED" },
    { 1, "P_UI_ERROR_ILLEGAL_INFO" },
    { 2, "P_UI_ERROR_ID_NOT_FOUND" },
    { 3, "P_UI_ERROR_RESOURCE_UNAVAILABLE" },
    { 4, "P_UI_ERROR_ILLEGAL_RANGE" },
    { 5, "P_UI_ERROR_IMPROPER_USER_RESPONSE" },
    { 6, "P_UI_ERROR_ABANDON" },
    { 7, "P_UI_ERROR_NO_OPERATION_ACTIVE" },
    { 8, "P_UI_ERROR_NO_SPACE_AVAILABLE" },
    { 9, "P_UI_ERROR_RESOURCE_TIMEOUT" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUICollectMode:1.0
 */
static const value_string org_csapi_ui_TpUICollectMode[] = {

    { 0, "P_UI_COLLECT_MODE_DTMF" },
    { 1, "P_UI_COLLECT_MODE_VOICE" },
    { 2, "P_UI_COLLECT_MODE_DTMFANDVOICE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUIPronounceType:1.0
 */
static const value_string org_csapi_ui_TpUIPronounceType[] = {

    { 0, "P_UI_PRONOUNCE_IPA" },
    { 1, "P_UI_PRONOUNCE_SOUNDSLIKE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUISynthesisRange:1.0
 */
static const value_string org_csapi_ui_TpUISynthesisRange[] = {

    { 0, "P_UI_RANGE_CALMER" },
    { 1, "P_UI_RANGE_CALM" },
    { 2, "P_UI_RANGE_AVERAGE" },
    { 3, "P_UI_RANGE_EXCITED" },
    { 4, "P_UI_RANGE_MORE_EXCITED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUISynthesisRate:1.0
 */
static const value_string org_csapi_ui_TpUISynthesisRate[] = {

    { 0, "P_UI_RATE_SLOW" },
    { 1, "P_UI_RATE_AVERAGE" },
    { 2, "P_UI_RATE_FAST" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUISynthesisAge:1.0
 */
static const value_string org_csapi_ui_TpUISynthesisAge[] = {

    { 0, "P_UI_AGE_CHILD" },
    { 1, "P_UI_AGE_YOUNG_ADULT" },
    { 2, "P_UI_AGE_ADULT" },
    { 3, "P_UI_AGE_OLDER_ADULT" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUISynthesisGender:1.0
 */
static const value_string org_csapi_ui_TpUISynthesisGender[] = {

    { 0, "P_UI_GENDER_MALE" },
    { 1, "P_UI_GENDER_FEMALE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpReleaseCause:1.0
 */
static const value_string org_csapi_cc_TpReleaseCause[] = {

    { 0, "P_UNDEFINED" },
    { 1, "P_USER_NOT_AVAILABLE" },
    { 2, "P_BUSY" },
    { 3, "P_NO_ANSWER" },
    { 4, "P_NOT_REACHABLE" },
    { 5, "P_ROUTING_FAILURE" },
    { 6, "P_PREMATURE_DISCONNECT" },
    { 7, "P_DISCONNECTED" },
    { 8, "P_CALL_RESTRICTED" },
    { 9, "P_UNAVAILABLE_RESOURCE" },
    { 10, "P_GENERAL_FAILURE" },
    { 11, "P_TIMER_EXPIRY" },
    { 12, "P_UNSUPPORTED_MEDIA" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallMonitorMode:1.0
 */
static const value_string org_csapi_cc_TpCallMonitorMode[] = {

    { 0, "P_CALL_MONITOR_MODE_INTERRUPT" },
    { 1, "P_CALL_MONITOR_MODE_NOTIFY" },
    { 2, "P_CALL_MONITOR_MODE_DO_NOT_MONITOR" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallBearerService:1.0
 */
static const value_string org_csapi_cc_TpCallBearerService[] = {

    { 0, "P_CALL_BEARER_SERVICE_UNKNOWN" },
    { 1, "P_CALL_BEARER_SERVICE_SPEECH" },
    { 2, "P_CALL_BEARER_SERVICE_DIGITALUNRESTRICTED" },
    { 3, "P_CALL_BEARER_SERVICE_DIGITALRESTRICTED" },
    { 4, "P_CALL_BEARER_SERVICE_AUDIO" },
    { 5, "P_CALL_BEARER_SERVICE_DIGITALUNRESTRICTEDTONES" },
    { 6, "P_CALL_BEARER_SERVICE_VIDEO" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallChargeOrderCategory:1.0
 */
static const value_string org_csapi_cc_TpCallChargeOrderCategory[] = {

    { 0, "P_CALL_CHARGE_TRANSPARENT" },
    { 1, "P_CALL_CHARGE_PREDEFINED_SET" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallErrorType:1.0
 */
static const value_string org_csapi_cc_TpCallErrorType[] = {

    { 0, "P_CALL_ERROR_UNDEFINED" },
    { 1, "P_CALL_ERROR_INVALID_ADDRESS" },
    { 2, "P_CALL_ERROR_INVALID_STATE" },
    { 3, "P_CALL_ERROR_RESOURCE_UNAVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallLoadControlMechanismType:1.0
 */
static const value_string org_csapi_cc_TpCallLoadControlMechanismType[] = {

    { 0, "P_CALL_LOAD_CONTROL_PER_INTERVAL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallNetworkAccessType:1.0
 */
static const value_string org_csapi_cc_TpCallNetworkAccessType[] = {

    { 0, "P_CALL_NETWORK_ACCESS_TYPE_UNKNOWN" },
    { 1, "P_CALL_NETWORK_ACCESS_TYPE_POT" },
    { 2, "P_CALL_NETWORK_ACCESS_TYPE_ISDN" },
    { 3, "P_CALL_NETWORK_ACCESS_TYPE_DIALUPINTERNET" },
    { 4, "P_CALL_NETWORK_ACCESS_TYPE_XDSL" },
    { 5, "P_CALL_NETWORK_ACCESS_TYPE_WIRELESS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallPartyCategory:1.0
 */
static const value_string org_csapi_cc_TpCallPartyCategory[] = {

    { 0, "P_CALL_PARTY_CATEGORY_UNKNOWN" },
    { 1, "P_CALL_PARTY_CATEGORY_OPERATOR_F" },
    { 2, "P_CALL_PARTY_CATEGORY_OPERATOR_E" },
    { 3, "P_CALL_PARTY_CATEGORY_OPERATOR_G" },
    { 4, "P_CALL_PARTY_CATEGORY_OPERATOR_R" },
    { 5, "P_CALL_PARTY_CATEGORY_OPERATOR_S" },
    { 6, "P_CALL_PARTY_CATEGORY_ORDINARY_SUB" },
    { 7, "P_CALL_PARTY_CATEGORY_PRIORITY_SUB" },
    { 8, "P_CALL_PARTY_CATEGORY_DATA_CALL" },
    { 9, "P_CALL_PARTY_CATEGORY_TEST_CALL" },
    { 10, "P_CALL_PARTY_CATEGORY_PAYPHONE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallServiceCodeType:1.0
 */
static const value_string org_csapi_cc_TpCallServiceCodeType[] = {

    { 0, "P_CALL_SERVICE_CODE_UNDEFINED" },
    { 1, "P_CALL_SERVICE_CODE_DIGITS" },
    { 2, "P_CALL_SERVICE_CODE_FACILITY" },
    { 3, "P_CALL_SERVICE_CODE_U2U" },
    { 4, "P_CALL_SERVICE_CODE_HOOKFLASH" },
    { 5, "P_CALL_SERVICE_CODE_RECALL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallTeleService:1.0
 */
static const value_string org_csapi_cc_TpCallTeleService[] = {

    { 0, "P_CALL_TELE_SERVICE_UNKNOWN" },
    { 1, "P_CALL_TELE_SERVICE_TELEPHONY" },
    { 2, "P_CALL_TELE_SERVICE_FAX_2_3" },
    { 3, "P_CALL_TELE_SERVICE_FAX_4_I" },
    { 4, "P_CALL_TELE_SERVICE_FAX_4_II_III" },
    { 5, "P_CALL_TELE_SERVICE_VIDEOTEX_SYN" },
    { 6, "P_CALL_TELE_SERVICE_VIDEOTEX_INT" },
    { 7, "P_CALL_TELE_SERVICE_TELEX" },
    { 8, "P_CALL_TELE_SERVICE_MHS" },
    { 9, "P_CALL_TELE_SERVICE_OSI" },
    { 10, "P_CALL_TELE_SERVICE_FTAM" },
    { 11, "P_CALL_TELE_SERVICE_VIDEO" },
    { 12, "P_CALL_TELE_SERVICE_VIDEO_CONF" },
    { 13, "P_CALL_TELE_SERVICE_AUDIOGRAPH_CONF" },
    { 14, "P_CALL_TELE_SERVICE_MULTIMEDIA" },
    { 15, "P_CALL_TELE_SERVICE_CS_INI_H221" },
    { 16, "P_CALL_TELE_SERVICE_CS_SUB_H221" },
    { 17, "P_CALL_TELE_SERVICE_CS_INI_CALL" },
    { 18, "P_CALL_TELE_SERVICE_DATATRAFFIC" },
    { 19, "P_CALL_TELE_SERVICE_EMERGENCY_CALLS" },
    { 20, "P_CALL_TELE_SERVICE_SMS_MT_PP" },
    { 21, "P_CALL_TELE_SERVICE_SMS_MO_PP" },
    { 22, "P_CALL_TELE_SERVICE_CELL_BROADCAST" },
    { 23, "P_CALL_TELE_SERVICE_ALT_SPEECH_FAX_3" },
    { 24, "P_CALL_TELE_SERVICE_AUTOMATIC_FAX_3" },
    { 25, "P_CALL_TELE_SERVICE_VOICE_GROUP_CALL" },
    { 26, "P_CALL_TELE_SERVICE_VOICE_BROADCAST" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallTreatmentType:1.0
 */
static const value_string org_csapi_cc_TpCallTreatmentType[] = {

    { 0, "P_CALL_TREATMENT_DEFAULT" },
    { 1, "P_CALL_TREATMENT_RELEASE" },
    { 2, "P_CALL_TREATMENT_SIAR" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallPartyToChargeType:1.0
 */
static const value_string org_csapi_cc_TpCallPartyToChargeType[] = {

    { 0, "P_CALL_PARTY_ORIGINATING" },
    { 1, "P_CALL_PARTY_DESTINATION" },
    { 2, "P_CALL_PARTY_SPECIAL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/gccs/TpCallNotificationType:1.0
 */
static const value_string org_csapi_cc_gccs_TpCallNotificationType[] = {

    { 0, "P_ORIGINATING" },
    { 1, "P_TERMINATING" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/gccs/TpCallAppInfoType:1.0
 */
static const value_string org_csapi_cc_gccs_TpCallAppInfoType[] = {

    { 0, "P_CALL_APP_UNDEFINED" },
    { 1, "P_CALL_APP_ALERTING_MECHANISM" },
    { 2, "P_CALL_APP_NETWORK_ACCESS_TYPE" },
    { 3, "P_CALL_APP_TELE_SERVICE" },
    { 4, "P_CALL_APP_BEARER_SERVICE" },
    { 5, "P_CALL_APP_PARTY_CATEGORY" },
    { 6, "P_CALL_APP_PRESENTATION_ADDRESS" },
    { 7, "P_CALL_APP_GENERIC_INFO" },
    { 8, "P_CALL_APP_ADDITIONAL_ADDRESS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/gccs/TpCallReportType:1.0
 */
static const value_string org_csapi_cc_gccs_TpCallReportType[] = {

    { 0, "P_CALL_REPORT_UNDEFINED" },
    { 1, "P_CALL_REPORT_PROGRESS" },
    { 2, "P_CALL_REPORT_ALERTING" },
    { 3, "P_CALL_REPORT_ANSWER" },
    { 4, "P_CALL_REPORT_BUSY" },
    { 5, "P_CALL_REPORT_NO_ANSWER" },
    { 6, "P_CALL_REPORT_DISCONNECT" },
    { 7, "P_CALL_REPORT_REDIRECTED" },
    { 8, "P_CALL_REPORT_SERVICE_CODE" },
    { 9, "P_CALL_REPORT_ROUTING_FAILURE" },
    { 10, "P_CALL_REPORT_QUEUED" },
    { 11, "P_CALL_REPORT_NOT_REACHABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/gccs/TpCallFault:1.0
 */
static const value_string org_csapi_cc_gccs_TpCallFault[] = {

    { 0, "P_CALL_FAULT_UNDEFINED" },
    { 1, "P_CALL_TIMEOUT_ON_RELEASE" },
    { 2, "P_CALL_TIMEOUT_ON_INTERRUPT" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallAppInfoType:1.0
 */
static const value_string org_csapi_cc_TpCallAppInfoType[] = {

    { 0, "P_CALL_APP_UNDEFINED" },
    { 1, "P_CALL_APP_ALERTING_MECHANISM" },
    { 2, "P_CALL_APP_NETWORK_ACCESS_TYPE" },
    { 3, "P_CALL_APP_TELE_SERVICE" },
    { 4, "P_CALL_APP_BEARER_SERVICE" },
    { 5, "P_CALL_APP_PARTY_CATEGORY" },
    { 6, "P_CALL_APP_PRESENTATION_ADDRESS" },
    { 7, "P_CALL_APP_GENERIC_INFO" },
    { 8, "P_CALL_APP_ADDITIONAL_ADDRESS" },
    { 9, "P_CALL_APP_ORIGINAL_DESTINATION_ADDRESS" },
    { 10, "P_CALL_APP_REDIRECTING_ADDRESS" },
    { 11, "P_CALL_APP_HIGH_PROBABILITY_COMPLETION" },
    { 12, "P_CALL_APP_CARRIER" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallEventType:1.0
 */
static const value_string org_csapi_cc_TpCallEventType[] = {

    { 0, "P_CALL_EVENT_UNDEFINED" },
    { 1, "P_CALL_EVENT_ORIGINATING_CALL_ATTEMPT" },
    { 2, "P_CALL_EVENT_ORIGINATING_CALL_ATTEMPT_AUTHORISED" },
    { 3, "P_CALL_EVENT_ADDRESS_COLLECTED" },
    { 4, "P_CALL_EVENT_ADDRESS_ANALYSED" },
    { 5, "P_CALL_EVENT_ORIGINATING_SERVICE_CODE" },
    { 6, "P_CALL_EVENT_ORIGINATING_RELEASE" },
    { 7, "P_CALL_EVENT_TERMINATING_CALL_ATTEMPT" },
    { 8, "P_CALL_EVENT_TERMINATING_CALL_ATTEMPT_AUTHORISED" },
    { 9, "P_CALL_EVENT_ALERTING" },
    { 10, "P_CALL_EVENT_ANSWER" },
    { 11, "P_CALL_EVENT_TERMINATING_RELEASE" },
    { 12, "P_CALL_EVENT_REDIRECTED" },
    { 13, "P_CALL_EVENT_TERMINATING_SERVICE_CODE" },
    { 14, "P_CALL_EVENT_QUEUED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCallLegAttachMechanism:1.0
 */
static const value_string org_csapi_cc_TpCallLegAttachMechanism[] = {

    { 0, "P_CALLLEG_ATTACH_IMPLICITLY" },
    { 1, "P_CALLLEG_ATTACH_EXPLICITLY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/TpCarrierSelectionField:1.0
 */
static const value_string org_csapi_cc_TpCarrierSelectionField[] = {

    { 0, "P_CIC_UNDEFINED" },
    { 1, "P_CIC_NO_INPUT" },
    { 2, "P_CIC_INPUT" },
    { 3, "P_CIC_UNDETERMINED" },
    { 4, "P_CIC_NOT_PRESCRIBED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/mpccs/TpAppMultiPartyCallBackRefType:1.0
 */
static const value_string org_csapi_cc_mpccs_TpAppMultiPartyCallBackRefType[] = {

    { 0, "P_APP_CALLBACK_UNDEFINED" },
    { 1, "P_APP_MULTIPARTY_CALL_CALLBACK" },
    { 2, "P_APP_CALL_LEG_CALLBACK" },
    { 3, "P_APP_CALL_AND_CALL_LEG_CALLBACK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/mmccs/TpMediaStreamDirection:1.0
 */
static const value_string org_csapi_cc_mmccs_TpMediaStreamDirection[] = {

    { 0, "P_SEND_ONLY" },
    { 1, "P_RECEIVE_ONLY" },
    { 2, "P_SEND_RECEIVE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/mmccs/TpMediaStreamEventType:1.0
 */
static const value_string org_csapi_cc_mmccs_TpMediaStreamEventType[] = {

    { 0, "P_MEDIA_STREAM_ADDED" },
    { 1, "P_MEDIA_STREAM_SUBTRACTED" },
    { 2, "P_MEDIA_STREAM_QOS_CLASS_CHANGED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/mmccs/TpMediaStreamDataTypeRequestType:1.0
 */
static const value_string org_csapi_cc_mmccs_TpMediaStreamDataTypeRequestType[] = {

    { 0, "P_AUDIO_CAPABILITIES" },
    { 1, "P_VIDEO_CAPABILITIES" },
    { 2, "P_DATA_CAPABILITIES" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/mmccs/TpAppMultiMediaCallBackRefType:1.0
 */
static const value_string org_csapi_cc_mmccs_TpAppMultiMediaCallBackRefType[] = {

    { 0, "P_APP_CALLBACK_UNDEFINED" },
    { 1, "P_APP_MULTIMEDIA_CALL_CALLBACK" },
    { 2, "P_APP_CALL_LEG_CALLBACK" },
    { 3, "P_APP_CALL_AND_CALL_LEG_CALLBACK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/cccs/TpConfPolicyType:1.0
 */
static const value_string org_csapi_cc_cccs_TpConfPolicyType[] = {

    { 0, "P_CONFERENCE_POLICY_UNDEFINED" },
    { 1, "P_CONFERENCE_POLICY_MONOMEDIA" },
    { 2, "P_CONFERENCE_POLICY_MULTIMEDIA" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cc/cccs/TpVideoHandlingType:1.0
 */
static const value_string org_csapi_cc_cccs_TpVideoHandlingType[] = {

    { 0, "P_MIXED_VIDEO" },
    { 1, "P_SWITCHED_VIDEO_CHAIR_CONTROLLED" },
    { 2, "P_SWITCHED_VIDEO_VOICE_CONTROLLED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/ui/TpUITargetObjectType:1.0
 */
static const value_string org_csapi_ui_TpUITargetObjectType[] = {

    { 0, "P_UI_TARGET_OBJECT_CALL" },
    { 1, "P_UI_TARGET_OBJECT_MULTI_PARTY_CALL" },
    { 2, "P_UI_TARGET_OBJECT_CALL_LEG" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpLocationPriority:1.0
 */
static const value_string org_csapi_mm_TpLocationPriority[] = {

    { 0, "P_M_NORMAL" },
    { 1, "P_M_HIGH" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpLocationResponseIndicator:1.0
 */
static const value_string org_csapi_mm_TpLocationResponseIndicator[] = {

    { 0, "P_M_NO_DELAY" },
    { 1, "P_M_LOW_DELAY" },
    { 2, "P_M_DELAY_TOLERANT" },
    { 3, "P_M_USE_TIMER_VALUE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpLocationTriggerCriteria:1.0
 */
static const value_string org_csapi_mm_TpLocationTriggerCriteria[] = {

    { 0, "P_UL_ENTERING_AREA" },
    { 1, "P_UL_LEAVING_AREA" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpLocationType:1.0
 */
static const value_string org_csapi_mm_TpLocationType[] = {

    { 0, "P_M_CURRENT" },
    { 1, "P_M_CURRENT_OR_LAST_KNOWN" },
    { 2, "P_M_INITIAL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpLocationUncertaintyShape:1.0
 */
static const value_string org_csapi_mm_TpLocationUncertaintyShape[] = {

    { 0, "P_M_SHAPE_NONE" },
    { 1, "P_M_SHAPE_CIRCLE" },
    { 2, "P_M_SHAPE_CIRCLE_SECTOR" },
    { 3, "P_M_SHAPE_CIRCLE_ARC_STRIPE" },
    { 4, "P_M_SHAPE_ELLIPSE" },
    { 5, "P_M_SHAPE_ELLIPSE_SECTOR" },
    { 6, "P_M_SHAPE_ELLIPSE_ARC_STRIPE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpMobilityDiagnostic:1.0
 */
static const value_string org_csapi_mm_TpMobilityDiagnostic[] = {

    { 0, "P_M_NO_INFORMATION" },
    { 1, "P_M_APPL_NOT_IN_PRIV_EXCEPT_LST" },
    { 2, "P_M_CALL_TO_USER_NOT_SETUP" },
    { 3, "P_M_PRIVACY_OVERRIDE_NOT_APPLIC" },
    { 4, "P_M_DISALL_BY_LOCAL_REGULAT_REQ" },
    { 5, "P_M_CONGESTION" },
    { 6, "P_M_INSUFFICIENT_RESOURCES" },
    { 7, "P_M_INSUFFICIENT_MEAS_DATA" },
    { 8, "P_M_INCONSISTENT_MEAS_DATA" },
    { 9, "P_M_LOC_PROC_NOT_COMPLETED" },
    { 10, "P_M_LOC_PROC_NOT_SUPP_BY_USER" },
    { 11, "P_M_QOS_NOT_ATTAINABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpMobilityError:1.0
 */
static const value_string org_csapi_mm_TpMobilityError[] = {

    { 0, "P_M_OK" },
    { 1, "P_M_SYSTEM_FAILURE" },
    { 2, "P_M_UNAUTHORIZED_NETWORK" },
    { 3, "P_M_UNAUTHORIZED_APPLICATION" },
    { 4, "P_M_UNKNOWN_SUBSCRIBER" },
    { 5, "P_M_ABSENT_SUBSCRIBER" },
    { 6, "P_M_POSITION_METHOD_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpMobilityStopScope:1.0
 */
static const value_string org_csapi_mm_TpMobilityStopScope[] = {

    { 0, "P_M_ALL_IN_ASSIGNMENT" },
    { 1, "P_M_SPECIFIED_USERS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpTerminalType:1.0
 */
static const value_string org_csapi_mm_TpTerminalType[] = {

    { 0, "P_M_FIXED" },
    { 1, "P_M_MOBILE" },
    { 2, "P_M_IP" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpUserLocationEmergencyTrigger:1.0
 */
static const value_string org_csapi_mm_TpUserLocationEmergencyTrigger[] = {

    { 0, "P_ULE_CALL_ORIGINATION" },
    { 1, "P_ULE_CALL_RELEASE" },
    { 2, "P_ULE_LOCATION_REQUEST" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpUserStatusIndicator:1.0
 */
static const value_string org_csapi_mm_TpUserStatusIndicator[] = {

    { 0, "P_US_REACHABLE" },
    { 1, "P_US_NOT_REACHABLE" },
    { 2, "P_US_BUSY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpAuthStatusIndicator:1.0
 */
static const value_string org_csapi_mm_TpAuthStatusIndicator[] = {

    { 0, "P_AUTHENTICATED_FOR_NETWORK_ONLY" },
    { 1, "P_AUTHENTICATED_FOR_NETWORK_AND_IP_SERVICES" },
    { 2, "P_NOT_AUTHENTICATED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpAccessTechnology:1.0
 */
static const value_string org_csapi_mm_TpAccessTechnology[] = {

    { 0, "P_MOBILE_ACCESS_PS" },
    { 1, "P_MOBILE_ACCESS_CS" },
    { 2, "P_FIXED_ACCESS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpRoamingStatus:1.0
 */
static const value_string org_csapi_mm_TpRoamingStatus[] = {

    { 0, "P_UNKNOWN_ROAMING_STATUS" },
    { 1, "P_HOME_USER" },
    { 2, "P_NATIONAL_ROAMING" },
    { 3, "P_INTERNATIONAL_ROAMING" },
    { 4, "P_OPERATOR_ROAMING" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mm/TpBindingEntryType:1.0
 */
static const value_string org_csapi_mm_TpBindingEntryType[] = {

    { 0, "P_UB_UNDEFINED" },
    { 1, "P_UB_EXPIRES" },
    { 2, "P_UB_CONTACT_ADDRESS" },
    { 3, "P_UB_PREFERENCE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/termcap/TpTerminalCapabilitiesError:1.0
 */
static const value_string org_csapi_termcap_TpTerminalCapabilitiesError[] = {

    { 0, "P_TERMCAP_ERROR_UNDEFINED" },
    { 1, "P_TERMCAP_INVALID_TERMINALID" },
    { 2, "P_TERMCAP_SYSTEM_FAILURE" },
    { 3, "P_TERMCAP_INFO_UNAVAILABLE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/termcap/TpTerminalCapabilityScopeType:1.0
 */
static const value_string org_csapi_termcap_TpTerminalCapabilityScopeType[] = {

    { 0, "P_TERMINAL_CAPABILITY_SCOPE_TYPE_UNDEFINED" },
    { 1, "P_TERMINAL_CAPABILITY_SCOPE_TYPE_CCPP" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/dsc/TpDataSessionChargeOrderCategory:1.0
 */
static const value_string org_csapi_dsc_TpDataSessionChargeOrderCategory[] = {

    { 0, "P_DATA_SESSION_CHARGE_PER_VOLUME" },
    { 1, "P_DATA_SESSION_CHARGE_NETWORK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/dsc/TpDataSessionErrorType:1.0
 */
static const value_string org_csapi_dsc_TpDataSessionErrorType[] = {

    { 0, "P_DATA_SESSION_ERROR_UNDEFINED" },
    { 1, "P_DATA_SESSION_ERROR_INVALID_ADDRESS" },
    { 2, "P_DATA_SESSION_ERROR_INVALID_STATE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/dsc/TpDataSessionFault:1.0
 */
static const value_string org_csapi_dsc_TpDataSessionFault[] = {

    { 0, "P_DATA_SESSION_FAULT_UNDEFINED" },
    { 1, "P_DATA_SESSION_FAULT_USER_ABORTED" },
    { 2, "P_DATA_SESSION_TIMEOUT_ON_RELEASE" },
    { 3, "P_DATA_SESSION_TIMEOUT_ON_INTERRUPT" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/dsc/TpDataSessionMonitorMode:1.0
 */
static const value_string org_csapi_dsc_TpDataSessionMonitorMode[] = {

    { 0, "P_DATA_SESSION_MONITOR_MODE_INTERRUPT" },
    { 1, "P_DATA_SESSION_MONITOR_MODE_NOTIFY" },
    { 2, "P_DATA_SESSION_MONITOR_MODE_DO_NOT_MONITOR" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/dsc/TpDataSessionReportType:1.0
 */
static const value_string org_csapi_dsc_TpDataSessionReportType[] = {

    { 0, "P_DATA_SESSION_REPORT_UNDEFINED" },
    { 1, "P_DATA_SESSION_REPORT_CONNECTED" },
    { 2, "P_DATA_SESSION_REPORT_DISCONNECT" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessagingFault:1.0
 */
static const value_string org_csapi_gms_TpMessagingFault[] = {

    { 0, "P_MESSAGING_FAULT_UNDEFINED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessagingEventName:1.0
 */
static const value_string org_csapi_gms_TpMessagingEventName[] = {

    { 0, "P_EVENT_GMS_NAME_UNDEFINED" },
    { 1, "P_EVENT_GMS_NEW_MESSAGE_ARRIVED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessageStatus:1.0
 */
static const value_string org_csapi_gms_TpMessageStatus[] = {

    { 0, "P_MESSAGING_MESSAGE_STATUS_READ_MESSAGE" },
    { 1, "P_MESSAGING_MESSAGE_STATUS_UNREAD_MESSAGE" },
    { 2, "P_MESSAGING_MESSAGE_STATUS_FORWARDED_MESSAGE" },
    { 3, "P_MESSAGING_MESSAGE_STATUS_REPLIED_TO_MESSAGE" },
    { 4, "P_MESSAGING_MESSAGE_STATUS_SAVED_OR_UNSENT_MESSAGE" },
    { 5, "P_MESSAGING_MESSAGE_STATUS_NOTIFICATION_THAT_A_MESSAGE_WAS_DELIVERED" },
    { 6, "P_MESSAGING_MESSAGE_STATUS_NOTIFICATION_THAT_A_MESSAGE_WAS_READ" },
    { 7, "P_MESSAGING_MESSAGE_STATUS_NOTIFICATION_THAT_A_MESSAGE_WAS_NOT_DELIVERED" },
    { 8, "P_MESSAGING_MESSAGE_STATUS_NOTIFICATION_THAT_A_MESSAGE_WAS_NOT_READ" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessagePriority:1.0
 */
static const value_string org_csapi_gms_TpMessagePriority[] = {

    { 0, "P_MESSAGING_MESSAGE_PRIORITY_UNDEFINED" },
    { 1, "P_MESSAGING_MESSAGE_PRIORITY_HIGH" },
    { 2, "P_MESSAGING_MESSAGE_PRIORITY_LOW" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessageInfoPropertyName:1.0
 */
static const value_string org_csapi_gms_TpMessageInfoPropertyName[] = {

    { 0, "P_MESSAGING_MESSAGE_UNDEFINED" },
    { 1, "P_MESSAGING_MESSAGE_ID" },
    { 2, "P_MESSAGING_MESSAGE_SUBJECT" },
    { 3, "P_MESSAGING_MESSAGE_DATE_SENT" },
    { 4, "P_MESSAGING_MESSAGE_DATE_RECEIVED" },
    { 5, "P_MESSAGING_MESSAGE_DATE_CHANGED" },
    { 6, "P_MESSAGING_MESSAGE_SENT_FROM" },
    { 7, "P_MESSAGING_MESSAGE_SENT_TO" },
    { 8, "P_MESSAGING_MESSAGE_CC_TO" },
    { 9, "P_MESSAGING_MESSAGE_BCC_TO" },
    { 10, "P_MESSAGING_MESSAGE_SIZE" },
    { 11, "P_MESSAGING_MESSAGE_PRIORITY" },
    { 12, "P_MESSAGING_MESSAGE_FORMAT" },
    { 13, "P_MESSAGING_MESSAGE_FOLDER" },
    { 14, "P_MESSAGING_MESSAGE_STATUS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMessageFormat:1.0
 */
static const value_string org_csapi_gms_TpMessageFormat[] = {

    { 0, "P_MESSAGING_MESSAGE_FORMAT_UNDEFINED" },
    { 1, "P_MESSAGING_MESSAGE_FORMAT_TEXT" },
    { 2, "P_MESSAGING_MESSAGE_FORMAT_BINARY" },
    { 3, "P_MESSAGING_MESSAGE_FORMAT_UUENCODED" },
    { 4, "P_MESSAGING_MESSAGE_FORMAT_MIME" },
    { 5, "P_MESSAGING_MESSAGE_FORMAT_WAVE" },
    { 6, "P_MESSAGING_MESSAGE_FORMAT_AU" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpMailboxInfoPropertyName:1.0
 */
static const value_string org_csapi_gms_TpMailboxInfoPropertyName[] = {

    { 0, "P_MESSAGING_MAILBOX_UNDEFINED" },
    { 1, "P_MESSAGING_MAILBOX_ID" },
    { 2, "P_MESSAGING_MAILBOX_OWNER" },
    { 3, "P_MESSAGING_MAILBOX_FOLDER" },
    { 4, "P_MESSAGING_MAILBOX_DATE_CREATED" },
    { 5, "P_MESSAGING_MAILBOX_DATE_CHANGED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/gms/TpFolderInfoPropertyName:1.0
 */
static const value_string org_csapi_gms_TpFolderInfoPropertyName[] = {

    { 0, "P_MESSAGING_FOLDER_UNDEFINED" },
    { 1, "P_MESSAGING_FOLDER_ID" },
    { 2, "P_MESSAGING_FOLDER_MESSAGE" },
    { 3, "P_MESSAGING_FOLDER_SUBFOLDER" },
    { 4, "P_MESSAGING_FOLDER_DATE_CREATED" },
    { 5, "P_MESSAGING_FOLDER_DATE_CHANGED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpTrafficDirection:1.0
 */
static const value_string org_csapi_cm_TpTrafficDirection[] = {

    { 0, "UNIDIRECTIONAL" },
    { 1, "BIDIRECTIONAL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpTagValue:1.0
 */
static const value_string org_csapi_cm_TpTagValue[] = {

    { 0, "PROVIDER_SPECIFIED" },
    { 1, "OPERATOR_SPECIFIED" },
    { 2, "UNSPECIFIED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpSiteOrSap:1.0
 */
static const value_string org_csapi_cm_TpSiteOrSap[] = {

    { 0, "SITE" },
    { 1, "SAP" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpIPVersion:1.0
 */
static const value_string org_csapi_cm_TpIPVersion[] = {

    { 0, "VERSION_UNKNOWN" },
    { 1, "VERSION_IPV4" },
    { 2, "VERSION_IPV6" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpIPv4AddType:1.0
 */
static const value_string org_csapi_cm_TpIPv4AddType[] = {

    { 0, "IPV4_ADD_CLASS_A" },
    { 1, "IPV4_ADD_CLASS_B" },
    { 2, "IPV4_ADD_CLASS_C" },
    { 3, "IPV4_ADD_CLASS_D" },
    { 4, "IPV4_ADD_CLASS_E" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpAction:1.0
 */
static const value_string org_csapi_cm_TpAction[] = {

    { 0, "DROP" },
    { 1, "TRANSMIT" },
    { 2, "RESHAPE" },
    { 3, "REMARK" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cm/TpVprpStatus:1.0
 */
static const value_string org_csapi_cm_TpVprpStatus[] = {

    { 0, "ACTIVE" },
    { 1, "PENDING" },
    { 2, "DISALLOWED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/am/TpChargingEventName:1.0
 */
static const value_string org_csapi_am_TpChargingEventName[] = {

    { 0, "P_AM_CHARGING" },
    { 1, "P_AM_RECHARGING" },
    { 2, "P_AM_ACCOUNT_LOW" },
    { 3, "P_AM_ACCOUNT_ZERO" },
    { 4, "P_AM_ACCOUNT_DISABLED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/am/TpBalanceQueryError:1.0
 */
static const value_string org_csapi_am_TpBalanceQueryError[] = {

    { 0, "P_BALANCE_QUERY_OK" },
    { 1, "P_BALANCE_QUERY_ERROR_UNDEFINED" },
    { 2, "P_BALANCE_QUERY_UNKNOWN_SUBSCRIBER" },
    { 3, "P_BALANCE_QUERY_UNAUTHORIZED_APPLICATION" },
    { 4, "P_BALANCE_QUERY_SYSTEM_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/am/TpTransactionHistoryStatus:1.0
 */
static const value_string org_csapi_am_TpTransactionHistoryStatus[] = {

    { 0, "P_AM_TRANSACTION_ERROR_UNSPECIFIED" },
    { 1, "P_AM_TRANSACTION_INVALID_INTERVAL" },
    { 2, "P_AM_TRANSACTION_UNKNOWN_ACCOUNT" },
    { 3, "P_AM_TRANSACTION_UNAUTHORIZED_APPLICATION" },
    { 4, "P_AM_TRANSACTION_PROCESSING_ERROR" },
    { 5, "P_AM_TRANSACTION_SYSTEM_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/am/TpVoucherError:1.0
 */
static const value_string org_csapi_am_TpVoucherError[] = {

    { 0, "P_VOUCHER_OK" },
    { 1, "P_VOUCHER_UNDEFINED" },
    { 2, "P_VOUCHER_UNKNOWN_SUBSCRIBER" },
    { 3, "P_VOUCHER_UNAUTHORIZED_APPLICATION" },
    { 4, "P_VOUCHER_SYSTEM_FAILURE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cs/TpChargingParameterValueType:1.0
 */
static const value_string org_csapi_cs_TpChargingParameterValueType[] = {

    { 0, "P_CHS_PARAMETER_INT32" },
    { 1, "P_CHS_PARAMETER_FLOAT" },
    { 2, "P_CHS_PARAMETER_STRING" },
    { 3, "P_CHS_PARAMETER_BOOLEAN" },
    { 4, "P_CHS_PARAMETER_OCTETSET" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cs/TpChargingError:1.0
 */
static const value_string org_csapi_cs_TpChargingError[] = {

    { 0, "P_CHS_ERR_UNDEFINED" },
    { 1, "P_CHS_ERR_ACCOUNT" },
    { 2, "P_CHS_ERR_USER" },
    { 3, "P_CHS_ERR_PARAMETER" },
    { 4, "P_CHS_ERR_NO_DEBIT" },
    { 5, "P_CHS_ERR_NO_CREDIT" },
    { 6, "P_CHS_ERR_VOLUMES" },
    { 7, "P_CHS_ERR_CURRENCY" },
    { 8, "P_CHS_ERR_NO_EXTEND" },
    { 9, "P_CHS_ERR_RESERVATION_LIMIT" },
    { 10, "P_CHS_ERR_CONFIRMATION_REQUIRED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cs/TpSessionEndedCause:1.0
 */
static const value_string org_csapi_cs_TpSessionEndedCause[] = {

    { 0, "P_CHS_CAUSE_UNDEFINED" },
    { 1, "P_CHS_CAUSE_TIMER_EXPIRED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/cs/TpAppInformationType:1.0
 */
static const value_string org_csapi_cs_TpAppInformationType[] = {

    { 0, "P_APP_INF_TIMESTAMP" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/policy/TpPolicyConditionListType:1.0
 */
static const value_string org_csapi_policy_TpPolicyConditionListType[] = {

    { 0, "P_PM_DNF" },
    { 1, "P_PM_CNF" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/policy/TpPolicyConditionType:1.0
 */
static const value_string org_csapi_policy_TpPolicyConditionType[] = {

    { 0, "P_PM_TIME_PERIOD_CONDITION" },
    { 1, "P_PM_EVENT_CONDITION" },
    { 2, "P_PM_EXPRESSION_CONDITION" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/policy/TpPolicyActionType:1.0
 */
static const value_string org_csapi_policy_TpPolicyActionType[] = {

    { 0, "P_PM_EVENT_ACTION" },
    { 1, "P_PM_EXPRESSION_ACTION" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/policy/TpPolicyTypeInfo:1.0
 */
static const value_string org_csapi_policy_TpPolicyTypeInfo[] = {

    { 0, "P_PM_SIMPLE_TYPE" },
    { 1, "P_PM_TYPE_RECORD" },
    { 2, "P_PM_TYPE_LIST" },
    { 3, "P_PM_STRUCTURED_TYPE" },
    { 4, "P_PM_XML_TYPE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMContextName:1.0
 */
static const value_string org_csapi_pam_TpPAMContextName[] = {

    { 0, "PAM_CONTEXT_ANY" },
    { 1, "PAM_CONTEXT_COMMUNICATION" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMACLDefault:1.0
 */
static const value_string org_csapi_pam_TpPAMACLDefault[] = {

    { 0, "PAM_ACCESS_ALLOW" },
    { 1, "PAM_ACCESS_DENY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMPreferenceType:1.0
 */
static const value_string org_csapi_pam_TpPAMPreferenceType[] = {

    { 0, "PAM_ACCESS_LIST" },
    { 1, "PAM_EXTERNAL_CONTROL" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMEventName:1.0
 */
static const value_string org_csapi_pam_TpPAMEventName[] = {

    { 0, "PAM_CE_IDENTITY_PRESENCE_SET" },
    { 1, "PAM_CE_AVAILABILITY_CHANGED" },
    { 2, "PAM_CE_WATCHERS_CHANGED" },
    { 3, "PAM_CE_IDENTITY_CREATED" },
    { 4, "PAM_CE_IDENTITY_DELETED" },
    { 5, "PAM_CE_GROUP_MEMBERSHIP_CHANGED" },
    { 6, "PAM_CE_AGENT_CREATED" },
    { 7, "PAM_CE_AGENT_DELETED" },
    { 8, "PAM_CE_AGENT_ASSIGNED" },
    { 9, "PAM_CE_AGENT_UNASSIGNED" },
    { 10, "PAM_CE_CAPABILITY_CHANGED" },
    { 11, "PAM_CE_AGENT_CAPABILITY_PRESENCE_SET" },
    { 12, "PAM_CE_AGENT_PRESENCE_SET" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMwatcherChangeType:1.0
 */
static const value_string org_csapi_pam_TpPAMwatcherChangeType[] = {

    { 0, "PAM_WATCHERS_PERIODIC" },
    { 1, "PAM_WATCHERS_ADDED" },
    { 2, "PAM_WATCHERS_DELETED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/pam/TpPAMErrorCause:1.0
 */
static const value_string org_csapi_pam_TpPAMErrorCause[] = {

    { 0, "P_PAM_CAUSE_UNDEFINED" },
    { 1, "P_PAM_CAUSE_INVALID_ADDRESS" },
    { 2, "P_PAM_CAUSE_SYSTEM_FAILURE" },
    { 3, "P_PAM_CAUSE_INFO_UNAVAILABLE" },
    { 4, "P_PAM_CAUSE_EVENT_REGISTRATION_CANCELLED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpFolderInfoPropertyName:1.0
 */
static const value_string org_csapi_mmm_TpFolderInfoPropertyName[] = {

    { 0, "P_MMM_FOLDER_UNDEFINED" },
    { 1, "P_MMM_FOLDER_DATE_CREATED" },
    { 2, "P_MMM_FOLDER_DATE_CHANGED" },
    { 3, "P_MMM_FOLDER_SIZE" },
    { 4, "P_MMM_FOLDER_NUMBER_OF_MESSAGES" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMailboxInfoPropertyName:1.0
 */
static const value_string org_csapi_mmm_TpMailboxInfoPropertyName[] = {

    { 0, "P_MMM_MAILBOX_UNDEFINED" },
    { 1, "P_MMM_MAILBOX_OWNER" },
    { 2, "P_MMM_MAILBOX_DATE_CREATED" },
    { 3, "P_MMM_MAILBOX_DATE_CHANGED" },
    { 4, "P_MMM_MAILBOX_SIZE" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessageInfoPropertyName:1.0
 */
static const value_string org_csapi_mmm_TpMessageInfoPropertyName[] = {

    { 0, "P_MMM_MESSAGE_UNDEFINED" },
    { 1, "P_MMM_MESSAGE_DATE_CREATED" },
    { 2, "P_MMM_MESSAGE_DATE_RECEIVED" },
    { 3, "P_MMM_MESSAGE_DATE_CHANGED" },
    { 4, "P_MMM_MESSAGE_SIZE" },
    { 5, "P_MMM_MESSAGE_STATUS" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessagePriority:1.0
 */
static const value_string org_csapi_mmm_TpMessagePriority[] = {

    { 0, "P_MMM_MESSAGE_PRIORITY_UNDEFINED" },
    { 1, "P_MMM_MESSAGE_PRIORITY_HIGH" },
    { 2, "P_MMM_MESSAGE_PRIORITY_LOW" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessageHeaderFieldType:1.0
 */
static const value_string org_csapi_mmm_TpMessageHeaderFieldType[] = {

    { 0, "P_MESSAGE_DATE_SENT" },
    { 1, "P_MESSAGE_SENT_FROM" },
    { 2, "P_MESSAGE_SENDER" },
    { 3, "P_MESSAGE_REPLY_TO" },
    { 4, "P_MESSAGE_SENT_TO" },
    { 5, "P_MESSAGE_CC_TO" },
    { 6, "P_MESSAGE_BCC_TO" },
    { 7, "P_MESSAGE_RFC822_MESSAGE_ID" },
    { 8, "P_MESSAGE_IN_REPLY_TO" },
    { 9, "P_MESSAGE_REFERENCES" },
    { 10, "P_MESSAGE_SUBJECT" },
    { 11, "P_MESSAGE_COMMENTS" },
    { 12, "P_MESSAGE_KEYWORDS" },
    { 13, "P_MESSAGE_TRACE_FIELD" },
    { 14, "P_MESSAGE_RESENT_FIELD" },
    { 15, "P_MESSAGE_MIME_VERSION" },
    { 16, "P_MESSAGE_MIME_CONTENT" },
    { 17, "P_MESSAGE_MIME_ENCODING" },
    { 18, "P_MESSAGE_MIME_ID" },
    { 19, "P_MESSAGE_MIME_DESCRIPTION" },
    { 20, "P_MESSAGE_MIME_DISPOSITION" },
    { 21, "P_MESSAGE_MIME_EXTENSION_FIELD" },
    { 22, "P_MESSAGE_EXTENSION_FIELD" },
    { 23, "P_MESSAGE_PRIORITY" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMailboxMessageStatus:1.0
 */
static const value_string org_csapi_mmm_TpMailboxMessageStatus[] = {

    { 0, "P_MMM_RECEIVED_MSG_STATUS_READ" },
    { 1, "P_MMM_RECEIVED_MSG_STATUS_UNREAD" },
    { 2, "P_MMM_RECEIVED_MSG_STATUS_FORWARDED" },
    { 3, "P_MMM_RECEIVED_MSG_STATUS_REPLIED_TO" },
    { 4, "P_MMM_DRAFT_MSG_STATUS_SAVED_OR_UNSENT" },
    { 5, "P_MMM_SENT_MSG_STATUS_SENT" },
    { 6, "P_MMM_SENT_MSG_STATUS_DELIVERED" },
    { 7, "P_MMM_SENT_MSG_STATUS_READ" },
    { 8, "P_MMM_SENT_MSG_STATUS_DELETED_UNREAD" },
    { 9, "P_MMM_SENT_MSG_STATUS_NOT_DELIVERABLE" },
    { 10, "P_MMM_SENT_MSG_STATUS_EXPIRED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpSetPropertyError:1.0
 */
static const value_string org_csapi_mmm_TpSetPropertyError[] = {

    { 0, "P_MMM_PROPERTY_NOT_SET" },
    { 1, "P_MMM_PROPERTY_READONLY" },
    { 2, "P_MMM_PROPERTY_INSUFFICIENT_PRIVILEGE" },
    { 3, "P_MMM_PROPERTY_NAME_UNKNOWN" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessagingEventName:1.0
 */
static const value_string org_csapi_mmm_TpMessagingEventName[] = {

    { 0, "P_EVENT_MSG_NAME_UNDEFINED" },
    { 1, "P_EVENT_MSG_NEW_MAILBOX_MESSAGE_ARRIVED" },
    { 2, "P_EVENT_MSG_NEW_MESSAGE_ARRIVED" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpDeliveryTimeType:1.0
 */
static const value_string org_csapi_mmm_TpDeliveryTimeType[] = {

    { 0, "P_MMM_SEND_IMMEDIATE" },
    { 1, "P_MMM_DELIVERY_TIME" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessageTreatmentType:1.0
 */
static const value_string org_csapi_mmm_TpMessageTreatmentType[] = {

    { 0, "P_MMM_TREATMENT_UNDEFINED" },
    { 1, "P_MMM_TREATMENT_REPORT_REQUESTED" },
    { 2, "P_MMM_TREATMENT_BILLING_ID" },
    { 3, "P_MMM_TREATMENT_DELIVERY_TIME" },
    { 4, "P_MMM_TREATMENT_VALIDITY_TIME" },
    { 0,       NULL },
};

/*
 * Enum = IDL:org/csapi/mmm/TpMessagingError:1.0
 */
static const value_string org_csapi_mmm_TpMessagingError[] = {

    { 0, "P_MMM_ERROR_UNDEFINED" },
    { 1, "P_MMM_ERROR_INVALID_AUTHENTICATION_INFORMATION" },
    { 2, "P_MMM_ERROR_INVALID_MAILBOX" },
    { 3, "P_MMM_ERROR_INVALID_DELIVERY_TYPE" },
    { 4, "P_MMM_ERROR_MAX_MESSAGE_SIZE_EXCEEDED" },
    { 5, "P_MMM_ERROR_INVALID_FOLDER_ID" },
    { 6, "P_MMM_ERROR_INVALID_MESSAGE_ID" },
    { 7, "P_MMM_ERROR_INVALID_PART_ID" },
    { 8, "P_MMM_ERROR_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH" },
    { 9, "P_MMM_ERROR_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH" },
    { 10, "P_MMM_ERROR_INVALID_DELIVERY_TIME" },
    { 11, "P_MMM_ERROR_INVALID_VALIDITY_TIME" },
    { 12, "P_MMM_ERROR_MAX_SUBJECT_SIZE_EXCEEDED" },
    { 13, "P_MMM_ERROR_INVALID_ID" },
    { 14, "P_MMM_ERROR_INVALID_NESTING_LEVEL" },
    { 15, "P_MMM_ERROR_INVALID_CRITERIA" },
    { 16, "P_MMM_ERROR_INFORMATION_NOT_AVAILABLE" },
    { 17, "P_MMM_ERROR_CANNOT_CANCEL" },
    { 18, "P_MMM_ERROR_INVALID_HEADER" },
    { 19, "P_MMM_INVALID_NETWORK_STATE" },
    { 20, "P_MMM_ERROR_RESOURCE_UNAVAILABLE" },
    { 21, "P_MMM_ERROR_RESOURCE_TIMEOUT" },
    { 0,       NULL },
};

/*
 * IDL Enums End
 */

/*  Begin Exception Helper Functions  */


/* Exception = IDL:org/csapi/P_INVALID_ASSIGNMENT_ID:1.0 */
static void
decode_ex_org_csapi_P_INVALID_ASSIGNMENT_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_ASSIGNMENT_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_TIME_AND_DATE_FORMAT:1.0 */
static void
decode_ex_org_csapi_P_INVALID_TIME_AND_DATE_FORMAT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_TIME_AND_DATE_FORMAT_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_EVENT_TYPE:1.0 */
static void
decode_ex_org_csapi_P_INVALID_EVENT_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_EVENT_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_INTERFACE_NAME:1.0 */
static void
decode_ex_org_csapi_P_INVALID_INTERFACE_NAME(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_INTERFACE_NAME_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_INTERFACE_TYPE:1.0 */
static void
decode_ex_org_csapi_P_INVALID_INTERFACE_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_INTERFACE_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_UNKNOWN_SUBSCRIBER:1.0 */
static void
decode_ex_org_csapi_P_UNKNOWN_SUBSCRIBER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_UNKNOWN_SUBSCRIBER_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INFORMATION_NOT_AVAILABLE:1.0 */
static void
decode_ex_org_csapi_P_INFORMATION_NOT_AVAILABLE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INFORMATION_NOT_AVAILABLE_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_CRITERIA:1.0 */
static void
decode_ex_org_csapi_P_INVALID_CRITERIA(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_CRITERIA_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_SESSION_ID:1.0 */
static void
decode_ex_org_csapi_P_INVALID_SESSION_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_SESSION_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/TpCommonExceptions:1.0 */
static void
decode_ex_org_csapi_TpCommonExceptions(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    proto_tree_add_int(tree, hf_org_csapi_TpCommonExceptions_ExceptionType, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_TpCommonExceptions_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_CURRENCY:1.0 */
static void
decode_ex_org_csapi_P_INVALID_CURRENCY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_CURRENCY_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_AMOUNT:1.0 */
static void
decode_ex_org_csapi_P_INVALID_AMOUNT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_AMOUNT_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_APPLICATION_NOT_ACTIVATED:1.0 */
static void
decode_ex_org_csapi_P_APPLICATION_NOT_ACTIVATED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_APPLICATION_NOT_ACTIVATED_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_ADDRESS:1.0 */
static void
decode_ex_org_csapi_P_INVALID_ADDRESS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_ADDRESS_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_UNSUPPORTED_ADDRESS_PLAN:1.0 */
static void
decode_ex_org_csapi_P_UNSUPPORTED_ADDRESS_PLAN(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_UNSUPPORTED_ADDRESS_PLAN_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_UNAUTHORISED_PARAMETER_VALUE:1.0 */
static void
decode_ex_org_csapi_P_UNAUTHORISED_PARAMETER_VALUE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_UNAUTHORISED_PARAMETER_VALUE_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_VERSION:1.0 */
static void
decode_ex_org_csapi_P_INVALID_VERSION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_VERSION_ExtraInformation);

}

/* Exception = IDL:org/csapi/P_INVALID_NETWORK_STATE:1.0 */
static void
decode_ex_org_csapi_P_INVALID_NETWORK_STATE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_P_INVALID_NETWORK_STATE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SERVICE_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SERVICE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SERVICE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_SERVICE_ACCESS_DENIED:1.0 */
static void
decode_ex_org_csapi_fw_P_SERVICE_ACCESS_DENIED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_SERVICE_ACCESS_DENIED_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_ACCESS_DENIED:1.0 */
static void
decode_ex_org_csapi_fw_P_ACCESS_DENIED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_ACCESS_DENIED_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_SERVICE_NOT_ENABLED:1.0 */
static void
decode_ex_org_csapi_fw_P_SERVICE_NOT_ENABLED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_SERVICE_NOT_ENABLED_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY:1.0 */
static void
decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_AGREEMENT_TEXT:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_AGREEMENT_TEXT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_AGREEMENT_TEXT_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SERVICE_TOKEN:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SERVICE_TOKEN(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SERVICE_TOKEN_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SIGNATURE:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SIGNATURE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SIGNATURE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SIGNING_ALGORITHM:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SIGNING_ALGORITHM(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SIGNING_ALGORITHM_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_DOMAIN_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_DOMAIN_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_DOMAIN_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_PROPERTY:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_PROPERTY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_PROPERTY_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_ACCESS_TYPE:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_ACCESS_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_ACCESS_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_ILLEGAL_SERVICE_TYPE:1.0 */
static void
decode_ex_org_csapi_fw_P_ILLEGAL_SERVICE_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_ILLEGAL_SERVICE_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_UNKNOWN_SERVICE_TYPE:1.0 */
static void
decode_ex_org_csapi_fw_P_UNKNOWN_SERVICE_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_UNKNOWN_SERVICE_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_MISSING_MANDATORY_PROPERTY:1.0 */
static void
decode_ex_org_csapi_fw_P_MISSING_MANDATORY_PROPERTY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_MISSING_MANDATORY_PROPERTY_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_DUPLICATE_PROPERTY_NAME:1.0 */
static void
decode_ex_org_csapi_fw_P_DUPLICATE_PROPERTY_NAME(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_DUPLICATE_PROPERTY_NAME_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_PROPERTY_TYPE_MISMATCH:1.0 */
static void
decode_ex_org_csapi_fw_P_PROPERTY_TYPE_MISMATCH(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_PROPERTY_TYPE_MISMATCH_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_CLIENT_APP_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_CLIENT_APP_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_CLIENT_APP_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_AUTH_TYPE:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_AUTH_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_AUTH_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SAG_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SAG_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SAG_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SERVICE_PROFILE_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SERVICE_PROFILE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SERVICE_PROFILE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SERVICE_CONTRACT_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SERVICE_CONTRACT_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SERVICE_CONTRACT_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_ACTIVITY_TEST_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_ACTIVITY_TEST_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_ACTIVITY_TEST_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_ILLEGAL_SERVICE_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_ILLEGAL_SERVICE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_ILLEGAL_SERVICE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_UNKNOWN_SERVICE_ID:1.0 */
static void
decode_ex_org_csapi_fw_P_UNKNOWN_SERVICE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_UNKNOWN_SERVICE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_SERVICE_TYPE_UNAVAILABLE:1.0 */
static void
decode_ex_org_csapi_fw_P_SERVICE_TYPE_UNAVAILABLE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_SERVICE_TYPE_UNAVAILABLE_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_ADDITION_TO_SAG:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_ADDITION_TO_SAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_ADDITION_TO_SAG_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT:1.0 */
static void
decode_ex_org_csapi_fw_P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM:1.0 */
static void
decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM_ExtraInformation);

}

/* Exception = IDL:org/csapi/fw/P_NO_ACCEPTABLE_SIGNING_ALGORITHM:1.0 */
static void
decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_SIGNING_ALGORITHM(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_P_NO_ACCEPTABLE_SIGNING_ALGORITHM_ExtraInformation);

}

/* Exception = IDL:org/csapi/ui/P_ID_NOT_FOUND:1.0 */
static void
decode_ex_org_csapi_ui_P_ID_NOT_FOUND(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_ui_P_ID_NOT_FOUND_ExtraInformation);

}

/* Exception = IDL:org/csapi/ui/P_ILLEGAL_ID:1.0 */
static void
decode_ex_org_csapi_ui_P_ILLEGAL_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_ui_P_ILLEGAL_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/ui/P_ILLEGAL_RANGE:1.0 */
static void
decode_ex_org_csapi_ui_P_ILLEGAL_RANGE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_ui_P_ILLEGAL_RANGE_ExtraInformation);

}

/* Exception = IDL:org/csapi/ui/P_INVALID_COLLECTION_CRITERIA:1.0 */
static void
decode_ex_org_csapi_ui_P_INVALID_COLLECTION_CRITERIA(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_ui_P_INVALID_COLLECTION_CRITERIA_ExtraInformation);

}

/* Exception = IDL:org/csapi/mm/P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED:1.0 */
static void
decode_ex_org_csapi_mm_P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mm_P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED_ExtraInformation);

}

/* Exception = IDL:org/csapi/mm/P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED:1.0 */
static void
decode_ex_org_csapi_mm_P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mm_P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED_ExtraInformation);

}

/* Exception = IDL:org/csapi/mm/P_INVALID_REPORTING_INTERVAL:1.0 */
static void
decode_ex_org_csapi_mm_P_INVALID_REPORTING_INTERVAL(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mm_P_INVALID_REPORTING_INTERVAL_ExtraInformation);

}

/* Exception = IDL:org/csapi/mm/P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED:1.0 */
static void
decode_ex_org_csapi_mm_P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mm_P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED_ExtraInformation);

}

/* Exception = IDL:org/csapi/termcap/P_INVALID_TERMINAL_ID:1.0 */
static void
decode_ex_org_csapi_termcap_P_INVALID_TERMINAL_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_termcap_P_INVALID_TERMINAL_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_INVALID_FOLDER_ID:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_INVALID_FOLDER_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_INVALID_FOLDER_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_INSUFFICIENT_PRIVILEGE:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_INSUFFICIENT_PRIVILEGE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_INSUFFICIENT_PRIVILEGE_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_INVALID_AUTHENTICATION_INFORMATION:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_INVALID_AUTHENTICATION_INFORMATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_INVALID_AUTHENTICATION_INFORMATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_INVALID_MAILBOX:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_INVALID_MAILBOX(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_INVALID_MAILBOX_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_INVALID_MESSAGE_ID:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_INVALID_MESSAGE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_INVALID_MESSAGE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_LOCKING_LOCKED_MAILBOX:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_LOCKING_LOCKED_MAILBOX(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_LOCKING_LOCKED_MAILBOX_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_MESSAGE_NOT_REMOVED:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_MESSAGE_NOT_REMOVED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_MESSAGE_NOT_REMOVED_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_NUMBER_NOT_POSITIVE:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_NUMBER_NOT_POSITIVE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_NUMBER_NOT_POSITIVE_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_UNLOCKING_UNLOCKED_MAILBOX:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_UNLOCKING_UNLOCKED_MAILBOX(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_UNLOCKING_UNLOCKED_MAILBOX_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_MAILBOX_LOCKED:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_MAILBOX_LOCKED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_MAILBOX_LOCKED_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_CANNOT_UNLOCK_MAILBOX:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_CANNOT_UNLOCK_MAILBOX(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_CANNOT_UNLOCK_MAILBOX_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_PROPERTY_NOT_SET:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_PROPERTY_NOT_SET(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_PROPERTY_NOT_SET_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_FOLDER_IS_OPEN:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_FOLDER_IS_OPEN(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_FOLDER_IS_OPEN_ExtraInformation);

}

/* Exception = IDL:org/csapi/gms/P_GMS_MAILBOX_OPEN:1.0 */
static void
decode_ex_org_csapi_gms_P_GMS_MAILBOX_OPEN(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_gms_P_GMS_MAILBOX_OPEN_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_VPRP_ID:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_VPRP_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_VPRP_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SLA_ID:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SLA_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SLA_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_STATUS:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_STATUS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_STATUS_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_QOS_INFO:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_QOS_INFO(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_QOS_INFO_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_VALIDITY_INFO:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_VALIDITY_INFO(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_VALIDITY_INFO_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_PIPEQOSINFO:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_PIPEQOSINFO(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_PIPEQOSINFO_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_DSCODEPOINT:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_DSCODEPOINT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_DSCODEPOINT_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_VPRPID:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_VPRPID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_VPRPID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_REF_VALUE:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_REF_VALUE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_REF_VALUE_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_INTERFACE:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_INTERFACE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_INTERFACE_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_CANT_DELETE_VPRP:1.0 */
static void
decode_ex_org_csapi_cm_P_CANT_DELETE_VPRP(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_CANT_DELETE_VPRP_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_TEMPLATES:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_TEMPLATES(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_TEMPLATES_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_MENU:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_MENU(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_MENU_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_ENTERPRISE_NETWORK:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_ENTERPRISE_NETWORK(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_ENTERPRISE_NETWORK_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_TEMPLATE_TYPE:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_TEMPLATE_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_TEMPLATE_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_DESCRIPTION:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_DESCRIPTION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_DESCRIPTION_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_SLA_ID:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_SLA_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_SLA_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_TAG:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_TAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_TAG_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_VALUE:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_VALUE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_VALUE_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_COMBINATION:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_COMBINATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_COMBINATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SITES:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SITES(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SITES_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_VPRN:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_VPRN(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_VPRN_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_ILLEGAL_SITE_ID:1.0 */
static void
decode_ex_org_csapi_cm_P_ILLEGAL_SITE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_ILLEGAL_SITE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SITE_ID:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SITE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SITE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SAPS:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SAPS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SAPS_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SITE_LOCATION:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SITE_LOCATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SITE_LOCATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SITE_DESCRIPTION:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SITE_DESCRIPTION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SITE_DESCRIPTION_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_IPSUBNET:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_IPSUBNET(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_IPSUBNET_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_SAP:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_SAP(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_SAP_ExtraInformation);

}

/* Exception = IDL:org/csapi/cm/P_UNKNOWN_VPRP:1.0 */
static void
decode_ex_org_csapi_cm_P_UNKNOWN_VPRP(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cm_P_UNKNOWN_VPRP_ExtraInformation);

}

/* Exception = IDL:org/csapi/am/P_UNAUTHORIZED_APPLICATION:1.0 */
static void
decode_ex_org_csapi_am_P_UNAUTHORIZED_APPLICATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_am_P_UNAUTHORIZED_APPLICATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/cs/P_INVALID_USER:1.0 */
static void
decode_ex_org_csapi_cs_P_INVALID_USER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cs_P_INVALID_USER_ExtraInformation);

}

/* Exception = IDL:org/csapi/cs/P_INVALID_ACCOUNT:1.0 */
static void
decode_ex_org_csapi_cs_P_INVALID_ACCOUNT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cs_P_INVALID_ACCOUNT_ExtraInformation);

}

/* Exception = IDL:org/csapi/cs/P_INVALID_REQUEST_NUMBER:1.0 */
static void
decode_ex_org_csapi_cs_P_INVALID_REQUEST_NUMBER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cs_P_INVALID_REQUEST_NUMBER_ExtraInformation);

}

/* Exception = IDL:org/csapi/cs/P_INVALID_VOLUME:1.0 */
static void
decode_ex_org_csapi_cs_P_INVALID_VOLUME(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cs_P_INVALID_VOLUME_ExtraInformation);

}

/* Exception = IDL:org/csapi/policy/P_ACCESS_VIOLATION:1.0 */
static void
decode_ex_org_csapi_policy_P_ACCESS_VIOLATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_policy_P_ACCESS_VIOLATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/policy/P_SYNTAX_ERROR:1.0 */
static void
decode_ex_org_csapi_policy_P_SYNTAX_ERROR(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_policy_P_SYNTAX_ERROR_ExtraInformation);

}

/* Exception = IDL:org/csapi/policy/P_NAME_SPACE_ERROR:1.0 */
static void
decode_ex_org_csapi_policy_P_NAME_SPACE_ERROR(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_policy_P_NAME_SPACE_ERROR_ExtraInformation);

}

/* Exception = IDL:org/csapi/policy/P_NO_TRANSACTION_IN_PROCESS:1.0 */
static void
decode_ex_org_csapi_policy_P_NO_TRANSACTION_IN_PROCESS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_policy_P_NO_TRANSACTION_IN_PROCESS_ExtraInformation);

}

/* Exception = IDL:org/csapi/policy/P_TRANSACTION_IN_PROCESS:1.0 */
static void
decode_ex_org_csapi_policy_P_TRANSACTION_IN_PROCESS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_policy_P_TRANSACTION_IN_PROCESS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_TYPE:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_MEMBER:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_MEMBER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_MEMBER_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_IDENTITY:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_IDENTITY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_IDENTITY_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_GROUP:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_GROUP(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_GROUP_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_CAPABILITY:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_CAPABILITY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_CAPABILITY_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTES:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTES(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTES_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTE:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTE_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_ASSIGNMENT:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ASSIGNMENT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_ASSIGNMENT_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_ALIAS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ALIAS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_ALIAS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNKNOWN_AGENT:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNKNOWN_AGENT(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNKNOWN_AGENT_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNASSIGNED_ALIAS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNASSIGNED_ALIAS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNASSIGNED_ALIAS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_TYPE_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_TYPE_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_TYPE_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_TYPE_ASSOCIATED:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_TYPE_ASSOCIATED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_TYPE_ASSOCIATED_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_NOT_REGISTERED:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_NOT_REGISTERED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_NOT_REGISTERED_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_NOT_MEMBER:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_NOT_MEMBER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_NOT_MEMBER_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_NO_CAPABILITY:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_NO_CAPABILITY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_NO_CAPABILITY_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_MEMBER_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_MEMBER_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_MEMBER_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_IS_CYCLIC:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_IS_CYCLIC(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_IS_CYCLIC_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_IDENTITY_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_IDENTITY_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_IDENTITY_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_DISASSOCIATED_TYPE:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_DISASSOCIATED_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_DISASSOCIATED_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_ATTRIBUTE_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_ATTRIBUTE_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_ATTRIBUTE_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_ALIAS_NOT_UNIQUE:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_ALIAS_NOT_UNIQUE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_ALIAS_NOT_UNIQUE_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_ALIAS_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_ALIAS_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_ALIAS_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_AGENT_EXISTS:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_AGENT_EXISTS(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_AGENT_EXISTS_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_UNAVAILABLE_INTERFACE:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_UNAVAILABLE_INTERFACE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_UNAVAILABLE_INTERFACE_ExtraInformation);

}

/* Exception = IDL:org/csapi/pam/P_PAM_INVALID_CREDENTIAL:1.0 */
static void
decode_ex_org_csapi_pam_P_PAM_INVALID_CREDENTIAL(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_pam_P_PAM_INVALID_CREDENTIAL_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_AUTHENTICATION_INFORMATION:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_AUTHENTICATION_INFORMATION(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_AUTHENTICATION_INFORMATION_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_MAILBOX:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_MAILBOX(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_MAILBOX_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TYPE:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TYPE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TYPE_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_MAX_MESSAGE_SIZE_EXCEEDED:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_MAX_MESSAGE_SIZE_EXCEEDED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_MAX_MESSAGE_SIZE_EXCEEDED_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_FOLDER_ID:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_FOLDER_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_FOLDER_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_MESSAGE_ID:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_MESSAGE_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_MESSAGE_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_PART_ID:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_PART_ID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_PART_ID_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_PROPERTY:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_PROPERTY(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_PROPERTY_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TIME:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TIME(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TIME_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_VALIDITY_TIME:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_VALIDITY_TIME(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_VALIDITY_TIME_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_MAX_SUBJECT_SIZE_EXCEEDED:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_MAX_SUBJECT_SIZE_EXCEEDED(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_MAX_SUBJECT_SIZE_EXCEEDED_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INFORMATION_NOT_AVAILABLE:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INFORMATION_NOT_AVAILABLE(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INFORMATION_NOT_AVAILABLE_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_CANNOT_CANCEL:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_CANNOT_CANCEL(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_CANNOT_CANCEL_ExtraInformation);

}

/* Exception = IDL:org/csapi/mmm/P_MMM_INVALID_HEADER:1.0 */
static void
decode_ex_org_csapi_mmm_P_MMM_INVALID_HEADER(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, int *offset _U_, MessageHeader *header _U_, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_item *item _U_;

    giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_mmm_P_MMM_INVALID_HEADER_ExtraInformation);

}


/*  End Exception Helper Functions  */

/*
 * Main delegator for exception handling
 *
 */
static gboolean
decode_user_exception(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *ptree _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    proto_tree *tree _U_;

    if (!header->exception_id)
        return FALSE;

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_ASSIGNMENT_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_ASSIGNMENT_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_ASSIGNMENT_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_TIME_AND_DATE_FORMAT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_TIME_AND_DATE_FORMAT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_TIME_AND_DATE_FORMAT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_EVENT_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_EVENT_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_EVENT_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_INTERFACE_NAME:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_INTERFACE_NAME(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_INTERFACE_NAME:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_INTERFACE_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_INTERFACE_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_INTERFACE_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_UNKNOWN_SUBSCRIBER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_UNKNOWN_SUBSCRIBER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_UNKNOWN_SUBSCRIBER:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INFORMATION_NOT_AVAILABLE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INFORMATION_NOT_AVAILABLE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INFORMATION_NOT_AVAILABLE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_CRITERIA:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_CRITERIA(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_CRITERIA:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_SESSION_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_SESSION_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_SESSION_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/TpCommonExceptions:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_TpCommonExceptions(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/TpCommonExceptions:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_CURRENCY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_CURRENCY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_CURRENCY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_AMOUNT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_AMOUNT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_AMOUNT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_APPLICATION_NOT_ACTIVATED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_APPLICATION_NOT_ACTIVATED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_APPLICATION_NOT_ACTIVATED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_ADDRESS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_ADDRESS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_ADDRESS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_UNSUPPORTED_ADDRESS_PLAN:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_UNSUPPORTED_ADDRESS_PLAN(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_UNSUPPORTED_ADDRESS_PLAN:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_UNAUTHORISED_PARAMETER_VALUE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_UNAUTHORISED_PARAMETER_VALUE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_UNAUTHORISED_PARAMETER_VALUE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_VERSION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_VERSION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_VERSION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/P_INVALID_NETWORK_STATE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_P_INVALID_NETWORK_STATE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/P_INVALID_NETWORK_STATE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SERVICE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SERVICE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SERVICE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_SERVICE_ACCESS_DENIED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_SERVICE_ACCESS_DENIED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_SERVICE_ACCESS_DENIED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_ACCESS_DENIED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_ACCESS_DENIED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_ACCESS_DENIED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_SERVICE_NOT_ENABLED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_SERVICE_NOT_ENABLED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_SERVICE_NOT_ENABLED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_NO_ACCEPTABLE_ENCRYPTION_CAPABILITY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_AGREEMENT_TEXT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_AGREEMENT_TEXT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_AGREEMENT_TEXT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SERVICE_TOKEN:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SERVICE_TOKEN(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SERVICE_TOKEN:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SIGNATURE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SIGNATURE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SIGNATURE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SIGNING_ALGORITHM:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SIGNING_ALGORITHM(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SIGNING_ALGORITHM:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_DOMAIN_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_DOMAIN_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_DOMAIN_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_PROPERTY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_PROPERTY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_PROPERTY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_ACCESS_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_ACCESS_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_ACCESS_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_ILLEGAL_SERVICE_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_ILLEGAL_SERVICE_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_ILLEGAL_SERVICE_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_UNKNOWN_SERVICE_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_UNKNOWN_SERVICE_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_UNKNOWN_SERVICE_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_MISSING_MANDATORY_PROPERTY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_MISSING_MANDATORY_PROPERTY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_MISSING_MANDATORY_PROPERTY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_DUPLICATE_PROPERTY_NAME:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_DUPLICATE_PROPERTY_NAME(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_DUPLICATE_PROPERTY_NAME:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_PROPERTY_TYPE_MISMATCH:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_PROPERTY_TYPE_MISMATCH(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_PROPERTY_TYPE_MISMATCH:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_CLIENT_APP_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_CLIENT_APP_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_CLIENT_APP_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_AUTH_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_AUTH_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_AUTH_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SAG_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SAG_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SAG_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SERVICE_PROFILE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SERVICE_PROFILE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SERVICE_PROFILE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SERVICE_CONTRACT_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SERVICE_CONTRACT_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SERVICE_CONTRACT_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_ACTIVITY_TEST_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_ACTIVITY_TEST_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_ACTIVITY_TEST_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_ILLEGAL_SERVICE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_ILLEGAL_SERVICE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_ILLEGAL_SERVICE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_UNKNOWN_SERVICE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_UNKNOWN_SERVICE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_UNKNOWN_SERVICE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_SERVICE_TYPE_UNAVAILABLE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_SERVICE_TYPE_UNAVAILABLE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_SERVICE_TYPE_UNAVAILABLE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_ADDITION_TO_SAG:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_ADDITION_TO_SAG(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_ADDITION_TO_SAG:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_INVALID_SAG_TO_SERVICE_PROFILE_ASSIGNMENT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_NO_ACCEPTABLE_AUTHENTICATION_MECHANISM:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/fw/P_NO_ACCEPTABLE_SIGNING_ALGORITHM:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_fw_P_NO_ACCEPTABLE_SIGNING_ALGORITHM(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/fw/P_NO_ACCEPTABLE_SIGNING_ALGORITHM:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/ui/P_ID_NOT_FOUND:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_ui_P_ID_NOT_FOUND(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/ui/P_ID_NOT_FOUND:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/ui/P_ILLEGAL_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_ui_P_ILLEGAL_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/ui/P_ILLEGAL_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/ui/P_ILLEGAL_RANGE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_ui_P_ILLEGAL_RANGE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/ui/P_ILLEGAL_RANGE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/ui/P_INVALID_COLLECTION_CRITERIA:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_ui_P_INVALID_COLLECTION_CRITERIA(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/ui/P_INVALID_COLLECTION_CRITERIA:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mm/P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mm_P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mm/P_REQUESTED_ACCURACY_CANNOT_BE_DELIVERED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mm/P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mm_P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mm/P_REQUESTED_RESPONSE_TIME_CANNOT_BE_DELIVERED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mm/P_INVALID_REPORTING_INTERVAL:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mm_P_INVALID_REPORTING_INTERVAL(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mm/P_INVALID_REPORTING_INTERVAL:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mm/P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mm_P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mm/P_TRIGGER_CONDITIONS_NOT_SUBSCRIBED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/termcap/P_INVALID_TERMINAL_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_termcap_P_INVALID_TERMINAL_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/termcap/P_INVALID_TERMINAL_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_INVALID_FOLDER_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_INVALID_FOLDER_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_INVALID_FOLDER_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_INSUFFICIENT_PRIVILEGE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_INSUFFICIENT_PRIVILEGE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_INSUFFICIENT_PRIVILEGE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_INVALID_AUTHENTICATION_INFORMATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_INVALID_AUTHENTICATION_INFORMATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_INVALID_AUTHENTICATION_INFORMATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_INVALID_MAILBOX:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_INVALID_MAILBOX(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_INVALID_MAILBOX:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_INVALID_MESSAGE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_INVALID_MESSAGE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_INVALID_MESSAGE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_LOCKING_LOCKED_MAILBOX:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_LOCKING_LOCKED_MAILBOX(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_LOCKING_LOCKED_MAILBOX:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_MESSAGE_NOT_REMOVED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_MESSAGE_NOT_REMOVED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_MESSAGE_NOT_REMOVED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_NUMBER_NOT_POSITIVE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_NUMBER_NOT_POSITIVE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_NUMBER_NOT_POSITIVE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_UNLOCKING_UNLOCKED_MAILBOX:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_UNLOCKING_UNLOCKED_MAILBOX(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_UNLOCKING_UNLOCKED_MAILBOX:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_MAILBOX_LOCKED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_MAILBOX_LOCKED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_MAILBOX_LOCKED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_CANNOT_UNLOCK_MAILBOX:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_CANNOT_UNLOCK_MAILBOX(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_CANNOT_UNLOCK_MAILBOX:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_PROPERTY_NOT_SET:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_PROPERTY_NOT_SET(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_PROPERTY_NOT_SET:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_FOLDER_IS_OPEN:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_FOLDER_IS_OPEN(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_FOLDER_IS_OPEN:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/gms/P_GMS_MAILBOX_OPEN:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_gms_P_GMS_MAILBOX_OPEN(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/gms/P_GMS_MAILBOX_OPEN:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_VPRP_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_VPRP_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_VPRP_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SLA_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SLA_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SLA_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_STATUS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_STATUS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_STATUS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_QOS_INFO:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_QOS_INFO(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_QOS_INFO:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_VALIDITY_INFO:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_VALIDITY_INFO(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_VALIDITY_INFO:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_PIPEQOSINFO:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_PIPEQOSINFO(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_PIPEQOSINFO:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_DSCODEPOINT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_DSCODEPOINT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_DSCODEPOINT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_VPRPID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_VPRPID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_VPRPID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_REF_VALUE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_REF_VALUE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_REF_VALUE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_INTERFACE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_INTERFACE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_INTERFACE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_CANT_DELETE_VPRP:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_CANT_DELETE_VPRP(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_CANT_DELETE_VPRP:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_TEMPLATES:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_TEMPLATES(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_TEMPLATES:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_MENU:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_MENU(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_MENU:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_ENTERPRISE_NETWORK:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_ENTERPRISE_NETWORK(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_ENTERPRISE_NETWORK:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_TEMPLATE_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_TEMPLATE_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_TEMPLATE_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_DESCRIPTION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_DESCRIPTION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_DESCRIPTION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_SLA_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_SLA_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_SLA_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_TAG:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_TAG(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_TAG:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_VALUE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_VALUE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_VALUE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_COMBINATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_COMBINATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_COMBINATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SITES:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SITES(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SITES:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_VPRN:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_VPRN(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_VPRN:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_ILLEGAL_SITE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_ILLEGAL_SITE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_ILLEGAL_SITE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SITE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SITE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SITE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SAPS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SAPS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SAPS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SITE_LOCATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SITE_LOCATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SITE_LOCATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SITE_DESCRIPTION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SITE_DESCRIPTION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SITE_DESCRIPTION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_IPSUBNET:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_IPSUBNET(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_IPSUBNET:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_SAP:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_SAP(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_SAP:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cm/P_UNKNOWN_VPRP:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cm_P_UNKNOWN_VPRP(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cm/P_UNKNOWN_VPRP:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/am/P_UNAUTHORIZED_APPLICATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_am_P_UNAUTHORIZED_APPLICATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/am/P_UNAUTHORIZED_APPLICATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cs/P_INVALID_USER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cs_P_INVALID_USER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cs/P_INVALID_USER:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cs/P_INVALID_ACCOUNT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cs_P_INVALID_ACCOUNT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cs/P_INVALID_ACCOUNT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cs/P_INVALID_REQUEST_NUMBER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cs_P_INVALID_REQUEST_NUMBER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cs/P_INVALID_REQUEST_NUMBER:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/cs/P_INVALID_VOLUME:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_cs_P_INVALID_VOLUME(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/cs/P_INVALID_VOLUME:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/policy/P_ACCESS_VIOLATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_policy_P_ACCESS_VIOLATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/policy/P_ACCESS_VIOLATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/policy/P_SYNTAX_ERROR:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_policy_P_SYNTAX_ERROR(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/policy/P_SYNTAX_ERROR:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/policy/P_NAME_SPACE_ERROR:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_policy_P_NAME_SPACE_ERROR(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/policy/P_NAME_SPACE_ERROR:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/policy/P_NO_TRANSACTION_IN_PROCESS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_policy_P_NO_TRANSACTION_IN_PROCESS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/policy/P_NO_TRANSACTION_IN_PROCESS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/policy/P_TRANSACTION_IN_PROCESS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_policy_P_TRANSACTION_IN_PROCESS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/policy/P_TRANSACTION_IN_PROCESS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_MEMBER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_MEMBER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_MEMBER:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_IDENTITY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_IDENTITY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_IDENTITY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_GROUP:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_GROUP(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_GROUP:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_CAPABILITY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_CAPABILITY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_CAPABILITY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTES:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTES(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTES:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ATTRIBUTE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_ATTRIBUTE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_ASSIGNMENT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ASSIGNMENT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_ASSIGNMENT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_ALIAS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_ALIAS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_ALIAS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNKNOWN_AGENT:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNKNOWN_AGENT(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNKNOWN_AGENT:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNASSIGNED_ALIAS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNASSIGNED_ALIAS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNASSIGNED_ALIAS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_TYPE_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_TYPE_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_TYPE_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_TYPE_ASSOCIATED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_TYPE_ASSOCIATED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_TYPE_ASSOCIATED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_NOT_REGISTERED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_NOT_REGISTERED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_NOT_REGISTERED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_NOT_MEMBER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_NOT_MEMBER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_NOT_MEMBER:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_NO_CAPABILITY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_NO_CAPABILITY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_NO_CAPABILITY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_MEMBER_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_MEMBER_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_MEMBER_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_IS_CYCLIC:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_IS_CYCLIC(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_IS_CYCLIC:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_IDENTITY_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_IDENTITY_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_IDENTITY_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_DISASSOCIATED_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_DISASSOCIATED_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_DISASSOCIATED_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_ATTRIBUTE_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_ATTRIBUTE_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_ATTRIBUTE_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_ALIAS_NOT_UNIQUE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_ALIAS_NOT_UNIQUE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_ALIAS_NOT_UNIQUE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_ALIAS_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_ALIAS_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_ALIAS_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_AGENT_EXISTS:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_AGENT_EXISTS(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_AGENT_EXISTS:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_UNAVAILABLE_INTERFACE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_UNAVAILABLE_INTERFACE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_UNAVAILABLE_INTERFACE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/pam/P_PAM_INVALID_CREDENTIAL:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_pam_P_PAM_INVALID_CREDENTIAL(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/pam/P_PAM_INVALID_CREDENTIAL:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_AUTHENTICATION_INFORMATION:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_AUTHENTICATION_INFORMATION(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_AUTHENTICATION_INFORMATION:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_MAILBOX:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_MAILBOX(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_MAILBOX:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TYPE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TYPE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TYPE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_MAX_MESSAGE_SIZE_EXCEEDED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_MAX_MESSAGE_SIZE_EXCEEDED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_MAX_MESSAGE_SIZE_EXCEEDED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_FOLDER_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_FOLDER_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_FOLDER_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_MESSAGE_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_MESSAGE_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_MESSAGE_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_PART_ID:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_PART_ID(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_PART_ID:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_ADDRESS_TYPE_MISMATCH:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_DELIVERY_TYPE_MESSAGE_TYPE_MISMATCH:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_PROPERTY:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_PROPERTY(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_PROPERTY:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TIME:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_DELIVERY_TIME(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_DELIVERY_TIME:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_VALIDITY_TIME:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_VALIDITY_TIME(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_VALIDITY_TIME:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_MAX_SUBJECT_SIZE_EXCEEDED:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_MAX_SUBJECT_SIZE_EXCEEDED(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_MAX_SUBJECT_SIZE_EXCEEDED:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INFORMATION_NOT_AVAILABLE:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INFORMATION_NOT_AVAILABLE(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INFORMATION_NOT_AVAILABLE:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_CANNOT_CANCEL:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_CANNOT_CANCEL(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_CANNOT_CANCEL:1.0  */
        return TRUE;
    }

    if (strcmp(header->exception_id, "IDL:org/csapi/mmm/P_MMM_INVALID_HEADER:1.0") == 0) {
        tree = start_dissecting(tvb, pinfo, ptree, offset);
        decode_ex_org_csapi_mmm_P_MMM_INVALID_HEADER(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);   /*  IDL:org/csapi/mmm/P_MMM_INVALID_HEADER:1.0  */
        return TRUE;
    }


    return FALSE;    /* user exception not found */
}

/*
 * IDL:org/csapi/IpService/setCallback:1.0
 */
static void
decode_org_csapi_IpService_setCallback(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/IpService/setCallbackWithSessionID:1.0
 */
static void
decode_org_csapi_IpService_setCallbackWithSessionID(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        proto_tree_add_int(tree, hf_org_csapi_IpService_setCallbackWithSessionID_sessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpInitial/initiateAuthentication:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthentication(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpAuthDomain"  */
        decode_org_csapi_fw_TpAuthDomain_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpAuthDomain"  */
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthentication_authType);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpAuthDomain"  */
            decode_org_csapi_fw_TpAuthDomain_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpAuthDomain"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpInitial/initiateAuthenticationWithVersion:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthenticationWithVersion(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpAuthDomain"  */
        decode_org_csapi_fw_TpAuthDomain_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpAuthDomain"  */
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthenticationWithVersion_authType);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpInitial_initiateAuthenticationWithVersion_frameworkVersion);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpAuthDomain"  */
            decode_org_csapi_fw_TpAuthDomain_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpAuthDomain"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAuthentication/requestAccess:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAuthentication_requestAccess(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAuthentication_requestAccess_accessType);

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpClientAccess/terminateAccess:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_terminationText);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_signingAlgorithm);

        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature=0; i_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature; i_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAccess_terminateAccess_digitalSignature, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/obtainInterface:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterface(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterface_interfaceName);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/obtainInterfaceWithCallback:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterfaceWithCallback(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_obtainInterfaceWithCallback_interfaceName);

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/endAccess:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties=0; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_endAccess_endAccessProperties++) {

            /*  Begin struct "org_csapi_fw_TpProperty"  */
            decode_org_csapi_fw_TpProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpProperty"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/listInterfaces:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return);

            for (i_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return=0; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_listInterfaces_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/releaseInterface:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_releaseInterface(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_releaseInterface_interfaceName);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/selectSigningAlgorithm:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_selectSigningAlgorithm(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_selectSigningAlgorithm_signingAlgorithmCaps);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_selectSigningAlgorithm_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/terminateAccess:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_terminationText);

        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature=0; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_terminateAccess_digitalSignature, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAccess/relinquishInterface:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_interfaceName);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_terminationText);

        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature=0; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature; i_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAccess_relinquishInterface_digitalSignature, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpClientAPILevelAuthentication/authenticate:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge;
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge=0; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_challenge, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return);

            for (i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return=0; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return++) {

                proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticate_return, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpClientAPILevelAuthentication/abortAuthentication:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_abortAuthentication(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpClientAPILevelAuthentication/authenticationSucceeded:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_authenticationSucceeded(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpClientAPILevelAuthentication/challenge:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge;
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge=0; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_challenge, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return);

            for (i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return=0; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return; i_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return++) {

                proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpClientAPILevelAuthentication_challenge_return, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/selectEncryptionMethod:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectEncryptionMethod(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectEncryptionMethod_encryptionCaps);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectEncryptionMethod_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/authenticate:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge;
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge=0; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_challenge, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return);

            for (i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return=0; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return++) {

                proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticate_return, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/abortAuthentication:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_abortAuthentication(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/authenticationSucceeded:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_authenticationSucceeded(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/selectAuthenticationMechanism:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectAuthenticationMechanism(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectAuthenticationMechanism_authMechanismList);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_selectAuthenticationMechanism_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_access/trust_and_security/IpAPILevelAuthentication/challenge:1.0
 */
static void
decode_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge;
    guint32   u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return;
    guint32   i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge);

        for (i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge=0; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_challenge, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return);

            for (i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return=0; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return < u_octet4_loop_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return; i_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return++) {

                proto_tree_add_uint(tree, hf_org_csapi_fw_fw_access_trust_and_security_IpAPILevelAuthentication_challenge_return, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/notification/IpAppEventNotification/reportNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_notification_IpAppEventNotification_reportNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventInfo"  */
        decode_org_csapi_fw_TpFwEventInfo_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventInfo"  */
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_notification_IpAppEventNotification_reportNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/notification/IpAppEventNotification/notificationTerminated:1.0
 */
static void
decode_org_csapi_fw_fw_application_notification_IpAppEventNotification_notificationTerminated(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/notification/IpEventNotification/createNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_notification_IpEventNotification_createNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventCriteria"  */
        decode_org_csapi_fw_TpFwEventCriteria_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventCriteria"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_notification_IpEventNotification_createNotification_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/notification/IpEventNotification/destroyNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_notification_IpEventNotification_destroyNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_notification_IpEventNotification_destroyNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/activityTestRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestRes_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestRes_activityTestResult);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/appActivityTestReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appActivityTestReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appActivityTestReq_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/fwFaultReportInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultReportInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultReportInd_fault, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/fwFaultRecoveryInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultRecoveryInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwFaultRecoveryInd_fault, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/svcUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcUnavailableInd_serviceID);

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcUnavailableInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/genFaultStatsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordRes_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/fwUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwUnavailableInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/activityTestErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_activityTestErr_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/genFaultStatsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordErr_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/appUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_appUnavailableInd_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/genFaultStatsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_genFaultStatsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/svcAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcAvailStatusInd_serviceID);

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_svcAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/generateFaultStatisticsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordRes_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/generateFaultStatisticsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics;
    guint32   u_octet4;
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics=0; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics++) {

            u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_faultStatistics, tvb, *offset-4, 4, u_octet4);

        }

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordErr_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/generateFaultStatisticsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppFaultManager/fwAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppFaultManager_fwAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryAppLoadReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryAppLoadReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryLoadRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics=0; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryLoadErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/loadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics=0; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_loadLevelNotification_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/resumeNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_resumeNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/suspendNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_suspendNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/createLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_createLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/destroyLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_destroyLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryAppLoadStatsReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryAppLoadStatsReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryAppLoadStatsReq_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryLoadStatsRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics=0; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics; i_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppLoadManager/queryLoadStatsErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsErr_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpAppLoadManager_queryLoadStatsErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/reportLoad:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_reportLoad(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_reportLoad_loadLevel, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryLoadReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadReq_serviceIDs);

        }

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryAppLoadRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryAppLoadErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/createLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_createLoadLevelNotification_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/destroyLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_destroyLoadLevelNotification_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/resumeNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_resumeNotification_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/suspendNotification:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_suspendNotification_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryLoadStatsReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryLoadStatsReq_serviceIDs);

        }

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryAppLoadStatsRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics);

        for (i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics=0; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics; i_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpLoadManager/queryAppLoadStatsErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsErr_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpLoadManager_queryAppLoadStatsErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppOAM/systemDateTimeQuery:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppOAM_systemDateTimeQuery(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppOAM_systemDateTimeQuery_systemDateAndTime);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpAppOAM_systemDateTimeQuery_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpOAM/systemDateTimeQuery:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpOAM_systemDateTimeQuery(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpOAM_systemDateTimeQuery_clientDateAndTime);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpOAM_systemDateTimeQuery_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/activityTestReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_activityTestReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_activityTestReq_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_activityTestReq_svcID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/appActivityTestRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestRes_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestRes_activityTestResult);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/svcUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_svcUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_svcUnavailableInd_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/genFaultStatsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordReq_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/appActivityTestErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appActivityTestErr_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/appUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_appUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appUnavailableInd_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/genFaultStatsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/genFaultStatsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_genFaultStatsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/appAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_appAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_appAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/generateFaultStatisticsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs;
    guint32   i_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs);

        for (i_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs=0; i_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs < u_octet4_loop_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs; i_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordReq_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/generateFaultStatisticsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpFaultManager/generateFaultStatisticsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_integrity_IpFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpHeartBeatMgmt/enableHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_enableHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_enableHeartBeat_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpHeartBeatMgmt/disableHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_disableHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpHeartBeatMgmt/changeInterval:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_changeInterval(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpHeartBeatMgmt_changeInterval_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppHeartBeat/pulse:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppHeartBeat_pulse(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpHeartBeat/pulse:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpHeartBeat_pulse(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppHeartBeatMgmt/enableAppHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_enableAppHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_enableAppHeartBeat_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppHeartBeatMgmt/disableAppHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_disableAppHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/integrity/IpAppHeartBeatMgmt/changeInterval:1.0
 */
static void
decode_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_changeInterval(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_integrity_IpAppHeartBeatMgmt_changeInterval_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/discovery/IpServiceDiscovery/listServiceTypes:1.0
 */
static void
decode_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return;
    guint32   i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return);

            for (i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return=0; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return < u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listServiceTypes_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/discovery/IpServiceDiscovery/describeServiceType:1.0
 */
static void
decode_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_describeServiceType(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_describeServiceType_name);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpServiceTypeDescription"  */
            decode_org_csapi_fw_TpServiceTypeDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceTypeDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/discovery/IpServiceDiscovery/discoverService:1.0
 */
static void
decode_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList;
    guint32   i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList;
    guint32   u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return;
    guint32   i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_serviceTypeName);

        u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList);

        for (i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList=0; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList < u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_desiredPropertyList++) {

            /*  Begin struct "org_csapi_fw_TpServiceProperty"  */
            decode_org_csapi_fw_TpServiceProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProperty"  */
        }

        proto_tree_add_int(tree, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_max, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return);

            for (i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return=0; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return < u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_discoverService_return++) {

                /*  Begin struct "org_csapi_fw_TpService"  */
                decode_org_csapi_fw_TpService_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpService"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/discovery/IpServiceDiscovery/listSubscribedServices:1.0
 */
static void
decode_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return;
    guint32   i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return);

            for (i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return=0; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return < u_octet4_loop_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return; i_org_csapi_fw_fw_application_discovery_IpServiceDiscovery_listSubscribedServices_return++) {

                /*  Begin struct "org_csapi_fw_TpService"  */
                decode_org_csapi_fw_TpService_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpService"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpAppServiceAgreementManagement/signServiceAgreement:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return;
    guint32   i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_serviceToken);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_agreementText);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_signingAlgorithm);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return);

            for (i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return=0; i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return < u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return; i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return++) {

                proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_signServiceAgreement_return, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpAppServiceAgreementManagement/terminateServiceAgreement:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature;
    guint32   i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_serviceToken);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_terminationText);

        u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature);

        for (i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature=0; i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature < u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature; i_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpAppServiceAgreementManagement_terminateServiceAgreement_digitalSignature, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpServiceAgreementManagement/signServiceAgreement:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_serviceToken);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_agreementText);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_signServiceAgreement_signingAlgorithm);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpSignatureAndServiceMgr"  */
            decode_org_csapi_fw_TpSignatureAndServiceMgr_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpSignatureAndServiceMgr"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpServiceAgreementManagement/terminateServiceAgreement:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature;
    guint32   i_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_serviceToken);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_terminationText);

        u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature);

        for (i_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature=0; i_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature < u_octet4_loop_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature; i_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature++) {

            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_terminateServiceAgreement_digitalSignature, tvb, *offset-1, 1, get_CDR_octet(tvb,offset));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpServiceAgreementManagement/selectService:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_selectService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_selectService_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_selectService_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_application/service_agreement/IpServiceAgreementManagement/initiateSignServiceAgreement:1.0
 */
static void
decode_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_initiateSignServiceAgreement(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_application_service_agreement_IpServiceAgreementManagement_initiateSignServiceAgreement_serviceToken);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/createServiceProfile:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_createServiceProfile(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpServiceProfileDescription"  */
        decode_org_csapi_fw_TpServiceProfileDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpServiceProfileDescription"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_createServiceProfile_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/modifyServiceProfile:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_modifyServiceProfile(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpServiceProfile"  */
        decode_org_csapi_fw_TpServiceProfile_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpServiceProfile"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/deleteServiceProfile:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deleteServiceProfile(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deleteServiceProfile_serviceProfileID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/assign:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_assign(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_assign_sagID);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_assign_serviceProfileID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/deassign:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deassign(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deassign_sagID);

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_deassign_serviceProfileID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileManagement/requestConflictInfo:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileManagement_requestConflictInfo_return++) {

                /*  Begin struct "org_csapi_fw_TpAssignSagToServiceProfileConflict"  */
                decode_org_csapi_fw_TpAssignSagToServiceProfileConflict_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpAssignSagToServiceProfileConflict"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileInfoQuery/listServiceProfiles:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listServiceProfiles_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileInfoQuery/describeServiceProfile:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_describeServiceProfile(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_describeServiceProfile_serviceProfileID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpServiceProfileDescription"  */
            decode_org_csapi_fw_TpServiceProfileDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProfileDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceProfileInfoQuery/listAssignedMembers:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_serviceProfileID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceProfileInfoQuery_listAssignedMembers_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractManagement/createServiceContract:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_createServiceContract(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpServiceContractDescription"  */
        decode_org_csapi_fw_TpServiceContractDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpServiceContractDescription"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_createServiceContract_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractManagement/modifyServiceContract:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_modifyServiceContract(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpServiceContract"  */
        decode_org_csapi_fw_TpServiceContract_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpServiceContract"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractManagement/deleteServiceContract:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_deleteServiceContract(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractManagement_deleteServiceContract_serviceContractID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractInfoQuery/describeServiceContract:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_describeServiceContract(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_describeServiceContract_serviceContractID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpServiceContractDescription"  */
            decode_org_csapi_fw_TpServiceContractDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceContractDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractInfoQuery/listServiceContracts:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceContracts_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpServiceContractInfoQuery/listServiceProfiles:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_serviceContractID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpServiceContractInfoQuery_listServiceProfiles_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpEntOpAccountManagement/modifyEntOpAccount:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties);

        for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_modifyEntOpAccount_enterpriseOperatorProperties++) {

            /*  Begin struct "org_csapi_fw_TpProperty"  */
            decode_org_csapi_fw_TpProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpProperty"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpEntOpAccountManagement/deleteEntOpAccount:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountManagement_deleteEntOpAccount(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpEntOpAccountInfoQuery/describeEntOpAccount:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpEntOpAccountInfoQuery_describeEntOpAccount(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpEntOp"  */
            decode_org_csapi_fw_TpEntOp_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpEntOp"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/createClientApp:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createClientApp(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpClientAppDescription"  */
        decode_org_csapi_fw_TpClientAppDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpClientAppDescription"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/modifyClientApp:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_modifyClientApp(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpClientAppDescription"  */
        decode_org_csapi_fw_TpClientAppDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpClientAppDescription"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/deleteClientApp:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteClientApp(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteClientApp_clientAppID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/createSAG:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpSag"  */
        decode_org_csapi_fw_TpSag_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpSag"  */
        u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs);

        for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_createSAG_clientAppIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/modifySAG:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_modifySAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpSag"  */
        decode_org_csapi_fw_TpSag_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpSag"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/deleteSAG:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteSAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_deleteSAG_sagID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/addSAGMembers:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_sagID);

        u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs);

        for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_addSAGMembers_clientAppIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/removeSAGMembers:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_sagID);

        u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList);

        for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_removeSAGMembers_clientAppIDList);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppManagement/requestConflictInfo:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppManagement_requestConflictInfo_return++) {

                /*  Begin struct "org_csapi_fw_TpAddSagMembersConflict"  */
                decode_org_csapi_fw_TpAddSagMembersConflict_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpAddSagMembersConflict"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/describeClientApp:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeClientApp(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeClientApp_clientAppID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpClientAppDescription"  */
            decode_org_csapi_fw_TpClientAppDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpClientAppDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/listClientApps:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientApps_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/describeSAG:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeSAG(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeSAG_sagID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_describeSAG_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/listSAGs:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGs_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/listSAGMembers:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_sagID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listSAGMembers_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/service_subscription/IpClientAppInfoQuery/listClientAppMembership:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return;
    guint32   i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_clientAppID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return);

            for (i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return=0; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return < u_octet4_loop_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return; i_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_enterprise_operator_service_subscription_IpClientAppInfoQuery_listClientAppMembership_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/notification/IpClientEventNotification/reportNotification:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_notification_IpClientEventNotification_reportNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventInfo"  */
        decode_org_csapi_fw_TpFwEventInfo_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventInfo"  */
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_enterprise_operator_notification_IpClientEventNotification_reportNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/notification/IpClientEventNotification/notificationTerminated:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_notification_IpClientEventNotification_notificationTerminated(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/notification/IpEventNotification/createNotification:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_createNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventCriteria"  */
        decode_org_csapi_fw_TpFwEventCriteria_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventCriteria"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_createNotification_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_enterprise_operator/notification/IpEventNotification/destroyNotification:1.0
 */
static void
decode_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_destroyNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_enterprise_operator_notification_IpEventNotification_destroyNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/discovery/IpFwServiceDiscovery/listServiceTypes:1.0
 */
static void
decode_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return;
    guint32   i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return);

            for (i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return=0; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return < u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return++) {

                giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listServiceTypes_return);

            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/discovery/IpFwServiceDiscovery/describeServiceType:1.0
 */
static void
decode_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_describeServiceType(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_describeServiceType_name);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpServiceTypeDescription"  */
            decode_org_csapi_fw_TpServiceTypeDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceTypeDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/discovery/IpFwServiceDiscovery/discoverService:1.0
 */
static void
decode_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList;
    guint32   i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList;
    guint32   u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return;
    guint32   i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_serviceTypeName);

        u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList);

        for (i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList=0; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList < u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_desiredPropertyList++) {

            /*  Begin struct "org_csapi_fw_TpServiceProperty"  */
            decode_org_csapi_fw_TpServiceProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProperty"  */
        }

        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_max, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return);

            for (i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return=0; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return < u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_discoverService_return++) {

                /*  Begin struct "org_csapi_fw_TpService"  */
                decode_org_csapi_fw_TpService_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpService"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/discovery/IpFwServiceDiscovery/listRegisteredServices:1.0
 */
static void
decode_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return;
    guint32   i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return);

            for (i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return=0; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return < u_octet4_loop_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return; i_org_csapi_fw_fw_service_discovery_IpFwServiceDiscovery_listRegisteredServices_return++) {

                /*  Begin struct "org_csapi_fw_TpService"  */
                decode_org_csapi_fw_TpService_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_fw_TpService"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_lifecycle/IpServiceInstanceLifecycleManager/createServiceManager:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties;
    guint32   i_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_application);

        u_octet4_loop_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties);

        for (i_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties=0; i_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties < u_octet4_loop_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties; i_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceProperties++) {

            /*  Begin struct "org_csapi_fw_TpServiceProperty"  */
            decode_org_csapi_fw_TpServiceProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProperty"  */
        }

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_createServiceManager_serviceInstanceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_lifecycle/IpServiceInstanceLifecycleManager/destroyServiceManager:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_destroyServiceManager(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_lifecycle_IpServiceInstanceLifecycleManager_destroyServiceManager_serviceInstance);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/registerService:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList;
    guint32   i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_serviceTypeName);

        u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList);

        for (i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList=0; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList < u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_servicePropertyList++) {

            /*  Begin struct "org_csapi_fw_TpServiceProperty"  */
            decode_org_csapi_fw_TpServiceProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProperty"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerService_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/announceServiceAvailability:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_announceServiceAvailability(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_announceServiceAvailability_serviceID);

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/unregisterService:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unregisterService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unregisterService_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/describeService:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_describeService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_describeService_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_fw_TpServiceDescription"  */
            decode_org_csapi_fw_TpServiceDescription_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceDescription"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/unannounceService:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unannounceService(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_unannounceService_serviceID);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/service_registration/IpFwServiceRegistration/registerServiceSubType:1.0
 */
static void
decode_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList;
    guint32   i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList;
    guint32   u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList;
    guint32   i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_serviceTypeName);

        u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList);

        for (i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList=0; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList < u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_servicePropertyList++) {

            /*  Begin struct "org_csapi_fw_TpServiceProperty"  */
            decode_org_csapi_fw_TpServiceProperty_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceProperty"  */
        }

        u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList);

        for (i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList=0; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList < u_octet4_loop_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList; i_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_extendedServicePropertyList++) {

            /*  Begin struct "org_csapi_fw_TpServiceTypePropertyValue"  */
            decode_org_csapi_fw_TpServiceTypePropertyValue_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpServiceTypePropertyValue"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_service_registration_IpFwServiceRegistration_registerServiceSubType_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/querySvcLoadReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_querySvcLoadReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/queryLoadRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics);

        for (i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics=0; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/queryLoadErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/loadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics;
    guint32   i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics);

        for (i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics=0; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_loadLevelNotification_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/suspendNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_suspendNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/resumeNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_resumeNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/createLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_createLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/destroyLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_destroyLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/querySvcLoadStatsReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_querySvcLoadStatsReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_querySvcLoadStatsReq_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/queryLoadStatsRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics);

        for (i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics=0; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics; i_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcLoadManager/queryLoadStatsErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsErr_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcLoadManager_queryLoadStatsErr_loadStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/reportLoad:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_reportLoad(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_reportLoad_loadLevel, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/queryLoadReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadReq_querySubject, tvb, *offset-4, 4, u_octet4);

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/querySvcLoadRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics);

        for (i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics=0; i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics; i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/querySvcLoadErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadErr_loadStatisticError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/createLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_createLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_createLoadLevelNotification_notificationSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/destroyLoadLevelNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_destroyLoadLevelNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_destroyLoadLevelNotification_notificationSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/suspendNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_suspendNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_suspendNotification_notificationSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/resumeNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_resumeNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_resumeNotification_notificationSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/queryLoadStatsReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadStatsReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadStatsReq_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_queryLoadStatsReq_querySubject, tvb, *offset-4, 4, u_octet4);

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/querySvcLoadStatsRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics;
    guint32   i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics);

        for (i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics=0; i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics; i_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsRes_loadStatistics++) {

            /*  Begin struct "org_csapi_fw_TpLoadStatistic"  */
            decode_org_csapi_fw_TpLoadStatistic_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_fw_TpLoadStatistic"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwLoadManager/querySvcLoadStatsErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsErr_loadStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwLoadManager_querySvcLoadStatsErr_loadStatisticError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/activityTestRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestRes_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestRes_activityTestResult);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/svcActivityTestReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_svcActivityTestReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_svcActivityTestReq_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/fwFaultReportInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultReportInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultReportInd_fault, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/fwFaultRecoveryInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultRecoveryInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwFaultRecoveryInd_fault, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/fwUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwUnavailableInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/svcUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_svcUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/appUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_appUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/genFaultStatsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordRes_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/activityTestErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_activityTestErr_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/genFaultStatsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordErr_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/genFaultStatsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs;
    guint32   i_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs);

        for (i_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs=0; i_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs; i_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_genFaultStatsRecordReq_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/generateFaultStatsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/appAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_appAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_appAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/generateFaultStatisticsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordRes_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/generateFaultStatisticsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordErr_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/generateFaultStatisticsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcFaultManager/fwAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcFaultManager_fwAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/activityTestReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_activityTestReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_activityTestReq_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_activityTestReq_testSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/svcActivityTestRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestRes_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestRes_activityTestResult);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/appUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_appUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/genFaultStatsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordReq_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/svcUnavailableInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcUnavailableInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcUnavailableInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/svcActivityTestErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcActivityTestErr_activityTestID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/genFaultStatsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs;
    guint32   i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs);

        for (i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs=0; i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs; i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordRes_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/genFaultStatsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    guint32   u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs;
    guint32   i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs);

        for (i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs=0; i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs < u_octet4_loop_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs; i_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs++) {

            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_genFaultStatsRecordErr_serviceIDs);

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/generateFaultStatsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/generateFaultStatsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/svcAvailStatusInd:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcAvailStatusInd(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_svcAvailStatusInd_reason, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/generateFaultStatisticsRecordReq:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordReq_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpTimeInterval"  */
        decode_org_csapi_TpTimeInterval_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpTimeInterval"  */
        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordReq_recordSubject, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/generateFaultStatisticsRecordRes:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordRes_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_fw_TpFaultStatsRecord"  */
        decode_org_csapi_fw_TpFaultStatsRecord_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_fw_TpFaultStatsRecord"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwFaultManager/generateFaultStatisticsRecordErr:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordErr_faultStatsReqID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_fw_fw_service_integrity_IpFwFaultManager_generateFaultStatisticsRecordErr_faultStatisticsError, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcOAM/systemDateTimeQuery:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcOAM_systemDateTimeQuery(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpSvcOAM_systemDateTimeQuery_systemDateAndTime);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpSvcOAM_systemDateTimeQuery_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwOAM/systemDateTimeQuery:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwOAM_systemDateTimeQuery(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpFwOAM_systemDateTimeQuery_clientDateAndTime);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_fw_fw_service_integrity_IpFwOAM_systemDateTimeQuery_return);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwHeartBeatMgmt/enableHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_enableHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_enableHeartBeat_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwHeartBeatMgmt/disableHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_disableHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwHeartBeatMgmt/changeInterval:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_changeInterval(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpFwHeartBeatMgmt_changeInterval_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcHeartBeat/pulse:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcHeartBeat_pulse(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpFwHeartBeat/pulse:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpFwHeartBeat_pulse(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcHeartBeatMgmt/enableSvcHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_enableSvcHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_enableSvcHeartBeat_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcHeartBeatMgmt/disableSvcHeartBeat:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_disableSvcHeartBeat(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/integrity/IpSvcHeartBeatMgmt/changeInterval:1.0
 */
static void
decode_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_changeInterval(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_integrity_IpSvcHeartBeatMgmt_changeInterval_interval, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/notification/IpFwEventNotification/createNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_notification_IpFwEventNotification_createNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventCriteria"  */
        decode_org_csapi_fw_TpFwEventCriteria_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventCriteria"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_notification_IpFwEventNotification_createNotification_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/notification/IpFwEventNotification/destroyNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_notification_IpFwEventNotification_destroyNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_notification_IpFwEventNotification_destroyNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/notification/IpSvcEventNotification/reportNotification:1.0
 */
static void
decode_org_csapi_fw_fw_service_notification_IpSvcEventNotification_reportNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin union "org_csapi_fw_TpFwEventInfo"  */
        decode_org_csapi_fw_TpFwEventInfo_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_fw_TpFwEventInfo"  */
        proto_tree_add_int(tree, hf_org_csapi_fw_fw_service_notification_IpSvcEventNotification_reportNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/fw/fw_service/notification/IpSvcEventNotification/notificationTerminated:1.0
 */
static void
decode_org_csapi_fw_fw_service_notification_IpSvcEventNotification_notificationTerminated(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/routeRes:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_routeRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_routeRes_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_gccs_TpCallReport"  */
        decode_org_csapi_cc_gccs_TpCallReport_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallReport"  */
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_routeRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/routeErr:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_routeErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_routeErr_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_routeErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/getCallInfoRes:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_getCallInfoRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_getCallInfoRes_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_gccs_TpCallInfoReport"  */
        decode_org_csapi_cc_gccs_TpCallInfoReport_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallInfoReport"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/getCallInfoErr:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_getCallInfoErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_getCallInfoErr_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/superviseCallRes:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_superviseCallRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_report, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_superviseCallRes_usedTime, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/superviseCallErr:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_superviseCallErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_superviseCallErr_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/callFaultDetected:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_callFaultDetected(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_callFaultDetected_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_gccs_IpAppCall_callFaultDetected_fault, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/getMoreDialledDigitsRes:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsRes_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        giop_add_CDR_string(tree, tvb, offset, stream_is_big_endian, boundary, hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsRes_digits);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/getMoreDialledDigitsErr:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_getMoreDialledDigitsErr_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCall/callEnded:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCall_callEnded(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCall_callEnded_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_gccs_TpCallEndedReport"  */
        decode_org_csapi_cc_gccs_TpCallEndedReport_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallEndedReport"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/routeReq:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_routeReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_responseRequested;
    guint32   i_org_csapi_cc_gccs_IpCall_routeReq_responseRequested;
    guint32   u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_appInfo;
    guint32   i_org_csapi_cc_gccs_IpCall_routeReq_appInfo;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_routeReq_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_responseRequested = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_gccs_IpCall_routeReq_responseRequested_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_responseRequested);

        for (i_org_csapi_cc_gccs_IpCall_routeReq_responseRequested=0; i_org_csapi_cc_gccs_IpCall_routeReq_responseRequested < u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_responseRequested; i_org_csapi_cc_gccs_IpCall_routeReq_responseRequested++) {

            /*  Begin struct "org_csapi_cc_gccs_TpCallReportRequest"  */
            decode_org_csapi_cc_gccs_TpCallReportRequest_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_gccs_TpCallReportRequest"  */
        }

        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_appInfo = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_gccs_IpCall_routeReq_appInfo_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_appInfo);

        for (i_org_csapi_cc_gccs_IpCall_routeReq_appInfo=0; i_org_csapi_cc_gccs_IpCall_routeReq_appInfo < u_octet4_loop_org_csapi_cc_gccs_IpCall_routeReq_appInfo; i_org_csapi_cc_gccs_IpCall_routeReq_appInfo++) {

            /*  Begin union "org_csapi_cc_gccs_TpCallAppInfo"  */
            decode_org_csapi_cc_gccs_TpCallAppInfo_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

            /*  End union "org_csapi_cc_gccs_TpCallAppInfo"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_routeReq_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/release:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_release(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_release_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_gccs_TpCallReleaseCause"  */
        decode_org_csapi_cc_gccs_TpCallReleaseCause_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallReleaseCause"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/deassignCall:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_deassignCall(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_deassignCall_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/getCallInfoReq:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_getCallInfoReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_getCallInfoReq_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_getCallInfoReq_callInfoRequested, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/setCallChargePlan:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_setCallChargePlan(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_setCallChargePlan_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallChargePlan"  */
        decode_org_csapi_cc_TpCallChargePlan_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallChargePlan"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/setAdviceOfCharge:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_setAdviceOfCharge(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_setAdviceOfCharge_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpAoCInfo"  */
        decode_org_csapi_TpAoCInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAoCInfo"  */
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_setAdviceOfCharge_tariffSwitch, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/getMoreDialledDigitsReq:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_getMoreDialledDigitsReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_getMoreDialledDigitsReq_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_getMoreDialledDigitsReq_length, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/superviseCallReq:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_superviseCallReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_superviseCallReq_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_superviseCallReq_time, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_superviseCallReq_treatment, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCall/continueProcessing:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCall_continueProcessing(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCall_continueProcessing_callSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callAborted:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callAborted(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_callAborted_callReference, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callEventNotify:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callEventNotify(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        /*  Begin struct "org_csapi_cc_gccs_TpCallIdentifier"  */
        decode_org_csapi_cc_gccs_TpCallIdentifier_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallIdentifier"  */
        /*  Begin struct "org_csapi_cc_gccs_TpCallEventInfo"  */
        decode_org_csapi_cc_gccs_TpCallEventInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallEventInfo"  */
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_callEventNotify_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callNotificationInterrupted:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callNotificationInterrupted(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callNotificationContinued:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callNotificationContinued(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callOverloadEncountered:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadEncountered(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadEncountered_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/callOverloadCeased:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadCeased(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_callOverloadCeased_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpAppCallControlManager/abortMultipleCalls:1.0
 */
static void
decode_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet;
    guint32   i_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        u_octet4_loop_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet);

        for (i_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet=0; i_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet < u_octet4_loop_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet; i_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet++) {

            proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpAppCallControlManager_abortMultipleCalls_callReferenceSet, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/createCall:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_createCall(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_cc_gccs_TpCallIdentifier"  */
            decode_org_csapi_cc_gccs_TpCallIdentifier_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_gccs_TpCallIdentifier"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/enableCallNotification:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_enableCallNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        /*  Begin struct "org_csapi_cc_gccs_TpCallEventCriteria"  */
        decode_org_csapi_cc_gccs_TpCallEventCriteria_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallEventCriteria"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCallControlManager_enableCallNotification_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/disableCallNotification:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_disableCallNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCallControlManager_disableCallNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/setCallLoadControl:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_setCallLoadControl(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCallControlManager_setCallLoadControl_duration, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin union "org_csapi_cc_TpCallLoadControlMechanism"  */
        decode_org_csapi_cc_TpCallLoadControlMechanism_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_cc_TpCallLoadControlMechanism"  */
        /*  Begin struct "org_csapi_cc_gccs_TpCallTreatment"  */
        decode_org_csapi_cc_gccs_TpCallTreatment_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallTreatment"  */
        /*  Begin struct "org_csapi_TpAddressRange"  */
        decode_org_csapi_TpAddressRange_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddressRange"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCallControlManager_setCallLoadControl_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/changeCallNotification:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_changeCallNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_gccs_IpCallControlManager_changeCallNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_gccs_TpCallEventCriteria"  */
        decode_org_csapi_cc_gccs_TpCallEventCriteria_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_gccs_TpCallEventCriteria"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/gccs/IpCallControlManager/getCriteria:1.0
 */
static void
decode_org_csapi_cc_gccs_IpCallControlManager_getCriteria(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return;
    guint32   i_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return);

            for (i_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return=0; i_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return < u_octet4_loop_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return; i_org_csapi_cc_gccs_IpCallControlManager_getCriteria_return++) {

                /*  Begin struct "org_csapi_cc_gccs_TpCallEventCriteriaResult"  */
                decode_org_csapi_cc_gccs_TpCallEventCriteriaResult_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_cc_gccs_TpCallEventCriteriaResult"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/eventReportRes:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_eventReportRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_eventReportRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallEventInfo"  */
        decode_org_csapi_cc_TpCallEventInfo_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallEventInfo"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/eventReportErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_eventReportErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_eventReportErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/attachMediaRes:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/attachMediaErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_attachMediaErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/detachMediaRes:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/detachMediaErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_detachMediaErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/getInfoRes:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_getInfoRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_getInfoRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallLegInfoReport"  */
        decode_org_csapi_cc_TpCallLegInfoReport_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallLegInfoReport"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/getInfoErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_getInfoErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_getInfoErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/routeErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_routeErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_routeErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/superviseRes:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_report, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseRes_usedTime, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/superviseErr:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_superviseErr(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_superviseErr_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallError"  */
        decode_org_csapi_cc_TpCallError_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallError"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpAppCallLeg/callLegEnded:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpAppCallLeg_callLegEnded(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_callLegEnded_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_mpccs_IpAppCallLeg_callLegEnded_cause, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/createCall:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_createCall(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_cc_mpccs_TpMultiPartyCallIdentifier"  */
            decode_org_csapi_cc_mpccs_TpMultiPartyCallIdentifier_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_mpccs_TpMultiPartyCallIdentifier"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/createNotification:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_createNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        /*  Begin struct "org_csapi_cc_TpCallNotificationRequest"  */
        decode_org_csapi_cc_TpCallNotificationRequest_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallNotificationRequest"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_createNotification_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/destroyNotification:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_destroyNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_destroyNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/changeNotification:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_changeNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_changeNotification_assignmentID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_cc_TpCallNotificationRequest"  */
        decode_org_csapi_cc_TpCallNotificationRequest_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallNotificationRequest"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/getNotification:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return;
    guint32   i_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            u_octet4_loop_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
            proto_tree_add_uint(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return);

            for (i_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return=0; i_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return < u_octet4_loop_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return; i_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNotification_return++) {

                /*  Begin struct "org_csapi_cc_TpNotificationRequested"  */
                decode_org_csapi_cc_TpNotificationRequested_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
                /*  End struct "org_csapi_cc_TpNotificationRequested"  */
            }

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/setCallLoadControl:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_setCallLoadControl(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_setCallLoadControl_duration, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin union "org_csapi_cc_TpCallLoadControlMechanism"  */
        decode_org_csapi_cc_TpCallLoadControlMechanism_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

        /*  End union "org_csapi_cc_TpCallLoadControlMechanism"  */
        /*  Begin struct "org_csapi_cc_TpCallTreatment"  */
        decode_org_csapi_cc_TpCallTreatment_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallTreatment"  */
        /*  Begin struct "org_csapi_TpAddressRange"  */
        decode_org_csapi_TpAddressRange_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddressRange"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_setCallLoadControl_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/enableNotifications:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_enableNotifications(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        get_CDR_object(tvb, pinfo, tree, offset, stream_is_big_endian, boundary);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_enableNotifications_return, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/disableNotifications:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_disableNotifications(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpMultiPartyCallControlManager/getNextNotification:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNextNotification(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_boolean(tree, hf_org_csapi_cc_mpccs_IpMultiPartyCallControlManager_getNextNotification_reset, tvb, *offset-1, 1, get_CDR_boolean(tvb,offset));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_cc_TpNotificationRequestedSetEntry"  */
            decode_org_csapi_cc_TpNotificationRequestedSetEntry_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_TpNotificationRequestedSetEntry"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/routeReq:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_routeReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo;
    guint32   i_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_routeReq_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        /*  Begin struct "org_csapi_TpAddress"  */
        decode_org_csapi_TpAddress_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_TpAddress"  */
        u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo);

        for (i_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo=0; i_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo < u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo; i_org_csapi_cc_mpccs_IpCallLeg_routeReq_appInfo++) {

            /*  Begin union "org_csapi_cc_TpCallAppInfo"  */
            decode_org_csapi_cc_TpCallAppInfo_un(tvb, pinfo, tree, offset, header, operation, stream_is_big_endian);

            /*  End union "org_csapi_cc_TpCallAppInfo"  */
        }

        /*  Begin struct "org_csapi_cc_TpCallLegConnectionProperties"  */
        decode_org_csapi_cc_TpCallLegConnectionProperties_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
        /*  End struct "org_csapi_cc_TpCallLegConnectionProperties"  */
        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/eventReportReq:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_eventReportReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested;
    guint32   i_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested = get_CDR_ulong(tvb, offset, stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested_loop, tvb,*offset-4, 4, u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested);

        for (i_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested=0; i_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested < u_octet4_loop_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested; i_org_csapi_cc_mpccs_IpCallLeg_eventReportReq_eventsRequested++) {

            /*  Begin struct "org_csapi_cc_TpCallEventRequest"  */
            decode_org_csapi_cc_TpCallEventRequest_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_TpCallEventRequest"  */
        }

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/release:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_release(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    /* Operation specific Variable declarations Begin */
    guint32   u_octet4;
    /* Operation specific Variable declarations End */

    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_release_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        u_octet4 = get_CDR_enum(tvb,offset,stream_is_big_endian, boundary);
        proto_tree_add_uint(tree, hf_org_csapi_cc_mpccs_IpCallLeg_release_cause, tvb, *offset-4, 4, u_octet4);

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/getInfoReq:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_getInfoReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_getInfoReq_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_getInfoReq_callLegInfoRequested, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/getCall:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_getCall(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_getCall_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /*  Begin struct "org_csapi_cc_mpccs_TpMultiPartyCallIdentifier"  */
            decode_org_csapi_cc_mpccs_TpMultiPartyCallIdentifier_st(tvb, pinfo, tree, item, offset, header, operation, stream_is_big_endian);
            /*  End struct "org_csapi_cc_mpccs_TpMultiPartyCallIdentifier"  */
            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/attachMediaReq:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_attachMediaReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_attachMediaReq_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* switch(header->rep_status) */

        break;
    default:
        /* Unknown GIOP Message */
        expert_add_info_format(pinfo, item, &ei_parlay_unknown_giop_msg, "Unknown GIOP message %d", header->message_type);
        break;
    } /* switch(header->message_type) */
}

/*
 * IDL:org/csapi/cc/mpccs/IpCallLeg/detachMediaReq:1.0
 */
static void
decode_org_csapi_cc_mpccs_IpCallLeg_detachMediaReq(tvbuff_t *tvb _U_, packet_info *pinfo _U_, proto_tree *tree _U_, proto_item *item _U_, int *offset _U_, MessageHeader *header, const gchar *operation _U_, gboolean stream_is_big_endian _U_)
{
    switch(header->message_type) {
    case Request:
        proto_tree_add_int(tree, hf_org_csapi_cc_mpccs_IpCallLeg_detachMediaReq_callLegSessionID, tvb, *offset-4, 4, get_CDR_long(tvb,offset,stream_is_big_endian, boundary));

        break;
    case Reply:
        switch(header->rep_status) {
        case NO_EXCEPTION:
            /* Function returns void */

            break;
        case USER_EXCEPTION:
            break;
        default:
            /* Unknown Exception */
            expert_add_info_format(pinfo, item, &ei_parlay_unknown_exception, "Unknown exception %d", header->rep_status);
            break;
        }   /* 