/*   Copyright 2004 The Apache Software Foundation
 *
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.codehaus.annogen.override.internal;

import org.codehaus.annogen.generate.Annogen;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoContext;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * <p>Base implementation of AnnotationBean.  This serves as a base for
 * classes generated by annogen.  Its main responsibility is to accept
 * 'set value' requests from a AnnoOverrider and transform them into
 * reflective invocations on methods on the extending class.</p>
 *
 * @author Patrick Calahan &lt;email: pcal-at-bea-dot-com&gt;
 */
public /*abstract*/ class AnnoBeanBase implements AnnoBean {

  // ========================================================================
  // Variables

  private AnnoContext mContext = null;

  // ========================================================================
  // AnnoBean implementation

  /**
   * Just try to set the value via reflection.
   */ 
  public boolean setValue(String valueName, Object value)
  {
    assertInited();
    String methodName = Annogen.SETTER_PREFIX + valueName;
    Method[] m = this.getClass().getMethods();
    for(int i=0; i<m.length; i++) {
      //FIXME this is lazy, doing it this way because it's easier than dealing
      //with autoboxing and type narrowing needed for getMethod(name,params).
      if (m[i].getName().equals(methodName)) {
        try {
          m[i].invoke(this, new Object[]{value});
        } catch (IllegalAccessException e) {
          e.printStackTrace();  //FIXME
        } catch (InvocationTargetException e) {
          e.printStackTrace();  //FIXME
        } catch(IllegalArgumentException iae) {
          IllegalArgumentException iae2 =
            new IllegalArgumentException(valueName+" "+value+"  "+
                                         value.getClass());
          iae2.initCause(iae);
          mContext.getLogger().error(iae2);
        }
        return true;
      }
    }
    return false;
  }

  //public Object getValue(String name);

  //public boolean isDefaultValueUsed(String valueName);

  public AnnoBean createNestableBean(Class beanOrAnnoType)
  {
    assertInited();
    try {
      Class c =
        mContext.getAnnobeanClassFor(beanOrAnnoType);
      if (c == null) return null;
      return mContext.createAnnoBeanFor(c);
    } catch (ClassNotFoundException e) {
      mContext.getLogger().verbose(e,this);
      return null;
    }
  }

  public Object getValue(String name) {
    return null;//FIXME
  }

  public boolean isDefaultValueUsed(String valueName) {
    return false; //FIXME
  }

  // ========================================================================
  // java.lang.annotation.Annotation implementation

  public Class annotationType() {
    try {
      return mContext.
          getJsr175ClassForAnnobeanClass(this.getClass());
    } catch(ClassNotFoundException cnfe) {
      mContext.getLogger().error(cnfe);
      return null;
    }
  }

  // ========================================================================
  // Internal use only

  public void init(AnnoContext ctx) {
    if (ctx == null) throw new IllegalArgumentException("null ctx");
    if (mContext != null) throw new IllegalStateException("already inited");
    mContext = ctx;
  }

  // ========================================================================
  // Private methods

  private void assertInited() {
    if (mContext == null) throw new IllegalStateException();
  }
}
