# import public API
from .datatree import DataTree
from .extensions import register_datatree_accessor
from .io import open_datatree
from .mapping import TreeIsomorphismError, map_over_subtree
from .treenode import InvalidTreeError, NotFoundInTreeError

try:
    # NOTE: the `_version.py` file must not be present in the git repository
    #   as it is generated by setuptools at install time
    from ._version import __version__
except ImportError:  # pragma: no cover
    # Local copy or not installed with setuptools
    __version__ = "999"

__all__ = (
    "DataTree",
    "open_datatree",
    "TreeIsomorphismError",
    "InvalidTreeError",
    "NotFoundInTreeError",
    "map_over_subtree",
    "register_datatree_accessor",
    "__version__",
)
